<?php

class ControllerHerbalPayment extends Controller
{
    private $error = [];

    public function index()
    {
        $this->load->language('herbal/payment');
        $this->load->language('herbal/new_herbal');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/payment');
        $this->load->model('sale/order');

        unset($this->session->data['prescription']);
        unset($this->session->data['product']);
        unset($this->session->data['service']);
        unset($this->session->data['acupuncture_list']);
        unset($this->session->data['image']);
        unset($this->session->data['shipping_addres_id']);
        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $this->getList();
    }

    public function getList()
    {
        $this->load->language('herbal/payment');

        $this->document->addStyle('view/stylesheet/payment.css?v=' . time());

        date_default_timezone_set("Asia/Kuala_Lumpur");

        $data['date_types'][] = [
            'text' => 'All',
            'value' => 'all'
        ];
        $data['date_types'][] = [
            'text' => 'Today',
            'value' => 'today'
        ];
        $data['date_types'][] = [
            'text' => 'Yesterdays',
            'value' => 'Yesterday'
        ];
        $data['date_types'][] = [
            'text' => 'This Month',
            'value' => 'month'
        ];
        $data['date_types'][] = [
            'text' => 'Last 7 days',
            'value' => 'Last_7_days'
        ];
        $data['date_types'][] = [
            'text' => 'Last 30 days',
            'value' => 'Last_30_days'
        ];
        $data['date_types'][] = [
            'text' => 'Last 3 Months',
            'value' => 'Last_3_months'
        ];
        $data['date_types'][] = [
            'text' => 'Last 6 Months',
            'value' => 'Last_6_months'
        ];
        $data['date_types'][] = [
            'text' => 'Years To Date(YTD)',
            'value' => 'Years_To_Date(YTD)'
        ];
        $data['date_types'][] = [
            'text' => 'Last 1 Years',
            'value' => 'Last_1_Years'
        ];
        $data['date_types'][] = [
            'text' => 'Last 3 Years',
            'value' => 'Last_3_Years'
        ];
        $data['date_types'][] = [
            'text' => 'Last 5 Years',
            'value' => 'Last_5_Years'
        ];

        $config_date_type = 'today';
			$filter_date_type = isset($this->request->get['filter_date_type']) ? $this->request->get['filter_date_type'] : $config_date_type;
			$data['selected_date_type'] = $filter_date_type;

        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = '';
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = '';
        }

        if(empty($filter_date_from) && empty($filter_date_to) ){
				$date_now = date('Y-m-d');
				switch ($filter_date_type) {
					case 'today':
						$filter_date_from2 = date('Y-m-d');
						$filter_date_to2 = date('Y-m-d');
						break;
					case 'Yesterday':
						$filter_date_from2 = date('Y-m-d',strtotime('-1 days'));
						$filter_date_to2 = date('Y-m-d',strtotime('-1 days'));
						break;
					case 'month':
						$filter_date_from2 = date('Y-m-01');
						$filter_date_to2 = date('Y-m-t');
						break;
					case 'Last_7_days':
						$filter_date_from2 = date('Y-m-d',strtotime('-7 days'));
						$filter_date_to2 = date('Y-m-d');
						break;
					case 'Last_30_days':
						$filter_date_from2 = date('Y-m-d',strtotime('-30 days'));
						$filter_date_to2 = date('Y-m-d');
						break;
					case 'Last_3_months':
						$filter_date_from2 = date('Y-m-d',strtotime('-3 months'));
						$filter_date_to2 = date('Y-m-d');
						break;
					case 'Last_6_months':
						$filter_date_from2 = date('Y-m-d',strtotime('-6 months'));
						$filter_date_to2 = date('Y-m-d');
						break;	
					case 'Years_To_Date(YTD)':
						$filter_date_from2 = date('Y-m-d',strtotime('first day of january this year'));
						$filter_date_to2 = date('Y-m-d',strtotime('last day of december this year'));
						break;
					case 'Last_1_Years':
						$filter_date_from2 = date('Y-m-d',strtotime('-1 years'));
						$filter_date_to2 = date('Y-m-d');
						break;
					case 'Last_3_Years':
						$filter_date_from2 = date('Y-m-d',strtotime('-3 years'));
						$filter_date_to2 = date('Y-m-d');
						break;
					case 'Last_5_Years':
						$filter_date_from2 = date('Y-m-d',strtotime('-5 years'));
						$filter_date_to2 = date('Y-m-d');
						break;
					default:
						$filter_date_from2 =  '1999-01-01';
						$filter_date_to2 = '2999-12-31';
						break;
				}
				$data['selected_date_type'] = $filter_date_type;
			} else{
				$filter_date_from2 = $filter_date_from;
				$filter_date_to2 = $filter_date_to;
			}


			$this->request->get['filter_date_from'] = $filter_date_from;
			$this->request->get['filter_date_to'] = $filter_date_to;

        if (isset($this->request->get['filter_transaction_from'])) {
            $filter_transaction_from = $this->request->get['filter_transaction_from'];
        } else {
            $filter_transaction_from = '';
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $filter_transaction_to = $this->request->get['filter_transaction_to'];
        } else {
            $filter_transaction_to = '';
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $filter_customer_ic = $this->request->get['filter_customer_ic'];
        } else {
            $filter_customer_ic = '';
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $filter_customer_card = $this->request->get['filter_customer_card'];
        } else {
            $filter_customer_card = '';
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $filter_customer_search = $this->request->get['filter_customer_search'];
        } else {
            $filter_customer_search = '';
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $filter_customer_firstname = $this->request->get['filter_customer_firstname'];
        } else {
            $filter_customer_firstname = '';
        }

        if (isset($this->request->get['filter_customer_lastname'])) {
            $filter_customer_lastname = $this->request->get['filter_customer_lastname'];
        } else {
            $filter_customer_lastname = '';
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $filter_payment_status = '17';
        } else {
            $filter_payment_status = '17';
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = '5';
        } else {
            $filter_status = '5';
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor = '';
        }

        if (isset($this->request->get['filter_occupation'])) {
            $filter_occupation = $this->request->get['filter_occupation'];
        } else {
            $filter_occupation = '';
        }

        if (isset($this->request->get['filter_prescription'])) {
            $filter_prescription = $this->request->get['filter_prescription'];
        } else {
            $filter_prescription = '';
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $filter_diagnostic = $this->request->get['filter_diagnostic'];
        } else {
            $filter_diagnostic = '';
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = '';
        }

        if (isset($this->request->get['filter_address'])) {
            $filter_address = $this->request->get['filter_address'];
        } else {
            $filter_address = '';
        }

        if (isset($this->request->get['filter_store_id'])) {
            $filter_store_id = $this->request->get['filter_store_id'];
        } else {
            $filter_store_id = $this->session->data['store_id'];;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'sales_date ,invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = '';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = '';
        }

        if (isset($this->request->get['filter_service_type'])) {
            $filter_service_type = $this->request->get['filter_service_type'];
        } else {
            $filter_service_type = '';
        }

        $url = '';

        

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_lastname'])) {
            $url .= '&filter_customer_lastname=' . urlencode(html_entity_decode($this->request->get['filter_customer_lastname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . urlencode(html_entity_decode($this->request->get['filter_diagnostic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $url .= '&filter_customer_search=' . urlencode(html_entity_decode($this->request->get['filter_customer_search'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_prescription'])) {
            $url .= '&filter_prescription=' . urlencode(html_entity_decode($this->request->get['filter_prescription'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        if (isset($this->request->get['filter_service_type'])) {
            $url .= '&filter_service_type=' . $this->request->get['filter_service_type'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
        );

        $data['add'] = $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
        $data['delete'] = $this->url->link('herbal/new_herbal/delete', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');

        $data['herbals'] = array();

        $filter_data = array(
            'filter_date_from' => $filter_date_from2,
            'filter_date_to' => $filter_date_to2,
            'filter_transaction_from' => $filter_transaction_from,
            'filter_transaction_to' => $filter_transaction_to,
            'filter_customer_ic' => $filter_customer_ic,
            'filter_occupation' => $filter_occupation,
            'filter_diagnostic' => $filter_diagnostic,
            'filter_prescription' => $filter_prescription,
            'filter_telephone' => $filter_telephone,
            'filter_address' => $filter_address,
            'filter_customer_lastname' => $filter_customer_lastname,
            'filter_customer_card' => $filter_customer_card,
            'filter_customer_firstname' => $filter_customer_firstname,
            'filter_payment_status' => $filter_payment_status,
            'filter_store_id' => $filter_store_id, 
            'filter_status' => $filter_status,
            'filter_customer_search' => $filter_customer_search,
            'filter_doctor' => $filter_doctor,
            'filter_gender' => $filter_gender,
            'filter_service_type' => $filter_service_type,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );


        $herbal_total = $this->model_herbal_payment->getTotalHerbal($filter_data);

        $results = $this->model_herbal_payment->getHerbals($filter_data);

        foreach ($results as $result) {
            if ($result['collect_consultation_price'] > 0) {
                $consultation_price = $result['clinicalsale_concultation'] * 1; //$this->model_sale_order->getHerbalTotal($result['clinical_sale_id']);
            } else {
                $consultation_price = $result['clinicalsale_concultation'] + $result['d_gst'];
            }

            $herbal_service_total = $this->model_herbal_payment->getHerbalServiceTotal($result['clinical_sale_id']);

            $date_of_birth = date('m/d/Y', strtotime($result['dob']));
            $birthDate = explode("/", $date_of_birth);
            $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md") ? ((date("Y") - $birthDate[2]) - 1) : (date("Y") - $birthDate[2]));

            switch ($result['herb_service_type']) {
                case 'herbs':
                    $result['herb_service_type'] = $this->language->get('text_herbs');
                    break;
                case 'brewing':
                    $result['herb_service_type'] = $this->language->get('text_brewing');
                    break;
                case 'granule':
                    $result['herb_service_type'] = $this->language->get('text_granule');
                    break;
                default:
            }

            $data['herbals'][] = array(
                'clinical_sale_id' => $result['clinical_sale_id'],
                'sales_date' => date('Y-m-d',strtotime($result['sales_date'])),
                'sales_time' => date('h:i A', strtotime($result['date_added'])),
                'invoice_prefix' => $result['invoice_prefix'],
                'telephone' => $result['telephone'],
                'firstname' => $result['firstname'] . ' ' . $result['lastname'],
                'doctor_name' => $result['doctor_name'],
                'customer_id' => $result['customer_id'],
                'customer_ic' => $result['customer_ic'],
                'customer_card' => $result['customer_card'],
                'order_invoice_prefix' => $result['order_invoice_prefix'],
                'customer_group' => $result['customer_group'],
                'status' => $result['status'],
                'top' => $result['tick_top'],
                'occupation' => $result['occupation'],
                'telephone' => $result['telephone'],
                'diagnostic' => substr($result['diagnostic_text'], 0, -1),
                'service_total_price' =>$this->currency->format($result['service_total_price'], $this->config->get('config_currency')) ,
              
                'herb_service_type' => $result['herb_service_type'],
                'order_status' => $result['order_status'],
                'order_action' => $result['order_action'],
                'order_id' => $result['order_id'],
                'clinicalsale_action' => $result['clinicalsale_action'],
                'clinicalsale_total' => $result['clinicalsale_total'],
                'consultation_price' => sprintf('%.2f', $consultation_price),
                'service_total' => number_format($herbal_service_total, 2),
                'total_d_gst' => $this->currency->format(sprintf('%.2f', $consultation_price + $herbal_service_total + $result['clinicalsale_total']), $this->config->get('config_currency')) ,
                'total_price' =>$this->currency->format((sprintf('%.2f', $consultation_price + $herbal_service_total + $result['clinicalsale_total'])+$result['service_total_price']), $this->config->get('config_currency')),
                'cs_type' => $result['herb_service_type'],
                // 'service_total' => number_format($herbal_service_total, 2),
                // 'total_d_gst' => sprintf('%.2f', $result['total_d_gst'] + $herbal_service_total),
                'create_new' => $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . $url, 'SSL'),
                'edit' => $this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['clinical_sale_id'] . '&condition=waiting' . $url, 'SSL'),
                'pos' => $this->url->link('pos/pos', 'user_token=' . $this->session->data['user_token']  , 'SSL'),
                'info' => $this->url->link('herbal/payment/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['clinical_sale_id'] . $url, 'SSL'),
                'print_prescription_sticker' => $this->url->link('herbal/new_herbal/printPrescriptionSticker', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['clinical_sale_id'] . $url . '&pdf=1', 'SSL'),
                'age' => $age,
                'gender' => $result['gender'],
                'date_modified' => date('Y-m-d h:i A', strtotime($result['date_modified'])),
                'date_added' => date('Y-m-d h:i A', strtotime($result['date_added']))
            );
        }

        $data['add_new'] = $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
        $data['export_excel'] = $this->url->link('herbal/new_herbal/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
        $data['refresh_medical_record'] = 'index.php?route=herbal/new_herbal/getList2&user_token=' . $this->session->data['user_token'] . $url;

        $data['user_token'] = $this->session->data['user_token'];

        $data['user_view'] = $this->user->user_view;

        if ($this->user->user_position == 2 && $this->user->user_view == 0) {
            $data['user_view'] = 0;
        } else {
            $data['user_view'] = 1;
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($filter_date_type)) {
            $url .= '&filter_date_type=' . $filter_date_type;
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $url .= '&filter_customer_search=' . urlencode(html_entity_decode($this->request->get['filter_customer_search'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_lastname'])) {
            $url .= '&filter_customer_lastname=' . urlencode(html_entity_decode($this->request->get['filter_customer_lastname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_address'])) {
            $url .= '&filter_address=' . urlencode(html_entity_decode($this->request->get['filter_address'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_occupation'])) {
            $url .= '&filter_occupation=' . urlencode(html_entity_decode($this->request->get['filter_occupation'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . urlencode(html_entity_decode($this->request->get['filter_diagnostic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_prescription'])) {
            $url .= '&filter_prescription=' . urlencode(html_entity_decode($this->request->get['filter_prescription'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_sales_date'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=cs.sales_date' . $url, 'SSL');
        $data['sort_invoice_prefix'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=cs.invoice_prefix' . $url, 'SSL');
        $data['sort_firstname'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.firstname' . $url, 'SSL');
        $data['sort_customer_ic'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.customer_ic' . $url, 'SSL');
        $data['sort_customer_card'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.customer_card' . $url, 'SSL');
        $data['sort_telephone'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.telephone' . $url, 'SSL');

        $url = '';

        if (isset($filter_date_type)) {
            $url .= '&filter_date_type=' . $filter_date_type;
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $url .= '&filter_customer_search=' . urlencode(html_entity_decode($this->request->get['filter_customer_search'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . urlencode(html_entity_decode($this->request->get['filter_diagnostic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_prescription'])) {
            $url .= '&filter_prescription=' . urlencode(html_entity_decode($this->request->get['filter_prescription'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $herbal_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('herbal/payment', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', 'SSL');

        $data['pagination'] = $pagination->render();
        $data['count'] = $this->config->get('config_limit_admin');
        $data['results'] = sprintf($this->language->get('text_pagination'), ($herbal_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($herbal_total - $this->config->get('config_limit_admin'))) ? $herbal_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $herbal_total, ceil($herbal_total / $this->config->get('config_limit_admin')));

        $data['filter_date_type'] = $filter_date_type;
        $data['filter_date_from'] = $filter_date_from;
        $data['filter_date_to'] = $filter_date_to;
        $data['filter_transaction_from'] = $filter_transaction_from;
        $data['filter_transaction_to'] = $filter_transaction_to;
        $data['filter_customer_ic'] = $filter_customer_ic;
        $data['filter_customer_card'] = $filter_customer_card;
        $data['filter_customer_firstname'] = $filter_customer_firstname;
        $data['filter_payment_status'] = $filter_payment_status;
        $data['filter_status'] = $filter_status;
        $data['filter_doctor'] = $filter_doctor;
        $data['filter_customer_lastname'] = $filter_customer_lastname;
        $data['filter_occupation'] = $filter_occupation;
        $data['filter_address'] = $filter_address;
        $data['filter_prescription'] = $filter_prescription;
        $data['filter_diagnostic'] = $filter_diagnostic;
        $data['filter_telephone'] = $filter_telephone;
        $data['filter_customer_search'] = $filter_customer_search;
        $data['filter_gender'] = $filter_gender;
        $data['filter_service_type'] = $filter_service_type;
        $data['count'] = (($page - 1) * $this->config->get('config_limit_admin'));
        $data['total_pay'] = $pagination->total;

        $data['print_prescription'] = $this->url->link('herbal/new_herbal/printA5', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', 'SSL');
        $data['print_dispensing_list'] = $this->url->link('herbal/new_herbal/printPrescriptionSticker', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', 'SSL');
        $data['print_medical_cert'] = $this->url->link('herbal/new_herbal/medicalCert', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', 'SSL');

        $data['customer_id'] = null;
        $data['herbal_single'] = array();

        if (!empty($this->request->get['customer_id'])) {
            $data['customer_id'] = $this->request->get['customer_id'];
        }
        if ($data['customer_id'] != '') {
            $herbal_single_results = $this->model_herbal_payment->getCustomerbyid($data['customer_id']);

            $data['herbal_single'] = $herbal_single_results;
        }

        $this->load->model('localisation/order_status');

        $order_status_list = array(7, 5, 1, 18);

        foreach ($order_status_list as $order_status) {
            $order_status_data = $this->model_localisation_order_status->getOrderStatus($order_status);

            $data['cs_order_statuses'][] = array(
                'order_status_id' => $order_status_data['order_status_id'],
                'name' => $order_status_data['name']
            );
        }

        $this->load->model('setting/store');
        $data['stores'] = array();

        $sname = $this->config->get('config_name');

        $data['stores'][] = array(
            'store_id' => 0,
            'name' => $sname . $this->language->get('text_default')
        );

        $stores = $this->model_setting_store->getStores();

        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }

        $data['search_types'] = $this->getSearchTypes();

    

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        $data['doctors'] = $this->model_herbal_payment->getDoctors();

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/payment_list', $data));
    }

    public function getSearchTypes(){
        $searchtype = [];
        $searchtype[] = [
           'value' => 'customer_ic',
           'text' => 'IC/Passport'
        ];
        $searchtype[] = [
            'value' => 'contact_number',
            'text' => 'Contact Number'
        ];
        $searchtype[] = [
            'value' => 'member_number',
            'text' => 'Member number'
        ];
        $searchtype[] = [
            'value' => 'customer_name',
            'text' => 'Customer Name'
        ];

        return $searchtype;
    }

    protected function printData($data)
    {
        echo '<pre>';
        print_r($data);
        echo '</pre>';
    }

    public function getInfo() {
        unset($this->session->data['prescription']);
        unset($this->session->data['product']);
        unset($this->session->data['service']);
        unset($this->session->data['acupuncture_list']);
        unset($this->session->data['image']);
        unset($this->session->data['shipping_addres_id']);
        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        $this->load->language('herbal/payment');
        $this->document->addStyle('view/stylesheet/payment.css?v=' . time());
        $this->document->addStyle('view/javascript/magnific/magnific-popup.css');
        $this->document->addScript('view/javascript/magnific/jquery.magnific-popup.min.js');
        

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/payment');

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->library('weight');
        $this->weight = new Weight($this->registry);

        $data['user_token'] = $this->session->data['user_token'];
        $data['error_warning'] = '';
        $data['product_exit'] = '';

        if (isset($this->request->get['herbal_id'])) {
            $data['herbal_id'] = $this->request->get['herbal_id'];
        } else {
            $data['herbal_id'] = 0;
        }

        $herbal_id_info = '';
        $herbal_prescription = '';
        $herbal_peroduct = '';
        $herbal_totals = '';
        $data['total_data'] = '';
        $data['user_id'] = (int) $this->session->data['user_id'];

        $this->load->model('user/user');
        $user_details = $this->model_user_user->getUser((int) $this->session->data['user_id']);

        $data['user_price'] = $user_details['consultationprice'];

        if (isset($this->request->get['herbal_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $herbal_id_info = $this->model_herbal_payment->getHerbal($this->request->get['herbal_id']);
            $herbal_prescription = $this->model_herbal_payment->getHerbalPrescription($this->request->get['herbal_id']);
            $herbal_totals = $this->model_herbal_payment->getHerbalTotals($this->request->get['herbal_id']);
            $herbal_service = $this->model_herbal_payment->getHerbalService($this->request->get['herbal_id']);
            $herbal_image = $this->model_herbal_payment->getImage($this->request->get['herbal_id']);
            $data['herbal_pass_images'] = $this->model_herbal_payment->getHerbalImages($herbal_id_info['customer_id'], $this->request->get['herbal_id']);
            $herbal_service_acupuncture = $this->model_herbal_payment->getHerbalServiceAcupuncture($this->request->get['herbal_id']);
            $service_total = $this->model_herbal_payment->getservicetotal($this->request->get['herbal_id']) ;
            $clinical_total = $this->model_herbal_payment->gettotal($this->request->get['herbal_id']) ;
            $service_item_total =  $this->model_herbal_payment->getserviceitemtotal($this->request->get['herbal_id']) ; 

        }

        $this->load->model('customer/customer');
        if ($herbal_id_info) {

            $data['username'] = $herbal_id_info['doctor_firstname'] . ' ' . $herbal_id_info['doctor_lastname'];
            $data['invoice_prefix'] = $herbal_id_info['invoice_prefix'];
            $data['customer_card'] = $herbal_id_info['customer_card'];
            $data['customer_ic'] = $herbal_id_info['customer_ic'];
            $data['customer_id'] = $herbal_id_info['customer_id'];
            $data['customer_name'] = $herbal_id_info['firstname'] . ' ' . $herbal_id_info['lastname'];
            $data['gender'] = $herbal_id_info['gender'];
            $data['email'] = $herbal_id_info['email'];
            $data['dob'] = $herbal_id_info['dob'];
            $data['telephone'] = $herbal_id_info['telephone'];
            $data['telephone2'] = $herbal_id_info['telephone2'];
            $data['home'] = $herbal_id_info['home'];
            $data['fax'] = $herbal_id_info['fax'];
            $data['status'] = $herbal_id_info['clinicalsale_action'];
            $data['age'] = $this->calculateAge($herbal_id_info['dob']);
            $data['sales_date'] = $herbal_id_info['sales_date'];
            $data['invoice_prefix'] = $herbal_id_info['invoice_prefix'];
            $data['total'] = $this->currency->format($herbal_id_info['total'], $this->config->get('config_currency'));
            $data['total_price'] =$this->currency->format(( $herbal_id_info['total']+$herbal_id_info['service_total_price']), $this->config->get('config_currency'));
            $data['diagnostic'] = $herbal_id_info['diagnostic'];
            $data['doctoradvice'] = $herbal_id_info['doctoradvice'];
            $data['pulse'] = $herbal_id_info['pulse'];
            $data['disease'] = $herbal_id_info['disease'];
            $data['treatment'] = $herbal_id_info['treatment'];
            $data['acupuncture'] = $herbal_id_info['acupuncture'];
            $data['symptom'] = $herbal_id_info['symptom'];

            $data['https_herbal_images'] = HTTPS_HERBAL_IMAGE;
            $data['uploading_img'] = HTTPS_IMAGE . 'uploading.gif';

            $this->load->model('localisation/order_status');
            $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

            if ($herbal_service) {
                foreach ($herbal_service as $services) {
                    $this->cart->setService($services['clinicalservice_id'], $services['staffincharge'], $services['price']);
                } //loop services
            } //end services

            if ($herbal_service_acupuncture) {
                foreach ($herbal_service_acupuncture as $clinicalservice_id => $acupuncture_list) {
                    if (!empty($acupuncture_list)) {
                        foreach ($acupuncture_list as $acupuncture) {
                            $this->cart->setAcupunctureList($clinicalservice_id, $acupuncture['acupuncture_id'], $acupuncture['num_of_acupuncture']);
                        }
                    }
                }
            }

            if($clinical_total){
                foreach($clinical_total as $ct){
                    $data['clinicals'][] = array (
                        'title' => $ct['title'], 
                        'value' => $this->currency->format($ct['value'], $this->config->get('config_currency')),
                    );
                }
            }

            if($service_item_total){
                foreach($service_item_total as $sit){
                    $data['service_item_totals'][] = array(
                        'title' => $sit['title'],
                        'value' => $this->currency->format($sit['value'], $this->config->get('config_currency')),
                    );
                  
                }
            }

            if($service_total){
                foreach ($service_total as $st) {
                    $data['services'][]= array(
                        'service_date' => $st['service_date'],
                        'invoice_prefix' => $st['invoice_prefix'],
                        'doctor_name' => $st['doctor_name'],
                        'servicename' => $st['servicename'],
                        'total' => $this->currency->format($st['total'], $this->config->get('config_currency')),
                        
                    );
               
                }

            }

            if ($herbal_image) {
                foreach ($herbal_image as $image) {
                    $key = rand();
                    $this->cart->addImages($key, $image['category_id'], $image['folder'], $image['remark'], $image['image']);
                } //loop image
            } //end image

            $data['total_data'] = [];
            if ($herbal_totals) {
                foreach ($herbal_totals as $total) {
                    $data['total_data'][] = array(
                        'id' => $total['id'],
                        'code' => $total['code'],
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $this->config->get('config_currency')),
                        'value' => $total['value'],
                    );
                } //end looptotals
            } //end totaldata

            if ($herbal_id_info['order_action'] == '17') {
                $data['enable_edit'] = true;
            } else {
                $data['enable_edit'] = false;
            }
        } else {
            $data['error_warning'] = $this->language->get('error_curupted');
        }

        $url = '';

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        } //url


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, true)
        ); //breadcrumbs
        //html products
        $data['prescription'] = array();
        $data['products'] = array();
        $data['service'] = array();
        $data['images'] = array();
        $data['total_weight'] = array();

        $total_weight = 0;
        $grand_total_weight = 0;

        foreach ($herbal_prescription as $prescription_id => $prescription) {
            $data['prescription'][$prescription_id] = array(
                'key' => $prescription_id,
                'name' => $prescription['name'],
                'id' => $prescription['prescription_id'],
                'discount' => 0
            );
        }

        //     $herbal_peroduct = $this->model_herbal_payment->getHerbalInfoProduct($prescription['clinical_sale_prescription_id']);

        //     foreach ($herbal_peroduct as $product_id => $products) {
        //         $total = $this->currency->format($products['rowtotal'], $this->config->get('config_currency'));
        //         $tax = $this->currency->format($products['t_gst'], $this->config->get('config_currency'));
        //         $subtotal = $this->currency->format($products['t_net_price'], $this->config->get('config_currency'));

        //         $quantity = $products['quantity'];
        //         $times = $products['times'];
        //         $weight = $quantity * $times;

        //         $total_weight += $quantity;
        //         $grand_total_weight += $weight;

        //         if ($products['weight_class_id']) {
        //             $total_weight_format = $this->weight->format($total_weight, $products['weight_class_id']);

        //             $grand_total_weight_format = $this->weight->format($grand_total_weight, $products['weight_class_id']);
        //         }

        //         $data['total_weight'] = array(
        //             array(
        //                 'total_weight_name' => $this->language->get('weight_total_name'),
        //                 'total_weight' => $total_weight_format
        //             ),
        //             array(
        //                 'total_weight_name' => $this->language->get('grand_weight_total_name'),
        //                 'total_weight' => $grand_total_weight_format
        //             )
        //         );

        //         $data['products'][$prescription_id][] = array(
        //             'product_id' => $products['product_id'],
        //             'name' => $products['name'],
        //             'code' => $products['code'],
        //             'quantity' => $products['quantity'],
        //             'times' => $products['times'],
        //             'cook' => $products['cook'],
        //             'taketype' => $products['taketype'],
        //             'day' => $products['day'],
        //             'price' => $products['product_price'],
        //             'discount' => $products['discount'],
        //             'subtotal' => $subtotal,
        //             'total' => $total,
        //             'tax' => $tax,
        //             'tax_class_id' => $products['tax_class_id'],
        //             'weight' => $products['weight'],
        //             'weight_class_id' => $products['weight_class_id'],
        //             'weight_format' => $weight
        //         );
        //     } //end products
        // } //send prescription

        foreach ($this->cart->getService() as $key => $service) {
            $total = $this->currency->format($this->tax->calculate($service['total'], $service['tax_class_id'], $this->config->get('config_tax')), $this->config->get('config_currency'));

            //tax
            $b = $this->tax->calculate($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));
            $tax = $this->currency->format($b - $service['total'], $this->config->get('config_currency'));
            $subtotal = $this->currency->format($service['total'], $this->config->get('config_currency'));


            $data['service'][$key] = array(
                'service_id' => $key,
                'staff_id' => $service['staff_id'],
                'staff_name' => $service['staff_name'],
                'service_name' => $service['service_name'],
                'service_minute' => $service['service_minute'],
                'price' => $service['price'],
                'subtotal' => $subtotal,
                'total' => $total,
                'tax' => $tax,
                'tax_class_id' => $service['tax_class_id']
            );
        } //end service
        // acupuncture list
        foreach ($this->cart->getAcupunctureList() as $clinicalservice_id => $acupuncture_list) {
            foreach ($acupuncture_list as $acupuncture) {
                $acupuncture_id = $acupuncture['acupuncture_id'];

                $acupuncture_name = $this->model_herbal_payment->getAcupunctureNameById($acupuncture_id);

                $data['acupuncture_list'][$clinicalservice_id][] = array(
                    'acupuncture_id' => $acupuncture_id,
                    'acupuncture_name' => $acupuncture_name,
                    'num_of_acupuncture' => $acupuncture['num_of_acupuncture']
                );
            }
        }

        foreach ($this->cart->getImages() as $key => $image) {
            $data['images'][$key] = array(
                'category_id' => $image['category_id'],
                'name' => $image['name'],
                'remark' => $image['remark'],
                'path' => HTTPS_HERBAL_IMAGE . $image['path']
            );
        } //images
        // image for button and pdf
        $herbal_remedies_image = $this->model_herbal_payment->getHerbalRemediesImage($data['herbal_id']);

        if (!empty($herbal_remedies_image)) {
            $data['available_image'] = '1';
        } else {
            $data['available_image'] = '0';
        }

        $data['action'] = $this->url->link('herbal/herbal/addOrder', 'user_token=' . $this->session->data['user_token'] . $url . '&herbal_id=' . $this->request->get['herbal_id'], true);

        $data['cancel'] = $this->url->link('herbal/payment', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['edit_url'] = $this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'], true);
        $data['url_image'] = $this->url->link('herbal/new_herbal/printA5', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1&image=1', true);
        $data['url_image_no'] = $this->url->link('herbal/new_herbal/printA5', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', true);
        $data['print_prescription_stickers'] = $this->url->link('herbal/new_herbal/printPrescriptionStickers', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', true);
        $data['print_mc'] = $this->url->link('herbal/new_herbal/medicalCert', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', true);

        $data['image_link'] = $this->url->link('herbal/herbal/addImages', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/payment_info', $data));
    }

    private function calculateAge($dob) {
        $date_of_birth = date('m/d/Y', strtotime($dob));

        $birthDate = explode("/", $date_of_birth);

        $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md") ? ((date("Y") - $birthDate[2]) - 1) : (date("Y") - $birthDate[2]));

        return $age;
    }

    public function checkpay(){

        $json = array('success' => false);
		
        $clinical_sale_id = (isset($this->request->post['clinical_sale_id'])) ? $this->request->post['clinical_sale_id'] : false;
		// if (isset($this->request->post['clinical_sale_id'])) {
		// 	$clinical_sale_id = $this->request->post['clinical_sale_id'];
		// }
		if($clinical_sale_id){
            $this->load->model('herbal/payment');

            $allclinicaldata = $this->model_herbal_payment->getallclinicaldata($clinical_sale_id);

            if (!empty($allclinicaldata)) {
                $json = array(
                    'success' => true,
                   
                );
            }
        }
    
      
           
        // echo"<pre>";
        // print_r($allclinicaldata);
        // echo"</pre>";

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));

    }
}
