<?php

class ControllerFacilityFacility extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('facility/facility');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('facility/facility');

        $this->createIfNotExist();
        $this->getList();
    }

    public function add()
    {
        $this->load->language('facility/facility');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('facility/facility');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->model_facility_facility->addFacility($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->syncToEtcm();
            $this->response->redirect($this->url->link('facility/facility', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }
        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('facility/facility');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('facility/facility');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_facility_facility->editFacility($this->request->get['facility_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }
            $this->syncToEtcm();
            $this->response->redirect($this->url->link('facility/facility', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function delete()
    {
        $this->load->language('facility/facility');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('facility/facility');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $facility_id) {
                $this->model_facility_facility->deleteFacility($facility_id);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->syncToEtcm();

            $this->response->redirect($this->url->link('facility/facility', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    protected function getList()
    {
        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text'  => $this->language->get('text_home'),
            'href'  => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text'  => $this->language->get('heading_title'),
            'href'  => $this->url->link('facility/facility', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('facility/facility/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link('facility/facility/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['facilities'] = array();

        $filter_data = array(
            'filter_name'   => $filter_name,
            'sort'          => $sort,
            'order'         => $order,
            'start'         => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit'         => $this->config->get('config_limit_admin')
        );

        $facilities_total = $this->model_facility_facility->getTotalFacilities($filter_data);
        $results = $this->model_facility_facility->getFacilities($filter_data);

        foreach ($results as $result) {

            $availability_hour = $this->model_facility_facility->getFacilityhour($result['facility_id']);

            if (!empty($availability_hour)) {
                $working_hours = '';
                $working_hour_arr = array();

                foreach ($availability_hour as $time) {
                    $working_hour_arr[] = $time['day']. ' ' . $time['start_time'] . ' - ' . $time['end_time'];
                }

                // if (!empty($working_hour_arr)) {
                //     $working_hours = implode('<br />', $working_hour_arr);
                // }
            } else {
                $working_hour_arr = '';
                $working_hours = '-';
            }

            $available = $result['available'] == '1' ? $this->language->get('text_all_day') : $this->getAvailableText($result['facility_id']);

            $status = $result['status'] == '1' ? $this->language->get('text_enabled') : $this->language->get('text_disabled');

            $data['facilities'][] = array(
                'facility_id'   => $result['facility_id'],
                'store_id'      => $result['store_id'],
                'store_name'    => $result['store_name'],
                'name'          => $result['name'],
                'availability_status' => $result['available'],
                'availability'  => $working_hour_arr,
                'status'        => $status,
                'edit'          => $this->url->link('facility/facility/edit', 'user_token=' . $this->session->data['user_token'] . '&facility_id=' . $result['facility_id'] . $url, true)
            );

            
        }
        // echo"<pre>";
        // print_r($data['facilities']);
        // echo"</pre>";
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $facilities_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('facility/facility', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($facilities_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($facilities_total - $this->config->get('config_limit_admin'))) ? $facilities_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $facilities_total, ceil($facilities_total / $this->config->get('config_limit_admin')));

        $data['sort']   = $sort;
        $data['order']  = $order;
        $data['filter_name'] = $filter_name;

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('facility/facility_list', $data));
    }

    protected function getForm()
    {
        $data['text_form'] = !isset($this->request->get['facility_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
        $data['days'] = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
        $data['facility_id'] = isset($this->request->get['facility_id']) ? $this->request->get['facility_id'] : '';
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['facility_name'])) {
            $data['error_facility_name'] = $this->error['facility_name'];
        } else {
            $data['error_facility_name'] = '';
        }

        $data['error_start_time'] = isset($this->error['start_time']) ? $this->error['start_time'] : NULL;
        $data['error_end_time'] = isset($this->error['end_time']) ? $this->error['end_time'] : NULL;
        $data['error_day'] = isset($this->error['day']) ? $this->error['day'] : NULL;

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text'  => $this->language->get('text_home'),
            'href'  => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text'  => $this->language->get('heading_title'),
            'href'  => $this->url->link('facility/facility', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['facility_id'])) {
            $data['action'] = $this->url->link('facility/facility/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('facility/facility/edit', 'user_token=' . $this->session->data['user_token'] . '&facility_id=' . $this->request->get['facility_id'] . $url, true);
        }

        $data['cancel'] = $this->url->link('facility/facility', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['facility_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $facility_info = $this->model_facility_facility->getFacility($this->request->get['facility_id']);

            $facility_availabilities = $this->model_facility_facility->getFacilityAvailabilities($this->request->get['facility_id']);
        }

        $data['user_token'] = $this->session->data['user_token'];

        $data['store_id'] = $this->session->data['store_id'];

        foreach ($data['days'] as $day){ 
            // $availability_infos = $this->model_facility_facility->getFacility($data['facility_id'],$day);

            // if(!empty($availability_infos['availability_id'])){
            //     $availability_id = $availability_infos['availability_id'];
            // }else{
            //     $availability_id = '';

            // }

            $facility_availability_times = $this->model_facility_facility->getFacilityAvailability($data['facility_id'],$day);
            $time=[];
			$product_count = 0 ;

            foreach ($facility_availability_times as $facility_availability_time){
                $time[]=[
                    'start_time' => $facility_availability_time['start_time'],
                    'end_time' => $facility_availability_time['end_time'],
                    
                ];
                $product_count++ ;
                $data['product_count']  = $product_count ;
              
            }

            // $availability_services = $this->model_facility_facility->getAvailabilityService($availability_id);
            // $service='';
            // foreach ($availability_services as $availability_service){
            //     $service[]=
            //        $availability_service['service_id']
            //     ;
            // }

            $a[] = [
                'clinical_day' => $day,
                // 'service' => $service,
                'times' => $time,
            ];
            

        }
        // $data['facility_availability_times']=
        //     $a;
        // echo"<pre>";
        // print_r($data['facility_availability_times']);
        // echo"</pre>";
        if (isset($this->request->post['facility_name'])) {
            $data['facility_name'] = $this->request->post['facility_name'];
        } elseif (!empty($facility_info)) {
            $data['facility_name'] = $facility_info['name'];
        } else {
            $data['facility_name'] = '';
        }

        if (isset($this->request->post['facility_status'])) {
            $data['facility_status'] = $this->request->post['facility_status'];
        } elseif (!empty($facility_info)) {
            $data['facility_status'] = $facility_info['status'];
        } else {
            $data['facility_status'] = '1';
        }

        if (isset($this->request->post['facility_available'])) {
            $data['facility_available'] = $this->request->post['facility_available'];
        } elseif (!empty($facility_info)) {
            $data['facility_available'] = $facility_info['available'];
        } else {
            $data['facility_available'] = '1';
        }

        if (isset($this->request->post['facility_availabilities'])) {
            $data['facility_availability_times'] = $this->request->post['facility_availabilities'];
        } else if (!empty($a)) {
            $data['facility_availability_times'] = $a;
        } else {
            $data['facility_availability_times'] = array();
        }

       

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('facility/facility_form', $data));
    }

    private function getAvailableText($facility_id)
    {
        $result = '';
        $availabilities = $this->model_facility_facility->getFacilityAvailabilities($facility_id);
        foreach ($availabilities as $item) {
            $result .= $this->language->get('text_' . strtolower($item['day'])) . " : " . $item['start_time'] . " - " . $item['end_time'] . "<br>";
        }
        $br_position = strrpos($result, "<br>");
        if ($br_position !== false) {
            $result = substr($result, 0, $br_position);
        }

        return $result;
    }

    protected function validateForm()
    {

        // echo"<pre>";

        // // var_dump($this->request->post);
        // print_r($this->request->post);

        // echo"</pre>";

            // die();
        if (!$this->user->hasPermission('modify', 'facility/facility')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ((utf8_strlen($this->request->post['facility_name']) < 1)) {
            $this->error['facility_name'] = $this->language->get('error_facility_name');
        }

        if (!empty($this->request->post['facility_availabilities']) && $this->request->post['facility_available'] == 0) {
            $skip = 0;
            foreach ($this->request->post['facility_availabilities'] as $detail) {

                if($this->request->post['facility_available'] == 0 && empty($detail['check_day'])){
                    $skip ++;
                    // $this->error['warning'] = $this->language->get('error_not_select');
                    continue;

                }

                if(!empty($detail['check_day'])){
               
                if (empty($detail['clinical_day'])) {
                    $this->error['clinical_day']['facility_availabilities'] = $this->language->get('error_day');
                }

                $previous_start_time = null;
                $previous_end_time = null;

                foreach($detail['times'] as $counter => $time){
                
                    if (empty($time['start_time'])) {
                        $this->error['start_time']['facility_availabilities'][$detail['clinical_day']][$counter] = $this->language->get('error_start_time');
                    }
                    if (empty($time['end_time'])) {
                        $this->error['end_time']['facility_availabilities'][$detail['clinical_day']][$counter] = $this->language->get('error_end_time');
                    }

                    if (strtotime($time['start_time']) > strtotime($time['end_time'])) {
                        $this->error['start_time']['facility_availabilities'][$detail['clinical_day']][$counter] = $this->language->get('error_invalid_time');
                        $this->error['end_time']['facility_availabilities'][$detail['clinical_day']][$counter] = $this->language->get('error_invalid_time');
                    }
                    if (($previous_start_time !== null && strtotime($time['start_time']) < $previous_start_time) || ($previous_end_time !== null && strtotime($time['start_time']) < $previous_end_time)) {
                        $this->error['start_time']['facility_availabilities'][$detail['clinical_day']][$counter] = $this->language->get('error_invalid_time');
                    }

                    $start_time=strtotime($time['start_time']);
                    $end_time=strtotime($time['end_time']);

                    
                    $previous_start_time = $start_time;
                    $previous_end_time = $end_time;

                
                }

            }
        }
        if($skip == 7 && $this->request->post['facility_available'] == 0){
            $this->error['warning'] = $this->language->get('error_not_select');

        }


        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }
        // var_dump($this->error);
        // die();
        return !$this->error;
    }

    protected function validateDelete()
    {
        if (!$this->user->hasPermission('modify', 'facility/facility')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    protected function syncToEtcm()
    {

        $db_facilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "facility")->rows;
        $facilities = [];
        foreach ($db_facilities as $facility) {
            $availabilities = [];
            $db_availabilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "facility_availability WHERE facility_id = '" . (int)$facility['facility_id'] . "'")->rows;
            $facilities[] = [
                'facility_id'       => $facility['facility_id'],
                'store_id'          => $facility['store_id'],
                'name'              => $facility['name'],
                'available'         => $facility['available'],
                'status'            => $facility['status'],
                'availabilities'    => $db_availabilities,
            ];
        }
        $post_data = [
            'store_url' => HTTPS_CATALOG,
            'facilities' => $facilities
        ];

        $path = 'etcm/syncing/syncing/update_facilities';
        $result = $this->connectCurl($path, $post_data);
        return $result;
    }

    private function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = 'https://www.etcm.me/index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }

    private function createIfNotExist()
    {
        $facility_exist = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "facility'")->num_rows;
        if (!$facility_exist) {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "facility` (
                `facility_id` int(11) NOT NULL  AUTO_INCREMENT , PRIMARY KEY (`facility_id`),
                `store_id` int(11) NOT NULL,
                `name` varchar(255) NOT NULL,
                `available` int(1) NOT NULL,
                `status` int(1) NOT NULL,
                `added_by` int(11) NOT NULL,
                `date_added` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
                `modified_by` int(11) NOT NULL,
                `date_modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }

        $facility_availability_exist = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "facility_availability'")->num_rows;
        if (!$facility_availability_exist) {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "facility_availability` (
                `id` int(11) NOT NULL  AUTO_INCREMENT , PRIMARY KEY (`id`),
                `facility_id` int(11) NOT NULL,
                `day` varchar(255) NOT NULL,
                `start_time` varchar(255) NOT NULL,
                `end_time` varchar(255) NOT NULL
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }
    }
}
