<?php
class ControllerExtensionModuleTrackingshipmentPro extends Controller { 
 
	private $error = array();
	private $_ext_name = 'trackingshipmentpro';
	private $_ext_title = 'MX2 - Tracking Shipment Pro';
	private $_dev_name = 'Afendio';
	private $_dev_email = 'opencartmy@gmail.com';
	private $_ext_version = '3.0';

	public function install() {
		$this->load->model('trackingshipmentpro/dbcarrier');		
		$this->model_trackingshipmentpro_dbcarrier->InstallTable();
	}
		
	public function uninstall() {
		$this->load->model('trackingshipmentpro/dbcarrier');		
		$this->model_trackingshipmentpro_dbcarrier->UninstallTable();
	}

	public function index() {
		$this->load->language('extension/module/trackingshipmentpro');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('trackingshipmentpro/trackingshipmentpro');
		$this->getList();
	}
	
	public function add() {
		$this->load->language('module/trackingshipmentpro');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('trackingshipmentpro/trackingshipmentpro');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
		 
		    $this->model_trackingshipmentpro_trackingshipmentpro->addCarrier($this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('module/trackingshipmentpro', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}		
		
		$this->getForm();
	}

	public function update() {
		$this->load->language('module/trackingshipmentpro');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('trackingshipmentpro/trackingshipmentpro');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
		 
		    $this->model_trackingshipmentpro_trackingshipmentpro->editCarrier($this->request->get['carrier_id'], $this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('module/trackingshipmentpro', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}		
		
		$this->getForm();
	}

	public function delete() {
		$this->load->language('module/trackingshipmentpro');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('trackingshipmentpro/trackingshipmentpro');
				
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
		 
			foreach ($this->request->post['selected'] as $carrier_id) {
			        $this->model_trackingshipmentpro_trackingshipmentpro->deleteCarrier($carrier_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('module/trackingshipmentpro', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}
		
		$this->getList();
	}

	public function getList() {
	 
	 	if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['add'] = $this->url->link('extension/module/trackingshipmentpro/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('extension/module/trackingshipmentpro/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);	
		$data['carriers'] = array();
		
		$pagelimit = 15;

		$filter_data = array(
			'start' => ($page - 1) * $pagelimit,
			'limit' => $pagelimit
		);

		$carrier_total = $this->model_trackingshipmentpro_trackingshipmentpro->getTotalCarriers();
		$results = $this->model_trackingshipmentpro_trackingshipmentpro->getCarriers($filter_data);
		$this->load->model('tool/image');
					
		foreach ($results as $result) {
		 	if ($result['image'] && file_exists(DIR_IMAGE . $result['image'])) {$image = $this->model_tool_image->resize($result['image'], 110, 30);
			} else {$image = $this->model_tool_image->resize('no_image.jpg', 110, 30);}
			
			$data['carriers'][] = array(
				'carrier_id'     => $result['carrier_id'],
				'name'           => $result['name'],
				'image'          => $image,
				'url'            => $result['url'],
				'displaystatus'  => ($result['displaystatus'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
				'edit'           => $this->url->link('extension/module/trackingshipmentpro/update', 'user_token=' . $this->session->data['user_token'] . '&carrier_id=' . $result['carrier_id'] . $url, true)
			);
		}	
						
    	$data['ext_name'] = $this->_ext_name;
		$data['ext_title'] = $this->_ext_title;
		$data['dev_name'] = $this->_dev_name;
		$data['dev_email'] = $this->_dev_email;
		$data['ext_version'] = $this->_ext_version;	
				
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$url = '';
		$pagelimit = 15;

		$pagination = new Pagination();
		$pagination->total = $carrier_total;
		$pagination->page = $page;
		$pagination->limit = $pagelimit;
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('extension/module/trackingshipmentpro', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($carrier_total) ? (($page - 1) * $pagelimit) + 1 : 0, ((($page - 1) * $pagelimit) > ($carrier_total - $pagelimit)) ? $carrier_total : ((($page - 1) * $pagelimit) + $pagelimit), $carrier_total, ceil($carrier_total / $pagelimit));
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');		
		
		$this->response->setOutput($this->load->view('extension/module/trackingshipmentpro_list', $data));
	}

	public function getForm() {
	 
	    $this->load->language('extension/module/trackingshipmentpro');

		$data['ext_name'] = $this->_ext_name;
		$data['ext_title'] = $this->_ext_title;
		$data['dev_name'] = $this->_dev_name;
		$data['dev_email'] = $this->_dev_email;
		$data['ext_version'] = $this->_ext_version;		
		 
		$data['text_form'] = !isset($this->request->get['carrier_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');   	

		if (isset($this->error['warning'])) {$data['error_warning'] = $this->error['warning'];} 
		    else {$data['error_warning'] = '';}	
				
		if (isset($this->error['name'])) {$data['error_name'] = $this->error['name'];} 
		    else {$data['error_name'] = '';}
		    
		if (isset($this->error['url'])) {$data['error_url'] = $this->error['url'];} 
		    else {$data['error_url'] = '';}
		    
		if (isset($this->error['shipmentinfo'])) {$data['error_shipmentinfo'] = $this->error['shipmentinfo'];} 
		    else {$data['error_shipmentinfo'] = array();}
		
		$url = '';		

		if (!isset($this->request->get['carrier_id'])) {
			$data['action'] = $this->url->link('extension/module/trackingshipmentpro/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('extension/module/trackingshipmentpro/update', 'user_token=' . $this->session->data['user_token'] . '&carrier_id=' . $this->request->get['carrier_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('extension/module/trackingshipmentpro', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['carrier_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$carrier_info = $this->model_trackingshipmentpro_trackingshipmentpro->getCarrier($this->request->get['carrier_id']);}
		
		if (isset($this->request->post['image'])) {$data['image'] = $this->request->post['image'];} 
	        elseif (!empty($carrier_info)) {$data['image'] = $carrier_info['image'];} 
			        else {$data['image'] = '';}

		$this->load->model('tool/image');
		
		if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 110, 30);
		} elseif (!empty($carrier_info) && is_file(DIR_IMAGE . $carrier_info['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($carrier_info['image'], 110, 30);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
				
		$data['user_token'] = $this->session->data['user_token'];
		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();	


		if (isset($this->request->post['shipmentinfo'])) {
			$data['shipmentinfo'] = $this->request->post['shipmentinfo'];
		} elseif (isset($this->request->get['carrier_id'])) {
			$data['shipmentinfo'] = $this->model_trackingshipmentpro_trackingshipmentpro->getShipmentinfo($this->request->get['carrier_id']);
		} else {
			$data['shipmentinfo'] = array();
		}
		
				
		if (isset($this->request->post['name'])) {
      		$data['name'] = $this->request->post['name'];
    	} elseif (!empty($carrier_info)) {
      		$data['name'] = $carrier_info['name'];
    	} else {
      		$data['name'] = '';
    	}
		
		if (isset($this->request->post['url'])) {
      		$data['url'] = $this->request->post['url'];
    	} elseif (!empty($carrier_info)) {
      		$data['url'] = $carrier_info['url'];
    	} else {
      		$data['url'] = '';
    	}
    	
		if (isset($this->request->post['displaystatus'])) {
      		$data['displaystatus'] = $this->request->post['displaystatus'];
    	} elseif (!empty($carrier_info)) {
      		$data['displaystatus'] = $carrier_info['displaystatus'];
    	} else {
      		$data['displaystatus'] = 1;
    	}
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');   
		
		$this->response->setOutput($this->load->view('extension/module/trackingshipmentpro_form', $data)); 
}
  	public function getShipmentinfohistory() {
		$this->load->model('trackingshipmentpro/trackingshipmentpro');		
		$json = array();
		
		if (isset($this->request->post['carrier_id']) && isset($this->request->post['trackingnumber']) && isset($this->request->post['trackingpostcode']) && isset($this->request->post['order_id'])) { 
			
			$carrier_info = $this->model_trackingshipmentpro_trackingshipmentpro->getCarrier($this->request->post['carrier_id']);			
			$find = array('{carriername}','{trackingnumber}','{trackingpostcode}','{trackingurl}');
			
			$replace = array(
				'carriername' 	   => $carrier_info['name'],
				'trackingnumber'   => $this->request->post['trackingnumber'],
				'trackingpostcode' => $this->request->post['trackingpostcode'],
				'trackingurl'      => str_replace("{trackingnumber}", $this->request->post['trackingnumber'], str_replace("{trackingpostcode}", $this->request->post['trackingpostcode'], html_entity_decode($carrier_info['url'], ENT_QUOTES, 'UTF-8')))
			);
			
			$cust_order_lang_id = $this->model_trackingshipmentpro_trackingshipmentpro->getCustOrderLangId($this->request->post['order_id']);
			$shop_default_lang_id = $this->model_trackingshipmentpro_trackingshipmentpro->getShopDefaultLangId();			
			$set_lang_id = $cust_order_lang_id;
			$shipmentinfotemplate = $this->model_trackingshipmentpro_trackingshipmentpro->getShipmentinfo($this->request->post['carrier_id']);
			
			if (!isset($shipmentinfotemplate[$set_lang_id])) {
				$set_lang_id = $shop_default_lang_id;
			}		

			$shipmentinfocomment = $shipmentinfotemplate[$set_lang_id]['shipmentinfo'];			
			$json['shipmentinfotemplate'] = str_replace($find, $replace, $shipmentinfocomment); 
		}		
		$this->response->setOutput(json_encode($json));
	}

	protected function validateForm() {
		
		if (!$this->user->hasPermission('modify', 'module/trackingshipmentpro')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}   	

		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 100)) {
			$this->error['name'] = $this->language->get('error_name');
		}

		if ((utf8_strlen($this->request->post['url']) < 3) || (utf8_strlen($this->request->post['url']) > 1000)) {
			$this->error['url'] = $this->language->get('error_url');
		}
      	
		foreach ($this->request->post['shipmentinfo'] as $language_id => $value) {
			if (utf8_strlen($value['shipmentinfo']) < 3) {
				$this->error['shipmentinfo'][$language_id] = $this->language->get('error_shipmentinfo');
			}
		}
		
		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;		
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'module/trackingshipmentpro')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
         return !$this->error;
	}
}