<?php
class ControllerExtensionModuleMmslogin extends Controller {
	private $error = array();

	public function index() {
		$this->install();
		$this->load->language('extension/module/mmslogin');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');
		$this->document->addStyle('view/stylesheet/mmdashboard/mmsocialadmin.css');
		
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			
			$post_data =  $this->request->post;		

			foreach($post_data as $key => $postdatas){				
			
				$insert_data['module_mmslogin_data'][$key]=$postdatas;				
			} 
			if($this->request->post['module_mmslogin_status']){
			$insert_data['module_mmslogin_status'] = $this->request->post['module_mmslogin_status'];
			}
			$this->model_setting_setting->editSetting('module_mmslogin', $insert_data);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
		}
		
		
		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		 if (isset($this->error['fb_client'])) {
			 $data['error_fb_client'] = $this->error['fb_client'];
		 } else {
			 $data['error_fb_client'] = '';
		 }
		 if (isset($this->error['fb_secret'])) {
			 $data['error_fb_secret'] = $this->error['fb_secret'];
		 } else {
			 $data['error_fb_secret'] = '';
		 }
		 if (isset($this->error['gp_client'])) {
			 $data['error_gp_client'] = $this->error['gp_client'];
		 } else {
			 $data['error_gp_client'] = '';
		 }
		 if (isset($this->error['gp_secret'])) {
			 $data['error_gp_secret'] = $this->error['gp_secret'];
		 } else {
			 $data['error_gp_secret'] = '';
		 }
		 if (isset($this->error['tw_client'])) {
			 $data['error_tw_client'] = $this->error['tw_client'];
		 } else {
			 $data['error_tw_client'] = '';
		 }
		 if (isset($this->error['tw_secret'])) {
			 $data['error_tw_secret'] = $this->error['tw_secret'];
		 } else {
			 $data['error_tw_secret'] = '';
		 }
		 if (isset($this->error['ld_client'])) {
			 $data['error_ld_client'] = $this->error['ld_client'];
		 } else {
			 $data['error_ld_client'] = '';
		 }
		 if (isset($this->error['ld_secret'])) {
			 $data['error_ld_secret'] = $this->error['ld_secret'];
		 } else {
			 $data['error_ld_secret'] = '';
		 }
			

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		if (!isset($this->request->get['module_id'])) {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('extension/module/mmslogin', 'user_token=' . $this->session->data['user_token'], true)
			);
		} else {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('extension/module/mmslogin', 'user_token=' . $this->session->data['user_token'] . '&module_id=' . $this->request->get['module_id'], true)
			);
		}

		if (!isset($this->request->get['module_id'])) {
			$data['action'] = $this->url->link('extension/module/mmslogin', 'user_token=' . $this->session->data['user_token'], true);
		} else {
			$data['action'] = $this->url->link('extension/module/mmslogin', 'user_token=' . $this->session->data['user_token'] . '&module_id=' . $this->request->get['module_id'], true);
		}

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		
		
		if($this->request->server['REQUEST_METHOD'] != 'POST'){
			$module_info = $this->config->get('module_mmslogin_data'); 
		}
		
		// Fetching store catalog address
		if ($this->request->server['HTTPS']) {
			$sitelink = HTTPS_CATALOG;
		} else {
			$sitelink = HTTP_CATALOG;
		}
		
		
		if (isset($this->request->post['title'])) {
			$data['title'] = $this->request->post['title'];
		} elseif(!empty($module_info)) {
			$data['title'] = $module_info['title'];
		}else{
			$data['title'] = array();
		}
		
		if (isset($this->request->post['view'])) {
			$data['view'] = $this->request->post['view'];
		} elseif(!empty($module_info)) {
			$data['view'] = $module_info['view'];
		}else{
			$data['view'] = array();
		}
		
		if (isset($this->request->post['alignment'])) {
			$data['alignment'] = $this->request->post['alignment'];
		} elseif(!empty($module_info)) {
			$data['alignment'] = $module_info['alignment'];
		}else{
			$data['alignment'] = array();
		}
		// facebook
		
		if (isset($this->request->post['fbstatus'])) {
			$data['fbstatus'] = $this->request->post['fbstatus'];
		} elseif(!empty($module_info)) {
			$data['fbstatus'] = $module_info['fbstatus'];
		}else{
			$data['fbstatus'] = "";
		}
		
		if (isset($this->request->post['fbtitle'])) {
			$data['fbtitle'] = $this->request->post['fbtitle'];
		} elseif(!empty($module_info)) {
			$data['fbtitle'] = $module_info['fbtitle'];
		}else{
			$data['fbtitle'] = "";
		}
		
		if (isset($this->request->post['fb_client'])) {
			$data['fb_client'] = $this->request->post['fb_client'];
		} elseif(!empty($module_info)) {
			$data['fb_client'] = $module_info['fb_client'];
		}else{
			$data['fb_client'] = "";
		}
		if (isset($this->request->post['fb_secret'])) {
			$data['fb_secret'] = $this->request->post['fb_secret'];
		} elseif(!empty($module_info)) {
			$data['fb_secret'] = $module_info['fb_secret'];
		}else{
			$data['fb_secret'] = "";
		}
		
			if (isset($this->request->post['imagefb'])) {
			$data['imagefb'] = $this->request->post['imagefb'];
		} elseif(!empty($module_info) && isset($module_info['imagefb'])) {
			$data['imagefb'] = $module_info['imagefb'];
		}else{
			$data['imagefb'] = "";
		}
		
		$this->load->model('tool/image');
		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		if (isset($this->request->post['imagefb']) && is_file(DIR_IMAGE . $this->request->post['imagefb'])) {
			$data['imagefb_thumb'] = $this->model_tool_image->resize($this->request->post['imagefb'], 100, 100);
		} elseif (!empty($module_info) && is_file(DIR_IMAGE . $module_info['imagefb'])) {
			$data['imagefb_thumb'] = $this->model_tool_image->resize($module_info['imagefb'], 100, 100);
		} else {
			$data['imagefb_thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}
				
		// Fetching Redirect Uri
		$fbsitelink = str_replace("http://","https://",$sitelink);
		
		$data['fbredirect']	=	$fbsitelink."index.php?route=mmsocial/facebook";		
											 
		// facebook end
		
		// Google Plus
		
		if (isset($this->request->post['gpstatus'])) {
			$data['gpstatus'] = $this->request->post['gpstatus'];
		} elseif(!empty($module_info)) {
			$data['gpstatus'] = $module_info['gpstatus'];
		}else{
			$data['gpstatus'] = "";
		}
		
		if (isset($this->request->post['gptitle'])) {
			$data['gptitle'] = $this->request->post['gptitle'];
		} elseif(!empty($module_info)) {
			$data['gptitle'] = $module_info['gptitle'];
		}else{
			$data['gptitle'] = "";
		}
		
		if (isset($this->request->post['gp_client'])) {
			$data['gp_client'] = $this->request->post['gp_client'];
		} elseif(!empty($module_info)) {
			$data['gp_client'] = $module_info['gp_client'];
		}else{
			$data['gp_client'] = "";
		}
		if (isset($this->request->post['gp_secret'])) {
			$data['gp_secret'] = $this->request->post['gp_secret'];
		} elseif(!empty($module_info)) {
			$data['gp_secret'] = $module_info['gp_secret'];
		}else{
			$data['gp_secret'] = "";
		}
		
			if (isset($this->request->post['imagegp'])) {
			$data['imagegp'] = $this->request->post['imagegp'];
		} elseif(!empty($module_info) && isset($module_info['imagegp'])) {
			$data['imagegp'] = $module_info['imagegp'];
		}else{
			$data['imagegp'] = "";
		}
		
		$this->load->model('tool/image');
		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		if (isset($this->request->post['imagegp']) && is_file(DIR_IMAGE . $this->request->post['imagegp'])) {
			$data['imagegp_thumb'] = $this->model_tool_image->resize($this->request->post['imagegp'], 100, 100);
		} elseif (!empty($module_info) && is_file(DIR_IMAGE . $module_info['imagegp'])) {
			$data['imagegp_thumb'] = $this->model_tool_image->resize($module_info['imagegp'], 100, 100);
		} else {
			$data['imagegp_thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}
				
		// Fetching Redirect Uri			
		$data['gpredirect']	=	$sitelink."index.php?route=mmsocial/google";		
											 
		// Google Plus end
		
		// Twitter
		
		if (isset($this->request->post['twstatus'])) {
			$data['twstatus'] = $this->request->post['twstatus'];
		} elseif(!empty($module_info)) {
			$data['twstatus'] = $module_info['twstatus'];
		}else{
			$data['twstatus'] = "";
		}
		
		if (isset($this->request->post['twtitle'])) {
			$data['twtitle'] = $this->request->post['twtitle'];
		} elseif(!empty($module_info)) {
			$data['twtitle'] = $module_info['twtitle'];
		}else{
			$data['twtitle'] = "";
		}
		
		if (isset($this->request->post['tw_client'])) {
			$data['tw_client'] = $this->request->post['tw_client'];
		} elseif(!empty($module_info)) {
			$data['tw_client'] = $module_info['tw_client'];
		}else{
			$data['tw_client'] = "";
		}
		if (isset($this->request->post['tw_secret'])) {
			$data['tw_secret'] = $this->request->post['tw_secret'];
		} elseif(!empty($module_info)) {
			$data['tw_secret'] = $module_info['tw_secret'];
		}else{
			$data['tw_secret'] = "";
		}
		
			if (isset($this->request->post['imagetw'])) {
			$data['imagetw'] = $this->request->post['imagetw'];
		} elseif(!empty($module_info) && isset($module_info['imagetw'])) {
			$data['imagetw'] = $module_info['imagetw'];
		}else{
			$data['imagetw'] = "";
		}
		
		$this->load->model('tool/image');
		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		if (isset($this->request->post['imagetw']) && is_file(DIR_IMAGE . $this->request->post['imagetw'])) {
			$data['imagetw_thumb'] = $this->model_tool_image->resize($this->request->post['imagetw'], 100, 100);
		} elseif (!empty($module_info) && is_file(DIR_IMAGE . $module_info['imagetw'])) {
			$data['imagetw_thumb'] = $this->model_tool_image->resize($module_info['imagetw'], 100, 100);
		} else {
			$data['imagetw_thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}
				
		// Fetching Redirect Uri			
		$data['twredirect']	=	$sitelink."index.php?route=mmsocial/twitter";		
											 
		// Twitter end
		
		// linkedin
		
		if (isset($this->request->post['ldstatus'])) {
			$data['ldstatus'] = $this->request->post['ldstatus'];
		} elseif(!empty($module_info)) {
			$data['ldstatus'] = $module_info['ldstatus'];
		}else{
			$data['ldstatus'] = "";
		}
		
		if (isset($this->request->post['ldtitle'])) {
			$data['ldtitle'] = $this->request->post['ldtitle'];
		} elseif(!empty($module_info)) {
			$data['ldtitle'] = $module_info['ldtitle'];
		}else{
			$data['ldtitle'] = "";
		}
		
		if (isset($this->request->post['ld_client'])) {
			$data['ld_client'] = $this->request->post['ld_client'];
		} elseif(!empty($module_info)) {
			$data['ld_client'] = $module_info['ld_client'];
		}else{
			$data['ld_client'] = "";
		}
		if (isset($this->request->post['ld_secret'])) {
			$data['ld_secret'] = $this->request->post['ld_secret'];
		} elseif(!empty($module_info)) {
			$data['ld_secret'] = $module_info['ld_secret'];
		}else{
			$data['ld_secret'] = "";
		}
		
		if (isset($this->request->post['imageld'])) {
			$data['imageld'] = $this->request->post['imageld'];
		} elseif(!empty($module_info) && isset($module_info['imageld'])) {
			$data['imageld'] = $module_info['imageld'];
		}else{
			$data['imageld'] = "";
		}
		
		$this->load->model('tool/image');
		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		if (isset($this->request->post['imageld']) && is_file(DIR_IMAGE . $this->request->post['imageld'])) {
			$data['imageld_thumb'] = $this->model_tool_image->resize($this->request->post['imageld'], 100, 100);
		} elseif (!empty($module_info) && is_file(DIR_IMAGE . $module_info['imageld'])) {
			$data['imageld_thumb'] = $this->model_tool_image->resize($module_info['imageld'], 100, 100);
		} else {
			$data['imageld_thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}
				
		// Fetching Redirect Uri			
		$data['ldredirect']	=	$sitelink."index.php?route=mmsocial/linkedin";		
											 
		// Linkedin end
		
		
		if (isset($this->request->post['module_mmslogin_status'])) {
			$data['module_mmslogin_status'] = $this->request->post['module_mmslogin_status'];
		} elseif(!empty($module_info)) {
			$data['module_mmslogin_status'] = $module_info['module_mmslogin_status'];
		}else{
			$data['module_mmslogin_status'] = "";
		}
		
		if (isset($this->request->post['icon_height'])) {
			$data['icon_height'] = $this->request->post['icon_height'];
		} elseif(!empty($module_info)) {
			$data['icon_height'] = $module_info['icon_height'];
		}else{
			$data['icon_height'] = "";
		}
		
		if (isset($this->request->post['icon_width'])) {
			$data['icon_width'] = $this->request->post['icon_width'];
		} elseif(!empty($module_info)) {
			$data['icon_width'] = $module_info['icon_width'];
		}else{
			$data['icon_width'] = "";
		}
		
		
		if (isset($this->request->post['entry_css'])) {
			$data['custom_css'] = $this->request->post['custom_css'];
		} elseif (!empty($module_info)) {
			$data['custom_css'] = $module_info['custom_css'];
		} else {
			$data['custom_css'] = '';
		}			
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/mmslogin', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/mmslogin')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if ($this->request->post['fbstatus']) {	
		
			if ($this->request->post['fb_client']=="") {
				$this->error['fb_client'] = $this->language->get('error_fb_client');
			}
			if ($this->request->post['fb_secret']=="") {
				$this->error['fb_secret'] = $this->language->get('error_fb_secret');
			}	
			
		}
		if ($this->request->post['gpstatus']) {	
		
			if ($this->request->post['gp_client']=="") {
				$this->error['gp_client'] = $this->language->get('error_gp_client');
			}
			if ($this->request->post['gp_secret']=="") {
				$this->error['gp_secret'] = $this->language->get('error_gp_secret');
			}	
			
		}
		if ($this->request->post['twstatus']) {
			
			if ($this->request->post['tw_client']=="") {
				$this->error['tw_client'] = $this->language->get('error_tw_client');
			}
			if ($this->request->post['tw_secret']=="") {
				$this->error['tw_secret'] = $this->language->get('error_tw_secret');
			}	
			
		}
		if ($this->request->post['ldstatus']) {
		
			if ($this->request->post['ld_client']=="") {
				$this->error['ld_client'] = $this->language->get('error_ld_client');
			}
			if ($this->request->post['ld_secret']=="") {
				$this->error['ld_secret'] = $this->language->get('error_ld_secret');
			}
			
		}
		
		
		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}
		

		return !$this->error;
	}
	
	
	function install(){
       // $this->load->model('mmslogin/mmslogin');
       // $this->model_mmslogin_mmslogin->install();
    }
}
