<?php

class ControllerCommonStats extends Controller {

    public function index() {
        $this->load->language('common/column_left');

        $this->load->model('sale/order');

        $order_total = $this->model_sale_order->getTotalOrders();

        $this->load->model('report/statistics');

        $complete_total = $this->model_report_statistics->getValue('order_complete');

        if ((float) $complete_total && $order_total) {
            $data['complete_status'] = round(($complete_total / $order_total) * 100);
        } else {
            $data['complete_status'] = 0;
        }

        $processing_total = $this->model_report_statistics->getValue('order_processing');

        if ((float) $processing_total && $order_total) {
            $data['processing_status'] = round(($processing_total / $order_total) * 100);
        } else {
            $data['processing_status'] = 0;
        }

        $other_total = $this->model_report_statistics->getValue('order_other');

        if ((float) $other_total && $order_total) {
            $data['other_status'] = round(($other_total / $order_total) * 100);
        } else {
            $data['other_status'] = 0;
        }

        return $this->load->view('common/stats', $data);
    }

}

?>