<?php

class ControllerCommonHeaderNotification extends Controller {

    public function index() {
        $this->load->language('notification/notification');
        $this->load->model('notification/notification');

        $this->notification = new Notification($this->registry);

        $data['text_no_notification'] = $this->language->get('text_no_notification');
        $data['text_show_all'] = $this->language->get('text_show_all');

        $data['notifications'] = [];

        $data['notification_num'] = $this->model_notification_notification->get_total_unread_notification();

        $hide_old_hour = $this->notification->hide_old_time_ago;

        $data['show_time_ago'] = ($this->notification->show_time_ago > 0) ? true : false;

        $notifications = $this->model_notification_notification->get_header_notifications($hide_old_hour);

        if (!empty($notifications)) {
            foreach ($notifications as $notification) {
                $had_read = ($notification['had_read'] > 0) ? true : false;
                $notification_details = $this->notification->get_notification_details($notification['notification_id']);

                $notification_title = !empty($notification_details) ? $notification_details['title'] : '';
                $notification_message = !empty($notification_details) ? $notification_details['message'] : '';
                $notification_url = !empty($notification_details) ? $notification_details['url'] : '';

                $data['notifications'][] = [
                    'notification_id' => $notification['notification_id'],
                    'title' => $notification_title,
                    'message' => $notification_message,
                    'url' => $notification_url,
                    'had_read' => $had_read,
                    'time_ago' => $this->notification->timeAgoSecondsToText($notification['time_ago'])
                ];
            }
        }

        $data['user_token'] = $this->session->data['user_token'];

        $data['all_notification'] = $this->url->link('notification/notification', 'user_token=' . $this->session->data['user_token'], true);

        return $this->load->view('/common/header_notification', $data);
    }

}

?>