<?php

class ControllerCatalogStockReturn extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('catalog/stock_return');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');

        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');

        $this->load->model('catalog/stock_return');

        $this->getList();
    }

    public function add() {
        $this->load->language('catalog/stock_return');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_return');

        if ($this->request->server['REQUEST_METHOD'] == 'POST'){
            $draft = isset($this->request->post['draft'])?true:false;
            $submit = isset($this->request->post['submit'])?true:false;
            $proceed=false;
            if($submit){
                if($this->validateForm()) {
                    $this->model_catalog_stock_return->addStockReturn($this->request->post);
                    $proceed=true;
                }
            }
            if($draft){
                if($this->validateDraftForm()){
                    $this->model_catalog_stock_return->draftStockReturn($this->request->post);
                    $proceed=true;
                }
            }
            if($proceed){
  
                $this->session->data['success'] = $this->language->get('text_success');

                $querystring = '';

                if (isset($this->request->get['sort']))
                    $querystring .= '&sort=' . $this->request->get['sort'];

                if (isset($this->request->get['order']))
                    $querystring .= '&order=' . $this->request->get['order'];

                if (isset($this->request->get['page']))
                    $querystring .= '&page=' . $this->request->get['page'];

                if (isset($this->request->get['filter_doc_no']))
                    $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

                if (isset($this->request->get['filter_add_by']))
                    $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

                if (isset($this->request->get['filter_date_from']))
                    $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

                if (isset($this->request->get['filter_date_to']))
                    $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

                if (isset($this->request->get['filter_store_id']))
                    $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];


                $this->response->redirect($this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
            }
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('catalog/stock_return');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_return');

        if ($this->request->server['REQUEST_METHOD'] == 'POST') {
            $draft = isset($this->request->post['draft'])?true:false;
            $submit = isset($this->request->post['submit'])?true:false;
            $proceed=false;
            if($submit){
                if($this->validateForm()) {
                    $this->model_catalog_stock_return->editStockReturn($this->request->get['stock_return_id'], $this->request->post);
                    $proceed=true;
                }
            }
            if($draft){
                if($this->validateDraftForm()){
                    $this->model_catalog_stock_return->editDraftStockReturn($this->request->get['stock_return_id'], $this->request->post);
                    $proceed=true;
                }
            }
            
            if($proceed){
                $this->session->data['success'] = $this->language->get('text_success');

                $querystring = '';

                if (isset($this->request->get['sort']))
                    $querystring .= '&sort=' . $this->request->get['sort'];

                if (isset($this->request->get['order']))
                    $querystring .= '&order=' . $this->request->get['order'];

                if (isset($this->request->get['page']))
                    $querystring .= '&page=' . $this->request->get['page'];

                if (isset($this->request->get['filter_doc_no']))
                    $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

                if (isset($this->request->get['filter_add_by']))
                    $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

                if (isset($this->request->get['filter_date_from']))
                    $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

                if (isset($this->request->get['filter_batch_date_from']))
                    $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];

                if (isset($this->request->get['filter_date_to']))
                    $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

                if (isset($this->request->get['filter_store_id']))
                    $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];


                $this->response->redirect($this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
            }
        }

        $this->getForm();
    }


    public function filter() {
        $this->load->language('catalog/stock_return');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_return');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';

            if (isset($this->request->post['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->post['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            //post from filter form
            if (isset($this->request->post['filter_doc_no']))
                $querystring .= '&filter_doc_no=' . $this->request->post['filter_doc_no'];

                if (isset($this->request->post['filter_add_by']))
                $querystring .= '&filter_add_by=' . implode(',', $this->request->post['filter_add_by']);

            if (isset($this->request->post['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->post['filter_date_from'];

            if (isset($this->request->post['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->post['filter_date_to'];

            if (isset($this->request->post['filter_status']))
                $querystring .= '&filter_status='  . implode(",", $this->request->post['filter_status']);

            if (isset($this->request->post['filter_store_id'])) {
                $querystring .= '&filter_store_id=' . implode(",", $this->request->post['filter_store_id']);
            }

            if (isset($this->request->post['filter_location_id'])) {
                $querystring .= '&filter_location_id=' . implode(',', $this->request->post['filter_location_id']);
            }

            if (isset($this->request->post['filter_product_id'])) {
                $querystring .= '&filter_product_id=' . $this->request->post['filter_product_id'];
            }

            if (isset($this->request->post['filter_product_name'])) {
                $querystring .= '&filter_product_name=' . $this->request->post['filter_product_name'];
            }

            if (isset($this->request->post['filter_product_code'])) {
                $querystring .= '&filter_product_code=' . $this->request->post['filter_product_code'];
            }

            if (isset($this->request->post['filter_batch_date_to'])) {
                $querystring .= '&filter_batch_date_to=' . $this->request->post['filter_batch_date_to'];
            }

            if (isset($this->request->post['filter_batch_date_from'])) {
                $querystring .= '&filter_batch_date_from=' . $this->request->post['filter_batch_date_from'];
            }

            if (isset($this->request->post['filter_category']))
                $querystring .= '&filter_category='  . implode(",", $this->request->post['filter_category']);

            $this->response->redirect($this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getList();
    }

    public function getList() {

        $filter_doc_no = isset($this->request->get['filter_doc_no']) ? $this->request->get['filter_doc_no'] : NULL;
        $filter_product_name = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : NULL;
        $filter_product_code = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : NULL;
        $filter_status = isset($this->request->get['filter_status']) ? explode(',',$this->request->get['filter_status']) : NULL;
        $filter_category = isset($this->request->get['filter_category']) ? explode(',', $this->request->get['filter_category']) : null;
        $filter_store_id = isset($this->request->get['filter_store_id']) ? explode(',', $this->request->get['filter_store_id']) : NULL;
        $filter_add_by = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : NULL;
        $filter_location_id = isset($this->request->get['filter_location_id']) ? explode(',', $this->request->get['filter_location_id']) : NULL;
        $filter_batch_date_from = isset($this->request->get['filter_batch_date_from']) ? $this->request->get['filter_batch_date_from'] : NULL;
        $filter_batch_date_to = isset($this->request->get['filter_batch_date_to']) ? $this->request->get['filter_batch_date_to'] : NULL;
        $filter_date_from = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : NULL;
        $filter_date_to = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : NULL;
        
        // $filter_store_id = isset($this->request->get['filter_store_id']) ? $this->request->get['filter_store_id'] : $this->session->data['store_id'];

        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'date_modified';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'DESC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $querystring = '';

        if (isset($this->request->get['filter_doc_no']))
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

        if (isset($this->request->get['filter_product_name']))
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_code']))
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];

        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];

            if (isset($this->request->get['filter_category'])) {
                $querystring .= '&filter_category=' . $this->request->get['filter_category'];
            }
    
            if (isset($this->request->get['filter_store_id'])) {
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }

        if (isset($this->request->get['filter_add_by']))
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_location_id']))
            $querystring .= '&filter_location_id=' . $this->request->get['filter_location_id'];

        if (isset($this->request->get['filter_date_from']))
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_batch_date_from']))
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];

        if (isset($this->request->get['filter_batch_date_to']))
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];

        if (isset($this->request->get['filter_date_to']))
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_store_id']))
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];



        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['sort_order'])) {
            $querystring .= '&sort_order=' . $this->request->get['sort_order'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        //**breadcrumbs
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . $querystring, true)
        );

        $data['user_token'] = $this->session->data['user_token'];

        //**
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        //**filter memory
        $data['filter_doc_no_memory'] = isset($this->request->get['filter_doc_no']) ? $this->request->get['filter_doc_no'] : "";
        $data['filter_product_name_memory'] = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : "";
        $data['filter_product_code_memory'] = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : "";
        $data['filter_status_memory'] = isset($this->request->get['filter_status']) ? explode(",",$this->request->get['filter_status']) : array();
        $data['filter_category_memory'] = isset($this->request->get['filter_category']) ? explode(",",$this->request->get['filter_category']) : array();

        $data['filter_store_id_memory'] = isset($this->request->get['filter_store_id']) ? explode(",",$this->request->get['filter_store_id']) : array();
        $data['filter_add_by_memory'] = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : "";
        $data['filter_location_memory'] = isset($this->request->get['filter_location_id']) ? explode(",",$this->request->get['filter_location_id']) : array();
        $data['filter_date_from_memory'] = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : "";
        $data['filter_batch_date_from_memory'] = isset($this->request->get['filter_batch_date_from']) ? $this->request->get['filter_batch_date_from'] : "";
        $data['filter_batch_date_to_memory'] = isset($this->request->get['filter_batch_date_to']) ? $this->request->get['filter_batch_date_to'] : "";
        $data['filter_date_to_memory'] = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : "";

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $querystring = '';

        if (isset($this->request->get['filter_doc_no']))
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

        if (isset($this->request->get['filter_product_name']))
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_code']))
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];

        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];
        
            if (isset($this->request->get['filter_category'])) {
                $querystring .= '&filter_category=' . $this->request->get['filter_category'];
            }
    
            if (isset($this->request->get['filter_store_id'])) {
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }
    

        if (isset($this->request->get['filter_add_by']))
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_location_id'])) 
            $querystring .= '&filter_location_id=' . $this->request->get['filter_location_id'];
            
        if (isset($this->request->get['filter_date_from']))
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_batch_date_from']))
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];

        if (isset($this->request->get['filter_batch_date_to']))
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];

        if (isset($this->request->get['filter_date_to']))
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_store_id']))
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

        if ($order == 'ASC') {
            $querystring .= '&order=DESC';
        } else {
            $querystring .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        $data['sort_doc_no'] = $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . '&sort=doc_no' . $querystring, true);
        $data['sort_add_by'] = $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . '&sort=add_by' . $querystring, true);
        $data['sort_date_added'] = $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $querystring, true);
        $data['sort_doc_type'] = $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . '&sort=doc_type' . $querystring, true);
        $data['sort_product'] = $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . '&sort=product' . $querystring, true);
        $data['sort_qty'] = $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . '&sort=qty' . $querystring, true);
        $data['sort_location'] = $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . '&sort=location' . $querystring, true);
        $data['sort_batch_date'] = $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . '&sort=batch_date' . $querystring, true);
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_doc_no']))
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

        if (isset($this->request->get['filter_product_name']))
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_code']))
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        
        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];

            if (isset($this->request->get['filter_category'])) {
                $querystring .= '&filter_category=' . $this->request->get['filter_category'];
            }
    
            if (isset($this->request->get['filter_store_id'])) {
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }

        if (isset($this->request->get['filter_add_by']))
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_location_id'])) 
            $querystring .= '&filter_location_id=' . $this->request->get['filter_location_id'];

        if (isset($this->request->get['filter_date_from']))
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_batch_date_from']))
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];

        if (isset($this->request->get['filter_batch_date_to']))
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        
        if (isset($this->request->get['filter_date_to']))
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
      
        if (isset($this->request->get['filter_store_id']))
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

        $data['filter'] = $this->url->link('catalog/stock_return/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $data['add'] = $this->url->link('catalog/stock_return/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("catalog/stock_return/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_doc_no' => $filter_doc_no,
            'filter_product_name' => $filter_product_name,
            'filter_product_code' => $filter_product_code,
            'filter_status' => $filter_status,
            'filter_category' => $filter_category,
            'filter_store_id' => $filter_store_id,
            'filter_add_by' => $filter_add_by,
            'filter_location_id' => $filter_location_id,
            'filter_date_from' => $filter_date_from,
            'filter_batch_date_from' => $filter_batch_date_from,
            'filter_batch_date_to' => $filter_batch_date_to,
            'filter_date_to' => $filter_date_to,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['filter_data'] = $filter_data;

        $data['user_view'] = $this->user->user_view;

        $data['staffs'] = $this->model_catalog_stock_return->getStaffs();

        if ($this->user->user_view == 1) {
            $data['locations'] = $this->model_catalog_stock_return->getAllLocations();
        } else {
            $data['locations'] = $this->model_catalog_stock_return->getLocations();
        }

        $data['statuses'] = array();
        $statuses = $this->model_catalog_stock_return->getStatus();


        foreach ($statuses as $status) {
            $data['statuses'][] = array(
                'order_status_id' => $status['order_status_id'],
                'name' => $status['name']
            );
        }

        $data['categories'] = array();
        $categories = $this->model_catalog_stock_return->getCategories();


        foreach ($categories as $category) {
            $data['categories'][] = array(
                'category_id' => $category['category_id'],
                'name' => $category['name']
            );
        }

        $this->load->model('setting/store');
        $data['stores'] = array();

        $sname = $this->config->get('config_name');

        $data['stores'][] = array(
            'store_id' => 0,
            'name' => $sname . $this->language->get('text_default')
        );

        $stores = $this->model_setting_store->getStores();


        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }

        $data['stockReturnList'] = array();

        $stockReturnList = $this->model_catalog_stock_return->getStockReturnList($filter_data);

        foreach ($stockReturnList as $stockReturn) {
            $data['stockReturnList'][] = array(
                'stock_return_id' => $stockReturn['stock_return_id'],
                'product_id' => $stockReturn['product_id'],
                'date_added' => date('d/m/Y', strtotime($stockReturn['date_added'])),
                'doc_no' => $stockReturn['doc_no'],
                'description' => $stockReturn['description'],
                'status' => $stockReturn['status'],
                'add_by' => $stockReturn['add_by'],
                'modified_by' => $stockReturn['modified_by'],
                'product_name' => $stockReturn['product_name'],
                'product_name2' => $stockReturn['product_name2'],
                'doc_type' => $stockReturn['doc_type'],
                'qty' => $stockReturn['qty'],
                'unit' => $stockReturn['unit'],
                'location' => $stockReturn['location'],
                'stock_onhand' => $stockReturn['stock_onhand'],
                'stock_balance' => $stockReturn['stock_balance'],
                'batch_date' => $stockReturn['batch_date'],
                'date_modified' => date('d/m/Y H:iA', strtotime($stockReturn['date_modified'])),
                'sname' => $stockReturn['sname'],
                'product_code' => $stockReturn['product_code'],
                'category' => $stockReturn['category'],
                'info' => $this->url->link('catalog/stock_return/info', 'user_token=' . $this->session->data['user_token'] . '&stock_return_id=' . $stockReturn['stock_return_id'] . $querystring, true),
                'print' => $this->url->link('catalog/stock_return/printForm', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&stock_return_id=' . $stockReturn['stock_return_id'] . $querystring, true),
                'edit' => $this->url->link('catalog/stock_return/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_return_id=' . $stockReturn['stock_return_id'] . $querystring, true),
                'export_excel' => $this->url->link('catalog/stock_return/exportExcel', 'user_token=' . $this->session->data['user_token'] . '&stock_return_id=' . $stockReturn['stock_return_id'], true)
            );
        }

        $total_stock_return = $this->model_catalog_stock_return->totalStockReturn($filter_data);

        $querystring = '';

        if (isset($this->request->get['filter_doc_no']))
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

        if (isset($this->request->get['filter_product_name']))
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_code']))
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];

        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];

        if (isset($this->request->get['filter_add_by']))
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_date_from']))
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_batch_date_from']))
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];

        if (isset($this->request->get['filter_batch_date_to']))
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];

        if (isset($this->request->get['filter_date_to']))
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        $data['barcode_link'] = $this->url->link('catalog/stock_return/printProductStickers', 'user_token=' . $this->session->data['user_token'] . '&type=barcode' . $querystring, true);
        $data['export_all'] = $this->url->link('catalog/stock_return/export_excel_all', 'user_token=' . $this->session->data['user_token'], true);
        $data['export_searched'] = $this->url->link('catalog/stock_return/export_excel_searched', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $pagination = new Pagination();
        $pagination->total = $total_stock_return;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_stock_return) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_stock_return - $this->config->get('config_limit_admin'))) ? $total_stock_return : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_stock_return, ceil($total_stock_return / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/stock_return_list', $data));
    }

    public function exportExcel()
    {
        $this->load->language('catalog/stock_return');
        $this->load->model('catalog/stock_return');

        if (isset($this->request->get['stock_return_id'])) {
            $stock_return_id = $this->request->get['stock_return_id'];

            $sr_info = $this->model_catalog_stock_return->getStockReturn($stock_return_id);

            if (!empty($sr_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $stock_return_item =  $this->model_catalog_stock_return->getStockReturnProduct($stock_return_id);

                $table_collection = array();

                if (!empty($stock_return_item)) {
                    // foreach ($stock_return_item as $product_id => $item) {
                        $action = ($stock_return_item['action'] > 0) ? $this->language->get('text_qty_add') : $this->language->get('text_qty_deduct');

                        $table_collection[] = [
                            'product_id' => $stock_return_item['product_id'],
                            'product_name' => $stock_return_item['product_name'],
                            'product_code' => $stock_return_item['product_code'],
                            'action' => $action,
                            'qty' => $stock_return_item['qty']
                        ];
                    // }
                }

                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                $table[] = array('Doc No : ', $sr_info['doc_no']);
                $table[] = array('Store Name : ', $this->config->get('config_name'));
                $table[] = array('Description : ', $sr_info['description']);
                $table[] = array('Date : ', $sr_info['date_added']);

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_product_id'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_product_code'),
                    $this->language->get('column_product_action'),
                    $this->language->get('column_product_qty')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 7;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_' . $stock_return_item['doc_no'];

                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        }
    }

    public function export_excel_all()
    {
        $this->load->language('catalog/stock_return');
        $this->load->model('catalog/stock_return');


            $return_info = $this->model_catalog_stock_return->getStockReturnItemAll();

            if (!empty($return_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $return_item = $this->model_catalog_stock_return->getStockReturnItemAll();

                $table_collection = array();

                if (!empty($return_item)) {
                    foreach ($return_item as $item) {
                        $table_collection[] = [
                            'stock_return_id' => $item['stock_return_id'],
                            'doc_no' => $item['doc_no'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'sname' => $item['sname']. " (Batch Date: ".$item['batch_date']. ") ",
                            'qty' => $item['qty']. " " .$item['unit'],
                            'status_name' => $item['status_name'],
                            'stock_onhand' => $item['stock_onhand'] . $item['unit'] . " => " . $item['stock_balance'] . $item['unit'],
                            'date_added' => $item['date_added'],
                            'add_by' => $item['add_by']
                        ];
                    }
                }


                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_store'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_stock_movement'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_All';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        
    }

    public function export_excel_searched()
    {
        $this->load->language('catalog/stock_return');
        $this->load->model('catalog/stock_return');

        $filter_doc_no = isset($this->request->get['filter_doc_no']) ? $this->request->get['filter_doc_no'] : NULL;
        $filter_product_name = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : NULL;
        $filter_product_code = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : NULL;
        $filter_status = isset($this->request->get['filter_status']) ? explode(',',$this->request->get['filter_status']) : NULL;
        $filter_category = isset($this->request->get['filter_category']) ? explode(',', $this->request->get['filter_category']) : null;
        $filter_store_id = isset($this->request->get['filter_store_id']) ? explode(',', $this->request->get['filter_store_id']) : NULL;
        $filter_add_by = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : NULL;
        $filter_location_id = isset($this->request->get['filter_location_id']) ? explode(',', $this->request->get['filter_location_id']) : NULL;
        $filter_batch_date_from = isset($this->request->get['filter_batch_date_from']) ? $this->request->get['filter_batch_date_from'] : NULL;
        $filter_batch_date_to = isset($this->request->get['filter_batch_date_to']) ? $this->request->get['filter_batch_date_to'] : NULL;
        $filter_date_from = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : NULL;
        $filter_date_to = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : NULL;
        
        $querystring = '';

        if (isset($this->request->get['filter_doc_no']))
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];

        if (isset($this->request->get['filter_product_name']))
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];

        if (isset($this->request->get['filter_product_code']))
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];

        if (isset($this->request->get['filter_status']))
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];

            if (isset($this->request->get['filter_category'])) {
                $querystring .= '&filter_category=' . $this->request->get['filter_category'];
            }
    
            if (isset($this->request->get['filter_store_id'])) {
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }

        if (isset($this->request->get['filter_add_by']))
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

        if (isset($this->request->get['filter_location_id']))
            $querystring .= '&filter_location_id=' . $this->request->get['filter_location_id'];

        if (isset($this->request->get['filter_date_from']))
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

        if (isset($this->request->get['filter_batch_date_from']))
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];

        if (isset($this->request->get['filter_batch_date_to']))
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];

        if (isset($this->request->get['filter_date_to']))
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

        if (isset($this->request->get['filter_store_id']))
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

            $filter_data = array(
                'filter_doc_no' => $filter_doc_no,
                'filter_product_name' => $filter_product_name,
                'filter_product_code' => $filter_product_code,
                'filter_status' => $filter_status,
                'filter_category' => $filter_category,
                'filter_store_id' => $filter_store_id,
                'filter_add_by' => $filter_add_by,
                'filter_location_id' => $filter_location_id,
                'filter_date_from' => $filter_date_from,
                'filter_batch_date_from' => $filter_batch_date_from,
                'filter_batch_date_to' => $filter_batch_date_to,
                'filter_date_to' => $filter_date_to
            );

            $return_info = $this->model_catalog_stock_return->getStockReturnItemAll();

            if (!empty($return_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $return_item = $this->model_catalog_stock_return->getStockReturnItemSearched($filter_data);

                $table_collection = array();

                if (!empty($return_item)) {
                    foreach ($return_item as $item) {
                        $table_collection[] = [
                            'stock_return_id' => $item['stock_return_id'],
                            'doc_no' => $item['doc_no'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'sname' => $item['sname']. " (Batch Date: ".$item['batch_date']. ") ",
                            'qty' => $item['qty']. " " .$item['unit'],
                            'status_name' => $item['status_name'],
                            'stock_onhand' => $item['stock_onhand'] . $item['unit'] . " => " . $item['stock_balance'] . $item['unit'],
                            'date_added' => $item['date_added'],
                            'add_by' => $item['add_by']
                        ];
                    }
                }


                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_store'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_stock_movement'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_Searched';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        
    }

    public function export_excel_selected()
    {
        $this->load->language('catalog/stock_return');
        $this->load->model('catalog/stock_return');

        if (isset($this->request->get['returns'])) {
            $return_ids = explode(",", $this->request->get['returns']);

            $return_info = $this->model_catalog_stock_return->getStockReturnItemAll();

            if (!empty($return_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $table_collection = array();
                foreach ($return_ids as $return_id) {
                    $return_item = $this->model_catalog_stock_return->getStockReturnItemSelected($return_id);

                if (!empty($return_item)) {
                    foreach ($return_item as $item) {
                        $table_collection[] = [
                            'stock_return_id' => $item['stock_return_id'],
                            'doc_no' => $item['doc_no'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'sname' => $item['sname']. " (Batch Date: ".$item['batch_date']. ") ",
                            'qty' => $item['qty']. " " .$item['unit'],
                            'status_name' => $item['status_name'],
                            'stock_onhand' => $item['stock_onhand'] . $item['unit'] . " => " . $item['stock_balance'] . $item['unit'],
                            'date_added' => $item['date_added'],
                            'add_by' => $item['add_by']
                        ];
                    }
                }
            }

                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_store'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_stock_movement'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_Selected';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        }
    }

    public function info(){
        $this->load->model('catalog/stock_return');

        $stock_return_id = isset($this->request->get['stock_return_id']) ? $this->request->get['stock_return_id'] : 0;

        $stock_return_info = $this->model_catalog_stock_return->getStockReturn($stock_return_id);

        if($stock_return_info){
            $this->load->language('catalog/stock_return');

            $this->document->setTitle($this->language->get('heading_title'));
            $data['heading_title'] = $this->language->get('heading_title');

            $data['party']=$stock_return_info['party'];
            $data['doc_no']=$stock_return_info['doc_no'];
            $data['doc_date']=$stock_return_info['doc_date'];
            $data['product_name']=$stock_return_info['product_name'];
            $data['product_name2']=$stock_return_info['product_name2'];
            $data['product_code']=$stock_return_info['product_code'];
            $data['product_desc']=html_entity_decode($stock_return_info['product_desc'],ENT_QUOTES, 'UTF-8');
            $data['description']=$stock_return_info['description'];
            
            if($stock_return_info['party']=='customer'){
                $this->load->model('customer/customer');
                $customer_info = $this->model_customer_customer->getCustomer($stock_return_info['party_id']);
                $address_info = $this->model_customer_customer->getAddress($customer_info['address_id']);
                
                $add1=$address_info['address_1']!='-'?$address_info['address_1']:null;
                $add2=$address_info['address_2']!='-'?$address_info['address_2']:null;
                $add3=$address_info['address_3']!='-'?$address_info['address_3']:null;
                
                $full_address = !empty($add1)?$add1:null;
                $full_address .= !empty($add1)?"<br>".$add2:$add2;
                $full_address .= !empty($add2)?"<br>".$add3:$add3;
                $full_address .= !empty($add3)?"<br>".$address_info['postcode']:$address_info['postcode'];
                $full_address .= !empty($full_address)?" ".$address_info['zone']:$address_info['zone'];
                $full_address .= !empty($full_address)?"<br>".$address_info['country']:$address_info['country'];
                
                
                
                $data['customer_name'] = $customer_info['firstname']." ".$customer_info['lastname'];
                $data['address'] = $full_address;
                $data['email'] = $customer_info['email'];
                $data['phone'] = $customer_info['telephone'];
                $data['date_purchase'] = $this->model_catalog_stock_return->getProductPurchaseDate('order',$stock_return_info['ref_no']);
            }
            if($stock_return_info['party']=='supplier'){
                $supplier_info = $this->model_catalog_stock_return->getManufacturerInfo($stock_return_info['party_id']);

                $add1=$supplier_info['address_1']!=''?$supplier_info['address_1']:null;
                $add2=$supplier_info['address_2']!=''?$supplier_info['address_2']:null;
                $add3=$supplier_info['address_3']!=''?$supplier_info['address_3']:null;

                $full_address = !empty($add1)?$add1:null;
                $full_address .= !empty($add1)?"<br>".$add2:$add2;
                $full_address .= !empty($add2)?"<br>".$add3:$add3;
                $full_address .= !empty($add3)?"<br>".$supplier_info['postcode']:$supplier_info['postcode'];
                $full_address .= !empty($full_address)?" ".$supplier_info['zone']:$supplier_info['zone'];
                $full_address .= !empty($full_address)?"<br>".$supplier_info['country']:$supplier_info['country'];


                $data['customer_name'] = $supplier_info['name'];
                $data['address'] = $full_address;
                $data['email'] = $supplier_info['email'];
                $data['phone'] = $supplier_info['telephone1'];
                $data['date_purchase'] = $this->model_catalog_stock_return->getProductPurchaseDate('invoice',$stock_return_info['ref_no']);
            }


            //**sitemap
            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'], true)
            );

            //**query string
            $querystring = '';

            if (isset($this->request->get['sort'])) {
                $querystring .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $querystring .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $querystring .= '&page=' . $this->request->get['page'];
            }

            if (isset($this->request->get['filter_doc_no'])) {
                $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
            }

            if (isset($this->request->get['filter_add_by'])) {
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
            }

            if (isset($this->request->get['filter_date_from'])) {
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
            }

            if (isset($this->request->get['filter_date_to'])) {
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
            }

            if (isset($this->request->get['filter_store_id'])) {
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }

            //**urls
            $data['cancel'] = $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('catalog/stock_return_info', $data));
        }
        else{
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    public function printProductStickers()
    {
        $product_ids[] = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : '';
        if (!empty($product_ids)) {
            $this->load->language('catalog/product');
            $this->load->model('catalog/product');
            $data = [];

            $type = !empty($this->request->get['type']) ? $this->request->get['type'] : 'barcode';

            foreach ($product_ids as $id) {
                $product_info = $this->model_catalog_product->getProductByProductID($id);

                if (!empty($product_info)) {
                    $date_stock_in = !empty($product_info['date_stock_in']) ? date('d M Y', strtotime($product_info['date_stock_in'])) : date('d M Y', strtotime('2021-05-20'));
                    $date_expired = !empty($product_info['date_expired']) ? date('d M Y', strtotime($product_info['date_expired'])) : date('d M Y', strtotime('2021-05-20'));
                    $product_weight = !empty($product_info['product_weight_sticker']) ? $product_info['product_weight_sticker'] : '30 KG';

                    if ($type == 'qr_code') {
                        //$qr_code_content = ['code' => $product_info['code'], 'chinese_name' => $product_info['chinese_name'], 'english_name' => $product_info['english_name'], 'date_stock_in' => $date_stock_in, 'date_expired' => $date_expired, 'weight' => $product_weight];

                        //$qr_code_content =  json_encode($qr_code_content, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES, true);
                        $qr_code_content = $product_info['code'];
                        $content = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . $qr_code_content . '&choe=UTF-8';
                    } else {
                        $content = 'https://barcode.tec-it.com/barcode.ashx?data=' . $product_info['code'] . '&amp;code=Code128&amp;multiplebarcodes=false&amp;translate-esc=false&amp;unit=Fit&amp;dpi=96&amp;imagetype=Gif&amp;rotation=0&amp;color=%23000000&amp;bgcolor=%23ffffff&amp;codepage=&amp;qunit=Mm&amp;quiet=0';
                    }

                    //$content = urlencode($content);

                    $data['product_stickers'][] = [
                        'product_id' => $product_info['product_id'],
                        'code'         => $product_info['code'],
                        'model'      => $product_info['model'],
                        'chinese_name' => $product_info['chinese_name'],
                        'english_name' => $product_info['english_name'],
                        //'date_stock_in' => $date_stock_in,
                        //'date_expired' => $date_expired,
                        //'product_weight_sticker' => $product_weight,
                        'link' => $content,
                    ];
                }
            }

            $data['stickers_count'] = !empty($data['product_stickers']) ? count($data['product_stickers']) : 0;

            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';

            $data['text_stickers'] = '';
            if ($type == 'qr_code') {
                $data['sticker_size'] = '100mm 110mm';
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_display_size'] = 'width:60%;';
                $data['text_stickers'] = $this->language->get('text_barcode_sticker');
            } else {
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_size'] = '100mm 80mm';
                $data['$sticker_display_size'] = 'width:50px;height:100px;';
                $data['text_stickers'] = $this->language->get('text_qrcode_sticker');
            }

            //echo '<pre>';
            //print_r($data);
            //echo '</pre>';

            $mpdf = new mPDF('utf-8', 'A4');
            $mpdf->writeHTML($this->load->view('catalog/product_stickers', $data));
            $mpdf->Output($filename, 'I');
        } else {
            echo "<h1>Barcode not found</h1>";
        }
    }

    public function printForm(){
        
        $this->load->model('catalog/stock_return');

        $stock_return_id = isset($this->request->get['stock_return_id']) ? $this->request->get['stock_return_id'] : 0;
        $stock_return_info = $this->model_catalog_stock_return->getStockReturn($stock_return_id);
        if($stock_return_info){
            $this->load->language('catalog/stock_return');

            $data['title']=$stock_return_info['doc_no'];
            $data['party']=$stock_return_info['party'];
            $data['doc_no']=$stock_return_info['doc_no'];
            $data['doc_date']=$stock_return_info['doc_date'];
            $data['doc_type']=$stock_return_info['doc_type'];
            $data['product_name']=$stock_return_info['product_name'];
            $data['product_desc']=html_entity_decode($stock_return_info['product_desc'],ENT_QUOTES, 'UTF-8');
            $data['description']=$stock_return_info['description'];
            
            if($stock_return_info['party']=='customer'){
                $this->load->model('customer/customer');
                $customer_info = $this->model_customer_customer->getCustomer($stock_return_info['party_id']);
                $address_info = $this->model_customer_customer->getAddress($customer_info['address_id']);
                
                $add1=$address_info['address_1']!='-'?$address_info['address_1']:null;
                $add2=$address_info['address_2']!='-'?$address_info['address_2']:null;
                $add3=$address_info['address_3']!='-'?$address_info['address_3']:null;
                
                $full_address = !empty($add1)?$add1:null;
                $full_address .= !empty($add1)?"<br>".$add2:$add2;
                $full_address .= !empty($add2)?"<br>".$add3:$add3;
                $full_address .= !empty($add3)?"<br>".$address_info['postcode']:$address_info['postcode'];
                $full_address .= !empty($full_address)?" ".$address_info['zone']:$address_info['zone'];
                $full_address .= !empty($full_address)?"<br>".$address_info['country']:$address_info['country'];
                
                
                
                $data['customer_name'] = $customer_info['firstname']." ".$customer_info['lastname'];
                $data['address'] = $full_address;
                $data['email'] = $customer_info['email'];
                $data['phone'] = $customer_info['telephone'];
                $data['date_purchase'] = $this->model_catalog_stock_return->getProductPurchaseDate('order',$stock_return_info['ref_no']);
            }
            if($stock_return_info['party']=='supplier'){
                $supplier_info = $this->model_catalog_stock_return->getManufacturerInfo($stock_return_info['party_id']);

                $add1=$supplier_info['address_1']!=''?$supplier_info['address_1']:null;
                $add2=$supplier_info['address_2']!=''?$supplier_info['address_2']:null;
                $add3=$supplier_info['address_3']!=''?$supplier_info['address_3']:null;

                $full_address = !empty($add1)?$add1:null;
                $full_address .= !empty($add1)?"<br>".$add2:$add2;
                $full_address .= !empty($add2)?"<br>".$add3:$add3;
                $full_address .= !empty($add3)?"<br>".$supplier_info['postcode']:$supplier_info['postcode'];
                $full_address .= !empty($full_address)?" ".$supplier_info['zone']:$supplier_info['zone'];
                $full_address .= !empty($full_address)?"<br>".$supplier_info['country']:$supplier_info['country'];


                $data['customer_name'] = $supplier_info['name'];
                $data['address'] = $full_address;
                $data['email'] = $supplier_info['email'];
                $data['phone'] = $supplier_info['telephone1'];
                $data['date_purchase'] = $this->model_catalog_stock_return->getProductPurchaseDate('invoice',$stock_return_info['ref_no']);
            }
            if (isset($this->request->get['pdf'])) {
                $pdf = new PDF();
                $page_size ='a4';
                $pdf_file_name = $stock_return_info['doc_no'] . '.pdf';

                $this->response->setOutput($pdf->pdf($this->load->view('catalog/stock_return_print', $data), $pdf_file_name, $page_size));
            }
            else {
                $this->response->setOutput($this->load->view('catalog/stock_return_print', $data));
            }
        }else{
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    public function getReason(){
        $json = array('success' => false);

        $party = (isset($this->request->post['party'])) ? $this->request->post['party'] : false;

        if($party){
            $this->load->model('catalog/stock_return');
            $reasons = $this->model_catalog_stock_return->getReasons($party);
            $json = array(
                'success' => true,
                'reasons' => $reasons,
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function getProductQty(){
        $json = array('success' => false);

        $doc_id = (isset($this->request->post['doc_id'])) ? $this->request->post['doc_id'] : false;
        $doc_type = (isset($this->request->post['doc_type'])) ? $this->request->post['doc_type'] : false;
        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

        $this->load->model('catalog/stock_return');
        $result = $this->model_catalog_stock_return->getProductQty($doc_type,$doc_id,$product_id);
        if(!empty($result)){
            $json = array(
                'success' => true,
                'qty' => $result['qty'],
                'wcid' => $result['weight_class_id'],
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function getForm() {

        $data['user_token'] = $this->session->data['user_token'];
        
        $store_id = $this->session->data['store_id'];

        //form_data
        if(isset($this->request->get['stock_return_id'])){
            $stock_return_info = $this->model_catalog_stock_return->getStockReturn($this->request->get['stock_return_id']);
            $data["form_memory_doc_no"]=$stock_return_info['doc_no'];
        }
        else{
            $data["form_memory_doc_no"] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_return', 'store' => $store_id));
        }

        if($this->request->server['REQUEST_METHOD'] == 'POST'){
            $data["form_memory_doc_date"] = $this->request->post['doc_date'];
            $data["form_memory_parties"] = $this->request->post['parties'];
            $data["form_memory_customer_name"] = $this->request->post['customer_name'];
            $data["form_memory_customer_id"] = $this->request->post['customer_id'];
            $data["form_memory_supplier_name"] = $this->request->post['supplier_name'];
            $data["form_memory_supplier_id"] = $this->request->post['supplier_id'];
            $data["form_memory_order_no"] = isset($this->request->post['order_no'])?$this->request->post['order_no']:'';
            $data["form_memory_order_id"] = $this->request->post['order_id'];
            $data["form_memory_invoice_no"] = isset($this->request->post['invoice_no'])?$this->request->post['invoice_no']:'';
            $data["form_memory_purchase_invoice_id"] = $this->request->post['purchase_invoice_id'];
            $data["form_memory_product_name"] = $this->request->post['product_name'];
            $data["form_memory_product_id"] = $this->request->post['product_id'];
            $data["form_memory_product_qty"] = $this->request->post['product_qty'];
            $data["form_memory_qty"] = $this->request->post['qty'];
            $data["form_memory_weight_class_id"] = $this->request->post['weight_class_id'];
            $data["form_memory_reason"] = $this->request->post['reason'];
            $data['description'] = $this->request->post['description'];
            $data['form_location_id'] = $this->request->post['location'];
            $data['form_memory_batch_date'] = $this->request->post['batch_date'];
        }
        elseif(!empty($stock_return_info)){
            $data["form_memory_doc_date"] = $stock_return_info['doc_date'];
            $data["form_memory_parties"] = $stock_return_info['party'];
            if($stock_return_info['party']=='customer'){
                $this->load->model('customer/customer');
                $customer_info = $this->model_customer_customer->getCustomer($stock_return_info['party_id']);

                $data["form_memory_customer_name"] = $customer_info['firstname']." ".$customer_info['lastname'];
                $data["form_memory_customer_id"] = $stock_return_info['party_id'];
                $data["form_memory_order_no"] = $stock_return_info['ref_no'];
                $data["form_memory_order_id"] = $this->model_catalog_stock_return->getRefId('order',$stock_return_info['ref_no']);

                $data["form_memory_supplier_name"] = '';
                $data["form_memory_supplier_id"] = '';
                $data["form_memory_invoice_no"] = '';
                $data["form_memory_purchase_invoice_id"] = '';
                $product_qty = $this->model_catalog_stock_return->getProductQty('order',$data["form_memory_order_id"],$stock_return_info['product_id']);
                $data["form_memory_product_qty"] = !empty($product_qty['qty'])?$product_qty['qty']:0;
            }
            elseif($stock_return_info['party']=='supplier'){
                $supplier_info = $this->model_catalog_stock_return->getManufacturerInfo($stock_return_info['party_id']);
                $data["form_memory_customer_name"] = '';
                $data["form_memory_customer_id"] = '';
                $data["form_memory_order_no"] = '';
                $data["form_memory_order_id"] = '';
    
                $data["form_memory_supplier_name"] = $supplier_info['name'];
                $data["form_memory_supplier_id"] = $stock_return_info['party_id'];
                $data["form_memory_invoice_no"] = $stock_return_info['ref_no'];
                $data["form_memory_purchase_invoice_id"] = $this->model_catalog_stock_return->getRefId('invoice',$stock_return_info['ref_no']);
                $product_qty = $this->model_catalog_stock_return->getProductQty('invoice',$data["form_memory_purchase_invoice_id"],$stock_return_info['product_id']);
                $data["form_memory_product_qty"] = !empty($product_qty['qty'])?$product_qty['qty']:0;
            }
            else{
                $data["form_memory_customer_name"] = '';
                $data["form_memory_customer_id"] = '';
                $data["form_memory_order_no"] = '';
                $data["form_memory_order_id"] = '';
    
                $data["form_memory_supplier_name"] = '';
                $data["form_memory_supplier_id"] = '';
                $data["form_memory_invoice_no"] = '';
                $data["form_memory_purchase_invoice_id"] = '';
                $data["form_memory_product_qty"] = '';
            }
            

            $data["form_memory_product_name"] = $stock_return_info['product_name'];
            $data["form_memory_product_id"] = $stock_return_info['product_id'];
            $data["form_memory_qty"] = $stock_return_info['qty'];
            $data["form_memory_weight_class_id"] = $stock_return_info['weight_class_id'];
            $data["form_memory_reason"] = $stock_return_info['reason_id'];
            $data['description'] = $stock_return_info['description'];
            $data['form_location_id'] = $stock_return_info['location_id'];
            $data['form_memory_batch_date'] = ($stock_return_info['batch_date']=='0000-00-00')?'':$stock_return_info['batch_date'];
        }
        else{
            $data["form_memory_doc_date"] = date('Y-m-d');
            $data["form_memory_parties"] = 'customer';
            $data["form_memory_customer_name"] = '';
            $data["form_memory_customer_id"] = '';
            $data["form_memory_supplier_name"] = '';
            $data["form_memory_supplier_id"] = '';
            $data["form_memory_order_no"] = '';
            $data["form_memory_order_id"] = '';
            $data["form_memory_invoice_no"] = '';
            $data["form_memory_purchase_invoice_id"] = '';
            $data["form_memory_product_name"] = '';
            $data["form_memory_product_id"] = '';
            $data["form_memory_product_qty"] = '';
            $data["form_memory_qty"] = '';
            $data["form_memory_weight_class_id"] = '';
            $data["form_memory_reason"] = '';
            $data['description'] = '';
            $data['form_location_id'] = '';
            $data['form_memory_batch_date'] = '';
        }
        
        $data['weight_classes'] = $this->model_catalog_stock_return->getWeightClasses();
        $data['locations'] = $this->model_catalog_stock_return->getLocations();

        //**text
        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_form'] = !(isset($this->request->get['stock_return_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        //**sitemap data
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'], true)
        );

        //**query string
        $querystring = '';

        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        //**urls
        $data['cancel'] = $this->url->link('catalog/stock_return', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        if (isset($this->request->get['stock_return_id']))
            $querystring .= '&stock_return_id=' . $this->request->get['stock_return_id'];

        $action_mode = !(isset($this->request->get['stock_return_id'])) ? 'add' : 'edit';
        $data['action'] = $this->url->link("catalog/stock_return/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);



        $data['stock_return_item'] = isset($this->request->post['stock_return_item']) ? $this->request->post['stock_return_item'] : 0;

        //**error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_product_id'] = isset($this->error['product_id']) ? $this->error['product_id'] : NULL;
        $data['error_product_qty'] = isset($this->error['product_qty']) ? $this->error['product_qty'] : NULL;
        $data['error_description'] = isset($this->error['description']) ? $this->error['description'] : NULL;
        $data['error_customer'] = isset($this->error['customer_id']) ? $this->error['customer_id'] : NULL;
        $data['error_order_no'] = isset($this->error['order_id']) ? $this->error['order_id'] : NULL;
        $data['error_supplier'] = isset($this->error['supplier_id']) ? $this->error['supplier_id'] : NULL;
        $data['error_invoice_no'] = isset($this->error['purchase_invoice_id']) ? $this->error['purchase_invoice_id'] : NULL;

        $data['user_token'] = $this->session->data['user_token'];

        //**load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/stock_return_form', $data));
    }

    protected function validateForm() {

        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_return') && !$this->user->userpermission('modify', 'catalog/stock_return'))
            $this->error['warning'] = $this->language->get('error_permission');

        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        $party = $this->request->post['parties'];

        if($party == 'customer'){
            $customer_id = isset($this->request->post['customer_id']) ? $this->request->post['customer_id'] : false;
            $order_id = isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false;
            if(!$customer_id || $customer_id=='' || $customer_id==0){
                $this->error['customer_id'] = $this->language->get('error_empty_customer');
                ;
            }
            if(!$order_id || $order_id=='' || $order_id==0){
                $this->error['order_id'] = $this->language->get('error_empty_order_no');
                ;
            }
        }
        if($party == 'supplier'){
            $supplier_id = isset($this->request->post['supplier_id']) ? $this->request->post['supplier_id'] : false;
            $purchase_invoice_id = isset($this->request->post['purchase_invoice_id']) ? $this->request->post['purchase_invoice_id'] : false;
            if(!$supplier_id || $supplier_id=='' || $supplier_id==0){
                $this->error['supplier_id'] = $this->language->get('error_empty_supplier');
                ;
            }
            if(!$purchase_invoice_id || $purchase_invoice_id=='' || $purchase_invoice_id==0){
                $this->error['purchase_invoice_id'] = $this->language->get('error_empty_invoice_no');
                ;
            }

        }

        $description = isset($this->request->post['description']) ? $this->request->post['description'] : false;
        $product_id = isset($this->request->post['product_id']) ? $this->request->post['product_id'] : false;
        $qty = isset($this->request->post['qty']) ? $this->request->post['qty'] : false;
        if(!$description || $description==''){
            $this->error['description'] = $this->language->get('error_empty_description');
            ;
        }
        if(!$product_id || $product_id=='' || $product_id==0){
            $this->error['product_id'] = $this->language->get('error_empty_product');
            ;
        }
        if (!is_numeric($qty)) {
            $this->error['product_qty'] = $this->language->get('error_qty');
        } else {
            if ($qty <= 0) {
                $this->error['product_qty'] = $this->language->get('error_qty');
            }
        }
        return !$this->error;
    }

    protected function validateDraftForm() {

        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_return') && !$this->user->userpermission('modify', 'catalog/stock_return'))
            $this->error['warning'] = $this->language->get('error_permission');

        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        $party = $this->request->post['parties'];

        if($party == 'customer'){
            $customer_id = isset($this->request->post['customer_id']) ? $this->request->post['customer_id'] : false;
            $order_id = isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false;
            if(!$customer_id || $customer_id=='' || $customer_id==0){
                $this->error['customer_id'] = $this->language->get('error_empty_customer');
                ;
            }
            if(!$order_id || $order_id=='' || $order_id==0){
                $this->error['order_id'] = $this->language->get('error_empty_order_no');
                ;
            }
        }
        if($party == 'supplier'){
            $supplier_id = isset($this->request->post['supplier_id']) ? $this->request->post['supplier_id'] : false;
            $purchase_invoice_id = isset($this->request->post['purchase_invoice_id']) ? $this->request->post['purchase_invoice_id'] : false;
            if(!$supplier_id || $supplier_id=='' || $supplier_id==0){
                $this->error['supplier_id'] = $this->language->get('error_empty_supplier');
                ;
            }
            if(!$purchase_invoice_id || $purchase_invoice_id=='' || $purchase_invoice_id==0){
                $this->error['purchase_invoice_id'] = $this->language->get('error_empty_invoice_no');
                ;
            }

        }

        $description = isset($this->request->post['description']) ? $this->request->post['description'] : false;
        $product_id = isset($this->request->post['product_id']) ? $this->request->post['product_id'] : false;
        $qty = isset($this->request->post['qty']) ? $this->request->post['qty'] : false;
        if(!$description || $description==''){
            $this->error['description'] = $this->language->get('error_empty_description');
            ;
        }
        if(!$product_id || $product_id=='' || $product_id==0){
            $this->error['product_id'] = $this->language->get('error_empty_product');
            ;
        }
        if (!is_numeric($qty)) {
            $this->error['product_qty'] = $this->language->get('error_qty');
        } else {
            if ($qty <= 0) {
                $this->error['product_qty'] = $this->language->get('error_qty');
            }
        }
        return !$this->error;
    }


    //autocomplete for order no
    public function autocompleteOrder(){
        $json = [];
        if(!empty($this->request->get)){
            $this->load->model('catalog/stock_return');
            //Get the variables
			$doc_no = isset($this->request->get['filter_doc_no']) ? $this->request->get['filter_doc_no'] : '';
			$customer_id = isset($this->request->get['filter_customer_id']) ? $this->request->get['filter_customer_id'] : '';
            $filter = [
                'filter_doc_no' =>$doc_no,
                'filter_customer_id' =>$customer_id,
            ];
            $results = $this->model_catalog_stock_return->getAutocompleteOrders($filter);
            if (!empty($results)) {
                foreach($results as $result){
                    $json[]=[
                        'invoice_prefix'=>strip_tags(html_entity_decode($result['invoice_prefix'], ENT_QUOTES, 'UTF-8')),
                        'order_id'=>$result['order_id']
                    ];
                }
            }
        }
        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    //autocomplete for invoice no
    public function getAutocompletePuchases(){
        $json = [];
        if(!empty($this->request->get)){
            $this->load->model('catalog/stock_return');
            //Get the variables
			$doc_no = isset($this->request->get['filter_doc_no']) ? $this->request->get['filter_doc_no'] : '';
			$supplier_id = isset($this->request->get['filter_manufacturer_id']) ? $this->request->get['filter_manufacturer_id'] : '';
            $filter = [
                'filter_doc_no' =>$doc_no,
                'filter_manufacturer_id' =>$supplier_id,
            ];
            $results = $this->model_catalog_stock_return->getAutocompletePuchases($filter);
            if (!empty($results)) {
                foreach($results as $result){
                    $json[]=[
                        'invoice_prefix'=>strip_tags(html_entity_decode($result['invoice_prefix'], ENT_QUOTES, 'UTF-8')),
                        'purchase_invoice_id'=>$result['purchase_invoice_id']
                    ];
                }
            }
        }
        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }
}
