<?php

class ControllerCatalogStockIssue extends Controller
{
    private $error = [];

    public function index()
    {
        $this->load->language('catalog/stock_issue');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $this->document->setTitle($this->language->get('heading_title'));


        $this->load->model('catalog/stock_issue');

        $this->getList();
    }

    public function add()
    {
        $this->load->language('catalog/stock_issue');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_issue');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_catalog_stock_issue->addStockIssue($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true));
        }

        // echo '<pre>';
        // print_r($this->request->post);
        // echo '</pre>';

        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('catalog/stock_issue');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_issue');
        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_catalog_stock_issue->editStockIssue($this->request->get['stock_issue_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm();
    }

    public function info()
    {
        $this->load->language('catalog/stock_issue');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_issue');



        $this->load->model('catalog/stock_issue');
        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateUpdateDesc()) {
            $this->model_catalog_stock_issue->editStockIssueDetail(
                $this->request->get['stock_issue_id'],
                $this->request->post
            );


            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true));
        }
        if (isset($this->request->get['stock_issue_id'])) {
            $stock_issue_id = $this->request->get['stock_issue_id'];

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true)
            );

            $stock_issue_info = [];
            $stock_issue_info = $this->model_catalog_stock_issue->getStockIssue($stock_issue_id);

            $data['stock_issue_item'] = [];

            if (!empty($stock_issue_info)) {
                $stock_issue_products = $this->model_catalog_stock_issue->getStockIssueProducts($stock_issue_id);

                $data['invoice_prefix'] = $stock_issue_info['invoice_prefix'];
                $data['date_added'] = date('d/m/Y H:iA', strtotime($stock_issue_info['date_added']));
                $data['staff'] = $stock_issue_info['staff'];
                $data['fname'] = $stock_issue_info['fname'];

                if (isset($this->request->post['description'])) {
                    $data['description'] = $this->request->post['description'];
                } elseif (!empty($stock_issue_info['description'])) {
                    $data['description'] = $stock_issue_info['description'];
                } else {
                    $data['description'] = '';
                }



                if (!empty($stock_issue_products)) {
                    foreach ($stock_issue_products as $product) {
                        $data['stock_issue_item'][] = [
                            'stock_adjustment_id' => $product['stock_adjustment_id'],
                            'stock_issue_item_id' => $product['stock_issue_item_id'],
                            'stock_issue_id' => $product['stock_issue_id'],
                            'product_id' => $product['product_id'],
                            'product_name' => $product['product_name'],
                            'product_name2' => $product['product_name2'],
                            'product_code' => $product['code'],
                            'quantity' => $product['quantity'],
                            'category' => $product['category'],
                            'batch_date' => $product['batch_date'],
                            'location' => $product['location'],
                            'unit' => $product['unit'],
                            'fname' => $product['fname'],
                            'sname' => $product['sname'],
                            'stock_onhand' => $product['stock_onhand'],
                            'stock_balance' => $product['stock_balance'],
                            'date_modified' => date('d/m/Y H:iA', strtotime($product['date_modified'])),
                            'modified_by' => $product['modified_by'],
                            'print' => $this->url->link('catalog/stock_issue/printForm', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&stock_issue_id=' . $product['stock_issue_id'], true)
                        ];
                    }
                }
            } else {
                $this->response->redirect($this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true));
            }
        } else {
            $this->response->redirect($this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true));
        }

        $language_arr = ['heading_title', 'button_export_excel', 'button_cancel', 'entry_invoice_prefix', 'entry_date_added', 'entry_staff', 'entry_description', 'column_product_name', 'column_product_code', 'column_product_qty'];

        foreach ($language_arr as $language) {
            $data[$language] = $this->language->get($language);
        }
        $data['barcode_link'] = $this->url->link('catalog/stock_issue/printProductStickers', 'user_token=' . $this->session->data['user_token'] . '&type=barcode' . $this->request->get['stock_issue_id'], true);
        $data['export_excel'] = $this->url->link('catalog/stock_issue/export_excel', 'user_token=' . $this->session->data['user_token'] . '&stock_issue_id=' . $this->request->get['stock_issue_id'], true);
        $data['cancel'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true);

        $data['user_token'] = $this->session->data['user_token'];
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/stock_issue_info', $data));
    }

    public function export_excel_all()
    {
        $this->load->language('catalog/stock_issue');
        $this->load->model('catalog/stock_issue');


            $issue_info = $this->model_catalog_stock_issue->getStockIssueItemAll();

            if (!empty($issue_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $issue_item = $this->model_catalog_stock_issue->getStockIssueItemAll();

                $table_collection = array();

                if (!empty($issue_item)) {
                    foreach ($issue_item as $item) {
                        $table_collection[] = [
                            'stock_issue_id' => $item['stock_issue_id'],
                            'fname' => $item['fname'],
                            'invoice_prefix' => $item['invoice_prefix'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'sname' => $item['sname']. " (Batch Date: ".$item['batch_date']. ") ",
                            'quantity' => $item['quantity']. " " .$item['unit'],
                            'status_name' => $item['status_name'],
                            'stock_onhand' => $item['stock_onhand'] . $item['unit'] . " => " . $item['stock_balance'] . $item['unit'],
                            'date_added' => $item['date_added'],
                            'add_by' => $item['add_by']
                        ];
                    }
                }


                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_customer'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_store'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_stock_movement'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_All';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        
    }

    public function export_excel_searched()
    {
        $this->load->language('catalog/stock_issue');
        $this->load->model('catalog/stock_issue');

        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = null;
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = null;
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $filter_invoice_prefix = $this->request->get['filter_invoice_prefix'];
        } else {
            $filter_invoice_prefix = null;
        }

        if (isset($this->request->get['filter_remark'])) {
            $filter_remark = $this->request->get['filter_remark'];
        } else {
            $filter_remark = null;
        }

        if (isset($this->request->get['filter_store_id'])) {
            $filter_store_id = $this->request->get['filter_store_id'];
        } else {
            $filter_store_id = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = null;
        }

        if (isset($this->request->get['filter_customer_id'])) {
            $filter_customer_id = $this->request->get['filter_customer_id'];
        } else {
            $filter_customer_id = null;
        }

        if (isset($this->request->get['filter_category'])) {
            $filter_category = $this->request->get['filter_category'];
        } else {
            $filter_category = null;
        }

        if (isset($this->request->get['filter_location_id'])) {
            $filter_location_id = $this->request->get['filter_location_id'];
        } else {
            $filter_location_id = null;
        }

        if (isset($this->request->get['filter_product_name'])) {
            $filter_product_name = $this->request->get['filter_product_name'];
        } else {
            $filter_product_name = null;
        }

        if (isset($this->request->get['filter_product_code'])) {
            $filter_product_code = $this->request->get['filter_product_code'];
        } else {
            $filter_product_code = null;
        }


        if (isset($this->request->get['filter_batch_date_from'])) {
            $filter_batch_date_from = $this->request->get['filter_batch_date_from'];
        } else {
            $filter_batch_date_from = null;
        }

        if (isset($this->request->get['filter_batch_date_to'])) {
            $filter_batch_date_to = $this->request->get['filter_batch_date_to'];
        } else {
            $filter_batch_date_to = null;
        }

        if (isset($this->request->get['filter_add_by'])) {
            $filter_add_by = $this->request->get['filter_add_by'];
        } else {
            $filter_add_by = null;
        }

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_customer_id'])) {
            $url .= '&filter_customer_id=' . $this->request->get['filter_customer_id'];
        }

        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }

        if (isset($this->request->get['filter_location_id'])) {
            $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }
        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }
        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }
        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        $filter_data = array(
            'filter_invoice_prefix' => $filter_invoice_prefix,
            'filter_add_by' => $filter_add_by,
            'filter_product_name' => $filter_product_name,
            'filter_product_code' => $filter_product_code,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_batch_date_from' => $filter_batch_date_from,
            'filter_batch_date_to' => $filter_batch_date_to,
            'filter_status' => $filter_status,
            'filter_customer_id' => $filter_customer_id,
            'filter_store_id' => $filter_store_id,
            'filter_location_id' => $filter_location_id,
            'filter_category' => $filter_category,
            'filter_remark' => $filter_remark
        );

            $issue_info = $this->model_catalog_stock_issue->getStockIssueItemAll();

            if (!empty($issue_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $issue_item = $this->model_catalog_stock_issue->getStockIssueItemSearched($filter_data);

                $table_collection = array();

                if (!empty($issue_item)) {
                    foreach ($issue_item as $item) {
                        $table_collection[] = [
                            'stock_issue_id' => $item['stock_issue_id'],
                            'fname' => $item['fname'],
                            'invoice_prefix' => $item['invoice_prefix'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'sname' => $item['sname']. " (Batch Date: ".$item['batch_date']. ") ",
                            'quantity' => $item['quantity']. " " .$item['unit'],
                            'status_name' => $item['status_name'],
                            'stock_onhand' => $item['stock_onhand'] . $item['unit'] . " => " . $item['stock_balance'] . $item['unit'],
                            'date_added' => $item['date_added'],
                            'add_by' => $item['add_by']
                        ];
                    }
                }


                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_customer'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_store'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_stock_movement'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_Searched';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        
    }

    public function export_excel_selected()
    {
        $this->load->language('catalog/stock_issue');
        $this->load->model('catalog/stock_issue');

        if (isset($this->request->get['issues'])) {
            $issue_ids = explode(",", $this->request->get['issues']);

            $issue_info = $this->model_catalog_stock_issue->getStockIssueItemAll();

            if (!empty($issue_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                    $table_collection = array();
                foreach ($issue_ids as $issue_id) {

                $issue_item = $this->model_catalog_stock_issue->getStockIssueItemSelected($issue_id);
                if (!empty($issue_item)) {
                    foreach ($issue_item as $item) {
                        $table_collection[] = [
                            'stock_issue_id' => $item['stock_issue_id'],
                            'fname' => $item['fname'],
                            'invoice_prefix' => $item['invoice_prefix'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'sname' => $item['sname']. " (Batch Date: ".$item['batch_date']. ") ",
                            'quantity' => $item['quantity']. " " .$item['unit'],
                            'status_name' => $item['status_name'],
                            'stock_onhand' => $item['stock_onhand'] . $item['unit'] . " => " . $item['stock_balance'] . $item['unit'],
                            'date_added' => $item['date_added'],
                            'add_by' => $item['add_by']
                        ];
                    }
                }
            }

                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_customer'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_store'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_stock_movement'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_Selected';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        }
    }

    public function export_excel()
    {
        $this->load->language('catalog/stock_issue');
        $this->load->model('catalog/stock_issue');

        if (isset($this->request->get['stock_issue_id'])) {
            $stock_issue_id = $this->request->get['stock_issue_id'];

            $stock_issue_info = $this->model_catalog_stock_issue->getStockIssue($stock_issue_id);

            if (!empty($stock_issue_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $stock_issue_items = $this->model_catalog_stock_issue->getStockIssueProducts($stock_issue_id);

                $table_collection = array();

                if (!empty($stock_issue_items)) {
                    foreach ($stock_issue_items as $item) {
                        $table_collection[] = [
                            'product_id' => $item['product_id'],
                            'product_name' => $item['product_name'],
                            'product_code' => $item['code'],
                            'quantity' => $item['quantity']
                        ];
                    }
                }

                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                $table[] = array('Invoice Prefix : ', $stock_issue_info['invoice_prefix']);
                $table[] = array('Store Name : ', $this->config->get('config_name'));
                $table[] = array('Description : ', $stock_issue_info['description']);
                $table[] = array('Date : ', $stock_issue_info['date_added']);

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_product_id'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_product_code'),
                    $this->language->get('column_product_qty')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 7;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_' . $stock_issue_info['invoice_prefix'];

                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        }
    }

    public function get_product_stock()
    {
        $json = [];

        $this->load->model('catalog/stock_issue');

        if (isset($this->request->post['product_id'])) {
            $product_id = $this->request->post['product_id'];

            $product_stock = $this->model_catalog_stock_issue->getProductStock($product_id);

            if (!empty($product_stock)) {
                $json = [
                    'error' => false,
                    'data' => $product_stock,
                    'message' => 'get product stock data success'
                ];
            } else {
                $json = [
                    'error' => true,
                    'message' => 'cannot get product row data'
                ];
            }
        } else {
            $json = [
                'error' => true,
                'message' => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function add_product()
    {
        $json = [];
        $returned_data = [];

        $this->load->model('catalog/stock_issue');

        if (isset($this->request->post)) {
            $product_id = $this->request->post['product_id'];
            $quantity = $this->request->post['quantity'];
            $weight_class_id = $this->request->post['weight_class_id'];
            $location_id = $this->request->post['location_id'];
            $stock_issue_batch_date = $this->request->post['stock_issue_batch_date'];
            $store_id = $this->session->data['store_id'];


            $product_info = $this->model_catalog_stock_issue->getProduct($product_id);

            if (!empty($product_info)) {

                //get location list based on product_id
                $locationList = $this->model_catalog_stock_issue->getLocationList($product_id);
                reset($locationList);
                $first_location_id = key($locationList);

                //get batchdate list based on product id and location_id
                $batchDateList = $this->model_catalog_stock_issue->getBatchDateList($product_id, $location_id);
                $first_batch_date = reset($batchDateList);


                //get weight class 
                $weightClassList = $this->model_catalog_stock_issue->getWeightClasses($product_id);





                //get onhand_quantity based on product id, location_id and batchdate
                $product_stock = $this->model_catalog_stock_issue->getStockOnhand($product_id, $location_id, $stock_issue_batch_date, $store_id);

                if (!empty($product_stock)) {
                    $returned_data = [
                        'product_id' => $product_info['product_id'],
                        'product_code' => $product_info['code'],
                        'product_name' => $product_info['name'],
                        'quantity' => $quantity,
                        'stock' => $product_stock,
                        'locationList' => $locationList,
                        'weight_class_id' => $weight_class_id,
                        'batchDateList' => $batchDateList,
                        'location_id' => $location_id,
                        'weightClassList' => $weightClassList,
                        'stock_issue_batch_date' => $stock_issue_batch_date,
                        'store_id' => $store_id,
                    ];

                    $json = [
                        'error' => false,
                        'data' => $returned_data,
                        'message' => 'get product data success'
                    ];
                } else {
                    $json = [
                        'error' => true,
                        'message' => 'cannot get product stock data'
                    ];
                }
            } else {
                $json = [
                    'error' => true,
                    'message' => 'cannot get product data'
                ];
            }
        } else {
            $json = [
                'error' => true,
                'message' => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function add_product_by_herbal_remedies()
    {
        $json = [];
        $returned_data = [];

        $this->load->model('catalog/stock_issue');

        $ranges = (isset($this->request->post['ranges'])) ? $this->request->post['ranges'] : array();
        $store_id = $this->session->data['store_id'];

        if ($ranges) {
            $products = $this->model_catalog_stock_issue->getHerbalRemediesItem($ranges);

            if (!empty($products)) {
                foreach ($products as $product) {
                    $product_id = $product['product_id'];
                    $quantity = $product['quantity'];

                    $product_info = $this->model_catalog_stock_issue->getProduct($product_id);

                    if (!empty($product_info)) {
                        //get location list based on product_id
                        $locationList = $this->model_catalog_stock_issue->getLocationList($product_id);
                        reset($locationList);
                        $first_location_id = key($locationList);

                        //get batchdate list based on product id and location_id
                        $batchDateList = $this->model_catalog_stock_issue->getBatchDateList($product_id, $first_location_id);
                        $first_batch_date = reset($batchDateList);

                        //get onhand_quantity based on product id, location_id and batchdate
                        $product_stock = $this->model_catalog_stock_issue->getStockOnhand($product_id, $first_location_id, $first_batch_date,$store_id);
                        
                        if (!empty($product_stock)) {
                            $returned_data[] = [
                                'product_id' => $product_id,
                                'product_code' => $product['code'],
                                'product_name' => $product_info['name'],
                                'quantity' => $quantity,
                                'stock' => $product_stock,
                                'locationList' => $locationList,
                                'batchDateList' => $batchDateList,
                            ];
                        }
                    }
                }

                $json = [
                    'error' => false,
                    'data' => $returned_data,
                    'message' => 'get products data success'
                ];
            } else {
                $json = [
                    'error' => true,
                    'message' => 'no product found'
                ];
            }
        } else {
            $json = [
                'error' => true,
                'message' => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function deductItem()
    {
        $json = array('success' => false);

        $stock_issue_item_id = (isset($this->request->post['stock_issue_item_id'])) ? $this->request->post['stock_issue_item_id'] : false;
        $remark = (isset($this->request->post['remark'])) ? $this->request->post['remark'] : false;

        if ($stock_issue_item_id) {
            $this->load->model('catalog/stock_issue');
            $this->model_catalog_stock_issue->deductItem($stock_issue_item_id, $remark);
            $json = array(
                'success' => true,
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }


    protected function getList() {

        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = '';
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = '';
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $filter_invoice_prefix = $this->request->get['filter_invoice_prefix'];
        } else {
            $filter_invoice_prefix = '';
        }

        if (isset($this->request->get['filter_remark'])) {
            $filter_remark = $this->request->get['filter_remark'];
        } else {
            $filter_remark = '';
        }

        if (isset($this->request->get['filter_store_id'])) {
            $filter_store_id = $this->request->get['filter_store_id'];
        } else {
            $filter_store_id = $this->session->data['store_id'];
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = '';
        }

        if (isset($this->request->get['filter_customer_id'])) {
            $filter_customer_id = $this->request->get['filter_customer_id'];
        } else {
            $filter_customer_id = '';
        }

        if (isset($this->request->get['filter_category'])) {
            $filter_category = $this->request->get['filter_category'];
        } else {
            $filter_category = '';
        }

        if (isset($this->request->get['filter_location_id'])) {
            $filter_location_id = $this->request->get['filter_location_id'];
        } else {
            $filter_location_id = '';
        }

        if (isset($this->request->get['filter_product_name'])) {
            $filter_product_name = $this->request->get['filter_product_name'];
        } else {
            $filter_product_name = '';
        }

        if (isset($this->request->get['filter_product_code'])) {
            $filter_product_code = $this->request->get['filter_product_code'];
        } else {
            $filter_product_code = '';
        }


        if (isset($this->request->get['filter_batch_date_from'])) {
            $filter_batch_date_from = $this->request->get['filter_batch_date_from'];
        } else {
            $filter_batch_date_from = '';
        }

        if (isset($this->request->get['filter_batch_date_to'])) {
            $filter_batch_date_to = $this->request->get['filter_batch_date_to'];
        } else {
            $filter_batch_date_to = '';
        }

        if (isset($this->request->get['filter_add_by'])) {
            $filter_add_by = $this->request->get['filter_add_by'];
        } else {
            $filter_add_by = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'date_modified';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_customer_id'])) {
            $url .= '&filter_customer_id=' . $this->request->get['filter_customer_id'];
        }

        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }

        if (isset($this->request->get['filter_location_id'])) {
            $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }
        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }
        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }
        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $language_arr = ['heading_title', 'button_add', 'text_list', 'entry_customer', 'entry_date_from', 'entry_date_to', 'button_filter', 'entry_add_by', 'entry_invoice_prefix', 'entry_store', 'entry_category', 'entry_location_name', 'text_all_store', 'column_date_added', 'column_action', 'column_invoice_prefix', 'column_add_by', 'text_no_results', 'button_view', 'button_edit', 'button_export_excel', 'column_description'];

        foreach ($language_arr as $language) {
            $data[$language] = $this->language->get($language);
        }

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        


        $data['stock_issues'] = array();

        $filter_data = array(
            'filter_invoice_prefix' => $filter_invoice_prefix,
            'filter_add_by' => $filter_add_by,
            'filter_product_name' => $filter_product_name,
            'filter_product_code' => $filter_product_code,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_batch_date_from' => $filter_batch_date_from,
            'filter_batch_date_to' => $filter_batch_date_to,
            'filter_status' => $filter_status,
            'filter_customer_id' => $filter_customer_id,
            'filter_store_id' => $filter_store_id,
            'filter_location_id' => $filter_location_id,
            'filter_category' => $filter_category,
            'filter_remark' => $filter_remark,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        // $results = $this->model_catalog_stock_issue->getStockIssues($filter_data);
        $total_stock_issues = $this->model_catalog_stock_issue->getTotalStockIssues($filter_data);

        $results = $this->model_catalog_stock_issue->getStockIssues($filter_data);

        // echo '<pre>';
        // print_r($results);
        // echo '</pre>';

        if (!empty($results)) {
            foreach ($results as $result) {
                if ($result['status'] == '1') {
                    $label = 'warning';
                } else {
                    $label = 'success';
                }

                $data['stock_issues'][] = [
                    'product_id' => $result['product_id'],
                    'stock_issue_id' => $result['stock_issue_id'],
                    'stock_issue_item_id' => $result['stock_issue_item_id'],
                    'invoice_prefix' => $result['invoice_prefix'],
                    'product_name' => $result['product_name'],
                    'product_code' => $result['product_code'],
                    'category' => $result['category'],
                    'date_added' => date('Y-m-d', strtotime($result['date_added'])),
                    'store_name' => $result['store_name'],
                    'batch_date' => $result['batch_date'],
                    'description' => nl2br($result['description']),
                    'status' => $result['status'],
                    'status_name' => $result['status_name'],
                    'customer_id' => $result['customer_id'],
                    'fname' => $result['fname'],
                    'status_label' => $label,
                    'location' => $result['location'],
                    'location_id' => $result['location_id'],
                    'stock_onhand' => $result['onhand'],
                    'stock_balance' => $result['balance'],
                    'quantity' => $result['quantity'],
                    'unit' => $result['unit'],
                    'remark' => $result['remark'],
                    'add_by' => $result['add_by'],
                    'store_id' => $result['store_id'],
                    'stock_adjustment_id' => $result['stock_adjustment_id'],
                    'date_modified' => date('d/m/Y H:iA', strtotime($result['date_modified'])),
                    'modified_by' => $result['modified_by'],
                    'edit' => $this->url->link('catalog/stock_issue/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_issue_id=' . $result['stock_issue_id'], true),
                    'info' => $this->url->link('catalog/stock_issue/info', 'user_token=' . $this->session->data['user_token'] . '&stock_issue_id=' . $result['stock_issue_id'], true),
                    'export' => $this->url->link('catalog/stock_issue/export_excel', 'user_token=' . $this->session->data['user_token'] . '&stock_issue_id=' . $result['stock_issue_id'], true),
                    'print' => $this->url->link('catalog/stock_issue/printForm', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&stock_issue_id=' . $result['stock_issue_id'], true)
                ];
            }
        }


        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_customer_id'])) {
            $url .= '&fitler_customer_id' . $this->request->get['filter_customer_id'];
        }

        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }

        if (isset($this->request->get['filter_location_id'])) {
            $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }
        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }
        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }
        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        // sort
        $data['sort_date_added'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=date_added', true);
        $data['sort_invoice_prefix'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=invoice_prefix', true);
        $data['sort_product_name'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=product_name', true);
        $data['sort_product_code'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=product_code', true);
        $data['sort_add_by'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=add_by', true);
        $data['sort_description'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=description', true);
        $data['sort_location'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=location', true);
        $data['sort_quantity'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=quantity', true);
        $data['sort_batch_date'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=batch_date', true);
        $data['sort_remark'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=remark', true);
        $data['sort_category'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=category', true);
        $data['sort_status'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=status', true);
        $data['sort_customer_id'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=customer_id', true);

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_customer_id'])) {
            $url .= '&filter_customer_id=' . $this->request->get['filter_customer_id'];
        }

        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }

        if (isset($this->request->get['filter_location_id'])) {
            $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }
        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }
        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }
        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $data['user_token'] = $this->session->data['user_token'];
        $data['user_view'] = $this->user->user_view;

        $this->load->model('setting/store');
        $data['stores'] = array();

        $sname = $this->config->get('config_name');

        $data['stores'][] = array(
            'store_id' => 0,
            'name' => $sname . $this->language->get('text_default')
        );

        // $data['stores'][] = array(
        //     'store_id' => 0,
        //     'name' => $sname . $this->language->get('text_default')
        // );

        $data['staffs'] = $this->model_catalog_stock_issue->getStaffs();
        $stores = $this->model_setting_store->getStores();

        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }

        $data['categories'] = array();
        $categories = $this->model_catalog_stock_issue->getCategories();


        foreach ($categories as $category) {
            $data['categories'][] = array(
                'category_id' => $category['category_id'],
                'name' => $category['name']
            );
        }

        $data['statuses'] = array();
        $statuses = $this->model_catalog_stock_issue->getStatus();


        foreach ($statuses as $status) {
            $data['statuses'][] = array(
                'order_status_id' => $status['order_status_id'],
                'name' => $status['name']
            );
        }

        $data['customers'] = array();
        $customers = $this->model_catalog_stock_issue->getCustomers();


        foreach ($customers as $customer) {
            $data['customers'][] = array(
                'customer_id' => $customer['customer_id'],
                'firstname' => $customer['firstname'] . ' ' . $customer['lastname']
            );
        }


        if ($this->user->user_view == 1) {
            $data['locations'] = $this->model_catalog_stock_issue->getAllLocations();
        } else {
            $data['locations'] = $this->model_catalog_stock_issue->getLocations();
        }

        $data['add'] = $this->url->link('catalog/stock_issue/add', 'user_token=' . $this->session->data['user_token'], true);
        $data['barcode_link'] = $this->url->link('catalog/stock_issue/printProductStickers', 'user_token=' . $this->session->data['user_token'] . '&type=barcode' . $url, true);
        $data['export_all'] = $this->url->link('catalog/stock_issue/export_excel_all', 'user_token=' . $this->session->data['user_token'], true);
        $data['export_search'] = $this->url->link('catalog/stock_issue/export_excel_searched', 'user_token=' . $this->session->data['user_token'] . $url, true);
                
        $pagination = new Pagination();
        $pagination->total = $total_stock_issues;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_stock_issues) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_stock_issues - $this->config->get('config_limit_admin'))) ? $total_stock_issues : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_stock_issues, ceil($total_stock_issues / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        //**filter memory
        $data['filter_date_from'] = $filter_date_from;
        $data['filter_date_to'] = $filter_date_to;
        $data['filter_invoice_prefix'] =  $filter_invoice_prefix;
        $data['filter_remark'] =  $filter_remark;
        $data['filter_add_by'] = explode(",",$filter_add_by);
        $data['filter_store_id'] = explode(",",$filter_store_id);
        $data['filter_status'] = explode(",",$filter_status);
        $data['filter_customer_id'] = explode(",",$filter_customer_id);
        $data['filter_category'] = explode(",",$filter_category);
        $data['filter_location_id'] = explode(",",$filter_location_id);
        $data['filter_product_name'] = $filter_product_name;
        $data['filter_product_code'] = $filter_product_code;
        $data['filter_batch_date_from'] = $filter_batch_date_from;
        $data['filter_batch_date_to'] = $filter_batch_date_to;


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $data['store_name'] = $this->config->get('config_name');
        $data['page'] = ($page - 1) * $this->config->get('config_limit_admin');

        $this->response->setOutput($this->load->view('catalog/stock_issue_list', $data));
    }

    public function printProductStickers()
    {
        $product_ids[] = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : '';
        if (!empty($product_ids)) {
            $this->load->language('catalog/product');
            $this->load->model('catalog/product');
            $data = [];

            $type = !empty($this->request->get['type']) ? $this->request->get['type'] : 'barcode';

            foreach ($product_ids as $id) {
                $product_info = $this->model_catalog_product->getProductByProductID($id);

                if (!empty($product_info)) {
                    $date_stock_in = !empty($product_info['date_stock_in']) ? date('d M Y', strtotime($product_info['date_stock_in'])) : date('d M Y', strtotime('2021-05-20'));
                    $date_expired = !empty($product_info['date_expired']) ? date('d M Y', strtotime($product_info['date_expired'])) : date('d M Y', strtotime('2021-05-20'));
                    $product_weight = !empty($product_info['product_weight_sticker']) ? $product_info['product_weight_sticker'] : '30 KG';

                    if ($type == 'qr_code') {
                        //$qr_code_content = ['code' => $product_info['code'], 'chinese_name' => $product_info['chinese_name'], 'english_name' => $product_info['english_name'], 'date_stock_in' => $date_stock_in, 'date_expired' => $date_expired, 'weight' => $product_weight];

                        //$qr_code_content =  json_encode($qr_code_content, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES, true);
                        $qr_code_content = $product_info['code'];
                        $content = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . $qr_code_content . '&choe=UTF-8';
                    } else {
                        $content = 'https://barcode.tec-it.com/barcode.ashx?data=' . $product_info['code'] . '&amp;code=Code128&amp;multiplebarcodes=false&amp;translate-esc=false&amp;unit=Fit&amp;dpi=96&amp;imagetype=Gif&amp;rotation=0&amp;color=%23000000&amp;bgcolor=%23ffffff&amp;codepage=&amp;qunit=Mm&amp;quiet=0';
                    }

                    //$content = urlencode($content);

                    $data['product_stickers'][] = [
                        'product_id' => $product_info['product_id'],
                        'code'         => $product_info['code'],
                        'model'      => $product_info['model'],
                        'chinese_name' => $product_info['chinese_name'],
                        'english_name' => $product_info['english_name'],
                        //'date_stock_in' => $date_stock_in,
                        //'date_expired' => $date_expired,
                        //'product_weight_sticker' => $product_weight,
                        'link' => $content,
                    ];
                }
            }

            $data['stickers_count'] = !empty($data['product_stickers']) ? count($data['product_stickers']) : 0;

            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';

            $data['text_stickers'] = '';
            if ($type == 'qr_code') {
                $data['sticker_size'] = '100mm 110mm';
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_display_size'] = 'width:60%;';
                $data['text_stickers'] = $this->language->get('text_barcode_sticker');
            } else {
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_size'] = '100mm 80mm';
                $data['$sticker_display_size'] = 'width:50px;height:100px;';
                $data['text_stickers'] = $this->language->get('text_qrcode_sticker');
            }

            //echo '<pre>';
            //print_r($data);
            //echo '</pre>';

            $mpdf = new mPDF('utf-8', 'A4');
            $mpdf->writeHTML($this->load->view('catalog/product_stickers', $data));
            $mpdf->Output($filename, 'I');
        } else {
            echo "<h1>Barcode not found</h1>";
        }
    }

    public function printForm(){
        
        $this->load->language('catalog/stock_issue');

        $this->document->setTitle($this->language->get('heading_title'));
        $store_id = $this->session->data['store_id'];

        $this->load->model('catalog/stock_issue');
        $this->load->model('setting/setting');

        if (isset($this->request->get['stock_issue_id'])) {
            $stock_issue_id = $this->request->get['stock_issue_id'];

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true)
            );

            $stock_issue_info = [];
            $stock_issue_info = $this->model_catalog_stock_issue->getStockIssue($stock_issue_id);

            $data['stock_issue_item'] = [];
            $data['store_info'] = $this->model_setting_setting->getSetting('config', $store_id);

            if (!empty($stock_issue_info)) {
                $stock_issue_products = $this->model_catalog_stock_issue->getStockIssueProducts($stock_issue_id);

                $data['invoice_prefix'] = $stock_issue_info['invoice_prefix'];
                $data['date_added'] = date('d/m/Y H:iA', strtotime($stock_issue_info['date_added']));
                $data['staff'] = $stock_issue_info['staff'];
                $data['fname'] = $stock_issue_info['fname'];

                if (isset($this->request->post['description'])) {
                    $data['description'] = $this->request->post['description'];
                } elseif (!empty($stock_issue_info['description'])) {
                    $data['description'] = $stock_issue_info['description'];
                } else {
                    $data['description'] = '';
                }



                if (!empty($stock_issue_products)) {
                    foreach ($stock_issue_products as $product) {
                        $data['stock_issue_item'][] = [
                            'title' => $product['invoice_prefix'],
                            'product_name' => $product['product_name'],
                            'product_name2' => $product['product_name2'],
                            'product_code' => $product['code'],
                            'quantity' => $product['quantity'],
                            'category' => $product['category'],
                            'batch_date' => $product['batch_date'],
                            'location' => $product['location'],
                            'unit' => $product['unit'],
                            'fname' => $product['fname'],
                            'sname' => $product['sname'],
                            'stock_onhand' => $product['stock_onhand'],
                            'stock_balance' => $product['stock_balance'],
                            'date_modified' => date('d/m/Y', strtotime($product['date_modified'])),
                            'remark' => $product['remark'],
                            'modified_by' => $product['modified_by'],
                            'description' => $product['description']
                        ];
                    }
                }

                if (isset($this->request->get['pdf'])) {
                    $pdf = new PDF();
                    $page_size ='a4';
                    $pdf_file_name = $stock_issue_info['invoice_prefix'] . '.pdf';
    
                    $this->response->setOutput($pdf->pdf($this->load->view('catalog/stock_issue_print', $data), $pdf_file_name, $page_size));
                }
                else {
                    $this->response->setOutput($this->load->view('catalog/stock_issue_print', $data));
                }
            } else {
                $this->response->redirect($this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true));
            }
        } else {
            $this->response->redirect($this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true));
        }

       
    }

    protected function getForm()
    {
        $data['user_token'] = $this->session->data['user_token'];

        $store_id = $this->session->data['store_id'];

        if (isset($this->request->get['stock_issue_id'])) {
            $stock_issue_info = $this->model_catalog_stock_issue->getStockIssue($this->request->get['stock_issue_id']);

            // var_dump($stock_issue_info);
            // die();

            $data["invoice_prefix"] = $stock_issue_info['invoice_prefix'];
            $data['stock_issue_id'] = $this->request->get['stock_issue_id'];
            $data['fname'] = $stock_issue_info['fname'];
            $data['customer_id'] = $stock_issue_info['customer_id'];
        } else {
            $data["invoice_prefix"] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_issue', 'store' => $store_id));
            $data['stock_issue_id'] = 0;
        }

        if ($this->request->server['REQUEST_METHOD'] == 'POST') {
            $data["current_date"] = isset($this->request->post['date_added']) ? $this->request->post['date_added'] : date('Y-m-d');
            $form_memory_stock_issue_items = isset($this->request->post['stock_issue_item']) ?
                $this->request->post['stock_issue_item'] :
                array();
            $data["form_memory_stock_issue_items"] = $form_memory_stock_issue_items;
            $data['description'] = $this->request->post['description'];
        } elseif (!empty($stock_issue_info)) {

            $data["current_date"] = $stock_issue_info['date_added'];
            $data["form_memory_stock_issue_items"] = isset($stock_issue_info['stock_issue_item']) ? $stock_issue_info['stock_issue_item'] : array();
            $data['description'] = $stock_issue_info['description'];
        } else {
            $data["current_date"] = date('Y-m-d');
            $data["form_memory_stock_issue_items"] = array();
            $data['description'] = '';
        }
        foreach ($data["form_memory_stock_issue_items"] as $key => $item) {
           
            if (!empty($item['product_id'])) {
                $data['locations'][$item['product_id']] = $this->model_catalog_stock_issue->getLocationList($item['product_id'], false);
                $data['batchDates'][$item['product_id']][$item['location_id']] = $this->model_catalog_stock_issue->getBatchDateList($item['product_id'], $item['location_id'], false);
            }
            if (empty($item['onhand_quantity'])) {

                $form_batch_date = isset($item['batch_date'])?$item['batch_date']:$item['stock_issue_batch_date'];
                $data["form_memory_stock_issue_items"][$key]['onhand_quantity'] = $this->model_catalog_stock_issue->getStockOnhand($item['product_id'], $item['location_id'], $form_batch_date, $store_id);
            }
                
        }
        
        // var_dump($data['batchDates']);
        // die();

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true)
        );

        $language_arr = ['heading_title', 'button_cancel', 'button_save', 'text_add_form', 'entry_invoice_prefix', 'entry_current_date', 'entry_description', 'column_product_name', 'column_product_code', 'column_product_action', 'column_product_qty', 'column_product_onhand_quantity', 'text_loading', 'entry_product_name', 'entry_product_code', 'entry_quantity', 'tab_add_product', 'tab_clinical_sale', 'entry_product_onhand_quantity', 'button_add_product', 'button_clear', 'error_product_quantity', 'button_delete', 'error_quantity_over', 'error_product', 'entry_sale_date', 'entry_date_start', 'entry_date_end', 'text_add_date', 'text_add_transaction', 'entry_transaction_start', 'entry_transaction_end', 'button_add_range', 'error_product_empty_herbal_remedies', 'entry_cs_invoice_prefix'];

        foreach ($language_arr as $language) {
            $data[$language] = $this->language->get($language);
        }

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = '';
        }


        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $supplier_counter = (isset($this->request->post['supplier_counter'])) ? $this->request->post['supplier_counter'] : false;
        $image_counter = (isset($this->request->post['image_counter'])) ? $this->request->post['image_counter'] : false;
        $image_url = (isset($this->request->post['image_url'])) ? $this->request->post['image_url'] : false;

        if ($product_id && $image_url) {

            $this->load->model('tool/image');

            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('quotation_request');
            $this->po = new Quotation_request($this->registry);

            if (is_file(DIR_IMAGE . $image_url)) {
                $image_thumb = $this->model_tool_image->resize($image_url, 100, 100);
            } else {
                $image_thumb = $this->model_tool_image->resize('no_image.png', 100, 100);
            }


            $respond = $this->po->updateSupplierImage($product_id, $supplier_counter, $image_counter, $image_url, $image_thumb);

            $product_cart = $this->po->getProducts();

            $json = array(
                'success' => true,
                'respond' => $product_cart
            );
        }


        //Get Location List
        $this->load->model('localisation/warehouse');


        //Get Weight Class List
        $this->load->model('localisation/weight_class');
        $weight_classes = $this->model_localisation_weight_class->getWeightClasses();
        $sort_weight_class = array_column($weight_classes, 'unit');
        array_multisort($sort_weight_class, SORT_ASC, $weight_classes);
        $data['weight_classes'] = $weight_classes;

        if (!empty($stock_issue_info)) {
            $data['action'] = $this->url->link('catalog/stock_issue/edit', 'user_token=' . $this->session->data['user_token'] . "&stock_issue_id=" . $this->request->get['stock_issue_id'], true);
        } else {
            $data['action'] = $this->url->link('catalog/stock_issue/add', 'user_token=' . $this->session->data['user_token'], true);
        }
        $data['cancel'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/stock_issue_form', $data));
    }


    protected function getEditForm()
    {
        $data['stock_issue_item'] = [];

        if (isset($this->request->get['stock_issue_id'])) {
            $stock_issue_id = $this->request->get['stock_issue_id'];
            $stock_issue_info = $this->model_catalog_stock_issue->getStockIssue($stock_issue_id);

            if (!empty($stock_issue_info)) {
                $stock_issue_products = $this->model_catalog_stock_issue->getStockIssueProducts($stock_issue_id);

                $data['invoice_prefix'] = $stock_issue_info['invoice_prefix'];
                $data['date_added'] = $stock_issue_info['date_added'];
                $data['staff'] = $stock_issue_info['staff'];
                $data['description'] = $stock_issue_info['description'];

                if (!empty($stock_issue_products)) {
                    foreach ($stock_issue_products as $product) {
                        $data['stock_issue_item'][] = [
                            'product_name' => $product['product_name'],
                            'product_code' => $product['code'],
                            'quantity' => $product['quantity']
                        ];
                    }
                }
            } else {
                $this->response->redirect($this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true));
            }
        } else {
            $this->response->redirect($this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true));
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true)
        );

        $language_arr = ['heading_title', 'button_cancel', 'button_save', 'text_edit_form', 'entry_invoice_prefix', 'entry_date_added', 'entry_description', 'entry_staff', 'column_product_name', 'column_product_code', 'column_product_qty'];

        foreach ($language_arr as $language) {
            $data[$language] = $this->language->get($language);
        }

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['action'] = $this->url->link('catalog/stock_issue/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_issue_id=' . $this->request->get['stock_issue_id'], true);
        $data['cancel'] = $this->url->link('catalog/stock_issue', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/stock_issue_edit_form', $data));
    }

    protected function validateForm()
    {
        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_issue') && !$this->user->userpermission('modify', 'catalog/stock_issue'))
            $this->error['warning'] = $this->language->get('error_permission');

        $stock_issue_item = isset($this->request->post['stock_issue_item']) ? $this->request->post['stock_issue_item'] : false;

        if (!$stock_issue_item) {
            $this->error['warning'] = $this->language->get('error_warning');
        // } else {
        //     //check product
        //     foreach ($stock_issue_item as $item) {
        //         $stock_onhand = $this->model_catalog_stock_issue->getStockOnhand($item['product_id'], $item['location_id'], $item['stock_issue_batch_date'], $this->session->data['store_id']);
        //         if ($item['quantity'] > $stock_onhand) {
        //             $this->error['warning'] = $this->language->get('error_warning');
        //         }
        //         if($item['quantity']==0){
        //             $this->error['warning'] = $this->language->get('error_warning');
        //         }
        //     }
        }



        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function getLocationList()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        if ($product_id) {
            $this->load->model('catalog/stock_issue');
            $locationList = $this->model_catalog_stock_issue->getLocationList($product_id);
            $product_info = $this->model_catalog_stock_issue->getProductStock($product_id);
            $json = array(
                'success' => true,
                'locationList' => $locationList,
                'productInfo' => $product_info
            );
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function getBatchDateList()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $location_id = (isset($this->request->post['location_id'])) ? $this->request->post['location_id'] : 0;
        if ($product_id) {
            $this->load->model('catalog/stock_issue');
            $batchDateList = $this->model_catalog_stock_issue->getBatchDateList($product_id, $location_id);
            $json = array(
                'success' => true,
                'batchDateList' => $batchDateList,
            );
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }
    public function getStockOnhand()
    {
        $json = array('success' => false, 'qty' => '0');

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $location_id = (isset($this->request->post['location_id'])) ? $this->request->post['location_id'] : 0;
        $batch_date = (isset($this->request->post['batch_date'])) ? $this->request->post['batch_date'] : '0000-00-00';
        $store_id = (isset($this->request->post['store_id'])) ? $this->request->post['store_id'] : $this->session->data['store_id'];
        if ($product_id) {
            $this->load->model('catalog/stock_issue');
            $stock = $this->model_catalog_stock_issue->getStockOnhand($product_id, $location_id, $batch_date, $store_id);
            $json = array(
                'success' => true,
                'qty' => $stock,
            );
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    protected function validateUpdateDesc()
    {
        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_issue') && !$this->user->userpermission('modify', 'catalog/stock_issue')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['description'])) {
            $this->error['description'] = $this->language->get('error_description');
        }





        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function getcustomerList()
    {
        $this->load->language('catalog/stock_issue');

        $this->document->setTitle($this->language->get('text_customer_list'));

        $this->load->model('catalog/stock_issue');

        if (isset($this->request->get['customer_name'])) {
            $customer_name = $this->request->get['customer_name'];
        } else {
            $customer_name = NULL;
        }

        if (isset($this->request->get['customer_ic'])) {
            $customer_ic = $this->request->get['customer_ic'];
        } else {
            $customer_ic = NULL;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['customer_name'])) {
            $url .= '&customer_name=' . urlencode(html_entity_decode($this->request->get['customer_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['customer_ic'])) {
            $url .= '&customer_ic=' . urlencode(html_entity_decode($this->request->get['customer_ic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['customers'] = array();

        $filter_data = array(
            'customer_name' => $customer_name,
            'customer_ic' => $customer_ic,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $total_customers = $this->model_catalog_stock_issue->getTotalCustomers($filter_data);
        $results = $this->model_catalog_stock_issue->getCustomerslist($filter_data);

        foreach ($results as $result) {
            $data['customers'][] = array(
                'customer_id' => $result['customer_id'],
                'customer_name' => $result['customer_name'],
                'customer_ic' => $result['customer_ic'],
                'data_encoded' => htmlspecialchars(json_encode($result))
            );
        }

        $data['text_list'] = $this->language->get('text_customer_list');

        $data['user_token'] = $this->session->data['user_token'];

        $pagination = new Pagination();
        $pagination->total = $total_customers;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        ;
        $pagination->url = $this->url->link('catalog/stock_issue/getcustomerList', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_customers) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_customers - $this->config->get('config_limit_admin'))) ? $total_customers : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_customers, ceil($total_customers / $this->config->get('config_limit_admin')));

        $data['customer_name'] = $customer_name;
        $data['customer_ic'] = $customer_ic;

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/customer_full_list', $data));
    }
}
