<?php

class ControllerCatalogStockAdjustment extends Controller
{

    private $error = array();

    public function index()
    {
        $this->load->language('catalog/stock_adjustment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');

        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');

        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $this->load->model('catalog/stock_adjustment');

        $this->getList();
    }

    public function add()
    {   
        $this->load->language('catalog/stock_adjustment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_adjustment');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && isset($this->request->post['add_product'])) {
            $stock_adjustment_id = $this->model_catalog_stock_adjustment->addStockAdjustment($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');


            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_invoice_prefix']))
                $querystring .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];

            if (isset($this->request->get['filter_add_by']))
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_status']))
                $querystring .= '&filter_status=' . $this->request->get['filter_status'];

            if (isset($this->request->get['filter_store_id']))
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];


            $this->response->redirect($this->url->link('catalog/stock_adjustment/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_adjustment_id=' . $stock_adjustment_id . $querystring, true));
        } elseif ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_catalog_stock_adjustment->addStockAdjustment($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_invoice_prefix']))
                $querystring .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];

            if (isset($this->request->get['filter_add_by']))
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_status']))
                $querystring .= '&filter_status=' . $this->request->get['filter_status'];

            if (isset($this->request->get['filter_store_id']))
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

            $this->response->redirect($this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }



        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('catalog/stock_adjustment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_adjustment');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_catalog_stock_adjustment->editStockAdjustment($this->request->get['stock_adjustment_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_invoice_prefix']))
                $querystring .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];

            if (isset($this->request->get['filter_add_by']))
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_status']))
                $querystring .= '&filter_status=' . $this->request->get['filter_status'];

            if (isset($this->request->get['filter_store_id']))
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

            $this->response->redirect($this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm();
    }

    public function info()
    {
        //load default model
        $this->load->model('catalog/stock_adjustment');
        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateDesc()) {
            $this->model_catalog_stock_adjustment->editStockInfo(
                $this->request->get['stock_adjustment_id'],
                $this->request->post
            );
            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'], true));
        }

        $stock_adjustment_id = isset($this->request->get['stock_adjustment_id']) ? $this->request->get['stock_adjustment_id'] : 0;

        $stock_adjustment_info = $this->model_catalog_stock_adjustment->getStockAdjustment($stock_adjustment_id);

        if ($stock_adjustment_info) {
            //load default language
            $this->load->language('catalog/stock_adjustment');

            //set document title
            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            //**sitemap
            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'], true)
            );

            //**data
            $data['invoice_prefix'] = $stock_adjustment_info['invoice_prefix'];
            $data['date_added'] = date('d/m/Y H:iA', strtotime($stock_adjustment_info['date_added']));
            $data['staff'] = $stock_adjustment_info['staff'];


            if (isset($this->request->post['description'])) {
                $data['description'] = $this->request->post['description'];
            } elseif (!empty($stock_adjustment_info['description'])) {
                $data['description'] = $stock_adjustment_info['description'];
            } else {
                $data['description'] = '';
            }

            $stock_adjustment_item = $stock_adjustment_info['stock_adjustment_item'];

            foreach ($stock_adjustment_item as $product_id => $product) {
                if ($product['action'] == 1) {
                    $stock_adjustment_item[$product_id]['action'] = $this->language->get('text_qty_add');
                } else if ($product['action'] == 0) {
                    $stock_adjustment_item[$product_id]['action'] = $this->language->get('text_qty_deduct');
                }
            }

            $data['stock_adjustment_item'] = $stock_adjustment_item;
            //**query string
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_invoice_prefix']))
                $querystring .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];

            if (isset($this->request->get['filter_add_by']))
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_status']))
                $querystring .= '&filter_status=' . $this->request->get['filter_status'];

            if (isset($this->request->get['filter_store_id']))
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];

            //**url
            $data['print'] = $this->url->link('catalog/stock_adjustment/printForm', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&stock_adjustment_id=' . $this->request->get['stock_adjustment_id'], true);
            $data['barcode_link'] = $this->url->link('catalog/stock_adjustment/printProductStickers', 'user_token=' . $this->session->data['user_token'] . '&type=barcode' . $querystring, true);
            $data['export_excel'] = $this->url->link('catalog/stock_adjustment/export_excel', 'user_token=' . $this->session->data['user_token'] . '&stock_adjustment_id=' . $this->request->get['stock_adjustment_id'], true);
            $data['cancel'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('catalog/stock_adjustment_info', $data));
        } else {
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    public function export_excel_all()
    {
        $this->load->language('catalog/stock_adjustment');
        $this->load->model('catalog/stock_adjustment');


            $lot_info = $this->model_catalog_stock_adjustment->getStockAdjustmentItemAll();

            if (!empty($lot_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $adjustment_item = $this->model_catalog_stock_adjustment->getStockAdjustmentItemAll();

                $table_collection = array();

                if (!empty($adjustment_item)) {
                    foreach ($adjustment_item as $item) {
                        $table_collection[] = [
                            'stock_adjustment_id' => $item['stock_adjustment_id'],
                            'invoice_prefix' => $item['invoice_prefix'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'sname' => $item['sname']. " (Batch Date: ".$item['batch_date']. ") ",
                            'qty' => $item['qty']. " " .$item['uom'],
                            'status_name' => $item['status_name'],
                            'date_added' => $item['date_added'],
                            'add_by' => $item['add_by']
                        ];
                    }
                }


                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_store'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_All';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        
    }

    public function export_excel_searched()
    {
        $this->load->language('catalog/stock_adjustment');
        $this->load->model('catalog/stock_adjustment');

        $filter_invoice_prefix = isset($this->request->get['filter_invoice_prefix']) ? $this->request->get['filter_invoice_prefix'] : null;
        $filter_add_by = isset($this->request->get['filter_add_by']) ? explode(',', $this->request->get['filter_add_by']) : null;
        $filter_date_to = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : null;
        $filter_date_from = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : null;

        $filter_status = isset($this->request->get['filter_status']) ? explode(',', $this->request->get['filter_status']) : null;

        $filter_category = isset($this->request->get['filter_category']) ? explode(',', $this->request->get['filter_category']) : null;

        $filter_store_id = isset($this->request->get['filter_store_id']) ? explode(',', $this->request->get['filter_store_id']) : NULL;

        $filter_location_id = isset($this->request->get['filter_location_id']) ? explode(',', $this->request->get['filter_location_id']) : NULL;

        $filter_product_name = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : NULL;

        $filter_product_code = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : NULL;

        $filter_product_id = isset($this->request->get['filter_product_id']) ? $this->request->get['filter_product_id'] : NULL;

        $filter_batch_date_to = isset($this->request->get['filter_batch_date_to']) ? $this->request->get['filter_batch_date_to'] : NULL;

        $filter_batch_date_from = isset($this->request->get['filter_batch_date_from']) ? $this->request->get['filter_batch_date_from'] : NULL;

        $querystring = '';

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $querystring .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_status'])) {
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_category'])) {
            $querystring .= '&filter_category=' . $this->request->get['filter_category'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_location_id'])) {
            $querystring .= '&filter_location_id=' . $this->request->get['filter_location_id'];
        }

        if (isset($this->request->get['filter_product_id'])) {
            $querystring .= '&filter_product_id=' . $this->request->get['filter_product_id'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_product_code'])) {
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }

        if (isset($this->request->get['filter_batch_date_to'])) {
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }

        if (isset($this->request->get['filter_batch_date_from'])) {
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }

        $filter_data = array(
            'filter_invoice_prefix' => $filter_invoice_prefix,
            'filter_add_by' => $filter_add_by,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_status' => $filter_status,
            'filter_category' => $filter_category,
            'filter_store_id' => $filter_store_id,
            'filter_location_id' => $filter_location_id,
            'filter_product_id' => $filter_product_id,
            'filter_product_name' => $filter_product_name,
            'filter_product_code' => $filter_product_code,
            'filter_batch_date_to' => $filter_batch_date_to,
            'filter_batch_date_from' => $filter_batch_date_from
        );

            $adjustment_info = $this->model_catalog_stock_adjustment->getStockAdjustmentItemAll();

            if (!empty($adjustment_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $adjustment_item = $this->model_catalog_stock_adjustment->getStockAdjustmentItemSearched($filter_data);

                $table_collection = array();

                if (!empty($adjustment_item)) {
                    foreach ($adjustment_item as $item) {
                        $table_collection[] = [
                            'stock_adjustment_id' => $item['stock_adjustment_id'],
                            'invoice_prefix' => $item['invoice_prefix'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'sname' => $item['sname']. " (Batch Date: ".$item['batch_date']. ") ",
                            'qty' => $item['qty']. " " .$item['uom'],
                            'status_name' => $item['status_name'],
                            'date_added' => $item['date_added'],
                            'add_by' => $item['add_by']
                        ];
                    }
                }


                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_store'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_Searched';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        
    }

    public function export_excel_selected()
    {
        $this->load->language('catalog/stock_adjustment');
        $this->load->model('catalog/stock_adjustment');

        if (isset($this->request->get['adjustments'])) {
            $adjustment_ids = explode(",", $this->request->get['adjustments']);

            $lot_info = $this->model_catalog_stock_adjustment->getStockAdjustmentItemAll();

            if (!empty($lot_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                    $table_collection = array();
                foreach ($adjustment_ids as $adjustment_id) {

                $adjustment_item = $this->model_catalog_stock_adjustment->getStockAdjustmentItemSelected($adjustment_id);
                if (!empty($adjustment_item)) {
                    foreach ($adjustment_item as $item) {
                        $table_collection[] = [
                            'stock_adjustment_id' => $item['stock_adjustment_id'],
                            'invoice_prefix' => $item['invoice_prefix'],
                            'product_name' => ($item['product_name2']==$item['product_name']) ? $item['product_name'] : $item['product_name']." ".$item['product_name2'],
                            'product_code' => $item['product_code'],
                            'sname' => $item['sname']. " (Batch Date: ".$item['batch_date']. ") ",
                            'qty' => $item['qty']. " " .$item['uom'],
                            'status_name' => $item['status_name'],
                            'date_added' => $item['date_added'],
                            'add_by' => $item['add_by']
                        ];
                    }
                }
            }

                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $table[] = array('Date Export: ', date('m/d/Y h:i:s a', time()));

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_stock_id'),
                    $this->language->get('column_invoice_prefix'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_code'),
                    $this->language->get('entry_store'),
                    $this->language->get('column_product_qty'),
                    $this->language->get('column_status'),
                    $this->language->get('column_date_added'),
                    $this->language->get('row_add_by')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 4;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_Selected';
        
                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        }
    }

    public function export_excel()
    {
        $this->load->language('catalog/stock_adjustment');
        $this->load->model('catalog/stock_adjustment');

        if (isset($this->request->get['stock_adjustment_id'])) {
            $stock_adjustment_id = $this->request->get['stock_adjustment_id'];

            $sa_info = $this->model_catalog_stock_adjustment->getStockAdjustment($stock_adjustment_id);

            if (!empty($sa_info)) {
                // get user detail
                $this->load->model('user/user');
                $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                // load php Excel
                $this->load->library('PHPExcel');
                $objPHPExcel = new PHPExcel();

                // Set document properties
                $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle('Title')
                    ->setSubject('Subject')
                    ->setDescription('Description')
                    ->setKeywords('report qiangyitang.com')
                    ->setCategory('report excel');

                // Set default font
                $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);

                $stock_adjustment_item = $sa_info['stock_adjustment_item'];

                $table_collection = array();

                if (!empty($stock_adjustment_item)) {
                    foreach ($stock_adjustment_item as $product_id => $item) {
                        $action = ($item['action'] > 0) ? $this->language->get('text_qty_add') : $this->language->get('text_qty_deduct');

                        $table_collection[] = [
                            'product_id' => $product_id,
                            'product_name' => $item['name'],
                            'product_code' => $item['code'],
                            'action' => $action,
                            'qty' => $item['qty']
                        ];
                    }
                }

                $table = array();

                $table[] = array('Report Name : ', $this->language->get('heading_title'));
                $table[] = array('Invoice Prefix : ', $sa_info['invoice_prefix']);
                $table[] = array('Store Name : ', $this->config->get('config_name'));
                $table[] = array('Description : ', $sa_info['description']);
                $table[] = array('Date : ', $sa_info['date_added']);

                $table[] = array();

                $table_header = array(
                    $this->language->get('column_product_id'),
                    $this->language->get('column_product_name'),
                    $this->language->get('column_product_code'),
                    $this->language->get('column_product_action'),
                    $this->language->get('column_product_qty')
                );

                $table[] = $table_header;

                $total_row = 0;

                $table_data = $table_collection;
                // $row;

                foreach ($table_data as $key => $data) {
                    $row = array();

                    foreach ($data as $key => $value) {
                        $row[] = $value;
                    }
                    $table[] = $row;

                    $total_row++;
                }

                // Styling
                $autosize_column_index = 'A';
                foreach ($table_header as $header) {
                    $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                    $autosize_column_index++;
                }

                $header_index_s_column = 'A';
                $header_index_e_column = $header_index_s_column;
                foreach ($table_header as $col)
                    $header_index_e_column++;
                $header_index_row = 7;
                $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                $header_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                    ),
                    'font' => array(
                        'bold' => true
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                $currency_style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                    ),
                    'numberformat' => array(
                        'code' => "0.00"
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                // Add Array To Excel
                $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

                // Rename worksheet
                $sheettitle = $this->language->get('heading_title');
                $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);

                $filename = $this->language->get('heading_title') . '_' . $sa_info['invoice_prefix'];

                // Save Excel 2007 file
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                //ob_end_clean();
                // We'll be outputting an excel file
                header('Content-type: application/vnd.ms-excel');

                // It will be called file.xls
                header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                $objWriter->save('php://output');
            }
        }
    }

    public function printForm(){
        
        $this->load->language('catalog/stock_adjustment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_adjustment');

        if (isset($this->request->get['stock_adjustment_id'])) {
            $stock_adjustment_id = $this->request->get['stock_adjustment_id'];

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'], true)
            );

            $stock_adjustment_info = [];
            $stock_adjustment_info = $this->model_catalog_stock_adjustment->getStockAdjustment($stock_adjustment_id);

            $data['stock_adjustment_item'] = [];

            if (!empty($stock_adjustment_info)) {
                $stock_adjustment_products = $this->model_catalog_stock_adjustment->getStockAdjustmentProducts($stock_adjustment_id);
                //load default language
            $this->load->language('catalog/stock_adjustment');

            //set document title
            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

                $data['invoice_prefix'] = $stock_adjustment_info['invoice_prefix'];
                $data['date_added'] = $stock_adjustment_info['date_added'];
                $data['staff'] = $stock_adjustment_info['staff'];

                if (isset($this->request->post['description'])) {
                    $data['description'] = $this->request->post['description'];
                } elseif (!empty($stock_adjustment_info['description'])) {
                    $data['description'] = $stock_adjustment_info['description'];
                } else {
                    $data['description'] = '';
                }

                $stock_adjustment_item = $stock_adjustment_info['stock_adjustment_item'];

                foreach ($stock_adjustment_item as $product_id => $product) {
                    if ($product['action'] == 1) {
                        $stock_adjustment_item[$product_id]['action'] = $this->language->get('text_qty_add');
                    } else if ($product['action'] == 0) {
                        $stock_adjustment_item[$product_id]['action'] = $this->language->get('text_qty_deduct');
                    }

                    if (!empty($stock_adjustment_products)) {
                        foreach ($stock_adjustment_products as $product) {
                            $data['stock_adjustment_item'][] = [
                                'product_name' => $product['product_name'],
                                'product_name2' => $product['product_name2'],
                                'product_code' => $product['code'],
                                'qty' => $product['qty'],
                                'category' => $product['category'],
                                'batch_date' => $product['batch_date'],
                                'location' => $product['location'],
                                'unit' => $product['unit'],
                                'sname' => $product['sname'],
                                'stock_onhand' => $product['stock_onhand'],
                                'stock_balance' => $product['stock_balance'],
                                'date_modified' => date('d/m/Y', strtotime($product['date_modified'])),
                                'modified_by' => $product['modified_by'],
                                'description' => $product['description'],
                                'action' => $stock_adjustment_item[$product_id]['action']
                            ];
                        }
                    }
                }

                if (isset($this->request->get['pdf'])) {
                    $pdf = new PDF();
                    $page_size ='a4';
                    $pdf_file_name = $stock_adjustment_info['invoice_prefix'] . '.pdf';
    
                    $this->response->setOutput($pdf->pdf($this->load->view('catalog/stock_adjustment_print', $data), $pdf_file_name, $page_size));
                }
                else {
                    $this->response->setOutput($this->load->view('catalog/stock_adjustment_print', $data));
                }
            } else {
                $this->response->redirect($this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'], true));
            }
        } else {
            $this->response->redirect($this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'], true));
        }

       
    }

    public function printProductStickers()
    {
        $product_ids[] = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : '';
        if (!empty($product_ids)) {
            $this->load->language('catalog/product');
            $this->load->model('catalog/product');
            $data = [];

            $type = !empty($this->request->get['type']) ? $this->request->get['type'] : 'barcode';

            foreach ($product_ids as $id) {
                $product_info = $this->model_catalog_product->getProductByProductID($id);

                if (!empty($product_info)) {
                    $date_stock_in = !empty($product_info['date_stock_in']) ? date('d M Y', strtotime($product_info['date_stock_in'])) : date('d M Y', strtotime('2021-05-20'));
                    $date_expired = !empty($product_info['date_expired']) ? date('d M Y', strtotime($product_info['date_expired'])) : date('d M Y', strtotime('2021-05-20'));
                    $product_weight = !empty($product_info['product_weight_sticker']) ? $product_info['product_weight_sticker'] : '30 KG';

                    if ($type == 'qr_code') {
                        //$qr_code_content = ['code' => $product_info['code'], 'chinese_name' => $product_info['chinese_name'], 'english_name' => $product_info['english_name'], 'date_stock_in' => $date_stock_in, 'date_expired' => $date_expired, 'weight' => $product_weight];

                        //$qr_code_content =  json_encode($qr_code_content, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES, true);
                        $qr_code_content = $product_info['code'];
                        $content = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . $qr_code_content . '&choe=UTF-8';
                    } else {
                        $content = 'https://barcode.tec-it.com/barcode.ashx?data=' . $product_info['code'] . '&amp;code=Code128&amp;multiplebarcodes=false&amp;translate-esc=false&amp;unit=Fit&amp;dpi=96&amp;imagetype=Gif&amp;rotation=0&amp;color=%23000000&amp;bgcolor=%23ffffff&amp;codepage=&amp;qunit=Mm&amp;quiet=0';
                    }

                    //$content = urlencode($content);

                    $data['product_stickers'][] = [
                        'product_id' => $product_info['product_id'],
                        'code'         => $product_info['code'],
                        'model'      => $product_info['model'],
                        'chinese_name' => $product_info['chinese_name'],
                        'english_name' => $product_info['english_name'],
                        //'date_stock_in' => $date_stock_in,
                        //'date_expired' => $date_expired,
                        //'product_weight_sticker' => $product_weight,
                        'link' => $content,
                    ];
                }
            }

            $data['stickers_count'] = !empty($data['product_stickers']) ? count($data['product_stickers']) : 0;

            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';

            $data['text_stickers'] = '';
            if ($type == 'qr_code') {
                $data['sticker_size'] = '100mm 110mm';
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_display_size'] = 'width:60%;';
                $data['text_stickers'] = $this->language->get('text_barcode_sticker');
            } else {
                $filename = 'barcode_sticker_' . time() . '.pdf';
                $data['sticker_size'] = '100mm 80mm';
                $data['$sticker_display_size'] = 'width:50px;height:100px;';
                $data['text_stickers'] = $this->language->get('text_qrcode_sticker');
            }

            //echo '<pre>';
            //print_r($data);
            //echo '</pre>';

            $mpdf = new mPDF('utf-8', 'A4');
            $mpdf->writeHTML($this->load->view('catalog/product_stickers', $data));
            $mpdf->Output($filename, 'I');
        } else {
            echo "<h1>Barcode not found</h1>";
        }
    }

    public function filter()
    {
        $this->load->language('catalog/stock_adjustment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/stock_adjustment');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';

            if (isset($this->request->post['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->post['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            //post from filter form
            if (isset($this->request->post['filter_invoice_prefix']))
                $querystring .= '&filter_invoice_prefix=' . $this->request->post['filter_invoice_prefix'];

            if (isset($this->request->post['filter_add_by']))
                $querystring .= '&filter_add_by=' . implode(',', $this->request->post['filter_add_by']);

            if (isset($this->request->post['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->post['filter_date_from'];

            if (isset($this->request->post['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->post['filter_date_to'];
                
            if (isset($this->request->post['filter_doc_no']))
                $querystring .= '&filter_doc_no=' . implode(',', $this->request->post['filter_doc_no']);

            if (isset($this->request->post['filter_status']))
                $querystring .= '&filter_status='  . implode(",", $this->request->post['filter_status']);

            if (isset($this->request->post['filter_store_id'])) {
                $querystring .= '&filter_store_id=' . implode(",", $this->request->post['filter_store_id']);
            }

            if (isset($this->request->post['filter_location_id'])) {
                $querystring .= '&filter_location_id=' . implode(',', $this->request->post['filter_location_id']);
            }

            if (isset($this->request->post['filter_product_id'])) {
                $querystring .= '&filter_product_id=' . $this->request->post['filter_product_id'];
            }

            if (isset($this->request->post['filter_product_name'])) {
                $querystring .= '&filter_product_name=' . $this->request->post['filter_product_name'];
            }

            if (isset($this->request->post['filter_product_code'])) {
                $querystring .= '&filter_product_code=' . $this->request->post['filter_product_code'];
            }

            if (isset($this->request->post['filter_batch_date_to'])) {
                $querystring .= '&filter_batch_date_to=' . $this->request->post['filter_batch_date_to'];
            }

            if (isset($this->request->post['filter_batch_date_from'])) {
                $querystring .= '&filter_batch_date_from=' . $this->request->post['filter_batch_date_from'];
            }

            if (isset($this->request->post['filter_category']))
                $querystring .= '&filter_category='  . implode(",", $this->request->post['filter_category']);

            $this->response->redirect($this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getList();
    }

    public function getList()
    {
        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = '';
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = '';
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $filter_doc_no = $this->request->get['filter_doc_no'];
        } else {
            $filter_doc_no = '';
        }

        if (isset($this->request->get['filter_remark'])) {
            $filter_remark = $this->request->get['filter_remark'];
        } else {
            $filter_remark = '';
        }

        if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

        if (isset($this->request->get['filter_location_id'])) {
            $filter_location_id = $this->request->get['filter_location_id'];
        } else {
            $filter_location_id = '';
        }

        if (isset($this->request->get['filter_product_name'])) {
            $filter_product_name = $this->request->get['filter_product_name'];
        } else {
            $filter_product_name = '';
        }

        if (isset($this->request->get['filter_product_code'])) {
            $filter_product_code = $this->request->get['filter_product_code'];
        } else {
            $filter_product_code = '';
        }


        if (isset($this->request->get['filter_batch_date_from'])) {
            $filter_batch_date_from = $this->request->get['filter_batch_date_from'];
        } else {
            $filter_batch_date_from = '';
        }

        if (isset($this->request->get['filter_batch_date_to'])) {
            $filter_batch_date_to = $this->request->get['filter_batch_date_to'];
        } else {
            $filter_batch_date_to = '';
        }

        if (isset($this->request->get['filter_add_by'])) {
            $filter_add_by = $this->request->get['filter_add_by'];
        } else {
            $filter_add_by = '';
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = '';
        }

        if (isset($this->request->get['filter_category'])) {
            $filter_category = $this->request->get['filter_category'];
        } else {
            $filter_category = '';
        }


        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'date_modified';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'DESC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $url .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_location_id'])) {
            $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }
        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }
        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }
        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }
        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }
        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }
        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }

        //**breadcrumbs
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['user_token'] = $this->session->data['user_token'];

        //**
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        //**filter memory
        $data['filter_doc_no'] = isset($this->request->get['filter_doc_no']) ? $this->request->get['filter_doc_no'] : "";
        $data['filter_add_by'] = isset($this->request->get['filter_add_by']) ? $this->request->get['filter_add_by'] : "";
        $data['filter_date_from_memory'] = isset($this->request->get['filter_date_from']) ? $this->request->get['filter_date_from'] : "";
        $data['filter_date_to_memory'] = isset($this->request->get['filter_date_to']) ? $this->request->get['filter_date_to'] : "";

        $data['filter_status'] = isset($this->request->get['filter_status']) ? explode(",",$this->request->get['filter_status']) : array();

        $data['filter_category'] = isset($this->request->get['filter_category']) ? explode(",",$this->request->get['filter_category']) : array();

        $data['filter_store_id'] = isset($this->request->get['filter_store_id']) ? explode(",",$this->request->get['filter_store_id']) : array();

        $data['filter_location_memory'] = isset($this->request->get['filter_location_id']) ? explode(",",$this->request->get['filter_location_id']) : array();

        $data['filter_product_name_memory'] = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : "";

        $data['filter_product_id_memory'] = isset($this->request->get['filter_product_id']) ? $this->request->get['filter_product_id'] : "";

        $data['filter_product_code_memory'] = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : "";

        $data['filter_batch_date_to_memory'] = isset($this->request->get['filter_batch_date_to']) ? $this->request->get['filter_batch_date_to'] : "";

        $data['filter_batch_date_from_memory'] = isset($this->request->get['filter_batch_date_from']) ? $this->request->get['filter_batch_date_from'] : "";
        $data['filter_remark_memory'] = isset($this->request->get['filter_remark']) ? $this->request->get['filter_remark'] : "";





        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }
        $querystring = '';

        if (isset($this->request->get['filter_doc_no'])) {
            $querystring .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_status'])) {
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_category'])) {
            $querystring .= '&filter_category=' . $this->request->get['filter_category'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_location_id'])) {
            $querystring .= '&filter_location_id=' . $this->request->get['filter_location_id'];
        }

        if (isset($this->request->get['filter_product_id'])) {
            $querystring .= '&filter_product_id=' . $this->request->get['filter_product_id'];
        }

        if (isset($this->request->get['filter_product_code'])) {
            $querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }

        if (isset($this->request->get['filter_batch_date_to'])) {
            $querystring .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }

        if (isset($this->request->get['filter_batch_date_from'])) {
            $querystring .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $querystring .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if ($order == 'ASC') {
            $querystring .= '&order=DESC';
        } else {
            $querystring .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        $data['sort_invoice_prefix'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $querystring, true);
        $data['sort_product_name'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=product_name' . $querystring, true);
        $data['sort_product_code'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=product_code' . $querystring, true);
        $data['sort_qty'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=qty' . $querystring, true);
        $data['sort_batch_date'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=batch_date' . $querystring, true);
        $data['sort_location'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=location' . $querystring, true);
        $data['sort_remark'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=remark' . $querystring, true);
        $data['sort_add_by'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=add_by' . $querystring, true);
        $data['sort_date_added'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added_2' . $querystring, true);
        $data['sort_status'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $querystring, true);
        $data['sort_category'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=category' . $querystring, true);
        $data['sort_description'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=description' . $querystring, true);
        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $url .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_location_id'])) {
            $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }
        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }
        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }
        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }
        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }
        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }


        // $data['filter'] = $this->url->link('catalog/stock_adjustment/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $data['add'] = $this->url->link('catalog/stock_adjustment/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("catalog/stock_adjustment/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_doc_no' => $filter_doc_no,
            'filter_add_by' => $filter_add_by,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_product_name' => $filter_product_name,
            'filter_product_code' => $filter_product_code,
            'filter_location_id' => $filter_location_id,
            'filter_store_id' => $filter_store_id,
            'filter_batch_date_from' => $filter_batch_date_from,
            'filter_batch_date_to' => $filter_batch_date_to,
            'filter_remark' => $filter_remark,
            'filter_status' => $filter_status,
            'filter_category' => $filter_category,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['filter_data'] = $filter_data;

        $data['user_view'] = $this->user->user_view;

        //put here 
        $data['batch_dates'] = $this->model_catalog_stock_adjustment->getAllStockAdjustmentBatchDates();
        $data['staffs'] = $this->model_catalog_stock_adjustment->getStaffs();

        if ($this->user->user_view == 1) {
            $data['locations'] = $this->model_catalog_stock_adjustment->getAllLocations();
        } else {
            $data['locations'] = $this->model_catalog_stock_adjustment->getLocations();
        }

        $data['statuses'] = array();
        $statuses = $this->model_catalog_stock_adjustment->getStatus();


        foreach ($statuses as $status) {
            $data['statuses'][] = array(
                'order_status_id' => $status['order_status_id'],
                'name' => $status['name']
            );
        }

        $data['categories'] = array();
        $categories = $this->model_catalog_stock_adjustment->getCategories();


        foreach ($categories as $category) {
            $data['categories'][] = array(
                'category_id' => $category['category_id'],
                'name' => $category['name']
            );
        }
        // var_dump($data['status']);
        // die();

        $this->load->model('setting/store');
        $data['stores'] = array();

        $sname = $this->config->get('config_name');

        $data['stores'][] = array(
            'store_id' => 0,
            'name' => $sname . $this->language->get('text_default')
        );

        $stores = $this->model_setting_store->getStores();


        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }


        $data['stockAdjustments'] = array();

        $stockAdjustmentList = $this->model_catalog_stock_adjustment->getStockAdjustmentList($filter_data);

 
            foreach ($stockAdjustmentList as $stockAdjustment) {


                $data['stockAdjustments'][] = array(
                    'stock_adjustment_id' => $stockAdjustment['stock_adjustment_id'],
                    'stock_adjustment_item_id' => $stockAdjustment['stock_adjustment_item_id'],
                    'date_added' => date('Y-m-d', strtotime($stockAdjustment['date_added'])),
                    'invoice_prefix' => $stockAdjustment['invoice_prefix'],
                    'product_id' => $stockAdjustment['product_id'],
                    'product_name' => $stockAdjustment['product_name'],
                    'product_code' => $stockAdjustment['product_code'],
                    'category' => $stockAdjustment['category'],
                    'qty' => $stockAdjustment['qty'],
                    'batch_date' => $stockAdjustment['batch_date'],
                    'location' => $stockAdjustment['location'],
                    'location_id' => $stockAdjustment['location_id'],
                    'description' => $stockAdjustment['description'],
                    'stock_onhand' => $stockAdjustment['onhand'],
                    'stock_balance' => $stockAdjustment['balance'],
                    'action' => $stockAdjustment['action'],
                    'add_by' => $stockAdjustment['add_by'],
                    'remark' => $stockAdjustment['remark'],
                    'status' => $stockAdjustment['status'],
                    'store_id' => $stockAdjustment['store_id'],
                    'sname' => $stockAdjustment['store_name'],
                    'date_modified' => date('Y-m-d H:iA', strtotime($stockAdjustment['date_modified'])),
                    'modify_by' => $stockAdjustment['modified_by'],
                    'info' => $this->url->link('catalog/stock_adjustment/info', 'user_token=' . $this->session->data['user_token'] . '&stock_adjustment_id=' . $stockAdjustment['stock_adjustment_id'] . $querystring, true),
                    'print' => $this->url->link('catalog/stock_adjustment/printForm', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&stock_adjustment_id=' . $stockAdjustment['stock_adjustment_id'], true),
                    'edit' => $this->url->link('catalog/stock_adjustment/edit', 'user_token=' . $this->session->data['user_token'] . '&stock_adjustment_id=' . $stockAdjustment['stock_adjustment_id'] . $querystring, true),
                    'export' => $this->url->link('catalog/stock_adjustment/export_excel', 'user_token=' . $this->session->data['user_token'] . '&stock_adjustment_id=' . $stockAdjustment['stock_adjustment_id'], true)
                );
            }
        

        $this->load->model('service/service_form');
        
        $data['stock_adjustment_status'] = $this->model_service_service_form->serviceFormStatusList();
        $total_stock_adjustment = $this->model_catalog_stock_adjustment->totalStockAdjustment($filter_data);

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_doc_no'])) {
            $url .= '&filter_doc_no=' . $this->request->get['filter_doc_no'];
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . $this->request->get['filter_remark'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_location_id'])) {
            $url .= '&filter_location_id=' . $this->request->get['filter_location_id'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }
        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }
        if (isset($this->request->get['filter_batch_date_from'])) {
            $url .= '&filter_batch_date_from=' . $this->request->get['filter_batch_date_from'];
        }
        if (isset($this->request->get['filter_batch_date_to'])) {
            $url .= '&filter_batch_date_to=' . $this->request->get['filter_batch_date_to'];
        }
        if (isset($this->request->get['filter_add_by'])) {
            $url .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }
        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }
        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }

        $data['barcode_link'] = $this->url->link('catalog/stock_adjustment/printProductStickers', 'user_token=' . $this->session->data['user_token'] . '&type=barcode' . $url, true);
        $data['export_excel_all'] = $this->url->link('catalog/stock_adjustment/export_excel_all', 'user_token=' . $this->session->data['user_token'], true);
        $data['export_excel_searched'] = $this->url->link('catalog/stock_adjustment/export_excel_searched', 'user_token=' . $this->session->data['user_token']. $url, true);

        $pagination = new Pagination();
        $pagination->total = $total_stock_adjustment;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_stock_adjustment) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_stock_adjustment - $this->config->get('config_limit_admin'))) ? $total_stock_adjustment : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_stock_adjustment, ceil($total_stock_adjustment / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $data['store_name'] = $this->config->get('config_name');
        $data['page'] = ($page - 1) * $this->config->get('config_limit_admin');
        

        $this->response->setOutput($this->load->view('catalog/stock_adjustment_list', $data));
    }

    public function getForm()
    {

        $data['user_token'] = $this->session->data['user_token'];

        $store_id = $this->session->data['store_id'];

        if (isset($this->request->get['stock_adjustment_id'])) {
            $stock_adjustment_info = $this->model_catalog_stock_adjustment->getStockAdjustment($this->request->get['stock_adjustment_id']);
            $data["form_memory_invoice_prefix"] = $stock_adjustment_info['invoice_prefix'];
            $data['stock_adjustment_id'] = $this->request->get['stock_adjustment_id'];
        } else {
            $data["form_memory_invoice_prefix"] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_adjustment', 'store' => $store_id));
            $data['stock_adjustment_id'] = 0;
        }

        if ($this->request->server['REQUEST_METHOD'] == 'POST') {
            $data["current_date"] = isset($this->request->post['date_added']) ? $this->request->post['date_added'] : date('Y-m-d');
            $form_memory_stock_adjustment_items = isset($this->request->post['stock_adjustment_item']) ?
                $this->request->post['stock_adjustment_item'] :
                array();
            $data["form_memory_stock_adjustment_items"] = $form_memory_stock_adjustment_items;
            $data['description'] = $this->request->post['description'];
      
        } elseif (!empty($stock_adjustment_info)) {
            $empty_product = array(
                array(
                    'stock_adjustment_item_id' => 0,
                    'name' => '',
                    'product_id' => '',
                    'code' => '',
                    'onhand_quantity' => '',
                    'qty' => '',
                    'action' => '',
                    'weight_class_id' => '',
                    'location_id' => '',
                    'location' => 0,
                    'remark' => ''
                )
            );
            $data["current_date"] = $stock_adjustment_info['date_added'];
            $data["form_memory_stock_adjustment_items"] = isset($stock_adjustment_info['stock_adjustment_item']) ? $stock_adjustment_info['stock_adjustment_item'] : $empty_product;
            $data['description'] = $stock_adjustment_info['description'];
            
        } else {
            $data["current_date"] = date('Y-m-d');
            $data["form_memory_stock_adjustment_items"] = array();
            $data['description'] = '';
        }
        foreach ($data["form_memory_stock_adjustment_items"] as $item) {

            $data['locationlist'] = $this->model_catalog_stock_adjustment->getlocationfulllist($this->request->get['stock_adjustment_id']);
            if (!empty($item['product_id'])) {
                $data['locations'][$item['product_id']] = $this->model_catalog_stock_adjustment->getLocationList($item['product_id']);
                 $data['batchDates'][$item['product_id']][$item['location_id']] = $this->model_catalog_stock_adjustment->getBatchDateList($item['product_id'], $item['location_id']);
            }
        }
       

        
       

        $data["form_memory_current_date"] = date('d/m/Y h:i A');


        //Get Location List
        // $data['locations'] = $this->model_catalog_stock_adjustment->getLocations();
        $data['weight_classes'] = $this->model_catalog_stock_adjustment->getWeightClasses();

        //**text
        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_form'] = !(isset($this->request->get['stock_adjustment_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');


        //**sitemap data
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'], true)
        );

        //**query string
        $querystring = '';

        if (isset($this->request->get['sort'])) {
            $querystring .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $querystring .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $querystring .= '&page=' . $this->request->get['page'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $querystring .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_add_by'])) {
            $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_status'])) {
            $querystring .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        //**urls
        $data['cancel'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        if (isset($this->request->get['stock_adjustment_id']))
            $querystring .= '&stock_adjustment_id=' . $this->request->get['stock_adjustment_id'];
        $action_mode = !(isset($this->request->get['stock_adjustment_id'])) ? 'add' : 'edit';
        $data['action'] = $this->url->link("catalog/stock_adjustment/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        // if (isset($this->request->post['description'])) {
        //     $data['description'] = $this->request->post['description'];
        // } else {
        //     $data['description'] = '';
        // }

        $data['stock_adjustment_item'] = isset($this->request->post['stock_adjustment_item']) ? $this->request->post['stock_adjustment_item'] : 0;

        $this->load->model('service/service_form');
        $data['stock_adjustment_status'] = $this->model_service_service_form->serviceFormStatusList();

        //**error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_product_id'] = isset($this->error['product_id']) ? $this->error['product_id'] : NULL;
        $data['error_product_qty'] = isset($this->error['product_qty']) ? $this->error['product_qty'] : NULL;
        $data['error_product_loc'] = isset($this->error['product_location']) ? $this->error['product_location'] : NULL;

        $data['user_token'] = $this->session->data['user_token'];

        //**load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');


        $this->response->setOutput($this->load->view('catalog/stock_adjustment_form', $data));
    }

    public function getEditForm()
    {
        $store_id = $this->session->data['store_id'];

        //load default model
        $this->load->model('catalog/stock_adjustment');

        $stock_adjustment_id = isset($this->request->get['stock_adjustment_id']) ? $this->request->get['stock_adjustment_id'] : 0;

        $stock_adjustment_info = $this->model_catalog_stock_adjustment->getStockAdjustment($stock_adjustment_id);


        if ($stock_adjustment_info) {
            //**text
            $data['heading_title'] = $this->language->get('heading_title');
            $data['text_form'] = !(isset($this->request->get['stock_adjustment_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

            //**sitemap data
            $data['breadcrumbs'] = array();
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'], true)
            );

            $stock_adjustment_item = $stock_adjustment_info['stock_adjustment_item'];

            foreach ($stock_adjustment_item as $product_id => $product) {
                if ($product['action'] == 1) {
                    $stock_adjustment_item[$product_id]['action'] = $this->language->get('text_qty_add');
                } else if ($product['action'] == 0) {
                    $stock_adjustment_item[$product_id]['action'] = $this->language->get('text_qty_deduct');
                }
            }

            //**data
            $data['invoice_prefix'] = $stock_adjustment_info['invoice_prefix'];
            $data['date_added'] = date('d-m-Y h:i A', strtotime($stock_adjustment_info['date_added']));
            //$data['staff'] = $stock_adjustment_info['staff'];

            $data['stock_adjustment_item'] = $stock_adjustment_item;

            //**query string
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_invoice_prefix']))
                $querystring .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];

            if (isset($this->request->get['filter_add_by']))
                $querystring .= '&filter_add_by=' . $this->request->get['filter_add_by'];

            if (isset($this->request->get['filter_date_from']))
                $querystring .= '&filter_date_from=' . $this->request->get['filter_date_from'];

            if (isset($this->request->get['filter_date_to']))
                $querystring .= '&filter_date_to=' . $this->request->get['filter_date_to'];

            if (isset($this->request->get['filter_status']))
                $querystring .= '&filter_status=' . $this->request->get['filter_status'];

            if (isset($this->request->get['filter_store_id']))
                $querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];


            //**urls
            $data['cancel'] = $this->url->link('catalog/stock_adjustment', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

            if (isset($this->request->get['stock_adjustment_id']))
                $querystring .= '&stock_adjustment_id=' . $this->request->get['stock_adjustment_id'];
            $action_mode = !(isset($this->request->get['stock_adjustment_id'])) ? 'add' : 'edit';
            $data['action'] = $this->url->link("catalog/stock_adjustment/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

            if (isset($this->request->post['description'])) {
                $data['description'] = $this->request->post['description'];
            } else if (isset($this->request->get['stock_adjustment_id'])) {
                $data['description'] = $stock_adjustment_info['description'];
            } else {
                $data['description'] = '';
            }

            //**error
            $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
            $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;

            $data['user_token'] = $this->session->data['user_token'];

            //**load template module
            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('catalog/stock_adjustment_edit_form', $data));
        }
    }

    public function autocomplete()
    {
        $json = array();

        if (isset($this->request->get['name'])) {
            $this->load->model('catalog/stock_adjustment');

            if (isset($this->request->get['name'])) {
                $product_name = $this->request->get['product_name'];
            } else {
                $product_name = '';
            }

            $results = $this->model_catalog_stock_transfer->getProductByName($product_name);

            foreach ($results as $result) {
                $json[] = array(
                    'product_id' => $result['product_id'],
                    'name' => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
                    'code' => $result['code'],
                    'onhand_quantity' => $result['onhand_quantity']
                );
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    protected function validateForm()
    {

        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_adjustment') && !$this->user->userpermission('modify', 'catalog/stock_adjustment'))
            $this->error['warning'] = $this->language->get('error_permission');

        $stock_adjustment_item = isset($this->request->post['stock_adjustment_item']) ? $this->request->post['stock_adjustment_item'] : false;

        if ($stock_adjustment_item) {

            $products_id_list = array();
            $batch_date_list = array();
            $location_id_list = array();

            foreach ($stock_adjustment_item as $row_id => $product) {
                $product_id = $product['product_id'];
                $product_id = trim($product_id);
                $batch_date = !empty($product['batch_date']) ? $product['batch_date'] : 0000-00-00 ;
                $location_id = isset($product['location_id']) ? $product['location_id'] : 0;
                if (empty($product_id)) {
                    $this->error['product_id'][$row_id] = $this->language->get('error_product');
                } else {
                    if (in_array($product_id  , $products_id_list)) {
                        if(in_array($location_id , $location_id_list)){
                            if(in_array($batch_date , $batch_date_list)){
                                $this->error['product_id'][$row_id] = $this->language->get('error_product_duplicate');
                            }
                        }
                    }
                  
                    $products_id_list[] = $product_id;
                    $batch_date_list[] = $batch_date;
                    $location_id_list[]= $location_id;
                }

                // $qty = $product['qty'];
                // $qty = trim($qty);
                // if (!is_numeric($qty)) {
                //     $this->error['product_qty'][$row_id] = $this->language->get('error_qty');
                // } else {
                //     if ($qty <= 0) {
                //          [$row_id] = $this->language->get('error_qty');
                //     }

                //     $onhand_quantity = $product['onhand_quantity'];
                //     $onhand_quantity = trim($onhand_quantity);
                //     $action = $product['action'];

                //     if (!empty($onhand_quantity) && $action == 0) {
                //         if ($qty > $onhand_quantity) {
                //             $this->error['product_qty'][$row_id] = $this->language->get('error_qty_over');
                //         }
                //     }
                // }
                if (!is_numeric($location_id)) {
                    $this->error['product_location'][$row_id] = $this->language->get('error_location');
                }
            }
        } else {
            $this->error['warning'] = $this->language->get('error_empty_stock_adjustment');;
        }

        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDelete()
    {
        if (!$this->user->hasPermission('delete', 'catalog/stock_adjustment') && !$this->user->userpermission('delete', 'catalog/stock_adjustment')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }


    public function getLocationList()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        if ($product_id) {
            $this->load->model('catalog/stock_adjustment');
            $locationList = $this->model_catalog_stock_adjustment->getLocationList($product_id);
            $def_wcid = $this->model_catalog_stock_adjustment->getweightClassProduct($product_id);
            $json = array(
                'success' => true,
                'locationList' => $locationList,
                'def_wcid' => $def_wcid,
            );
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function getBatchDateList()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $location_id = (isset($this->request->post['location_id'])) ? $this->request->post['location_id'] : 0;

        if ($product_id) {
            $this->load->model('catalog/stock_adjustment');
            $batchDateList = $this->model_catalog_stock_adjustment->getBatchDateList($product_id, $location_id);
            $json = array(
                'success' => true,
                'list' => $batchDateList,
            );
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }
    public function getStockOnhand()
    {
        $json = array('success' => false, 'qty' => '-');

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $location_id = (isset($this->request->post['location_id'])) ? $this->request->post['location_id'] : 0;
        $batch_date = (isset($this->request->post['batch_date'])) ? $this->request->post['batch_date'] : '0000-00-00';
        if ($product_id) {
            $this->load->model('catalog/stock_adjustment');
            $stock = $this->model_catalog_stock_adjustment->getStockOnhand($product_id, $location_id, $batch_date);
            $json = array(
                'success' => true,
                'qty' => $stock,
            );
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function getDefaultLocationAndWeightClassId()
    {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

        if ($product_id) {
            $this->load->model('catalog/stock_adjustment');
            $locationList = $this->model_catalog_stock_adjustment->getLocationList($product_id);
            $def_wcid = $this->model_catalog_stock_adjustment->getweightClassProduct($product_id);
            $json = array(
                'success' => true,
                'locationList' => $locationList,
                'def_wcid' => $def_wcid,
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    protected function validateDesc()
    {
        //permission checking
        if (!$this->user->hasPermission('modify', 'catalog/stock_adjustment') && !$this->user->userpermission('modify', 'catalog/stock_adjustment')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['description'])) {
            $this->error['description'] = $this->language->get('error_description');
        }





        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function insertProductToDatabase()
    {

        $this->load->language('catalog/stock_adjustment');
        $this->load->model('catalog/stock_adjustment');

        $json = [];
        $error = false;

        $stock_adjustment_id = !empty($this->request->post['stock_adjustment_id']) ? $this->request->post['stock_adjustment_id'] : 0;

        $product_id = !empty($this->request->post['product_id']) ? $this->request->post['product_id'] : 0;


        if (empty($stock_adjustment_id)) {
            $error = true;
        }


        if (empty($product_id)) {
            $error = true;
        }



        if (empty($error)) {
            $result = $this->model_catalog_stock_adjustment->addStockAdjustmentProduct($this->request->post);

            $json['stock_adjustment_item_id'] = !empty($result['id']) ? $result['id'] : 0;
            $json['stock_onhand'] = !empty($result['stock_onhand']) ? $result['stock_onhand'] : 0;
            $json['success'] = !empty($result) ? true : false;
        } else {
            $json['errors'][] = [
                'error' => 'missing_product_data',
                'msg'   => $this->language->get('error_missing_product_data')
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function updateProductToDatabase()
    {

        $this->load->language('catalog/stock_adjustment');
        $this->load->model('catalog/stock_adjustment');

        $json = [];
        $error = false;

        $stock_adjustment_item_id = !empty($this->request->post['stock_adjustment_item_id']) ? $this->request->post['stock_adjustment_item_id'] : 0;

        $product_id = !empty($this->request->post['product_id']) ? $this->request->post['product_id'] : 0;



        if (empty($stock_adjustment_item_id)) {
            $error = true;
        }



        if (empty($product_id)) {
            $error = true;
        }



        if (empty($error)) {

            $result = $this->model_catalog_stock_adjustment->editStockAdjustmentProduct($this->request->post);

            $json['stock_adjustment_item_id'] = !empty($result['id']) ? $result['id'] : 0;
            $json['stock_onhand'] = !empty($result['stock_onhand']) ? $result['stock_onhand'] : 0;
            $json['success'] = !empty($result) ? true : false;
        } else {

            $json['errors'][] = [

                'error' => 'missing_product_data',

                'msg'   => $this->language->get('error_missing_product_data')

            ];
        }



        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));
    }

    public function deleteProductFromDatabase()
    {

        $this->load->language('catalog/stock_adjustment');
        $this->load->model('catalog/stock_adjustment');

        $json = [];
        $error = false;

        $stock_adjustment_item_id = !empty($this->request->post['stock_adjustment_item_id']) ? $this->request->post['stock_adjustment_item_id'] : 0;



        if (empty($stock_adjustment_item_id)) {
            $error = true;
        }

        if (empty($error)) {

            $this->model_catalog_stock_adjustment->deleteStockAdjustmentProduct($stock_adjustment_item_id);

            $json['stock_adjustment_item_id'] = !empty($stock_adjustment_item_id) ? $stock_adjustment_item_id : 0;

            $json['success'] = !empty($stock_adjustment_item_id) ? true : false;
        } else {

            $json['errors'][] = [

                'error' => 'missing_product_data',

                'msg'   => $this->language->get('error_missing_product_data')

            ];
        }



        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));
    }
}
