<?php
class ControllerCatalogScanProduction extends Controller {
    private $error = [];

    public function index() {
        $this->load->language('catalog/scan_production');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/scan_production');
        
        $this->getForm();
    }
    
    public function get_order_product() {
        $json = [];
        $return_data = [];
        $return_product_materials = [];
        $return_product_serials = [];

        $this->load->language('catalog/scan_production');
        $this->load->model('catalog/scan_production');

        if (isset($this->request->post['order_product'])) {
            $order_product = $this->request->post['order_product'];
            $order_product_string = base64_decode($order_product);
            $order_product_arr = explode('_', $order_product_string);
            $order_product_id = isset($order_product_arr[2]) ? $order_product_arr[2] : false;

            if ($order_product_id) {
                $order_product_info = $this->model_catalog_scan_production->get_order_product($order_product_id);
                $order_product_serials = $this->model_catalog_scan_production->get_order_product_serials($order_product_id);

                // echo '<pre>';
                // print_r($order_product_id);
                // echo '</pre>';

                if (!empty($order_product_info)) {
                    $product_materials = $this->model_catalog_scan_production->get_product_material($order_product_info['product_id']);

                    $order_quantity = (int)$order_product_info['quantity'];

                    if (!empty($product_materials)) {
                        foreach ($product_materials as $material) {
                            $return_product_materials[] = [
                                'material_id'       => $material['metarial_id'],
                                'material_name'     => $material['material_name'],
                                'used_quantity'     => $material['used_quantity'] * $order_quantity
                            ];
                        }
                    }

                    if (!empty($order_product_serials)) {
                        foreach ($order_product_serials as $serial) {
                            $return_product_serials[] = [
                                'material_id'       => $serial['material_id'],
                                'material_name'     => $serial['material_name'],
                                'quantity'          => $serial['quantity'],
                                'serial_num'        => $serial['serial_num']
                            ];
                        }
                    }

                    $warning_product_materials = !empty($return_product_materials) ? '' : sprintf($this->language->get('text_add_product_material'), $order_product_info['name']);

                    $return_data = [
                        'order_product_id'              => $order_product_id,
                        'order_id'                      => $order_product_info['order_id'],
                        'order_url'                     => $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $order_product_info['order_id'], true),
                        'product_id'                    => $order_product_info['product_id'],
                        'product_url'                   => $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $order_product_info['product_id'], true),
                        'product_name'                  => $order_product_info['name'],
                        'model'                         => $order_product_info['model'],
                        'order_quantity'                => $order_quantity,
                        'product_materials'             => $return_product_materials,
                        'warning_product_materials'     => $warning_product_materials,
                        'scanned_materials'             => $return_product_serials
                    ];

                    $json = [
                        'error'     => false,
                        'data'      => $return_data,
                        'message'   => 'get order produuct success'
                    ];
                }
            } else {
                $json = [
                    'error'     => true,
                    'message'   => 'invalid order product id'
                ];
            }           
        } else {
            $json = [
                'error'     => true,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    public function scan_packaging() {
        $json = [];
        $order_product_materials = [];
        $order_product_materials_arr = [];
        $return_product_serials = [];
        $already_scan = true;

        $this->load->model('catalog/scan_production');

        $packaging = isset($this->request->post['packaging']) ? $this->request->post['packaging'] : false;
        $order_product_id = isset($this->request->post['order_product_id']) ? $this->request->post['order_product_id'] : false;

        if ($packaging && $order_product_id) {
            $packaging_string = base64_decode($packaging);
            $packaging_arr = explode('_', $packaging_string);
            $packaging_id = isset($packaging_arr[1]) ? $packaging_arr[1] : false;

            if ($packaging_id) {
                $packaging_materials = $this->model_catalog_scan_production->get_packaging_materials($packaging_id);
                $order_product_info = $this->model_catalog_scan_production->get_order_product($order_product_id);

                $product_id = !empty($order_product_info) ? $order_product_info['product_id'] : 0;
                $purchased_quantity = !empty($order_product_info) ? $order_product_info['quantity'] : 0;

                if ($product_id > 0) {
                    $product_materials = $this->model_catalog_scan_production->get_product_material($product_id);

                    if (!empty($product_materials)) {
                        foreach ($product_materials as $material) {
                            $order_product_materials[] = [
                                'material_id'       => $material['metarial_id'],
                                'used_quantity'     => $material['used_quantity'] * $purchased_quantity
                            ];

                            $order_product_materials_arr[] = $material['metarial_id'];
                        }
                    }
                }

                if (!empty($packaging_materials)) {
                    foreach ($packaging_materials as $material) {
                        $production_id = $material['production_id'];

                        $material_production_info = $this->model_catalog_scan_production->get_material_production($production_id);

                        if (!empty($material_production_info)) {
                            $material_id = $material_production_info['product_id'];

                            $check_serial_order_product = $this->model_catalog_scan_production->check_order_product_serial($order_product_id, $packaging_id, $material_id);

                            if (empty($check_serial_order_product)) {
                                $double_check_scanned = $this->model_catalog_scan_production->check_order_product_serial_by_material($material_id, $order_product_id);

                                $total_double_check = 0;

                                if (!empty($double_check_scanned)) {
                                    foreach ($double_check_scanned as $scanned_product) {
                                        $total_double_check += $scanned_product['quantity'];
                                    }
                                }

                                if ($material['quantity'] > $total_double_check) {
                                    if (in_array($material_id, $order_product_materials_arr)) {
                                        $already_scan = false;

                                        $insert_data = [
                                            'packaging_id'      => $packaging_id,
                                            'order_product_id'  => $order_product_id,
                                            'material_id'       => $material_id,
                                            'quantity'          => $material['quantity'],
                                            'production_id'     => $production_id
                                        ];
            
                                        $this->model_catalog_scan_production->add_order_product_serial($insert_data);
                                    }                                    
                                }                                
                            } else {
                                $total_scanned_products = 0;

                                foreach ($check_serial_order_product as $product) {
                                    $total_scanned_products += $product['quantity'];
                                }

                                foreach ($order_product_materials as $material_row) {
                                    if ($material_row['material_id'] == $material_id) {
                                        if ($material_row['used_quantity'] > $total_scanned_products) {
                                            $already_scan = false;
            
                                            $insert_data = [
                                                'packaging_id'      => $packaging_id,
                                                'order_product_id'  => $order_product_id,
                                                'material_id'       => $material_id,
                                                'quantity'          => $material['quantity'],
                                                'production_id'     => $production_id
                                            ];
                
                                            $this->model_catalog_scan_production->add_order_product_serial($insert_data);
                                        }
                                    }                                    
                                }
                            }        
                        }
                    }
                }

                $order_product_serials = $this->model_catalog_scan_production->get_order_product_serials($order_product_id);

                if (!empty($order_product_serials)) {
                    foreach ($order_product_serials as $serial) {
                        $return_product_serials[] = [
                            'material_id'       => $serial['material_id'],
                            'material_name'     => $serial['material_name'],
                            'quantity'          => $serial['quantity'],
                            'serial_num'        => $serial['serial_num']
                        ];
                    }
                }

                if ($already_scan) {
                    $json = [
                        'error'     => false,
                        'scanned'   => $already_scan,
                        'data'      => $return_product_serials,
                        'message'   => 'the packaging already scanned'
                    ];
                } else {
                    $json = [
                        'error'     => false,
                        'scanned'   => $already_scan,
                        'data'      => $return_product_serials,
                        'message'   => 'scan packaging success'
                    ];
                }                
            } else {
                $json = [
                    'error'     => true,
                    'message'   => 'invalid packaging id'
                ];
            }
        } else {
            $json = [
                'error'     => true,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    public function complete_order() {
        $json = [];

        $this->load->model('catalog/scan_production');

        $order_status_id = isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false;
        $order_id = isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false;

        if ($order_status_id && $order_id) {
            $this->model_catalog_scan_production->complete_order_scan($order_id, $order_status_id);

            $json = [
                'error'     => false,
                'message'   => 'success complete order'
            ];
        } else {
            $json = [
                'error'     => true,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    protected function getForm() {
        $url = '';
        
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/scan_production', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        $data['selected_order_status'] = 15;

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('catalog/scan_production_form', $data));
    }
}
?>