<?php
class ControllerCatalogProductionMachine extends Controller{
    private $error = [];

    public function index() {
        $this->load->language('catalog/production_machine');        

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production_machine');

        $this->getList();
    }

    public function add() {
        $this->load->language('catalog/production_machine');        

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production_machine');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_catalog_production_machine->addProductionMachine($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

            $url = '';
            
            if (isset($this->request->get['filter_start_last_maintenance_date'])) {
                $url .= '&filter_start_last_maintenance_date=' . $this->request->get['filter_start_last_maintenance_date'];
            }
    
            if (isset($this->request->get['filter_end_last_maintenance_date'])) {
                $url .= '&filter_end_last_maintenance_date=' . $this->request->get['filter_end_last_maintenance_date'];
            }
    
            if (isset($this->request->get['filter_machine_name'])) {
                $url .= '&filter_machine_name=' . $this->request->get['filter_machine_name'];
            }
    
            if (isset($this->request->get['filter_machine_serial_num'])) {
                $url .= '&filter_machine_serial_num=' . $this->request->get['filter_machine_serial_num'];
            }
    
            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }
    
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }
    
            $this->response->redirect($this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('catalog/production_machine');        

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production_machine');

        if (!isset($this->request->get['production_machine_id'])) {
            $this->response->redirect($this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'], true));
        }

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_catalog_production_machine->editProductionMachine($this->request->post, $this->request->get['production_machine_id']);

			$this->session->data['success'] = $this->language->get('text_success');

            $url = '';
            
            if (isset($this->request->get['filter_start_last_maintenance_date'])) {
                $url .= '&filter_start_last_maintenance_date=' . $this->request->get['filter_start_last_maintenance_date'];
            }
    
            if (isset($this->request->get['filter_end_last_maintenance_date'])) {
                $url .= '&filter_end_last_maintenance_date=' . $this->request->get['filter_end_last_maintenance_date'];
            }
    
            if (isset($this->request->get['filter_machine_name'])) {
                $url .= '&filter_machine_name=' . $this->request->get['filter_machine_name'];
            }
    
            if (isset($this->request->get['filter_machine_serial_num'])) {
                $url .= '&filter_machine_serial_num=' . $this->request->get['filter_machine_serial_num'];
            }
    
            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }
    
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }
    
            $this->response->redirect($this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }
        
        $this->getForm();
    }
    
    public function delete() {
        $this->load->language('catalog/production_machine');        

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/production_machine');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $production_machine_id) {
                $this->model_catalog_production_machine->deleteProductionMachine($production_machine_id);
			}

            $this->session->data['success'] = $this->language->get('text_success');
            
            $url = '';
            
            if (isset($this->request->get['filter_start_last_maintenance_date'])) {
                $url .= '&filter_start_last_maintenance_date=' . $this->request->get['filter_start_last_maintenance_date'];
            }
    
            if (isset($this->request->get['filter_end_last_maintenance_date'])) {
                $url .= '&filter_end_last_maintenance_date=' . $this->request->get['filter_end_last_maintenance_date'];
            }
    
            if (isset($this->request->get['filter_machine_name'])) {
                $url .= '&filter_machine_name=' . $this->request->get['filter_machine_name'];
            }
    
            if (isset($this->request->get['filter_machine_serial_num'])) {
                $url .= '&filter_machine_serial_num=' . $this->request->get['filter_machine_serial_num'];
            }
    
            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }
    
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }
    
            $this->response->redirect($this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    public function get_maintenance_history() {
        $json = [];
        $history_data = [];

        $this->load->model('catalog/production_machine');

        $production_machine_id = isset($this->request->post['production_machine_id']) ? $this->request->post['production_machine_id'] : false;

        if ($production_machine_id) {
            $histories = $this->model_catalog_production_machine->getProductionMachineMaintenances($production_machine_id);

            if (!empty($histories)) {
                foreach ($histories as $history) {
                    $history_data[] = [
                        'maintenance_date'  => date($this->language->get('date_format_short'), strtotime($history['maintenance_date'])),
                        'remark'            => nl2br($history['remark'])
                    ];
                }
            }

            $json = [
                'error'     => false,
                'data'      => $history_data,
                'message'   => 'get history success'
            ];
        } else {
            $json = [
                'error'     => true,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    public function add_machine_maintenance() {
        $json = [];
        $error_data = [];

        $this->load->language('catalog/production_machine');
        $this->load->model('catalog/production_machine');

        $maintenance_date = isset($this->request->post['maintenance_date']) ? $this->request->post['maintenance_date'] : false;
        $remark = isset($this->request->post['remark']) ? $this->request->post['remark'] : '';
        $production_machine_id = isset($this->request->post['production_machine_id']) ? $this->request->post['production_machine_id'] : false;

        if ($maintenance_date && $production_machine_id) {
            $post_data = [
                'production_machine_id'     => $production_machine_id,
                'remark'                    => $remark,
                'maintenance_date'          => $maintenance_date
            ];

            $pmm_id = $this->model_catalog_production_machine->addProductionMachineMaintenance($post_data);

            if ($pmm_id > 0) {
                $json = [
                    'error'         => false,
                    'success_data'  => $this->language->get('text_success_add_maintenance'),
                    'message'       => 'add machine maintenance success'
                ];
            } else {
                $json = [
                    'error'         => true,
                    'message'       => 'cannot add production machine maintenance'
                ];
            }
        } else {
            if (!$maintenance_date) {
                $error_data['error_maintenance_date'] = $this->language->get('error_maintenance_date');
            }

            $json = [
                'error'         => true,
                'error_data'    => $error_data,
                'message'       => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    protected function getList() {
        if (isset($this->request->get['filter_start_last_maintenance_date'])) {
            $filter_start_last_maintenance_date = $this->request->get['filter_start_last_maintenance_date'];
        } else {
            $filter_start_last_maintenance_date = '';
        }

        if (isset($this->request->get['filter_end_last_maintenance_date'])) {
            $filter_end_last_maintenance_date = $this->request->get['filter_end_last_maintenance_date'];
        } else {
            $filter_end_last_maintenance_date = '';
        }

        if (isset($this->request->get['filter_machine_name'])) {
            $filter_machine_name = $this->request->get['filter_machine_name'];
        } else {
            $filter_machine_name = '';
        }

        if (isset($this->request->get['filter_machine_serial_num'])) {
            $filter_machine_serial_num = $this->request->get['filter_machine_serial_num'];
        } else {
            $filter_machine_serial_num = '';
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'date_added';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_start_last_maintenance_date'])) {
            $url .= '&filter_start_last_maintenance_date=' . $this->request->get['filter_start_last_maintenance_date'];
        }

        if (isset($this->request->get['filter_end_last_maintenance_date'])) {
            $url .= '&filter_end_last_maintenance_date=' . $this->request->get['filter_end_last_maintenance_date'];
        }

        if (isset($this->request->get['filter_machine_name'])) {
            $url .= '&filter_machine_name=' . $this->request->get['filter_machine_name'];
        }

        if (isset($this->request->get['filter_machine_serial_num'])) {
            $url .= '&filter_machine_serial_num=' . $this->request->get['filter_machine_serial_num'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );
        
        $data['production_machines'] = [];

        $filter_data = array(
            'filter_start_last_maintenance_date'    => $filter_start_last_maintenance_date,
            'filter_end_last_maintenance_date'      => $filter_end_last_maintenance_date,
            'filter_machine_name'                   => $filter_machine_name,
            'filter_machine_serial_num'             => $filter_machine_serial_num,
            'filter_status'                         => $filter_status,
            'sort'                                  => $sort,
            'order'                                 => $order
        );

        $start = ($page - 1) * $this->config->get('config_limit_admin');
        $limit = $this->config->get('config_limit_admin');

        $results = $this->model_catalog_production_machine->getProductionMachines($filter_data);

        $total_production_machines = count($results);

        if (!empty($results)) {
            foreach ($results as $result) {
                $last_maintenance_date = !empty($result['last_maintenance_date']) ? date($this->language->get('date_format_short'), strtotime($result['last_maintenance_date'])) : '-';

                $data['production_machines'][] = [
                    'production_machine_id'     => $result['production_machine_id'],
                    'machine_name'              => $result['machine_name'],
                    'machine_serial_num'        => $result['machine_serial_num'],
                    'status'                    => ($result['status'] == '1') ? $this->language->get('text_enabled') : $this->language->get('text_disabled'),
                    'date_added'                => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    'last_maintenance_date'     => $last_maintenance_date,
                    'edit'                      => $this->url->link('catalog/production_machine/edit', 'user_token=' . $this->session->data['user_token'] . '&production_machine_id=' . $result['production_machine_id'], true)
                ];
            }
        }

        $data['production_machines'] = array_slice($data['production_machines'], $start, $limit);

        $data['add'] = $this->url->link('catalog/production_machine/add', 'user_token=' . $this->session->data['user_token'], true);
        $data['delete'] = $this->url->link('catalog/production_machine/delete', 'user_token=' . $this->session->data['user_token'], true);

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = [];
        }

        $url = '';

        if (isset($this->request->get['filter_start_last_maintenance_date'])) {
            $url .= '&filter_start_last_maintenance_date=' . $this->request->get['filter_start_last_maintenance_date'];
        }

        if (isset($this->request->get['filter_end_last_maintenance_date'])) {
            $url .= '&filter_end_last_maintenance_date=' . $this->request->get['filter_end_last_maintenance_date'];
        }

        if (isset($this->request->get['filter_machine_name'])) {
            $url .= '&filter_machine_name=' . $this->request->get['filter_machine_name'];
        }

        if (isset($this->request->get['filter_machine_serial_num'])) {
            $url .= '&filter_machine_serial_num=' . $this->request->get['filter_machine_serial_num'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        // sort
        $data['sort_production_machine_id'] = $this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'] . '&sort=production_machine_id' . $url, true);
        $data['sort_machine_name'] = $this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'] . '&sort=machine_name' . $url, true);
        $data['sort_machine_serial_num'] = $this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'] . '&sort=machine_serial_num' . $url, true);
        $data['sort_status'] = $this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);
        $data['sort_last_maintenance_date'] = $this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'] . '&sort=last_maintenance_date' . $url, true);
        $data['sort_date_added'] = $this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $url, true);

        $pagination = new Pagination();
        $pagination->total = $total_production_machines;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_production_machines) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_production_machines - $this->config->get('config_limit_admin'))) ? $total_production_machines : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_production_machines, ceil($total_production_machines / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['filter_start_last_maintenance_date'] = $filter_start_last_maintenance_date;
        $data['filter_end_last_maintenance_date'] = $filter_end_last_maintenance_date;
        $data['filter_machine_name'] = $filter_machine_name;
        $data['filter_machine_serial_num'] = $filter_machine_serial_num;
        $data['filter_status'] = $filter_status;

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('catalog/production_machine_list', $data));
    }

    protected function getForm() {
        $data['text_form'] = isset($this->request->get['production_machine_id']) ? $this->language->get('text_edit') : $this->language->get('text_add');

        $production_machine_info = isset($this->request->get['production_machine_id']) ? $this->model_catalog_production_machine->getProductionMachine($this->request->get['production_machine_id']) : [];

        if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['machine_name'])) {
			$data['error_machine_name'] = $this->error['machine_name'];
		} else {
			$data['error_machine_name'] = '';
		}

		if (isset($this->error['machine_serial_num'])) {
			$data['error_machine_serial_num'] = $this->error['machine_serial_num'];
		} else {
			$data['error_machine_serial_num'] = '';
        }
        
        $url = '';

        if (isset($this->request->get['filter_start_last_maintenance_date'])) {
            $url .= '&filter_start_last_maintenance_date=' . $this->request->get['filter_start_last_maintenance_date'];
        }

        if (isset($this->request->get['filter_end_last_maintenance_date'])) {
            $url .= '&filter_end_last_maintenance_date=' . $this->request->get['filter_end_last_maintenance_date'];
        }

        if (isset($this->request->get['filter_machine_name'])) {
            $url .= '&filter_machine_name=' . $this->request->get['filter_machine_name'];
        }

        if (isset($this->request->get['filter_machine_serial_num'])) {
            $url .= '&filter_machine_serial_num=' . $this->request->get['filter_machine_serial_num'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['edit_machine'] = isset($this->request->get['production_machine_id']) ? true : false;

        $data['action'] = isset($this->request->get['production_machine_id']) ? $this->url->link('catalog/production_machine/edit', 'user_token=' . $this->session->data['user_token'] . '&production_machine_id=' . $this->request->get['production_machine_id'], true) : $this->url->link('catalog/production_machine/add', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('catalog/production_machine', 'user_token=' . $this->session->data['user_token'], true);

        if (isset($this->request->post['machine_name'])) {
			$data['machine_name'] = $this->request->post['machine_name'];
		} elseif (!empty($production_machine_info)) {
			$data['machine_name'] = $production_machine_info['machine_name'];
		} else {
			$data['machine_name'] = '';
        }

        if (isset($this->request->post['machine_serial_num'])) {
			$data['machine_serial_num'] = $this->request->post['machine_serial_num'];
		} elseif (!empty($production_machine_info)) {
			$data['machine_serial_num'] = $production_machine_info['machine_serial_num'];
		} else {
			$data['machine_serial_num'] = '';
        }
        
        if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (!empty($production_machine_info)) {
			$data['status'] = $production_machine_info['status'];
		} else {
			$data['status'] = 1;
        }
        
        $data['user_token'] = $this->session->data['user_token'];

        $data['production_machine_id'] = isset($this->request->get['production_machine_id']) ? $this->request->get['production_machine_id'] : false;

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('catalog/production_machine_form', $data));
    }

    protected function validateForm() {
        if (!$this->user->hasPermission('modify', 'catalog/production_machine')) {
			$this->error['warning'] = $this->language->get('error_permission');
        }
        
        if (empty($this->request->post['machine_name'])) {
            $this->error['machine_name'] = $this->language->get('error_machine_name');
        }

        if (empty($this->request->post['machine_serial_num'])) {
            $this->error['machine_serial_num'] = $this->language->get('error_machine_serial_num');
        }

		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('modify', 'catalog/production_machine')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
    }
}
?>