<?php
class ControllerCatalogProductSellEtcm extends Controller {
    private $error = array();

    public function index(){
        $this->load->language('catalog/product_sell_etcm');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/product_sell_etcm');

		$this->getList();
    }

    protected function getList(){
        if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = null;
		}

        if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = null;
		}

        if (isset($this->request->get['filter_product_price'])) {
			$filter_product_price = $this->request->get['filter_product_price'];
		} else {
			$filter_product_price = null;
		}

        if (isset($this->request->get['filter_product_wholesale_price'])) {
			$filter_product_wholesale_price = $this->request->get['filter_product_wholesale_price'];
		} else {
			$filter_product_wholesale_price = null;
		}

        if (isset($this->request->get['filter_product_quantity'])) {
			$filter_product_quantity = $this->request->get['filter_product_quantity'];
		} else {
			$filter_product_quantity = null;
		}

        if (isset($this->request->get['filter_product_status'])) {
			$filter_product_status = $this->request->get['filter_product_status'];
		} else {
			$filter_product_status = null;
		}

        if (isset($this->request->get['filter_product_wholesale_status'])) {
			$filter_product_wholesale_status = $this->request->get['filter_product_wholesale_status'];
		} else {
			$filter_product_wholesale_status = null;
		}

        if (isset($this->request->get['filter_publish_status'])) {
            $filter_publish_status = $this->request->get['filter_publish_status'];
        } else {
            $filter_publish_status = null;
        }

        if (isset($this->request->get['filter_publish_wholesale_status'])) {
            $filter_publish_wholesale_status = $this->request->get['filter_publish_wholesale_status'];
        } else {
            $filter_publish_wholesale_status = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'p.product_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . urlencode(html_entity_decode($this->request->get['filter_product_name'], ENT_QUOTES, 'UTF-8'));
		}

        if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . urlencode(html_entity_decode($this->request->get['filter_product_code'], ENT_QUOTES, 'UTF-8'));
		}

        if (isset($this->request->get['filter_product_price'])) {
			$url .= '&filter_product_price=' . urlencode(html_entity_decode($this->request->get['filter_product_price'], ENT_QUOTES, 'UTF-8'));
		}

        if (isset($this->request->get['filter_product_wholesale_price'])) {
            $url .= '&filter_product_wholesale_price=' . urlencode(html_entity_decode($this->request->get['filter_product_wholesale_price'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_product_quantity'])) {
			$url .= '&filter_product_quantity=' . urlencode(html_entity_decode($this->request->get['filter_product_quantity'], ENT_QUOTES, 'UTF-8'));
		}

        if (isset($this->request->get['filter_product_status'])) {
			$url .= '&filter_product_status=' . urlencode(html_entity_decode($this->request->get['filter_product_status'], ENT_QUOTES, 'UTF-8'));
		}

        if (isset($this->request->get['filter_product_wholesale_status'])) {
			$url .= '&filter_product_wholesale_status=' . urlencode(html_entity_decode($this->request->get['filter_product_wholesale_status'], ENT_QUOTES, 'UTF-8'));
		}

        if (isset($this->request->get['filter_publish_status'])) {
			$url .= '&filter_publish_status=' . urlencode(html_entity_decode($this->request->get['filter_publish_status'], ENT_QUOTES, 'UTF-8'));
		}

        if (isset($this->request->get['filter_publish_wholesale_status'])) {
            $url .= '&filter_publish_wholesale_status=' . urlencode(html_entity_decode($this->request->get['filter_publish_wholesale_status'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

        $data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

        $data['products'] = array();

        $filter_data = array(
            'filter_product_name'                 => $filter_product_name,
            'filter_product_code'                 => $filter_product_code,
            'filter_product_price'                => $filter_product_price,
            'filter_product_wholesale_price'      => $filter_product_wholesale_price,
            'filter_product_quantity'             => $filter_product_quantity,
            'filter_product_status'               => $filter_product_status,
            'filter_product_wholesale_status'     => $filter_product_wholesale_status,
            'filter_publish_status'               => $filter_publish_status,
            'filter_publish_wholesale_status'     => $filter_publish_wholesale_status,
            'sort'                                => $sort,
            'order'                               => $order,
            'start'                               => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit'                               => $this->config->get('config_limit_admin')
        );

        $products = $this->model_catalog_product_sell_etcm->getProducts($filter_data);
        $total_products = $this->model_catalog_product_sell_etcm->getTotalProducts($filter_data);

        if(!empty($products)){
            foreach($products as $product){
                if($product['status'] == ''){
                    $status_color = 'warning';
                    $etcm_product_status = $this->language->get('text_not_selling');

                    $enable_sell_product = 1;
                } else{
                    switch($product['status']){
                        case '0':
                            $status_color = 'warning';
                            $etcm_product_status = $this->language->get('text_pending');
                            break;
                        case '1':
                            $status_color = 'success';
                            $etcm_product_status = $this->language->get('text_approved');
                            break;
                        case '2':
                            $status_color = 'danger';
                            $etcm_product_status = $this->language->get('text_rejected');
                            break;
                    }

                    $enable_sell_product = 0;
                }

                if($product['wholesale_status'] == ''){
                    $wholesale_status_color = 'warning';
                    $etcm_wholesale_product_status = $this->language->get('text_not_selling');

                    $enable_wholesale_product = 1;
                } else{
                    switch($product['wholesale_status']){
                        case '0':
                            $wholesale_status_color = 'warning';
                            $etcm_wholesale_product_status = $this->language->get('text_pending');
                            break;
                        case '1':
                            $wholesale_status_color = 'success';
                            $etcm_wholesale_product_status = $this->language->get('text_approved');
                            break;
                        case '2':
                            $wholesale_status_color = 'danger';
                            $etcm_wholesale_product_status = $this->language->get('text_rejected');
                            break;
                    }

                    $enable_wholesale_product = 0;
                }

                if($product['publish_status'] == ''){
                    $publish_status = '-';
                } else{
                    $publish_status = ($product['publish_status'] == 0) ? $this->language->get('text_disabled') : $this->language->get('text_enabled');
                }

                if($product['wholesale_publish_status'] == ''){
                    $wholesale_publish_status = '-';
                } else{
                    $wholesale_publish_status = ($product['wholesale_publish_status'] == 0) ? $this->language->get('text_disabled') : $this->language->get('text_enabled');
                }

                $wholesale_price = empty($product['wholesale_price']) ? '0.00' : $product['wholesale_price'];
                $special_wholesale_price = empty($product['special_price']) ? '0.00' : $product['special_price'];
                $product_quantity = !empty($product['onhand_quantity']) ? $product['onhand_quantity'] : '0.00';

                $data['products'][] = array(
                    'product_id'                    => $product['product_id'],
                    'product_name'                  => $product['name'],
                    'product_code'                  => $product['code'],
                    'product_price'                 => $this->currency->format($product['price'], $this->config->get('config_currency')),
                    'wholesale_price'               => $this->currency->format($wholesale_price, $this->config->get('config_currency')),
                    'special_price_switch'          => $product['special_price_switch'],
                    'special_wholesale_price'       => $this->currency->format($special_wholesale_price , $this->config->get('config_currency')),
                    'product_quantity'              => $product_quantity,
                    'status'                        => $product['status'],
                    'wholesale_status'              => $product['wholesale_status'],
                    'product_status'                => $etcm_product_status,
                    'product_wholesale_status'      => $etcm_wholesale_product_status,
                    'status_color'                  => $status_color,
                    'wholesale_status_color'        => $wholesale_status_color,
                    'enable_sell_product'           => $enable_sell_product,
                    'enable_wholesale_product'      => $enable_wholesale_product,
                    'publish_status_id'             => $product['publish_status'],
                    'wholesale_publish_status_id'   => $product['wholesale_publish_status'],
                    'publish_status'                => $publish_status,
                    'wholesale_publish_status'      => $wholesale_publish_status,
                    'import'                        => $this->url->link('catalog/product_sell_etcm/import','user_token=' . $this->session->data['user_token'] . '&product_id=' . $product['product_id'],true),
                    'import_wholesale'              => $this->url->link('catalog/product_sell_etcm/import_wholesale','user_token=' . $this->session->data['user_token'] . '&product_id=' . $product['product_id'],true),
                    'view'                          => $this->url->link('catalog/product_sell_etcm/info', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $product['product_id'], true),
                    'publish'                       => $this->url->link('catalog/product_sell_etcm/publish', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $product['product_id'], true),
                    'publish_wholesale'             => $this->url->link('catalog/product_sell_etcm/publish_wholesale', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $product['product_id'], true),
                    'unpublish'                     => $this->url->link('catalog/product_sell_etcm/unpublish', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $product['product_id'], true),
                    'unpublish_wholesale'           => $this->url->link('catalog/product_sell_etcm/unpublish_wholesale', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $product['product_id'], true)
                );
            }
        }

        $language_arr = array('heading_title', 'text_list', 'button_filter', 'entry_product_name', 'entry_product_code', 'entry_product_price', 'entry_product_quantity', 'column_product_name', 'column_product_code', 'column_product_wholesale_quantity', 'column_product_price', 'text_no_results', 'column_product_status', 'entry_product_status', 'text_not_selling', 'text_pending', 'text_approved', 'text_rejected', 'column_action', 'button_import', 'button_view', 'column_product_publish_status', 'entry_publish_status', 'text_enabled', 'text_disabled', 'button_publish', 'button_unpublish', 'entry_product_wholesale_price', 'entry_publish_wholesale_status', 'entry_product_wholesale_status', 'column_product_wholesale_publish_status', 'column_product_wholesale_price', 'column_product_wholesale_status', 'button_import_wholesale', 'button_unpublish_wholesale', 'button_publish_wholesale');

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

        $url = '';

		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . urlencode(html_entity_decode($this->request->get['filter_product_name'], ENT_QUOTES, 'UTF-8'));
		}

        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . urlencode(html_entity_decode($this->request->get['filter_product_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_product_price'])) {
            $url .= '&filter_product_price=' . urlencode(html_entity_decode($this->request->get['filter_product_price'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_product_wholesale_price'])) {
            $url .= '&filter_product_wholesale_price=' . urlencode(html_entity_decode($this->request->get['filter_product_wholesale_price'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_product_quantity'])) {
            $url .= '&filter_product_quantity=' . urlencode(html_entity_decode($this->request->get['filter_product_quantity'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_product_status'])) {
            $url .= '&filter_product_status=' . urlencode(html_entity_decode($this->request->get['filter_product_status'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_product_wholesale_status'])) {
            $url .= '&filter_product_wholesale_status=' . urlencode(html_entity_decode($this->request->get['filter_product_wholesale_status'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_publish_status'])) {
            $url .= '&filter_publish_status=' . urlencode(html_entity_decode($this->request->get['filter_publish_status'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_publish_wholesale_status'])) {
            $url .= '&filter_publish_wholesale_status=' . urlencode(html_entity_decode($this->request->get['filter_publish_wholesale_status'], ENT_QUOTES, 'UTF-8'));
        }

        if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

        $data['sort_name'] = $this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.name' . $url, true);
        $data['sort_code'] = $this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'] . '&sort=p.code' . $url, true);
        $data['sort_price'] = $this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'] . '&sort=p.price' . $url, true);
        $data['sort_quantity'] = $this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'] . '&sort=pwe.quantity' . $url, true);
        $data['sort_wholesale_price'] = $this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'] . '&sort=pwe.price' . $url, true);

        $url = '';

		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . urlencode(html_entity_decode($this->request->get['filter_product_name'], ENT_QUOTES, 'UTF-8'));
		}

        if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . urlencode(html_entity_decode($this->request->get['filter_product_code'], ENT_QUOTES, 'UTF-8'));
		}

        if (isset($this->request->get['filter_product_price'])) {
            $url .= '&filter_product_price=' . $this->request->get['filter_product_price'];
        }

        if (isset($this->request->get['filter_product_wholesale_price'])) {
            $url .= '&filter_product_wholesale_price=' . $this->request->get['filter_product_wholesale_price'];
        }

        if (isset($this->request->get['filter_product_quantity'])) {
            $url .= '&filter_product_quantity=' . $this->request->get['filter_product_quantity'];
        }

        if (isset($this->request->get['filter_product_status'])) {
            $url .= '&filter_product_status=' . $this->request->get['filter_product_status'];
        }

        if (isset($this->request->get['filter_product_wholesale_status'])) {
            $url .= '&filter_product_wholesale_status=' . $this->request->get['filter_product_wholesale_status'];
        }

        if (isset($this->request->get['filter_publish_status'])) {
            $url .= '&filter_publish_status=' . $this->request->get['filter_publish_status'];
        }

        if (isset($this->request->get['filter_publish_wholesale_status'])) {
            $url .= '&filter_publish_wholesale_status=' . $this->request->get['filter_publish_wholesale_status'];
        }

        if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

        $pagination = new Pagination();
        $pagination->total = $total_products;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_products) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_products - $this->config->get('config_limit_admin'))) ? $total_products : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_products, ceil($total_products / $this->config->get('config_limit_admin')));

        $data['filter_product_name']  = $filter_product_name;
        $data['filter_product_code']  = $filter_product_code;
        $data['filter_product_price']  = $filter_product_price;
        $data['filter_product_wholesale_price'] = $filter_product_wholesale_price;
        $data['filter_product_quantity']  = $filter_product_quantity;
        $data['filter_product_status']  = $filter_product_status;
        $data['filter_product_wholesale_status'] = $filter_product_wholesale_status;
        $data['filter_publish_status']  = $filter_publish_status;
        $data['filter_publish_wholesale_status'] = $filter_publish_wholesale_status;

        $data['user_token'] = $this->session->data['user_token'];
        $data['sort'] = $sort;

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('catalog/product_sell_etcm_list', $data));
    }

    public function import(){
        $this->load->model('catalog/product_sell_etcm');
        $this->load->language('catalog/product_sell_etcm');

        $this->document->setTitle($this->language->get('text_form'));

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            // add into database
            $this->model_catalog_product_sell_etcm->addProductSellEtcm($this->request->post, $this->request->get['product_id']);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'],true));
        }

        if(isset($this->request->get['product_id'])){
            $product_id = $this->request->get['product_id'];
            $product_sell_etcm = $this->model_catalog_product_sell_etcm->getSellEtcmProduct($product_id);

            if(!empty($product_sell_etcm)){
                $this->response->redirect($this->url->link('catalog/product_sell_etcm','user_token=' . $this->session->data['user_token'], true));
            }
        } else{
            $this->response->redirect($this->url->link('catalog/product_sell_etcm','user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm();
    }

    public function import_wholesale(){
        $this->load->model('catalog/product_sell_etcm');
        $this->load->model('localisation/weight_class');
        $this->load->model('localisation/language');
        $this->load->model('tool/image');
        $this->load->language('catalog/product_sell_etcm');

        $this->document->setTitle($this->language->get('text_form_wholesale'));

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateFormWholesale()) {
            $product_wholesale_etcm_id = $this->model_catalog_product_sell_etcm->addProductWholesaleEtcm($this->request->post, $this->request->get['product_id']);

            // add wholesale price log
            $product_info = $this->model_catalog_product_sell_etcm->getProductByProductId($this->request->get['product_id']);

            if(!empty($product_info)){
                $this->model_catalog_product_sell_etcm->addPriceLog($this->request->post, $product_wholesale_etcm_id);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'],true));
        }

        if(!isset($this->request->get['product_id'])){
            $this->response->redirect($this->url->link('catalog/product_sell_etcm','user_token=' . $this->session->data['user_token'], true));
        }

        $this->getImportWholesaleForm();
    }

    public function edit(){
        $this->load->model('catalog/product_sell_etcm');
        $this->load->language('catalog/product_sell_etcm');

        $this->document->setTitle($this->language->get('text_edit_form'));

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            // get product sell etcm id
            $product_id = $this->request->get['product_id'];
            $product_sell_etcm = $this->model_catalog_product_sell_etcm->getSellEtcmProduct($product_id);

            $product_sell_etcm_id = $product_sell_etcm['product_sell_etcm_id'];

            // update
            $this->model_catalog_product_sell_etcm->updateEtcmCategory($this->request->post['etcm_category_id'], $product_sell_etcm_id);

            $this->session->data['success'] = $this->language->get('text_success_edit');

            $this->response->redirect($this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'],true));
        }

        if(isset($this->request->get['product_id'])){
            $product_id = $this->request->get['product_id'];
            $product_sell_etcm = $this->model_catalog_product_sell_etcm->getSellEtcmProduct($product_id);

            if(empty($product_sell_etcm)){
                $this->response->redirect($this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'], true));
            }
        } else{
            $this->response->redirect($this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm();
    }

    public function edit_wholesale(){
        $this->load->model('catalog/product_sell_etcm');
        $this->load->model('localisation/weight_class');
        $this->load->model('localisation/language');
        $this->load->model('tool/image');
        $this->load->language('catalog/product_sell_etcm');

        $this->document->setTitle($this->language->get('text_edit_form_wholesale'));

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateFormWholesale()) {
            // get product wholesale etcm id
            $product_id = $this->request->get['product_id'];
            $product_wholesale_etcm = $this->model_catalog_product_sell_etcm->getWholesaleEtcmProduct($product_id);

            $product_wholesale_etcm_id = $product_wholesale_etcm['product_wholesale_etcm_id'];

            // update
            $this->model_catalog_product_sell_etcm->updateWholesaleProduct($this->request->post, $product_wholesale_etcm_id, $product_id);

            $product_info = $this->model_catalog_product_sell_etcm->getProductByProductId($product_id);

            if(!empty($product_info)){
                $this->model_catalog_product_sell_etcm->addPriceLog($this->request->post, $product_wholesale_etcm_id);
            }

            $this->session->data['success'] = $this->language->get('text_success_edit_wholesale');

            $this->response->redirect($this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'],true));
        }

        if(isset($this->request->get['product_id'])){
            $product_id = $this->request->get['product_id'];
            $product_wholesale_etcm = $this->model_catalog_product_sell_etcm->getWholesaleEtcmProduct($product_id);

            if(empty($product_wholesale_etcm)){
                $this->response->redirect($this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'], true));
            }
        } else{
            $this->response->redirect($this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getImportWholesaleForm();
    }

    protected function getForm(){
        if(isset($this->request->get['product_id'])){
            $product_id = $this->request->get['product_id'];

            $product_sell_etcm = $this->model_catalog_product_sell_etcm->getSellEtcmProduct($product_id);

            if(!empty($product_sell_etcm)){
                $url = HTTP_API . 'index.php?route=product/category/getProductCategoryETCM&category_id=' . $product_sell_etcm['etcm_category_id'];

                $etcm_category_info = file_get_contents($url);

                $etcm_category_info_arr = json_decode($etcm_category_info,true);
            }
        }

        $url = '';

        $data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

        $language_arr = array('heading_title', 'text_form', 'button_save', 'button_cancel', 'entry_etcm_category', 'column_product_name', 'column_product_code', 'column_product_price', 'column_product_quantity');

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

        if (isset($this->error['etcm_category'])) {
			$data['error_etcm_category'] = $this->error['etcm_category'];
		} else {
			$data['error_etcm_category'] = '';
		}

        if(isset($this->request->post['etcm_category'])){
            $data['etcm_category'] = $this->request->post['etcm_category'];
        } elseif(!empty($product_sell_etcm)){
            $data['etcm_category'] = $etcm_category_info_arr['name'];
        } else{
            $data['etcm_category'] = '';
        }

        if(isset($this->request->post['etcm_category_id'])){
            $data['etcm_category_id'] = $this->request->post['etcm_category_id'];
        } elseif(!empty($product_sell_etcm)){
            $data['etcm_category_id'] = $etcm_category_info_arr['category_id'];
        } else{
            $data['etcm_category_id'] = '';
        }

        if($this->request->get['route'] == 'catalog/product_sell_etcm/edit'){
            $data['action'] = $this->url->link('catalog/product_sell_etcm/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'], true);
        } else{
            $data['action'] = $this->url->link('catalog/product_sell_etcm/import', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'], true);
        }

        $data['cancel'] = $this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'],true);

        $product_info = $this->model_catalog_product_sell_etcm->getProductByProductId($this->request->get['product_id']);

        if(!empty($product_info)){
            $data['product'] = [
                'product_name'      => $product_info['name'],
                'product_code'      => $product_info['code'],
                'product_price'     => $this->currency->format($product_info['price'], $this->config->get('config_currency')),
                'product_stock'     => $product_info['onhand_quantity']
            ];
        }

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$data['curl_etcm'] = HTTP_API;

		$this->response->setOutput($this->load->view('catalog/product_sell_etcm_form', $data));
    }

    protected function getImportWholesaleForm(){
        if(isset($this->request->get['product_id'])){
            $product_id = $this->request->get['product_id'];

            $product_wholesale_etcm = $this->model_catalog_product_sell_etcm->getWholesaleEtcmProduct($product_id);

            if(!empty($product_wholesale_etcm)){
                if($product_wholesale_etcm['etcm_category_id'] > 0){
                    $url = HTTP_API . 'index.php?route=product/category/getProductCategoryETCM&category_id=' . $product_wholesale_etcm['etcm_category_id'];

                    $etcm_category_info = file_get_contents($url);

                    $etcm_category_info_arr = json_decode($etcm_category_info,true);
                } else{
                    $etcm_category_info_arr = [
                        'category_id'   => 0,
                        'name'          => ''
                    ];
                }
            }
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $language_arr = ['button_cancel', 'heading_title', 'text_form_wholesale', 'button_save', 'entry_etcm_wholesale_category', 'entry_product_wholesale_price', 'column_weight_limit', 'column_promotion_price', 'button_add', 'entry_weight_limit', 'entry_promotion_price', 'button_remove', 'column_product_name', 'column_product_code', 'entry_weight_class', 'entry_wholesale_quantity', 'text_special_wholesale_price', 'entry_date_start', 'entry_date_end', 'entry_enable_special_price', 'text_yes', 'text_no', 'tab_general', 'tab_product_images', 'tab_product_description', 'entry_description', 'entry_image', 'entry_sort_order', 'button_image_add'];

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

        if (isset($this->error['etcm_category'])) {
            $data['error_etcm_category'] = $this->error['etcm_category'];
        } else {
            $data['error_etcm_category'] = '';
        }

        if (isset($this->error['wholesale_quantity'])) {
            $data['error_wholesale_quantity'] = $this->error['wholesale_quantity'];
        } else {
            $data['error_wholesale_quantity'] = '';
        }

        if (isset($this->error['wholesale_price'])) {
            $data['error_wholesale_price'] = $this->error['wholesale_price'];
        } else {
            $data['error_wholesale_price'] = '';
        }

        if (isset($this->error['special_wholesale_price'])) {
            $data['error_special_wholesale_price'] = $this->error['special_wholesale_price'];
        } else {
            $data['error_special_wholesale_price'] = '';
        }

        if(isset($this->request->post['etcm_category'])){
            $data['etcm_category'] = $this->request->post['etcm_category'];
        } elseif(!empty($product_wholesale_etcm)){
            $data['etcm_category'] = $etcm_category_info_arr['name'];
        } else{
            $data['etcm_category'] = '';
        }

        if(isset($this->request->post['etcm_category_id'])){
            $data['etcm_category_id'] = $this->request->post['etcm_category_id'];
        } elseif(!empty($product_wholesale_etcm)){
            $data['etcm_category_id'] = $etcm_category_info_arr['category_id'];
        } else{
            $data['etcm_category_id'] = '';
        }

        if(isset($this->request->post['weight_class_id'])){
            $data['weight_class_id'] = $this->request->post['weight_class_id'];
        } elseif(!empty($product_wholesale_etcm)){
            $data['weight_class_id'] = $product_wholesale_etcm['weight_class_id'];
        } else{
            $data['weight_class_id'] = '';
        }

        if(isset($this->request->post['wholesale_quantity'])){
            $data['wholesale_quantity'] = $this->request->post['wholesale_quantity'];
        } elseif(!empty($product_wholesale_etcm)){
            $data['wholesale_quantity'] = $product_wholesale_etcm['quantity'];
        } else{
            $data['wholesale_quantity'] = '';
        }

        if(isset($this->request->post['wholesale_price'])){
            $data['wholesale_price'] = $this->request->post['wholesale_price'];
        } elseif(!empty($product_wholesale_etcm)){
            $data['wholesale_price'] = $product_wholesale_etcm['price'];
        } else{
            $data['wholesale_price'] = '';
        }

        if(isset($this->request->post['enable_special_price'])){
            $data['enable_special_price'] = $this->request->post['enable_special_price'];
        } elseif(!empty($product_wholesale_etcm)){
            $data['enable_special_price'] = $product_wholesale_etcm['special_price_switch'];
        } else{
            $data['enable_special_price'] = '';
        }

        if (isset($this->request->post['special_wholesale_price'])) {
			$data['special_wholesale_price'] = $this->request->post['special_wholesale_price'];
		} else if(!empty($product_wholesale_etcm)) {
			$data['special_wholesale_price'] = $product_wholesale_etcm['special_price'];
		} else {
			$data['special_wholesale_price'] = '';
		}

        if (isset($this->request->post['date_start'])) {
			$data['date_start'] = $this->request->post['date_start'];
		} else if(!empty($product_wholesale_etcm)) {
			$data['date_start'] = $product_wholesale_etcm['special_date_start'];
		} else {
			$data['date_start'] = '';
		}

        if (isset($this->request->post['date_end'])) {
			$data['date_end'] = $this->request->post['date_end'];
		} else if(!empty($product_wholesale_etcm)) {
			$data['date_end'] = $product_wholesale_etcm['special_date_end'];
		} else {
			$data['date_end'] = '';
		}

        if (isset($this->request->post['product_description'])) {
			$data['product_description'] = $this->request->post['product_description'];
		} elseif (isset($this->request->get['product_id'])) {
			$data['product_description'] = $this->model_catalog_product_sell_etcm->getProductDescriptions($this->request->get['product_id']);
		} else {
			$data['product_description'] = array();
		}

        if (isset($this->request->post['product_image'])) {
			$product_images = $this->request->post['product_image'];
		} elseif (isset($this->request->get['product_id'])) {
			$product_images = $this->model_catalog_product_sell_etcm->getProductImages($this->request->get['product_id']);
		} else {
			$product_images = array();
		}

		$data['product_images'] = array();

		foreach ($product_images as $product_image) {
			if (is_file(DIR_IMAGE . $product_image['image'])) {
				$image = $product_image['image'];
				$thumb = $product_image['image'];
			} else {
				$image = '';
				$thumb = 'no_image.png';
			}

			$data['product_images'][] = array(
				'image'      => $image,
				'thumb'      => $this->model_tool_image->resize($thumb, 100, 100),
				'sort_order' => $product_image['sort_order']
			);
		}

        $data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

        if($this->request->get['route'] == 'catalog/product_sell_etcm/edit_wholesale'){
            $data['action'] = $this->url->link('catalog/product_sell_etcm/edit_wholesale', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'], true);
        } else{
            $data['action'] = $this->url->link('catalog/product_sell_etcm/import_wholesale', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'], true);
        }

        $product_info = $this->model_catalog_product_sell_etcm->getProductByProductId($this->request->get['product_id']);

        if(!empty($product_info)){
            $data['product'] = [
                'product_name'          => $product_info['name'],
                'product_code'          => $product_info['code']
            ];
        }

        if($this->request->server['REQUEST_METHOD'] == 'POST'){
            $weight_class_id_default = $this->request->post['weight_class_id'];
        } elseif(!empty($product_wholesale_etcm)){
            $weight_class_id_default = $product_wholesale_etcm['weight_class_id'];
        } else{
            $weight_class_id_default = $this->config->get('config_weight_class_id');
        }

        $default_weight_class_info = $this->model_localisation_weight_class->getWeightClass($weight_class_id_default);

        $data['weight_class_name'] = !empty($default_weight_class_info) ? $default_weight_class_info['title'] : '';

        $data['weight_classes'] = $this->model_localisation_weight_class->getWeightClasses();
        $data['languages'] = $this->model_localisation_language->getLanguages();

        $data['cancel'] = $this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('catalog/product_wholesale_etcm_form', $data));
    }

    public function info(){
        $this->load->language('catalog/product_sell_etcm');
        $this->load->model('catalog/product_sell_etcm');
        $this->load->model('localisation/weight_class');

        $this->document->setTitle($this->language->get('heading_title'));

        if(isset($this->request->get['product_id'])){
            $product_id = $this->request->get['product_id'];

            $data['product'] = array();

            $product_etcm = $this->model_catalog_product_sell_etcm->getSellEtcmProduct($product_id);
            $product_wholesale_etcm = $this->model_catalog_product_sell_etcm->getWholesaleEtcmProduct($product_id);

            if(!empty($product_etcm) || !empty($product_wholesale_etcm)){
                $product_info = $this->model_catalog_product_sell_etcm->getProductByProductId($product_id);
                $product_images = $this->model_catalog_product_sell_etcm->getProductImages($product_id);

                $product_image_results = [];

                if(!empty($product_info)){
                    $product_status_id = !is_null($product_info['status']) ? $product_info['status'] : NULL;
                    $product_wholesale_status_id = $product_info['wholesale_status'];

                    if(!is_null($product_status_id)){
                        switch($product_status_id){
                            case '0':
                                $product_status = $this->language->get('text_pending');
                                $status_color = 'warning';
                                break;
                            case '1':
                                $product_status = $this->language->get('text_approved');
                                $status_color = 'success';
                                break;
                            case '2':
                                $product_status = $this->language->get('text_rejected');
                                $status_color = 'danger';
                                break;
                        }
                    } else{
                        $product_status = '';
                        $status_color = '';
                    }

                    if(!is_null($product_wholesale_status_id)){
                        switch($product_wholesale_status_id){
                            case '0':
                                $product_wholesale_status = $this->language->get('text_pending');
                                $wholesale_status_color = 'warning';
                                break;
                            case '1':
                                $product_wholesale_status = $this->language->get('text_approved');
                                $wholesale_status_color = 'success';
                                break;
                            case '2':
                                $product_wholesale_status = $this->language->get('text_rejected');
                                $wholesale_status_color = 'danger';
                                break;
                        }
                    } else{
                        $product_wholesale_status = '';
                        $wholesale_status_color = '';
                    }

                    if(!is_null($product_info['etcm_category_id'])){
                        $url = HTTP_API . 'index.php?route=product/category/getProductCategoryETCM&category_id=' . $product_info['etcm_category_id'];

                        $category_data = file_get_contents($url);
                        $category_arr = json_decode($category_data, true);
                    } else{
                        $category_arr = [
                            'name'      => ''
                        ];
                    }

                    if($product_info['wholesale_etcm_category_id'] > 0){
                        // wholesale
                        $wholesale_url = HTTP_API . 'index.php?route=product/category/getProductCategoryETCM&category_id=' . $product_info['wholesale_etcm_category_id'];

                        $wholesale_category_data = file_get_contents($wholesale_url);
                        $wholesale_category_arr = json_decode($wholesale_category_data, true);
                    } else{
                        $wholesale_category_arr = [
                            'name'      => ''
                        ];
                    }

                    $product_sell_etcm_id = !empty($product_etcm) ? $product_etcm['product_sell_etcm_id'] : 0;
                    $product_wholesale_etcm_id = !empty($product_wholesale_etcm) ? $product_wholesale_etcm['product_wholesale_etcm_id'] : 0;

                    $product_date_added = !empty($product_info['date_added']) ? date($this->language->get('date_format_short'), strtotime($product_info['date_added'])) : '';
                    $product_wholesale_date_added = !empty($product_info['wholesale_date_added']) ? date($this->language->get('date_format_short'), strtotime($product_info['wholesale_date_added'])) : '';

                    $price_log = $this->model_catalog_product_sell_etcm->getPriceLog($product_wholesale_etcm_id);

                    $price_log_arr = [];

                    if(!empty($price_log)){
                        foreach($price_log as $price){
                            $weight_class_info = $this->model_localisation_weight_class->getWeightClass($price['weight_class_id']);
                            $weight_class_title = !empty($weight_class_info) ? $weight_class_info['title'] : '';
                            $price_log_special_date_start = ($price['special_date_start'] == '0000-00-00') ? '-' : date($this->language->get('date_format_short'), strtotime($price['special_date_start']));
                            $price_log_special_date_end = ($price['special_date_end'] == '0000-00-00') ? '-' : date($this->language->get('date_format_short'), strtotime($price['special_date_end']));
                            $special_price_switch_text = ($price['special_price_switch'] == '1') ? $this->language->get('text_yes') : $this->language->get('text_no');

                            $price_log_arr[] = [
                                'weight_class_id'           => $price['weight_class_id'],
                                'weight_class_title'        => $weight_class_title,
                                'wholesale_quantity'        => $price['quantity'],
                                'wholesale_price'           => $this->currency->format($price['price'], $this->config->get('config_currency')),
                                'special_price_switch'      => $price['special_price_switch'],
                                'special_price_switch_text' => $special_price_switch_text,
                                'special_price'             => $this->currency->format($price['special_price'], $this->config->get('config_currency')),
                                'special_date_start'        => $price_log_special_date_start,
                                'special_date_end'          => $price_log_special_date_end,
                                'date_added'                => date($this->language->get('date_format_short'), strtotime($price['date_added']))
                            ];
                        }
                    }

                    if(!empty($product_images)){
                        foreach($product_images as $image){
                            $product_image_results[] = [
                                'image'         => HTTPS_IMAGE . $image['image'],
                                'sort_order'    => $image['sort_order']
                            ];
                        }
                    }

                    $wholesale_weight_class_id = $product_info['wholesale_weight_class_id'];
                    $wholesale_weight_class_info = $this->model_localisation_weight_class->getWeightClass($wholesale_weight_class_id);
                    $wholesale_weight_class_name = !empty($wholesale_weight_class_info) ? $wholesale_weight_class_info['title'] : '';
                    $special_price_switch_text = ($product_info['special_price_switch'] == '1') ? $this->language->get('text_yes') : $this->language->get('text_no');

                    $special_date_start = ($product_info['special_date_start'] == '0000-00-00') ? '-' : date($this->language->get('date_format_short'), strtotime($product_info['special_date_start']));
                    $special_date_end = ($product_info['special_date_end'] == '0000-00-00') ? '-' : date($this->language->get('date_format_short'), strtotime($product_info['special_date_end']));

                    $data['product'] = array(
                        'product_sell_etcm_id'                  => $product_sell_etcm_id,
                        'product_wholesale_etcm_id'             => $product_wholesale_etcm_id,
                        'product_id'                            => $product_info['product_id'],
                        'product_code'                          => $product_info['code'],
                        'product_name'                          => $product_info['name'],
                        'product_wholesale_weight_class'        => $wholesale_weight_class_id,
                        'product_wholesale_weight_class_name'   => $wholesale_weight_class_name,
                        'product_price'                         => $this->currency->format($product_info['price'], $this->config->get('config_currency')),
                        'wholesale_price'                       => $this->currency->format($product_info['wholesale_price'], $this->config->get('config_currency')),
                        'product_quantity'                      => $product_info['onhand_quantity'],
                        'wholesale_quantity'                    => $product_info['onhand_quantity_wholesale'],
                        'special_price_switch'                  => $product_info['special_price_switch'],
                        'special_price_switch_text'             => $special_price_switch_text,
                        'special_price'                         => $this->currency->format($product_info['special_price'], $this->config->get('config_currency')),
                        'special_date_start'                    => $special_date_start,
                        'special_date_end'                      => $special_date_end,
                        'product_date_added'                    => $product_date_added,
                        'product_wholesale_date_added'          => $product_wholesale_date_added,
                        'status'                                => $product_status_id,
                        'wholesale_status'                      => $product_wholesale_status_id,
                        'product_status'                        => $product_status,
                        'product_wholesale_status'              => $product_wholesale_status,
                        'status_color'                          => $status_color,
                        'wholesale_status_color'                => $wholesale_status_color,
                        'etcm_category'                         => $category_arr['name'],
                        'etcm_wholesale_category'               => $wholesale_category_arr['name'],
                        'price_log'                             => $price_log_arr,
                        'description'                           => html_entity_decode($product_info['description']),
                        'product_images'                        => $product_image_results,
                        'product_link'                          => $this->url->link('catalog/product/edit','user_token=' . $this->session->data['user_token'] . '&product_id=' . $product_info['product_id'], true)
                    );
                }

                if(!empty($product_etcm)){
                    $status_history = $this->model_catalog_product_sell_etcm->getStatusHistory($product_etcm['product_sell_etcm_id']);

                    if(!empty($status_history)){
                        foreach($status_history as $history){
                            switch($history['status']){
                                case '0':
                                    $history_status_name = $this->language->get('text_pending');
                                    break;
                                case '1':
                                    $history_status_name = $this->language->get('text_approved');
                                    break;
                                case '2':
                                    $history_status_name = $this->language->get('text_rejected');
                                    break;
                            }

                            $data['product']['history'][] = array(
                                'status'        => $history['status'],
                                'status_name'   => $history_status_name,
                                'comment'       => $history['comment'],
                                'date_added'    => date($this->language->get('date_format_short'), strtotime($history['date_added']))
                            );
                        }
                    } else{
                        $data['product']['history'] = array();
                    }
                } else{
                    $data['product']['history'] = array();
                }

                if(!empty($product_wholesale_etcm)){
                    $wholesale_status_history = $this->model_catalog_product_sell_etcm->getWholesaleStatusHistory($product_wholesale_etcm['product_wholesale_etcm_id']);

                    if(!empty($wholesale_status_history)){
                        foreach($wholesale_status_history as $history){
                            switch($history['status']){
                                case '0':
                                    $wholesale_history_status_name = $this->language->get('text_pending');
                                    break;
                                case '1':
                                    $wholesale_history_status_name = $this->language->get('text_approved');
                                    break;
                                case '2':
                                    $wholesale_history_status_name = $this->language->get('text_rejected');
                                    break;
                            }

                            $data['product']['wholesale_history'][] = array(
                                'status'        => $history['status'],
                                'status_name'   => $wholesale_history_status_name,
                                'comment'       => $history['comment'],
                                'date_added'    => date($this->language->get('date_format_short'), strtotime($history['date_added']))
                            );
                        }
                    } else{
                        $data['product']['wholesale_history'] = array();
                    }
                } else{
                    $data['product']['wholesale_history'] = array();
                }
            } else{
                $this->response->redirect($this->url->link('catalog/product_sell_etcm','user_token=' . $this->session->data['user_token'], true));
            }
        } else{
            $this->response->redirect($this->url->link('catalog/product_sell_etcm','user_token=' . $this->session->data['user_token'], true));
        }

        $url = '';

        $data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

        $language_arr = array('heading_title', 'button_cancel', 'text_view', 'column_product_name', 'column_product_code', 'column_product_price', 'column_product_date_added', 'column_product_wholesale_quantity', 'column_quantity', 'column_etcm_category', 'column_product_status', 'tab_information', 'tab_status_history', 'column_comment', 'text_no_results', 'button_edit_sell', 'button_edit_wholesale', 'column_etcm_wholesale_category', 'column_product_wholesale_status', 'column_product_wholesale_date_added', 'text_selling', 'text_wholesale', 'tab_wholesale_status_history', 'column_product_wholesale_price', 'column_date_end', 'column_date_start', 'column_priority', 'column_selling_price', 'tab_product_price_log', 'column_action', 'button_view', 'button_hide', 'column_wholesale_date_available', 'column_product_price_per_kg', 'column_weight_class', 'column_enable_special_price', 'tab_product_description', 'tab_product_images', 'text_no_image_found');

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        $data['cancel'] = $this->url->link('catalog/product_sell_etcm','user_token=' . $this->session->data['user_token'], true);
        $data['edit'] = $this->url->link('catalog/product_sell_etcm/edit','user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'], true);
        $data['edit_wholesale'] = $this->url->link('catalog/product_sell_etcm/edit_wholesale','user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'], true);

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('catalog/product_sell_etcm_info', $data));
    }

    public function publish(){
        $this->load->language('catalog/product_sell_etcm');
        $this->load->model('catalog/product_sell_etcm');

        if(isset($this->request->get['product_id'])){
            $product_id = $this->request->get['product_id'];

            $this->model_catalog_product_sell_etcm->updatePublishStatus('1',$product_id);

            $this->session->data['success'] = sprintf($this->language->get('text_success_publish'), $this->language->get('text_published'));

            $this->response->redirect($this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'],true));
        } else{
            $this->response->redirect($this->url->link('catalog/product_sell_etcm','user_token=' . $this->session->data['user_token'], true));
        }
    }

    public function publish_wholesale(){
        $this->load->language('catalog/product_sell_etcm');
        $this->load->model('catalog/product_sell_etcm');

        if(isset($this->request->get['product_id'])){
            $product_id = $this->request->get['product_id'];

            $this->model_catalog_product_sell_etcm->updatePublishWholesaleStatus('1',$product_id);

            $this->session->data['success'] = sprintf($this->language->get('text_success_publish'), $this->language->get('text_published'));

            $this->response->redirect($this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'],true));
        } else{
            $this->response->redirect($this->url->link('catalog/product_sell_etcm','user_token=' . $this->session->data['user_token'], true));
        }
    }

    public function unpublish(){
        $this->load->language('catalog/product_sell_etcm');
        $this->load->model('catalog/product_sell_etcm');

        if(isset($this->request->get['product_id'])){
            $product_id = $this->request->get['product_id'];

            $this->model_catalog_product_sell_etcm->updatePublishStatus('0',$product_id);

            $this->session->data['success'] = sprintf($this->language->get('text_success_publish'), $this->language->get('text_unpublished'));

            $this->response->redirect($this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'],true));
        } else{
            $this->response->redirect($this->url->link('catalog/product_sell_etcm','user_token=' . $this->session->data['user_token'], true));
        }
    }

    public function unpublish_wholesale(){
        $this->load->language('catalog/product_sell_etcm');
        $this->load->model('catalog/product_sell_etcm');

        if(isset($this->request->get['product_id'])){
            $product_id = $this->request->get['product_id'];

            $this->model_catalog_product_sell_etcm->updatePublishWholesaleStatus('0',$product_id);

            $this->session->data['success'] = sprintf($this->language->get('text_success_publish'), $this->language->get('text_unpublished'));

            $this->response->redirect($this->url->link('catalog/product_sell_etcm', 'user_token=' . $this->session->data['user_token'],true));
        } else{
            $this->response->redirect($this->url->link('catalog/product_sell_etcm','user_token=' . $this->session->data['user_token'], true));
        }
    }

    protected function validateForm(){
        if (!$this->user->hasPermission('modify', 'catalog/product_sell_etcm')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

        if(empty($this->request->post['etcm_category_id'])){
            $this->error['etcm_category'] = $this->language->get('error_etcm_category');
        }

        if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

        return !$this->error;
    }

    protected function validateFormWholesale(){
        if (!$this->user->hasPermission('modify', 'catalog/product_sell_etcm')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

        if(empty($this->request->post['etcm_category_id'])){
            $this->error['etcm_category'] = $this->language->get('error_etcm_category');
        }

        if(empty($this->request->post['wholesale_quantity'])){
            $this->error['wholesale_quantity'] = $this->language->get('error_wholesale_quantity');
        }

        if(empty($this->request->post['wholesale_price'])){
            $this->error['wholesale_price'] = $this->language->get('error_wholesale_price');
        }

        if($this->request->post['enable_special_price'] == '1'){
            if(empty($this->request->post['special_wholesale_price'])){
                $this->error['special_wholesale_price'] = $this->language->get('error_wholesale_price');
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

        return !$this->error;
    }

    public function autocomplete(){
        $this->load->model('catalog/product_sell_etcm');

        $json = array();

        if(isset($this->request->get['filter_name']) || isset($this->request->get['filter_code'])){
            if(isset($this->request->get['filter_name'])){
                $filter_name = $this->request->get['filter_name'];
            } else{
                $filter_name = '';
            }

            if(isset($this->request->get['filter_code'])){
                $filter_code = $this->request->get['filter_code'];
            } else{
                $filter_code = '';
            }

            if (isset($this->request->get['limit'])) {
				$limit = $this->request->get['limit'];
			} else {
				$limit = 5;
			}

            $filter_data = array(
				'filter_name'  => $filter_name,
				'filter_code'  => $filter_code,
				'start'        => 0,
				'limit'        => $limit
			);

            $results = $this->model_catalog_product_sell_etcm->getAutoCompleteProducts($filter_data);

            foreach($results as $result){
                $json[] = array(
                    'product_id'        => $result['product_id'],
                    'product_name'      => $result['name'],
                    'product_code'      => $result['code']
                );
            }
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }
}
?>