<?php
class ControllerCatalogManufacturer extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('catalog/manufacturer');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/manufacturer');

		$this->getList();
	}

	public function add() {
		$this->load->language('catalog/manufacturer');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/manufacturer');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_catalog_manufacturer->addManufacturer($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('catalog/manufacturer', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('catalog/manufacturer');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/manufacturer');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_catalog_manufacturer->editManufacturer($this->request->get['manufacturer_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('catalog/manufacturer', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('catalog/manufacturer');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/manufacturer');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $manufacturer_id) {
				$this->model_catalog_manufacturer->deleteManufacturer($manufacturer_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('catalog/manufacturer', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['filter_supplier_name'])) {
			$filter_supplier_name = $this->request->get['filter_supplier_name'];
		} else {
			$filter_supplier_name = null;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';
		
		if (isset($this->request->get['filter_supplier_name'])) {
			$url .= '&filter_supplier_name=' . urlencode(html_entity_decode($this->request->get['filter_supplier_name'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('catalog/manufacturer', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		
		$data['add'] = $this->url->link('catalog/manufacturer/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('catalog/manufacturer/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['manufacturers'] = array();

		$filter_data = array(
			'filter_supplier_name'	=> $filter_supplier_name,
			'sort'  				=> $sort,
			'order' 				=> $order,
			'start' 				=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' 				=> $this->config->get('config_limit_admin')
		);

		$manufacturer_total = $this->model_catalog_manufacturer->getTotalManufacturers($filter_data);

		$results = $this->model_catalog_manufacturer->getManufacturers($filter_data);

		foreach ($results as $result) {
			$data['manufacturers'][] = array(
				'manufacturer_id' => $result['manufacturer_id'],
				'name'            => $result['name'],
				'sort_order'      => $result['sort_order'],
				'edit'            => $this->url->link('catalog/manufacturer/edit', 'user_token=' . $this->session->data['user_token'] . '&manufacturer_id=' . $result['manufacturer_id'] . $url, true)
			);
		}

		$data['user_token'] = $this->session->data['user_token'];
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';
		
		if (isset($this->request->get['filter_supplier_name'])) {
			$url .= '&filter_supplier_name=' . urlencode(html_entity_decode($this->request->get['filter_supplier_name'], ENT_QUOTES, 'UTF-8'));
		}

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		if (isset($this->request->get['filter_supplier_name'])) {
			$url .= '&filter_supplier_name=' . urlencode(html_entity_decode($this->request->get['filter_supplier_name'], ENT_QUOTES, 'UTF-8'));
		}

		$data['sort_name'] = $this->url->link('catalog/manufacturer', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $url, true);
		$data['sort_sort_order'] = $this->url->link('catalog/manufacturer', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $url, true);

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $manufacturer_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('catalog/manufacturer', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($manufacturer_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($manufacturer_total - $this->config->get('config_limit_admin'))) ? $manufacturer_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $manufacturer_total, ceil($manufacturer_total / $this->config->get('config_limit_admin')));

		$data['filter_supplier_name'] = $filter_supplier_name;
		
		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('catalog/manufacturer_list', $data));
	}

	protected function getForm() {
		$data['heading_title'] = $this->language->get('heading_title');
		
		$data['text_form'] = !isset($this->request->get['manufacturer_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
		$data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('catalog/manufacturer', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		
		if (!isset($this->request->get['manufacturer_id'])) {
			$data['action'] = $this->url->link('catalog/manufacturer/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('catalog/manufacturer/edit', 'user_token=' . $this->session->data['user_token'] . '&manufacturer_id=' . $this->request->get['manufacturer_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('catalog/manufacturer', 'user_token=' . $this->session->data['user_token'] . $url, true);
		
		$this->load->model('localisation/language');//load other module model
		$data['languages'] = $this->model_localisation_language->getLanguages();//get languages

		if (isset($this->request->get['manufacturer_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($this->request->get['manufacturer_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];
		
		/*
		if (isset($this->request->post['name'])) {
			$data['name'] = $this->request->post['name'];
		} elseif (!empty($manufacturer_info)) {
			$data['name'] = $manufacturer_info['name'];
		} else {
			$data['name'] = '';
		}*/
		
		if (isset($this->request->post['username'])) {
			$data['username'] = $this->request->post['username'];
		} elseif (!empty($manufacturer_info)) {
			$data['username'] = $manufacturer_info['username'];
		} else {
			$data['username'] = '';
		}
		
		if (isset($this->request->post['firstname'])) {
			$data['firstname'] = $this->request->post['firstname'];
		} elseif (!empty($manufacturer_info)) {
			$data['firstname'] = $manufacturer_info['firstname'];
		} else {
			$data['firstname'] = '';
		}
		
		if (isset($this->request->post['lastname'])) {
			$data['lastname'] = $this->request->post['lastname'];
		} elseif (!empty($manufacturer_info)) {
			$data['lastname'] = $manufacturer_info['lastname'];
		} else {
			$data['lastname'] = '';
		}
		
		if (isset($this->request->post['gender'])) {
			$data['gender'] = $this->request->post['gender'];
		} elseif (!empty($manufacturer_info)) {
			$data['gender'] = $manufacturer_info['gender'];
		} else {
			$data['gender'] = '';
		}
		
		if (isset($this->request->post['ic'])) {
			$data['ic'] = $this->request->post['ic'];
		} elseif (!empty($manufacturer_info)) {
			$data['ic'] = $manufacturer_info['ic'];
		} else {
			$data['ic'] = '';
		}
		
		if (isset($this->request->post['name'])) {
			$data['name'] = $this->request->post['name'];
		} elseif (!empty($manufacturer_info)) {
			$data['name'] = $manufacturer_info['name'];
		} else {
			$data['name'] = '';
		}
		
		if (isset($this->request->post['code'])) {
			$data['code'] = $this->request->post['code'];
		} elseif (!empty($manufacturer_info)) {
			$data['code'] = $manufacturer_info['code'];
		} else {
			$data['code'] = '';
		}
		
		if (isset($this->request->post['gst_reg_no'])) {
			$data['gst_reg_no'] = $this->request->post['gst_reg_no'];
		} elseif (!empty($manufacturer_info)) {
			$data['gst_reg_no'] = $manufacturer_info['gst_reg_no'];
		} else {
			$data['gst_reg_no'] = '';
		}
		
		if (isset($this->request->post['company_reg_no'])) {
			$data['company_reg_no'] = $this->request->post['company_reg_no'];
		} elseif (!empty($manufacturer_info)) {
			$data['company_reg_no'] = $manufacturer_info['company_reg_no'];
		} else {
			$data['company_reg_no'] = '';
		}
		
		if (isset($this->request->post['description'])) {
			$data['description'] = $this->request->post['description'];
		} elseif (!empty($manufacturer_info)) {
			$data['description'] = $manufacturer_info['description'];
		} else {
			$data['description'] = '';
		}
		
		if (isset($this->request->post['periodfrom'])) {
			$data['periodfrom'] = $this->request->post['periodfrom'];
		} elseif (!empty($manufacturer_info)) {
			$data['periodfrom'] = $manufacturer_info['periodfrom'];
		} else {
			$data['periodfrom'] = '';
		}
		
		if (isset($this->request->post['periodto'])) {
			$data['periodto'] = $this->request->post['periodto'];
		} elseif (!empty($manufacturer_info)) {
			$data['periodto'] = $manufacturer_info['periodto'];
		} else {
			$data['periodto'] = '';
		}
		
		if (isset($this->request->post['personincharge'])) {
			$data['personincharge'] = $this->request->post['personincharge'];
		} elseif (!empty($manufacturer_info)) {
			$data['personincharge'] = $manufacturer_info['personincharge'];
		} else {
			$data['personincharge'] = '';
		}
		
		if (isset($this->request->post['address_1'])) {
			$data['address_1'] = $this->request->post['address_1'];
		} elseif (!empty($manufacturer_info)) {
			$data['address_1'] = $manufacturer_info['address_1'];
		} else {
			$data['address_1'] = '';
		}
		
		if (isset($this->request->post['address_2'])) {
			$data['address_2'] = $this->request->post['address_2'];
		} elseif (!empty($manufacturer_info)) {
			$data['address_2'] = $manufacturer_info['address_2'];
		} else {
			$data['address_2'] = '';
		}
		
		if (isset($this->request->post['address_3'])) {
			$data['address_3'] = $this->request->post['address_3'];
		} elseif (!empty($manufacturer_info)) {
			$data['address_3'] = $manufacturer_info['address_3'];
		} else {
			$data['address_3'] = '';
		}
		
		if (isset($this->request->post['postcode'])) {
			$data['postcode'] = $this->request->post['postcode'];
		} elseif (!empty($manufacturer_info)) {
			$data['postcode'] = $manufacturer_info['postcode'];
		} else {
			$data['postcode'] = '';
		}
		
		if (isset($this->request->post['zone_id'])) {
			$data['zone_id'] = $this->request->post['zone_id'];
		} elseif (!empty($manufacturer_info)) {
			$data['zone_id'] = $manufacturer_info['zone_id'];
		} else {
			$data['zone_id'] = '';
		}
		
		if (isset($this->request->post['city'])) {
			$data['city'] = $this->request->post['city'];
		} elseif (!empty($manufacturer_info)) {
			$data['city'] = $manufacturer_info['city'];
		} else {
			$data['city'] = '';
		}
		
		$this->load->model('localisation/country');
		$data['countries'] = $this->model_localisation_country->getCountries();
		
		if (isset($this->request->post['country_id'])) {
			$data['country_id'] = $this->request->post['country_id'];
		} elseif (!empty($manufacturer_info)) {
			$data['country_id'] = $manufacturer_info['country_id'];
		} else {
			$data['country_id'] = '';
		}
		
		if (isset($this->request->post['telephone1'])) {
			$data['telephone1'] = $this->request->post['telephone1'];
		} elseif (!empty($manufacturer_info)) {
			$data['telephone1'] = $manufacturer_info['telephone1'];
		} else {
			$data['telephone1'] = '';
		}
		
		if (isset($this->request->post['telephone2'])) {
			$data['telephone2'] = $this->request->post['telephone2'];
		} elseif (!empty($manufacturer_info)) {
			$data['telephone2'] = $manufacturer_info['telephone2'];
		} else {
			$data['telephone2'] = '';
		}
		
		if (isset($this->request->post['fax'])) {
			$data['fax'] = $this->request->post['fax'];
		} elseif (!empty($manufacturer_info)) {
			$data['fax'] = $manufacturer_info['fax'];
		} else {
			$data['fax'] = '';
		}
		
		if (isset($this->request->post['email'])) {
			$data['email'] = $this->request->post['email'];
		} elseif (!empty($manufacturer_info)) {
			$data['email'] = $manufacturer_info['email'];
		} else {
			$data['email'] = '';
		}
		
		if (isset($this->request->post['password'])) {
			$data['password'] = $this->request->post['password'];
		} elseif (!empty($manufacturer_info)) {
			$data['password'] = '';
		}
		
		if (isset($this->request->post['password'])) {
			$data['password'] = $this->request->post['password'];
		} else {
			$data['password'] = '';
		}
		
		if (isset($this->request->post['confirm'])) {
			$data['confirm'] = $this->request->post['confirm'];
		} else {
			$data['confirm'] = '';
		}
		
		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (!empty($manufacturer_info)) {
			$data['status'] = $manufacturer_info['status'];
		} else {
			$data['status'] = '';
		}
		
		if (isset($this->request->post['remark'])) {
			$data['remark'] = $this->request->post['remark'];
		} elseif (!empty($manufacturer_info)) {
			$data['remark'] = $manufacturer_info['remark'];
		} else {
			$data['remark'] = '';
		}

		$this->load->model('setting/store');

		$data['stores'] = $this->model_setting_store->getStores();

		if (isset($this->request->post['manufacturer_store'])) {
			$data['manufacturer_store'] = $this->request->post['manufacturer_store'];
		} elseif (isset($this->request->get['manufacturer_id'])) {
			$data['manufacturer_store'] = $this->model_catalog_manufacturer->getManufacturerStores($this->request->get['manufacturer_id']);
		} else {
			$data['manufacturer_store'] = array(0);
		}
		
		/*
		if (isset($this->request->post['keyword'])) {
			$data['keyword'] = $this->request->post['keyword'];
		} elseif (!empty($manufacturer_info)) {
			$data['keyword'] = $manufacturer_info['keyword'];
		} else {
			$data['keyword'] = '';
		}
		*/

		if (isset($this->request->post['image'])) {
			$data['image'] = $this->request->post['image'];
		} elseif (!empty($manufacturer_info)) {
			$data['image'] = $manufacturer_info['image'];
		} else {
			$data['image'] = '';
		}

		$this->load->model('tool/image');

		if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
		} elseif (!empty($manufacturer_info) && is_file(DIR_IMAGE . $manufacturer_info['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($manufacturer_info['image'], 100, 100);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

		if (isset($this->request->post['sort_order'])) {
			$data['sort_order'] = $this->request->post['sort_order'];
		} elseif (!empty($manufacturer_info)) {
			$data['sort_order'] = $manufacturer_info['sort_order'];
		} else {
			$data['sort_order'] = '';
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('catalog/manufacturer_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'catalog/manufacturer')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$this->load->model('catalog/manufacturer');
		if(isset($this->request->get['manufacturer_id'])){
			$manufacture_info = $this->model_catalog_manufacturer->getManufacturer($this->request->get['manufacturer_id']);
		}
		
		
		// if ((utf8_strlen($this->request->post['username']) < 3) || (utf8_strlen($this->request->post['username']) > 20)) {
		// 	$this->error['name']['username'] = $this->language->get('error_username');

		// } else {
		// 	if(isset($this->request->get['manufacturer_id'])){
				
		// 		if(
		// 		$this->request->post['username'] != $manufacture_info['username'] &&
		// 		$this->model_catalog_manufacturer->manufacturerUsernameExists($this->request->post['username'])){
		// 			$this->error['name']['username'] = $this->language->get('error_username_exists');
		// 		}
		// 	} else {
		// 		if($this->model_catalog_manufacturer->manufacturerUsernameExists($this->request->post['username'])){
		// 			$this->error['name']['username'] = $this->language->get('error_username_exists');
		// 		}
		// 	}
		// }
		
		// if ((utf8_strlen(trim($this->request->post['firstname'])) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
		// 	$this->error['name']['firstname'] = $this->language->get('error_firstname');
		// }
		
		// if (empty($this->request->post['ic'])) {
		// 	$this->error['name']['ic'] = $this->language->get('error_ic');
		// }
		
		// if (empty($this->request->post['periodfrom'])) {
		// 	$this->error['periodfrom'] = $this->language->get('error_periodfrom');
		// }

        // if (empty($this->request->post['periodto'])) {
		// 	$this->error['periodto'] = $this->language->get('error_periodto');
		// }
		
		$name = $this->request->post['name'];
		if ((utf8_strlen($name) < 1) || (utf8_strlen($name) > 64)) {
			$this->error['name']['name'] = $this->language->get('error_name');
		} else {
			$is_current_name = false;
				
			if(isset($this->request->get['manufacturer_id'])){
				$current_name = $manufacture_info['name'];
				
				$is_current_name = (strtolower($name) == strtolower($current_name)) ? true : false;
			}
			
			if($this->model_catalog_manufacturer->manufacturerNameExists($name) && !$is_current_name){
				$this->error['name']['name'] = $this->language->get('error_name_exists');
			}
		}
		
		$code = $this->request->post['code'];
		if ((utf8_strlen($code) < 1) || (utf8_strlen($code) > 64)) {
			$this->error['name']['code'] = $this->language->get('error_code');
		} else {
			$is_current_code = false;
				
			if(isset($this->request->get['manufacturer_id'])){
				$current_code = $manufacture_info['code'];
				
				$is_current_code = (strtolower($code) == strtolower($current_code)) ? true : false;
			}
			
			if($this->model_catalog_manufacturer->manufacturerCodeExists($code) && !$is_current_code){
				$this->error['name']['code'] = $this->language->get('error_code_exists');
			}
		}
		
		// if ((utf8_strlen($this->request->post['gst_reg_no']) < 1)) {
		// 	$this->error['name']['gst_reg_no'] = $this->language->get('error_gst_reg_no');
		// }
		
		// if ((utf8_strlen($this->request->post['company_reg_no']) < 1)) {
		// 	$this->error['name']['company_reg_no'] = $this->language->get('error_company_reg_no');
		// }
		
		// if ((utf8_strlen($this->request->post['address_1']) < 1)) {
		// 	$this->error['name']['address_1'] = $this->language->get('error_address_1');
		// }
		
		// if ((utf8_strlen($this->request->post['city']) < 1)) {
		// 	$this->error['name']['city'] = $this->language->get('error_city');
		// }
		
		// $this->load->model('localisation/country');

		// $country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);

		// if ($country_info && $country_info['postcode_required'] && (utf8_strlen($this->request->post['country_id']) < 2 || utf8_strlen($this->request->post['country_id']) > 10)) {
		// 	$this->error['address']['postcode'] = $this->language->get('error_postcode');
		// }

		// if ($this->request->post['country_id'] == '') {
		// 	$this->error['name']['country_id'] = $this->language->get('error_country');
		// }

		// if (!isset($this->request->post['zone_id']) || $this->request->post['zone_id'] == '') {
		// 	$this->error['name']['zone_id'] = $this->language->get('error_zone');
		// }
		
		// if ((utf8_strlen($this->request->post['telephone1']) < 1)) {
		// 	$this->error['name']['telephone1'] = $this->language->get('error_telephone1');
		// }
		
		// $email = trim($this->request->post['email']);
		
		// if((utf8_strlen($email) > 0)){
		// 	if(!filter_var($email, FILTER_VALIDATE_EMAIL)){
		// 		$this->error['name']['email'] = $this->language->get('error_email_format');
		// 	} else {
		// 		$is_current_mail = false;
				
		// 		if(isset($this->request->get['manufacturer_id'])){
					
		// 			$current_email = $manufacture_info['email'];
					
		// 			$is_current_mail = (strtolower($email) == strtolower($current_email)) ? true : false;
		// 		}
				
		// 		if($this->model_catalog_manufacturer->manufacturerEmailExists($email) && !$is_current_mail){
		// 			$this->error['name']['email'] = $this->language->get('error_email_exists');
		// 		}
				
		// 		//getManufacturer
		// 	}
		// } else {
        //             $this->error['name']['email'] = $this->language->get('error_email');
        //         }
		
		// if(!isset($this->request->get['manufacturer_id'])){
		// 	if ((utf8_strlen($this->request->post['password']) < 4) || (utf8_strlen($this->request->post['password']) > 20)) {
		// 		$this->error['name']['password'] = $this->language->get('error_password');
		// 	}
			
		// 	if ($this->request->post['password'] != $this->request->post['confirm']) {
		// 		$this->error['name']['confirm'] = $this->language->get('error_confirm');
		// 	}
		// } else {
		// 	if(!empty($this->request->post['password'])){
		// 		if ((utf8_strlen($this->request->post['password']) < 4) || (utf8_strlen($this->request->post['password']) > 20)) {
		// 			$this->error['name']['password'] = $this->language->get('error_password');
		// 		}
				
		// 		if ($this->request->post['password'] != $this->request->post['confirm']) {
		// 			$this->error['name']['confirm'] = $this->language->get('error_confirm');
		// 		}
		// 	}
		// }
		
		//error
		if($this->error && !isset($this->error['warning']))
			$this->error['warning'] = $this->language->get('error_warning');
		
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'catalog/manufacturer')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		$this->load->model('catalog/product');

		foreach ($this->request->post['selected'] as $manufacturer_id) {
			$product_total = $this->model_catalog_product->getTotalProductsByManufacturerId($manufacturer_id);

			if ($product_total) {
				$this->error['warning'] = sprintf($this->language->get('error_product'), $product_total);
			}
		}

		return !$this->error;
	}

	public function autocomplete() {
		$json = array();

		if (isset($this->request->get['filter_name'])) {
			$this->load->model('catalog/manufacturer');

			$filter_data = array(
				'filter_name' => $this->request->get['filter_name'],
				'start'       => 0,
				'limit'       => 5
			);

			$results = $this->model_catalog_manufacturer->getManufacturers($filter_data);

			foreach ($results as $result) {
				$json[] = array(
					'manufacturer_id' => $result['manufacturer_id'],
					'name'            => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
					'description' 	  => strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')),
					'code'=> strip_tags(html_entity_decode($result['code'], ENT_QUOTES, 'UTF-8')),
					'opendate'=> strip_tags(html_entity_decode($result['opendate'], ENT_QUOTES, 'UTF-8')),
					'personincharge'=> strip_tags(html_entity_decode($result['personincharge'], ENT_QUOTES, 'UTF-8')),
					'address_1'=> strip_tags(html_entity_decode($result['address_1'], ENT_QUOTES, 'UTF-8')),
					'address_2'=> strip_tags(html_entity_decode($result['address_2'], ENT_QUOTES, 'UTF-8')),
					'address_3'=> strip_tags(html_entity_decode($result['address_3'], ENT_QUOTES, 'UTF-8')),
					'city'=> strip_tags(html_entity_decode($result['city'], ENT_QUOTES, 'UTF-8')),
					'postcode'=> strip_tags(html_entity_decode($result['postcode'], ENT_QUOTES, 'UTF-8')),
					'country_id'=> $result['country_id'],
					'zone_id'=> $result['zone_id'],
					'telephone1'=> strip_tags(html_entity_decode($result['telephone1'], ENT_QUOTES, 'UTF-8')),
					'telephone2'=> strip_tags(html_entity_decode($result['telephone2'], ENT_QUOTES, 'UTF-8')),
					'fax'=> strip_tags(html_entity_decode($result['fax'], ENT_QUOTES, 'UTF-8')),
					'email'=> strip_tags(html_entity_decode($result['email'], ENT_QUOTES, 'UTF-8')),
					'status'=> $result['status'],
					'remark'=> strip_tags(html_entity_decode($result['remark'], ENT_QUOTES, 'UTF-8')),
					'image'=> strip_tags(html_entity_decode($result['image'], ENT_QUOTES, 'UTF-8')),
					'sort_order'=> $result['sort_order'],
					'date_added'=> strip_tags(html_entity_decode($result['date_added'], ENT_QUOTES, 'UTF-8')),
					'add_by'=> $result['add_by'],
					'date_modified'=> strip_tags(html_entity_decode($result['date_modified'], ENT_QUOTES, 'UTF-8')),
					'modify_by'=> $result['modify_by'],
				);
			}
		}

		$sort_order = array();

		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['name'];
		}

		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function searchManufacturer(){
		$json = array('success' => false); //default return false
		
		$data = array();
		
		// filter data
		if(isset($this->request->get['name'])) $data['name'] = $this->request->get['name'];
		if(isset($this->request->get['code'])) $data['code'] = $this->request->get['code'];
		if(isset($this->request->get['store_id'])) $data['store_id'] = $this->request->get['store_id'];
		
		if(isset($this->request->get['name']) || isset($this->request->get['code'])){
			$this->load->model('catalog/manufacturer');
			$result = $this->model_catalog_manufacturer->searchManufacturer($data);
			
			if(!empty($result)){
				$json = $result;
				$json['success'] = 'found';
			} else {
				$json['success'] = 'new';
			}
		}
		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function supplierList(){
		$this->load->language('catalog/manufacturer');
		$this->load->model('catalog/manufacturer');
		
		if (isset($this->request->get['filter_supplier_name'])) {
			$filter_supplier_name = $this->request->get['filter_supplier_name'];
		} else {
			$filter_supplier_name = null;
		}
		
		if (isset($this->request->get['filter_supplier_code'])) {
			$filter_supplier_code = $this->request->get['filter_supplier_code'];
		} else {
			$filter_supplier_code = null;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';

        if (isset($this->request->get['filter_supplier_name'])) {
			$url .= '&filter_supplier_name=' . $this->request->get['filter_supplier_name'];
		}
		
	  	if (isset($this->request->get['filter_supplier_code'])) {
			$url .= '&filter_supplier_code=' . $this->request->get['filter_supplier_code'];
		}
		
		$data['manufacturers'] = array();

		$filter_data = array(
			'filter_supplier_name' => $filter_supplier_name,
			'filter_supplier_code' => $filter_supplier_code,
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$manufacturer_total = $this->model_catalog_manufacturer->getTotalManufacturers($filter_data);

		$results = $this->model_catalog_manufacturer->getManufacturers($filter_data);

		foreach ($results as $result) {
			$data['manufacturers'][] = array(
				'manufacturer_id' 	=> $result['manufacturer_id'],
				'name'            	=> $result['name'],
				'code'				=> $result['code'],
				'sort_order'      	=> $result['sort_order']
			);
		}

		if (!empty($data['manufacturers'])) {
			foreach ($data['manufacturers'] as $index => $manufacturer) {
				$data['manufacturers'][$index]['select_data'] = htmlspecialchars(json_encode($manufacturer));
			}
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_name'] = $this->url->link('catalog/manufacturer/supplierList', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $url, true);
		$data['sort_code'] = $this->url->link('catalog/manufacturer/supplierList', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $url, true);
		$data['sort_sort_order'] = $this->url->link('catalog/manufacturer/supplierList', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $url, true);

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $manufacturer_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('catalog/manufacturer/supplierList', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($manufacturer_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($manufacturer_total - $this->config->get('config_limit_admin'))) ? $manufacturer_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $manufacturer_total, ceil($manufacturer_total / $this->config->get('config_limit_admin')));

		$data['callback'] = isset($this->request->get['callback']) ? $this->request->get['callback'] : false;
		$data['row'] = isset($this->request->get['row']) ? $this->request->get['row'] : '';
		
		$data['sort'] = $sort;
		$data['order'] = $order;
		$data['filter_supplier_name'] = $filter_supplier_name;
		$data['filter_supplier_code'] = $filter_supplier_code;
		$data['user_token'] = $this->session->data['user_token'];
		$data['header'] = $this->load->controller('common/header/pop_header');
		$this->response->setOutput($this->load->view('openwindow/supplier_list', $data));
	}
}