<?php
class ControllerCatalogEvent extends Controller { 
	private $error = array();

	public function index() {
		$this->load->language('catalog/event');

		$this->document->setTitle($this->language->get('heading_title'));
		$this->document->addScript('view/javascript/fullcalendar.min.js');
		$this->document->addStyle('view/stylesheet/fullcalendar.min.css');
		$this->document->addStyle('view/stylesheet/fullcalendar_fcpmdam.css');
		 
		$this->load->model('catalog/event');

		$this->getList();
	}

	public function add() {
		$this->load->language('catalog/event');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/event');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_catalog_event->addEvent($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->response->redirect($this->url->link('catalog/event', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('catalog/event');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/event');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_catalog_event->editEvent($this->request->get['event_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->response->redirect($this->url->link('catalog/event', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}
 
	public function delete() {
		$this->load->language('catalog/event');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('catalog/event');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $event_id) {
				$this->model_catalog_event->deleteEvent($event_id);
			}
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->response->redirect($this->url->link('catalog/event', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'id.title';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$data['breadcrumbs'] = array();

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], true),
      		'separator' => false
   		);

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('catalog/event', 'user_token=' . $this->session->data['user_token'] . $url, true),
      		'separator' => ' :: '
   		);
				
		$data['user_token'] = $this->session->data['user_token'];   
		
		$data['add'] = $this->url->link('catalog/event/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('catalog/event/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);	

		$data['events'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$event_total = $this->model_catalog_event->getTotalEvents();
	
		$results = $this->model_catalog_event->getEvents($filter_data, false);
 
    	foreach ($results as $result) {						
			$data['events'][] = array(
				'event_id' 				=> $result['event_id'],
				'title'         		=> $result['title'],
				'event_date'       		=> date('d/m/Y', strtotime($result['event_date'])),
				'sort_order'    		=> $result['sort_order'],
				'export_subscribers'	=> $this->url->link('catalog/event/export', 'user_token=' . $this->session->data['user_token'] . '&event_id=' . $result['event_id'], true),
				'edit'         			=> $this->url->link('catalog/event/edit', 'user_token=' . $this->session->data['user_token'] . '&event_id=' . $result['event_id'] . $url, true)
			);
		}	

		$all_results = $this->model_catalog_event->getEvents($filter_data, true);
	
		foreach ($all_results as $result) {						
			$data['calendar_events'][] = array(
				'event_id' 				=> $result['event_id'],
				'title'         		=> $result['title'],
				'event_date'       		=> date('Y-m-d', strtotime($result['event_date'])),
				'event_start_time'		=> date('H:i:s', strtotime($result['event_start_time'])),
				'edit'         			=> htmlspecialchars_decode($this->url->link('catalog/event/edit', 'user_token=' . $this->session->data['user_token'] . '&event_id=' . $result['event_id'] . $url, true))
			);
		}	
				
 		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$data['sort_title'] = $this->url->link('catalog/event', 'user_token=' . $this->session->data['user_token'] . '&sort=id.title' . $url, true);
		$data['sort_sort_order'] = $this->url->link('catalog/event', 'user_token=' . $this->session->data['user_token'] . '&sort=i.sort_order' . $url, true);
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $event_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('catalog/event', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);
			
		$data['pagination'] = $pagination->render();
		$data['results'] = sprintf($this->language->get('text_pagination'), ($event_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($event_total - $this->config->get('config_limit_admin'))) ? $event_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $event_total, ceil($event_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('catalog/event_list', $data));			
	}

	private function getForm() {
		$data['text_form'] = isset($this->request->get['event_id']) ? $this->language->get('text_edit') : $this->language->get('text_add');
		
		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-colorpicker.min.js');
		$this->document->addStyle('view/javascript/bootstrap/css/bootstrap-colorpicker.min.css');
		
		$data['user_token'] = $this->session->data['user_token'];

 		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

 		if (isset($this->error['title'])) {
			$data['error_title'] = $this->error['title'];
		} else {
			$data['error_title'] = array();
		}
		
	 	if (isset($this->error['description'])) {
			$data['error_description'] = $this->error['description'];
		} else {
			$data['error_description'] = array();
		}
		
		if (isset($this->error['event_start_time'])){
			$data['error_event_start_time'] = $this->error['event_start_time'];
		} else {
			$data['error_event_start_time'] = '';
		}
		
		if (isset($this->error['event_end_time'])){
			$data['error_event_end_time'] = $this->error['event_end_time'];
		} else {
			$data['error_event_end_time'] = '';
		}

		if (isset($this->error['event_location'])){
			$data['error_event_location'] = $this->error['event_location'];
		} else {
			$data['error_event_location'] = '';
		}

		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$data['breadcrumbs'] = array();

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], true)
   		);

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('catalog/event', 'user_token=' . $this->session->data['user_token'] . $url, true),
      		'separator' => ' :: '
   		);
							
		if (!isset($this->request->get['event_id'])) {
			$data['action'] = $this->url->link('catalog/event/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('catalog/event/edit', 'user_token=' . $this->session->data['user_token'] . '&event_id=' . $this->request->get['event_id'] . $url, true);
		}
		
		$data['cancel'] = $this->url->link('catalog/event', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['event_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$event_info = $this->model_catalog_event->getEvent($this->request->get['event_id']);
			$event_keywords = $this->model_catalog_event->getEventKeywords($this->request->get['event_id']);
		}
		
		$this->load->model('localisation/language');
		
		$data['languages'] = $this->model_localisation_language->getLanguages();
		
		if (isset($this->request->post['event_description'])) {
			$data['event_description'] = $this->request->post['event_description'];
		} elseif (isset($this->request->get['event_id'])) {
			$data['event_description'] = $this->model_catalog_event->getEventDescriptions($this->request->get['event_id']);
		} else {
			$data['event_description'] = array();
		}

		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (isset($event_info)) {
			$data['status'] = $event_info['status'];
		} else {
			$data['status'] = 1;
		}
		
		if (isset($this->request->post['event_date'])) {
			$data['event_date'] = $this->request->post['event_date'];
		} elseif (isset($event_info)) {
			$data['event_date'] = $event_info['event_date'];
		} else {
			if (isset($this->request->get['event_date'])) {
				$data['event_date'] = $this->request->get['event_date'];
			} else {
				$data['event_date'] = date('Y-m-d');
			}
		}

		if (isset($this->request->post['event_start_time'])) {
			$data['event_start_time'] = $this->request->post['event_start_time'];
		} elseif (isset($event_info)) {
			$data['event_start_time'] = $event_info['event_start_time'];
		} else {
			$data['event_start_time'] = '';
		}

		if (isset($this->request->post['event_end_time'])) {
			$data['event_end_time'] = $this->request->post['event_end_time'];
		} elseif (isset($event_info)) {
			$data['event_end_time'] = $event_info['event_end_time'];
		} else {
			$data['event_end_time'] = '';
		}


		if (isset($this->request->post['event_location'])) {
			$data['event_location'] = $this->request->post['event_location'];
		} elseif (isset($event_info)) {
			$data['event_location'] = $event_info['event_location'];
		} else {
			$data['event_location'] = '';
		}

		if (isset($this->request->post['allow_subscribe'])) {
			$data['allow_subscribe'] = $this->request->post['allow_subscribe'];
		} elseif (isset($event_info)) {
			$data['allow_subscribe'] = $event_info['allow_subscribe'];
		} else {
			$data['allow_subscribe'] = '';
		}
		if (isset($this->request->post['image'])) {
			$data['image'] = $this->request->post['image'];
		} elseif (isset($event_info)) {
			$data['image'] = $event_info['image'];
		} else {
			$data['image'] = '';
		}
		$this->load->model('tool/image');

		if (isset($event_info) && $event_info['image'] && file_exists(DIR_IMAGE . $event_info['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($event_info['image'], 100, 100);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
				
		$this->load->model('setting/store');
		
		$data['stores'] = array();

		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $this->language->get('text_default')
		);

		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		if (isset($this->request->post['event_store'])) {
			$data['event_store'] = $this->request->post['event_store'];
		} elseif (isset($event_info)) {
			$data['event_store'] = $this->model_catalog_event->getEventStores($this->request->get['event_id']);
		} else {
			$data['event_store'] = array(0);
		}		
		
		if (isset($this->request->post['keyword'])) {
			$data['keyword'] = $this->request->post['keyword'];
		} elseif (!empty($event_keywords)) {
			$data['keyword'] = $event_keywords;
		} else {
			$data['keyword'] = [];
		}
		
		if (isset($this->request->post['sort_order'])) {
			$data['sort_order'] = $this->request->post['sort_order'];
		} elseif (isset($event_info)) {
			$data['sort_order'] = $event_info['sort_order'];
		} else {
			$data['sort_order'] = '';
		}
		
		if (isset($this->request->post['event_layout'])) {
			$data['event_layout'] = $this->request->post['event_layout'];
		} elseif (isset($event_info)) {
			$data['event_layout'] = $this->model_catalog_event->getEventLayouts($this->request->get['event_id']);
		} else {
			$data['event_layout'] = array();
		}
		
		
		if (isset($this->request->post['no_of_sub'])) {
			$data['no_of_sub'] = $this->request->post['no_of_sub'];
		} elseif (isset($event_info)) {
			$data['no_of_sub'] = $event_info['no_of_sub'];
		} else {
			$data['no_of_sub'] = '';
		}

		if (isset($this->request->post['color'])) {
			$data['color'] = $this->request->post['color'];
		} elseif (isset($event_info)) {
			$data['color'] = $event_info['color'];
		} else {
			$data['color'] = '';
		}

		// if (isset($this->request->post['reminder_numdays'])) {
		// 	$data['reminder_numdays'] = $this->request->post['reminder_numdays'];
		// } elseif (isset($event_info)) {
		// 	$data['reminder_numdays'] = $event_info['reminder_numdays'];
		// } else {
		// 	$data['reminder_numdays'] = '';
		// }

		if (isset($this->request->post['customer_group'])) {
			$data['customer_group'] = $this->request->post['customer_group'];
		} elseif (isset($event_info)) {
			$data['customer_group'] = explode(',', $event_info['customer_group']);
		} else {
			$data['customer_group'] = array();
		}

		$this->load->model('design/layout');
		
		$data['layouts'] = $this->model_design_layout->getLayouts();
		
		
		$data['product_related'] = array();
		if (isset($this->request->post['product_related'])) {
			$products = $this->request->post['product_related'];
		} elseif (isset($event_info) && $event_info['product_related']!='') {		
			$products = unserialize($event_info['product_related']);
		} else {
			$products = array();
		}
		$this->load->model('catalog/product');
		foreach ($products as $product_id) {
			$related_info = $this->model_catalog_product->getProduct($product_id);
			
			if ($related_info) {
				$data['product_related'][] = array(
					'product_id' => $related_info['product_id'],
					'name'       => $related_info['name']
				);
			}
		}

		$this->load->model('customer/customer_group');
		$data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();
				
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('catalog/event_form', $data));
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify', 'catalog/event')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		foreach ($this->request->post['event_description'] as $language_id => $value) {
			if ((strlen(utf8_decode($value['title'])) < 3) || (strlen(utf8_decode($value['title'])) > 64)) {
				$this->error['title'][$language_id] = $this->language->get('error_title');
			}
		
			if (strlen(utf8_decode($value['description'])) < 3) {
				$this->error['description'][$language_id] = $this->language->get('error_description');
			}
		}

		if (empty($this->request->post['event_start_time'])){
			$this->error['event_start_time'] = $this->language->get('error_event_start_time');
		}

		if (empty($this->request->post['event_end_time'])){
			$this->error['event_end_time'] = $this->language->get('error_event_end_time');
		}
		
		$start_time_timestamp = strtotime($this->request->post['event_start_time']);
		$end_time_timestamp = strtotime($this->request->post['event_end_time']);

		if($start_time_timestamp > $end_time_timestamp){
			$this->error['warning'] = $this->language->get('error_event_time');
		}

		
		if (empty($this->request->post['event_location'])){
			$this->error['event_location'] = $this->language->get('error_event_location');
		}

		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}
			
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify', 'catalog/event')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
	
	public function export() {
		$sql = "select fname,lname,phone,email,comments,dtadd from ".DB_PREFIX."event_subscribers where event_id='".$this->request->get['event_id']."'";
		$query = $this->db->query($sql);
		$results = $query->rows;
		$out = "First Name, Last Name, Phone, Email, Comments, Date \n";
		foreach ($results as $result) {
			$out .='"'.$result['fname'].'",';
			$out .='"'.$result['lname'].'",';
			$out .='"'.$result['phone'].'",';
			$out .='"'.$result['email'].'",';
			$out .='"'.$result['comments'].'",';
			$out .='"'.$result['dtadd'].'",';
			$out .="\n";
		}
				
		header("Content-type: text/x-csv");
		//header("Content-type: text/csv");
		//header("Content-type: application/csv");
		header("Content-Disposition: attachment; filename=subscribers.csv");
		echo $out;
		die();
	}	

	/**
	 * Send notification to subscribers,.
	 */
	public function send_notification() 
	{
		$this->load->model('catalog/event');
		$this->load->model('setting/store');
		$sql = "select * from ".DB_PREFIX."event_subscribers where notification_sent = 0";
		$query = $this->db->query($sql);
		$results = $query->rows;
		$today = date('Y-m-d');
		foreach ($results as $k => $v) {
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "events i LEFT JOIN " . DB_PREFIX . "event_description id ON (i.event_id = id.event_id) WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "' AND i.event_id = " . $v['event_id']);
			$event = $query->row;
			if (!$event['reminder_numdays']) {
				continue;
			}
			$reminder_date = date('Y-m-d', strtotime($event['event_date'] . "-" . $event['reminder_numdays'] . " days"));
			$store_info = $this->model_setting_store->getStore($this->config->get('config_store_id'));
			if ($store_info) {
				$store_name = $store_info['name'];
			} else {
				$store_name = $this->config->get('config_name');
			}
			if ($today == $reminder_date) {
				$subject = "Reminder for " . $event['title'];
				$message = 'Hello ' . $v['fname'] . '<br><br>'; 
				$message.= 'You asked us to send you a reminder for the following event.'; 
				$message.= '<br><br>';
				$message.= '<h2>' . $event['title'] . '</h2>';
				$message.= date('W, F d, Y', strtotime($event['event_date']));
				$message.= '<br><br>You can view the details here: ' . $this->url->link('information/event', 'event_id=' . $v['event_id'], true);
				$message.= '<br><br>Best Regards,<br>';
				$message.= $store_name;
				$mail = new Mail();
				$mail->protocol = $this->config->get('config_mail_protocol');
				$mail->parameter = $this->config->get('config_mail_parameter');
				$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
				$mail->smtp_username = $this->config->get('config_mail_smtp_username');
				$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
				$mail->smtp_port = $this->config->get('config_mail_smtp_port');
				$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

				$mail->setTo($v['email']);
				$mail->setFrom($this->config->get('config_email'));
				$mail->setSender(html_entity_decode($store_name, ENT_QUOTES, 'UTF-8'));
				$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
				$mail->setHtml($message);
				$mail->send();
				$this->db->query("UPDATE ".DB_PREFIX."event_subscribers 
					SET notification_sent = 1
					WHERE id = " . $v['id']);
			}
		}
	}
}
?>