<?php

class ControllerCatalogBarcode extends Controller
{
    private $error = array();
    public function index()
    {
        $this->load->model('catalog/barcode');
        $this->load->language('catalog/barcode');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->getList();
    }

    protected function getList()
    {
        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = null;
        }

        if (isset($this->request->get['filter_model'])) {
            $filter_model = $this->request->get['filter_model'];
        } else {
            $filter_model = null;
        }


        if (isset($this->request->get['filter_code'])) {
            $filter_code = $this->request->get['filter_code'];
        } else {
            $filter_code = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_model'])) {
            $url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_code'])) {
            $url .= '&filter_code=' . urlencode(html_entity_decode($this->request->get['filter_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] =   array();

        $data['breadcrumbs'][] =   array(
            'text' =>  $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] =   array(
            'text' =>  $this->language->get('heading_title'),
            'href' =>  $this->url->link('catalog/', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['print'] = $this->url->link('catalog/add', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['products'] = array();

        $filter_data = array(
            'filter_name' => $filter_name,
            'filter_model' => $filter_model,
            'filter_code' => $filter_code,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $results = $this->model_catalog_barcode->getProducts($filter_data);
        $total_product = $this->model_catalog_barcode->getTotalProducts($filter_data);

        $this->load->model('tool/image');

        foreach ($results as $product) {
            if (is_file(DIR_IMAGE . $product['image'])) {
                $image = $this->model_tool_image->resize($product['image'], 40, 40);
            } else {
                $image = $this->model_tool_image->resize('no_image.png', 40, 40);
            }

            $data['products'][] = array(
                "product_id" => $product['product_id'],
                'image' => $image,
                "name" => $product['name'],
                "uom" => $product['unit'],
                "model_concat" => $product['model'],
                "code" => $product['code'],
                "print_barcode" => ''
            );
        }
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_model'])) {
            $url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_code'])) {
            $url .= '&filter_code=' . urlencode(html_entity_decode($this->request->get['filter_code'], ENT_QUOTES, 'UTF-8'));
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_name'] = $this->url->link('catalog/barcode', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.name' . $url, true);
        $data['sort_model'] = $this->url->link('catalog/barcode', 'user_token=' . $this->session->data['user_token'] . '&sort=p.model' . $url, true);
        $data['sort_code'] = $this->url->link('catalog/barcode', 'user_token=' . $this->session->data['user_token'] . '&sort=p.code' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_model'])) {
            $url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_code'])) {
            $url .= '&filter_code=' . urlencode(html_entity_decode($this->request->get['filter_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $total_product;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/barcode', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_product) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_product - $this->config->get('config_limit_admin'))) ? $total_product : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_product, ceil($total_product / $this->config->get('config_limit_admin')));


        $data['user_token'] = $this->session->data['user_token'];

        $data['filter_name'] = $filter_name;
        $data['filter_model'] = $filter_model;
        $data['filter_code'] = $filter_code;

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('catalog/barcode_list', $data));
    }





    public function printProduct_backup()
    {
        //load core api function
        require DIR_SYSTEM . "/library/tcpdf/tcpdf.php";
        $product_id = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : '';
        $quantity = !empty($this->request->get['quantity']) ? $this->request->get['quantity'] : 0;

        //this parameter for quantity to be include in barcode data
        $include_qty = !empty($this->request->get['include_qty']) ? $this->request->get['include_qty'] : false;
        $include_qty = $include_qty == 'Y' ? true : false;

        $this->load->model('catalog/barcode');




        if ($product_id) {
            $product_info = $this->model_catalog_barcode->getProduct($product_id);

            $uom = $product_info['unit'];

            $product_name = mb_substr($product_info['chinese_name'], 0, 8);
            $product_pinyin = substr($product_info['pinyin'], 0, 25);
            $product_code = $product_info['code'];
            $barcode_data = $product_id;
            if (!empty($quantity)) {
                if ($include_qty) {
                    $barcode_data .= " " . $quantity;
                }
                $qty_text = "$quantity $uom";
            }

            $pageLayout = array(60, 40);
            $pdf = new TCPDF('L', PDF_UNIT, $pageLayout, true, 'UTF-8', false);

            //set title
            $pdf->SetTitle($product_name);
            // set font
            $pdf->SetFont('stsongstdlight', '', 14);

            // set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, 0);

            // set image scale factor
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

            // remove default header/footer
            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);

            //set margin
            $pdf->SetMargins(0, 0);

            // add a page
            $pdf->AddPage();


            // define barcode style
            $style = array(
                'position' => '',
                'align' => 'C',
                'stretch' => false,
                'fitwidth' => true,
                'cellfitalign' => 'C',
                'border' => false,
                'hpadding' => '0',
                'vpadding' => '0',
                'fgcolor' => array(0, 0, 0),
                'bgcolor' => false, //array(255,255,255),
                'text' => false,
                'font' => 'helvetica',
                'fontsize' => 8,
                'stretchtext' => 4
            );
            // CODE 128 AUTO
            $pdf->Ln();
            $pdf->Cell(0, 0, $product_name, 0, 1, 'C');
            $pdf->Cell(0, 0, $product_pinyin, 0, 1, 'C');
            $pdf->write1DBarcode($barcode_data, 'C128', '', '', '', '', '', $style, 'N');
            $pdf->Cell(0, 0, $product_code, 0, 1, 'C');
            if ($quantity > 0) {
                $pdf->Cell(0, 0, $qty_text, 0, 1, 'C');
            }


            //Close and output PDF document
            $pdf->Output($product_code . '.pdf', 'I');
        } else {
            echo "Not found";
        }
    }

    public function printProduct()
    {
        $product_id = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : '';
        $quantity = !empty($this->request->get['quantity']) ? $this->request->get['quantity'] : 0;

        //this parameter for quantity to be include in barcode data
        $include_qty = !empty($this->request->get['include_qty']) ? $this->request->get['include_qty'] : false;
        $include_qty = $include_qty == 'Y' ? true : false;

        if ($product_id) {
            $data[] = array(
                "product_id" => $product_id,
                "qty" => $quantity,
                "include_qty" => $include_qty
            );
            $this->printProductBarcode($data);
        } else {
            echo "Not found";
        }
    }

    public function printMultiProduct()
    {
        $products = !empty($this->request->get['products']) ? $this->request->get['products'] : '';
        //this parameter for quantity to be include in barcode data
        $include_qty = !empty($this->request->get['include_qty']) ? $this->request->get['include_qty'] : false;
        $include_qty = $include_qty == 'Y' ? true : false;
        if (!empty($products)) {
            $products = explode(',', $products);
            foreach ($products as $product) {
                $id_qty = explode('-', $product);
                $data[] = array(
                    "product_id" => $id_qty[0],
                    "qty" => isset($id_qty[1]) ? $id_qty[1] : 0,
                    "include_qty" => $include_qty
                );
            }
            $this->printProductBarcode($data);
        } else {
            echo "Not found";
        }
    }

    private function printProductBarcode($data)
    {
        //load core api function
        // define('K_TCPDF_CALLS_IN_HTML', true);
        require DIR_SYSTEM . "/library/tcpdf/tcpdf.php";
        $this->load->model('catalog/barcode');

        $pageLayout = array(60, 40);
        $pdf = new TCPDF('L', PDF_UNIT, $pageLayout, true, 'UTF-8', false);

        //set title
        $pdf->SetTitle('Product Barcode');
        // set font

        $custom_font = TCPDF_FONTS::addTTFfont(DIR_APPLICATION . 'view/stylesheet/fonts/huawenxingkai.ttf');

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 0);

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // remove default header/footer
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        //set margin
        $pdf->SetMargins(0, 0);

        // define barcode style
        $style = array(
            'position' => '',
            'border' => false,
            'align' => 'C',
            'stretch' => true,
            'fitwidth' => false,
            'cellfitalign' => 'C',
            'hpadding' => 'auto',
            'vpadding' => '0',
            'fgcolor' => array(0, 0, 0),
            'bgcolor' => false, //array(255,255,255),
            'text' => false,
            'font' => 'helvetica',
            'fontsize' => 8,
            'stretchtext' => 4
        );
        foreach ($data as $product) {
            $product_id = $product['product_id'];
            $qty = $product['qty'];
            $include_qty = $product['include_qty'];
            $product_info = $this->model_catalog_barcode->getProduct($product_id);

            $uom = $product_info['unit'];

            $product_name = str_replace("(", " ( ", $product_info['chinese_name']);
            $product_name = str_replace(")", " ) ", $product_name);
            // $pattern = "/\p{Han}/";
            //         if(preg_match_all($pattern, $product_name, $matches, PREG_OFFSET_CAPTURE, 0)) {
            //             var_dump($matches);
            //             die();
            //             foreach($matches as $word){
            //                 $product_name = str_replace($word,$word.' lklk',$product_name);
            //             }
            //         }
            //$product_pinyin = substr($product_info['pinyin'], 0, 25);
            $product_code = $product_info['code'];
            $barcode_data = $product_id;
            $qty_text = "";
            if (!empty($qty)) {
                if ($include_qty) {
                    $barcode_data .= " " . $qty;
                }
                $qty_text = " - $qty$uom";
            }

            // add a page
            $pdf->AddPage();

            $param = $pdf->serializeTCPDFtagParameters(array($barcode_data, 'C128', '', '', '', '9', '', $style, 'M'));
            // $params = $pdf->serializeTCPDFtagParameters(array('CODE 128', 'C128', '', '', 80, 30, 0.4, array('position'=>'S', 'border'=>true, 'padding'=>4, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>8, 'stretchtext'=>4), 'N'));
            $html = '<table style="padding-top: 10px;"><tr><td><span style="font-family: huawenxingkai; font-size: 20px; text-align: center; ">' . $product_name . '</span></td></tr>';
            $html .= '<tr><td><tcpdf method="write1DBarcode" params="'. $param . '"/></td></tr>';
            $html .= '<tr><td><span style="font-family: helvetica; text-align: center; font-size: 16px; font-weight: bold;">' . $product_code .'</span><span style="font-family: helvetica; font-size: 16px;font-weight: bold;">' . $qty_text .'</span></td></tr></table>';

            // CODE 128 AUTO
            // $pdf->SetFont($custom_font, 'B', 16);
            // $pdf->Cell(0, 0, $product_name, 0, 1, 'C');
            $pdf->writeHTML($html);
            // if ($qty > 0) {
            //     $pdf->SetFont('helvetica', 'B', 8);
            //     $pdf->Cell(0, 0, $qty_text, 0, 1, 'C');
            // }
            //$pdf->Cell(0, 0, $product_pinyin, 0, 1, 'C');
            // $pdf->write1DBarcode($barcode_data, 'C128', '', '', '', '', '', $style, 'N');

            // $pdf->SetFont('helvetica', '', 8);
            
            // $pdf->Cell(0, 0, $product_code, 0, 1, 'C');
        }

        // $pdf->lastPage();
        //Close and output PDF document
        $pdf->Output($product_code . '.pdf', 'I');
        
    }
}
