<?php
class ControllerAppointmentAppointmentSetting extends Controller {
    private $error = [];
    private $appointment_status = ['pending', 'confirm', 'canceled', 'attended', 'draft'];
    private $list_view_type = ['calendar', 'month_calendar', 'list'];

    public function index() {
        $this->load->language('appointment/appointment_setting');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/appointment_setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_appointment_appointment_setting->save_settings($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success_appointment_settings');

			$this->response->redirect($this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'], 'SSL'));
        }

        $this->getSettingsForm();
    }

    protected function getSettingsForm() {        		
		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-colorpicker.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-colorpicker.min.css');
        
        $appointment_settings = $this->get_settings();

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment_setting', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
        );

        $language_arr = ['heading_title', 'button_save', 'button_cancel', 'text_appointment_settings_form', 'entry_create_new_cs_status', 'text_select', 'text_enabled', 'text_disabled', 'entry_create_new_cs_appointment_status', 'help_create_new_cs_appointment_status', 'text_create_new_cs', 'text_customer_mapping', 'entry_customer_mapping_status', 'entry_customer_mapping_column', 'text_telephone', 'text_email', 'text_appointment_status', 'entry_pending_color', 'entry_confirm_color', 'entry_canceled_color', 'entry_attended_color', 'entry_draft_color', 'text_appointment_list_view', 'entry_view_type',
        'text_appointment_booking_preference',
        'text_yes',
        'text_no',
        'entry_allow_duplicate',
        'entry_allow_attend_before_date',
        'entry_min_day_advance',
        'entry_grace_period',
        'help_allow_duplicate',
        'help_allow_attend_before_date',
        'help_min_day_advance',
        'help_grace_period'];

        foreach ($language_arr as $language) {
            $data[$language] = $this->language->get($language);
        }

        $data['action'] = $this->url->link('appointment/appointment_setting', 'user_token=' . $this->session->data['user_token'], 'SSL');
        $data['cancel'] = $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'], 'SSL');

        if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
        }
        
        if (isset($this->error['list_view_type'])) {
			$data['error_list_view_type'] = $this->error['list_view_type'];
		} else {
			$data['error_list_view_type'] = '';
        }

        if (isset($this->error['create_new_cs_status'])) {
			$data['error_create_new_cs_status'] = $this->error['create_new_cs_status'];
		} else {
			$data['error_create_new_cs_status'] = '';
        }

        if (isset($this->error['create_new_cs_appointment_status'])) {
			$data['error_create_new_cs_appointment_status'] = $this->error['create_new_cs_appointment_status'];
		} else {
			$data['error_create_new_cs_appointment_status'] = '';
        }

        if (isset($this->error['customer_mapping_status'])) {
			$data['error_customer_mapping_status'] = $this->error['customer_mapping_status'];
		} else {
			$data['error_customer_mapping_status'] = '';
        }

        if (isset($this->error['customer_mapping_column'])) {
			$data['error_customer_mapping_column'] = $this->error['customer_mapping_column'];
		} else {
			$data['error_customer_mapping_column'] = '';
        }

        if (isset($this->error['allow_duplicate'])) {
			$data['error_allow_duplicate'] = $this->error['allow_duplicate'];
		} else {
			$data['error_allow_duplicate'] = '';
        }

        if (isset($this->error['allow_attend_before_date'])) {
			$data['error_allow_attend_before_date'] = $this->error['allow_attend_before_date'];
		} else {
			$data['error_allow_attend_before_date'] = '';
        }

        if (isset($this->request->post['appointment_status'])) {
            $data['appointment_status'] = $this->request->post['appointment_status'];
        } elseif (!empty($appointment_settings)) {
            $data['appointment_status'] = $appointment_settings['appointment_status'];
        } else {
            $data['appointment_status'] = [];
        }

        if (isset($this->request->post['list_view_type'])) {
            $data['list_view_type'] = $this->request->post['list_view_type'];
        } elseif (!empty($appointment_settings)) {
            $data['list_view_type'] = $appointment_settings['list_view_type'];
        } else {
            $data['list_view_type'] = [];
        }

        if (isset($this->request->post['create_new_cs_status'])) {
            $data['create_new_cs_status'] = $this->request->post['create_new_cs_status'];
        } elseif (!empty($appointment_settings)) {
            $data['create_new_cs_status'] = $appointment_settings['create_new_cs_status'];
        } else {
            $data['create_new_cs_status'] = '';
        }

        if (isset($this->request->post['create_new_cs_appointment_status'])) {
            $data['create_new_cs_appointment_status'] = $this->request->post['create_new_cs_appointment_status'];
        } elseif (!empty($appointment_settings)) {
            $data['create_new_cs_appointment_status'] = $appointment_settings['create_new_cs_appointment_status'];
        } else {
            $data['create_new_cs_appointment_status'] = [];
        }

        if (isset($this->request->post['customer_mapping_status'])) {
            $data['customer_mapping_status'] = $this->request->post['customer_mapping_status'];
        } elseif (!empty($appointment_settings)) {
            $data['customer_mapping_status'] = $appointment_settings['customer_mapping_status'];
        } else {
            $data['customer_mapping_status'] = '';
        }

        if (isset($this->request->post['customer_mapping_column'])) {
            $data['customer_mapping_column'] = $this->request->post['customer_mapping_column'];
        } elseif (!empty($appointment_settings)) {
            $data['customer_mapping_column'] = $appointment_settings['customer_mapping_column'];
        } else {
            $data['customer_mapping_column'] = '';
        }

        
        if (isset($this->request->post['min_day_advance'])) {
            $data['min_day_advance'] = $this->request->post['min_day_advance'];
        } elseif (!empty($appointment_settings)) {
            $data['min_day_advance'] = $appointment_settings['min_day_advance'];
        } else {
            $data['min_day_advance'] = '0';
        }

        if (isset($this->request->post['allow_duplicate'])) {
            $data['allow_duplicate'] = $this->request->post['allow_duplicate'];
        } elseif (!empty($appointment_settings)) {
            $data['allow_duplicate'] = $appointment_settings['allow_duplicate'];
        } else {
            $data['allow_duplicate'] = [];
        }

        if (isset($this->request->post['allow_attend_before_date'])) {
            $data['allow_attend_before_date'] = $this->request->post['allow_attend_before_date'];
        } elseif (!empty($appointment_settings)) {
            $data['allow_attend_before_date'] = $appointment_settings['allow_attend_before_date'];
        } else {
            $data['allow_attend_before_date'] = '0';
        }

        if (isset($this->request->post['grace_period'])) {
            $data['grace_period'] = $this->request->post['grace_period'];
        } elseif (!empty($appointment_settings)) {
            $data['grace_period'] = $appointment_settings['grace_period'];
        } else {
            $data['grace_period'] = '10';
        }

        $data['appointment_statuses'] = [];

        foreach ($this->appointment_status as $index => $status) {
            $data['appointment_statuses'][] = [
                'appointment_status_id'     => $index,
                'name'                      => $this->language->get('text_' . $status)
            ];
        }

        $data['view_types'] = [];

        foreach ($this->list_view_type as $index => $type) {
            $data['view_types'][] = [
                'code'      => $type,
                'name'      => $this->language->get('tab_' . $type)
            ];
        }

        $data['services'] = [];
        $services = $this->model_appointment_appointment_setting->getServices();
        foreach ($services as $service) {
            $data['services'][] = array(
                'id' => $service['id'],
                'name' => $service['name']
            );
        }

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('appointment/appointment_settings', $data));
    }

    protected function validateForm() {
        if (!$this->user->hasPermission('modify', 'appointment/appointment_setting')) {
			$this->error['warning'] = $this->language->get('error_permission');
        }
        
        if (!isset($this->request->post['list_view_type'])) {
			$this->error['list_view_type'] = $this->language->get('error_list_view_type');
		}

        if ($this->request->post['create_new_cs_status'] == '') {
            $this->error['create_new_cs_status'] = $this->language->get('error_create_new_cs_status');
        }

        if (!isset($this->request->post['create_new_cs_appointment_status'])) {
			$this->error['create_new_cs_appointment_status'] = $this->language->get('error_create_new_cs_appointment_status');
		}

        if ($this->request->post['customer_mapping_status'] == '') {
            $this->error['customer_mapping_status'] = $this->language->get('error_customer_mapping_status');
        }

        if ($this->request->post['customer_mapping_status'] == '1') {
            if (empty($this->request->post['customer_mapping_column'])) {
                $this->error['customer_mapping_column'] = $this->language->get('error_customer_mapping_column');
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    private function get_settings(){
        $setting_results = [];

        $this->load->model('appointment/appointment_setting');

        $settings = $this->model_appointment_appointment_setting->get_settings();

        if(!empty($settings)){
            foreach($settings as $setting){
                if($setting['serialized'] == '1'){
                    $setting_results[$setting['setting_key']] = unserialize($setting['value']);
                } else{
                    $setting_results[$setting['setting_key']] = $setting['value'];
                }
            }
        }

        return $setting_results;
    }
}
?>