<?php

class ControllerAppointmentAppointmentAvailability extends Controller
{

    private $error = array();


    public function index()
    {
        $this->load->language('appointment/appointment_availability');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/appointment_availability');
        $this->load->model('appointment/appointment');

        $this->createIfNotExist();
        $this->getList();
    }

    public function add()
    {
        $this->load->language('appointment/appointment_availability');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/appointment_availability');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            // var_dump($this->request->post);
            // die();
            $this->model_appointment_appointment_availability->addAvailability($this->request->post);

            $this->syncToEtcm();

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('appointment/appointment_availability', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('appointment/appointment_availability');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/appointment_availability');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_appointment_appointment_availability->editAvailability($this->request->get['doctor_id'], $this->request->post);

            $this->syncToEtcm();

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('appointment/appointment_availability', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function delete()
    {
        $this->load->language('appointment/appointment_availability');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/appointment_availability');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $doctor_id) {
                $this->model_appointment_appointment_availability->deleteAvailability($doctor_id);
            }

            $this->syncToEtcm();

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('appointment/appointment_availability', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    protected function getList()
    {
        if (isset($this->request->get['filter_day'])) {
            $filter_day = $this->request->get['filter_day'];
        } else {
            $filter_day = null;
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'doctor_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_day'])) {
            $url .= '&filter_day=' . $this->request->get['filter_day'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment_availability', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('appointment/appointment_availability/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link('appointment/appointment_availability/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['availabilitys'] = array();

        $filter_data = array(
            'filter_day' => $filter_day,
            'filter_doctor' => $filter_doctor,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $availability_total = $this->model_appointment_appointment_availability->getTotalAvailabilitys($filter_data);

        $results = $this->model_appointment_appointment_availability->getAvailabilitys($filter_data);

        foreach ($results as $result) {
            $doctor = $this->model_appointment_appointment->getDoctor($result['doctor_id']);
            $availability_times = $this->model_appointment_appointment_availability->getAvailabilityWorkingHour($result['doctor_id']);

            $doctor_name = $doctor['firstname'] . ' ' . $doctor['lastname'];

            if (!empty($availability_times)) {
                $working_hours = '';
                $working_hour_arr = array();

                foreach ($availability_times as $time) {
                    $working_hour_arr[] = $time['service_day']. ' ' . $time['start_time'] . ' - ' . $time['end_time'];
                }

                // if (!empty($working_hour_arr)) {
                //     $working_hours = implode('<br />', $working_hour_arr);
                // }
            } else {
                $working_hours = '-';
            }

            $data['availabilitys'][] = array(
                'doctor_id' => $result['doctor_id'],
                'doctor' => $doctor_name,
                'open_hours' => $working_hour_arr,
                'edit' => $this->url->link('appointment/appointment_availability/edit', 'user_token=' . $this->session->data['user_token'] . '&doctor_id=' . $result['doctor_id'] . $url, true)
            );

                // echo"<pre>";
                // print_r($data['availabilitys']);
                // echo"</pre>";
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_day'])) {
            $url .= '&filter_day=' . $this->request->get['filter_day'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $availability_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('appointment/appointment_availability', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($availability_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($availability_total - $this->config->get('config_limit_admin'))) ? $availability_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $availability_total, ceil($availability_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['filter_day'] = $filter_day;
        $data['filter_doctor'] = $filter_doctor;

        $data['doctors'] = [];

        $doctors = $this->model_appointment_appointment->getDoctors();

        if (!empty($doctors)) {
            foreach ($doctors as $doctor) {
                $data['doctors'][] = [
                    'user_id' => $doctor['user_id'],
                    'doctor_name' => $doctor['firstname'] . ' ' . $doctor['lastname']
                ];
            }
        }

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('appointment/appointment_availability_list', $data));
    }

    protected function getForm()
    {
        $this->load->model('appointment/appointment');

        $data['text_form'] = !isset($this->request->get['availability_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
        $data['doctor_id'] = isset($this->request->get['doctor_id']) ? $this->request->get['doctor_id'] : '';

        if (isset($this->request->post['doctor_id'])) {
            $data['doctor_id'] = $this->request->post['doctor_id'];
        }elseif (isset($this->request->get['doctor_id'])){
            $data['doctor_id'] = $this->request->get['doctor_id'];
        } else {
            $data['doctor_id'] = '';
        }
       
        $data['days'] = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];

        $data['doctors'] = [];
        if( !empty($data['doctor_id'])){

            $data['doctors'] = $this->model_appointment_appointment_availability->getDoctorsselected( $data['doctor_id']);

        }else{
            $doctors = $this->model_appointment_appointment_availability->getDoctors();

                if (!empty($doctors)) {
                    foreach ($doctors as $doctor) {
                        $data['doctors'][] = [
                            'user_id' => $doctor['user_id'],
                            'doctor_name' => $doctor['firstname'] . ' ' . $doctor['lastname']
                        ];
                    }
                }
        }

        

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['day'])) {
            $data['error_day'] = $this->error['day'];
        } else {
            $data['error_day'] = '';
        }

        if (isset($this->error['minutes'])) {
            $data['error_minutes'] = $this->error['minutes'];
        } else {
            $data['error_minutes'] = '';
        }

        if (isset($this->error['doctor_id'])) {
            $data['error_doctor'] = $this->error['doctor_id'];
        } else {
            $data['error_doctor'] = '';
        }

        $data['error_start_time'] = isset($this->error['start_time']) ? $this->error['start_time'] : NULL;
        $data['error_end_time'] = isset($this->error['end_time']) ? $this->error['end_time'] : NULL;
        $data['error_num_app'] = isset($this->error['num_app']) ? $this->error['num_app'] : NULL;
        $data['error_enable_num_app'] = isset($this->error['enable_num_app']) ? $this->error['enable_num_app'] : NULL;

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment_availability', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['doctor_id'])) {
            $data['action'] = $this->url->link('appointment/appointment_availability/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('appointment/appointment_availability/edit', 'user_token=' . $this->session->data['user_token'] . '&doctor_id=' . $this->request->get['doctor_id'] . $url, true);
        }

        $data['cancel'] = $this->url->link('appointment/appointment_availability', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['doctor_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            // $availability_infos = $this->model_appointment_appointment_availability->getAvailability($this->request->get['doctor_id']);

            // $availability_times = $this->model_appointment_appointment_availability->getAvailabilityTimes($this->request->get['availability_id']);
        }
        if($data['doctor_id']){
        $data['services'] = $this->model_appointment_appointment_availability->get_clinical_service($data['doctor_id']);
            
        }

        $data['user_token'] = $this->session->data['user_token'];

        $data['store_id'] = $this->session->data['store_id'];


        foreach ($data['days'] as $day){ 
            $availability_infos = $this->model_appointment_appointment_availability->getAvailability($data['doctor_id'],$day);

            if(!empty($availability_infos['availability_id'])){
                $availability_id = $availability_infos['availability_id'];
            }else{
                $availability_id = '';

            }

            $availability_times = $this->model_appointment_appointment_availability->getAvailabilityTimes($availability_id);
            $time=[];
			$product_count = 0 ;

            foreach ($availability_times as $availability_time){
                $time[]=[
                    'start_time' => $availability_time['start_time'],
                    'end_time' => $availability_time['end_time'],
                    'num_app' => $availability_time['num_app'],
                    'enable_num_app' => $availability_time['enable_num_app']
                ];
                $product_count++ ;
                $data['product_count']  = $product_count ;
                
            }
            // echo"<pre>";
            // print_r($availability_times);
            // echo"</pre>";
            $availability_services = $this->model_appointment_appointment_availability->getAvailabilityService($availability_id);
            $service='';
            foreach ($availability_services as $availability_service){
                $service[]=
                   $availability_service['service_id']
                ;
            }

            $a[] = [
                'clinical_day' => $day,
                'service' => $service,
                'times' => $time,
            ];
            

        }
        // $data['availability_times']=
        //     $a;
        // echo"<pre>";
        // print_r($this->request->post['availability_times']);
        // echo"</pre>";

        if (isset($this->request->post['availability_times'])) {
            $data['availability_times'] = $this->request->post['availability_times'];
        } else if (!empty($a)) {
            $data['availability_times'] = $a;
        } else {
            $data['availability_times'] = array();
        }

        if (isset($this->request->get['doctor_id'])) {
            $data['disabled'] = 1;
        } else {
            $data['disabled'] = 0;
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('appointment/appointment_availability_form', $data));
    }

    protected function validateForm()
    {
        // echo"<pre>";

        // // var_dump($this->request->post);
        // print_r($this->request->post);

        // echo"</pre>";

            // die();
        if (!$this->user->hasPermission('modify', 'appointment/appointment_availability')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

       

        // if (empty($this->request->post['minutes'])) {
        //     $this->error['minutes'] = $this->language->get('error_minutes');
        // }

        if (isset($this->request->post['availability_times'])) {
     
            


                foreach($this->request->post['availability_times'] as $type){

                    $check_available = $this->model_appointment_appointment_availability->checkDuplicate( $this->request->post['doctor_id'], $this->request->post['store_id']);
                    if(!isset($this->request->get['doctor_id'])){
                        if (!empty($check_available)) {
                            if (!isset($this->request->get['doctor_id'])) {
                                $this->error['warning'] = $this->language->get('error_duplicate');
                            }
                        }
                    }
                    
            
                    // if ((utf8_strlen($type['clinical_day']) < 1)) {
                    //     $this->error['day'] = $this->language->get('error_day');
                    // }
            
                    // echo"<pre>";
            
                    //                 print_r($type['times']);
            
                    //                 echo"</pre>";

                    if(!empty($type['check_day']) && empty($type['times'])){
                        $this->error['warning'] = $this->language->get('error_time');
                    }

                    
            
                if(!isset($this->request->get['doctor_id'])){
                    if ((utf8_strlen($this->request->post['doctor_id']) < 1)) {
                        $this->error['doctor_id'] = $this->language->get('error_doctor');
                    }
                }

                    if(!empty($type['check_day']) && !empty($type['times'])){
                        // echo"<pre>";

                        // print_r($type['check_day']);

                        // echo"</pre>";

                        $previous_start_time = null;
                        $previous_end_time = null;
            foreach ($type['times'] as $counter => $time) {


                if (empty($time['start_time'])) {
                    $this->error['start_time']['availability_times'][$type['clinical_day']][$counter] = $this->language->get('error_start_time');
                }

                if (empty($time['end_time'])) {
                    $this->error['end_time']['availability_times'][$type['clinical_day']][$counter] = $this->language->get('error_end_time');
                }

                if ($time['enable_num_app'] == '') {
                    $this->error['enable_num_app']['availability_times'][$type['clinical_day']][$counter] = $this->language->get('error_enable_num_app');
                }

                if (utf8_strlen($time['num_app']) < 1) {
                    $this->error['num_app']['availability_times'][$type['clinical_day']][$counter] = $this->language->get('error_num_app');
                }

                if (strtotime($time['start_time']) > strtotime($time['end_time'])) {
                    $this->error['start_time']['availability_times'][$type['clinical_day']][$counter] = $this->language->get('error_invalid_time');
                    $this->error['end_time']['availability_times'][$type['clinical_day']][$counter] = $this->language->get('error_invalid_time');
                }

                if (($previous_start_time !== null && strtotime($time['start_time']) < $previous_start_time) || ($previous_end_time !== null && strtotime($time['start_time']) < $previous_end_time)) {
                    $this->error['start_time']['availability_times'][$type['clinical_day']][$counter] = $this->language->get('error_invalid_time');
                }

                $start_time=strtotime($time['start_time']);
                $end_time=strtotime($time['end_time']);

                
                $previous_start_time = $start_time;
                $previous_end_time = $end_time;

                // if ($counter > 0) {
                //     $previous_counter = $counter - 1;
                //     $previous_arr = $this->request->post['availability_times'][$previous_counter];

                    // if (strtotime($time['end_time']) < strtotime($time['start_time'])) {
                    //     $this->error['start_time']['availability_times'][$counter] = $this->language->get('error_invalid_time');
                    // }
                // }
            }
        }

        }
        // }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }
// var_dump($this->error); 
        return !$this->error;
    }

    protected function validateDelete()
    {
        if (!$this->user->hasPermission('modify', 'appointment/appointment_availability')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    protected function syncToEtcm()
    {

        $db_availabilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_availability")->rows;
        $doctor_availabilities = [];
        foreach ($db_availabilities as $availability) {
            $db_times = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_availability_time WHERE availability_id = '" . (int)$availability['availability_id'] . "'")->rows;
            $db_services = $this->db->query("SELECT * FROM " . DB_PREFIX . "availability_to_service WHERE availability_id = '" . (int)$availability['availability_id'] . "'")->rows;
            $doctor_availabilities[] = [
                'availability_id'   => $availability['availability_id'],
                'doctor_id'         => $availability['doctor_id'],
                'store_id'          => $availability['store_id'],
                'minutes'           => $availability['minutes'],
                'day'               => $availability['day'],
                'times'             => $db_times,
                'services'          => $db_services,
            ];
        }
        $post_data = [
            'store_url' => HTTPS_CATALOG,
            'doctor_availabilities' => $doctor_availabilities
        ];

        $path = 'etcm/syncing/syncing/update_doctor_availabilities';
        $result = $this->connectCurl($path, $post_data);
        return $result;
    }

    private function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = 'https://www.etcm.me/' . 'doctorapp/v2/index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }

    private function createIfNotExist()
    {
        $availability_service = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "availability_to_service'")->num_rows;
        if (!$availability_service) {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "availability_to_service` (
                `availability_id` int(11) NOT NULL,
                `service_id` int(11) NOT NULL,
                PRIMARY KEY (availability_id, service_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }
    }

    public function getservicebydoctor(){

        $this->load->model('appointment/appointment_availability');
        $json = [];
        $returned_data = [];
        $doctor_id = (isset($this->request->post['doctor_id'])) ? $this->request->post['doctor_id'] : array();

        if($doctor_id){
            $services = $this->model_appointment_appointment_availability->getservicebydoctor($doctor_id);
            // print_r($products['onhand']);
            foreach($services as $service){
                        if (!empty($service)) {
                            $returned_data[] = [
                                'service_id' => $service['service_id'],
                                'service_name' => $service['csservice_name'],
                               
                            ];
                        }
                    // print_r($products);
                    }
                $json = [
                    'error' => false,
                    'data' => $returned_data,
                    'message' => 'get products data success'
                ];
            
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
}
