<?php

class ControllerAppointmentAppointment extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('appointment/appointment');

        $this->document->setTitle($this->language->get('heading_title'));
        $this->document->addStyle('view/stylesheet/fullcalendar.min.css');
        $this->document->addStyle('view/stylesheet/fullcalendar_etcm.css');
        $this->document->addStyle('view/stylesheet/scheduler.min.css');
        $this->document->addScript('view/javascript/fullcalendar.min.js');
        $this->document->addScript('view/javascript/scheduler.min.js');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $this->load->model('appointment/appointment');

        $this->getList();
    }

    public function add()
    {
        $this->load->language('herbal/herbal');
        $this->load->language('appointment/appointment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('customer/customer');
        $this->load->model('appointment/appointment');

        $customer_id = isset($this->request->get['customer_id']) ? $this->request->get['customer_id'] : false;

        // $email = isset($this->request->get['email']) ? $this->request->get['email'] : false;

        // $telephone = isset($this->request->get['telephone']) ? $this->request->get['telephone'] : false;

        $data['customer_id'] = $customer_id ? $this->request->get['customer_id'] : 0;

        if (isset($this->request->get['customer_id'])) {
            $customer = $this->model_appointment_appointment->getCustomerbyid($this->request->get['customer_id']);
            if (!empty($customer)) {
                $data['customer_id'] = $customer['customer_id'];
                $data['customer_name'] = $customer['firstname'] . ' ' . $customer['lastname'];
                $data['customer_ic'] = $customer['customer_ic'];

                $data['email'] = $customer['email'];
                $data['telephone'] = $customer['telephone'];
                $data['new'] =  0;
                $data['clinicalservice_id'] = ''; //null for return customer
                $data['got_appointment_date'] = isset($this->request->get['appointment_date']) ? true : false;
                $data['appointment_date'] = isset($this->request->get['appointment_date']) ? $this->request->get['appointment_date'] : '';

                $data['got_appointment_time'] = isset($this->request->get['appointment_time']) ? true : false;
                $data['appointment_time'] = isset($this->request->get['appointment_time']) ? date('h:i A', strtotime($this->request->get['appointment_time'])) : '';

                $data['got_doctor_id'] = isset($this->request->get['doctor_id']) ? true : false;
                $data['doctor_id'] = isset($this->request->get['doctor_id']) ? $this->request->get['doctor_id'] : 0;

                $appointment_id = $this->model_appointment_appointment->addAppointment($data);

                $this->session->data['success'] = $this->language->get('text_success');

                if ($appointment_id > 0) {
                    $this->response->redirect($this->url->link('appointment/appointment/edit', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $appointment_id . '&admin_add=1', true));
                } else {
                    $this->response->redirect($this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'], true));
                }
            }
        }

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateFormCustomer()) {
            $customer_ic = !empty($this->request->post['customer_ic']) ? $this->request->post['customer_ic'] : '';

            $customer_info = [];
            if (!empty($customer_ic)) {
                $customer_info = $this->model_customer_customer->customerExistsByIc($customer_ic);
            }

            if (empty($customer_info)) {
                //new customer
                $data['customer_id'] = $this->model_appointment_appointment->addCustomer($this->request->post);
                $data['customer_name'] = $this->request->post['firstname'] . ' ' . $this->request->post['lastname'];
                $data['customer_ic'] = $this->request->post['customer_ic'];
                $data['email'] = $this->request->post['email'];
                $data['telephone'] = $this->request->post['telephone'];
                $data['new'] = true;
                $data['clinicalservice_id'] = 1; //default service 1 (Doctor Consultation)
                $new = 1;
            } else {
                //reutrn customer
                $data['customer_id'] = $customer_info['customer_id'];
                $data['customer_name'] = $customer_info['firstname'] . ' ' . $customer_info['lastname'];
                $data['customer_ic'] = $customer_info['customer_ic'];
                $data['email'] = $customer_info['email'];
                $data['telephone'] = $customer_info['telephone'];
                $data['new'] = false;
                $data['clinicalservice_id'] = ''; //null for return customer
                $new = 0;
            }

            $data['got_appointment_date'] = isset($this->request->get['appointment_date']) ? true : false;
            $data['appointment_date'] = isset($this->request->get['appointment_date']) ? $this->request->get['appointment_date'] : '';

            $data['got_appointment_time'] = isset($this->request->get['appointment_time']) ? true : false;
            $data['appointment_time'] = isset($this->request->get['appointment_time']) ? date('h:i A', strtotime($this->request->get['appointment_time'])) : '';

            $data['got_doctor_id'] = isset($this->request->get['doctor_id']) ? true : false;
            $data['doctor_id'] = isset($this->request->get['doctor_id']) ? $this->request->get['doctor_id'] : 0;

            $appointment_id = $this->model_appointment_appointment->addAppointment($data);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name=' . $this->request->get['filter_name'];
            }

            if (isset($this->request->get['filter_no'])) {
                $url .= '&filter_no=' . $this->request->get['filter_no'];
            }

            if (isset($this->request->get['filter_ic'])) {
                $url .= '&filter_ic=' . $this->request->get['filter_ic'];
            }

            if (isset($this->request->get['filter_date'])) {
                $url .= '&filter_date=' . $this->request->get['filter_date'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            if (isset($appointment_id) && $appointment_id != 0) {
                $url .= '&appointment_id=' . $appointment_id;
            }

            $url .= '&new=' . $new;

            $this->response->redirect($this->url->link('appointment/appointment/edit', 'user_token=' . $this->session->data['user_token'] . $url . '&admin_add=1', true));
        }

        $this->getFormCustomer();
    }

    public function edit()
    {
        $this->load->model('setting/setting');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');

        $this->load->language('herbal/herbal');
        $this->load->language('appointment/appointment');
        $this->load->language('mail/appointment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->document->addStyle('view/stylesheet/appointment_form.css');
        $this->document->addStyle('view/stylesheet/fullcalendar.min.css');
        $this->document->addScript('view/javascript/fullcalendar.min.js');

        $this->load->model('appointment/appointment');
        $this->load->model('customer/customer');

        $notification = new Notification($this->registry);

        $url = $this->getFilterUrl();

        // Check the appointment id is not empty
        if (empty($this->request->get['appointment_id'])) {
            $this->response->redirect($this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $appointment_info = $this->model_appointment_appointment->getGeneralAppointment($this->request->get['appointment_id']);

        // Check and valid the appointment is not attended
        if (!empty($appointment_info['status']) && $appointment_info['status'] == 3) {
            $url .= '&appointment_id=' . $this->request->get['appointment_id'];
            $this->response->redirect($this->url->link('appointment/appointment/view', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateFormAppointment()) {
            // Check and valid the appointment details is not empty
            if (empty($appointment_info)) {
                $this->response->redirect($this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true));
            }

            $appointment_date = $appointment_info['appointment_date'];
            $appointment_time = $appointment_info['appointment_time'];
            $appointment_status = $appointment_info['status'];

            $result = $this->model_appointment_appointment->editAppointment($this->request->get['appointment_id'], $this->request->post);

            $store = $this->model_appointment_appointment->getStore($this->request->get['appointment_id']);

            if ($store) {
                $store_name = $store['name'];
            } else {
                $store_name = $this->config->get('config_name');
            }

            if ($this->request->post['status'] == 3) {
                $this->model_appointment_appointment->insertOrUpdateCustomer($this->request->get['appointment_id']);

                // gcm for user app
                if ($appointment_info['from_etcm'] > 0) {
                    $this->pushToUserApp($this->request->get['appointment_id'], '4', $appointment_info['from_etcm'], $this->request->post['date'], $this->request->post['time']);
                }

                if ($this->request->post['customer_id'] > 0) {
                    //herbalremedies
                    //$service_type = $this->model_appointment_appointment->get_service_type($this->request->post['service']);

                    $transaction_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));
                    $herbal_id = $this->model_appointment_appointment->addHerbal($this->request->post, $transaction_no);

                    $this->load->model('herbal/herbal');
                    $this->load->model('customer/customer');

                    $herbal_row = $this->model_herbal_herbal->getHerbal($herbal_id);

                    if ($herbal_row['doctor_id'] != 0) {
                        $notification_template = $this->config->get('config_gcm_new_herbal');

                        if ($notification_template['status'] == '1') {
                            $template_title = $notification_template['title'];
                            $template_message = $notification_template['message'];

                            $customer_data = $this->model_customer_customer->getCustomer($herbal_row['customer_id']);
                            $customer_name = $customer_data['firstname'] . ' ' . $customer_data['lastname'];

                            $invoice_prefix = $herbal_row['invoice_prefix'];

                            $find_title = array(
                                '{customer_name}'
                            );

                            $replace_title = array(
                                'customer_name' => $customer_name
                            );

                            $find_message = array(
                                '{invoice_prefix}'
                            );

                            $replace_message = array(
                                'invoice_prefix' => $invoice_prefix
                            );

                            $notification_title = str_replace($find_title, $replace_title, $template_title);
                            $notification_message = str_replace($find_message, $replace_message, $template_message);

                            $notification_data = array(
                                'body'          => $notification_title,
                                'badge'         => 1,
                                'sound'         => 'ping.aiff'
                            );

                            $data_gcm = array(
                                'title' => $notification_title,
                                'message' => $notification_message,
                                'user_id' => $herbal_row['doctor_id'],
                                'type' => 2      // New herbal remedies type
                            );

                            $doctor_device = $this->model_herbal_herbal->getDoctorDevice($herbal_row['doctor_id']);

                            if (!empty($doctor_device)) {
                                $gcm = new GCM($this->registry);
                                $gcm->sendTo($gcm->get_user_token($herbal_row['doctor_id']))
                                    ->setData($data_gcm)
                                    ->setIosNotification($notification_data)
                                    ->setContentAvailable(true)
                                    ->send();
                            }
                        }
                    }


                }

            }

            if ($this->request->post['status'] == 1) {
                //customer
                $customer_id = $appointment_info['customer_id'];

                if ($customer_id > 0) {
                    $customer_data = $this->model_appointment_appointment->getCustomer($this->request->get['appointment_id']);

                    if ($customer_data['country_id'] == 0) {
                        $country_id = $this->config->get('config_country_id');
                    } else {
                        $country_id = $customer_data['country_id'];
                    }

                    $customer_name = $customer_data['firstname'];
                } else {
                    $country_id = $this->config->get('config_country_id');

                    $customer_name = $appointment_info['customer_name'];
                }

                $country_details = $this->model_localisation_country->getCountry($country_id);
                $mobile_code = $country_details['mobile_code'];

                if (isset($this->request->post['doctor'])) {
                    if ($this->request->post['doctor'] > 0) {
                        $doctor = $this->model_appointment_appointment->getDoctor($this->request->post['doctor']);

                        $doctor_name = $doctor['firstname'] . ' ' . $doctor['lastname'];
                    } else {
                        $doctor_name = '';
                    }
                }

                if (($this->request->post['appointment_date'] == $appointment_date) && ($this->request->post['appointment_time'] == $appointment_time)) {
                    if ((!empty($this->request->post['email'])) || ($this->request->post['email'] != '-')) {
                        $appointment_details = array();

                        $appointment_details['url'] = HTTPS_CATALOG;

                        if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
                            $appointment_details['image'] = HTTPS_IMAGE . $this->config->get('config_logo');
                        } else {
                            $appointment_details['image'] = '';
                        }

                        if (!empty($customer_name)) {
                            $appointment_details['customer_name'] = $customer_name;
                        } else {
                            $appointment_details['customer_name'] = '';
                        }


                        $appointment_details['appointment_date'] = $this->request->post['appointment_date'];
                        $appointment_details['appointment_time'] = $this->request->post['appointment_time'];
                        $appointment_details['store_name'] = $store_name;
                        $appointment_details['doctor_name'] = $doctor_name;

                        $store_id = $this->config->get('config_store_id');
                        $store_info = $this->model_setting_setting->getSetting('config', $store_id);
                        $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                        $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                        //address
                        $appointment_details['config_name'] = $store_info['config_name'];
                        $appointment_details['config_address'] = nl2br($store_info['config_address']);
                        $appointment_details['config_country'] = $country['name'];
                        $appointment_details['config_zone'] = $zone['name'];
                        $appointment_details['config_telephone'] = $store_info['config_telephone'];
                        $appointment_details['config_email'] = $store_info['config_email'];

                        $subject = sprintf($this->language->get('text_subject'), $appointment_details['appointment_date']);

                        $message = $this->load->view('appointment/email', $appointment_details);

                        $mail = new Mail($this->config->get('config_mail_engine'));
                        $mail->parameter = $this->config->get('config_mail_parameter');
                        $mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
                        $mail->smtp_username = $this->config->get('config_mail_smtp_username');
                        $mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
                        $mail->smtp_port = $this->config->get('config_mail_smtp_port');
                        $mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

                        if (!empty($this->request->post['email']) && filter_var($this->request->post['email'])) {
                            $mail->setTo($this->request->post['email']);
                            $mail->setFrom($this->config->get('config_email'));
                            $mail->setSender($store_name);
                            $mail->setSubject($subject);
                            $mail->setHtml($message);
                            $mail->send();
                        }
                    }

                    //SMS
                    $sms_appointment_info = $this->config->get('config_sms_appointment');

                    if ($sms_appointment_info['status'] == '1' && !empty($this->request->post['telephone'])) {
                        $appointment_template = $sms_appointment_info['template'];

                        $find = array(
                            '{action}',
                            '{date}',
                            '{time}',
                            '{storename}'
                        );

                        $replace = array(
                            'action' => 'confirmed on',
                            'date' => $this->request->post['date'],
                            'time' => $this->request->post['time'],
                            'storename' => $store_name
                        );

                        $sms_message = str_replace($find, $replace, $appointment_template);

                        $telephone = $this->request->post['telephone'];

                        if (substr($telephone, 0, 2) == '+6') {
                            $final_telephone = str_replace('+6', '', $telephone);
                        } else {
                            $final_telephone = $telephone;
                        }

                        $sms = new SMS($this->config->get('config_sms'));
                        $sms->sendTo($mobile_code, $final_telephone)->setMessage($sms_message)->send();
                    }

                    // gcm for user app
                    if ($appointment_info['from_etcm'] > 0) {
                        $this->pushToUserApp($this->request->get['appointment_id'], '1', $appointment_info['from_etcm'], $this->request->post['date'], $this->request->post['time']);
                    }
                } else {
                    // set indicator to reconfirm
                    $this->model_appointment_appointment->require_reconfirm($this->request->get['appointment_id']);

                    if ((!empty($this->request->post['email'])) || ($this->request->post['email'] != '-')) {
                        $appointment_details = array();

                        $appointment_details['url'] = HTTPS_CATALOG;

                        if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
                            $appointment_details['image'] = HTTPS_IMAGE . $this->config->get('config_logo');
                        } else {
                            $appointment_details['image'] = '';
                        }

                        if (!empty($customer_name)) {
                            $appointment_details['customer_name'] = $customer_name;
                        } else {
                            $appointment_details['customer_name'] = '';
                        }


                        $appointment_details['appointment_date'] = $this->request->post['appointment_date'];
                        $appointment_details['appointment_time'] = $this->request->post['appointment_time'];
                        $appointment_details['store_name'] = $store_name;
                        $appointment_details['doctor_name'] = $doctor_name;

                        $store_id = $this->config->get('config_store_id');
                        $store_info = $this->model_setting_setting->getSetting('config', $store_id);
                        $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                        $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                        //address
                        $appointment_details['config_name'] = $store_info['config_name'];
                        $appointment_details['config_address'] = nl2br($store_info['config_address']);
                        $appointment_details['config_country'] = $country['name'];
                        $appointment_details['config_zone'] = $zone['name'];
                        $appointment_details['config_telephone'] = $store_info['config_telephone'];
                        $appointment_details['config_email'] = $store_info['config_email'];

                        $subject = sprintf($this->language->get('text_subject_changed'), $appointment_details['appointment_date']);

                        $message = $this->load->view('appointment/changed_appointment_email', $appointment_details);


                        $mail = new Mail($this->config->get('config_mail_engine'));
                        $mail->parameter = $this->config->get('config_mail_parameter');
                        $mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
                        $mail->smtp_username = $this->config->get('config_mail_smtp_username');
                        $mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
                        $mail->smtp_port = $this->config->get('config_mail_smtp_port');
                        $mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

                        if (!empty($this->request->post['email']) && filter_var($this->request->post['email'])) {
                            $mail->setTo($this->request->post['email']);
                            $mail->setFrom($this->config->get('config_email'));
                            $mail->setSender($store_name);
                            $mail->setSubject($subject);
                            $mail->setHtml($message);
                            $mail->send();
                        }
                    }

                    //SMS
                    $sms_appointment_info = $this->config->get('config_sms_appointment');

                    if ($sms_appointment_info['status'] == '1') {
                        $appointment_template = $sms_appointment_info['template'];

                        $find = array(
                            '{action}',
                            '{date}',
                            '{time}',
                            '{storename}'
                        );

                        $replace = array(
                            'action' => 'changed to',
                            'date' => $this->request->post['date'],
                            'time' => $this->request->post['time'],
                            'storename' => $store_name
                        );

                        // $SMS_MESSAGE = STR_REPLACE($FIND, $REPLACE, $APPOINTMENT_TEMPLATE);

                        // $TELEPHONE = $THIS->REQUEST->POST['TELEPHONE'];

                        // IF (SUBSTR($TELEPHONE, 0, 2) == '+6') {
                        //     $FINAL_TELEPHONE = STR_REPLACE('+6', '', $TELEPHONE);
                        // } ELSE {
                        //     $FINAL_TELEPHONE = $TELEPHONE;
                        // }

                        // $SMS = NEW SMS($THIS->CONFIG->GET('CONFIG_SMS'));
                        // $SMS->SENDTO($MOBILE_CODE, $FINAL_TELEPHONE)
                        //     ->SETMESSAGE($SMS_MESSAGE)
                        //     ->SEND();
                    }

                    // gcm for user app
                    if ($appointment_info['from_etcm'] > 0) {
                        $this->pushToUserApp($this->request->get['appointment_id'], '2', $appointment_info['from_etcm'], $this->request->post['date'], $this->request->post['time']);
                    }
                }
            }

            // cancel appointment
            if ($this->request->post['status'] == 2) {
                //customer
                $customer_id = $appointment_info['customer_id'];

                if ($customer_id > 0) {
                    $customer_data = $this->model_appointment_appointment->getCustomer($this->request->get['appointment_id']);

                    if ($customer_data['country_id'] == 0) {
                        $country_id = $this->config->get('config_country_id');
                    } else {
                        $country_id = $customer_data['country_id'];
                    }

                    $customer_name = $customer_data['firstname'];
                } else {
                    $country_id = $this->config->get('config_country_id');

                    $customer_name = $appointment_info['customer_name'];
                }

                $country_details = $this->model_localisation_country->getCountry($country_id);
                $mobile_code = $country_details['mobile_code'];

                if (isset($this->request->post['doctor'])) {
                    if ($this->request->post['doctor'] > 0) {
                        $doctor = $this->model_appointment_appointment->getDoctor($this->request->post['doctor']);

                        $doctor_name = $doctor['firstname'] . ' ' . $doctor['lastname'];
                    } else {
                        $doctor_name = '';
                    }
                }

                if ((!empty($this->request->post['email'])) || ($this->request->post['email'] != '-')) {
                    $appointment_details = array();

                    $appointment_details['url'] = HTTPS_CATALOG;

                    if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
                        $appointment_details['image'] = HTTPS_IMAGE . $this->config->get('config_logo');
                    } else {
                        $appointment_details['image'] = '';
                    }

                    if (!empty($customer_name)) {
                        $appointment_details['customer_name'] = $customer_name;
                    } else {
                        $appointment_details['customer_name'] = '';
                    }


                    $appointment_details['appointment_date'] = $this->request->post['appointment_date'];
                    $appointment_details['appointment_time'] = $this->request->post['appointment_time'];
                    $appointment_details['store_name'] = $store_name;
                    $appointment_details['doctor_name'] = $doctor_name;

                    $store_id = $this->config->get('config_store_id');
                    $store_info = $this->model_setting_setting->getSetting('config', $store_id);
                    $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                    $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                    //address
                    $appointment_details['config_name'] = $store_info['config_name'];
                    $appointment_details['config_address'] = nl2br($store_info['config_address']);
                    $appointment_details['config_country'] = $country['name'];
                    $appointment_details['config_zone'] = $zone['name'];
                    $appointment_details['config_telephone'] = $store_info['config_telephone'];
                    $appointment_details['config_email'] = $store_info['config_email'];

                    $subject = sprintf($this->language->get('text_subject_canceled'), $appointment_details['appointment_date']);

                    $message = $this->load->view('appointment/email_cancel_appointment', $appointment_details);

                    $mail = new Mail($this->config->get('config_mail_engine'));
                    $mail->parameter = $this->config->get('config_mail_parameter');
                    $mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
                    $mail->smtp_username = $this->config->get('config_mail_smtp_username');
                    $mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
                    $mail->smtp_port = $this->config->get('config_mail_smtp_port');
                    $mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

                    if (!empty($this->request->post['email']) && filter_var($this->request->post['email'])) {
                        $mail->setTo($this->request->post['email']);
                        $mail->setFrom($this->config->get('config_email'));
                        $mail->setSender($store_name);
                        $mail->setSubject($subject);
                        $mail->setHtml($message);
                        $mail->send();
                    }
                }

                // SMS
                $sms_appointment_info = $this->config->get('config_sms_appointment');

                if ($sms_appointment_info['status'] == '1') {
                    $appointment_template = $sms_appointment_info['template'];

                    $find = array(
                        '{action}',
                        '{date}',
                        '{time}',
                        '{storename}'
                    );

                    $replace = array(
                        'action' => 'canceled on',
                        'date' => $this->request->post['date'],
                        'time' => $this->request->post['time'],
                        'storename' => $store_name
                    );

                    $sms_message = str_replace($find, $replace, $appointment_template);

                    $telephone = $this->request->post['telephone'];

                    if (substr($telephone, 0, 2) == '+6') {
                        $final_telephone = str_replace('+6', '', $telephone);
                    } else {
                        $final_telephone = $telephone;
                    }

                    $sms = new SMS($this->config->get('config_sms'));
                    $sms->sendTo($mobile_code, $final_telephone)
                        ->setMessage($sms_message)
                        ->send();
                }

                // gcm for user app
                if ($appointment_info['from_etcm'] > 0) {
                    $this->pushToUserApp($this->request->get['appointment_id'], '3', $appointment_info['from_etcm'], $this->request->post['date'], $this->request->post['time']);
                }

                $notification_data = [
                    'appointment_id' => $this->request->get['appointment_id'],
                    'customer_name' => $customer_name,
                    'appointment_date' => $this->request->post['appointment_date']
                ];

                if (($notification->cancel_appointment_notification_status == '1') && ($notification->notification_status == '1')) {
                    $notification->add_notification('cancel_appointment_notification', $notification_data);
                }
            }

            // if status still pending
            if ($this->request->post['status'] == 0) {
                // gcm for user app
                if ($appointment_info['from_etcm'] > 0) {
                    $this->pushToUserApp($this->request->get['appointment_id'], '5', $appointment_info['from_etcm'], $this->request->post['date'], $this->request->post['time']);
                }
            }

            if (isset($this->request->get['admin_add'])) {
                // push to admin web
                if ($this->request->post['customer_id'] > 0) {
                    $customer_info = $this->model_customer_customer->getCustomer($this->request->post['customer_id']);

                    $customer_name = !empty($customer_info) ? $customer_info['firstname'] . ' ' . $customer_info['lastname'] : '';
                } else {
                    $customer_name = '';
                }

                $doctor_info = $this->model_appointment_appointment->getDoctor($this->request->post['doctor']);
                $doctor_name = !empty($doctor_info) ? $doctor_info['firstname'] . ' ' . $doctor_info['lastname'] : '';

                $notification_data = [
                    'appointment_id' => $this->request->get['appointment_id'],
                    'customer_name' => $customer_name,
                    'doctor_name' => $doctor_name,
                    'appointment_date' => $this->request->post['appointment_date'],
                    'appointment_time' => $this->request->post['appointment_time']
                ];

                if (($notification->new_appointment_notification_status == '1') && ($notification->notification_status == '1')) {
                    $notification->add_notification('new_appointment_notification', $notification_data);
                }
            }

            $this->session->data['success'] = $this->language->get('text_success');

            if (isset($this->request->get['appointment_id']) && $this->request->get['appointment_id'] != 0) {
                $url .= '&appointment_id=' . $this->request->get['appointment_id'];
            }

            $this->response->redirect($this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getFormAppointment();
    }

    public function delete()
    {
        $this->load->language('appointment/appointment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/appointment');

        $url = $this->getFilterUrl();

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $appointment_id) {
                $this->model_appointment_appointment->deleteAppointment($appointment_id);

                $appointment_info = $this->model_appointment_appointment->getAppointment($appointment_id);

                if ($appointment_info['from_etcm'] > 0) {
                    $this->pushToUserApp($appointment_id, '3', $appointment_info['from_etcm'], $appointment_info['appointment_date'], $appointment_info['appointment_time']);
                }
            }

            $this->session->data['success'] = $this->language->get('text_success');

            if (isset($appointment_id) && $appointment_id != 0) {
                $url .= '&appointment_id=' . $appointment_id;
            }
        }

        $this->response->redirect($this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true));

        $this->getList();
    }

    public function view()
    {
        $this->load->language('herbal/herbal');
        $this->load->language('appointment/appointment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/appointment');

        $this->getFormView();
    }

    protected function getList()
    {


        $url  = $this->getFilterUrl();
        $url2 = $this->getFilterUrl(true);

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('appointment/appointment/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link('appointment/appointment/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['print_appointments'] = $this->url->link('appointment/appointment/printAppointmentList', 'user_token=' . $this->session->data['user_token'] . $url . '&pdf=1', true);
        $data['print_today_appointments'] = $this->url->link('appointment/appointment/printAppointmentList', 'user_token=' . $this->session->data['user_token'] . $url . '&filter_date_type=today&sort_type=by_doctor_by_date&pdf=1', true);
        $data['print_tommorow_appointments'] = $this->url->link('appointment/appointment/printAppointmentList', 'user_token=' . $this->session->data['user_token'] . $url . '&filter_date_type=tomorrow&sort_type=by_doctor_by_date&pdf=1', true);
        $data['appointment_settings'] = $this->url->link('appointment/appointment_setting', 'user_token=' . $this->session->data['user_token'], 'SSL');


        $filter_data = $this->getFiltersData();

        $results = $this->model_appointment_appointment->getAppointments($filter_data);
        $appointment_total = $this->model_appointment_appointment->getTotalAppointments($filter_data);

        $calendar_year_data = $this->getDateByDateType('this_year');
        $filter_data2 = [
            'filter_date_start' => $calendar_year_data['date_start'],
            'filter_date_end'   => $calendar_year_data['date_end'],
        ];
        $calendar_results = $this->model_appointment_appointment->getAppointments($filter_data2);

        $this->load->model('user/user');

        $data['appointments'] = $this->formattedAppointmentDetails($results, $url);

        $data['calendar_appointments'] = $this->formattedAppointmentDetails($calendar_results, $url);

        $data['min_time'] = $this->getTimeCalendarView('min');
        $data['max_time'] = $this->getTimeCalendarView('max');

        $data['status_color_list'] = [];

        $status_color_list = [0, 1, 2, 3, 4];

        foreach ($status_color_list as $status) {
            $data['status_color_list'][] = $this->getAppointmentStatusColor($status);
        }

        $data['column_created_date'] = $this->language->get('entry_created_date');
        $data['column_from_etcm'] = $this->language->get('entry_from_etcm');
        $data['column_doctor'] = $this->language->get('entry_doctor');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        if ($filter_data['order'] == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['sort']) || isset($this->request->get['page'])) {
            $data['show_appointment_list'] = 1;
        } else {
            $data['show_appointment_list'] = 0;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        // sort
        $data['sort_date'] = $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . '&sort=appointment_date' . $url, true);
        $data['sort_time'] = $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . '&sort=appointment_time' . $url, true);
        $data['sort_doctor_id'] = $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . '&sort=doctor_id' . $url, true);
        $data['sort_name'] = $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_name' . $url, true);
        $data['sort_from_etcm'] = $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . '&sort=from_etcm' . $url, true);
        $data['sort_status'] = $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);
        $data['sort_created_date'] = $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . '&sort=created_date' . $url, true);

        $data['date_types'] = $this->getDateTypes();
        $data['statuses']   = $this->getAppointmentStatus();

        $store_name = $this->config->get('config_name');
        $data['stores'] = [];
        $data['stores'][] = array(
            'id'   => 0,
            'name' => $store_name . $this->language->get('text_default')
        );

        $this->load->model('setting/store');
        $stores = $this->model_setting_store->getStores();
        foreach ($stores as $store) {
            $data['stores'][] = array(
                'id'   => $store['store_id'],
                'name' => $store['name']
            );
        }

        $doctors = $this->model_appointment_appointment->getDoctors();
        foreach ($doctors as $doctor) {
            $data['doctors'][] = array(
                'id'   => $doctor['user_id'],
                'name' => $doctor['firstname'] . ' ' . $doctor['lastname']
            );
        }

        $data['user_view'] = $this->user->user_view;

        if ($this->user->user_position == 2 && $this->user->user_view == 0) {
            $data['user_view'] = 0;
        } else {
            $data['user_view'] = 1;
        }

        $data['user_position'] = $this->user->user_position;

        if ($this->user->user_view == 1) {
            //$data['delete'] = 1;
        } else {
            //$data['delete'] = 0;
        }

        date_default_timezone_set("Asia/Kuala_Lumpur");
        $data['today_date'] = date('Y-m-d');
        $data['tomorrow_date'] = date('Y-m-d', strtotime(' + 1 days'));

        $pagination = new Pagination();
        $pagination->total = $appointment_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url2 . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($appointment_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($appointment_total - $this->config->get('config_limit_admin'))) ? $appointment_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $appointment_total, ceil($appointment_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $filter_data['sort'];
        $data['order'] = $filter_data['order'];

        $data['filter_date_type']    = $filter_data['filter_date_type'];
        $data['filter_date_start']   = $filter_data['filter_date_start'];
        $data['filter_date_end']     = $filter_data['filter_date_end'];
        $data['filter_doctor']       = explode(',', $filter_data['filter_doctor']);
        $data['filter_name']         = $filter_data['filter_name'];
        $data['filter_telephone']    = $filter_data['filter_telephone'];
        $data['filter_email']        = $filter_data['filter_email'];
        $data['filter_remark']       = $filter_data['filter_remark'];
        $data['filter_status']       = $filter_data['filter_status'];
        $data['filter_store']        = $filter_data['filter_store'];
        $data['filter_from_etcm']    = $filter_data['filter_from_etcm'];
        $data['filter_created_date'] = $filter_data['filter_created_date'];

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('appointment/appointment_list', $data));
    }

    protected function getFormCustomer()
    {
        $data['text_form'] = !isset($this->request->get['clinical_sale_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['user_token'] = $this->session->data['user_token'];

        $error_arr = ['warning', 'customer_ic', 'firstname', 'lastname', 'telephone', 'password', 'confirm', 'address', 'dob'];

        foreach ($error_arr as $error_index) {
            if (isset($this->error[$error_index])) {
                $data['error_' . $error_index] = $this->error[$error_index];
            } else {
                $data['error_' . $error_index] = '';
            }
        }

        $url = $this->getFilterUrl();

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $calendar_url = '';

        if (isset($this->request->get['appointment_date'])) {
            $calendar_url .= '&appointment_date=' . $this->request->get['appointment_date'];
        }

        if (isset($this->request->get['appointment_time'])) {
            $calendar_url .= '&appointment_time=' . $this->request->get['appointment_time'];
        }

        if (isset($this->request->get['doctor_id'])) {
            $calendar_url .= '&doctor_id=' . $this->request->get['doctor_id'];
        }

        $data['action'] = $this->url->link('appointment/appointment/add', 'user_token=' . $this->session->data['user_token'] . $url . $calendar_url, true);
        $data['cancel'] = $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $this->load->model('customer/customer_group');

        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

        if (isset($this->request->post['customer_group_id'])) {
            $data['customer_group_id'] = $this->request->post['customer_group_id'];
        } else {
            $data['customer_group_id'] = $this->config->get('config_customer_group_id');
        }

        if (isset($this->request->post['firstname'])) {
            $data['firstname'] = $this->request->post['firstname'];
        } else {
            $data['firstname'] = '';
        }

        if (isset($this->request->post['lastname'])) {
            $data['lastname'] = $this->request->post['lastname'];
        } else {
            $data['lastname'] = '';
        }

        if (isset($this->request->post['home'])) {
            $data['home'] = $this->request->post['home'];
        } else {
            $data['home'] = '';
        }

        if (isset($this->request->post['gender'])) {
            $data['gender'] = $this->request->post['gender'];
        } else {
            $data['gender'] = 1;
        }

        if (isset($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        } else {
            $data['customer_card'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'customer/customer', 'store' => $this->session->data['store_id']));
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['customer_id'])) {
            $data['customer_id'] = $this->request->post['customer_id'];
        } else {
            $data['customer_id'] = 0;
        }


        if (isset($this->request->post['email'])) {
            $data['email'] = $this->request->post['email'];
        } else {
            $data['email'] = '';
        }

        if (isset($this->request->post['dob'])) {
            $data['dob'] = $this->request->post['dob'];
        } else {
            $data['dob'] = '';
        }

        if (isset($this->request->post['telephone'])) {
            $data['telephone'] = $this->request->post['telephone'];
        } else {
            $data['telephone'] = '';
        }

        if (isset($this->request->post['telephone2'])) {
            $data['telephone2'] = $this->request->post['telephone2'];
        } else {
            $data['telephone2'] = '';
        }

        if (isset($this->request->post['fax'])) {
            $data['fax'] = $this->request->post['fax'];
        } else {
            $data['fax'] = '';
        }

        // Custom Fields
        $this->load->model('customer/custom_field');

        $data['custom_fields'] = array();

        $custom_fields = $this->model_customer_custom_field->getCustomFields();

        foreach ($custom_fields as $custom_field) {
            $data['custom_fields'][] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'custom_field_value' => $this->model_customer_custom_field->getCustomFieldValues($custom_field['custom_field_id']),
                'name' => $custom_field['name'],
                'value' => $custom_field['value'],
                'type' => $custom_field['type'],
                'location' => $custom_field['location']
            );
        }

        if (isset($this->request->post['custom_field'])) {
            $data['account_custom_field'] = $this->request->post['custom_field'];
        } else {
            $data['account_custom_field'] = array();
        }

        if (isset($this->request->post['newsletter'])) {
            $data['newsletter'] = $this->request->post['newsletter'];
        } else {
            $data['newsletter'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } else {
            $data['status'] = true;
        }

        if (isset($this->request->post['approved'])) {
            $data['approved'] = $this->request->post['approved'];
        } else {
            $data['approved'] = true;
        }

        if (isset($this->request->post['safe'])) {
            $data['safe'] = $this->request->post['safe'];
        } else {
            $data['safe'] = 0;
        }

        if (isset($this->request->post['password'])) {
            $data['password'] = $this->request->post['password'];
        } else {
            $data['password'] = '';
        }

        if (isset($this->request->post['confirm'])) {
            $data['confirm'] = $this->request->post['confirm'];
        } else {
            $data['confirm'] = '';
        }

        $this->load->model('localisation/country');

        $data['countries'] = $this->model_localisation_country->getCountries();

        if (isset($this->request->post['address'])) {
            $data['addresses'] = $this->request->post['address'];
        } else {
            $data['addresses'] = array();
        }

        if (isset($this->request->post['address_id'])) {
            $data['address_id'] = $this->request->post['address_id'];
        } else {
            $data['address_id'] = '';
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('appointment/appointment_form_customer', $data));
    }

    protected function getFormAppointment()
    {
        $this->document->addStyle('view/stylesheet/appointment_form.css');

        $data['text_form'] = !isset($this->request->get['appointment_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['user_token'] = $this->session->data['user_token'];

        $error_arr = ['warning', 'service', 'doctor', 'date', 'time', 'status'];

        foreach ($error_arr as $error_index) {
            if (isset($this->error[$error_index])) {
                $data['error_' . $error_index] = $this->error[$error_index];
            } else {
                $data['error_' . $error_index] = '';
            }
        }

        $url = $this->getFilterUrl();

        if (isset($this->request->get['new'])) {
            $url .= '&new=' . $this->request->get['new'];
        }

        if (isset($this->request->get['admin_add'])) {
            $url .= '&admin_add=' . $this->request->get['admin_add'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $customer_id = isset($this->request->get['customer_id']) ? $this->request->get['customer_id'] : false;
        $appointment_id = isset($this->request->get['appointment_id']) ? $this->request->get['appointment_id'] : false;


        $data['customer_id'] = $customer_id ? $this->request->get['customer_id'] : 0;
        $data['appointment_id'] = $appointment_id ? $this->request->get['appointment_id'] : 0;


        if (isset($this->request->get['customer_id'])) {
            $customer_info = $this->model_appointment_appointment->getCustomerInfo($this->request->get['customer_id']);
        } else {
            $customer_info = array();
        }


        $data['appointment_info'] = [];

        if (!empty($customer_info)) {
            $data['customer_info'] = [
                'customer_id'               => $customer_info['customer_id'],
                'customer_name'             => $customer_info['customer_name'],
                'email'                     => $customer_info['email']

            ];
        }



        $data['action'] = $this->url->link('appointment/appointment/edit', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $this->request->get['appointment_id'] . $url, true);
        $data['cancel'] = $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $appointment_info = $this->model_appointment_appointment->getGeneralAppointment($this->request->get['appointment_id']);

        if ($appointment_info['customer_id'] != 0) {
            $customer_info = $this->model_appointment_appointment->getCustomer($this->request->get['appointment_id']);


            $data['customer_id'] = $customer_info['customer_id'];
            $data['customer_card'] = $customer_info['customer_card'];
            $data['customer_ic'] = $customer_info['customer_ic'];
            $data['customer_name'] = $customer_info['firstname'] . ' ' . $customer_info['lastname'];
            $data['gender'] = $customer_info['gender'];
            $data['email'] = $customer_info['email'];
            $data['dob'] = $customer_info['dob'];
            $data['telephone'] = $customer_info['telephone'];
            $data['telephone2'] = $customer_info['telephone2'];
            $data['home'] = $customer_info['home'];
            $data['fax'] = $customer_info['fax'];
        } else {
            $data['customer_id'] = 0;
            $data['customer_card'] = '';
            $data['customer_ic'] = $appointment_info['customer_ic'];
            $data['customer_name'] = $appointment_info['customer_name'];
            $data['gender'] = 1;
            $data['email'] = $appointment_info['email'];
            $data['dob'] = '';
            $data['telephone'] = $appointment_info['telephone'];
            $data['telephone2'] = '';
            $data['home'] = '';
            $data['fax'] = '';
        }


        // if (isset($appointment_info['customer_id']) && $appointment_info['customer_id'] != 0) {
        //     $data['client_name'] = $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $appointment_info['customer_id'], true);
        // } else {
        //     $data['client_name'] = $this->url->link('customer/customer/add', 'user_token=' . $this->session->data['user_token'] . true);
        // }


        $data['addClient'] = $this->url->link('customer/customer/add', 'user_token=' . $this->session->data['user_token'], true);
        $data['editClient'] = $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $appointment_info['customer_id'], true);


        $status_info = $this->getAppointmentStatusById($appointment_info['status']);
        $data['status_name'] = $status_info['name'];
        $data['status_label'] = $status_info['color'];

        $etcm_customer = $appointment_info['from_etcm'];
        $data['etcm_customer'] = $etcm_customer;

        $got_appointment = $appointment_info['appointment_date'];

        $new_customer = $appointment_info['new_customer'];
        $data['new'] = $new_customer;



        if (isset($this->request->post['doctor_id'])) {
            $data['doctor_id'] = $this->request->post['doctor_id'];
        } elseif (!empty($appointment_info)) {
            $data['doctor_id'] = $appointment_info['doctor_id'];
        } else {
            $data['doctor_id'] = '';
        }


        if (isset($this->request->post['selected_service'])) {
            $data['selected_service'] = $this->request->post['selected_service'];
        } elseif (!empty($appointment_info)) {
            $data['selected_service'] = $appointment_info['clinicalservice_id'];
        } else {
            $data['selected_service'] = 26;
        }


        if (isset($this->request->post['appointment_date'])) {
            $data['appointment_date'] = $this->request->post['appointment_date'];
        } elseif (!empty($appointment_info)) {
            $data['appointment_date'] = $appointment_info['appointment_date'];
            if ($data['appointment_date'] == '0000-00-00') {
                $data['appointment_date'] = '';
            }
        } else {
            $data['appointment_date'] = '';
        }



        if (isset($this->request->post['doctor'])) {
            $data['doctor'] = $this->request->post['doctor'];
        } elseif (!empty($appointment_info)) {
            $data['doctor'] = $appointment_info['doctor_id'];
        } else {
            $data['doctor'] = '';
        }

        if (isset($this->request->post['doctor_required'])) {
            $data['doctor_required'] = $this->request->post['doctor_required'];
        } else {
            $data['doctor_required'] = '';
        }

        if (isset($this->request->post['store_id'])) {
            $data['store_id'] = $this->request->post['store_id'];
        } elseif (!empty($appointment_info)) {
            $data['store_id'] = $appointment_info['store_id'];
        } else {
            $data['store_id'] = 0;
        }


        if (isset($this->request->post['date'])) {
            $data['date'] = $this->request->post['date'];
        } elseif (!empty($appointment_info)) {
            $data['date'] = $appointment_info['appointment_date'];
            if ($data['date'] == '0000-00-00') {
                $data['date'] = '';
            }
        } else {
            $data['date'] = '';
        }


        if (isset($this->request->post['appointment_time'])) {
            $data['appointment_time'] = $this->request->post['appointment_time'];
        } elseif (!empty($appointment_info)) {
            $data['appointment_time'] = $appointment_info['appointment_time'];
        } else {
            $data['appointment_time'] = '';
        }


        if (isset($this->request->post['time'])) {
            $data['time'] = $this->request->post['time'];
        } elseif (!empty($appointment_info)) {
            $data['time'] = $appointment_info['appointment_time'];
        } else {
            $data['time'] = '';
        }

        if (!empty($appointment_info['status'])) {
            $data['status'] = $appointment_info['status'];
        } else {
            $data['status'] = '';
        }

        if (isset($this->request->post['remark'])) {
            $data['remark'] = $this->request->post['remark'];
        } elseif (!empty($appointment_info)) {
            $data['remark'] = $appointment_info['remark'];
        } else {
            $data['remark'] = '';
        }


        $data['store_id'] = $this->session->data['store_id'];
        $data['appointment_month'] = date('F Y');
        if (empty($data['doctor_id'])) {
            $data['services'] = $this->model_appointment_appointment->getServices();
        } else {
            $data['services'] = $this->model_appointment_appointment->getServices2($data['doctor_id']);
        }

        $data['today_date'] = $data['appointment_date'];


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');


        // var_dump($data['customer_name']);
        // die();

        $this->response->setOutput($this->load->view('appointment/appointment_form', $data));
    }

    public function getFormView()
    {
        $data['text_form'] = $this->language->get('text_view');

        $data['user_token'] = $this->session->data['user_token'];

        $url = $this->getFilterUrl();

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (empty($this->request->get['appointment_id'])) {
            $this->response->redirect($this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $appointment_id = $this->request->get['appointment_id'];

        $appointment_info = $this->model_appointment_appointment->getGeneralAppointment($appointment_id);

        if (!empty($appointment_info)) {
            if ($appointment_info['customer_id'] > 0) {
                $data['appointment_info'] = $this->model_appointment_appointment->getAppointment($appointment_id);
                $data['customer_info'] = $this->model_appointment_appointment->getCustomer($appointment_id);

                $data['customer_info']['gender_text'] = ($data['customer_info']['gender'] == '1') ? $this->language->get('filed_male') : $this->language->get('filed_female');
            } else {
                $data['appointment_info'] = $appointment_info;
                $data['customer_info'] = array(
                    'customer_card' => '',
                    'customer_ic' => '',
                    'firstname' => $appointment_info['customer_name'],
                    'lastname' => '-',
                    'gender_text' => '',
                    'dob' => '',
                    'email' => $appointment_info['email'],
                    'telephone' => $appointment_info['telephone'],
                    'telephone2' => '',
                    'home' => '',
                    'fax' => ''
                );
            }

            $data['cancel_reason'] = '';
            $data['others_reason'] = '';

            if (($appointment_info['status'] == '2') && ($appointment_info['cancel_reason_id'] > 0)) {
                $cancel_reason = $this->getCancelReason($appointment_info['cancel_reason_id']);

                $data['cancel_reason'] = !empty($cancel_reason) ? $cancel_reason : '';
            }

            if ($appointment_info['status'] == '2') {
                $data['others_reason'] = !empty($appointment_info['cancel_reasons']) ? $appointment_info['cancel_reasons'] : '';
            }
        } else {
            $this->response->redirect($this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        if ($data['appointment_info']['doctor_id'] > 0) {
            $doctor_info = $this->model_appointment_appointment->getDoctor($data['appointment_info']['doctor_id']);

            $data['doctor_name'] = $doctor_info['firstname'] . ' ' . $doctor_info['lastname'];
        } else {
            $data['doctor_name'] = '';
        }

        $data['service_info'] = $this->model_appointment_appointment->getService($data['appointment_info']['clinicalservice_id']);

        $data['cancel'] = $this->url->link('appointment/appointment', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('appointment/appointment_form_view', $data));
    }

    protected function validateFormCustomer()
    {
        if (!$this->user->hasPermission('modify', 'appointment/appointment')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ($this->request->post['customer_id'] == 0) {
            if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
                $this->error['firstname'] = $this->language->get('error_firstname');
            }

            if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen(trim($this->request->post['lastname'])) > 32)) {
                //$this->error['lastname'] = $this->language->get('error_lastname');
            }

            if ((utf8_strlen($this->request->post['telephone']) < 3) || (utf8_strlen($this->request->post['telephone']) > 32)) {
                $this->error['telephone'] = $this->language->get('error_telephone');
            }

            if ((utf8_strlen($this->request->post['customer_ic']) < 3) || (utf8_strlen($this->request->post['customer_ic']) > 32)) {
                //$this->error['customer_ic'] = $this->language->get('error_customer_ic');
            }


            // Custom field validation
            $this->load->model('customer/custom_field');

            $custom_fields = $this->model_customer_custom_field->getCustomFields(array('filter_customer_group_id' => $this->request->post['customer_group_id']));

            foreach ($custom_fields as $custom_field) {
                if (($custom_field['location'] == 'account') && $custom_field['required'] && empty($this->request->post['custom_field'][$custom_field['custom_field_id']])) {
                    $this->error['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                }
            }

            if (!empty($this->request->post['email'])) {
                if ((utf8_strlen($this->request->post['email']) > 96) || !filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {
                    $this->error['email'] = $this->language->get('error_email');
                }
            }

            if ($this->request->post['password'] || (!isset($this->request->get['customer_id']))) {
                if ($this->request->post['password'] != $this->request->post['confirm']) {
                    $this->error['confirm'] = $this->language->get('error_confirm');
                }
            }

            if (isset($this->request->post['address'])) {
                foreach ($this->request->post['address'] as $key => $value) {
                    if ((utf8_strlen($value['firstname']) < 1) || (utf8_strlen($value['firstname']) > 32)) {
                        $this->error['address'][$key]['firstname'] = $this->language->get('error_firstname');
                    }

                    if ((utf8_strlen($value['lastname']) < 1) || (utf8_strlen($value['lastname']) > 32)) {
                        $this->error['address'][$key]['lastname'] = $this->language->get('error_lastname');
                    }

                    if ((utf8_strlen($value['address_1']) < 3) || (utf8_strlen($value['address_1']) > 128)) {
                        $this->error['address'][$key]['address_1'] = $this->language->get('error_address_1');
                    }

                    if ((utf8_strlen($value['city']) < 2) || (utf8_strlen($value['city']) > 128)) {
                        $this->error['address'][$key]['city'] = $this->language->get('error_city');
                    }

                    $this->load->model('localisation/country');

                    $country_info = $this->model_localisation_country->getCountry($value['country_id']);

                    if ($country_info && $country_info['postcode_required'] && (utf8_strlen($value['postcode']) < 2 || utf8_strlen($value['postcode']) > 10)) {
                        $this->error['address'][$key]['postcode'] = $this->language->get('error_postcode');
                    }

                    if ($value['country_id'] == '') {
                        $this->error['address'][$key]['country'] = $this->language->get('error_country');
                    }

                    if (!isset($value['zone_id']) || $value['zone_id'] == '') {
                        $this->error['address'][$key]['zone'] = $this->language->get('error_zone');
                    }

                    foreach ($custom_fields as $custom_field) {
                        if (($custom_field['location'] == 'address') && $custom_field['required'] && empty($value['custom_field'][$custom_field['custom_field_id']])) {
                            $this->error['address'][$key]['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                        }
                    }
                }
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateFormAppointment()
    {
        if (!$this->user->hasPermission('modify', 'appointment/appointment')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (isset($this->request->get['new']) && $this->request->get['new'] != 1) {
            if ((utf8_strlen($this->request->post['service']) < 1)) {
                $this->error['service'] = $this->language->get('error_service');
            }
        }

        if ($this->request->post['doctor_required'] == 1) {
            if ((utf8_strlen($this->request->post['doctor']) < 1)) {
                $this->error['doctor'] = $this->language->get('error_doctor');
            }
        }

        // if ((utf8_strlen($this->request->post['date']) < 1)) {
        //     $this->error['warning'] = $this->language->get('error_date');
        // }

        // if ($this->request->post['status'] != $this->request->post['current_status'] && $this->request->post['status'] != 2) {
        //     if (strtotime($this->request->post['date']) < strtotime(date('Y-m-d'))) {
        //         $this->error['warning'] = $this->language->get('error_date_less');
        //     }
        // }



        $user_holiday = $this->model_appointment_appointment->checkUserHoliday($this->request->post['doctor']);
        $store_holiday = $this->model_appointment_appointment->checkStoreHoliday($this->session->data['store_id']);

        foreach ($user_holiday as $holiday) {
            $dates = $this->createDateRangeArray($holiday['start'], $holiday['end']);
            if (in_array($this->request->post['date'], $dates)) {
                $this->error['warning'] = $this->language->get('error_date_unavailable');
            }
        }

        foreach ($store_holiday as $holiday) {
            $dates = $this->createDateRangeArray($holiday['start'], $holiday['end']);
            if (in_array($this->request->post['date'], $dates)) {
                $this->error['warning'] = $this->language->get('error_date_unavailable');
            }
        }

        if (empty($this->request->post['time'])) {
            $this->error['warning'] = $this->language->get('error_time');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDelete()
    {
        if (!$this->user->hasPermission('modify', 'appointment/appointment')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }


    public function getAppointmentTimeSlots()
    {
        $this->load->model('appointment/appointment');

        // Set Malaysia Timezone
        date_default_timezone_set("Asia/Kuala_Lumpur");

        $json = [];

        $store_id = $this->session->data['store_id'];
        // $branch_id = !empty($this->request->post['branch_id']) ? $this->request->post['branch_id'] : 0;
        $doctor_id = !empty($this->request->post['doctor_id']) ? (int) $this->request->post['doctor_id'] : 0;
        $service_id = !empty($this->request->post['service']) ? $this->request->post['service'] : 0;



        $service_type = $this->model_appointment_appointment->get_service_type($service_id);
        $duration = $this->model_appointment_appointment->get_service_duration($service_id);

        // $duration = 10;
        $date = !empty($this->request->post['appointment_date']) ? date('Y-m-d', strtotime($this->request->post['appointment_date'])) : date('Y-m-d');
        $day = !empty($date) ? date('l', strtotime($date)) : date('l');

        $time_ranges = $this->getAppointmentTimeRanges();
        $increments = $duration; //10; // Appointment increments time (Harcoded now but this need added in appointment setting, by store or merchant / by platform)
        $buffer = 0;
        $time_slots = $this->generateTimeSlots($time_ranges, $increments);
        $appointments = $this->getAppointments2(); // Pass the desired date
        $facilities = $this->model_appointment_appointment->getServiceFacilities($store_id, $service_id, $day);
        // $facilities = $this->getTempFacilities;

        $availability_slots = $this->getAvailableTimeSlots($date, $duration, $buffer, $time_slots, $appointments, $doctor_id, $service_id, $service_type, $facilities);

        $data['availability_slots'] = $availability_slots;
        $data['appointment_time']= date("H:i", strtotime($this->request->post['appointment_time']));

        $json['error'] = '';
        $json['success'] = true;
        /** For checking purpose, can be removed after testing and maintenance */
        $json['post'] = $this->request->post;
        $json['time_ranges'] = $time_ranges;
        $json['time_slots'] = $time_slots;
        $json['appointments'] = $appointments;
        $json['facilities'] = $facilities;
        $json['availability_slot'] = $availability_slots;
        $json['availability_slots'] = $this->load->view('/appointment/availability_slots', $data);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    protected function generateTimeSlots($time_ranges, $interval_minutes)
    {
        $time_slots = [];
        $interval = new DateInterval("PT{$interval_minutes}M");

        foreach ($time_ranges as $range) {
            $start = new DateTime($range['start']);
            $end = new DateTime($range['end']);
            $period = new DatePeriod($start, $interval, $end);

            foreach ($period as $time) {
                $time_slots[] = $time->format('H:i');
            }
        }

        return $time_slots;
    }


    public function getApppointmentUnavailableDate()
    {
        $json = [];
        $final_date = [];
        $compare_date_range = [];

        $this->load->model('appointment/appointment');

        $doctor_id = isset($this->request->post['doctor_id']) ? (int) $this->request->post['doctor_id'] : false;
        $month = isset($this->request->post['appointment_month']) ? $this->request->post['appointment_month'] : date('F Y');
        $service_id = isset($this->request->post['service']) ? (int) $this->request->post['service'] : 0;


        $time_zone = $this->config->get('config_time_zone');
        date_default_timezone_set($time_zone);

        $today_date = date('Y-m-d');
        $today_timestamp = strtotime($today_date);

        if ($doctor_id) {
            $doctor_holidays = $this->model_appointment_appointment->checkUserHoliday($doctor_id);
        } else {
            $doctor_holidays = [];
        }

        $store_holiday = $this->model_appointment_appointment->checkStoreHoliday($this->session->data['store_id']);

        $date_range = $this->createDateRangeByMonthYearArray(date('n', strtotime($month)), date('Y', strtotime($month)));

        if (!empty($date_range)) {
            $one_month_later_timestamp = strtotime('+1 month', $today_timestamp);

            foreach ($date_range as $date) {
                $date_timestamp = strtotime($date);

                if ($today_timestamp > $date_timestamp) {
                    $compare_date_range[] = date('Y-m-d', $date_timestamp);
                }

                if ($date_timestamp > $one_month_later_timestamp) {
                    $compare_date_range[] = date('Y-m-d', $date_timestamp);
                }
            }

            if (!empty($doctor_holidays)) {
                foreach ($doctor_holidays as $holiday) {
                    $holiday_date_range = $this->createDateRangeArray($holiday['start'], $holiday['end']);

                    if (!empty($holiday_date_range)) {
                        foreach ($holiday_date_range as $date) {
                            if (in_array($date, $date_range)) {
                                $compare_date_range[] = $date;
                            }
                        }
                    }
                }
            }

            if (!empty($store_holiday)) {
                foreach ($store_holiday as $holiday) {
                    $holiday_date_range = $this->createDateRangeArray($holiday['start'], $holiday['end']);

                    if (!empty($holiday_date_range)) {
                        foreach ($holiday_date_range as $date) {
                            if (in_array($date, $date_range)) {
                                $compare_date_range[] = $date;
                            }
                        }
                    }
                }
            }

            foreach ($date_range as $date) {
                $date_range_day = date('l', strtotime($date));

                if ($doctor_id) {
                    $appointment_availability_time = $this->model_appointment_appointment->getDoctorAvailabilityTime($doctor_id, $date_range_day, $service_id);

                    if (empty($appointment_availability_time)) {
                        $compare_date_range[] = $date;
                    }
                }
            }

            $compare_date_range = array_unique($compare_date_range);

            if (!empty($compare_date_range)) {
                foreach ($compare_date_range as $date) {
                    $day = date('l', strtotime($date));

                    $final_date[] = [
                        'date' => $date,
                        'day' => $day
                    ];
                }

                $date_column = array_column($final_date, 'date');
                $date_column = array_map('strtotime', $date_column);

                array_multisort($final_date, SORT_NUMERIC, $date_column, SORT_ASC);
            }
        }

        if (!empty($final_date)) {
            $json = $final_date;
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    protected function getAvailableTimeSlots($selected_date, $duration, $buffer, $time_slots, $appointments, $doctor_id, $service_id, $service_type, $facilities)
    {
        // Set Malaysia Timezone
        date_default_timezone_set("Asia/Kuala_Lumpur");

        $availability_slots = [];
        //$day = date('l', strtotime($selected_date));
        $current_date = date("Y-m-d"); // Today date
        $now = new DateTime(); // Get the current time
        $booking_ahead_limit = clone $now;
        $booking_ahead_limit->add(new DateInterval("PT1H")); // Add or Hardcode to 1 hours to the current time

        // Get the current time
        for ($i = 0; $i < count($time_slots); $i++) {
            $start_time = new DateTime($time_slots[$i]);
            $end_time = clone $start_time;
            $end_time->add(new DateInterval("PT{$duration}M"));
            $buffer_time = clone $end_time;
            $buffer_time->add(new DateInterval("PT{$buffer}M"));

            $slot_available = true;

            $facility_avaibility = 0;
            $service_facilities = [];
            // Iterate through each facilities to check for available
            // If the facility is not available 24 hours, check its time ranges
            foreach ($facilities as $facility) {
                $facility_start = new DateTime($facility['start_time']);
                $facility_end = new DateTime($facility['end_time']);

                if (!in_array($facility['facility_id'], $service_facilities)) {
                    if (!empty($facility['available'])) {
                        $service_facilities[] = $facility['facility_id'];
                        $facility_avaibility++;
                    } else {
                        // Check the facility time range which is available.
                        if (($start_time >= $facility_start && $start_time < $facility_end) ||
                            ($end_time > $facility_start && $end_time <= $facility_end) ||
                            ($buffer_time > $facility_start && $buffer_time <= $facility_end) ||
                            ($start_time <= $facility_start && $buffer_time >= $facility_end)
                        ) {
                            $service_facilities[] = $facility['facility_id'];
                            $facility_avaibility++;
                        }
                    }
                }
            }

            // Check if the time slot has already passed if (selected date is today) (This need to set in appointment settings to check default, by day or by hour or by minute)
            $overlapping_appointments = 0;
            $overlapping_appointments_checked = [];

            if (/*($start_time <= $booking_ahead_limit) &&*/($selected_date == $current_date)) {
                $slot_available = false;
            } else {
                // Check for overlapping appointments
                // Count overlapping appointments
                $overlapping_appointments = 0;

                // Iterate through each appointment to check for overlaps
                foreach ($appointments as $appointment) {
                    $appointment_start = new DateTime($appointment['start_time']);
                    $appointment_end = new DateTime($appointment['end_time']);

                    // Check if there's an overlap between the appointment and the time slot
                    if (($start_time >= $appointment_start && $start_time < $appointment_end) ||
                        ($end_time > $appointment_start && $end_time <= $appointment_end) ||
                        ($buffer_time > $appointment_start && $buffer_time <= $appointment_end) ||
                        ($start_time <= $appointment_start && $buffer_time >= $appointment_end)
                    ) {

                        $appointment_date = date('Y-m-d', strtotime($appointment['appointment_date']));

                        // If service type is consultation and is same doctor consult then mark the slot as unavailable
                        // If service type is consultation no need check for facilities
                        if (($service_type == 2) && ($appointment['doctor_id'] == $doctor_id)) {
                            $slot_available = false;
                            break;
                        }

                        // If the service type is treatment
                        if ($service_type == 1) {
                            // If the service no have facility and selected doctor exists in appointment then mark the slot as unavailable
                            if ($appointment_date == $selected_date) {
                                if (empty($service_facilities) && $appointment['doctor_id'] == $doctor_id) {
                                    $slot_available = false;
                                    break;
                                }

                                // Check the appointment facilities used, if exists, increase the overlaps appointment count
                                if (in_array($appointment['facility_id'], $service_facilities)) {
                                    // If the overlapping appointment have occured, increment the counter
                                    $overlapping_appointments++;

                                    $overlapping_appointments_checked[] = [
                                        'appointment_id'    => $appointment['appointment_id'],
                                        'appointment_start' => $appointment_start,
                                        'appointment_end'   => $appointment_end,
                                    ];
                                }

                                // If the overlapping appointment have occured, increment the counter
                                // Check if the number of overlapping appointments exceeds the available facility quantity
                                if (!empty($overlapping_appointments) && !empty($facility_avaibility)) {
                                    if ($overlapping_appointments >= $facility_avaibility) {
                                        $slot_available = false;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }

            // Return Data
            //if (!empty($slot_available)) {
            $availability_slots[] = [
                'date'       => $selected_date,
                'timeslots'  => $time_slots[$i], //$time_slots[$i] . ' - ' . $end_time->format('H:i'),
                'start_time' => $time_slots[$i],
                'end_time'   => $end_time->format('H:i'),
                'available'  => $slot_available ? 1 : 0,
                'facility_avaibility' => $facility_avaibility,
                'facility_available_ids'  => !empty($service_facilities) ? implode(',', $service_facilities) : '',
                'overlapping_appointments' => $overlapping_appointments,
                'overlapping_appointments_checked' => $overlapping_appointments_checked, // Used for checking
            ];
            //}
        }

        array_multisort($availability_slots, SORT_ASC);

        return $availability_slots;
    }

    protected function getAppointments2()
    {
        // $this->load->model('account/customer');

        $store_id = !empty($this->request->post['store_id']) ? $this->request->post['store_id'] : 0;
        $date = !empty($this->request->post['appointment_date']) ? date('Y-m-d', strtotime($this->request->post['appointment_date'])) : date('Y-m-d');

        $data = [];
        $path = 'android/etcm/appointment/check_availability';
        $domain = HTTPS_CATALOG;
        $post_data = [
            'store_id'   => (int)$store_id,
            'start_date' => $date,
            'end_date'   => $date
        ];

        if (!empty($domain) && !empty($path) && !empty($post_data) && !empty($date)) {
            $response = $this->connectCurl($domain, $path, $post_data);
        }

        if (!empty($response)) {
            $data = $response;
        }

        return $data;
        // return $this->getTempAppointments;
    }

    protected function connectCurl($domain, $path, $data, $debug = false)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = $domain . 'index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        if ($debug) {
            return $response;
        }

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }

    protected function getAppointmentTimeRanges()
    {
        $this->load->model('appointment/appointment');

        $data = [];

        $doctor_id = !empty($this->request->post['doctor_id']) ? (int) $this->request->post['doctor_id'] : 0;
        $store_id = $this->session->data['store_id'];
        $day = !empty($this->request->post['appointment_date']) ? date('l', strtotime($this->request->post['appointment_date'])) : date('l');

        $times_ranges = $this->model_appointment_appointment->getDoctorAvailabilityTimes($doctor_id, $store_id, $day);
        foreach ($times_ranges as $time) {
            $data[] = [
                'availability_time_id'  => $time['availability_time_id'],
                'availability_id'       => $time['availability_id'],
                'doctor_id'             => $time['doctor_id'],
                'store_id'              => $time['store_id'],
                'day'                   => $time['day'],
                'start'                 => date('H:i', strtotime($time['start'])),
                'end'                   => date('H:i', strtotime($time['end'])),
            ];
        }

        return $data;
    }

    public function getService()
    {
        $json = array();
        $this->load->model('appointment/appointment');

        if (isset($this->request->get['doctor_id'])) {
            $doctor_id = $this->request->get['doctor_id'];
        } else {
            $doctor_id = '';
        }

        $json = $this->model_appointment_appointment->getServices2($doctor_id);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }


    public function getDoctors()
    {
        $json = array();

        $this->load->model('appointment/appointment');

        $json = $this->model_appointment_appointment->getDoctors();

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function getTimes()
    {
        $json = array();

        $this->load->model('appointment/appointment');

        if (isset($this->request->get['date'])) {
            $date = date('l', strtotime($this->request->get['date']));
        } else {
            $date = '';
        }

        if (isset($this->request->get['doctor_id'])) {
            $doctor_id = $this->request->get['doctor_id'];
        } else {
            $doctor_id = 0;
        }

        $times = $this->model_appointment_appointment->getTimes($this->session->data['store_id'], $date, $doctor_id);

        if (!empty($times)) {
            foreach ($times as $time) {
                if (!empty($time['start_time']) && !empty($time['end_time'])) {
                    $temp = strtotime($time['start_time']);
                    array_push($json, date('h:i A', $temp));
                    while (strtotime($time['end_time']) > $temp) {
                        $temp = $temp + ($time['minutes'] * 60);
                        $temp2 = $temp + ($time['minutes'] * 60);
                        if ($temp2 <= strtotime($time['end_time'])) {
                            array_push($json, date('h:i A', $temp));
                        }
                    }
                }
            }
        } else {
            $json = array();
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function getServiceTimes()
    {
        $json = array();

        $this->load->model('appointment/appointment');

        if (isset($this->request->get['date'])) {
            $date = date('l', strtotime($this->request->get['date']));
        } else {
            $date = '';
        }

        if (isset($this->request->get['service_id'])) {
            $service_id = $this->request->get['service_id'];
        } else {
            $service_id = 0;
        }

        $times = $this->model_appointment_appointment->getServiceTimes($this->session->data['store_id'], $date, $service_id);

        foreach ($times as $doctor_times) {
            foreach ($doctor_times as $time) {
                if (!empty($time['start_time']) && !empty($time['end_time'])) {
                    $temp = strtotime($time['start_time']);
                    array_push($json, date('h:i A', $temp));
                    while (strtotime($time['end_time']) > $temp) {
                        $temp = $temp + ($time['minutes'] * 60);
                        $temp2 = $temp + ($time['minutes'] * 60);
                        if ($temp2 <= strtotime($time['end_time'])) {
                            array_push($json, date('h:i A', $temp));
                        }
                    }
                }
            }
        }

        $json_unique = array_unique($json);

        $timestamp = array();

        foreach ($json_unique as $key => $unique) {
            $timestamp[] = strtotime($unique);
        }

        sort($timestamp);

        foreach ($timestamp as $key => $time) {
            $time_format[] = date('h:i A', $time);
        }

        unset($json);

        if (!empty($time_format)) {
            $new_format = array();

            $time_zones = $this->config->get('config_time_zone');
            date_default_timezone_set($time_zones);

            $current_time = date('h:i A', time());
            $today_date = date('Y-m-d');
            $current_timestamp = strtotime($current_time);

            if ($today_date == $this->request->get['date']) {
                foreach ($time_format as $time) {
                    $timestamp = strtotime($time);

                    if ($timestamp > $current_timestamp) {
                        $new_format[] = $time;
                    }
                }
            } else {
                $new_format = $time_format;
            }

            $json = $new_format;
        } else {
            $json = [];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function createDateRangeArray($strDateFrom, $strDateTo)
    {
        $aryRange = array();

        $iDateFrom = mktime(1, 0, 0, substr($strDateFrom, 5, 2), substr($strDateFrom, 8, 2), substr($strDateFrom, 0, 4));
        $iDateTo = mktime(1, 0, 0, substr($strDateTo, 5, 2), substr($strDateTo, 8, 2), substr($strDateTo, 0, 4));

        if ($iDateTo >= $iDateFrom) {
            array_push($aryRange, date('Y-m-d', $iDateFrom)); // first entry
            while ($iDateFrom < $iDateTo) {
                $iDateFrom += 86400; // add 24 hours
                array_push($aryRange, date('Y-m-d', $iDateFrom));
            }
        }

        return $aryRange;
    }

    public function createDateRangeByMonthYearArray($month, $year)
    {
        $aryRange = [];

        for ($day = 1; $day <= 31; $day++) {
            $time = mktime(12, 0, 0, $month, $day, $year);

            if (date('m', $time) == $month) {
                $aryRange[] = date('Y-m-d', $time);
            }
        }

        $num_of_days = count($aryRange);
        $last_day_element = $num_of_days - 1;

        $first_day = $aryRange[0];
        $first_day_timestamp = strtotime($first_day);

        $last_day = $aryRange[$last_day_element];
        $last_day_timestamp = strtotime($last_day);

        $one_day_later = date('Y-m-d', strtotime('+1 day', $last_day_timestamp));
        $two_weeks_later = date('Y-m-d', strtotime('+2 weeks', $last_day_timestamp));

        $one_day_before = date('Y-m-d', strtotime('-1 day', $first_day_timestamp));
        $two_weeks_before = date('Y-m-d', strtotime('-2 weeks', $first_day_timestamp));

        $days_later = $this->createDateRangeArray($one_day_later, $two_weeks_later);
        $days_before = $this->createDateRangeArray($two_weeks_before, $one_day_before);

        $aryRange = array_merge($aryRange, $days_before, $days_later);

        $date_column = array_map('strtotime', $aryRange);
        array_multisort($aryRange, SORT_NUMERIC, $date_column, SORT_ASC);

        return $aryRange;
    }

    public function pushToUserApp($appointment_id, $status, $hosting, $appointment_date, $appointment_time)
    {
        $user_appSession = curl_init();

        $url = HTTP_API . 'index.php?route=appointment/appointment/push_notification&appointment_id=' . $appointment_id . '&status=' . $status . '&hosting=' . $hosting . '&date=' . $appointment_date . '&time=' . $appointment_time;

        $new_url = str_replace(' ', '%20', $url);

        curl_setopt($user_appSession, CURLOPT_URL, $new_url);
        curl_setopt($user_appSession, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($user_appSession, CURLOPT_HEADER, false);

        curl_exec($user_appSession);
        curl_close($user_appSession);
    }

    public function autocompleteForm()
    {
        $json = [];

        if (isset($this->request->get['filter_firstname'])) {
            $filter_firstname = $this->request->get['filter_firstname'];
        } else {
            $filter_firstname = '';
        }

        if (isset($this->request->get['filter_lastname'])) {
            $filter_lastname = $this->request->get['filter_lastname'];
        } else {
            $filter_lastname = '';
        }

        $filter_data = array(
            'filter_firstname' => $filter_firstname,
            'filter_lastname' => $filter_lastname,
            'start' => 0,
            'limit' => 5
        );

        $this->load->model('appointment/appointment');

        $results = $this->model_appointment_appointment->getAutocompleteFormCustomers($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $json[] = [
                    'customer_id' => $result['customer_id'],
                    'firstname' => $result['firstname'],
                    'lastname' => $result['lastname'],
                    'newsletter' => $result['newsletter'],
                    'status' => $result['status'],
                    'approved' => $result['approved'],
                    'safe' => $result['safe'],
                    'customer_ic' => $result['customer_ic'],
                    'customer_card' => $result['customer_card'],
                    'customer_group_id' => $result['customer_group_id'],
                    'gender' => $result['gender'],
                    'dob' => $result['dob'],
                    'email' => $result['email'],
                    'telephone' => $result['telephone'],
                    'fax' => $result['fax'],
                    'telephone2' => $result['telephone2'],
                    'home' => $result['home']
                ];
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    private function getAppointmentStatusColor($status)
    {
        $this->language->load('appointment/appointment');

        $status_arr = [];

        switch ($status) {
            case '0':
                $status_arr['color'] = '#f38733';
                $status_arr['status_name'] = $this->language->get('text_pending');
                break;
            case '1':
                $status_arr['color'] = '#8fbb6c';
                $status_arr['status_name'] = $this->language->get('text_confirm');
                break;
            case '2':
                $status_arr['color'] = '#f56b6b';
                $status_arr['status_name'] = $this->language->get('text_canceled');
                break;
            case '3':
                $status_arr['color'] = '#ff78bb';
                $status_arr['status_name'] = $this->language->get('text_attended');
                break;
            case '4':
                $status_arr['color'] = '#6666ff';
                $status_arr['status_name'] = $this->language->get('text_draft');
                break;
            default:
                $status_arr['color'] = '#000';
                $status_arr['status_name'] = '';
                break;
        }

        return $status_arr;
    }

    private function getTimeCalendarView($indicator)
    {
        $timestamp_arr = [];

        $this->load->model('appointment/appointment');

        $available_times = $this->model_appointment_appointment->getCalendarTime($indicator);

        if (!empty($available_times)) {
            foreach ($available_times as $time) {
                $timestamp_arr[] = strtotime($time['distinct_time']);
            }

            if ($indicator == 'min') {
                $actual_time = date('H:i:s', min($timestamp_arr));
            } else {
                $actual_time = date('H:i:s', max($timestamp_arr));
            }
        } else {
            if ($indicator == 'min') {
                $actual_time = '00:00:00';
            } else {
                $actual_time = '24:00:00';
            }
        }

        return $actual_time;
    }

    private function getCancelReason($cancel_reason_id)
    {
        $cancel_reason_final_str = '';

        $etcm_url = HTTP_API . 'index.php?route=etcm/appointment/get_cancel_reason&language=' . $this->session->data['language'] . '&reason_id=' . $cancel_reason_id;

        $cancel_reason_json = file_get_contents($etcm_url);
        $cancel_reason_arr = json_decode($cancel_reason_json, true);

        if ($cancel_reason_arr['error'] == '0') {
            $cancel_reason_final_str = $cancel_reason_arr['data']['reason'];
        }

        return $cancel_reason_final_str;
    }

    public function printAppointmentList()
    {
        $this->load->model('appointment/appointment');

        $config_appointment_date_type = !empty($this->config->get('config_appointment_list_date_type')) ? $this->config->get('config_appointment_list_date_type') : 'today';

        if (isset($this->request->get['filter_date_type'])) {
            $filter_date_type = $this->request->get['filter_date_type'];
        } else {
            $filter_date_type = $config_appointment_date_type;
        }

        $date_from_datetypes = $this->getDateByDateType($filter_date_type);
        $filter_date_start2 = $date_from_datetypes['date_start'];
        $filter_date_end2 = $date_from_datetypes['date_end'];

        if ($filter_date_type != 'custom') {
            $filter_date_start = $filter_date_start2;
        } elseif (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = null;
        }

        if ($filter_date_type != 'custom') {
            $filter_date_end = $filter_date_end2;
        } elseif (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = null;
        }

        $pdf = !empty($this->request->get['pdf']) ? $this->request->get['pdf'] : false;

        $data = [];

        $url = '';
        $filter_data = [
            'filter_date_start' => $filter_date_start,
            'filter_date_end'   => $filter_date_end
        ];

        $results = $this->model_appointment_appointment->getAppointments($filter_data);
        $data['appointments'] = $this->formattedAppointmentDetails($results, $url);

        $file_name = 'Printing - Appointments';
        if ($filter_date_type !== 'today' || $filter_date_type !== 'tomorrow') {
            $file_name = 'Printing - Appointments (' . $filter_date_start . ' - ' . $filter_date_end . ')';
        } else {
            $file_name = 'Printing - Appointments (' . $filter_date_start . ')';
        }

        $data['filename'] = $file_name;

        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');

            $data['pdf'] = true;

            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';
            $mpdf = new mPDF('utf-8', 'A4');
            $mpdf->writeHTML($this->load->view('appointment/printing_appointments_list', $data));
            $mpdf->Output($file_name, 'I');
        } else {
            $this->response->setOutput($this->load->view('appointment/printing_appointments_list', $data));
        }
    }

    protected function getFiltersData()
    {
        /** Filters */
        $config_appointment_date_type = !empty($this->config->get('config_appointment_list_date_type')) ? $this->config->get('config_appointment_list_date_type') : 'upcoming';

        if (isset($this->request->get['filter_date_type'])) {
            $filter_date_type = $this->request->get['filter_date_type'];
        } else {
            $filter_date_type = $config_appointment_date_type;
        }

        $date_from_datetypes = $this->getDateByDateType($filter_date_type);
        $filter_date_start2 = $date_from_datetypes['date_start'];
        $filter_date_end2 = $date_from_datetypes['date_end'];

        if ($filter_date_type != 'custom') {
            $filter_date_start = $filter_date_start2;
        } elseif (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = null;
        }

        if ($filter_date_type != 'custom') {
            $filter_date_end = $filter_date_end2;
        } elseif (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = null;
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor = null;
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = null;
        }

        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = null;
        }

        if (isset($this->request->get['filter_remark'])) {
            $filter_remark = $this->request->get['filter_remark'];
        } else {
            $filter_remark = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = null;
        }

        if (isset($this->request->get['filter_store'])) {
            $filter_store = $this->request->get['filter_store'];
        } else {
            $filter_store = null;
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_from_etcm'])) {
            $filter_from_etcm = $this->request->get['filter_from_etcm'];
        } else {
            $filter_from_etcm = null;
        }

        if (isset($this->request->get['filter_created_date'])) {
            $filter_created_date = $this->request->get['filter_created_date'];
        } else {
            $filter_created_date = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'appointment_date';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        return [
            'filter_date_type'   => $filter_date_type,
            'filter_date_start'   => $filter_date_start,
            'filter_date_end'     => $filter_date_end,
            'filter_name'         => $filter_name,
            'filter_telephone'    => $filter_telephone,
            'filter_email'        => $filter_email,
            'filter_doctor'       => $filter_doctor,
            'filter_remark'       => $filter_remark,
            'filter_status'       => $filter_status,
            'filter_store'        => $filter_store,
            'filter_from_etcm'    => $filter_from_etcm,
            'filter_created_date' => $filter_created_date,
            'sort'                => $sort,
            'order'               => $order,
            'page'                => $page,
            'start'               => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit'               => $this->config->get('config_limit_admin')
        ];
    }

    /** Get the url that inclues filters data and search data.
     * param boolean
     * return string
     * true:  Show all list. (Used for listing count)
     * false: Not includes, sort, order, and page (Used for listing with pagination)
     */
    protected function getFilterUrl($all = false)
    {
        $url = '';
        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . urlencode(html_entity_decode($this->request->get['filter_date_type'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_date_start'])) {
            $url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
        }

        if (isset($this->request->get['filter_date_end'])) {
            $url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . urlencode(html_entity_decode($this->request->get['filter_email'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_remark'])) {
            $url .= '&filter_remark=' . urlencode(html_entity_decode($this->request->get['filter_remark'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_store'])) {
            $url .= '&filter_store=' . $this->request->get['filter_store'];
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_from_etcm'])) {
            $url .= '&filter_from_etcm=' . $this->request->get['filter_from_etcm'];
        }

        if (isset($this->request->get['filter_created_date'])) {
            $url .= '&filter_created_date=' . $this->request->get['filter_created_date'];
        }

        if (empty($all)) {
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }
        }

        return $url;
    }

    /** Formatted Appointment Details
     * param @objects[]
     * return object[]
     * Return all the appointment details used in appointment list page, calendarr and printing.
     */
    protected function formattedAppointmentDetails($datas = array(), $url)
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");

        $this->load->model('user/user');

        $result = [];
        if (!empty($datas)) {
            $appointment_count = 1;
            foreach ($datas as $data) {
                $status_info = $this->getAppointmentStatusById($data['status']);
                $status_color = $status_info['color'];
                $status_name  = $status_info['name'];
                $status_enable_edit = $status_info['edit'];

                $edit_url = $this->url->link('appointment/appointment/edit', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $data['appointment_id'] . $url, true);
                $view_url = $this->url->link('appointment/appointment/view', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $data['appointment_id'] . $url, true);

                $edit_customer_url = $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $data['customer_id'], true);

                $booked_time = $data['appointment_time'];
                $start_time  = $data['start_time'];
                $end_time    = $data['end_time'];

                if ($start_time == '00:00:00') {
                    $start_time = $data['appointment_time'];
                }

                if ($end_time == '00:00:00') {
                    $time_info = [
                        'start_time' => $start_time,
                        'doctor_id'  => (int)$data['doctor_id'],
                        'service_id' => (int)$data['clinicalservice_id'],
                        'date'       => date('l', strtotime($data['appointment_date']))
                    ];
                    $end_time = $this->getAppointmentEndTimeByStartTime($time_info);
                }

                $appointment_description = '';
                if (!empty($data['service_name']) && !empty($start_time) && !empty($end_time)) {
                    $appointment_description .= "<h4 style='background-color:#000;color:#fff !important;'>" . $data['service_name'] . ' (' . date('H:i', strtotime($start_time)) . ' - ' . date('H:i', strtotime($end_time)) . ')' . "</h4>";
                }


                if (empty($data['doctor_id'])) {
                    $doctor_name = 'No service provider been selected';
                } elseif (!empty($data['doctor_id']) && empty($data['doctor_name'])) {
                    $doctor_name = 'Service provider been deleted/disabled or Invalid Provider';
                } elseif (!empty($data['doctor_id']) && !empty($data['doctor_name'])) {
                    $doctor_name = $data['doctor_name'];
                } else {
                    $doctor_name = 'Invalid Service provider';
                }

                $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Service provider:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" . $doctor_name . "</div></div>";

                if (empty($data['clinicalservice_id'])) {
                    $service_name = 'No service selected';
                } elseif (!empty($data['clinicalservice_id']) && empty($data['service_name'])) {
                    $service_name = 'Service been deleted/disabled or Invalid Service';
                } elseif (!empty($data['clinicalservice_id']) && !empty($data['service_name'])) {
                    $service_name = $data['service_name'];
                } else {
                    $service_name = 'Invalid Service';
                }

                $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Service:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" . $service_name . "</div></div>";


                if (empty($data['customer_id']) && empty($data['appointment_customer'])) {
                    $customer_name = 'Walk In Customer';
                } elseif (empty($data['customer_id']) && !empty($data['appointment_customer'])) {
                    $customer_name = $data['appointment_customer'];
                } elseif (!empty($data['customer_id']) && empty($data['customer_name'])) {
                    $customer_name = 'Customer been deleted/disabled or Invalid Customer';
                } elseif (!empty($data['customer_id']) && !empty($data['customer_name'])) {
                    $customer_name = $data['customer_name'];
                } else {
                    $customer_name = 'Invalid Customer';
                }

                $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Client name:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" . $customer_name . "</div></div>";

                if (!empty($data['email'])) {
                    $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Client email:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" . $data['email'] . "</div></div>";
                }

                if (!empty($data['telephone'])) {
                    $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Client phone:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" . $data['telephone'] . "</div></div>";
                }

                if (!empty($data['appointment_date'])) {
                    $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Booking date:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" .  date('D, d-m-Y', strtotime($data['appointment_date'])) . "</div></div>";
                }

                if (!empty($start_time) && !empty($end_time)) {
                    $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Booking time:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" .  date('h:i A', strtotime($start_time)) . ' - ' .  date('h:i A', strtotime($end_time)) . "</div></div>";
                } else {
                    $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Booking time:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" .  date('H:i:s', strtotime($start_time)) . "</div></div>";
                }

                if (!empty($status_name)) {
                    $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Status:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" . $status_name . "</div></div>";
                }

                if (!empty($data['remark'])) {
                    $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Remark:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" . $data['remark'] . "</div></div>";
                }

                $appointment_type = '';
                if (empty($data['from_etcm']) && empty($data['created_by'])) {
                    $appointment_type = 'Online';
                } elseif (empty($data['from_etcm']) && !empty($data['created_by'])) {
                    $appointment_type = 'Internal';
                } else {
                    $appointment_type = 'ETCM Channel';
                }

                $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Type:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" . $appointment_type . "</div></div>";

                $created_by = '';
                $created_by_info = $this->model_user_user->getUser($data['created_by']);
                if (empty($data['created_by'])) {
                    $created_by = 'By Customer';
                } elseif (!empty($created_by_info)) {
                    $created_by = $created_by_info['firstname'] . ' ' . $created_by_info['lastname'];
                } else {
                    $created_by = 'Missing User Data';
                }

                $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Created by:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" . $created_by . "</div></div>";

                $created_at = date('l, Y-m-d h:i A', strtotime($data['created_date']));
                if ($data['created_date'] == '0000-00-00 00:00:00' || empty($data['created_date'])) {
                    $created_at = 'Missing Creation Time';
                }

                $appointment_description .= "<div class='row' style='display:flex;'><div class='col-sm-5 control-label' style='color:#fff !important;'>Created at:</div><div class='col-sm-7 control-info control-label' style='color:#fff !important;'>" . $created_at . "</div></div>";

                $appointment_title = '';
                $appointment_title .= $customer_name;
                $appointment_title .= ' ' . $service_name;

                $this->load->model('service/clinical_service');
                $service_info = $this->model_service_clinical_service->get_clinical_service($data['clinicalservice_id']);
                $service_minutes = !empty($service_info['cs_minute']) ? (int)$service_info['cs_minute'] : 0;

                date_default_timezone_set("Asia/Kuala_Lumpur");
                $start = strtotime($start_time);
                $end = strtotime($end_time);
                $diff = $end - $start;
                $service_minutes = round($diff / 60);

                $service_hours = floor($service_minutes / 60);
                $service_minutes = $service_minutes % 60;

                if ($service_hours > 0) {
                    $service_minutes_text =  $service_hours . "hr" . ($service_minutes > 0 ? $service_minutes . "mins" : "");
                } else {
                    $service_minutes_text = $service_minutes . "mins";
                }

                $result[] = [
                    'numbering'      => $appointment_count,
                    'appointment_id' => (int)$data['appointment_id'],
                    'date'           => date('Y-m-d', strtotime($data['appointment_date'])),
                    'created_date'   => date('Y-m-d H:i:s', strtotime($data['created_date'])),
                    'time'           => $data['appointment_time'],
                    'start_time'     => date('h:i A', strtotime($start_time)),
                    'end_time'       => date('h:i A', strtotime($end_time)),
                    'store_id'       => (int)$data['store_id'],
                    'store'          => $data['store_name'],
                    'customer_id'    => (int)$data['customer_id'],
                    'name'           => $customer_name,
                    'age'            => $data['age'],
                    'gender'         => $data['gender'],
                    'telephone'      => $data['telephone'],
                    'email'          => $data['email'],
                    'doctor_id'      => (int) $data['doctor_id'],
                    'doctor_name'    => $doctor_name,
                    'service_id'     => (int)$data['clinicalservice_id'],
                    'service_name'   => $service_name,
                    'service_minute' => $service_minutes_text,
                    'status'         => (int)$data['status'],
                    'status_name'    => $status_name,
                    'status_color'   => $status_color,
                    'enable_edit'    => $status_enable_edit,
                    'remark'         => $data['remark'],
                    'doctor_remark'  => $data['doctor_remark'],
                    'from_etcm'      => $data['from_etcm'],
                    'from_channel'   => $appointment_type,
                    'created_by'     => $created_by,
                    'created_at'     => $created_at,
                    'edit'           => $edit_url,
                    'view'           => $view_url,
                    'appointment_title' => $appointment_title,
                    'appointment_description' => $appointment_description,
                    'appointment_start_time' => $data['appointment_date'] . 'T' . date('H:i:s', strtotime($start_time)),
                    'appointment_end_time' => $data['appointment_date'] . 'T' . date('H:i:s', strtotime($end_time)),
                    'calendar_edit_url' => str_replace('&amp;', '&', $edit_url),
                    'calendar_view_url' => str_replace('&amp;', '&', $view_url),
                    'edit_customer_url' => $edit_customer_url,
                ];
                $appointment_count++;
            }
        }

        return $result;
    }

    /** Get formatted appointments
     * return object
     * Using one printing pdf
     */
    protected function getAppointments()
    {
        $this->load->language('appointment/appointment');

        $this->load->model('appointment/appointment');

        $filter_data = $this->getFiltersData();

        $results = $this->model_appointment_appointment->getAppointments($filter_data);

        $data = $this->formattedAppointmentDetails($results, '');

        return $data;
    }

    /** Get Start Date and End Date Based on Date Type
     * param @string
     * return @ array (
     * @ date/time $start_date
     * @ date/time $end_date )
     */
    protected function getDateByDateType($type)
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");
        $date = [];
        switch ($type) {
            case 'today':
                $start_date = date('Y-m-d');
                $end_date   = date('Y-m-d');
                break;
            case 'yesterday':
                $start_date = date('Y-m-d', ' - 1days');
                $end_date   = date('Y-m-d', ' - 1days');
                break;
            case 'upcoming':
                $start_date = date('Y-m-d');
                $end_date   = '';
                break;
            case 'past':
                $start_date = '';
                $end_date   = date('Y-m-d');
                break;
            case 'this_week':
                $start_date = date('Y-m-d', strtotime('Monday this week'));
                $end_date   = date('Y-m-d', strtotime('Sunday this week'));
                break;
            case 'this_month':
                $start_date = date('Y-m-d', strtotime('first day of this month'));
                $end_date   = date('Y-m-d', strtotime('last day of this month'));
                break;
            case 'this_year':
                $start_date = date('Y-m-d', strtotime('first day of January ' . date('Y')));
                $end_date   = date('Y-m-d', strtotime('last day of December ' . date('Y')));
                break;
            case 'last7days':
                $start_date = date('Y-m-d', strtotime(' - 7 days'));
                $end_date   = date('Y-m-d');
                break;
            case 'last30days':
                $start_date = date('Y-m-d', strtotime(' - 30 days'));
                $end_date   = date('Y-m-d');
                break;
            case 'last90days':
                $start_date = date('Y-m-d', strtotime(' - 90 days'));
                $end_date   = date('Y-m-d');
                break;
            case 'tomorrow':
                $start_date = date('Y-m-d', strtotime(' + 1 days'));
                $end_date   = date('Y-m-d', strtotime(' + 1 days'));
                break;
            case 'last_year_this_year':
                $start_date = date('Y-m-d', strtotime(' - 1 year'));
                $end_date   = date('Y-m-d', strtotime('last day of December ' . date('Y')));
                break;
            case 'all':
                $start_date = '';
                $end_date   = '';
                break;
            default:
                $start_date = date('Y-m-d');
                $end_date   = date('Y-m-d');
        }

        $date = [
            'date_start' => $start_date,
            'date_end'   => $end_date,
        ];
        return $date;
    }

    /** Get All Date Types (Default date types set at here)
     * return @ array (
     * @ string $name, $code )
     */
    protected function getDateTypes()
    {
        $this->language->load('appointment/appointment');
        $result = [
            array(
                'name' => 'Today',
                'code' => 'today'
            ),
            array(
                'name' => 'Tomorrow',
                'code' => 'tomorrow'
            ),
            array(
                'name' => 'Yesterday',
                'code' => 'yesterday'
            ),
            array(
                'name' => 'This Week',
                'code' => 'this_week'
            ),
            array(
                'name' => 'This Month',
                'code' => 'this_month'
            ),
            array(
                'name' => 'This Year',
                'code' => 'this_year'
            ),
            array(
                'name' => 'Last 7 days',
                'code' => 'last7days'
            ),
            array(
                'name' => 'Last 30 days',
                'code' => 'last30days'
            ),
            array(
                'name' => 'Last 90 days',
                'code' => 'last90days'
            ),
            array(
                'name' => 'Upcoming',
                'code' => 'upcoming'
            ),
            array(
                'name' => 'Past',
                'code' => 'past'
            ),
            array(
                'name' => 'All Time',
                'code' => 'all'
            ),
            array(
                'name' => 'Custom',
                'code' => 'custom'
            )
        ];
        return $result;
    }

    /** Get All Appointment Statues used in appointment module (Default appointment set at here)
     * return @ array (
     * @ int $id
     * @ string $name, $color )
     */
    protected function getAppointmentStatus()
    {
        $this->language->load('appointment/appointment');
        $result = [
            array(
                'id'    => 0,
                'name'  => $this->language->get('text_pending'),
                'color' => '#f38733'
            ),
            array(
                'id'    => 1,
                'name'  => $this->language->get('text_confirm'),
                'color' => '#8fbb6c'
            ),
            array(
                'id'    => 2,
                'name'  => $this->language->get('text_canceled'),
                'color' => '#f56b6b'
            ),
            array(
                'id'    => 3,
                'name'  => $this->language->get('text_attended'),
                'color' => '#ff78bb'
            ),
            array(
                'id'    => 4,
                'name'  => $this->language->get('text_draft'),
                'color' => '#6666ff'
            )
        ];
        return $result;
    }

    /** Get Specific Appointment Status By Status Id)
     * return @ array (
     * @ int $id
     * @ string $name, $color
     * @boolean $enable_edit true or false )
     */
    protected function getAppointmentStatusById($status)
    {
        switch ($status) {
            case '0':
                $status_name = $this->language->get('text_pending');
                $color = '#f38733';
                $enable_edit = true;
                break;
            case '1':
                $status_name = $this->language->get('text_confirm');
                $color = '#8fbb6c';
                $enable_edit = true;
                break;
            case '2':
                $status_name = $this->language->get('text_canceled');
                $color = '#f56b6b';
                $enable_edit = false;
                break;
            case '3':
                $status_name = $this->language->get('text_attended');
                $color = '#ff78bb';
                $enable_edit = false;
                break;
            case '4':
                $status_name = $this->language->get('text_draft');
                $color = '#6666ff';
                $enable_edit = true;
                break;
            default:
                $status_name = $this->language->get('text_draft');
                $color = '#6666ff';
                $enable_edit = true;
                break;
        }
        return [
            'id'    => $status,
            'name'  => $status_name,
            'color' => $color,
            'edit'  => $enable_edit,
        ];
    }

    /** Get Appointment End Time By Start Time because of current appointment doesn't save start time and end time.
     * return @ array (
     * @ int $id
     * @ string $name, $color
     * @boolean $enable_edit true or false )
     */
    protected function getAppointmentEndTimeByStartTime($data)
    {
        $this->load->model('appointment/appointment');
        $end_time = '';
        $start_time = $data['start_time'];
        // Get End Time By Service Minutes
        if (!empty($data['service_id']) && !empty($data['start_time'])) {
            $service_info = $this->model_appointment_appointment->getService($data['service_id']);
            if (!empty($service_info['cs_minute'])) { //&& $service_info['type'] == 1) {
                $duration = $service_info['cs_minute'];
                $end_time = date('H:i:s', (strtotime($start_time) + ($duration * 60)));
            }
        }

        // Get End Time By Doctor Consultation Time Minutes
        if (empty($end_time) && !empty($data['doctor_id']) && !empty($data['date']) && !empty($data['service_id']) && !empty($data['start_time'])) {
            $availability_info = $this->model_appointment_appointment->getDoctorAvailabilityTime($data['doctor_id'], $data['date'], $data['service_id']);
            if (!empty($availability_info)) {
                $duration = 0;
                foreach ($availability_info as $ai) {
                    $duration = $ai['minutes'];
                }
                $end_time = date('H:i:s', (strtotime($start_time) + ($duration * 60)));
            }
        }

        // Set End Time By Default as 15 minutes, can put in oc_setting and load from config
        if (empty($end_time)) {
            $end_time = date('H:i:s', (strtotime($start_time) + (15 * 60)));
        }

        return $end_time;
    }

    public function addcustomer()
    {
        $this->load->model('appointment/appointment');
        $json = [];
        $appointment_id = isset($this->request->get['appointment_id']) ? (int) $this->request->get['appointment_id'] : false;

        $customer = $this->model_appointment_appointment->getGeneralAppointment($appointment_id);
        $customer_detail =  $this->model_appointment_appointment->getCustomerDetail($customer['customer_ic']);

        if (!empty($customer_detail)) {
            $this->model_appointment_appointment->editcustomerdata($customer_detail);
        } else {
            $this->model_appointment_appointment->addcustomerdata($customer);
        }
        $json = ['success' => '1'];
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }


    public function autocomplete()
    {
        $json = array();

        if (isset($this->request->get['client_name'])) {
            $filter_name = $this->request->get['client_name'];

            $this->load->model('customer/customer');

            $filter_data = array(
                'filter_name' => $filter_name,
                'start' => 0,
                'limit' => 5
            );

            $results = $this->model_customer_customer->getCustomersAutocomplete($filter_data);

            foreach ($results as $result) {
                $json[] = array(
                    'customer_id' => $result['customer_id'],
                    'name' => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
                    'telephone' => $result['telephone'],
                    // Add other necessary fields for autocomplete results
                );
            }
        }

        $sort_order = array();

        foreach ($json as $key => $value) {
            $sort_order[$key] = $value['name'];
        }

        array_multisort($sort_order, SORT_ASC, $json);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }


    public function updateCustomer()
    {
        $this->load->model('appointment/appointment');
        $json = [];


        $old_customer_id = $this->request->post['old_customer_id'];
        $new_customer_id = $this->request->post['new_customer_id'];

        $appointment_id = $this->request->post['appointment_id'];


        $this->model_appointment_appointment->updateAppointmentCustomerId($appointment_id, $new_customer_id);





        $json['success'] = 1;

        header('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }



    public function addAppointment()
    {
        $this->load->model('appointment/appointment');
        $json = [];

        $data = [
            'customer_name' => $this->request->post['customer_name'],
            'customer_phone' => $this->request->post['customer_phone'],
            'email' => $this->request->post['email'],
            'remark' => $this->request->post['remark'],
            'customer_id' => $this->request->post['customer_id']
        ];

        $appointment_id = $this->model_appointment_appointment->addAppointmentCustomer($data);


        $json['success'] = 1;
        $json['appointment_id'] = $appointment_id;

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }



    /** Appointment Module Updates Note
     * --- 2023-02-22 by Chew Yi Xuan ---
     * Fix some bugs and enhance the user experience and friendliness
     * --- 2023-02-16 by Chew Yi Xuan ---
     * add `getFiltersUrl` function to avoid duplicate url generation in different function such `getList`, `add`, `delete` .. etc and refactoring the url generation.
     * Modify `edit` function >>
     * >> Added if appointment attended, redirect to view page
     * >> Added if appointment id is empty, redirect back to list page
     * Modify `validateFormAppointment` function >>
     * >> Only check date validation if the action is confirm or attend;
     * >> If the the action selected is same as current status, allowed to save and update data.
     * * ----------------------------------------
     * --- 2023-02-15 by Chew Yi Xuan ---
     * add `formattedAppointmentDetails` function to refactor the appointment details generate.
     * Fix the appointment `delete` function that caused error and redirect to error page.
     * * ----------------------------------------
     * --- 2023-02-06 by Chew Yi Xuan ---
     * add `getAppointments` function to get appointments list and data based on filtering and formatted it so that factoring the code and the reduce to create the new filters call at every each function
     * add `getAppointmentFilters` function get all appoinments filters based on GET method so that factoring the code and the reduce to create the new filters call at every each function
     * add `printAppointments` function to allow print the appointment list in PDF views
     * ----------------------------------------
     * --- 2023-02-03 by Chew Yi Xuan ---
     * add `getAppointmentEndTimeByStartTime` function
     * add `getAppointmentStatusById` function
     * add `getDateTypes` function
     * add `getDateByDateType` function
     */
}
