
$('#form input').keydown(function (e) {
    if (e.keyCode == 13) {
        filter();
    }
});

//load next page 
$('.product_pager button').click(function () {
    $q = $(this).attr('data-q');
    $category_id = $(this).attr('data-category-id');
    $is_search = $(this).attr('data-is-search');
    $page = $(this).attr('data-page');

    if ($is_search == 'true') {
        search($q, $page);
    } else {
        getItems($category_id, $page);
    }
});

function searchCustomerIc(customer_ic) {
    if (customer_ic) {
        //console.log(customer_ic);
        $.post('index.php?route=pos/pos/searchCustomer&user_token=' + user_token + '', {customer_ic: customer_ic}, function (data) {
            var data = JSON.parse(data);
            if (data['errors']) {
                $('.service_table tbody').html('');
                $('.customer_message').html("<div class='warning'>" + data['errors'] + "</div>");
                $('#customer_id').val(0);
                $('#customer_card').val('');
                $('.firstname').text('Walk In Customer');
                $('.validdate').text('');
                $('.telephone').text('');
                $('.customer_ic').text('');
                $('.email').text('');
                $('.dob').text('');
                $('.age').text('');
                $('.gender').text('');
                $('.address').text('');
                $('.memberGroup').text('');
                $('#customer_password').val('');
                $("#shipping_addres").empty();
                $("#shipping_addres").append('<option value="0">Pickup From Store</option>');
            }
            if (data['success']) {
                $('.service_table tbody').empty();
                $('.customer_message').empty();
                $("#shipping_addres").empty();
                $("#shipping_addres").append('<option value="0">Pickup From Store</option>');

                $.each(data['shipping'], function (index, value) {
                    //console.log(value);
                    if (data['shipping_address_id'] == value.address_id) {
                        $("#shipping_addres").append('<option value=' + value.address_id + ' selected >' + value.firstname + ' ' + value.lastname + ',' + value.address_1 + ',' + value.city + ',' + value.zone + ',' + value.country + '</option>');
                    } else {
                        $("#shipping_addres").append('<option value=' + value.address_id + '>' + value.firstname + ' ' + value.lastname + ',' + value.address_1 + ',' + value.city + ',' + value.zone + ',' + value.country + '</option>');
                    }
                });
                $('#customer_password').val('');
                $('#customer_id').val(data[0]['customer_id']);
                $('#customer_card').val(data[0]['customer_card']);
                $('.firstname').text(data[0]['firstname']);
                $('.validdate').text(data[0]['customer_validdate']);
                $('.telephone').text(data[0]['telephone']);
                $('.customer_ic').text(data[0]['customer_ic']);
                $('.email').text(data[0]['email']);
                $('.dob').text(data[0]['dob']);
                $('.age').text(data[0]['age']);
                $('.gender').text(data[0]['gender']);
                $('.address').text(data[0]['address']);
                $('.memberGroup').text(data[0]['memberGroup']);


                $('#customer_name').val(data[0]['firstname']);

                if (data['service'] != '') {
                    update_service(data['service']['services'], data['service']['total_data']);
                }
                if (data['brewing'] != '') {
                    update_brewings(data['brewing']['brewings'], data['brewing']['total_data']);
                }
                if (data['brewing_order'] != '') {
                    update_brewing_orders(data['brewing_order']['brewings'], data['brewing_order']['total_data']);
                }
                if (data['herbale'] != '') {
                    update_herbale(data['herbale']['herbals'], data['herbale']['total_data']);
                }
            }
        });
    }
}

function searchCustomerId(customer_id) {
    if (customer_id) {
        $.post('index.php?route=pos/pos/searchCustomerbyId&user_token=' + user_token + '', {customer_id: customer_id}, function (data) {
            var data = JSON.parse(data);
            if (data['errors']) {
                $('.service_table tbody').html('');
                $('.customer_message').html("<div class='warning'>" + data['errors'] + "</div>");
                $('#customer_id').val(0);
                $('#customer_card').val('');
                $('.firstname').text('Walk In Customer');
                $('.validdate').text('');
                $('.telephone').text('');
                $('.customer_ic').text('');
                $('.email').text('');
                $('.dob').text('');
                $('.age').text('');
                $('.gender').text('');
                $('.address').text('');
                $('.memberGroup').text('');
                $('#customer_password').val('');
                $("#shipping_addres").empty();
                $("#shipping_addres").append('<option value="0">Pickup From Store</option>');
            }
            if (data['success']) {
                $('.service_table tbody').empty();
                $('.customer_message').empty();
                $("#shipping_addres").empty();
                $("#shipping_addres").append('<option value="0">Pickup From Store</option>');

                $.each(data['shipping'], function (index, value) {
                    //console.log(value);
                    if (data['shipping_address_id'] == value.address_id) {
                        $("#shipping_addres").append('<option value=' + value.address_id + ' selected >' + value.firstname + ' ' + value.lastname + ',' + value.address_1 + ',' + value.city + ',' + value.zone + ',' + value.country + '</option>');
                    } else {
                        $("#shipping_addres").append('<option value=' + value.address_id + '>' + value.firstname + ' ' + value.lastname + ',' + value.address_1 + ',' + value.city + ',' + value.zone + ',' + value.country + '</option>');
                    }
                });
                $('#customer_password').val('');
                $('#customer_id').val(data[0]['customer_id']);
                $('#customer_card').val(data[0]['customer_card']);
                $('.firstname').text(data[0]['firstname']);
                $('.validdate').text(data[0]['customer_validdate']);
                $('.telephone').text(data[0]['telephone']);
                $('.customer_ic').text(data[0]['customer_ic']);
                $('.email').text(data[0]['email']);
                $('.dob').text(data[0]['dob']);
                $('.age').text(data[0]['age']);
                $('.gender').text(data[0]['gender']);
                $('.address').text(data[0]['address']);
                $('.memberGroup').text(data[0]['memberGroup']);


                if (data['service'] != '') {
                    update_service(data['service']['services'], data['service']['total_data']);
                }
                if (data['brewing'] != '') {
                    update_brewings(data['brewing']['brewings'], data['brewing']['total_data']);
                }
                if (data['brewing_order'] != '') {
                    update_brewing_orders(data['brewing_order']['brewings'], data['brewing_order']['total_data']);
                }
                if (data['herbale'] != '') {
                    update_herbale(data['herbale']['herbals'], data['herbale']['total_data']);
                }
            }
        });
    }
}

function add_service_cart(service_id, customer_id){
    $.ajax({
        url: 'index.php?route=pos/pos/add_service_cart&user_token='+user_token,
        type: 'post',
        dataType: 'json',
        data: {service_id:service_id},
        contentType: 'application/x-www-form-urlencoded',
        beforeSend: function () {
            $('button.add_service_cart_btn').prop('disabled', true).addClass('loading');
            $('button.add_to_cart_medical_btn').prop('disabled', true).addClass('loading');
        },
        complete: function () {
            $('button.add_service_cart_btn').prop('disabled', false).removeClass('loading');
            $('button.add_to_cart_medical_btn').prop('disabled', false).removeClass('loading');
        },
        success: function (json) {
            if (json['errors']) {
                $('.service_table tbody').html('');
            }

            if (json['error_empty_cart']) {
                $(".allowed_place_order").attr("disabled", true);
                $('.allowed_place_order').addClass('disabled');
            } else{
                $(".allowed_place_order").attr("disabled", false);
                $('.allowed_place_order').removeClass('disabled');
            }
    
            if (json['success']) {
                if (json['services'] != '') {
                    update_service(json['services']['services'], json['services']['total_data']); 
                    $('#input-customer-id-old').val(customer_id);
                    $('#input-customer-id').val(customer_id);
                    $('#input-identity').val(customer_id);
                    getPendingCheckout();
                }
            }  
        },
        error: function (xhr, ajaxOptions, thrownError) {
            console.log(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
        }
    });
}

function add_medical_cart(clinical_sale_id, customer_id) {
    $.ajax({
        url: 'index.php?route=pos/pos/add_medical_cart&user_token='+user_token,
        type: 'post',
        dataType: 'json',
        data: { clinical_sale_id:clinical_sale_id },
        contentType: 'application/x-www-form-urlencoded',
        beforeSend: function () {
            $('button.add_service_cart_btn').prop('disabled', true).addClass('loading');
            $('button.add_to_cart_medical_btn').prop('disabled', true).addClass('loading');
        },
        complete: function () {
            $('button.add_service_cart_btn').prop('disabled', false).removeClass('loading');
            $('button.add_to_cart_medical_btn').prop('disabled', false).removeClass('loading');
        },
        success: function (json) {
            if (json['errors']) {
                $('.herbal_table tbody').html('');
            }

            if (json['error_empty_cart']) {
                $(".allowed_place_order").attr("disabled", true);
                $('.allowed_place_order').addClass('disabled');
            } else{
                $(".allowed_place_order").attr("disabled", false);
                $('.allowed_place_order').removeClass('disabled');
            }
    
            if (json['success']) {
                if (json['herbals'] != '') {
                    update_herbale(json['herbals']['herbals'], json['herbals']['total_data']);
                    $('#input-customer-id-old').val(customer_id);
                    $('#input-customer-id').val(customer_id);
                    $('#input-identity').val(customer_id);
                    getPendingCheckout();
                }
            }  
        },
        error: function (xhr, ajaxOptions, thrownError) {
            console.log(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
        }
    });
}

   
function search($q, $page) {
    var html = '';

    //get category list
    $.post('index.php?route=pos/pos/searchProducts&user_token=' + user_token + '', {q: $q, page: $page}, function (data) {

        var data = JSON.parse(data);

        for (var i = 0; i < data.products.length; i++) {
            html += '<div class="product">';
            html += '<div class="tile" data-title="' + data.products[i]['name'] + '" data-price="' + data.products[i]['price_text'] + '"><div class="tile-content image">';
            html += '<img src="' + data.products[i]['image'] + '">';
            html += '</div><div class="brand bg-dark opacity"><span class="text">';
            html += data.products[i]['name'];
            html += '</span></div></div>';

            html += '<div class="btn-group tile-content">';
            html += '<a href="index.php?route=pos/pos/product&product_id=' + data.products[i]['id'] + '&user_token=' + user_token + '" class="btn btn_info fancybox.ajax">';
            html += '<i class="icon-info"></i>';
            html += '&nbsp;Info';
            html += '</a>';
            html += '<a data-product-id="' + data.products[i]['id'] + '"  data-has-option="' + data.products[i]['hasOptions'] + '" class="btn btn_cart" btn-success">';
            html += '<i class="icon-cart"></i>';
            html += '&nbsp;Cart';
            html += '</a>';
            html += '</div>'; //END tile-content

            html += '</div>';
        }

        $page++;

        if (data['has_more']) {
            //set attribute 
            $button = $('.product_pager button');
            $button.attr('data-q', $q);
            $button.attr('data-category-id', '');
            $button.attr('data-is-search', true);
            $button.attr('data-page', $page);
            $('.product_pager').removeClass('hide');
        } else {
            $('.product_pager').addClass('hide');
        }

        //check is start page 
        if ($page == 2) {
            $('.product_list .overview').html(html);
            oScrollbar1.tinyscrollbar_update('top');
        } else {
            $('.product_list .overview').append(html);
            oScrollbar1.tinyscrollbar_update('bottom');
        }

    });
}

//list category products 
$('.top_category_list li, .product_list .category').live('click', function () {
    getItems($(this).attr('data-category-id'), 1);
});

$(document).ready(function(){
    var category_id = $('.top_category_list li:first-child').attr('data-category-id');

    getItems(category_id, 1);
});

$("#barcode").on("keydown", function (event) {
    if (event.which == 13 && $(this).val().length > 0) {
        $.post('index.php?route=pos/pos/getProductByBarcode&user_token=' + user_token + '', {barcode: $(this).val()}, function (data) {

            var data = JSON.parse(data);

            $('.product-info .product_id').val(data.product_id);

            if (data.has_option == 1) {
                $('.product_list_bottom').removeClass('hide');
                get_option(data.product_id);
            } else {
                $('.product_list_bottom').addClass('hide');
                addToCart();
            }

            $("#barcode").val('');
        });
    }
});

$('#shipping_address').live('change', function () {
    $.post('index.php?route=pos/pos/addShipping&user_token=' + user_token + '', {shipping_addres: $(this).val()}, function (data) {
    });
});

$("#customer_card").on("keydown", function (event) {
    if (event.which == 13 && $(this).val().length > 0) {
        $.post('index.php?route=pos/pos/searchCustomer&user_token=' + user_token + '', {customer_card: $(this).val()}, function (data) {
            var data = JSON.parse(data);
            if (data['errors']) {
                $('.service_table tbody').html('');
                $('.customer_message').html("<div class='warning'>" + data['errors'] + "</div>");
                $('#customer_id').val(0);
                $('#customer_card').val('');
                $('#customer_password').val('');
                $('#customer_ic').val('');
                $('.firstname').text('Walk In Customer');
                $('.validdate').text('');
                $("#shipping_addres").empty();
                $("#shipping_addres").append('<option value="0">Pickup From Store</option>');
            }
            if (data['success']) {
                $('.service_table tbody').empty();
                $('.customer_message').empty();
                $("#shipping_addres").empty();
                $("#shipping_addres").append('<option value="0">Pickup From Store</option>');

                $.each(data['shipping'], function (index, value) {
                    //console.log(value);
                    if (data['shipping_address_id'] == value.address_id) {
                        $("#shipping_addres").append('<option value=' + value.address_id + ' selected >' + value.firstname + ' ' + value.lastname + ',' + value.address_1 + ',' + value.city + ',' + value.zone + ',' + value.country + '</option>');
                    } else {
                        $("#shipping_addres").append('<option value=' + value.address_id + '>' + value.firstname + ' ' + value.lastname + ',' + value.address_1 + ',' + value.city + ',' + value.zone + ',' + value.country + '</option>');
                    }
                });
                $('#customer_password').val('');
                $('#customer_id').val(data[0]['customer_id']);
                $('#customer_ic').val(data[0]['customer_ic']);
                $('.firstname').text(data[0]['firstname']);
                $('.validdate').text(data[0]['customer_validdate']);

                if (data['service'] != '') {
                    update_service(data['service']['services'], data['service']['total_data']);
                }
                if (data['brewing'] != '') {
                    update_brewings(data['brewing']['brewings'], data['brewing']['total_data']);
                }
                if (data['brewing_order'] != '') {
                    update_brewing_orders(data['brewing_order']['brewings'], data['brewing_order']['total_data']);
                }
                if (data['herbale'] != '') {
                    update_herbale(data['herbale']['herbals'], data['herbale']['total_data']);
                }
            }


        });
    }
});

$("#customer_ic").on("keydown", function (event) {
    if (event.which == 13 && $(this).val().length > 0) {
        $.post('index.php?route=pos/pos/searchCustomerbyId&user_token=' + user_token + '', {customer_ic: $(this).val()}, function (data) {
            var data = JSON.parse(data);
            if (data['errors']) {
                $('.service_table tbody').html('');
                $('.customer_message').html("<div class='warning'>" + data['errors'] + "</div>");
                $('#customer_id').val(0);
                $('#customer_card').val('');
                $('.firstname').text('Walk In Customer');
                $('.validdate').text('');
                $('.telephone').text('');
                $('.customer_ic').text('');
                $('.email').text('');
                $('.dob').text('');
                $('.age').text('');
                $('.gender').text('');
                $('.address').text('');
                $('.address').text('');
                $('#customer_password').val('');
                $("#shipping_addres").empty();
                $("#shipping_addres").append('<option value="0">Pickup From Store</option>');
            }
            if (data['success']) {
                $('.service_table tbody').empty();
                $('.customer_message').empty();
                $("#shipping_addres").empty();
                $("#shipping_addres").append('<option value="0">Pickup From Store</option>');

                $.each(data['shipping'], function (index, value) {
                    //console.log(value);
                    if (data['shipping_address_id'] == value.address_id) {
                        $("#shipping_addres").append('<option value=' + value.address_id + ' selected >' + value.firstname + ' ' + value.lastname + ',' + value.address_1 + ',' + value.city + ',' + value.zone + ',' + value.country + '</option>');
                    } else {
                        $("#shipping_addres").append('<option value=' + value.address_id + '>' + value.firstname + ' ' + value.lastname + ',' + value.address_1 + ',' + value.city + ',' + value.zone + ',' + value.country + '</option>');
                    }
                });
                $('#customer_password').val('');
                $('#customer_id').val(data[0]['customer_id']);
                $('#customer_card').val(data[0]['customer_card']);
                $('.firstname').text(data[0]['firstname']);
                $('.validdate').text(data[0]['customer_validdate']);
                $('.telephone').text(data[0]['telephone']);
                $('.customer_ic').text(data[0]['customer_ic']);
                $('.email').text(data[0]['email']);
                $('.dob').text(data[0]['dob']);
                $('.age').text(data[0]['age']);
                $('.gender').text(data[0]['gender']);
                $('.memberGroup').text(data[0]['memberGroup']);

                $('#customer_name').val(data[0]['firstname']);
                //console.log(data[0]['firstname']);


                if (data['service'] != '') {
                    update_service(data['service']['services'], data['service']['total_data']);
                }
                if (data['brewing'] != '') {
                    update_brewings(data['brewing']['brewings'], data['brewing']['total_data']);
                }
                if (data['brewing_order'] != '') {
                    update_brewing_orders(data['brewing_order']['brewings'], data['brewing_order']['total_data']);
                }
                if (data['herbale'] != '') {
                    update_herbale(data['herbale']['herbals'], data['herbale']['total_data']);
                }


            }

        });
    }
});

$("#customer_password").on("keydown", function (event) {
    if (event.which == 13 && $(this).val().length > 0) {
        $.post('index.php?route=pos/pos/customerLogin&user_token=' + user_token + '', {password: $(this).val(), customer_id: $('#customer_id').val()}, function (data) {
            var data = JSON.parse(data);
            if (data['errors']) {
                $('.customer_message').html("<div class='warning'>" + data['errors'] + "</div>");
                $('.customer_amount').text(0);
                $('#credit').val(0);
                $('.customer_points').text(0);
                $('#points').val(0)
            }
            if (data['success']) {
                $('.customer_message').empty();
                $('.customer_amount').text(data['amount']);
                $('#credit').val(data['amount']);
                $('.customer_points').text(data['points']);
                $('#points').val(data['points']);
            }
        });
    }
});

$("#q").on("keydown", function (event) {
    if (event.which == 13)
        search($(this).val(), 1);
});

$('.btn-search').click(function () {
    search($('#q').val(), 1);
});


function getItems($id, $page) {

    var html = '';

    //get category list
    $.post('index.php?route=pos/pos/getCategoryItems&user_token=' + user_token + '', {category_id: $id, page: $page}, function (data) {

        var data = JSON.parse(data);

        for (var i = 0; i < data.categories.length; i++) {
            html += '<div data-category-id="' + data.categories[i]['id'] + '" class="category"><div class="tile"><div class="tile-content image">';
            html += '<img src="' + data.categories[i]['image'] + '">';
            html += '</div><div class="brand bg-dark opacity"><span class="text">';
            html += data.categories[i]['name'];
            html += '</span></div></div></div>';
        }

        for (var i = 0; i < data.products.length; i++) {
            html += '<div data-product-id="' + data.products[i]['id'] + '"  data-has-option="' + data.products[i]['hasOptions'] + '"  class="product">';
            html += '<div class="tile" data-title="' + data.products[i]['name'] + '" data-price="' + data.products[i]['price_text'] + '">';
            html += '<div class="tile-content image">';
            html += '<img src="' + data.products[i]['image'] + '">';
            html += '</div><div class="brand bg-dark opacity"><span class="text">';
            html += data.products[i]['name'];
            html += '</span></div>';//END Brand
            html += '</div>';//END tile

            html += '<div class="btn-group tile-content">';
            html += '<a href="index.php?route=pos/pos/product&product_id=' + data.products[i]['id'] + '&user_token=' + user_token + '" class="btn btn_info fancybox.ajax">';
            html += '<i class="icon-info"></i>';
            html += '&nbsp;Info';
            html += '</a>';
            html += '<a data-product-id="' + data.products[i]['id'] + '"  data-has-option="' + data.products[i]['hasOptions'] + '" class="btn btn_cart" btn-success">';
            html += '<i class="icon-cart"></i>';
            html += '&nbsp;Cart';
            html += '</a>';
            html += '</div>'; //END tile-content

            html += '</div>';//END .product  
        }

        $page++;

        if (data['has_more']) {
            //set attribute 
            $button = $('.product_pager button');
            $button.attr('data-q', '');
            $button.attr('data-category-id', $id);
            $button.attr('data-is-search', false);
            $button.attr('data-page', $page);
            $('.product_pager').removeClass('hide');
        } else {
            $('.product_pager').addClass('hide');
        }

        //check is start page 
        if ($page == 2) {
            $('.product_list .overview').html(html);
            oScrollbar1.tinyscrollbar_update('top');
        } else {
            $('.product_list .overview').append(html);
            oScrollbar1.tinyscrollbar_update('bottom');
        }
    });
}

function filter($page) {
    url = 'index.php?route=pos/pos/ordersAJAX&user_token=' + user_token + '';

    var filter_order_id = $('input[name=\'filter_order_id\']').attr('value');

    if (filter_order_id) {
        url += '&filter_order_id=' + encodeURIComponent(filter_order_id);
    }

    var filter_invoice_id = $('input[name=\'filter_invoice_id\']').attr('value');

    if (filter_invoice_id) {
        url += '&filter_invoice_id=' + encodeURIComponent(filter_invoice_id);
    }

    var filter_customer = $('input[name=\'filter_customer\']').attr('value');

    if (filter_customer) {
        url += '&filter_customer=' + encodeURIComponent(filter_customer);
    }

    var filter_order_status_id = $('select[name=\'filter_order_status_id\']').attr('value');

    if (filter_order_status_id != '*') {
        url += '&filter_order_status_id=' + encodeURIComponent(filter_order_status_id);
    }

    var filter_total = $('input[name=\'filter_total\']').attr('value');

    if (filter_total) {
        url += '&filter_total=' + encodeURIComponent(filter_total);
    }

    var filter_date_added = $('input[name=\'filter_date_added\']').attr('value');

    if (filter_date_added) {
        url += '&filter_date_added=' + encodeURIComponent(filter_date_added);
    }

    var filter_date_modified = $('input[name=\'filter_date_modified\']').attr('value');

    if (filter_date_modified) {
        url += '&filter_date_modified=' + encodeURIComponent(filter_date_modified);
    }

    get_orders(url);
}


function holdfilter($page) {
    url = 'index.php?route=pos/pos/holdsAJAX&user_token=' + user_token + '';

    var filter_order_id = $('input[name=\'filter_order_id\']').attr('value');

    if (filter_order_id) {
        url += '&filter_order_id=' + encodeURIComponent(filter_order_id);
    }

    var filter_invoice_id = $('input[name=\'filter_invoice_id\']').attr('value');

    if (filter_invoice_id) {
        url += '&filter_invoice_id=' + encodeURIComponent(filter_invoice_id);
    }

    var filter_customer = $('input[name=\'filter_customer\']').attr('value');

    if (filter_customer) {
        url += '&filter_customer=' + encodeURIComponent(filter_customer);
    }

    var filter_order_status_id = 1

    if (filter_order_status_id != '*') {
        url += '&filter_order_status_id=' + encodeURIComponent(filter_order_status_id);
    }

    var filter_total = $('input[name=\'filter_total\']').attr('value');

    if (filter_total) {
        url += '&filter_total=' + encodeURIComponent(filter_total);
    }

    var filter_date_added = $('input[name=\'filter_date_added\']').attr('value');

    if (filter_date_added) {
        url += '&filter_date_added=' + encodeURIComponent(filter_date_added);
    }

    var filter_date_modified = $('input[name=\'filter_date_modified\']').attr('value');

    if (filter_date_modified) {
        url += '&filter_date_modified=' + encodeURIComponent(filter_date_modified);
    }

    get_holds(url);
}

$('input.filter_customer_search').autocomplete({
    'source': function (request, response) {
        $.ajax({
            url: 'index.php?route=pos/pos/customerAutocomplete&user_token=' + encodeURIComponent(user_token) + '&filter_search=' + encodeURIComponent(request.term),
            dataType: 'json',
            success: function (json) {
                response($.map(json, function (item) {
                    return {
                        label              : item['customer_name'] + ' , ' + item['customer_ic'] + ' , ' + item['telephone'],
                        value              : item['customer_name'],
                        customer_ic        : item['customer_ic'],
                        customer_card      : item['customer_card'],
                        customer_name      : item['customer_name'],
                        customer_firstname : item['customer_firstname'],
                        customer_lastname  : item['customer_lastname'],
                        customer_group_id  : item['customer_group_id'],
                        gender             : item['gender'],
                        email              : item['email'],
                        telephone          : item['telephone'],
                        customer_id        : item['customer_id'],
                        dob                : item['dob'],
                        customer_address   : item['customer_address'],
                        shipping           : item['shipping'],
                        shipping_address_id: item['shipping_address_id'],
                    }
                }));

            }
        });
    },
    select: function(event, item) {
        $('#input-customer-ic').html(item.item.customer_ic);
        $('#input-customer-id').val(item.item.customer_id);
        //$('#input-customer-id-old').val(item.item.customer_id);
        $('#input-customer-name').val(item.item.customer_name);
        $('#input-telephone').html(item.item.telephone);
        $('#input-firstname').html(item.item.customer_name);
        $('#input-gender').html(item.item.gender);
        $('#input-email').html(item.item.email);
        $('#input-dob').html(item.item.dob);
        $('#input-address').html(item.item.customer_address);
        $("#shipping_address").empty();
        $("#shipping_address").append('<option value="0">Pickup From Store</option>');
        $.each(item.item.shipping, function (index, value) {
            if (item.item.shipping_address_id == value.address_id) {
                $("#shipping_address").append('<option value=' + value.address_id + ' selected >' + value.firstname + ' ' + value.lastname + ',' + value.address_1 + ',' + value.city + ',' + value.zone + ',' + value.country + '</option>');
            } else {
                $("#shipping_address").append('<option value=' + value.address_id + '>' + value.firstname + ' ' + value.lastname + ',' + value.address_1 + ',' + value.city + ',' + value.zone + ',' + value.country + '</option>');
            }
        });
    }
});



