$('#order_pagination a').live('click', function () {
    get_orders($(this).attr('href'));
    return false;
});

$('#holds_pagination a').live('click', function () {
    get_holds($(this).attr('href'));
    return false;
});

$('.shipping_method').live('change', function () {
    $.post('index.php?route=pos/pos/setShipping&user_token=' + user_token + '', {
        shipping_method: $("input[name=shipping_method]:checked").val(),
    }, function (json) {
        var html = '<div class="pull-right">';
        var total_data = json['total_data'];
        for (var i = 0; i < total_data.length; i++) {
            html += '<div><b>' + total_data[i].title + '</b><br><span id="cart-total">' + total_data[i].text + '</span></div>';
        }
        html += '</div>';
        $('.confirm_total_wrapper').html(html);
        $('#pay_total').text(json['total']);
        $('#paid').val(json['total']);
    });
});

$('#pos-payment').live('change', function () {
    var pos_payment = $(this).find('option:selected').attr('data_name');

    if (pos_payment == 'Points') {
        $('#paid').val($('#buy_points').text());
        $('#paid').attr('readonly', true);
    } else if (pos_payment == 'Credit') {
        $('#paid').val($('#pay_total').text());
        $('#paid').attr('readonly', true);
    } else {
        $('#paid').val($('#pay_total').text());
        $('#paid').attr('readonly', false);
    }
});

$('.order_list .edit').live('click', function () {
    $.get('index.php?route=pos/pos/getOrder&order_id=' + $(this).attr('data-order-id') + '&invoice_prefix=' + $(this).attr('data-invoice-prefix') + '&customer_id=' + $(this).attr('data-customer-id') + '&user_token=' + user_token + '', function (data) {
        update_cart(data['products'], data['total_data']);
        update_service(data['services'], data['total_data']);
        update_herbale(data['herbls'], data['total_data']);

        //change pop up to order edit mode 
        $('#order').attr('href', 'index.php?route=pos/pos/updateConfirm&user_token=' + user_token + '&order_id=' + data['order_id']);
        $('input[name="order_id"]').val(data['order_id']);
        $('input[name="invoice_prefix"]').val(data['invoice_prefix']);

        if (data['customer']) {
            $('#customer_id').val(data['customer'][0]['customer_id']);
            $('#customer_card').val(data['customer'][0]['customer_card']);
            $('#customer_ic').val(data['customer'][0]['customer_ic']);
            $('.firstname').text(data['customer'][0]['firstname']);
            $("#customer_name").val(data['customer'][0]['firstname']);
            $('#customer_name').text(data['customer'][0]['firstname']);
            $('.validdate').text(data['customer'][0]['validdate']);
            $('#input-customer-id-old').val(data['customer'][0]['customer_id']);
            $('#input-customer-id').val(data['customer'][0]['customer_id']);
            $('#input-identity').val(data['customer'][0]['customer_id']);
        } else {
            console.log('Customer Detail Null');
        }

        $("#shipping_address").empty();
        $("#shipping_address").append('<option value="0">Pickup From Store</option>');
        if (data['shipping']) {
            $.each(data['shipping'], function (index, value) {
                if (data['shipping_address_id'] == value.address_id) {
                    $("#shipping_address").append('<option value=' + value.address_id + ' selected >' + value.firstname + ' ' + value.lastname + ',' + value.address_1 + ',' + value.city + ',' + value.zone + ',' + value.country + '</option>');
                } else {
                    $("#shipping_address").append('<option value=' + value.address_id + '>' + value.firstname + ' ' + value.lastname + ',' + value.address_1 + ',' + value.city + ',' + value.zone + ',' + value.country + '</option>');
                }

            });
        }

        if (data['total_data']) {
            $(".allowed_place_order").attr("disabled", false);
            $('.allowed_place_order').removeClass('disabled');
        } else {
            $(".allowed_place_order").attr("disabled", true);
            $('.allowed_place_order').addClass('disabled');
        }

        getPendingCheckout();
        $('.fancybox-close').trigger('click');
    });
});

$('#order_confirm').live('click', function () {
    $(this).val('Sending data...');
    $(".button-confirm").hide();
    $(".taxt-confirm").text("Loading.....");

    $pg_type = $('input[name="pg_type"]:checked').val();

    $print_method = $('input[name="print_method"]:checked').val();

    if ($pg_type == 'opencart') {
        $payment_method = $('#opencart_payment select[name="payment_method"]').val();
        $payment_name = $('#opencart_payment').find('option:selected').attr('data_name');
    } else {
        $payment_method = $('#pos_payment select[name="payment_method"]').val();
        $payment_name = $('#pos_payment').find('option:selected').attr('data_name');
    }

    $.post('index.php?route=pos/pos/addOrder&user_token=' + user_token + '', {
        card_no: $('.mask-card').val(),
        pg_type: $pg_type,
        paid: $('input[name="paid"]').val(),
        customer_id: $('input[name="customer_id"]').val(),
        customer_credit: $('#credit').val(),
        customer_points: $('#points').val(),
        points: $('#buy_points').text(),
        pay_total: $('#pay_total').text(),
        shipping_method: $("input[name=shipping_method]:checked").val(),
        shipping_addres_id: $('#shipping_address').val(),
        payment_name: $payment_name,
        payment_method: $payment_method,
        order_status_id: $(this).attr('order-status-id'),
        comment: $('textarea[name="order_comment"]').val()
    }, function (data) {
        //var data = JSON.parse(data);
        var html = '';

        if (data['errors']) {
            $('.message_wrapper').html("<div class='warning'>" + data['errors'] + "</div>");
            $(".button-confirm").show();
            $(".taxt-confirm").text('');
            $('.cart_table tbody').empty();
            $('.service_table tbody').empty();
            $('.herbal_table tbody').empty();
            clearCart();
            //window.location.reload(true);  
            //location.href = location.href     
        }

        if (data['success']) {
            //$('.message_wrapper').html("<div class='success'>"+data['success']+"</div>");             
            $('.fancybox-close').trigger('click');
            //alert('New order placed with ID: '+data.order_id);
            $('#order_confirm').val('Done');
            $('textarea[name="order_comment"]').val('').html('');
            $('.order_head .order_id').html('Order: ' + data['order_id']);
            $('.balance').html('<span>Cash : ' + data['cash'] + '</span><span>Card : ' + data['card'] + '</span>');
            $('.order_customer_name').html(data['customer_name'] + '<span class="pull-right">' + x.toDateString() + ', ' + x.toLocaleTimeString() + '</span>');
            $('#customer_id').val(0);
            $('#customer_card').val('');
            $('#customer_ic').val('');
            $('#customer_password').val('');
            $('.firstname').text('Walk In Customer');
            $('.validdate').text('');
            $('.customer_amount').text('');
            $('.customer_points').text('');
            $('#credit').val(0);
            $('#points').val(0)
            $('#customer_password').val('');
            $("#shipping_address").empty();
            $("#shipping_address").append('<option value="0">Pickup From Store</option>');

            if (data['payment_link']) {
                save_invoice();//save invoice html to print after payment success
                window.open(data['payment_link'], '_blank');

                //remove order data 
                $('.cart_table tbody').empty();
                $('.service_table tbody').empty();
                $('.herbal_table tbody').empty();

                $html = '<div class="pull-right">';
                $html += '<div>';
                $html += '<b>Sub total</b><br>';
                $html += '<span id="cart-total">' + zero_price + '</span>';
                $html += '</div>';
                $html += '<div>';
                $html += '<b>TAX</b><br>';
                $html += '<span id="cart-total">' + zero_price + '</span>';
                $html += '</div>';
                $html += '<div>';
                $html += '<b>Order Totals</b><br>';
                $html += '<span id="cart-total">' + zero_price + '</span>';
                $html += '</div>';
                $html += '</div>';
                $('.total_wrapper').html($html);

                if ($print_method == 1) {
                    print_invoice(data['order_id'])
                }
                if ($print_method == 2) {
                    print_receipt(data['order_id'])
                }
                if ($print_method == 3) {
                    print_hoald(data['order_id'])
                }

                clearCart();
                location.href = 'index.php?route=pos/pos&user_token=' + user_token;
            } else {
                //print_invoice(data['order_id']);  
                $('.cart_table tbody').empty();
                $('.service_table tbody').empty();
                $('.herbal_table tbody').empty();
                //print();//print invoice if pos gateways used 
                $html = '<div class="pull-right">';
                $html += '<div>';
                $html += '<b>Sub total</b><br>';
                $html += '<span id="cart-total">' + zero_price + '</span>';
                $html += '</div>';
                $html += '<div>';
                $html += '<b>TAX</b><br>';
                $html += '<span id="cart-total">' + zero_price + '</span>';
                $html += '</div>';
                $html += '<div>';
                $html += '<b>Order Totals</b><br>';
                $html += '<span id="cart-total">' + zero_price + '</span>';
                $html += '</div>';
                $html += '</div>';

                $('.total_wrapper').html($html);

                if ($print_method == 1) {
                    print_invoice(data['order_id'])
                }

                if ($print_method == 2) {
                    print_receipt(data['order_id'])
                }

                if ($print_method == 3) {
                    print_hoald(data['order_id'])
                }

                clearCart();
                location.href = 'index.php?route=pos/pos&user_token=' + user_token;
            }
        }
    });
});

function print_invoice(order_id) {
    /*var thePopup = window.open('index.php?route=sale/order/invoiceA5&user_token=' + user_token + '&pdf=1&order_id=' + oder_id, "Customer Listing", "menubar=0,location=0,height=700,width=700");
    $('#popup-content').clone().appendTo(thePopup.document.body);
    thePopup.print();*/
    window.open('index.php?route=sale/order/invoiceA5&user_token=' + user_token + '&pdf=1&order_id=' + order_id);
}

function print_receipt(order_id) {
    /*var thePopup = window.open('index.php?route=sale/order/invoiceReceipt&user_token=' + user_token + '&pdf=1&order_id=' + oder_id, "Customer Listing", "menubar=0,location=0,height=700,width=700");
    $('#popup-content').clone().appendTo(thePopup.document.body);
    thePopup.print();*/
    window.open('index.php?route=sale/order/invoiceReceipt&user_token=' + user_token + '&pdf=1&order_id=' + order_id);
}

function print_hoald(order_id) {
    /*var thePopup = window.open('index.php?route=sale/order/invoiceHoald&user_token=' + user_token + '&pdf=1&order_id=' + oder_id, "Customer Listing", "menubar=0,location=0,height=700,width=700");
    $('#popup-content').clone().appendTo(thePopup.document.body);
    thePopup.print();*/
    window.open('index.php?route=sale/order/invoiceHoald&user_token=' + user_token + '&pdf=1&order_id=' + order_id);
}


function save_invoice() {
    $html = '<div class="order_head">' + $(".order_head").html() + '</div>';
    $html += '<table class="table table-bordered cart_table">' + $(".cart_table").html() + '</table>';
    $html += '<div class="total_wrapper">' + $(".total_wrapper").html() + '</div>';
    $.post('index.php?route=pos/pos/saveInvoice&user_token=' + user_token + '', { html: $html });//save invoice html  
}

$('#order_update').live('click', function () {
    $(this).val('Sending data...');
    $(".button-confirm").hide();
    $(".taxt-confirm").text("Loading.....");


    $pg_type = $('input[name="pg_type"]:checked').val();

    $print_method = $('input[name="print_method"]:checked').val();

    if ($pg_type == 'opencart') {
        $payment_method = $('#opencart_payment select[name="payment_method"]').val();
        $payment_name = $('#opencart_payment').find('option:selected').attr('data_name');
    } else {
        $payment_method = $('#pos_payment select[name="payment_method"]').val();
        $payment_name = $('#pos_payment').find('option:selected').attr('data_name');
    }

    $.post('index.php?route=pos/pos/editOrder&user_token=' + user_token + '', {
        card_no: $('.mask-card').val(),
        pg_type: $pg_type,
        order_id: $('input[name="order_id"]').val(),
        invoice_prefix: $('input[name="invoice_prefix"]').val(),
        paid: $('input[name="paid"]').val(),
        points: $('#buy_points').text(),
        pay_total: $('#pay_total').text(),
        customer_credit: $('#credit').val(),
        customer_points: $('#points').val(),
        shipping_method: $("input[name=shipping_method]:checked").val(),
        shipping_addres_id: $('#shipping_address').val(),
        customer_id: $('input[name="customer_id"]').val(),
        order_status_id: $(this).attr('order-status-id'),
        payment_method: $payment_method,
        payment_name: $payment_name,
        comment: $('textarea[name="order_comment"]').val()
    }, function (data) {
        var data = JSON.parse(data);
        var html = '';

        if (data['errors']) {
            $('.message_wrapper').html("<div class='warning'>" + data['errors'] + "</div>");
            $(".button-confirm").show();
            $(".taxt-confirm").text('');
            $('.cart_table tbody').empty();
            $('.service_table tbody').empty();
            $('.herbal_table tbody').empty();
            clearCart();
        }

        if (data['success']) {
            $('.fancybox-close').trigger('click');

            //change pop up to order edit mode 
            $('#order').attr('href', 'index.php?route=pos/pos/confirm&user_token=' + user_token + '');

            $('.order_head .order_id').html('Order: ' + data['order_id']);
            $('.balance').html('<span>Cash : ' + data['cash'] + '</span><span>Card : ' + data['card'] + '</span>');
            $('.order_customer_name').html(data['customer_name'] + '<span class="pull-right">' + x.toDateString() + ', ' + x.toLocaleTimeString() + '</span>');
            $('#customer_id').val(0);
            $('#customer_password').val('');
            $('#customer_card').val('');
            $('#customer_ic').val('');
            $('.firstname').text('Walk In Customer');
            $('.validdate').text('');
            $('.customer_amount').text('');
            $('.customer_points').text('');
            $('#credit').val(0);
            $('#points').val(0)
            $('#customer_password').val('');
            $("#shipping_address").empty();
            $("#shipping_address").append('<option value="0">Pickup From Store</option>');

            if (data['payment_link']) {
                save_invoice();//save invoice html to print after payment success
                window.open(data['payment_link'], '_blank');

                //remove order data 
                $('.cart_table tbody').empty();
                $('.service_table tbody').empty();
                $('.herbal_table tbody').empty();

                $html = '<div class="pull-right">';
                $html += '<div>';
                $html += '<b>Sub total</b><br>';
                $html += '<span id="cart-total">' + zero_price + '</span>';
                $html += '</div>';
                $html += '<div>';
                $html += '<b>TAX</b><br>';
                $html += '<span id="cart-total">' + zero_price + '</span>';
                $html += '</div>';
                $html += '<div>';
                $html += '<b>Order Totals</b><br>';
                $html += '<span id="cart-total">' + zero_price + '</span>';
                $html += '</div>';
                $html += '</div>';

                clearCart();
                $('.total_wrapper').html($html);

                if ($print_method == 1) {
                    print_invoice(data['order_id'])
                }

                if ($print_method == 2) {
                    print_receipt(data['order_id'])
                }

                if ($print_method == 3) {
                    print_hoald(data['order_id'])
                }

                location.href = 'index.php?route=pos/pos&user_token=' + user_token;
            } else {
                $('.cart_table tbody').empty();
                $('.service_table tbody').empty();
                $('.herbal_table tbody').empty();
                //print();//print invoice if pos gateways used 
                $('.service_table tbody').html('');
                $html = '<div class="pull-right">';
                $html += '<div>';
                $html += '<b>Sub total</b><br>';
                $html += '<span id="cart-total">' + zero_price + '</span>';
                $html += '</div>';
                $html += '<div>';
                $html += '<b>TAX</b><br>';
                $html += '<span id="cart-total">' + zero_price + '</span>';
                $html += '</div>';
                $html += '<div>';
                $html += '<b>Order Totals</b><br>';
                $html += '<span id="cart-total">' + zero_price + '</span>';
                $html += '</div>';
                $html += '</div>';

                clearCart();
                $('.total_wrapper').html($html);

                if ($print_method == 1) {
                    print_invoice(data['order_id'])
                }
                if ($print_method == 2) {
                    print_receipt(data['order_id'])
                }
                if ($print_method == 3) {
                    print_hoald(data['order_id'])
                }

                location.href = 'index.php?route=pos/pos&user_token=' + user_token;
            }
        }
    });

});

function get_orders($url) {
    $.get($url, function (data) {
        var data = JSON.parse(data);
        var html = '';

        if (data['rows'].length == 0) {
            html += '<tr class="data_row"><td colspan="7">No order(s) found!</td></tr>';
        }

        for ($i = 0; $i < data['rows'].length; $i++) {
            html += "<tr class='data_row'>";
            html += "<td align='right'>" + data['rows'][$i]['order_id'] + "</td>";
            html += "<td align='right'>" + data['rows'][$i]['invoice_prefix'] + "</td>";
            html += "<td>" + data['rows'][$i]['customer'] + "</td>";
            html += "<td>" + data['rows'][$i]['status'] + "</td>";
            html += "<td align='right' class='td_total'>" + data['rows'][$i]['total'] + "</td>";
            html += "<td>" + data['rows'][$i]['date_added'] + "</td>";
            html += "<td>" + data['rows'][$i]['date_modified'] + "</td>";
            html += "<td align='center'>";
            html += "[<a href='" + data['print_a5'] + data['rows'][$i]['order_id'] + "' target='new'>Invoice</a>]<br/>";
            html += "[<a href='" + data['print_receipt'] + data['rows'][$i]['order_id'] + "' target='new'>Receipt</a>]<br/>";
            html += "<td>";
            html += "</tr>";
        }

        $('.order_list tbody tr.data_row').empty();
        $('.pagination').html(data['pagination']);
        $('.data_row').remove();
        $('.order_list table .filter').after(html);
    });
}

function get_holds($url) {
    $.get($url, function (data) {
        var data = JSON.parse(data);
        var html = '';

        if (data['rows'].length == 0) {
            html += '<tr class="data_row"><td colspan="7">No order(s) found!</td></tr>';
        }

        for ($i = 0; $i < data['rows'].length; $i++) {
            html += "<tr class='data_row'>";
            html += "<td align='right'>" + data['rows'][$i]['order_id'] + "</td>";
            html += "<td align='right'>" + data['rows'][$i]['invoice_prefix'] + "</td>";
            html += "<td>" + data['rows'][$i]['customer'] + "</td>";
            html += "<td>" + data['rows'][$i]['status'] + "</td>";
            html += "<td align='right' class='td_total'>" + data['rows'][$i]['total'] + "</td>";
            html += "<td>" + data['rows'][$i]['date_added'] + "</td>";
            html += "<td>" + data['rows'][$i]['date_modified'] + "</td>";
            html += "<td align='center'>[<a class='edit' data-order-id='" + data['rows'][$i]['order_id'] + "'   data-invoice-prefix='" + data['rows'][$i]['invoice_prefix'] + "' data-customer-id='" + data['rows'][$i]['customer_id'] + "' href='#'>Edit</a>]<br/>";
            html += "[<a href='" + data['print_a5'] + data['rows'][$i]['order_id'] + "' target='new'>Invoice</a>]<br/>";
            html += "[<a href='" + data['print_receipt'] + data['rows'][$i]['order_id'] + "' target='new'>Receipt</a>]<br/>";
            html += "[<a href='" + data['print_hoald'] + data['rows'][$i]['order_id'] + "' target='new'>Hold Invoice</a>]";
            html += "<td>";
            html += "</tr>";
        }

        $('.order_list tbody tr.data_row').empty();
        $('.pagination').html(data['pagination']);
        $('.data_row').remove();
        $('.order_list table .filter').after(html);
    });
}

function posParseFloat(floatstring) {
    // to take care of different culture with the formatted currency string
    // convert to general thousand point (,) and decimal point (.)
    var fString = '' + floatstring;
    if (',' != ',' || '.' != '.') {
        fString = fString.replace(',', '#tp#');
        fString = fString.replace('.', '.');
        fString = fString.replace('#tp#', ',');
    }

    return parseFloat(fString.replace(/[^0-9-.]/g, ''));
};