/*
 *  Bootstrap Color Picker Sliders - v3.0.1
 *
 *  Bootstrap 3 optimized responsive color selector with HSV, HSL, RGB and CIE-Lch (which supports human perceived lightness) selectors and color swatches.
 *  http://www.virtuosoft.eu/code/bootstrap-colorpickersliders/
 *
 *  Made by István Ujj-Mészáros
 *  Under Apache License v2.0 License
 *
 *  Requirements:  *
 *      TinyColor: https://github.com/bgrins/TinyColor/
 *
 *  Using color math algorithms from EasyRGB Web site:/
 *      http://www.easyrgb.com/index.php?X=MATH */
!function(a){"use strict";a.fn.ColorPickerSliders=function(b){return this.each(function(){function c(){"undefined"==typeof b&&(b={}),bb=a.extend({color:"hsl(342, 52%, 70%)",size:"default",placement:"auto",trigger:"focus",preventtouchkeyboardonshow:!0,title:"",hsvpanel:!1,sliders:!0,grouping:!0,swatches:["FFFFFF","C0C0C0","808080","000000","FF0000","800000","FFFF00","808000","00FF00","008000","00FFFF","008080","0000FF","000080","FF00FF","800080"],customswatches:"colorpickkersliders",connectedinput:!1,flat:!1,updateinterval:30,previewontriggerelement:!0,previewcontrasttreshold:30,previewformat:"rgb",titleswatchesadd:"Add color to swatches",titleswatchesremove:"Remove color from swatches",titleswatchesreset:"Reset to default swatches",order:{},labels:{},onchange:function(){}},b),bb.order=b.hasOwnProperty("order")?a.extend({opacity:!1,hsl:!1,rgb:!1,preview:!1},b.order):{opacity:0,hsl:1,rgb:2,preview:3},b.hasOwnProperty("labels")||(b.labels={}),bb.labels=a.extend({hslhue:"HSL-Hue",hslsaturation:"HSL-Saturation",hsllightness:"HSL-Lightness",rgbred:"RGB-Red",rgbgreen:"RGB-Green",rgbblue:"RGB-Blue",opacity:"Opacity",preview:"Preview"},b.labels)}function d(){gb||(gb=!0,lb=a.fn.ColorPickerSliders.detectWhichGradientIsSupported(),"filter"===lb&&(lb=!1),!lb&&a.fn.ColorPickerSliders.svgSupported()&&(lb="svg"),c(),bb.order.hasOwnProperty("preview")&&bb.order.preview!==!1||lb||(bb.order.preview=10),p(),f(),g(),P(),Q(),bb.flat&&o(),q())}function e(){n(),E(),O(),r()}function f(){ib?(tb.tiny=tinycolor(hb.val()),tb.tiny.isValid()||(tb.tiny=tinycolor(bb.color))):tb.tiny=tinycolor(bb.color),tb.hsla=tb.tiny.toHsl(),tb.rgba=tb.tiny.toRgb(),tb.hsv=tb.tiny.toHsv()}function g(){bb.connectedinput&&(jb=bb.connectedinput instanceof jQuery?bb.connectedinput:a(bb.connectedinput))}function h(a,b){var c=tinycolor(a);return c.isValid()?(tb.tiny=c,tb.hsla=c.toHsl(),tb.rgba=c.toRgb(),tb.hsv=c.toHsv(),bb.flat||mb?O(b):(b||Q(),P()),!0):!1}function i(a){if(!bb.flat){if(mb)return hb.popover("hide"),hb.popover("show"),void r();k(a),mb=!0}}function j(){mb=!1,l()}function k(b){if(!(db instanceof jQuery)){switch("undefined"==typeof b&&(b=!1),db=a('<div class="cp-popover-container"></div>').appendTo("body"),cb=a('<div class="cp-container"></div>').appendTo(db),cb.html(m()),bb.size){case"sm":cb.addClass("cp-container-sm");break;case"lg":cb.addClass("cp-container-lg")}e(),b||x(),hb.popover({html:!0,animation:!1,trigger:"manual",title:bb.title,placement:bb.placement,container:db,content:function(){return cb}}),hb.popover("show")}}function l(){db.remove(),db=null,hb.popover("destroy")}function m(){var a=[],b="";if(bb.sliders&&(bb.order.opacity!==!1&&(a[bb.order.opacity]='<div class="cp-slider cp-opacity cp-transparency"><span>'+bb.labels.opacity+'</span><div class="cp-marker"></div></div>'),bb.order.hsl!==!1&&(a[bb.order.hsl]='<div class="cp-slider cp-hslhue cp-transparency"><span>'+bb.labels.hslhue+'</span><div class="cp-marker"></div></div><div class="cp-slider cp-hslsaturation cp-transparency"><span>'+bb.labels.hslsaturation+'</span><div class="cp-marker"></div></div><div class="cp-slider cp-hsllightness cp-transparency"><span>'+bb.labels.hsllightness+'</span><div class="cp-marker"></div></div>'),bb.order.rgb!==!1&&(a[bb.order.rgb]='<div class="cp-slider cp-rgbred cp-transparency"><span>'+bb.labels.rgbred+'</span><div class="cp-marker"></div></div><div class="cp-slider cp-rgbgreen cp-transparency"><span>'+bb.labels.rgbgreen+'</span><div class="cp-marker"></div></div><div class="cp-slider cp-rgbblue cp-transparency"><span>'+bb.labels.rgbblue+'</span><div class="cp-marker"></div></div>'),bb.order.preview!==!1&&(a[bb.order.preview]='<div class="cp-preview cp-transparency"><input type="text" readonly="readonly"></div>')),bb.grouping&&(b+=!!bb.hsvpanel+!!(bb.sliders&&a.length>0)+!!bb.swatches>1?'<ul class="cp-pills">':'<ul class="cp-pills hidden">',bb.hsvpanel&&(b+='<li><a href="#" class="cp-pill-hsvpanel">HSV panel</a></li>'),bb.sliders&&a.length>0&&(b+='<li><a href="#" class="cp-pill-sliders">Sliders</a></li>'),bb.swatches&&(b+='<li><a href="#" class="cp-pill-swatches">Swatches</a></li>'),b+="</ul>"),bb.hsvpanel&&(b+='<div class="cp-hsvpanel"><div class="cp-hsvpanel-sv"><span></span><div class="cp-marker-point"></div></div><div class="cp-hsvpanel-h"><span></span><div class="cp-hsvmarker-vertical"></div></div><div class="cp-hsvpanel-a cp-transparency"><span></span><div class="cp-hsvmarker-vertical"></div></div></div>'),bb.sliders){b+='<div class="cp-sliders">';for(var c=0;c<a.length;c++)"undefined"!=typeof a[c]&&(b+=a[c]);b+="</div>"}return bb.swatches&&(b+='<div class="cp-swatches clearfix"><button type="button" class="add btn btn-default" title="'+bb.titleswatchesadd+'"><span class="glyphicon glyphicon-floppy-save"></span></button><button type="button" class="remove btn btn-default" title="'+bb.titleswatchesremove+'"><span class="glyphicon glyphicon-trash"></span></button><button type="button" class="reset btn btn-default" title="'+bb.titleswatchesreset+'"><span class="glyphicon glyphicon-repeat"></span></button><ul></ul></div>'),b}function n(){eb={actualswatch:!1,swatchescontainer:a(".cp-swatches",cb),swatches:a(".cp-swatches ul",cb),swatches_add:a(".cp-swatches button.add",cb),swatches_remove:a(".cp-swatches button.remove",cb),swatches_reset:a(".cp-swatches button.reset",cb),all_sliders:a(".cp-sliders, .cp-preview input",cb),hsvpanel:{sv:a(".cp-hsvpanel-sv",cb),sv_marker:a(".cp-hsvpanel-sv .cp-marker-point",cb),h:a(".cp-hsvpanel-h",cb),h_marker:a(".cp-hsvpanel-h .cp-hsvmarker-vertical",cb),a:a(".cp-hsvpanel-a span",cb),a_marker:a(".cp-hsvpanel-a .cp-hsvmarker-vertical",cb)},sliders:{hue:a(".cp-hslhue span",cb),hue_marker:a(".cp-hslhue .cp-marker",cb),saturation:a(".cp-hslsaturation span",cb),saturation_marker:a(".cp-hslsaturation .cp-marker",cb),lightness:a(".cp-hsllightness span",cb),lightness_marker:a(".cp-hsllightness .cp-marker",cb),opacity:a(".cp-opacity span",cb),opacity_marker:a(".cp-opacity .cp-marker",cb),red:a(".cp-rgbred span",cb),red_marker:a(".cp-rgbred .cp-marker",cb),green:a(".cp-rgbgreen span",cb),green_marker:a(".cp-rgbgreen .cp-marker",cb),blue:a(".cp-rgbblue span",cb),blue_marker:a(".cp-rgbblue .cp-marker",cb),preview:a(".cp-preview input",cb)},all_pills:a(".cp-pills",cb),pills:{hsvpanel:a(".cp-pill-hsvpanel",cb),sliders:a(".cp-pill-sliders",cb),swatches:a(".cp-pill-swatches",cb)}},bb.customswatches||(eb.swatches_add.hide(),eb.swatches_remove.hide(),eb.swatches_reset.hide())}function o(){bb.flat&&(ib?cb=a('<div class="cp-container"></div>').insertAfter(hb):(cb=a('<div class="cp-container"></div>'),hb.append(cb)),cb.append(m()),e(),x())}function p(){bb.connectedinput instanceof jQuery?bb.connectedinput.add(hb):bb.connectedinput=bb.connectedinput===!1?hb:a(bb.connectedinput).add(hb)}function q(){hb.on("colorpickersliders.updateColor",function(a,b){h(b)}),hb.on("colorpickersliders.show",function(){i()}),hb.on("colorpickersliders.hide",function(){j()}),bb.flat||"focus"!==bb.trigger||("undefined"==typeof hb.attr("tabindex")&&hb.attr("tabindex",-1),bb.preventtouchkeyboardonshow&&(a(hb).prop("readonly",!0).addClass("cp-preventtouchkeyboardonshow"),a(hb).on("click",function(b){mb&&(a(hb).prop("readonly",!1),b.stopPropagation())})),ib||a(hb).on("click",function(a){i(),a.stopPropagation()}),a(hb).on("focus",function(a){i(),a.stopPropagation()}),a(hb).on("blur",function(b){j(),bb.preventtouchkeyboardonshow&&a(hb).prop("readonly",!0),b.stopPropagation()})),jb&&jb.on("keyup change",function(){var b=a(this);h(b.val(),!0)})}function r(){cb.on("contextmenu",function(a){return a.preventDefault(),!1}),a(document).on("colorpickersliders.changeswatches",function(){E()}),eb.swatches.on("touchstart mousedown click","li span",function(b){var c=a(this).css("background-color");h(c),b.preventDefault()}),eb.swatches_add.on("touchstart mousedown click",function(a){H(),a.preventDefault(),a.stopPropagation()}),eb.swatches_remove.on("touchstart mousedown click",function(a){I(),a.preventDefault(),a.stopPropagation()}),eb.swatches_reset.on("touchstart touchend mousedown click",function(a){("click"===a.type||"touchend"===a.type)&&J(),a.preventDefault(),a.stopImmediatePropagation()}),eb.sliders.hue.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){nb="hue";var b=L(nb,a);K("hsla","h",3.6*b),O()}}),eb.sliders.saturation.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){nb="saturation";var b=L(nb,a);K("hsla","s",b/100),O()}}),eb.sliders.lightness.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){nb="lightness";var b=L(nb,a);K("hsla","l",b/100),O()}}),eb.sliders.opacity.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){nb="opacity";var b=L(nb,a);K("hsla","a",b/100),O()}}),eb.sliders.red.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){nb="red";var b=L(nb,a);K("rgba","r",2.55*b),O()}}),eb.sliders.green.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){nb="green";var b=L(nb,a);K("rgba","g",2.55*b),O()}}),eb.sliders.blue.parent().on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){nb="blue";var b=L(nb,a);K("rgba","b",2.55*b),O()}}),eb.hsvpanel.sv.on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){nb="hsvsv";var b=M("sv",a);K("hsv","s",b.horizontal/100),K("hsv","v",(100-b.vertical)/100),O()}}),eb.hsvpanel.h.on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){nb="hsvh";var b=M("h",a);K("hsv","h",3.6*b.vertical),O()}}),eb.hsvpanel.a.on("touchstart mousedown",function(a){if(a.preventDefault(),!(a.which>1)){nb="hsva";var b=M("a",a);K("hsv","a",(100-b.vertical)/100),O()}}),eb.sliders.preview.on("click",function(){this.select()}),a(document).on("touchmove mousemove",function(a){nb&&((new Date).getTime()-sb>qb&&!rb?C(nb,a):B(nb,a))}),a(document).on("touchend mouseup",function(a){a.which>1||nb&&(nb=!1,a.preventDefault())}),eb.pills.hsvpanel.on("click",function(a){a.preventDefault(),y()}),eb.pills.sliders.on("click",function(a){a.preventDefault(),z()}),eb.pills.swatches.on("click",function(a){a.preventDefault(),A()}),bb.flat||db.on("touchstart mousedown",".popover",function(a){return a.preventDefault(),a.stopPropagation(),!1})}function s(a,b){try{localStorage.setItem("cp-userdata-"+a,JSON.stringify(b))}catch(c){}}function t(a){try{var b=JSON.parse(localStorage.getItem("cp-userdata-"+a));return b}catch(c){return null}}function u(){return""!==kb?kb:(0===eb.pills.hsvpanel.length&&(kb+="_hsvpanel_"),0===eb.pills.sliders.length&&(kb+="_sliders_"),0===eb.pills.swatches.length&&(kb+="_swatches_"),kb)}function v(){return t("config_activepill"+u())}function w(a){return s("config_activepill"+u(),a)}function x(){switch(v()){case"hsvpanel":y();break;case"sliders":z();break;case"swatches":A();break;default:if(eb.pills.hsvpanel.length){y();break}if(eb.pills.sliders.length){z();break}if(eb.pills.swatches.length){A();break}}}function y(){return 0===eb.pills.hsvpanel.length?!1:(a("a",eb.all_pills).removeClass("active"),eb.pills.hsvpanel.addClass("active"),cb.removeClass("sliders-active swatches-active").addClass("hsvpanel-active"),w("hsvpanel"),O(!0),i(!0),!0)}function z(){return 0===eb.pills.sliders.length?!1:(a("a",eb.all_pills).removeClass("active"),eb.pills.sliders.addClass("active"),cb.removeClass("hsvpanel-active swatches-active").addClass("sliders-active"),w("sliders"),O(!0),i(!0),!0)}function A(){return 0===eb.pills.swatches.length?!1:(a("a",eb.all_pills).removeClass("active"),eb.pills.swatches.addClass("active"),cb.removeClass("hsvpanel-active sliders-active").addClass("swatches-active"),w("swatches"),O(!0),i(!0),!0)}function B(a,b){clearTimeout(pb),pb=setTimeout(function(){C(a,b)},qb)}function C(a,b){var c;if(rb)return void B(a,b);switch(rb=!0,sb=(new Date).getTime(),c="hsvsv"===a?M("sv",b):"hsvh"===a?M("h",b):"hsva"===a?M("a",b):L(a,b),a){case"hsvsv":K("hsv","s",c.horizontal/100),K("hsv","v",(100-c.vertical)/100);break;case"hsvh":K("hsv","h",3.6*c.vertical);break;case"hsva":K("hsv","a",(100-c.vertical)/100);break;case"hue":K("hsla","h",3.6*c);break;case"saturation":K("hsla","s",c/100);break;case"lightness":K("hsla","l",c/100);break;case"opacity":K("hsla","a",c/100);break;case"red":K("rgba","r",2.55*c);break;case"green":K("rgba","g",2.55*c);break;case"blue":K("rgba","b",2.55*c)}O(),b.preventDefault(),rb=!1}function D(){fb=[];for(var a=0;a<bb.swatches.length;a++){var b=tinycolor(bb.swatches[a]);b.isValid()&&fb.push(b.toRgbString())}}function E(){if(bb.swatches){if(bb.customswatches){var b=!1;try{b=JSON.parse(localStorage.getItem("swatches-"+bb.customswatches))}catch(c){}b?fb=b:D()}else D();if(fb instanceof Array){eb.swatches.html("");for(var d=0;d<fb.length;d++){var e=tinycolor(fb[d]);if(e.isValid()){var f=a("<span></span>").css("background-color",e.toRgbString()),g=a('<div class="btn btn-default cp-swatch"></div>');g.append(f),eb.swatches.append(a("<li></li>").append(g))}}}F()}}function F(){var b=!1;a("span",eb.swatches).filter(function(){var c=a(this).css("background-color");if(c=tinycolor(c),c.alpha=Math.round(100*c.alpha)/100,c.toRgbString()===tb.tiny.toRgbString()){b=!0;var d=a(this).parent();d.is(eb.actualswatch)||(eb.actualswatch&&eb.actualswatch.removeClass("actual"),eb.actualswatch=d,d.addClass("actual"))}}),b||eb.actualswatch&&(eb.actualswatch.removeClass("actual"),eb.actualswatch=!1),eb.actualswatch?(eb.swatches_add.prop("disabled",!0),eb.swatches_remove.prop("disabled",!1)):(eb.swatches_add.prop("disabled",!1),eb.swatches_remove.prop("disabled",!0))}function G(){localStorage.setItem("swatches-"+bb.customswatches,JSON.stringify(fb))}function H(){fb.unshift(tb.tiny.toRgbString()),G(),a(document).trigger("colorpickersliders.changeswatches")}function I(){var b=fb.indexOf(tb.tiny.toRgbString());-1!==b&&(fb.splice(b,1),G(),a(document).trigger("colorpickersliders.changeswatches"))}function J(){confirm("Do you really want to reset the swatches? All customizations will be lost!")&&(D(),G(),a(document).trigger("colorpickersliders.changeswatches"))}function K(a,b,c){switch(a){case"hsv":tb.hsv[b]=c,tb.tiny=tinycolor({h:tb.hsv.h,s:tb.hsv.s,v:tb.hsv.v,a:tb.hsv.a}),tb.rgba=tb.tiny.toRgb(),tb.hsla=tb.tiny.toHsl();break;case"hsla":tb.hsla[b]=c,tb.tiny=tinycolor({h:tb.hsla.h,s:tb.hsla.s,l:tb.hsla.l,a:tb.hsla.a}),tb.rgba=tb.tiny.toRgb(),tb.hsv=tb.tiny.toHsv();break;case"rgba":tb.rgba[b]=c,tb.tiny=tinycolor({r:tb.rgba.r,g:tb.rgba.g,b:tb.rgba.b,a:tb.hsla.a}),tb.hsla=tb.tiny.toHsl(),tb.hsv=tb.tiny.toHsv()}}function L(b,c){var d=a.fn.ColorPickerSliders.calculateEventPositionPercentage(c,eb.sliders[b]);return eb.sliders[b+"_marker"].data("position",d),d}function M(b,c){var d=a.fn.ColorPickerSliders.calculateEventPositionPercentage(c,eb.hsvpanel.sv,!0);return eb.hsvpanel[b+"_marker"].data("position",d),d}function N(a){ub=setTimeout(function(){O(a)},bb.updateinterval)}function O(a){return clearTimeout(ub),Date.now=Date.now||function(){return+new Date},Date.now()-ob<bb.updateinterval?void N(a):("undefined"==typeof a&&(a=!1),ob=Date.now(),bb.hsvpanel===!1||bb.grouping&&"hsvpanel"!==v()||(R(),S(),T()),!bb.sliders||bb.grouping&&"sliders"!==v()||(bb.order.opacity!==!1&&X(),bb.order.hsl!==!1&&(U(),V(),W()),bb.order.rgb!==!1&&(Y(),Z(),$()),bb.order.preview!==!1&&_()),a||Q(),(100-100*tb.hsla.l)*tb.hsla.a<bb.previewcontrasttreshold?(eb.all_sliders.css("color","#000"),ib&&bb.previewontriggerelement&&hb.css("background",tb.tiny.toRgbString()).css("color","#000")):(eb.all_sliders.css("color","#fff"),ib&&bb.previewontriggerelement&&hb.css("background",tb.tiny.toRgbString()).css("color","#fff")),!bb.swatches||bb.grouping&&"swatches"!==v()||F(),bb.onchange(cb,tb),void hb.data("color",tb))}function P(){ib&&bb.previewontriggerelement&&((100-100*tb.hsla.l)*tb.hsla.a<bb.previewcontrasttreshold?hb.csO    O                    PC            KO    O            O    l      O            ("color","#fff"))}function Q(){jb&&jb.each(function(b,c){var d=a(c),e=d.data("color-format")||bb.previewformat;switch(e){case"hex":d.val(tb.hsla.a<1?tb.tiny.toRgbString():tb.tiny.toHexString());break;case"hsl":d.val(tb.tiny.toHslString());break;case"rgb":default:d.val(tb.tiny.toRgbString())}})}function R(){eb.hsvpanel.sv.css("background",tinycolor("hsv("+tb.hsv.h+",100%,100%)").toRgbString()),eb.hsvpanel.sv_marker.css("left",100*tb.hsv.s+"%").css("top",100-100*tb.hsv.v+"%")}function S(){eb.hsvpanel.h_marker.css("top",tb.hsv.h/360*100+"%")}function T(){ab(eb.hsvpanel.a,a.fn.ColorPickerSliders.getScaledGradientStops(tb.hsla,"a",1,0,2),!0),eb.hsvpanel.a_marker.css("top",100-100*tb.hsv.a+"%")}function U(){ab(eb.sliders.hue,a.fn.ColorPickerSliders.getScaledGradientStops(tb.hsla,"h",0,360,7)),eb.sliders.hue_marker.css("left",tb.hsla.h/360*100+"%")}function V(){ab(eb.sliders.saturation,a.fn.ColorPickerSliders.getScaledGradientStops(tb.hsla,"s",0,1,2)),eb.sliders.saturation_marker.css("left",100*tb.hsla.s+"%")}function W(){ab(eb.sliders.lightness,a.fn.ColorPickerSliders.getScaledGradientStops(tb.hsla,"l",0,1,3)),eb.sliders.lightness_marker.css("left",100*tb.hsla.l+"%")}function X(){ab(eb.sliders.opacity,a.fn.ColorPickerSliders.getScaledGradientStops(tb.hsla,"a",0,1,2)),eb.sliders.opacity_marker.css("left",100*tb.hsla.a+"%")}function Y(){ab(eb.sliders.red,a.fn.ColorPickerSliders.getScaledGradientStops(tb.rgba,"r",0,255,2)),eb.sliders.red_marker.css("left",tb.rgba.r/255*100+"%")}function Z(){ab(eb.sliders.green,a.fn.ColorPickerSliders.getScaledGradientStops(tb.rgba,"g",0,255,2)),eb.sliders.green_marker.css("left",tb.rgba.g/255*100+"%")}function $(){ab(eb.sliders.blue,a.fn.ColorPickerSliders.getScaledGradientStops(tb.rgba,"b",0,255,2)),eb.sliders.blue_marker.css("left",tb.rgba.b/255*100+"%")}function _(){eb.sliders.preview.css("background",a.fn.ColorPickerSliders.csscolor(tb.rgba));var b;switch(bb.previewformat){case"hex":b=tb.hsla.a<1?tb.tiny.toRgbString():tb.tiny.toHexString();break;case"hsl":b=tb.tiny.toHslString();break;case"rgb":default:b=tb.tiny.toRgbString()}eb.sliders.preview.val(b)}function ab(b,c,d){switch("undefined"==typeof d&&(d=!1),c.sort(function(a,b){return a.position-b.position}),lb){case"noprefix":a.fn.ColorPickerSliders.renderNoprefix(b,c,d);break;case"webkit":a.fn.ColorPickerSliders.renderWebkit(b,c,d);break;case"ms":a.fn.ColorPickerSliders.renderMs(b,c,d);break;case"svg":a.fn.ColorPickerSliders.renderSVG(b,c,d);break;case"oldwebkit":a.fn.ColorPickerSliders.renderOldwebkit(b,c,d)}}var bb,cb,db,eb,fb,gb=!1,hb=a(this),ib=hb.is("input"),jb=!1,kb="",lb=!1,mb=!1,nb=!1,ob=0,pb=null,qb=70,rb=!1,sb=0,tb={tiny:null,hsla:null,rgba:null,hsv:null};d();var ub})},a.fn.ColorPickerSliders.getEventCoordinates=function(a){return"undefined"!=typeof a.pageX?{pageX:a.originalEvent.pageX,pageY:a.originalEvent.pageY}:"undefined"!=typeof a.originalEvent.touches?{pageX:a.originalEvent.touches[0].pageX,pageY:a.originalEvent.touches[0].pageY}:void 0},a.fn.ColorPickerSliders.calculateEventPositionPercentage=function(b,c,d){"undefined"==typeof d&&(d=!1);var e=a.fn.ColorPickerSliders.getEventCoordinates(b),f=c.width(),g=e.pageX-c.offset().left,h=g/f*100;if(0>h&&(h=0),h>100&&(h=100),d){var i=c.height(),j=e.pageY-c.offset().top,k=j/i*100;return 0>k&&(k=0),k>100&&(k=100),{horizontal:h,vertical:k}}return h},a.fn.ColorPickerSliders.getScaledGradientStops=function(b,c,d,e,f,g,h,i){"undefined"==typeof g&&(g=1),"undefined"==typeof h&&(h=0),"undefined"==typeof i&&(i=100);for(var j=[],k=e-d,l=!0,m=0;f>m;++m){var n,o=m/(f-1),p=a.fn.ColorPickerSliders.modifyColor(b,c,o*k+d);if(1>g){var q=a.fn.ColorPickerSliders.lch2rgb(p,g);l=q.isok,n=a.fn.ColorPickerSliders.csscolor(q,g)}else n=a.fn.ColorPickerSliders.csscolor(p,g);j[m]={color:n,position:o*(i-h)+h,isok:l,rawcolor:p}}return j},a.fn.ColorPickerSliders.getGradientStopsCSSString=function(a){for(var b="",c="",d="",e=0;e<a.length;e++){var f=a[e];b+=","+f.color+" "+f.position+"%",c+=",color-stop("+f.position+"%,"+f.color+")";var g=tinycolor(f.color);d+='<stop stop-color="'+g.toHexString()+'" stop-opacity="'+g.toRgb().a+'" offset="'+f.position/100+'"/>'}return{noprefix:b,oldwebkit:c,svg:d}},a.fn.ColorPickerSliders.renderNoprefix=function(b,c,d){"undefined"==typeof d&&(d=!1);var e,f=a.fn.ColorPickerSliders.getGradientStopsCSSString(c).noprefix;e=d?"linear-gradient(to bottom":"linear-gradient(to right",e+=f+")",b.css("background-image",e)},a.fn.ColorPickerSliders.renderWebkit=function(b,c,d){"undefined"==typeof d&&(d=!1);var e,f=a.fn.ColorPickerSliders.getGradientStopsCSSString(c).noprefix;e=d?"-webkit-linear-gradient(top":"-webkit-linear-gradient(left",e+=f+")",b.css("background-image",e)},a.fn.ColorPickerSliders.renderOldwebkit=function(b,c,d){"undefined"==typeof d&&(d=!1);var e,f=a.fn.ColorPickerSliders.getGradientStopsCSSString(c).oldwebkit;e=d?"-webkit-gradient(linear, 0% 0%, 0 100%":"-webkit-gradient(linear, 0% 0%, 100% 0%",e+=f+")",b.css("background-image",e)},a.fn.ColorPickerSliders.renderMs=function(b,c,d){"undefined"==typeof d&&(d=!1);var e,f=a.fn.ColorPickerSliders.getGradientStopsCSSString(c).noprefix;e=d?"-ms-linear-gradient(to bottom":"-ms-linear-gradient(to right",e+=f+")",b.css("background-image",e)},a.fn.ColorPickerSliders.renderSVG=function(b,c,d){"undefined"==typeof d&&(d=!1);var e="",f=a.fn.ColorPickerSliders.getGradientStopsCSSString(c).svg;e=d?'<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 1 1" preserveAspectRatio="none"><linearGradient id="vsgg" gradientUnits="userSpaceOnUse" x1="0" y1="0" x2="0" y2="100%">':'<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 1 1" preserveAspectRatio="none"><linearGradient id="vsgg" gradientUnits="userSpaceOnUse" x1="0" y1="0" x2="100%" y2="0">',e+=f,e+='</linearGradient><rect x="0" y="0" width="1" height="1" fill="url(#vsgg)" /></svg>',e="url(data:image/svg+xml;base64,"+a.fn.ColorPickerSliders.base64encode(e)+")",b.css("background-image",e)},a.fn.ColorPickerSliders.base64encode=function(a){var b,c,d,e,f,g,h,i,j="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",k=0,l=0,m="",n=[];if(!a)return a;do b=a.charCodeAt(k++),c=a.charCodeAt(k++),d=a.charCodeAt(k++),i=b<<16|c<<8|d,e=i>>18&63,f=i>>12&63,g=i>>6&63,h=63&i,n[l++]=j.charAt(e)+j.charAt(f)+j.charAt(g)+j.charAt(h);while(k<a.length);m=n.join("");var o=a.length%3;return(o?m.slice(0,o-3):m)+"===".slice(o||3)},a.fn.ColorPickerSliders.modifyColor=function(b,c,d){var e=a.extend({},b);if(!b.hasOwnProperty(c))throw"Missing color property: "+c;return e[c]=d,e},a.fn.ColorPickerSliders.csscolor=function(b){var c=!1,d=a.extend({},b);return d.hasOwnProperty("h")&&(c="hsla("+d.h+","+100*d.s+"%,"+100*d.l+"%,"+d.a+")"),d.hasOwnProperty("r")&&(c=d.a<1?"rgba("+Math.round(d.r)+","+Math.round(d.g)+","+Math.round(d.b)+","+d.a+")":"rgb("+Math.round(d.r)+","+Math.round(d.g)+","+Math.round(d.b)+")"),c},a.fn.ColorPickerSliders.detectWhichGradientIsSupported=function(){var a=document.createElement("detectGradientSupport").style;try{if(a.backgroundImage="linear-gradient(to top left, #9f9, white)",-1!==a.backgroundImage.indexOf("gradient"))return"noprefix";if(a.backgroundImage="-webkit-linear-gradient(left top, #9f9, white)",-1!==a.backgroundImage.indexOf("gradient"))return"webkit";if(a.backgroundImage="-ms-linear-gradient(left top, #9f9, white)",-1!==a.backgroundImage.indexOf("gradient"))return"ms";if(a.backgroundImage="-webkit-gradient(linear, left top, right bottom, from(#9f9), to(white))",-1!==a.backgroundImage.indexOf("gradient"))return"oldwebkit"}catch(b){try{if(a.filter='progid:DXImageTransform.Microsoft.gradient(startColorstr="#ffffff",endColorstr="#000000",GradientType=0)',-1!==a.filter.indexOf("DXImageTransform"))return"filter"}catch(b){}}return!1},a.fn.ColorPickerSliders.svgSupported=function(){return!!document.createElementNS&&!!document.createElementNS("http://www.w3.org/2000/svg","svg").createSVGRect}}(jQuery);