<?php

class ModelUserUser extends Model
{
    public function addUser($data)
    {
        $this->db->query("INSERT INTO `" . DB_PREFIX . "user` SET username = '" . $this->db->escape($data['username']) . "', user_group_id = '" . (int) $data['user_group_id'] . "', salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "', firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "', image = '" . $this->db->escape($data['image']) . "', chinesename ='" . $this->db->escape($data['chinesename']) . "', gender ='" . $this->db->escape($data['gender']) . "', dob ='" . $this->db->escape($data['dob']) . "', maritalstatus ='" . $this->db->escape($data['maritalstatus']) . "', race ='" . $this->db->escape($data['race']) . "', address ='" . $this->db->escape($data['address']) . "', ic ='" . $this->db->escape($data['ic']) . "', contactno ='" . $this->db->escape($data['contactno']) . "', salary ='" . $this->db->escape($data['salary']) . "', enable_appointment = '" . (int) $data['enable_appointment'] . "', show_for_appointment = '" . (int) $data['show_for_appointment'] . "',doctor_sort_order = '" . (int) $data['doctor_sort_order'] . "', enable_consultation_price = '" . (int) $data['enable_consultation_price'] . "', consultationprice ='" . $this->db->escape($data['consultationprice']) . "', tax_class_id ='" . (int) $data['tax_class_id'] . "', qualification ='" . $this->db->escape($data['qualification']) . "', periodfrom ='" . $this->db->escape($data['periodfrom']) . "', periodto ='" . $this->db->escape($data['periodto']) . "', remark ='" . $this->db->escape($data['remark']) . "', viewalldata ='" . (int) $data['viewalldata'] . "', position ='" . (int) $data['position'] . "', status = '" . (int) $data['status'] . "', add_by = '" . (int) $this->session->data['user_id'] . "', modify_by = '" . (int) $this->session->data['user_id'] . "', date_added = NOW(), date_modify = NOW()");

        $user_id = $this->db->getLastId();

        if (isset($data['user_store'])) {
            foreach ($data['user_store'] as $store_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "user_to_store SET user_id = '" . (int) $user_id . "', store_id = '" . (int) $store_id . "'");
            }
        }

        $this->db->query("INSERT INTO " . DB_PREFIX . "user_permission SET user_id = '" . (int) $user_id . "', permission = '" . (isset($data['permission']) ? $this->db->escape(json_encode($data['permission'])) : '') . "'");
    }

    public function editUser($user_id, $data)
    {
        $this->db->query("UPDATE `" . DB_PREFIX . "user` SET username = '" . $this->db->escape($data['username']) . "', user_group_id = '" . (int) $data['user_group_id'] . "', firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "', image = '" . $this->db->escape($data['image']) . "', chinesename ='" . $this->db->escape($data['chinesename']) . "', gender ='" . $this->db->escape($data['gender']) . "', dob ='" . $this->db->escape($data['dob']) . "', maritalstatus ='" . $this->db->escape($data['maritalstatus']) . "', race ='" . $this->db->escape($data['race']) . "', address ='" . $this->db->escape($data['address']) . "', ic ='" . $this->db->escape($data['ic']) . "', contactno ='" . $this->db->escape($data['contactno']) . "', salary ='" . $this->db->escape($data['salary']) . "', enable_appointment = '" . (int) $data['enable_appointment'] . "',  show_for_appointment = '" . (int) $data['show_for_appointment'] . "', enable_consultation_price = '" . (int) $data['enable_consultation_price'] . "', consultationprice ='" . $this->db->escape($data['consultationprice']) . "', tax_class_id ='" . (int) $data['tax_class_id'] . "', doctor_sort_order = '" . (int) $data['doctor_sort_order'] . "', qualification ='" . $this->db->escape($data['qualification']) . "', periodfrom ='" . $this->db->escape($data['periodfrom']) . "', periodto ='" . $this->db->escape($data['periodto']) . "', remark ='" . $this->db->escape($data['remark']) . "', viewalldata ='" . (int) $data['viewalldata'] . "', position ='" . (int) $data['position'] . "', status = '" . (int) $data['status'] . "', modify_by = '" . (int) $this->session->data['user_id'] . "', date_modify = NOW() WHERE user_id = '" . (int) $user_id . "'");

        if ($data['password']) {
            $this->db->query("UPDATE `" . DB_PREFIX . "user` SET salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "' WHERE user_id = '" . (int) $user_id . "'");
        }

        $this->db->query("UPDATE " . DB_PREFIX . "user_permission SET  permission = '" . (isset($data['permission']) ? $this->db->escape(json_encode($data['permission'])) : '') . "' WHERE user_id = '" . (int) $user_id . "'");

        $this->db->query("DELETE FROM " . DB_PREFIX . "user_to_store WHERE user_id = '" . (int) $user_id . "'", 100);

        if (isset($data['user_store'])) {
            foreach ($data['user_store'] as $store_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "user_to_store SET user_id = '" . (int) $user_id . "', store_id = '" . (int) $store_id . "'");
            }
        }
    }

    public function editPassword($user_id, $password)
    {
        $this->db->query("UPDATE `" . DB_PREFIX . "user` SET salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($password)))) . "', code = '' WHERE user_id = '" . (int) $user_id . "'");
    }

    public function editCode($email, $code)
    {
        $this->db->query("UPDATE `" . DB_PREFIX . "user` SET code = '" . $this->db->escape($code) . "' WHERE LCASE(email) = '" . $this->db->escape(utf8_strtolower($email)) . "'");
    }

    public function deleteUser($user_id)
    {
        $this->db->query("DELETE FROM `" . DB_PREFIX . "user` WHERE user_id = '" . (int) $user_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "user_permission WHERE user_id = '" . (int) $user_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "user_to_store WHERE user_id = '" . (int) $user_id . "'", 100);
    }

    public function getUser($user_id)
    {
        $query = $this->db->query("SELECT *, (SELECT ug.name FROM `" . DB_PREFIX . "user_group` ug WHERE ug.user_group_id = u.user_group_id) AS user_group FROM `" . DB_PREFIX . "user` u WHERE u.user_id = '" . (int) $user_id . "'");

        return $query->row;
    }

    //add by mlaxwong
    public function getDoctor($doctor_id)
    {
        $query = $this->db->query("SELECT *, (SELECT ug.name FROM `" . DB_PREFIX . "user_group` ug WHERE ug.user_group_id = u.user_group_id) AS user_group FROM `" . DB_PREFIX . "user` u WHERE u.user_id = '" . (int) $doctor_id . "' AND position = '2'");

        return $query->row;
    }

    public function getUserByUsername($username)
    {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "user` WHERE username = '" . $this->db->escape($username) . "'");

        return $query->row;
    }

    public function getUserByContactno($contactno)
    {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "user` WHERE contactno = '" . $this->db->escape($contactno) . "'");

        return $query->row;
    }

    public function getUserByIc($ic)
    {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "user` WHERE ic = '" . $this->db->escape($ic) . "'");

        return $query->row;
    }

    public function getUserStores($userid)
    {
        $user_store_data = array();

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store WHERE user_id = '" . (int) $userid . "'");

        foreach ($query->rows as $result) {
            $user_store_data[] = $result['store_id'];
        }

        return $user_store_data;
    }

    public function getUserPermission($userid)
    {
        $query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user_permission WHERE user_id = '" . (int) $userid . "'");

        return json_decode($query->row['permission'], true);
    }

    public function getUserByCode($code)
    {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "user` WHERE code = '" . $this->db->escape($code) . "' AND code != ''");

        return $query->row;
    }

    public function getUsers($data = array())
    {
        $sql = "SELECT ug.name AS name, u.* FROM `" . DB_PREFIX . "user` u LEFT JOIN `" . DB_PREFIX . "user_group` ug ON ug.user_group_id = u.user_group_id WHERE u.hide_user = '0'";

        $sort_data = array(
            'username',
            'status',
            'date_added',
            'periodfrom',
            'periodto'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY CASE WHEN u.status = '1' THEN 0 ELSE 1 END, " . $data['sort'];
        } else {
            $sql .= " ORDER BY CASE WHEN u.status = '1' THEN 0 ELSE 1 END, username ASC";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }


    public function getUserByPostion($position)
    {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "user` u WHERE position = '" . $position . "'");
        return $query->rows;
    }

    public function getUserforPurchase($data = array())
    {
        $sql = "SELECT *, CONCAT(u.firstname,' ',u.lastname) AS user_name  FROM " . DB_PREFIX . "user u WHERE position = '2'";

        $sort_data = array(
            'user_name',
            'status',
            'date_added'
        );

        if (!empty($data['filter_user_name'])) {
            $sql .= " AND CONCAT(u.firstname,' ',u.lastname) LIKE '%" . $data['filter_user_name'] . "%'";
        }

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY user_name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalUsers()
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "user` WHERE hide_user = '0'");

        return $query->row['total'];
    }

    public function getTotalUsersByGroupId($user_group_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "user` WHERE user_group_id = '" . (int) $user_group_id . "'");

        return $query->row['total'];
    }

    public function getTotalUsersByEmail($email)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "user` WHERE LCASE(email) = '" . $this->db->escape(utf8_strtolower($email)) . "'");

        return $query->row['total'];
    }

    public function getAllService()
    {
        $sql="SELECT
        csd.clinicalservice_id ,
        csd.name
        FROM oc_clinical_service cs
        LEFT JOIN oc_clinical_service_description csd
        ON cs.clinicalservice_id = csd.clinicalservice_id 
        WHERE 1 AND csd.language_id = '" . (int)$this->config->get('config_language_id') . "'

        ";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getService()
    {
        $sql="SELECT
        cs.*
        FROM oc_clinical_service cs
        WHERE 1
        ";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function UpdateDoctorService($doctor_id, $data)
    {
        $servicesFromPosts = isset($data['doctor_service']) ? $data['doctor_service'] : [];
        $servicesFromDB = $this->getService();

        foreach ($servicesFromDB as $service) {

            $doctor_ids = unserialize($service['doctor_id']);

            if (in_array($service['clinicalservice_id'], $servicesFromPosts)) {

                if($doctor_ids != '') {
                    $doctors = array_diff($doctor_ids, array($doctor_id));
                    // print_r($doctors);
                    array_push($doctors, $doctor_id);
                    $doctor = serialize($doctors);

                } else {
                    $doctor = serialize($doctor_id);

                }


                $this->db->query("UPDATE oc_clinical_service SET doctor_id = '".$this->db->escape($doctor)."' WHERE clinicalservice_id = '".(int)$service['clinicalservice_id']."'");
            } else {

                if($doctor_ids != '') {
                    $doctors = array_diff($doctor_ids, array($doctor_id));
                    $doctor = serialize($doctors);

                } else {
                    $doctor = serialize('');

                }


                $this->db->query("UPDATE oc_clinical_service SET doctor_id = '".$this->db->escape($doctor)."' WHERE clinicalservice_id = '".(int)$service['clinicalservice_id']."'");

            }



            $doctor_service = $this->db->query("SELECT * FROM oc_user_to_services uts WHERE uts.user_id = '".(int)$doctor_id."'");

            if($doctor_service) {

                $this->db->query("DELETE FROM oc_user_to_services WHERE user_id = '".(int)$doctor_id."'");


            }
            foreach($servicesFromPosts as $servicesFromPost) {


                $this->db->query("INSERT INTO oc_user_to_services SET user_id = '".(int)$doctor_id."', service_id = '".(int)$servicesFromPost."' ");
            }

        }
    }
}
