<?php

class ModelSettingStoreOpening extends Model{
    public function getStoreOpening($store_opening_id){
        $sql = "SELECT * FROM " . DB_PREFIX . "store_opening WHERE store_opening_id = '" . (int)$store_opening_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getStoreOpeningTimes($store_opening_id){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_opening_time WHERE store_opening_id = '" . $store_opening_id . "' ORDER BY store_opening_time_id ASC");

		return $query->rows;
	}

    public function getStoreOpenings($data){
        
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        
        $sql = "SELECT * FROM " . DB_PREFIX . "store_opening WHERE store_id = '" . $store_id . "'";

        if(!empty($data['filter_day'])){
            $sql .= " AND day = '" . $this->db->escape($data['filter_day']) . "'";
        }

        if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalStoreOpenings($data){
        
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "store_opening WHERE store_id = '" . $store_id . "'";

        if(!empty($data['filter_day'])){
            $sql .= " AND day = '" . $this->db->escape($data['filter_day']) . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function checkDuplicate($day, $store_id){
        $sql = "SELECT *
                FROM " . DB_PREFIX . "store_opening
                WHERE day = '" . $this->db->escape($day) . "'
                AND store_id = '" . (int)$store_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function addStoreOpening($data){
        $store_opening_time_arr = [];

        $sql = "INSERT INTO " . DB_PREFIX . "store_opening
                SET store_id = '" . (int)$data['store_id'] . "',
                    day = '" . $this->db->escape($data['day']) . "',
                    session = '" . (int)$data['service_session'] . "',
                    enable_session = '" . (int)$data['enable_service_session'] . "',
                    date_added = NOW(),
                    add_by = '" . (int)$this->session->data['user_id'] . "',
                    date_modified = NOW(),
                    modify_by = '" . (int)$this->session->data['user_id'] . "'";

        $query = $this->db->query($sql);

        $store_opening_id = $this->db->getLastId();

        if($store_opening_id > 0){
            if(isset($data['store_opening_times'])){
                foreach($data['store_opening_times'] as $time){
                    $this->db->query("INSERT INTO " . DB_PREFIX . "store_opening_time
                                      SET store_opening_id = '" . (int)$store_opening_id . "',
                                          start_time = '" . $this->db->escape($time['start_time']) . "',
                                          end_time = '" . $this->db->escape($time['end_time']) . "',
                                          added_by = '" . $this->user->getId() . "',
                                          date_added = NOW()"
                                    );

                    $store_opening_time_arr[] = [
                        'store_opening_time_id'     => $this->db->getLastId(),
                        'start_time'                => $time['start_time'],
                        'end_time'                  => $time['end_time']
                    ];
                }
            }
        }

        return $store_opening_time_arr;
    }

    public function editStoreOpening($data, $store_opening_id){
        $store_opening_time_arr = [];

        $this->db->query("UPDATE " . DB_PREFIX . "store_opening
                          SET store_id = '" . (int)$data['store_id'] . "',
                              day = '" . $this->db->escape($data['day']) . "',
                              session = '" . (int)$data['service_session'] . "',
                              enable_session = '" . (int)$data['enable_service_session'] . "',
                              date_modified = NOW(),
                              modify_by = '" . (int)$this->session->data['user_id'] . "'
                          WHERE store_opening_id = '" . (int)$store_opening_id . "'");

        $this->db->query("DELETE FROM " . DB_PREFIX . "store_opening_time WHERE store_opening_id = '" . (int)$store_opening_id . "'");

		if(isset($data['store_opening_times'])){
			foreach($data['store_opening_times'] as $time){
				$this->db->query("INSERT INTO " . DB_PREFIX . "store_opening_time
								  SET store_opening_id = '" . (int)$store_opening_id . "',
									  start_time = '" . $this->db->escape($time['start_time']) . "',
									  end_time = '" . $this->db->escape($time['end_time']) . "',
									  added_by = '" . $this->user->getId() . "',
									  date_added = NOW()"
								);

                $store_opening_time_arr[] = [
                    'store_opening_time_id'     => $this->db->getLastId(),
                    'start_time'                => $time['start_time'],
                    'end_time'                  => $time['end_time']
                ];
			}
		}

        return $store_opening_time_arr;
    }

    public function deleteStoreOpening($store_opening_id){
        $this->db->query("DELETE FROM " . DB_PREFIX . "store_opening WHERE store_opening_id = '" . (int)$store_opening_id . "'");

        $this->db->query("DELETE FROM " . DB_PREFIX . "store_opening_time WHERE store_opening_id = '" . (int)$store_opening_id . "'");
    }
}
?>