<?php
class ModelSaleSupplierPaymentMethod extends Model {
    public function getSupplierPaymentMethod($supplier_payment_method_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "supplier_payment_method WHERE supplier_payment_method_id = '" . (int)$supplier_payment_method_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getSupplierPaymentMethods($data) {
        $sql = "SELECT * FROM " . DB_PREFIX . "supplier_payment_method WHERE 1";

        if (!empty($data['filter_sql_accounting_code'])) {
            $sql .= " AND sql_accounting_code LIKE '%" . $this->db->escape($data['filter_sql_accounting_code']) . "%'";
        }

        if ($data['filter_status'] != '') {
            $sql .= " AND status = '" . (int)$data['filter_status'] . "'";
        }

        $sort_data = array(
			'status',
			'supplier_payment_method_id',
			'sql_accounting_code',
			'sort_order',
			'date_added'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY sort_order";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
        }
        
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function addSupplierPaymentMethod($data) {
        $payment_method_name = json_encode($data['payment_method_name']);

        $sql = "INSERT INTO " . DB_PREFIX . "supplier_payment_method SET payment_method_name = '" . $this->db->escape($payment_method_name) . "', sql_accounting_code = '" . $this->db->escape($data['sql_accounting_code']) . "', status = '" . (int)$data['status'] . "', sort_order = '" . (int)$data['sort_order'] . "', date_added = NOW(), add_by = '" . (int)$this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "'";

        $query = $this->db->query($sql);

        return $this->db->getLastId();
    }

    public function editSupplierPaymentMethod($data, $supplier_payment_method_id) {
        $payment_method_name = json_encode($data['payment_method_name']);

        $sql = "UPDATE " . DB_PREFIX . "supplier_payment_method SET payment_method_name = '" . $this->db->escape($payment_method_name) . "', sql_accounting_code = '" . $this->db->escape($data['sql_accounting_code']) . "', status = '" . (int)$data['status'] . "', sort_order = '" . (int)$data['sort_order'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "' WHERE supplier_payment_method_id = '" . (int)$supplier_payment_method_id . "'";

        $query = $this->db->query($sql);
    }

    public function deleteSupplierPaymentMethod($supplier_payment_method_id) {
        $sql = "DELETE FROM " . DB_PREFIX . "supplier_payment_method WHERE supplier_payment_method_id = '" . (int)$supplier_payment_method_id . "'";

        $query = $this->db->query($sql);
    }
}
?>