<?php
class ModelSalePurchaseReceive extends Model {
    public function addPurchaseReceive($data, $cart = array()) {
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/purchase_receive', 'store' => $this->session->data['store_id']));

        $store_id = $this->session->data['store_id'];

        $this->load->model('setting/setting');
        $store_setting = $this->model_setting_setting->getSetting('config', $store_id);

        $sql = "
		INSERT INTO " . DB_PREFIX . "purchase_receive SET
			invoice_prefix = '" . $this->db->escape($invoice_prefix) . "',
			purchase_order_id = '" . (int)$data['purchase_order_id'] . "',
			store_id = '" . (int)$store_id . "',
			comment = '" . $this->db->escape($data['comment']) . "',
			order_status_id = '" . (int)$data['order_status_id'] . "',
			date_added = NOW(),
			add_by = " . (int)$this->session->data['user_id'] . ",
			date_modified = NOW(),
			modify_by = " . (int)$this->session->data['user_id'] . "
		";
        $query = $this->db->query($sql);

        $purchase_receive_id = $this->db->getLastId();

        if ($purchase_receive_id != 0) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/purchase_receive', 'store' => $this->session->data['store_id']));

            foreach ($cart->getProducts() as $product_id => $product) {
                if ($product['quantity'] > 0) {

                    $purchase_order_id = ($product['purchase_order']) ? $data['purchase_order_id'] : 0;
                    $sql = "
				  INSERT INTO " . DB_PREFIX . "purchase_receive_product SET
				  purchase_receive_id = '" . (int)$purchase_receive_id . "',
				  purchase_order_id = '" . (int)$purchase_order_id . "',
				  product_id = '" . (int)$product_id . "',
				  quantity = '" . (float)$product['quantity'] . "'
				  ";
                    $query = $this->db->query($sql);

                    if ($data['order_status_id'] == 5) {
                        $this->db->query("
					  UPDATE " . DB_PREFIX . "product_to_store SET
						  onhand_quantity = onhand_quantity + " . $product['quantity'] . "
					  WHERE 1
					  AND product_id = '" . (int)$product_id . "'
					  AND store_id = '" . (int)$store_id . "'
					  ");
                    }
                }
            }
        }

        return $purchase_receive_id;
    }

    public function editPurchaseReceive($purchase_receive_id, $data = array(), $cart = array()) {
        $store_id = $this->session->data['store_id'];
        
        $sql = "
		UPDATE " . DB_PREFIX . "purchase_receive SET
			purchase_order_id = '" . (int)$data['purchase_order_id'] . "',
			comment = '" . $this->db->escape($data['comment']) . "',
			order_status_id = '" . (int)$data['order_status_id'] . "',
			date_modified = NOW(),
			modify_by = " . (int)$this->session->data['user_id'] . "
		WHERE purchase_receive_id = '" . (int)$purchase_receive_id . "'
		";
        $query = $this->db->query($sql);

        $sql = "DELETE FROM " . DB_PREFIX . "purchase_receive_product WHERE purchase_receive_id = '" . (int)$purchase_receive_id . "'";
        $query = $this->db->query($sql);

        foreach ($cart->getProducts() as $product_id => $product) {
            if ($product['quantity'] > 0) {

                $purchase_order_id = ($product['purchase_order']) ? $data['purchase_order_id'] : 0;
                $sql = "
				INSERT INTO " . DB_PREFIX . "purchase_receive_product SET
				purchase_receive_id = '" . (int)$purchase_receive_id . "',
				purchase_order_id = '" . (int)$purchase_order_id . "',
				product_id = '" . (int)$product_id . "',
				quantity = '" . (float)$product['quantity'] . "'
				";

                $query = $this->db->query($sql);

                if ($data['order_status_id'] == 5) {
                    $this->db->query("
					UPDATE " . DB_PREFIX . "product_to_store SET
						onhand_quantity = onhand_quantity + " . $product['quantity'] . "
					WHERE 1
					AND product_id = '" . (int)$product_id . "'
					AND store_id = '" . (int)$store_id . "'
					");
                }
            }
        }

        return $purchase_receive_id;
    }

    public function getPurchaseReceive($purchase_receive_id) {
        $language_id = $this->config->get('config_language_id');

        $sql = "
		SELECT
			pr.*,
			os.name AS order_status,
			po.invoice_prefix AS purchase_order_invoice,
			m.name AS manufacturer_name,
			m.code AS manufacturer_code
		FROM " . DB_PREFIX . "purchase_receive pr
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON pr.order_status_id = os.order_status_id
		AND os.language_id = '" . (int)$language_id . "'
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pr.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		WHERE purchase_receive_id = '" . (int)$purchase_receive_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getPurchaseReceives($data = array()) {
        $language_id = $this->config->get('config_language_id');

        $sort = isset($data['sort']) ? $data['sort'] : "purchase_receive_id";
        $order = isset($data['order']) ? $data['order'] : "DESC";

        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND pr.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND pr.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";
        
        $filter_manufacturer_prefix = (!empty($data['filter_transaction'])) ?
                "AND pr.invoice_prefix LIKE '%" . $this->db->escape($data['filter_transaction']) . "%'" :
                "";
        
        $filter_manufactuerer_id = (!empty($data['filter_manufacturer_id'])) ?
                " AND manufacturer_id = '" . (int)$data['filter_manufacturer_id'] . "'" :
                "";

        $filter_order_status_id_statement = (!empty($data['filter_order_status'])) ?
                "AND os.order_status_id = '" . (int)$data['filter_order_status'] . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $limit_statement = "";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $sql = "
		SELECT pr.*, os.name AS order_status, po.invoice_prefix AS po_prefix, po.manufacturer_id
		FROM " . DB_PREFIX . "purchase_receive pr
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON pr.order_status_id = os.order_status_id
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pr.purchase_order_id = po.purchase_order_id
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_order_status_id_statement
                $filter_manufacturer_prefix
                $filter_manufactuerer_id    
		AND os.language_id = '" . (int)$language_id . "'
		ORDER BY $sort $order
		$limit_statement
		";

        /*
          echo "<pre>";
          print_r($sql);
          echo "</pre>";
         */

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalPurchaseReceive($data = array()) {
        $language_id = $this->config->get('config_language_id');

        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $sql = "
		SELECT COUNT(*) AS total
		FROM " . DB_PREFIX . "purchase_receive
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function purchaseReceiveExistById($purchase_reveice_id) {
        $sql = "SELECT COUNT(*) AS num FROM " . DB_PREFIX . "purchase_receive WHERE purchase_receive_id = '" . (int)$purchase_reveice_id . "'";
        $query = $this->db->query($sql);

        return $query->row['num'] > 0 ? true : false;
    }

    public function getPurchaseReceiveIdByInvoicePrefix($invoice_prefix) {
        $sql = "
		SELECT purchase_receive_id
		FROM " . DB_PREFIX . "purchase_receive pr
		WHERE 1
		AND pr.invoice_prefix = '" . $this->db->escape($invoice_prefix) . "'
		";

        $query = $this->db->query($sql);
        return (isset($query->row['purchase_receive_id'])) ? $query->row['purchase_receive_id'] : 0;
    }

    public function getPurchaseReceiveItemsArray($purchase_receive_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "purchase_receive_product WHERE purchase_receive_id = '" . (int)$purchase_receive_id . "'";

        $query = $this->db->query($sql);

        $result = array();

        foreach ($query->rows as $item)
            $result[$item['product_id']] = $item['quantity'];

        return $result;
    }

    public function getPurchaseReceiveItems($purchase_receive_id) {
        $language_id = $this->config->get('config_language_id');

        $sql = "
		SELECT 
			prp.*,
			pd.name,
			p.code,
			p.model,
			po.invoice_prefix AS purchase_order_invoice
		FROM " . DB_PREFIX . "purchase_receive_product prp
		LEFT JOIN " . DB_PREFIX . "purchase_receive pr
		ON prp.purchase_receive_id = pr.purchase_receive_id
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON prp.purchase_order_id = po.purchase_order_id
		LEFT JOIN " . DB_PREFIX . "product p
		ON prp.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd
		ON prp.product_id = pd.product_id
		AND pd.language_id = '" . (int)$language_id . "'
		WHERE 1
		AND prp.purchase_receive_id = '" . (int)$purchase_receive_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getPurchaseReceiveTotals($purchase_receive_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "purchase_receive_total WHERE purchase_receive_id = '" . (int)$purchase_receive_id . "' ORDER BY sort_order");

        return $query->rows;
    }
    
    public function getPurchaseReceivebyorder($purchase_order_id) {
        $language_id = $this->config->get('config_language_id');

        $sql = "
		SELECT
			po.*,
			m.name AS manufacturer_name,
			m.code AS manufacturer_code,
			os.name AS status_name,
                        po.invoice_prefix AS purchase_order_prefix
		FROM " . DB_PREFIX . "purchase_order po
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON po.order_status_id = os.order_status_id  
		AND os.language_id = '" . (int)$language_id . "'
        WHERE po.purchase_order_id = '" . (int)$purchase_order_id . "'";
        
        $query = $this->db->query($sql);
        
        return $query->row;
    }

}