<?php
class ModelSalePurchaseOrder extends Model {
    public function addPurchaseOrder($data = array(), $cart = array(), $taxes = array()) {
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/purchase_order', 'store' => $this->session->data['store_id']));

        $store_id = $this->session->data['store_id'];

        $this->load->model('localisation/currency');
        $currency_info = $this->model_localisation_currency->getCurrencyByCode($this->config->get('config_currency'));

        $sql = "
		INSERT INTO " . DB_PREFIX . "purchase_order SET 
			purchase_request_id = '" . (int)$data['purchase_request_id'] . "',
			invoice_prefix = '" . $this->db->escape($invoice_prefix) . "',
			store_id = '" . (int)$store_id . "',
			manufacturer_id = '" . (int)$data['manufacturer_id'] . "',
			total = '" . $this->cart->getTotal() . "',
			subtotal = '" . $this->cart->getSubtotal() . "',
			order_status_id = '" . (int)$data['order_status_id'] . "',
			payment_status_id = '17',
			currency_id = '" . (int)$currency_info['currency_id'] . "',
			currency_code = '" . $currency_info['code'] . "',
			currency_value = '" . (int)$currency_info['value'] . "',
			date_added = NOW(),
			add_by = '" . (int)$this->session->data['user_id'] . "',
			date_modified = NOW(),
			modify_by = '" . (int)$this->session->data['user_id'] . "'
			";

        $query = $this->db->query($sql);

        $purchase_order_id = $this->db->getLastId();

        if ($purchase_order_id != 0) {
            //insert product
            foreach ($cart->getProducts() as $product_id => $product) {
                $sql = "
				INSERT INTO " . DB_PREFIX . "purchase_order_product SET
				purchase_order_id 		= '" . (int)$purchase_order_id . "',
				product_id				= '" . (int)$product_id . "',
				quantity				= '" . (float)$product['quantity'] . "',
				tax_class_id			= '" . (int)$product['tax_class_id'] . "',
				tax_code				= '" . $this->db->escape($product['tax_code']) . "',
				tax_format				= '" . $this->db->escape($product['tax_format']) . "',
				price					= '" . (float)$product['custom_price'] . "',
				net_amount				= '" . (float)$this->db->escape($product['costprice']) . "',
				total_net_amount		= '" . (float)$product['net_amount'] . "',
				total					= '" . (float)$product['total'] . "',
				total_tax				= '" . (float)$product['tax'] . "'
				";

                $this->db->query($sql);
            }

            $this->db->query("DELETE FROM " . DB_PREFIX . "purchase_order_total WHERE purchase_order_id = '" . (int)$purchase_order_id . "' AND id ='1' ");

            if (isset($taxes)) {
                foreach ($taxes as $order_total) {
                    $this->db->query("
					INSERT INTO " . DB_PREFIX . "purchase_order_total 
					SET 
					purchase_order_id = '" . (int)$purchase_order_id . "',
					id ='1', 
					code = '" . $this->db->escape($order_total['code']) . "',
					tax_code = '" . $this->db->escape($order_total['tax_code']) . "', 
					tax_key = '" . (int)$order_total['key'] . "',
					title = '" . $this->db->escape($order_total['title']) . "',  
					`value` = '" . (float)$order_total['value'] . "', 
					sort_order = '" . (int)$order_total['sort_order'] . "'
					");
                }
            }

            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/purchase_order', 'store' => $this->session->data['store_id']));
        }

        return $purchase_order_id;
    }

    public function getPurchaseOrderIdByInvoicePrefix($invoice_prefix) {
        $sql = "
		SELECT purchase_order_id
		FROM " . DB_PREFIX . "purchase_order po
		WHERE 1
		AND po.invoice_prefix = '" . $this->db->escape($invoice_prefix) . "'
		";

        $query = $this->db->query($sql);
        return (isset($query->row['purchase_order_id'])) ? $query->row['purchase_order_id'] : 0;
    }

    public function purchaseOrderExistById($purchase_order_id) {
        $sql = "SELECT COUNT(*) AS num FROM " . DB_PREFIX . "purchase_order WHERE purchase_order_id = '" . (int)$purchase_order_id . "'";
        $query = $this->db->query($sql);

        return $query->row['num'] > 0 ? true : false;
    }

    public function getPurchaseOrderByInvoicePrefix($manufacturer_id, $data = array()) {
        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND pr.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND pr.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $sql = "
		SELECT 
			prmp.product_id,
			prmp.price,
			prp.quantity 
		FROM " . DB_PREFIX . "purchase_request_manufacturer_price prmp
		LEFT JOIN " . DB_PREFIX . "purchase_request pr 
		ON prmp.purchase_request_id = pr.purchase_request_id
		LEFT JOIN " . DB_PREFIX . "purchase_request_product prp
		ON prmp.product_id = prp.product_id 
		AND prmp.purchase_request_id = prp.purchase_request_id 
		LEFT JOIN " . DB_PREFIX . "purchase_request_manufacturer prm
		ON prmp.purchase_request_id = prm.purchase_request_id  
		AND prmp.manufacturer_id = prm.manufacturer_id
		WHERE 1
		AND prm.status = '5'
		AND prmp.manufacturer_id = '" . (int)$manufacturer_id . "'
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function editPurchaseOrder($purchase_order_id, $data = array(), $cart = array(), $taxes = array()) {
        if ($cart->getProducts()) {
            $sql = "
			DELETE FROM " . DB_PREFIX . "purchase_order_product WHERE purchase_order_id = '" . (int)$purchase_order_id . "'
			";

            $query = $this->db->query($sql);

            foreach ($cart->getProducts() as $product_id => $product) {
                $sql = "
				INSERT INTO " . DB_PREFIX . "purchase_order_product SET
				purchase_order_id 	= '" . (int)$purchase_order_id . "',
				product_id			= '" . (int)$product_id . "',
				quantity			= '" . (float)$product['quantity'] . "',
				tax_class_id		= '" . (int)$product['tax_class_id'] . "',
				tax_code			= '" . $this->db->escape($product['tax_code']) . "',
				tax_format			= '" . $this->db->escape($product['tax_format']) . "',
				price				= '" . (float)$product['custom_price'] . "',
				net_amount			= '" . (float)$this->db->escape($product['costprice']) . "',
				total_net_amount	= '" . (float)$product['net_amount'] . "',
				total				= '" . (float)$product['total'] . "',
				total_tax			= '" . (float)$product['tax'] . "'				
				";

                $this->db->query($sql);
            }

            $this->load->model('localisation/currency');
            $currency_info = $this->model_localisation_currency->getCurrencyByCode($this->config->get('config_currency'));

            $sql = "
			UPDATE " . DB_PREFIX . "purchase_order SET
				order_status_id = '" . (int)$data['order_status_id'] . "',
				total = '" . (float)$cart->getTotal() . "',
				currency_code = '" . (int)$currency_info['code'] . "',
				currency_value = '" . (int)$currency_info['value'] . "',
				modify_by = '" . (int)$this->session->data['user_id'] . "', 
				date_modified = NOW()
			WHERE purchase_order_id = '" . (int)$purchase_order_id . "'";

            $this->db->query($sql);

            $this->db->query("DELETE FROM " . DB_PREFIX . "purchase_order_total WHERE purchase_order_id = '" . (int)$purchase_order_id . "' AND id ='1' ");

            if (isset($taxes)) {
                foreach ($taxes as $order_total) {
                    $this->db->query("
					INSERT INTO " . DB_PREFIX . "purchase_order_total 
					SET 
					purchase_order_id = '" . (int)$purchase_order_id . "',
					id ='1', 
					code = '" . $this->db->escape($order_total['code']) . "',
					tax_code = '" . $this->db->escape($order_total['tax_code']) . "', 
					tax_key = '" . (int)$order_total['key'] . "',
					title = '" . $this->db->escape($order_total['title']) . "',  
					`value` = '" . (float)$order_total['value'] . "', 
					sort_order = '" . (int)$order_total['sort_order'] . "'
					");
                }
            }
        }
    }

    public function getReceiveProducts($purchase_order_id) {
        $sql = "SELECT 
					prp.product_id, 
					SUM(prp.quantity) as quantity 
				FROM " . DB_PREFIX . "purchase_receive_product prp 
				LEFT JOIN " . DB_PREFIX . "purchase_receive pr
				ON prp.purchase_receive_id = pr.purchase_receive_id
				WHERE pr.purchase_order_id = '" . (int)$purchase_order_id . "' 
				AND pr.order_status_id = '5'
				GROUP BY prp.product_id";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getAllPurchaseReceive($purchase_order_id, $data = array()) {
        $sort = isset($data['sort']) ? $data['sort'] : "invoice_prefix";
        $order = isset($data['order']) ? $data['order'] : "DESC";

        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $limit_statement = "";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "purchase_receive 
		WHERE purchase_order_id = '" . (int)$purchase_order_id . "' 
		AND order_status_id = '5'
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		ORDER BY $sort $order
		$limit_statement";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalPurchaseReceive($purchase_order_id, $data = array()) {
        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $sql = "SELECT COUNT(*) as total
				FROM " . DB_PREFIX . "purchase_receive 
				WHERE purchase_order_id = '" . (int)$purchase_order_id . "' 
				AND order_status_id = '5'
				$filter_transaction_start_statement
				$filter_transaction_end_statement";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getAllPurchaseInvoice($purchase_order_id, $data = array()) {
        $sort = isset($data['sort']) ? $data['sort'] : "invoice_prefix";
        $order = isset($data['order']) ? $data['order'] : "DESC";

        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $limit_statement = "";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $sql = "
		SELECT 
			pi.*
		FROM " . DB_PREFIX . "purchase_invoice pi
		WHERE pi.purchase_order_id = '" . (int)$purchase_order_id . "' 
		AND pi.order_status_id = '5'
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		ORDER BY $sort $order
		$limit_statement";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalPurchaseInvoice($purchase_order_id, $data = array()) {
        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $sql = "
		SELECT 
			COUNT(*) AS total
		FROM " . DB_PREFIX . "purchase_invoice pi
		WHERE pi.purchase_order_id = '" . (int)$purchase_order_id . "' 
		AND pi.order_status_id = '5'
		$filter_transaction_start_statement
		$filter_transaction_end_statement";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function selectPurchaseRequest($manufacturer_id, $purchase_request_id) {

        $sql = "SELECT prmp.product_id,prp.quantity,prmp.price 
				FROM " . DB_PREFIX . "purchase_request_manufacturer_price prmp
				LEFT JOIN " . DB_PREFIX . "purchase_request_product prp
				ON prmp.purchase_request_id = prp.purchase_request_id
				AND prmp.product_id = prp.product_id
				WHERE prmp.manufacturer_id = '" . $manufacturer_id . "' 
				AND prp.purchase_request_id = '" . $purchase_request_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function selectPurchaseRequestByInvoice($manufacturer_id, $invoice) {
        $purchase_request = array();

        $get_id_sql = "
		SELECT
			purchase_request_id
		FROM " . DB_PREFIX . "purchase_request
		WHERE invoice_prefix = '" . $this->db->escape($invoice) . "'
		";

        $get_id_query = $this->db->query($get_id_sql);


        $sql = "
		SELECT 
			prmp.product_id,
			prp.quantity,
			prmp.price 
		FROM " . DB_PREFIX . "purchase_request_manufacturer_price prmp
		LEFT JOIN " . DB_PREFIX . "purchase_request_product prp
		ON prmp.purchase_request_id = prp.purchase_request_id
		AND prmp.product_id = prp.product_id
		LEFT JOIN " . DB_PREFIX . "purchase_request pr
		ON prmp.purchase_request_id = pr.purchase_request_id
		WHERE prmp.manufacturer_id = '" . (int)$manufacturer_id . "' 
		AND pr.invoice_prefix = '" . $this->db->escape($invoice) . "'";

        $query = $this->db->query($sql);

        $purchase_request = array(
            'purchase_request_id' => $get_id_query->row['purchase_request_id'],
            'products' => $query->rows
        );

        return $purchase_request;
    }

    public function getPurchaseOrder($purchase_order_id) {
        $language_id = $this->config->get('config_language_id');

        $sql = "
		SELECT 
			po.*,
			os.name AS order_status,
			ps.name AS payment_status,
			m.name AS manufacturer_name,
			m.code AS manufacturer_code,
			pr.invoice_prefix AS purchase_request_invoice
		FROM " . DB_PREFIX . "purchase_order po
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "order_status os
        ON po.order_status_id = os.order_status_id 
		AND os.language_id = '" . (int)$language_id . "' 
		LEFT JOIN " . DB_PREFIX . "order_status ps
        ON po.payment_status_id = ps.order_status_id 
		AND ps.language_id = '" . (int)$language_id . "' 
		LEFT JOIN " . DB_PREFIX . "purchase_request pr
		ON pr.purchase_request_id = po.purchase_request_id
		WHERE purchase_order_id = '" . (int)$purchase_order_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }
    
    public function getPurchaseOrderbyrequest($purchase_request_id) {
        $language_id = $this->config->get('config_language_id');

        $sql = "
		SELECT
			prm.*,
			m.name AS manufacturer_name,
			m.code AS manufacturer_code,
			os.name AS status_name,
                        pr.invoice_prefix AS purchase_request_prefix
		FROM " . DB_PREFIX . "purchase_request_manufacturer prm
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON prm.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON prm.status = os.order_status_id
                LEFT JOIN " . DB_PREFIX . "purchase_request pr
                ON prm.purchase_request_id = pr.purchase_request_id    
		AND os.language_id = '" . (int)$language_id . "'
        WHERE prm.purchase_request_id = '" . (int)$purchase_request_id . "'";
        
        $query = $this->db->query($sql);
        
        return $query->row;
    }

    public function getPurchaseOrders($data = array()) {
        $language_id = $this->config->get('config_language_id');

        $sort = isset($data['sort']) ? $data['sort'] : "purchase_order_id";
        $order = isset($data['order']) ? $data['order'] : "DESC";

        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $filter_manufacturer_id_statement = (!empty($data['filter_manufacturer_id'])) ?
                "AND po.manufacturer_id = '" . $this->db->escape($data['filter_manufacturer_id']) . "'" :
                "";
        
        $filter_manufacturer_prefix = (!empty($data['filter_transaction'])) ?
                "AND po.invoice_prefix LIKE '%" . $this->db->escape($data['filter_transaction']) . "%'" :
                "";

        $filter_order_status_id_statement = (!empty($data['filter_order_status'])) ?
                "AND po.order_status_id = '" . (int)$data['filter_order_status'] . "'" :
                "";

        $filter_payment_status_id_statement = (!empty($data['filter_payment_status'])) ?
                "AND po.payment_status_id = '" . (int)$data['filter_payment_status'] . "'" :
                "";

        $filter_not_payment_status_id_statement = (!empty($data['filter_not_payment_status'])) ?
                "AND po.payment_status_id != '" . (int)$data['filter_not_payment_status'] . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $limit_statement = "";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $sql = "
		SELECT
			po.*, 
			os.name AS order_status,
			ps.name AS payment_status,
			m.name AS manufacturer_name,
			m.code AS manufacturer_code,
                        pre.purchase_receive_id AS purchase_receive_id,
                        pi.purchase_invoice_id AS purchase_invoice_id
		FROM " . DB_PREFIX . "purchase_order po
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON po.order_status_id = os.order_status_id
		AND os.language_id = '" . (int)$language_id . "'
		LEFT JOIN " . DB_PREFIX . "order_status ps
		ON po.payment_status_id = ps.order_status_id
		AND ps.language_id = '" . (int)$language_id . "'
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON po.manufacturer_id = m.manufacturer_id
                LEFT JOIN " . DB_PREFIX . "purchase_receive pre
                ON po.purchase_order_id = pre.purchase_order_id   
                LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
                ON po.purchase_order_id = pi.purchase_order_id    
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_manufacturer_id_statement
		$filter_order_status_id_statement
		$filter_payment_status_id_statement
		$filter_not_payment_status_id_statement
                $filter_manufacturer_prefix    
		ORDER BY $sort $order
		$limit_statement
		";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalPurchaseOrder($data = array()) {
        $language_id = $this->config->get('config_language_id');

        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $filter_manufacturer_id_statement = (!empty($data['filter_manufacturer_id'])) ?
                "AND manufacturer_id = '" . $this->db->escape($data['filter_manufacturer_id']) . "'" :
                "";

        $filter_order_status_id_statement = (!empty($data['filter_order_status'])) ?
                "AND order_status_id = '" . (int)$data['filter_order_status'] . "'" :
                "";

        $filter_payment_status_id_statement = (!empty($data['filter_payment_status'])) ?
                "AND payment_status_id = '" . (int)$data['filter_payment_status'] . "'" :
                "";

        $sql = "
		SELECT COUNT(*) AS total
		FROM " . DB_PREFIX . "purchase_order
		WHERE 1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_manufacturer_id_statement
		$filter_order_status_id_statement
		$filter_payment_status_id_statement";


        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getPurchaseOrderItemsArray($purchase_order_id) {
        $sql = "
		SELECT
			product_id,
			quantity,
			price
		FROM " . DB_PREFIX . "purchase_order_product
		WHERE 1
		AND purchase_order_id = '" . (int)$purchase_order_id . "'";

        $query = $this->db->query($sql);

        $result = array();

        foreach ($query->rows as $item)
            $result[$item['product_id']] = array(
                'quantity' => $item['quantity'],
                'product_id' => $item['product_id'],
                'price' => $item['price']
            );

        return $result;
    }

    public function getPurchaseOrderItems($purchase_order_id) {
        $sql = "
				SELECT pop.quantity, pd.name, p.code FROM " . DB_PREFIX . "purchase_order_product pop
				LEFT JOIN " . DB_PREFIX . "product p
				ON p.product_id = pop.product_id
				LEFT JOIN " . DB_PREFIX . "product_description pd
				ON pd.product_id = pop.product_id
				WHERE pop.purchase_order_id = '" . (int)$purchase_order_id . "'
				AND pd.language_id = '" . $this->config->get('config_language_id') . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getPurchaseOrderTotals($purchase_order_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "purchase_order_total WHERE purchase_order_id = '" . (int)$purchase_order_id . "' ORDER BY sort_order");

        return $query->rows;
    }
}
?>