<?php
class ModelSalePurchaseInvoice extends Model {
    public function get_all_import_product() {
        $sql = $this->db->query("
			SELECT
					p.product_id,
					p.code,
					p.name,
					p.stock,
					p.price
				FROM
					`oc_import_product` p
				WHERE
					1
		");
        return $sql->rows;
    }

    public function check_product_exists($data) {
        $sql = $this->db->query("
			SELECT
					COUNT(*) AS total
				FROM
					`oc_product` p
				WHERE
					1
					AND p.product_id = '" . (int)$data['product_id'] . "'
					AND p.code       = '" . $this->db->escape($data['code']) . "'
		");
        return $sql->row['total'];
    }

    public function add_purchase_invoice($data = array(), $cart = array(), $taxes = array()) {
        $store_id = $this->session->data['store_id'];
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/purchase_invoice', 'store' => $store_id));
        $this->load->model('localisation/currency');
        $currency_info = $this->model_localisation_currency->getCurrencyByCode($this->config->get('config_currency'));

        $sql = "
		INSERT INTO " . DB_PREFIX . "purchase_invoice SET
			invoice_prefix = '" . $this->db->escape($invoice_prefix) . "',
			purchase_order_id = '" . (int)$data['purchase_order_id'] . "',
			supplier_invoice = '" . $this->db->escape($data['supplier_invoice']) . "',
			invoice_remark = '" . $this->db->escape($data['invoice_remark']) . "',
			store_id = '" . (int)0 . "',
			manufacturer_id = '" . (int)1 . "',
			comment = '" . $this->db->escape($data['comment']) . "',
			payment_method = '" . $this->db->escape($data['payment_method']) . "',
			payment_code = '" . $this->db->escape($data['payment_method']) . "',
			total = '" . (float)$cart->getTotal() . "',
			order_status_id = '" . (int)$data['order_status_id'] . "',
			currency_id = '" . (int)$currency_info['currency_id'] . "',
			currency_code = '" . $currency_info['code'] . "',
			currency_value = '" . (int)$currency_info['value'] . "',
			type = '" . (int)$cart->getImportType() . "',
			stock_affect = '" . (isset($data['stock_affect']) ? 1 : 0) . "',
			date_added = '" . date('Y-m-d', strtotime($data['date_added'])) . "',
			add_by = '" . (int)$this->session->data['user_id'] . "',
			date_modified = NOW(),
			modify_by = '" . (int)$this->session->data['user_id'] . "'
		";

        $query = $this->db->query($sql);
        $purchase_invoice_id = $this->db->getLastId();
        if ($purchase_invoice_id) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/purchase_invoice', 'store' => $store_id));
            if ($cart->getProducts()) {
                foreach ($cart->getProducts() as $product_id => $product) {
                    $product_id = ($product['is_custom']) ? 0 : $product_id;
                    $sql = "
					INSERT INTO " . DB_PREFIX . "purchase_invoice_product SET
					purchase_invoice_id = '" . (int)$purchase_invoice_id . "',
					product_id			= '" . (int)$product_id . "',
					name				= '" . $this->db->escape($product['name']) . "',
					code				= '" . $this->db->escape($product['code']) . "',
					transaction_no		= '" . $this->db->escape($product['transaction_no']) . "',
					quantity			= '" . (float)$product['quantity'] . "',
					tax_class_id		= '" . (int)$product['tax_class_id'] . "',
					tax_code			= '" . $this->db->escape($product['tax_code']) . "',
					tax_format			= '" . $this->db->escape($product['tax_format']) . "',
					price				= '" . (float)$product['custom_price'] . "',
					net_amount			= '" . (float)$this->db->escape($product['custom_price']) . "',
					total_net_amount	= '" . (float)$product['net_amount'] . "',
					total				= '" . (float)$product['total'] . "',
					total_tax			= '" . (float)$product['tax'] . "'
					";
                    $this->db->query($sql);
                }
            }

            if (isset($taxes)) {
                foreach ($taxes as $order_total) {
                    $this->db->query("
					INSERT INTO " . DB_PREFIX . "purchase_invoice_total
					SET
					purchase_invoice_id = '" . (int)$purchase_invoice_id . "',
					id ='1',
					code = '" . $this->db->escape($order_total['code']) . "',
					tax_code = '" . $this->db->escape($order_total['tax_code']) . "',
					tax_key = '" . (int)$order_total['key'] . "',
					title = '" . $this->db->escape($order_total['title']) . "',
					`value` = '" . (float)$order_total['value'] . "',
					sort_order = '" . (int)$order_total['sort_order'] . "'
					");
                }
            }

            $this->completePurchaseInvoiceStockControl($store_id, $data, $cart);
        }
    }

    public function addPurchaseInvoice($data = array(), $cart = array(), $taxes = array()) {
        $store_id = $this->session->data['store_id'];

        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/purchase_invoice', 'store' => $store_id));

        $this->load->model('localisation/currency');

        $currency_info = $this->model_localisation_currency->getCurrencyByCode($this->config->get('config_currency'));

        $sql = "
		INSERT INTO " . DB_PREFIX . "purchase_invoice SET
			invoice_prefix = '" . $this->db->escape($invoice_prefix) . "',
			purchase_order_id = '" . (int)$data['purchase_order_id'] . "',
			supplier_invoice = '" . $this->db->escape($data['supplier_invoice']) . "',
			invoice_remark = '" . $this->db->escape($data['invoice_remark']) . "',
			store_id = '" . (int)$store_id . "',
			manufacturer_id = '" . (int)$data['manufacturer_id'] . "',
			comment = '" . $this->db->escape($data['comment']) . "',
			payment_method = '" . $this->db->escape($data['payment_method']) . "',
			payment_code = '" . $this->db->escape($data['payment_method']) . "',
			total = '" . (float)$cart->getTotal() . "',
			order_status_id = '" . (int)$data['order_status_id'] . "',
			currency_id = '" . (int)$currency_info['currency_id'] . "',
			currency_code = '" . $currency_info['code'] . "',
			currency_value = '" . (int)$currency_info['value'] . "',
			type = '" . (int)$cart->getImportType() . "',
			stock_affect = '" . (isset($data['stock_affect']) ? 1 : 0) . "',
			date_added = '" . date('Y-m-d', strtotime($data['date_added'])) . "',
			add_by = '" . (int)$this->session->data['user_id'] . "',
			date_modified = NOW(),
			modify_by = '" . (int)$this->session->data['user_id'] . "'
		";

        $query = $this->db->query($sql);

        $purchase_invoice_id = $this->db->getLastId();

        if ($purchase_invoice_id) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/purchase_invoice', 'store' => $store_id));

            if ($cart->getProducts()) {
                foreach ($cart->getProducts() as $product_id => $product) {
                    $product_id = ($product['is_custom']) ? 0 : $product_id;

                    $sql = "
					INSERT INTO " . DB_PREFIX . "purchase_invoice_product SET
					purchase_invoice_id = '" . (int)$purchase_invoice_id . "',
					product_id			= '" . (int)$product_id . "',
					name				= '" . $this->db->escape($product['name']) . "',
					code				= '" . $this->db->escape($product['code']) . "',
					transaction_no		= '" . $this->db->escape($product['transaction_no']) . "',
					quantity			= '" . (float)$product['quantity'] . "',
					tax_class_id		= '" . (int)$product['tax_class_id'] . "',
					tax_code			= '" . $this->db->escape($product['tax_code']) . "',
					tax_format			= '" . $this->db->escape($product['tax_format']) . "',
					price				= '" . (float)$product['custom_price'] . "',
					net_amount			= '" . (float)$this->db->escape($product['custom_price']) . "',
					total_net_amount	= '" . (float)$product['net_amount'] . "',
					total				= '" . (float)$product['total'] . "',
					total_tax			= '" . (float)$product['tax'] . "'
					";

                    $this->db->query($sql);
                }
            }

            if (isset($taxes)) {
                foreach ($taxes as $order_total) {
                    $this->db->query("
					INSERT INTO " . DB_PREFIX . "purchase_invoice_total
					SET
					purchase_invoice_id = '" . (int)$purchase_invoice_id . "',
					id ='1',
					code = '" . $this->db->escape($order_total['code']) . "',
					tax_code = '" . $this->db->escape($order_total['tax_code']) . "',
					tax_key = '" . (int)$order_total['key'] . "',
					title = '" . $this->db->escape($order_total['title']) . "',
					`value` = '" . (float)$order_total['value'] . "',
					sort_order = '" . (int)$order_total['sort_order'] . "'
					");
                }
            }

            $this->completePurchaseInvoiceStockControl($store_id, $data, $cart);
        }
    }

    public function editPurchaseInvoice($purchase_invoice_id, $data = array(), $cart = array(), $taxes = array()) {
        $store_id = $this->session->data['store_id'];

        $sql = "
		UPDATE " . DB_PREFIX . "purchase_invoice SET
			supplier_invoice = '" . $this->db->escape($data['supplier_invoice']) . "',
			invoice_remark = '" . $this->db->escape($data['invoice_remark']) . "',
			manufacturer_id = '" . (int)$data['manufacturer_id'] . "',
			purchase_order_id = '" . (int)$data['purchase_order_id'] . "',
			comment = '" . $this->db->escape($data['comment']) . "',
			payment_method = '" . $this->db->escape($data['payment_method']) . "',
			payment_code = '" . $this->db->escape($data['payment_method']) . "',
			total = '" . (float)$cart->getTotal() . "',
			order_status_id = '" . (int)$data['order_status_id'] . "',
			type = '" . (int)$cart->getImportType() . "',
			stock_affect = '" . (isset($data['stock_affect']) ? 1 : 0) . "',
			date_added = '" . date('Y-m-d', strtotime($data['date_added'])) . "',
			date_modified = NOW(),
			modify_by = '" . (int)$this->session->data['user_id'] . "'
		WHERE purchase_invoice_id = '" . (int)$purchase_invoice_id . "'
		";

        $query = $this->db->query($sql);

        $sql = "
		DELETE FROM " . DB_PREFIX . "purchase_invoice_product
		WHERE purchase_invoice_id = '" . (int)$purchase_invoice_id . "'
		";

        $query = $this->db->query($sql);

        if ($cart->getProducts()) {
            foreach ($cart->getProducts() as $product_id => $product) {
                $sql = "
				INSERT INTO " . DB_PREFIX . "purchase_invoice_product SET
				purchase_invoice_id = '" . (int)$purchase_invoice_id . "',
				product_id			= '" . (int)$product_id . "',
				name				= '" . $this->db->escape($product['name']) . "',
				code				= '" . $this->db->escape($product['code']) . "',
				transaction_no		= '" . $this->db->escape($product['transaction_no']) . "',
				quantity			= '" . (float)$product['quantity'] . "',
				tax_class_id		= '" . (int)$product['tax_class_id'] . "',
				tax_code			= '" . $this->db->escape($product['tax_code']) . "',
				tax_format			= '" . $this->db->escape($product['tax_format']) . "',
				price				= '" . (float)$product['custom_price'] . "',
				net_amount			= '" . (float)$this->db->escape($product['custom_price']) . "',
				total_net_amount	= '" . (float)$product['net_amount'] . "',
				total				= '" . (float)$product['total'] . "',
				total_tax			= '" . (float)$product['tax'] . "'
				";

                $this->db->query($sql);
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "purchase_invoice_total WHERE purchase_invoice_id = '" . (int)$purchase_invoice_id . "' AND id ='1' ");

        if (isset($taxes)) {
            foreach ($taxes as $order_total) {
                $this->db->query("
				INSERT INTO " . DB_PREFIX . "purchase_invoice_total
				SET
				purchase_invoice_id = '" . (int)$purchase_invoice_id . "',
				id ='1',
				code = '" . $this->db->escape($order_total['code']) . "',
				tax_code = '" . $this->db->escape($order_total['tax_code']) . "',
				tax_key = '" . (int)$order_total['key'] . "',
				title = '" . $this->db->escape($order_total['title']) . "',
				`value` = '" . (float)$order_total['value'] . "',
				sort_order = '" . (int)$order_total['sort_order'] . "'
				");
            }
        }

        $this->completePurchaseInvoiceStockControl($store_id, $data, $cart);
    }

    private function completePurchaseInvoiceStockControl($store_id, $data, $cart) {
        if ((int)$data['order_status_id'] == 5) {//if complate
            switch ((int)$cart->getImportType()) {
                case 1:
                    $have_pr = false;
                    $have_pr_sql = "
					SELECT COUNT(*) AS have_pr
					FROM " . DB_PREFIX . "purchase_receive pr
					WHERE pr.purchase_order_id = '" . (int)$data['purchase_order_id'] . "'
					";

                    $have_pr_query = $this->db->query($have_pr_sql);
                    $have_pr = ($have_pr_query->row['have_pr'] > 0) ? true : false;

                    // if purchaser order no have purchase receive, create purchase receive, increase stock
                    if (!$have_pr) {
                        $purchase_receive = array();

                        foreach ($cart->getProducts() as $product_id => $product) {
                            $product_id = ($product['is_custom']) ? 0 : $product_id;

                            if ($product_id) {
                                $purchase_receive[$product_id] = array(
                                    'quantity' => $product['quantity'],
                                    'purchase_order_id' => $product['transaction_no'] != '' ? (int)$data['purchase_order_id'] : 0
                                );
                            }
                        }

                        if ($purchase_receive) {
                            $purchase_receive_invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/purchase_receive', 'store' => $this->session->data['store_id']));

                            $sql = "
							INSERT INTO " . DB_PREFIX . "purchase_receive SET
								invoice_prefix = '" . $this->db->escape($purchase_receive_invoice_prefix) . "',
								purchase_order_id = '" . (int)$data['purchase_order_id'] . "',
								store_id = '" . (int)$store_id . "',
								comment = 'Import from purchase invoice.',
								order_status_id = '5',
								date_added = NOW(),
								add_by = " . (int)$this->session->data['user_id'] . "
							";

                            $query = $this->db->query($sql);

                            $purchase_receive_id = $this->db->getLastId();

                            if ($purchase_receive_id != 0) {
                                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/purchase_receive', 'store' => $this->session->data['store_id']));

                                foreach ($purchase_receive as $product_id => $product) {
                                    $purchase_order_id = isset($product['purchase_order']) ? $data['purchase_order_id'] : 0;

                                    $sql = "
								  INSERT INTO " . DB_PREFIX . "purchase_receive_product SET
								  purchase_receive_id = '" . (int)$purchase_receive_id . "',
								  purchase_order_id = '" . (int)$product['purchase_order_id'] . "',
								  product_id = '" . (int)$product_id . "',
								  quantity = '" . $product['quantity'] . "'
								  ";

                                    $query = $this->db->query($sql);

                                    $this->db->query("
								  UPDATE " . DB_PREFIX . "product_to_store SET
									  onhand_quantity = onhand_quantity + " . $product['quantity'] . "
								  WHERE 1
								  AND product_id = '" . (int)$product_id . "'
								  AND store_id = '" . (int)$store_id . "'
								  ");
                                }
                            }
                        }
                    }

                    //update purchase order payment status
                    if ($this->getTotalMaxProduct($data['purchase_order_id']) == $this->getTotalPaidProduct($data['purchase_order_id'])) {//if all already paid
                        $this->db->query("
						UPDATE " . DB_PREFIX . "purchase_order SET
							payment_status_id = '5'
						WHERE purchase_order_id = '" . (int)$data['purchase_order_id'] . "'
						");
                    } else {
                        $this->db->query("
						UPDATE " . DB_PREFIX . "purchase_order SET
							payment_status_id = '2'
						WHERE purchase_order_id = '" . (int)$data['purchase_order_id'] . "'
						");
                    }
                    break;
				case 3:
					
				case 5:

				case 6:
                    if (isset($data['stock_affect'])) {
                        foreach ($cart->getProducts() as $product_id => $product) {
                            $product_id = ($product['is_custom']) ? 0 : $product_id;

                            if ($product_id) {
                                $this->db->query("
								UPDATE " . DB_PREFIX . "product_to_store SET
									onhand_quantity = onhand_quantity + " . (float)$product['quantity'] . "
								WHERE 1
								AND product_id = '" . (int)$product_id . "'
								AND store_id = '" . (int)$store_id . "'
								");
                            }
                        }
                    }
                    break;
            }
        }
    }

    public function getPurchaseInvoice($purchase_invoice_id) {
        $language_id = $this->config->get('config_language_id');

        $sql = "
		SELECT
			pi.*,
			(SELECT invoice_prefix FROM " . DB_PREFIX . "purchase_order WHERE purchase_order_id = pi.purchase_order_id) AS purchase_order_invoice,
			m.name AS manufacturer_name,
			m.code AS manufacturer_code,
			os.name AS order_status,
			m.address_1,
			m.address_2,
			m.address_3,
			m.city,
			m.postcode,
			c.name AS country,
			z.name AS zone,
			m.telephone1,
			m.company_reg_no,
			m.gst_reg_no
		FROM " . DB_PREFIX . "purchase_invoice pi
		LEFT JOIN " . DB_PREFIX . "manufacturer m
		ON pi.manufacturer_id = m.manufacturer_id
		LEFT JOIN " . DB_PREFIX . "country c
		ON m.country_id = c.country_id
		LEFT JOIN " . DB_PREFIX . "zone z
		ON m.zone_id = z.zone_id
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON pi.order_status_id = os.order_status_id
		AND os.language_id = '" . $language_id . "'
		WHERE purchase_invoice_id = '" . (int)$purchase_invoice_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getPurchaseInvoices($data = array()) {
        $language_id = $this->config->get('config_language_id');

        $sort = isset($data['sort']) ? $data['sort'] : "purchase_invoice_id";
        $order = isset($data['order']) ? $data['order'] : "DESC";

        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $filter_order_status_id_statement = (!empty($data['filter_order_status'])) ?
                "AND os.order_status_id = '" . (int)$data['filter_order_status'] . "'" :
                "";

        $filter_search_statement = '';
        if (!empty($data['search'])) {
            $filter_search_statement = "AND (po.invoice_prefix LIKE '%" . $this->db->escape($data['search']) . "%'
			OR po.supplier_invoice LIKE '%" . $this->db->escape($data['search']) . "%'
			OR po.invoice_remark LIKE '%" . $this->db->escape($data['search']) . "%'
			OR po.total LIKE '%" . $this->db->escape($data['search']) . "%'
			OR po.date_added LIKE '%" . $this->db->escape($data['search']) . "%'
			OR m.name LIKE '%" . $this->db->escape($data['search']) . "%'
			)";
        }

        $limit_statement = "";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $sql = "
		SELECT 
				po.*, 
				m.name AS supplier_name,
				os.name AS order_status
			FROM 
				`oc_purchase_invoice` po
					LEFT JOIN 
						`oc_order_status` os
								ON po.order_status_id = os.order_status_id
					LEFT JOIN 
						`oc_manufacturer` m
								ON po.manufacturer_id = m.manufacturer_id
			WHERE 
				1
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_order_status_id_statement
		$filter_search_statement
		AND os.language_id = '" . (int)$language_id . "'
		ORDER BY $sort $order
		$limit_statement
		";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalPurchaseInvoice($data = array()) {
        $language_id = $this->config->get('config_language_id');

        $sort = isset($data['sort']) ? $data['sort'] : "purchase_invoice_id";
        $order = isset($data['order']) ? $data['order'] : "DESC";

        $filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ?
                "AND po.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" :
                "";

        $filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ?
                "AND po.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" :
                "";

        $filter_order_status_id_statement = (!empty($data['filter_order_status'])) ?
                "AND os.order_status_id = '" . (int)$data['filter_order_status'] . "'" :
                "";

        $filter_search_statement = '';
        if (!empty($data['search'])) {
            $filter_search_statement = "AND (po.invoice_prefix LIKE '%" . $this->db->escape($data['search']) . "%'
			OR po.supplier_invoice LIKE '%" . $this->db->escape($data['search']) . "%'
			OR po.invoice_remark LIKE '%" . $this->db->escape($data['search']) . "%'
			OR po.total LIKE '%" . $this->db->escape($data['search']) . "%'
			OR po.date_added LIKE '%" . $this->db->escape($data['search']) . "%'
			OR m.name LIKE '%" . $this->db->escape($data['search']) . "%'
			)";
        }

        $sql = "
			SELECT 
					COUNT(*) AS total
					FROM 
					`oc_purchase_invoice` po
						LEFT JOIN 
							`oc_order_status` os
									ON po.order_status_id = os.order_status_id
						LEFT JOIN 
							`oc_manufacturer` m
									ON po.manufacturer_id = m.manufacturer_id
				WHERE 
					1
			$filter_transaction_start_statement
			$filter_transaction_end_statement
			$filter_order_status_id_statement
			$filter_search_statement
			AND os.language_id = '" . (int)$language_id . "'
			ORDER BY $sort $order
		";

        $query = $this->db->query($sql);
        return $query->row['total'];
    }

    public function getPurchaseOrderItem($purchase_order_id) {
        $item = array();

        $sql = "
		SELECT COUNT(*) AS total_pr
		FROM " . DB_PREFIX . "purchase_receive pr
		WHERE 1
		AND pr.purchase_order_id = '" . $purchase_order_id . "'
		AND pr.order_status_id = '5'";

        $query = $this->db->query($sql);
        $total_pr = $query->row['total_pr'];

        if ($total_pr > 0) {
            $sql = "
			SELECT
				prp.product_id,
				SUM(prp.quantity)
				-
				COALESCE((
					SELECT SUM(pid.quantity) AS quantity
					FROM " . DB_PREFIX . "purchase_invoice_product pid
					LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
					ON pid.purchase_invoice_id = pi.purchase_invoice_id
					WHERE 1
					AND pi.order_status_id = '5'
					AND pi.purchase_order_id > 0
					AND pi.purchase_order_id = '" . (int)$purchase_order_id . "'
					AND pid.product_id = prp.product_id
				), 0) AS quantity
				,
				" . (int)$purchase_order_id . " AS purchase_order_id,
				po.invoice_prefix AS invoice_prefix,
				p.costprice AS price
			FROM " . DB_PREFIX . "purchase_receive_product prp
			LEFT JOIN " . DB_PREFIX . "purchase_receive pr
			ON prp.purchase_receive_id = pr.purchase_receive_id
			LEFT JOIN " . DB_PREFIX . "purchase_order po
			ON pr.purchase_order_id = po.purchase_order_id
			LEFT JOIN " . DB_PREFIX . "product p
			ON prp.product_id = p.product_id
			WHERE 1
			AND pr.purchase_order_id = '" . (int)$purchase_order_id . "'
			AND pr.purchase_order_id != 0
			AND pr.order_status_id = '5'
			GROUP BY prp.product_id
			UNION ALL
			SELECT
				prp.product_id,
				SUM(prp.quantity)
				-
				COALESCE((
					SELECT SUM(pid.quantity) AS quantity
					FROM " . DB_PREFIX . "purchase_invoice_product pid
					LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
					ON pid.purchase_invoice_id = pi.purchase_invoice_id
					WHERE 1
					AND pi.order_status_id = '5'
					AND pi.purchase_order_id > 0
					AND pi.purchase_order_id = '" . (int)$purchase_order_id . "'
					AND pid.product_id = prp.product_id
				), 0) AS quantity
				,
				0 AS purchase_order_id,
				'' AS invoice_prefix,
				p.costprice AS price
			FROM " . DB_PREFIX . "purchase_receive_product prp
			LEFT JOIN " . DB_PREFIX . "purchase_receive pr
			ON prp.purchase_receive_id = pr.purchase_receive_id
			LEFT JOIN " . DB_PREFIX . "product p
			ON prp.product_id = p.product_id
			WHERE 1
			AND pr.purchase_order_id = '" . (int)$purchase_order_id . "'
			AND pr.purchase_order_id = 0
			AND pr.order_status_id = '5'
			GROUP BY prp.product_id
			";

            $query = $this->db->query($sql);

            $item = $query->rows;
        } else {
            $sql = "
			SELECT
				pop.product_id,
				pop.quantity,
				po.purchase_order_id,
				po.invoice_prefix,
				pop.price
			FROM " . DB_PREFIX . "purchase_order_product pop
			LEFT JOIN " . DB_PREFIX . "purchase_order po
			ON pop.purchase_order_id = po.purchase_order_id
			WHERE pop.purchase_order_id = '" . (int)$purchase_order_id . "'
			";

            $query = $this->db->query($sql);

            $item = $query->rows;
        }

        return $item;
    }

    public function getPurchaseReceiveItem($purchase_receive_id) {
        $sql = "
		SELECT
			prp.product_id,
			prp.quantity,
			pr.purchase_receive_id,
			pr.invoice_prefix
		FROM " . DB_PREFIX . "purchase_receive_product prp
		LEFT JOIN " . DB_PREFIX . "purchase_receive pr
		ON prp.purchase_receive_id = pr.purchase_receive_id
		WHERE prp.purchase_receive_id = '" . (int)$purchase_receive_id . "'
		";

        $query = $this->db->query($sql);

        $item = $query->rows;

        return $item;
    }

    public function getPurchaseInvoiceItemsArray($purchase_invoice_id) {
        $result = array(
            'product' => array(),
            'custom_product' => array()
        );

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "purchase_invoice_product
		WHERE 1
		AND purchase_invoice_id = '" . (int)$purchase_invoice_id . "'
		";

        $query = $this->db->query($sql);

        foreach ($query->rows as $item) {
            if ($item['product_id']) {
                $result['product'][$item['product_id']] = array(
                    'quantity' => $item['quantity'],
                    'price' => $item['price'],
                    'transaction_no' => $item['transaction_no']
                );
            } else {
                $result['custom_product'][] = array(
                    'name' => $item['name'],
                    'quantity' => $item['quantity'],
                    'price' => $item['price'],
                    'tax_class_id' => $item['tax_class_id'],
                    'total_net_amount' => $item['total_net_amount'],
                    'total_tax' => $item['total_tax'],
                    'total' => $item['total']
                );
            }
        }

        return $result;
    }

    public function getPurchaseInvoiceItems($purchase_invoice_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "purchase_invoice_product WHERE purchase_invoice_id = '" . (int)$purchase_invoice_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getPurchaseInvoiceTotals($purchase_invoice_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "purchase_invoice_total WHERE purchase_invoice_id = '" . (int)$purchase_invoice_id . "' ORDER BY sort_order");

        return $query->rows;
    }

    public function getStorePaymentDetails() {
        
    }

    public function getHerbalRemediesItem($data = array()) {
        $store_id = $this->session->data['store_id'];

        $date_ranges = isset($data['date']) ? $data['date'] : array();

        $transaction_ranges = isset($data['transaction']) ? $data['transaction'] : array();

        $range_statement = '';

        if ($date_ranges || $transaction_ranges) {
            foreach ($date_ranges as $range) {
                $range_statement .= " OR (DATE(o.date_added) >= '" . $range['from'] . "' AND DATE(o.date_added) <= '" . $range['to'] . "')";
            }

            foreach ($transaction_ranges as $range) {
                $range_statement .= " OR (cs.invoice_prefix >= '" . $range['from'] . "' AND cs.invoice_prefix <= '" . $range['to'] . "')";
            }

            $range_statement = substr($range_statement, 3, strlen($range_statement) - 3);

            $range_statement = $range_statement ? '(' . $range_statement . ')' : '';

            $sql = "
			SELECT
				csp.product_id,
				p.costprice,
				SUM(csp.t_weight) as quantity
			FROM " . DB_PREFIX . "clinicalsale_product csp
			LEFT JOIN " . DB_PREFIX . "clinical_sale cs
			ON csp.clinical_sale_id = cs.clinical_sale_id
			LEFT JOIN " . DB_PREFIX . "product p
			ON csp.product_id = p.product_id
			LEFT JOIN " . DB_PREFIX . "order o
			ON cs.order_id = o.order_id
			WHERE $range_statement
			AND o.order_id != '0'
			AND cs.store_id = '" . (int)$store_id . "'
			AND cs.order_action IN(5, 1)
			AND clinicalsale_action = 5
			GROUP BY csp.product_id
			";

            $query = $this->db->query($sql);

            return $query->rows;
        } else {
            return false;
        }
    }

    public function getPosItem($data = array()) {
        $store_id = $this->session->data['store_id'];

        $date_ranges = isset($data['date']) ? $data['date'] : array();

        $transaction_ranges = isset($data['transaction']) ? $data['transaction'] : array();

        $range_statement = '';

        if ($date_ranges || $transaction_ranges) {
            $range_statement = '';

            foreach ($date_ranges as $range) {
                $range_statement .= " OR (DATE(o.date_added) >= '" . $range['from'] . "' AND DATE(o.date_added) <= '" . $range['to'] . "')";
            }

            foreach ($transaction_ranges as $range) {
                $range_statement .= " OR (o.invoice_prefix >= '" . $range['from'] . "' AND o.invoice_prefix <= '" . $range['to'] . "')";
            }

            $range_statement = substr($range_statement, 3, strlen($range_statement) - 3);

            $sql = "
			SELECT
				op.product_id,
				p.costprice,
				SUM(op.quantity) as quantity
			FROM " . DB_PREFIX . "order_product op
			LEFT JOIN " . DB_PREFIX . "order o
			ON op.order_id = o.order_id
			LEFT JOIN " . DB_PREFIX . "product p
			ON op.product_id = p.product_id
			WHERE $range_statement
			AND o.store_id = '" . (int)$store_id . "'
			AND o.order_status_id IN(5, 1)
			GROUP BY op.product_id
			";

            $query = $this->db->query($sql);

            return $query->rows;
        } else {
            return false;
        }
    }

    public function getPosShipping($data = array()) {
        $store_id = $this->session->data['store_id'];

        $date_ranges = isset($data['date']) ? $data['date'] : array();

        $transaction_ranges = isset($data['transaction']) ? $data['transaction'] : array();

        $range_statement = '';

        if ($date_ranges || $transaction_ranges) {
            $range_statement = '';

            foreach ($date_ranges as $range) {
                $range_statement .= " OR (DATE(o.date_added) >= '" . $range['from'] . "' AND DATE(o.date_added) <= '" . $range['to'] . "')";
            }

            foreach ($transaction_ranges as $range) {
                $range_statement .= " OR (o.invoice_prefix >= '" . $range['from'] . "' AND o.invoice_prefix <= '" . $range['to'] . "')";
            }

            $range_statement = substr($range_statement, 3, strlen($range_statement) - 3);

            $sql = "
			SELECT
				CONCAT(st.title, '(', st.cost, ')') AS title,
				st.tax_class_id,
				COUNT(*) AS quantity,
				st.cost AS unit_price,
				SUM(st.tax) AS tax,
				SUM(st.cost) AS subtotal,
				SUM(st.total) AS total
			FROM " . DB_PREFIX . "shipping_transaction st
			LEFT JOIN " . DB_PREFIX . "order o
			ON st.order_id = o.order_id
			WHERE ($range_statement)
			AND o.order_status_id IN(5, 1)
			GROUP BY st.title, st.cost
			";

            $query = $this->db->query($sql);

            return $query->rows;
        } else {
            return false;
        }
    }

    public function getProductCost($product_id) {
        $sql = "SELECT costprice FROM " . DB_PREFIX . "product WHERE product_id='" . (int)$product_id . "'";

        $query = $this->db->query($sql);

        return $query->row['costprice'];
    }

    public function getProductByCode($code) {
        $sql = "SELECT * FROM " . DB_PREFIX . "product WHERE code = '" . $this->db->escape($code) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function purchaseInvoiceExistsById($purchase_invoice_id) {
        $sql = "SELECT COUNT(*) AS num FROM " . DB_PREFIX . "purchase_invoice WHERE 1 AND purchase_invoice_id = '" . (int)$purchase_invoice_id . "'";

        $query = $this->db->query($sql);

        return $query->row['num'] > 0;
    }

    public function getPurchaseInvoiceProducts($purchase_invoice_id) {
        $sql = "
		SELECT
			pip.*
		FROM " . DB_PREFIX . "purchase_invoice_product pip
		WHERE 1
		AND pip.purchase_invoice_id = '" . (int)$purchase_invoice_id . "'
		";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalPurchaseReceiveProducts($purchase_order_id) {
        $total = 0;

        $sql = "
		SELECT
			SUM(prp.quantity) AS total
		FROM " . DB_PREFIX . "purchase_receive_product prp
		LEFT JOIN " . DB_PREFIX . "purchase_receive pr
		ON prp.purchase_receive_id = pr.purchase_receive_id
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pr.purchase_order_id = po.purchase_order_id
		WHERE pr.purchase_order_id = '" . (int)$purchase_order_id . "'
		";

        $query = $this->db->query($sql);

        $total = isset($query->row['total']) ? $query->row['total'] : 0;

        return $total;
    }

    public function getTotalPurchaseOrderProduct($purchase_order_id) {
        $total = 0;

        $sql = "
		SELECT
			SUM(pop.quantity) AS total
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		WHERE po.purchase_order_id = '" . (int)$purchase_order_id . "'
		";

        $query = $this->db->query($sql);

        $total = isset($query->row['total']) ? $query->row['total'] : 0;

        return $total;
    }

    public function getTotalPoruchaseInvoiceProduct($purchase_order_id) {
        $total = 0;

        $sql = "
		SELECT
			SUM(pip.quantity) AS total
		FROM " . DB_PREFIX . "purchase_invoice_product pip
		LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
		ON pip.purchase_invoice_id = pi.purchase_invoice_id
		WHERE pi.purchase_order_id = '" . (int)$purchase_order_id . "'
		";

        $query = $this->db->query($sql);

        $total = isset($query->row['total']) ? $query->row['total'] : 0;

        return $total;
    }

    public function getTotalMaxProduct($purchase_order_id) {
        $sql = "
		SELECT SUM(a.quantity) AS total FROM(
		SELECT
			pop.product_id,
			CASE WHEN
			(
				SELECT
					SUM(prp.quantity) as quantity
				FROM " . DB_PREFIX . "purchase_receive_product prp
				WHERE prp.purchase_order_id = pop.purchase_order_id
				AND prp.product_id = pop.product_id
			) > pop.quantity THEN (
				SELECT
					SUM(prp.quantity) as quantity
				FROM " . DB_PREFIX . "purchase_receive_product prp
				WHERE prp.purchase_order_id = pop.purchase_order_id
				AND prp.product_id = pop.product_id
			) ELSE pop.quantity END AS quantity
		FROM " . DB_PREFIX . "purchase_order_product pop
		WHERE 1
		AND pop.purchase_order_id = '" . (int)$purchase_order_id . "'
		UNION ALL
		SELECT
			prp.product_id,
			SUM(prp.quantity)
		FROM " . DB_PREFIX . "purchase_receive_product prp
		LEFT JOIN " . DB_PREFIX . "purchase_receive pr
		ON prp.purchase_receive_id = pr.purchase_receive_id
		WHERE pr.purchase_order_id = '" . (int)$purchase_order_id . "'
		AND prp.purchase_order_id = 0
		GROUP BY product_id
		)a
		";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getTotalPaidProduct($purchase_order_id) {
        $sql = "
		SELECT
			SUM(pip.quantity) AS total
		FROM oc_purchase_invoice_product pip
		LEFT JOIN oc_purchase_invoice pi
		ON pip.purchase_invoice_id = pi.purchase_invoice_id
		WHERE 1
		AND pi.purchase_order_id = '" . (int)$purchase_order_id . "'
		";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getProductType($product_id) {
        $query = $this->db->query("SELECT pd.product_type FROM `" . DB_PREFIX . "product` pd WHERE product_id = '" . (int)$product_id . "'");

        return $query->row['product_type'];
    }
    
    public function getPurchaseInvoiceByGoodReceive($purchase_receive_id) {
        $language_id = $this->config->get('config_language_id');

        $sql = "
		SELECT
			pre.*,
			os.name AS status_name,
                        pre.invoice_prefix AS purchase_receive_prefix,
                        m.name AS manufacturer_name,
                        m.code AS manufacturer_code,
                        m.manufacturer_id AS manufacturer_id
		FROM " . DB_PREFIX . "purchase_receive pre
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON pre.order_status_id = os.order_status_id 
                LEFT JOIN " . DB_PREFIX . "purchase_order po
                ON pre.purchase_order_id = po.purchase_order_id
                LEFT JOIN " . DB_PREFIX . "manufacturer m
                ON po.manufacturer_id = m.manufacturer_id
		AND os.language_id = '" . (int)$language_id . "'
        WHERE pre.purchase_receive_id = '" . (int)$purchase_receive_id . "'";
        
        $query = $this->db->query($sql);
        
        return $query->row;
    }
    
    public function getPurchaseInvoiceByPurchaseOrder($purchase_order_id) {
        $language_id = $this->config->get('config_language_id');

        $sql = "
		SELECT
			po.*,
			os.name AS status_name,
                        po.invoice_prefix AS purchase_order_prefix,
                        m.name AS manufacturer_name,
                        m.code AS manufacturer_code,
                        m.manufacturer_id AS manufacturer_id
		FROM " . DB_PREFIX . "purchase_order po
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON po.order_status_id = os.order_status_id 
                LEFT JOIN " . DB_PREFIX . "manufacturer m
                ON po.manufacturer_id = m.manufacturer_id    
		AND os.language_id = '" . (int)$language_id . "'
        WHERE po.purchase_order_id = '" . (int)$purchase_order_id . "'";
        
        $query = $this->db->query($sql);
        
        return $query->row;
    }

}

?>