<?php

class ModelSaleExcelImport extends Model {

    public function get_product_by_product_code($product_code) {
        $sql = "SELECT p.product_id, pd.name AS product_name, p.code, p.model, p.price FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON pd.product_id = p.product_id AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE p.code = '" . $this->db->escape($product_code) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_excel_import_order($date_order, $customer_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "order WHERE DATE(date_ordered) = DATE('" . $this->db->escape($date_order) . "') AND customer_id = '" . (int) $customer_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_courier_data_by_name($courier_name) {
        $sql = "SELECT * FROM " . DB_PREFIX . "order_tracking_carriers WHERE name = '" . $this->db->escape($courier_name) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_order_history($order_id, $order_status_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "order_history WHERE order_id = '" . (int) $order_id . "' AND order_status_id = '" . (int) $order_status_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_customer($customer_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int) $customer_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_address($address_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "address WHERE address_id = '" . (int) $address_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_customer_by_telephone($telephone) {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE telephone = '" . $this->db->escape($telephone) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_product($product_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON pd.product_id = p.product_id AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE p.product_id = '" . (int) $product_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_zone_by_name($zone_name) {
        $sql = "SELECT * FROM " . DB_PREFIX . "zone WHERE name = '" . $this->db->escape($zone_name) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_settings() {
        $sql = "SELECT * FROM " . DB_PREFIX . "excel_import_setting";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_setting_by_key($setting_key) {
        $sql = "SELECT * FROM " . DB_PREFIX . "excel_import_setting WHERE setting_key = '" . $this->db->escape($setting_key) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function save_settings($data) {
        foreach ($data as $key => $data_row) {
            $check_sql = "SELECT * FROM " . DB_PREFIX . "excel_import_setting WHERE setting_key = '" . $this->db->escape($key) . "'";

            $check_query = $this->db->query($check_sql);

            $check_row = $check_query->row;

            if (!empty($check_row)) {
                $this->db->query("DELETE FROM " . DB_PREFIX . "excel_import_setting WHERE setting_key = '" . $this->db->escape($key) . "'");
            }

            if (is_array($data_row)) {
                $serialized = 1;
                $serialized_data = serialize($data_row);
            } else {
                $serialized = 0;
                $serialized_data = $data_row;
            }

            $sql = "INSERT INTO " . DB_PREFIX . "excel_import_setting SET setting_key = '" . $this->db->escape($key) . "', value = '" . $this->db->escape($serialized_data) . "', serialized = '" . (int) $serialized . "'";

            $query = $this->db->query($sql);
        }
    }

    public function add_order($data) {
        $sql = "INSERT INTO " . DB_PREFIX . "order SET store_id = '" . (int) $data['store_id'] . "', store_name = '" . $this->db->escape($data['store_name']) . "', store_url = '" . $this->db->escape($data['store_url']) . "', customer_id = '" . (int) $data['customer_id'] . "', customer_group_id = '" . (int) $data['customer_group_id'] . "', firstname = '" . $this->db->escape($data['firstname']) . "', email = '" . $this->db->escape($data['email']) . "', telephone = '" . $this->db->escape($data['telephone']) . "', payment_firstname = '" . $this->db->escape($data['payment_firstname']) . "', payment_address_1 = '" . $this->db->escape($data['payment_address_1']) . "', payment_address_2 = '" . $this->db->escape($data['payment_address_2']) . "', payment_city = '" . $this->db->escape($data['payment_city']) . "', payment_postcode = '" . $this->db->escape($data['payment_postcode']) . "', payment_country = '" . $this->db->escape($data['payment_country']) . "', payment_country_id = '" . (int) $data['payment_country_id'] . "', payment_zone = '" . $this->db->escape($data['payment_zone']) . "', payment_zone_id = '" . (int) $data['payment_zone_id'] . "', payment_method = '" . $this->db->escape($data['payment_method']) . "', payment_code = '" . $this->db->escape($data['payment_code']) . "', shipping_address_id = '" . (int) $data['shipping_address_id'] . "', shipping_firstname = '" . $this->db->escape($data['shipping_firstname']) . "', shipping_address_1 = '" . $this->db->escape($data['shipping_address_1']) . "', shipping_address_2 = '" . $this->db->escape($data['shipping_address_2']) . "', shipping_city = '" . $this->db->escape($data['shipping_city']) . "', shipping_postcode = '" . $this->db->escape($data['shipping_postcode']) . "', shipping_country = '" . $this->db->escape($data['shipping_country']) . "', shipping_country_id = '" . (int) $data['shipping_country_id'] . "', shipping_zone = '" . $this->db->escape($data['shipping_zone']) . "', shipping_zone_id = '" . (int) $data['shipping_zone_id'] . "', shipping_method = '" . $this->db->escape($data['shipping_method']) . "', shipping_code = '" . $this->db->escape($data['shipping_code']) . "', comment = '" . $this->db->escape($data['comment']) . "', total = '" . $data['total'] . "', shipping_total = '" . $data['shipping_total'] . "', order_status_id = '" . (int) $data['order_status_id'] . "', language_id = '" . (int) $data['language_id'] . "', currency_id = '" . (int) $data['currency_id'] . "', currency_code = '" . $this->db->escape($data['currency_code']) . "', currency_value = '" . $data['currency_value'] . "', ip = '" . $this->db->escape($data['ip']) . "', user_agent = '" . $this->db->escape($data['user_agent']) . "', date_ordered = '" . $this->db->escape($data['date_ordered']) . "',
        date_added ='" . $this->db->escape($data['date_ordered']) . "',
        add_by = '" . (int) $this->session->data['user_id'] . "',
        date_modified = NOW(), 
        modifi_by = '" . (int) $this->session->data['user_id'] . "'";

        $query = $this->db->query($sql);

        $order_id = $this->db->getLastId();

        if (!empty($data['order_products'])) {
            foreach ($data['order_products'] as $product) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "order_product SET order_id = '" . (int) $order_id . "', product_id = '" . (int) $product['product_id'] . "', name = '" . $this->db->escape($product['name']) . "',  model = '" . $this->db->escape($product['model']) . "',  quantity = '" . (int) $product['quantity'] . "', tax_class_id = '" . (int) $product['tax_class_id'] . "', weight_class_id = '1', price = '" . $product['price'] . "', net_amount = '" . $product['net_amount'] . "', total_net_amount = '" . $product['total_net_amount'] . "', total = '" . $product['total'] . "', tax = '" . $product['tax'] . "', total_tax = '" . $product['total_tax'] . "'");
            }
        }

        if (!empty($data['order_totals'])) {
            foreach ($data['order_totals'] as $total) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "order_total SET order_id = '" . (int) $order_id . "', code = '" . $this->db->escape($total['code']) . "',  title = '" . $this->db->escape($total['title']) . "',  value = '" . $total['value'] . "', sort_order = '" . (int) $total['sort_order'] . "'");
            }
        }

        return $order_id;
    }

    public function add_order_history($order_id, $order_status_id, $notify, $comment) {
        $sql = "INSERT INTO " . DB_PREFIX . "order_history SET order_id = '" . (int) $order_id . "', order_status_id = '" . (int) $order_status_id . "', notify = '" . (int) $notify . "', comment = '" . $this->db->escape($comment) . "', date_added = NOW()";

        $query = $this->db->query($sql);
    }

    public function update_order_status($order_id, $order_status_id) {
        $sql = "UPDATE " . DB_PREFIX . "order SET order_status_id = '" . (int) $order_status_id . "', date_modified = NOW() WHERE order_id = '" . (int) $order_id . "'";

        $query = $this->db->query($sql);
    }

    public function update_carrier($order_id, $carrier_id, $tracking_number) {
        $sql = "UPDATE " . DB_PREFIX . "order SET carrier_id = '" . (int) $carrier_id . "', tracking_number = '" . $this->db->escape($tracking_number) . "' WHERE order_id = '" . (int) $order_id . "'";

        $query = $this->db->query($sql);
    }

    public function add_customer_address($data) {
        $sql = "INSERT INTO " . DB_PREFIX . "address SET customer_id = '" . (int) $data['customer_id'] . "', firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', company = '" . $this->db->escape($data['company']) . "', address_1 = '" . $this->db->escape($data['address_1']) . "', address_2 = '" . $this->db->escape($data['address_2']) . "', address_3 = '" . $this->db->escape($data['address_3']) . "', city = '" . $this->db->escape($data['city']) . "', postcode = '" . $this->db->escape($data['postcode']) . "', country_id = '" . (int) $data['country_id'] . "', zone_id = '" . (int) $data['zone_id'] . "'";

        $query = $this->db->query($sql);

        $address_id = $this->db->getLastId();

        if ($data['default'] > 0) {
            $this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int) $address_id . "' WHERE customer_id = '" . (int) $data['customer_id'] . "'");
        }

        return $address_id;
    }

}
