<?php
class ModelSaleCustomerPaymentMethod extends Model {

    public function getCustomerPaymentMethodname($customer_payment_method_id) {
		$payment_method_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_payment_method cpm WHERE customer_payment_method_id = '" . (int)$customer_payment_method_id . "'");

		foreach ($query->rows as $result) {
			$payment_method_data[$result['language_id']] = array('payment_method_name' => $result['payment_method_name']);
		}

		return $payment_method_data;
	}
    public function getCustomerPaymentMethod($customer_payment_method_id) {
        
        $sql = "SELECT * FROM " . DB_PREFIX . "customer_payment_method cpm WHERE customer_payment_method_id = '" . (int)$customer_payment_method_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getCustomerPaymentMethods($data) {
        $sql = "SELECT 
         
          cpm.customer_payment_method_id AS customer_payment_method_id,
          cpm.payment_method_name AS payment_method_name,
          cpm.code AS code,
          cpm.sql_accounting_code AS sql_accounting_code,
          cpm.status,
          cpm.sort_order AS sort_order,
          cpm.allow_deleted AS allow_deleted,
          cpm.default,
          cpm.date_added,
          cpm.add_by AS add_by_id,
          cpm.date_modified,
          cpm.modify_by AS modified_by_id,
          CONCAT(u.firstname ,' ',u.lastname) AS add_by
          FROM " . DB_PREFIX . "customer_payment_method cpm 
          LEFT JOIN " . DB_PREFIX . "user u 
          ON cpm.add_by = u.user_id 
          WHERE cpm.language_id = '" . (int) $this->config->get('config_language_id') . "'";

        if (!empty($data['filter_payment_method_name'])) {
            $sql .= " AND payment_method_name LIKE '%" . $this->db->escape($data['filter_payment_method_name']) . "%'";
        }

        if (!empty($data['filter_sql_code'])) {
            $sql .= " AND cpm.code LIKE '%" . $this->db->escape($data['filter_sql_code']) . "%'";
        }

        if ($data['filter_status'] != '') {
            $sql .= " AND cpm.status in (" . $data['filter_status'] . ")";
        }

        // $filter_store_id = $data['filter_store_id'] != '' ?
		// "AND sa.store_id in (" . $data['filter_store_id'] . ")" : '';

        

        $sort_data = array(
            'filter_payment_method_name',
			'status',
			'customer_payment_method_id',
			'sql_accounting_code',
			'sort_order',
			'date_added'
		);

        if(empty($data['sort'] && $data['order'])){
            $sql .= " ORDER BY cpm.default DESC , cpm.payment_method_name ASC " ;
        }else{
            if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
                $sql .= " ORDER BY " . $data['sort'];
            } else {
                $sql .= " ORDER BY sort_order";
            }
    
            if (isset($data['order']) && ($data['order'] == 'DESC')) {
                $sql .= " DESC";
            } else {
                $sql .= " ASC";
            }
        }
		
        

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getcode(){
        $sql = "SELECT code FROM " . DB_PREFIX . "customer_payment_method WHERE 1";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getallowdeleted($customer_payment_method_id){
        $sql = "SELECT allow_deleted FROM " . DB_PREFIX . "customer_payment_method cpm WHERE cpm.customer_payment_method_id = '".(int)$customer_payment_method_id."' ";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function addCustomerPaymentMethod($data) {
        // $payment_method_name = json_encode($data['payment_method_name']);

        if(isset($data['default'])){
            
            $clear_default = "UPDATE " . DB_PREFIX . "customer_payment_method cpm SET cpm.default = '0' "; 

            $this->db->query($clear_default);

            $code = "SELECT code FROM " . DB_PREFIX . "customer_payment_method WHERE 1";
            if($data['sql_code'] != $code){

                foreach ($data['payment_method_name'] as $language_id => $value) {
                    if (isset($customer_payment_method_id)) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "customer_payment_method SET customer_payment_method_id = '" . (int)$customer_payment_method_id . "', language_id = '" . (int)$language_id . "', payment_method_name = '" . $this->db->escape($value['payment_method_name']) . "',code = '". $this->db->escape($data['sql_code']) ."', sql_accounting_code = '" . $this->db->escape($data['sql_accounting_code']) . "', status = '" . (int)$data['status'] . "', sort_order = '" . (int)$data['sort_order'] . "', `default` = '1', date_added = NOW(), add_by = '" . (int)$this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "'");
                    } else {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "customer_payment_method SET language_id = '" . (int)$language_id . "', payment_method_name = '" . $this->db->escape($value['payment_method_name']) . "',code = '". $this->db->escape($data['sql_code']) ."', sql_accounting_code = '" . $this->db->escape($data['sql_accounting_code']) . "', status = '" . (int)$data['status'] . "', sort_order = '" . (int)$data['sort_order'] . "', `default` = '1', date_added = NOW(), add_by = '" . (int)$this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "'");
                        
                        $customer_payment_method_id = $this->db->getLastId();
                    }
                }
                $this->cache->delete('payment_method_name');

                return $customer_payment_method_id;
            };

        }else{
            $code = "SELECT code FROM " . DB_PREFIX . "customer_payment_method WHERE 1";
            if($data['sql_code'] != $code){
                foreach ($data['payment_method_name'] as $language_id => $value) {
                    if (isset($customer_payment_method_id)) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "customer_payment_method SET customer_payment_method_id = '" . (int)$customer_payment_method_id . "', language_id = '" . (int)$language_id . "', payment_method_name = '" . $this->db->escape($value['payment_method_name']) . "',code = '". $this->db->escape($data['sql_code']) ."', sql_accounting_code = '" . $this->db->escape($data['sql_accounting_code']) . "', status = '" . (int)$data['status'] . "', sort_order = '" . (int)$data['sort_order'] . "', `default` = '0', date_added = NOW(), add_by = '" . (int)$this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "'");
                    } else {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "customer_payment_method SET language_id = '" . (int)$language_id . "', payment_method_name = '" . $this->db->escape($value['payment_method_name']) . "',code = '". $this->db->escape($data['sql_code']) ."', sql_accounting_code = '" . $this->db->escape($data['sql_accounting_code']) . "', status = '" . (int)$data['status'] . "', sort_order = '" . (int)$data['sort_order'] . "', `default` = '0', date_added = NOW(), add_by = '" . (int)$this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "'");
        
                        $customer_payment_method_id = $this->db->getLastId();
                    }
                }
                $this->cache->delete('payment_method_name');

                return $customer_payment_method_id;
            };
        };

        // return $this->db->getLastId();
    }

    public function editCustomerPaymentMethod($data, $customer_payment_method_id) {

        $dateadd = "SELECT date_added FROM " . DB_PREFIX . "customer_payment_method WHERE customer_payment_method_id = '" . (int)$customer_payment_method_id . "'";

        if(isset($data['default'])){
            
            $clear_default = "UPDATE " . DB_PREFIX . "customer_payment_method cpm SET cpm.default = '0' "; 

            $this->db->query($clear_default);

            $this->db->query("DELETE FROM " . DB_PREFIX . "customer_payment_method WHERE customer_payment_method_id = '" . (int)$customer_payment_method_id . "'");

            $code = "SELECT code FROM " . DB_PREFIX . "customer_payment_method WHERE 1";
            if($data['sql_code'] != $code){

                foreach ($data['payment_method_name'] as $language_id => $value) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "customer_payment_method SET customer_payment_method_id = '" . (int)$customer_payment_method_id . "', language_id = '" . (int)$language_id . "', payment_method_name = '" . $this->db->escape($value['payment_method_name']) . "',code = '". $this->db->escape($data['sql_code']) ."', sql_accounting_code = '" . $this->db->escape($data['sql_accounting_code']) . "', status = '" . (int)$data['status'] . "', sort_order = '" . (int)$data['sort_order'] . "',`default` = '1',date_added = '" . $this->db->escape($data['date_added']) . "' ,add_by = '" . (int)$this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "'");
                }
        
                $this->cache->delete('payment_method_name');
             };
            
        }else{
            $code = "SELECT code FROM " . DB_PREFIX . "customer_payment_method WHERE 1";

            if($data['sql_code'] != $code){

                $this->db->query("DELETE FROM " . DB_PREFIX . "customer_payment_method WHERE customer_payment_method_id = '" . (int)$customer_payment_method_id . "'");

                foreach ($data['payment_method_name'] as $language_id => $value) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "customer_payment_method SET customer_payment_method_id = '" . (int)$customer_payment_method_id . "', language_id = '" . (int)$language_id . "', payment_method_name = '" . $this->db->escape($value['payment_method_name']) . "',code = '". $this->db->escape($data['sql_code']) ."', sql_accounting_code = '" . $this->db->escape($data['sql_accounting_code']) . "', status = '" . (int)$data['status'] . "', sort_order = '" . (int)$data['sort_order'] . "',`default` = '0',date_added = '" . $this->db->escape($data['date_added']) ."' ,add_by = '" . (int)$this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "'");
                }
        
                $this->cache->delete('payment_method_name'); };
        };

        
        // $query = $this->db->query($sql);
    }

    public function deleteCustomerPaymentMethod($customer_payment_method_id) {
        $sql = "DELETE FROM " . DB_PREFIX . "customer_payment_method WHERE customer_payment_method_id = '" . (int)$customer_payment_method_id . "'";

        $query = $this->db->query($sql);
    }

    public function editCustomerPaymentMethodDefault($payment_id) {

            
            $clear_default = "UPDATE " . DB_PREFIX . "customer_payment_method cpm SET cpm.default = '0' "; 
           

            $sql = "UPDATE " . DB_PREFIX . "customer_payment_method SET  `default` = '1' WHERE customer_payment_method_id = '" . (int)$payment_id . "'";

            $this->db->query($clear_default);
    

        
        $query = $this->db->query($sql);
    }

    public function editCustomerPaymentMethodEnabled($payment_id) {

            $sql = "UPDATE " . DB_PREFIX . "customer_payment_method SET  `status` = '1' WHERE customer_payment_method_id = '" . (int)$payment_id . "'"; 

    
    $query = $this->db->query($sql);

}

public function editCustomerPaymentMethodDisabled($payment_id) {

    $sql = "UPDATE " . DB_PREFIX . "customer_payment_method SET  `status` = '0' WHERE customer_payment_method_id = '" . (int)$payment_id . "'"; 


$query = $this->db->query($sql);

}

    public function getorder(){
        $sql = "SELECT * FROM " . DB_PREFIX . "order WHERE 1";

        $query = $this->db->query($sql);

        return $query->rows; 
    }
}
?>