<?php
class ModelReportTopCustomerReport extends Model {
    public function getPaymentMethod(){
		$payment_methods = array();
		
		$sql = "SELECT DISTINCT payment_method FROM " . DB_PREFIX . "order";
		$query = $this->db->query($sql);
		
		foreach($query->rows as $payment_method) {
			$p_m = trim($payment_method['payment_method']);
			
			if(!empty($p_m)) $payment_methods[] = $payment_method['payment_method'];
		}
		
		return $payment_methods;
	}

    public function getCustomerGroup(){
        $sql="SELECT customer_group_id as id, name FROM oc_customer_group_description WHERE language_id = '".$this->config->get('config_language_id')."' ";

        $query = $this->db->query($sql);
		return $query->rows;
    }

    public function getstore($store_id){
        $sql="SELECT s.value FROM oc_setting s WHERE  s.store_id = '".$store_id."' and s.key = 'config_name'";

        $query = $this->db->query($sql);
		return $query->row['value'];
    }

    public function getTopcustomerlist($data){

        $filter_cs_date_from = (!empty($data['filter_date_start']))?
		" AND DATE(cs.sales_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";
		

		$filter_cs_date_to = (!empty($data['filter_date_end']))?
		" AND DATE(cs.sales_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";

        $filter_sf_date_from = (!empty($data['filter_date_start']))?
		" AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";
		

		$filter_sf_date_to = (!empty($data['filter_date_end']))?
		" AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
        $filter_customer_group = (!empty($data['filter_customer_group']))?
		" AND cgd.customer_group_id in (" .$data['filter_customer_group'] . ")" : 
		"";

        $filter_name = (!empty($data['filter_name']))?
		"AND CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'" :
		"";

        $filter_telephone = (!empty($data['filter_telephone']))?
		"AND c.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'" :
		"";

        $filter_gender = (!empty($data['filter_gender']))?
		" AND c.gender in (" .$data['filter_gender'] . ")" : 
		"";

        // if($data['filter_new_return'] == 'new'){
        //     $filter_new_return = "AND c.date_added = now() ";
        // }elseif($data['filter_new_return'] == 'return'){
        //     $filter_new_return = "AND c.date_added != now() ";
        // }else{
        //     $filter_new_return = "";
        // }

        $filter_age_start = (!empty($data['filter_age_start']))?
		"AND DATE_FORMAT(FROM_DAYS(DATEDIFF(NOW(),c.dob)), '%Y') + 0 >= '".(int)$data['filter_age_start']."'" :
		"";

        $filter_age_end = (!empty($data['filter_age_end']))?
        "AND DATE_FORMAT(FROM_DAYS(DATEDIFF(NOW(),c.dob)), '%Y') + 0 <= '".(int)$data['filter_age_end']."'" :

		"";

        $filter_last_visit_start = (!empty($data['filter_last_visit_start']))?
		"AND DATE(a.last_visit) >= '".$this->db->escape($data['filter_last_visit_start'])."'" :
		"";

        $filter_last_visit_end = (!empty($data['filter_last_visit_end']))?
		"AND DATE(a.last_visit) <= '".$this->db->escape($data['filter_last_visit_end'])."'" :
		"";

        $filter_store_id = $data['filter_store_id'] != '' ?
		"AND c.store_id = '" . $data['filter_store_id'] . "'" :
		"";
        $limit_statement = "";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
        $sql="SELECT
        c.customer_id as customer_id,
		CONCAT(c.firstname,' ',c.lastname) as name ,
        c.telephone as telephone ,
		DATE_FORMAT(FROM_DAYS(DATEDIFF(NOW(),c.dob)), '%Y') + 0 as age ,
        c.gender as gender ,
        cgd.name as customer_group,
        c.date_added as date_added ,
        c.store_id as store_id,
         c.date_added as first_visit,
        MAX(a.last_visit) as last_visit,
        (SELECT COUNT(DISTINCT(cs.clinical_sale_id)) as medical_record FROM oc_clinical_sale cs WHERE cs.customer_id = c.customer_id AND cs.clinicalsale_action = '5' $filter_cs_date_from $filter_cs_date_to ) as medical_record,
        (SELECT COUNT(DISTINCT(sf.service_form_id)) as service_record FROM oc_service_form sf WHERE sf.customer_id = c.customer_id AND sf.serviceform_action = '5' $filter_sf_date_from $filter_sf_date_to ) as service_record
        FROM oc_customer c
        LEFT JOIN oc_customer_group_description cgd 
        ON c.customer_group_id = cgd.customer_group_id AND cgd.language_id = '1'
        LEFT JOIN (
            SELECT 
            cs.customer_id as customer_id,
            MAX(cs.sales_date) as last_visit
            FROM oc_clinical_sale cs
            WHERE 1 
            AND cs.clinicalsale_action = '5'
            GROUP BY cs.clinical_sale_id 

            UNION ALL 

            SELECT 
            sf.customer_id as customer_id,
            MAX(sf.service_date) as last_visit
            FROM oc_service_form sf
            WHERE 1
            AND sf.serviceform_action = '5'
            GROUP BY sf.service_form_id 
        ) a 
        ON c.customer_id = a.customer_id
        WHERE 1
        AND a.last_visit != '' 
       
         $filter_customer_group
         $filter_name
         $filter_telephone
         $filter_gender
         $filter_age_start
         $filter_age_end
         $filter_last_visit_start
         $filter_last_visit_end
         $filter_store_id
        
        
        GROUP BY c.customer_id
        ORDER BY 
        (medical_record + service_record) DESC
        $limit_statement

        ";
        
        // echo"<pre>";
        // print_r($sql);
        // echo"</pre>";
        $query = $this->db->query($sql);
		return $query->rows; 
    }

    public function getTopcustomerlistnumber($data){
        $filter_batch_date_from = (!empty($data['filter_date_start']))?
		" AND DATE(c.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";
		

		$filter_batch_date_to = (!empty($data['filter_date_end']))?
		" AND DATE(c.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
        $filter_customer_group = (!empty($data['filter_customer_group']))?
		" AND cgd.customer_group_id in (" .$data['filter_customer_group'] . ")" : 
		"";

        $filter_name = (!empty($data['filter_name']))?
		"AND CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'" :
		"";

        $filter_telephone = (!empty($data['filter_telephone']))?
		"AND c.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'" :
		"";

        $filter_gender = (!empty($data['filter_gender']))?
		" AND c.gender in (" .$data['filter_gender'] . ")" : 
		"";

        // if($data['filter_new_return'] == 'new'){
        //     $filter_new_return = "  AND c.date_added = now() ";
        // }elseif($data['filter_new_return'] == 'return'){
        //     $filter_new_return = "  AND c.date_added != now() ";
        // }else{
        //     $filter_new_return = "";
        // }

        $filter_age_start = (!empty($data['filter_age_start']))?
		"AND DATE_FORMAT(FROM_DAYS(DATEDIFF(NOW(),c.dob)), '%Y') + 0 >= '".(int)$data['filter_age_start']."'" :
		"";

        $filter_age_end = (!empty($data['filter_age_end']))?
        "AND DATE_FORMAT(FROM_DAYS(DATEDIFF(NOW(),c.dob)), '%Y') + 0 <= '".(int)$data['filter_age_end']."'" :

		"";

        $filter_last_visit_start = (!empty($data['filter_last_visit_start']))?
		"AND a.last_visit >= '".$this->db->escape($data['filter_last_visit_start'])."'" :
		"";

        $filter_last_visit_end = (!empty($data['filter_last_visit_end']))?
		"AND a.last_visit <= '".$this->db->escape($data['filter_last_visit_end'])."'" :
		"";

        $filter_store_id = $data['filter_store_id'] != '' ?
		"AND c.store_id = '" . $data['filter_store_id'] . "'" :
		"";

       

        $sql="SELECT SUM(b.total) as total FROM
        (SELECT count(distinct(c.customer_id)) as total

        FROM oc_customer c
        LEFT JOIN oc_customer_group_description cgd 
        ON c.customer_group_id = cgd.customer_group_id AND cgd.language_id = '1'
        LEFT JOIN (
            SELECT 
            cs.customer_id as customer_id,
            MAX(cs.sales_date) as last_visit
           
            FROM oc_clinical_sale cs
            WHERE 1 
            AND cs.clinicalsale_action = '5'
            GROUP BY cs.clinical_sale_id 

            UNION ALL 

            SELECT 
            sf.customer_id as customer_id,
            MAX(sf.service_date) as last_visit
           
            FROM oc_service_form sf
            WHERE 1
            AND sf.serviceform_action = '5'
            GROUP BY sf.service_form_id 
        ) a 
        ON c.customer_id = a.customer_id
        WHERE 1
        AND a.last_visit != '' 
    
         $filter_customer_group
         $filter_name
         $filter_telephone
         $filter_gender
         $filter_age_start
         $filter_age_end
         $filter_last_visit_start
         $filter_last_visit_end
         $filter_store_id
        GROUP BY c.customer_id)b
        where 1
        ";
        
        // echo"<pre>";
        // print_r($sql);
        // echo"</pre>";
        $query = $this->db->query($sql);
		return $query->row['total']; 
    }

    public function getalltotal($data){

        $filter_cs_date_from = (!empty($data['filter_date_start']))?
		" AND DATE(cs.sales_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";
		

		$filter_cs_date_to = (!empty($data['filter_date_end']))?
		" AND DATE(cs.sales_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";

        $filter_sf_date_from = (!empty($data['filter_date_start']))?
		" AND DATE(sf.service_date) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";
		

		$filter_sf_date_to = (!empty($data['filter_date_end']))?
		" AND DATE(sf.service_date) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
        $filter_customer_group = (!empty($data['filter_customer_group']))?
		" AND cgd.customer_group_id in (" .$data['filter_customer_group'] . ")" : 
		"";

        $filter_name = (!empty($data['filter_name']))?
		"AND CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'" :
		"";

        $filter_telephone = (!empty($data['filter_telephone']))?
		"AND c.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'" :
		"";

        $filter_gender = (!empty($data['filter_gender']))?
		" AND c.gender in (" .$data['filter_gender'] . ")" : 
		"";

        // if($data['filter_new_return'] == 'new'){
        //     $filter_new_return = "AND c.date_added = now() ";
        // }elseif($data['filter_new_return'] == 'return'){
        //     $filter_new_return = "AND c.date_added != now() ";
        // }else{
        //     $filter_new_return = "";
        // }

        $filter_age_start = (!empty($data['filter_age_start']))?
		"AND DATE_FORMAT(FROM_DAYS(DATEDIFF(NOW(),c.dob)), '%Y') + 0 >= '".(int)$data['filter_age_start']."'" :
		"";

        $filter_age_end = (!empty($data['filter_age_end']))?
        "AND DATE_FORMAT(FROM_DAYS(DATEDIFF(NOW(),c.dob)), '%Y') + 0 <= '".(int)$data['filter_age_end']."'" :

		"";

        $filter_last_visit_start = (!empty($data['filter_last_visit_start']))?
		"AND a.last_visit >= '".$this->db->escape($data['filter_last_visit_start'])."'" :
		"";

        $filter_last_visit_end = (!empty($data['filter_last_visit_end']))?
		"AND a.last_visit <= '".$this->db->escape($data['filter_last_visit_end'])."'" :
		"";

        $filter_store_id = $data['filter_store_id'] != '' ?
		"AND c.store_id = '" . $data['filter_store_id'] . "'" :
		"";
        $limit_statement = "";
    
            if (isset($data['start']) || isset($data['limit'])) {
                if ($data['start'] < 0) {
                    $data['start'] = 0;
                }
    
                if ($data['limit'] < 1) {
                    $data['limit'] = 20;
                }
    
                $limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
            }
            $sql="SELECT IFNULL(SUM(b.new_customer),'0') as new_customer, IFNULL(SUM(b.return_customer),'0') as return_customer , IFNULL(SUM(b.medical_record),'0') as medical_record, IFNULL(SUM(b.service_record),'0') as service_record FROM
            (SELECT (CASE WHEN c.date_added = NOW() THEN COUNT(DISTINCT(c.customer_id)) END) as new_customer,
            (CASE WHEN c.date_added != NOW() THEN COUNT(DISTINCT(c.customer_id)) END) as return_customer,
            (SELECT COUNT(DISTINCT(cs.clinical_sale_id)) as medical_record FROM oc_clinical_sale cs WHERE cs.customer_id = c.customer_id AND cs.clinicalsale_action = '5' $filter_cs_date_from $filter_cs_date_to ) as medical_record,
        (SELECT COUNT(DISTINCT(sf.service_form_id)) as service_record FROM oc_service_form sf WHERE sf.customer_id = c.customer_id AND sf.serviceform_action = '5' $filter_sf_date_from $filter_sf_date_to ) as service_record
        
            FROM oc_customer c
            LEFT JOIN oc_customer_group_description cgd 
            ON c.customer_group_id = cgd.customer_group_id AND cgd.language_id = '1'
            LEFT JOIN (
                SELECT 
                cs.customer_id as customer_id,
                MAX(cs.sales_date) as last_visit
               
                FROM oc_clinical_sale cs
                WHERE 1 
                AND cs.clinicalsale_action = '5'
                GROUP BY cs.clinical_sale_id 
    
                UNION ALL 
    
                SELECT 
                sf.customer_id as customer_id,
                MAX(sf.service_date) as last_visit
               
                FROM oc_service_form sf
                WHERE 1
                AND sf.serviceform_action = '5'
                GROUP BY sf.service_form_id 
            ) a 
            ON c.customer_id = a.customer_id
            WHERE 1
            AND a.last_visit != '' 
          
             $filter_customer_group
             $filter_name
             $filter_telephone
             $filter_gender
             $filter_age_start
             $filter_age_end
             $filter_last_visit_start
             $filter_last_visit_end
             $filter_store_id
            GROUP BY c.customer_id)b
            where 1
         
            ";
            
            // echo"<pre>";
            // print_r($sql);
            // echo"</pre>";
            $query = $this->db->query($sql);
            return $query->row; 
        
        // $sql= "SELECT 
        // IFNULL(SUM(a.clinical_sale_new),'0') as clinical_sale_new,
        // IFNULL(SUM(a.clinical_sale_returning),'0') as clinical_sale_returning,
        // IFNULL(SUM(a.service_new),'0') as service_new,
        // IFNULL(SUM(a.service_return),'0') as service_return,
        // SUM(a.clinical_sale_total) as clinical_sale_total,
        // SUM(a.service_form_total) as service_form_total

        // FROM 

        // (SELECT  

        // IFNULL((CASE WHEN c.date_added = NOW() THEN COUNT(cs.clinical_sale_id) END),'0') as clinical_sale_new,
        // IFNULL((CASE WHEN c.date_added != NOW() THEN COUNT(cs.clinical_sale_id) END),'0') as clinical_sale_returning,
        // '0' as service_new,
        // '0' as service_return,
        // COUNT(cs.clinical_sale_id) as clinical_sale_total,
        // '0' as service_form_total

        // FROM oc_clinical_sale cs
        // LEFT JOIN oc_customer c
        // ON cs.customer_id = c.customer_id

        // WHERE 1
    
        // AND cs.clinicalsale_action = '5'
        // GROUP BY cs.clinical_sale_id

        // UNION ALL

        // SELECT
        // '0' as clinical_sale_new,
        // '0' as clinical_sale_returning,
        // IFNULL((CASE WHEN c.date_added = NOW() THEN COUNT(sf.service_form_id) END),'0') as service_new,
        // IFNULL((CASE WHEN c.date_added != NOW() THEN COUNT(sf.service_form_id) END),'0') as service_return,
        // '0' as clinical_sale_total,
        // COUNT(sf.service_form_id) as service_form_total
        // FROM oc_service_form sf
        // LEFT JOIN oc_customer c
        // ON sf.customer_id = c.customer_id
        // WHERE 1 
      
        // AND sf.serviceform_action = '5'

        // GROUP BY sf.service_form_id

        // )a

        // WHERE 1
        // ";
    }


}
?>