<?php
class ModelReportServiceformSummarybyService extends Model {

	
	public function getServiceformSummaryByService($data){
		
		
	
		$filter_statements = $this->getFiltersData($data);
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT 

		COUNT(si.clinicalservice_id) AS total_item,
            si.clinicalservice_id,
            IFNULL((SELECT csd.name FROM oc_clinical_service_description csd WHERE csd.clinicalservice_id = si.clinicalservice_id AND csd.language_id = '" . (int)$this->config->get('config_language_id') . "'),'Item be Deleted') as name,
			SUM(si.net_amount) AS subtotal,
			SUM(si.gst) AS tax,
			SUM(si.total) AS total
		
		FROM " . DB_PREFIX . "service_item si
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON si.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON sf.order_id = o.order_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		$filter_statements
		";
		$sql .= "GROUP BY si.clinicalservice_id";
		$sql .= " ORDER BY IFNULL(IFNULL(o.invoice_date,o.date_added),sf.service_date) DESC ";
        $sql .= $limit_statement;
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getServiceformSummaryByServiceTotal($data){
		
		
		
		$filter_statements = $this->getFiltersData($data);
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT COUNT(*) AS total FROM(
		SELECT 
		COUNT(si.clinicalservice_id) AS total_item,
		si.clinicalservice_id,
		IFNULL((SELECT csd.name FROM oc_clinical_service_description csd WHERE csd.clinicalservice_id = si.clinicalservice_id AND csd.language_id = '" . (int)$this->config->get('config_language_id') . "'),'Item be Deleted') as name,
		SUM(si.net_amount) AS subtotal,
		SUM(si.gst) AS tax,
		SUM(si.total) AS total
	
		FROM " . DB_PREFIX . "service_item si
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON si.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "order o
		ON sf.order_id = o.order_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
		WHERE 1
		$filter_statements
		GROUP BY si.clinicalservice_id
		)a
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getServiceformSummaryByServiceInfo($clinicalservice_id, $data){
		$filter_statements = $this->getFiltersData($data);
		
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			sf.service_date AS service_date,
			sf.invoice_prefix AS invoice_prefix, 
            IFNULL(o.invoice_date,o.date_added) AS order_date,
            o.invoice_prefix AS order_invoice_prefix,
            CONCAT(c.firstname , ' ' , c.lastname) AS name,
            c.telephone AS telephone,
            cgd.name AS group_description_name,
			a.net_amount AS subtotal, 
			a.gst AS tax,
			a.total AS total
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
        LEFT JOIN " . DB_PREFIX . "customer_group_description cgd
        ON c.customer_group_id = cgd.customer_group_id AND cgd.language_id = '" . (int)$this->config->get("config_language_id") . "' 
        LEFT JOIN " . DB_PREFIX . "order o
		ON sf.order_id = o.order_id
		WHERE 1
		AND csd.language_id = '" . (int)$this->config->get("config_language_id") . "'
		$filter_statements
		";
			
		
        $sql .= $limit_statement;
		
		// echo"<pre>";
		// print_r($sql);
		// echo"</pre>";
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getServiceformSummaryByServiceInfoTotal($clinicalservice_id, $data){
		$filter_statements = $this->getFiltersData($data);
		
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT COUNT(*) AS total FROM (
            SELECT
			sf.service_date AS service_date,
			sf.invoice_prefix AS invoice_prefix, 
            CONCAT(c.firstname + '' + c.lastname) AS name,
            cgd.name AS group_description_name,
			a.net_amount AS subtotal, 
			a.gst AS tax,
			a.total AS total
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
        LEFT JOIN " . DB_PREFIX . "customer_group_description cgd
        ON c.customer_group_id = cgd.customer_group_id AND cgd.language_id = '" . (int)$this->config->get("config_language_id") . "' 
        LEFT JOIN " . DB_PREFIX . "order o
		ON sf.order_id = o.order_id
		WHERE 1
		AND csd.language_id = '" . (int)$this->config->get("config_language_id") . "'
			$filter_statements
		
		)a
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getServiceformSummaryByServiceInfoTotalSubtotal($clinicalservice_id, $data){
		$filter_statements = $this->getFiltersData($data);
		
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			SUM(a.net_amount) as subtotal
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
        LEFT JOIN " . DB_PREFIX . "customer_group_description cgd
        ON c.customer_group_id = cgd.customer_group_id AND cgd.language_id = '" . (int)$this->config->get("config_language_id") . "' 
        LEFT JOIN " . DB_PREFIX . "order o
		ON sf.order_id = o.order_id
		WHERE 1
		AND csd.language_id = '" . (int)$this->config->get("config_language_id") . "'
		$filter_statements
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['subtotal'];
	}
	
	public function getServiceformSummaryByServiceInfoTotalTax($clinicalservice_id, $data){
		$filter_statements = $this->getFiltersData($data);
		
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			SUM(a.gst) as tax
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
        LEFT JOIN " . DB_PREFIX . "customer_group_description cgd
        ON c.customer_group_id = cgd.customer_group_id AND cgd.language_id = '" . (int)$this->config->get("config_language_id") . "' 
        LEFT JOIN " . DB_PREFIX . "order o
		ON sf.order_id = o.order_id
		WHERE 1
		AND csd.language_id = '" . (int)$this->config->get("config_language_id") . "'
		$filter_statements
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['tax'];
	}
	
	public function getServiceformSummaryByServiceInfoTotalSales($clinicalservice_id, $data){
		$filter_statements = $this->getFiltersData($data);
		
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			SUM(a.total) as total
		FROM
		(
			SELECT *
			FROM " . DB_PREFIX . "service_item
			WHERE 1
			AND clinicalservice_id = '" . (int)$clinicalservice_id . "'
			GROUP BY service_form_id
		)a
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON a.service_form_id = sf.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON a.clinicalservice_id = csd.clinicalservice_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON sf.customer_id = c.customer_id
        LEFT JOIN " . DB_PREFIX . "customer_group_description cgd
        ON c.customer_group_id = cgd.customer_group_id AND cgd.language_id = '" . (int)$this->config->get("config_language_id") . "' 
        LEFT JOIN " . DB_PREFIX . "order o
		ON sf.order_id = o.order_id
		WHERE 1
		AND csd.language_id = '" . (int)$this->config->get("config_language_id") . "'
		$filter_statements
		
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}

	public function orderstatus($data){

		$status = (!empty($data)) ? 
		"AND order_status_id IN (" . $data . ")" : 
		"";

		$sql = "SELECT name FROM " . DB_PREFIX . "order_status WHERE language_id = '" . (int)$this->config->get('config_language_id') . "' $status";
		
		$query = $this->db->query($sql);
		
		return $query->rows;

	}

	protected function getFiltersData($data) {
        // Filters
		$filter_statements = "";

        $filter_date_statement = '';
        if (!empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $filter_date_statement = " AND sf.`service_date`  BETWEEN '" . $this->db->escape($data['filter_date_start']) . "' AND  '" . $this->db->escape($data['filter_date_end']) . "'";
        } else if (!empty($data['filter_date_start']) && empty($data['filter_date_end'])) {
            $filter_date_statement = " AND sf.`service_date`  >= '" . $this->db->escape($data['filter_date_start']) . "'";
        } else if (empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $filter_date_statement = " AND sf.`service_date`  <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

		$filter_invoice_date_statement = '';
		if (!empty($data['filter_invoice_date_start']) && !empty($data['filter_invoice_date_end'])) {
            $filter_invoice_date_statement = " AND DATE(IFNULL(o.invoice_date,o.date_added))  BETWEEN '" . $this->db->escape($data['filter_invoice_date_start']) . "' AND  '" . $this->db->escape($data['filter_invoice_date_end']) . "'";
        } else if (!empty($data['filter_invoice_date_start']) && empty($data['filter_invoice_date_end'])) {
            $filter_invoice_date_statement = " AND DATE(IFNULL(o.invoice_date,o.date_added))  >= '" . $this->db->escape($data['filter_invoice_date_start']) . "'";
        } else if (empty($data['filter_invoice_date_start']) && !empty($data['filter_invoice_date_end'])) {
            $filter_invoice_date_statement = " AND DATE(IFNULL(o.invoice_date,o.date_added))  <= '" . $this->db->escape($data['filter_invoice_date_end']) . "'";
        }


		
		
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_ic_statement = (!empty($data['filter_customer_ic'])) ? 
		"AND sf.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";


		// if($data['filter_service_name'])
		// $filter_service_name = (!empty($data['filter_service_name'])) ?
		// 	"AND si.clinicalservice_id IN (" . (int)$data['filter_service_name'] . ")" :
		// 	"";
		// 	// var_dump(explode(',',$data['filter_service_name']));

		// $filter_service_name_deleted = ($data['filter_service_name'] == '*') ?
		// 	"AND si.servicename = ''" :
		// 	"";

		$filter_service_name='';
		if(!empty($data['filter_service_name'])){
		if($data['filter_service_name']=='*'){
			$filter_service_name = "AND si.servicename = ''";

		}else{
			if(in_array('*',explode(',',$data['filter_service_name']),true)){
				$service = substr($data['filter_service_name'],0,-2);
				$filter_service_name = "AND (si.clinicalservice_id IN (" . $this->db->escape($service) . ") OR si.servicename = '')";
			}else{
				$filter_service_name = (!empty($data['filter_service_name'])) ?
				"AND si.clinicalservice_id IN (" . (int)$data['filter_service_name'] . ")" :
				"";
			}
		}
		}
			$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND sf.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND sf.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";

        $filter_doctor_statement = !empty($data['filter_doctor_name']) ? " AND si.`user_id` IN (" . $this->db->escape($data['filter_doctor_name']) . ") " : "";

        $filter_status_id_statement = !empty($data['filter_status_id']) ? " AND sf.`serviceform_action` IN (" . $this->db->escape($data['filter_status_id']) . ") " : "";

        $filter_payment_status_statement = !empty($data['filter_payment_status']) ? " AND sf.`order_action` IN (" . $this->db->escape($data['filter_payment_status']) . ") " : "";

        $filter_store_id_statement = !empty($data['filter_store_id']) ? " AND sf.`store_id` IN (" . $this->db->escape($data['filter_store_id']) . ") " : "";

		// $filter_statements .= $filter_service_name_deleted;
		$filter_statements .= $filter_service_name;
		$filter_statements .= $filter_customer_name_statement;
		$filter_statements .= $filter_customer_ic_statement;
		$filter_statements .= $filter_customer_card_statement;
		$filter_statements .= $filter_transaction_start_statement;
		$filter_statements .= $filter_transaction_end_statement;
        $filter_statements .= $filter_date_statement;
		$filter_statements .= $filter_invoice_date_statement;
		$filter_statements .= $filter_doctor_statement;
		$filter_statements .= $filter_status_id_statement;
		$filter_statements .= $filter_payment_status_statement;
		$filter_statements .= $filter_store_id_statement;

        return $filter_statements;
    }

	public function getservicename(){
		$sql = "SELECT DISTINCT si.clinicalservice_id AS item_id, si.name AS item_name FROM  oc_clinical_service_description si WHERE 1 AND si.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY si.name ASC ";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function status($status_id){
		$sql="SELECT GROUP_CONCAT(os.name SEPARATOR ', ') as status_name FROM " . DB_PREFIX . "order_status os WHERE os.order_status_id IN (".$this->db->escape($status_id).") AND language_id = '" . (int)$this->config->get('config_language_id') . "'";
	
		$query = $this->db->query($sql);

		return $query->row['status_name'];
	}

	public function getServiceStatuses(){
		$sql="SELECT DISTINCT os.order_status_id , os.name  FROM oc_service_form sf LEFT JOIN oc_order_status os ON sf.serviceform_action = os.order_status_id AND language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE 1 ORDER BY os.name ASC";
	
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getPaymentStatuses(){
		$sql="SELECT DISTINCT os.order_status_id , os.name  FROM oc_service_form sf LEFT JOIN oc_order_status os ON sf.order_action = os.order_status_id AND language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE 1 ORDER BY os.name ASC";
	
		$query = $this->db->query($sql);

		return $query->rows;
	}
	
}
?>