<?php
class ModelReportServiceformSummaryByDoctor extends Model{
    public function getServiceformSummaryByDoctor($data){
        $filter_statements = $this->getFiltersData($data);

        $limit_statement = "";
		if (!empty($data)) {
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}

				$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}
		}

        $sql = "SELECT si.user_id AS doctor_id, CONCAT(u.firstname, ' ', u.lastname) AS doctor_name, COUNT(si.service_Item_id) AS total_services, COUNT(DISTINCT(si.service_form_id)) AS total_records, SUM(si.net_amount) AS subtotal, SUM(si.gst) AS tax, SUM(si.total) AS total 
        FROM `oc_service_item` si 
        LEFT JOIN `oc_service_form` sf ON (si.service_form_id = sf.service_form_id) 
        LEFT JOIN `oc_user` u ON (si.user_id = u.user_id) 
        LEFT JOIN " . DB_PREFIX . "order o ON sf.order_id = o.order_id
        WHERE 1 AND u.user_id IS NOT NULL
                $filter_statements
        ";
        $sql .= " GROUP BY si.user_id ";
        $sql .= " ORDER BY total DESC ";
        $sql .= $limit_statement;

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getServiceformSummaryByDoctorTotal($data){
        $filter_statements = $this->getFiltersData($data);

        $sql = "SELECT COUNT(DISTINCT si.user_id) AS total_practitioners, COUNT(si.service_Item_id) AS total_services, COUNT(DISTINCT(si.service_form_id)) AS total_records, SUM(si.net_amount) AS subtotal, SUM(si.gst) AS tax, SUM(si.total) AS total 
        FROM `oc_service_item` si 
        LEFT JOIN `oc_service_form` sf ON (si.service_form_id = sf.service_form_id) 
        LEFT JOIN `oc_user` u ON (si.user_id = u.user_id) 
        LEFT JOIN " . DB_PREFIX . "order o ON sf.order_id = o.order_id
        WHERE 1 AND u.user_id IS NOT NULL $filter_statements
        ";

        $query = $this->db->query($sql);
        return $query->row;
    }

    protected function getFiltersData($data) {
        // Filters
		$filter_statements = "";

        $filter_date_statement = '';
        if (!empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $filter_date_statement = " AND sf.`service_date`  BETWEEN '" . $this->db->escape($data['filter_date_start']) . "' AND  '" . $this->db->escape($data['filter_date_end']) . "'";
        } else if (!empty($data['filter_date_start']) && empty($data['filter_date_end'])) {
            $filter_date_statement = " AND sf.`service_date`  >= '" . $this->db->escape($data['filter_date_start']) . "'";
        } else if (empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $filter_date_statement = " AND sf.`service_date`  <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $filter_invoice_date_statement = '';
		if (!empty($data['filter_invoice_date_start']) && !empty($data['filter_invoice_date_end'])) {
            $filter_invoice_date_statement = " AND DATE(IFNULL(o.invoice_date,o.date_added))  BETWEEN '" . $this->db->escape($data['filter_invoice_date_start']) . "' AND  '" . $this->db->escape($data['filter_invoice_date_end']) . "'";
        } else if (!empty($data['filter_invoice_date_start']) && empty($data['filter_invoice_date_end'])) {
            $filter_invoice_date_statement = " AND DATE(IFNULL(o.invoice_date,o.date_added))  >= '" . $this->db->escape($data['filter_invoice_date_start']) . "'";
        } else if (empty($data['filter_invoice_date_start']) && !empty($data['filter_invoice_date_end'])) {
            $filter_invoice_date_statement = " AND DATE(IFNULL(o.invoice_date,o.date_added))  <= '" . $this->db->escape($data['filter_invoice_date_end']) . "'";
        }

        $filter_doctor_statement = !empty($data['filter_doctors']) ? " AND si.`user_id` IN (" . $this->db->escape($data['filter_doctors']) . ") " : "";

        $filter_status_id_statement = !empty($data['filter_status_id']) ? " AND sf.`serviceform_action` IN (" . $this->db->escape($data['filter_status_id']) . ") " : "";

        $filter_payment_status_statement = !empty($data['filter_payment_status']) ? " AND sf.`order_action` IN (" . $this->db->escape($data['filter_payment_status']) . ") " : "";

        $filter_store_id_statement = !empty($data['filter_store_id']) ? " AND sf.`store_id` IN (" . $this->db->escape($data['filter_store_id']) . ") " : "";

        $filter_statements .= $filter_date_statement;
		$filter_statements .= $filter_doctor_statement;
		$filter_statements .= $filter_status_id_statement;
		$filter_statements .= $filter_payment_status_statement;
		$filter_statements .= $filter_invoice_date_statement;
		$filter_statements .= $filter_store_id_statement;

        return $filter_statements;
    }

    public function getServiceByUserId($user_id, $data){
        $sql = "SELECT sf.invoice_prefix,
                       sf.date_added,
                       si.servicename,
                       si.gst,
                       si.price,
                       si.total
                FROM " . DB_PREFIX . "service_form sf
                LEFT JOIN " . DB_PREFIX . "service_item si
                ON si.service_form_id = sf.service_form_id
                LEFT JOIN " . DB_PREFIX . "user u
                ON u.user_id = si.user_id
                LEFT JOIN " . DB_PREFIX . "customer c
                ON c.customer_id = sf.customer_id
                LEFT JOIN " . DB_PREFIX . "order o
		        ON sf.order_id = o.order_id
                WHERE si.user_id IS NOT NULL
                AND si.user_id = '" . (int)$user_id . "'";

        if(!empty($data['filter_date_start'])){
            $sql .= " AND DATE(sf.date_added) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')";
        }

        if(!empty($data['filter_date_end'])){
            $sql .= " AND DATE(sf.date_added) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')";
        }

        if(!empty($data['filter_doctor_name'])){
			$sql .= " AND doctor_id = '" . (int)$data['filter_doctor_name'] . "'";
		}

        if(isset($data['filter_payment_status'])){
            $sql .= " AND sf.order_action IN (" . $data['filter_payment_status'] . ")";
        }

        if(!empty($data['filter_customer_ic'])){
            $sql .= " AND c.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']). "%'";
        }

        if(!empty($data['filter_customer_name'])){
            $sql .= " AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']). "%'";
        }

        if(isset($data['filter_status_id'])){
            $sql .= " AND sf.serviceform_action IN (" . $data['filter_status_id'] . ")";
        }

        if(!empty($data['filter_store_id'])){
            $sql .= " AND sf.store_id = '" . (int)$data['filter_store_id'] . "'";
        }

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalServiceByUserId($user_id, $data){
        $sql = "SELECT sf.invoice_prefix,
                       sf.date_added,
                       si.servicename,
                       si.gst,
                       si.price,
                       si.total
                FROM " . DB_PREFIX . "service_form sf
                LEFT JOIN " . DB_PREFIX . "service_item si
                ON si.service_form_id = sf.service_form_id
                LEFT JOIN " . DB_PREFIX . "user u
                ON u.user_id = si.user_id
                LEFT JOIN " . DB_PREFIX . "customer c
                ON c.customer_id = sf.customer_id
                LEFT JOIN " . DB_PREFIX . "order o
		        ON sf.order_id = o.order_id
                WHERE si.user_id IS NOT NULL
                AND si.user_id = '" . (int)$user_id . "'";

        if(!empty($data['filter_date_start'])){
            $sql .= " AND DATE(sf.date_added) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')";
        }

        if(!empty($data['filter_date_end'])){
            $sql .= " AND DATE(sf.date_added) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')";
        }

        if(!empty($data['filter_doctor_name'])){
			$sql .= " AND doctor_id = '" . (int)$data['filter_doctor_name'] . "'";
		}

        if(isset($data['filter_payment_status'])){
            $sql .= " AND sf.order_action IN (" . $data['filter_payment_status'] . ")";
        }

        if(!empty($data['filter_customer_ic'])){
            $sql .= " AND c.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']). "%'";
        }

        if(!empty($data['filter_customer_name'])){
            $sql .= " AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']). "%'";
        }

        if(isset($data['filter_status_id'])){
            $sql .= " AND sf.serviceform_action IN (" . $data['filter_status_id'] . ")";
        }

        if(!empty($data['filter_store_id'])){
            $sql .= " AND sf.store_id = '" . (int)$data['filter_store_id'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getServiceStatuses(){
		$sql="SELECT DISTINCT os.order_status_id , os.name  FROM oc_service_form sf LEFT JOIN oc_order_status os ON sf.serviceform_action = os.order_status_id AND language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE 1 ORDER BY os.name ASC";
	
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getPaymentStatuses(){
		$sql="SELECT DISTINCT os.order_status_id , os.name  FROM oc_service_form sf LEFT JOIN oc_order_status os ON sf.order_action = os.order_status_id AND language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE 1 ORDER BY os.name ASC";
	
		$query = $this->db->query($sql);

		return $query->rows;
	}

    public function getServiceProviders(){
		$sql = "SELECT si.user_id AS doctor_id, CONCAT(u.firstname,' ',u.lastname,' ',u.chinesename) AS doctor_name FROM `" . DB_PREFIX . "service_item` si INNER JOIN `" . DB_PREFIX . "user` u ON (si.user_id = u.user_id) WHERE 1 GROUP BY si.user_id ORDER BY doctor_name ASC ";

		$query = $this->db->query($sql);

		return $query->rows;
	}

    public function status($status_id){
		$sql="SELECT GROUP_CONCAT(os.name SEPARATOR ', ') as status_name FROM " . DB_PREFIX . "order_status os WHERE os.order_status_id IN (".$this->db->escape($status_id).") AND language_id = '" . (int)$this->config->get('config_language_id') . "'";
	
		$query = $this->db->query($sql);

		return $query->row['status_name'];
	}
}
?>
