<?php
class ModelReportSaleByCategory extends Model {
    public function getPaymentMethod(){
		$payment_methods = array();
		
		$sql = "SELECT DISTINCT payment_method FROM " . DB_PREFIX . "order";
		$query = $this->db->query($sql);
		
		foreach($query->rows as $payment_method) {
			$p_m = trim($payment_method['payment_method']);
			
			if(!empty($p_m)) $payment_methods[] = $payment_method['payment_method'];
		}
		
		return $payment_methods;
	}
    
	public function getSalesSummary($data){
		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";
		
		$today = date('Y-m-d');
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";

		$store_id      =  isset($data['filter_store_id']) ? $data['filter_store_id'] : '';
		$payment_method = !empty($data['filter_payment_method']) ? $data['filter_payment_method'] : '';
		
		if (isset($data['start']) && isset($data['limit'])) {
			$data['start'] = $data['start'] < 0 ? 0 : $data['start'];
			$data['limit'] = $data['limit'] < 1 ? $this->config->get('config_limit_admin') : $data['limit'];
		}
		
		$all_sales = array();
		
		//** memory saver
		$date_start_range = 
		isset($data['start']) ? (($data['start'] > 0) ? date('Y-m-d', strtotime('+' . $data['start'] . ' day', strtotime($date_start))) :  date('Y-m-d', strtotime($date_start))) : date('Y-m-d', strtotime($date_start));
		$date_end_range = isset($data['limit']) ? (date('Y-m-d', strtotime('+' . $data['limit'] - 1 . ' day', strtotime($date_start_range)))) : date('Y-m-d', strtotime($date_end));
		$date_end_range = strtotime($date_end_range) <= strtotime($date_end) ? date('Y-m-d', strtotime($date_end_range)) : date('Y-m-d', strtotime($date_end));

		$date_statement = " AND DATE(o.date_added) BETWEEN '" . $this->db->escape($date_start_range) . "' AND '" . $this->db->escape($date_end_range) . "'";
		
		$sales_summary_sql = "
		SELECT 
			(SUM(ROUND(a.herbal_remedies,2)) + SUM(ROUND(a.herbal_remedies2,2))) AS herbal_remedies, SUM(ROUND(a.doctor,2)) AS doctor, SUM(ROUND(a.doctor_tax,2)) AS doctor_tax, SUM(ROUND(a.service_form,2)) AS service_form, SUM(ROUND(a.service_form_tax,2)) AS service_form_tax, SUM(ROUND(a.pos,2)) AS pos, SUM(ROUND(a.expoint_subtotal,2)) AS expoint_subtotal, SUM(ROUND(a.expoint_tax,2)) AS expoint_tax, SUM(ROUND(a.subtotal,2)) AS subtotal, SUM(ROUND(a.shipping,2)) AS shipping, SUM(ROUND(a.tax,2)) AS tax, SUM(ROUND(a.rounding,2)) AS rounding, SUM(ROUND(a.total,2)) AS total, a.date_added AS date  
			FROM (
			SELECT 
			(SUM(ROUND(cst.value,2))) AS herbal_remedies, 0 AS herbal_remedies2, 0 AS doctor, 0 AS doctor_tax, 0 AS service_form, 0 AS service_form_tax, 0 AS pos, 0 AS expoint_subtotal, 0 AS expoint_tax, 0 AS subtotal, 0 AS shipping, 0 AS tax, 0 AS rounding,0 AS total, date(o.date_added) AS date_added
				FROM 
					`oc_order` o
						LEFT JOIN 
							`oc_clinical_sale` cs
								ON o.order_id = cs.order_id
						LEFT JOIN 
							`oc_clinical_sale_total` cst
								ON cs.clinical_sale_id = cst.clinical_sale_id
				WHERE 
					1
					AND cs.collect_consultation_price = '1' 
					AND cst.id = 1  
					AND cst.code = 'sub_total'
					$date_statement
					$filter_store_id_statement
					$filter_payment_status_statement
					$filter_payment_method_statement
				GROUP BY date(o.date_added) 
		
			UNION ALL

			SELECT 
			0 AS herbal_remedies, (SUM(ROUND(cst.value,2))) AS herbal_remedies2, 0 AS doctor, 0 AS doctor_tax, 0 AS service_form, 0 AS service_form_tax, 0 AS pos, 0 AS expoint_subtotal, 0 AS expoint_tax, 0 AS subtotal, 0 AS shipping, 0 AS tax, 0 AS rounding,0 AS total, date(o.date_added) AS date_added
				FROM 
					`oc_order` o
						LEFT JOIN 
							`oc_clinical_sale` cs
								ON o.order_id = cs.order_id
						LEFT JOIN 
							`oc_clinical_sale_total` cst
								ON cs.clinical_sale_id = cst.clinical_sale_id 
				WHERE 
					1
					AND cs.collect_consultation_price = '0' 
					AND cst.id = 2  
					AND cst.code = 'sub_total'
					$date_statement
					$filter_store_id_statement
					$filter_payment_status_statement
					$filter_payment_method_statement
				GROUP BY date(o.date_added) 

			UNION ALL
		
			SELECT 
				0 AS herbal_remedies, 0 AS herbal_remedies2, (SUM(ROUND(cst.value, 2)) - SUM(ROUND(cst2.value, 2))) AS doctor, 0 AS doctor_tax, 0 AS service_form, 0 AS service_form_tax, 0 AS pos, 0 AS expoint_subtotal, 0 AS expoint_tax, 0 AS subtotal, 0 AS shipping, 0 AS tax, 0 AS rounding, 0 AS total, date(o.date_added) AS date_added
				FROM 
					`oc_order` o
						LEFT JOIN 
							`oc_clinical_sale` cs
								ON o.order_id = cs.order_id
						LEFT JOIN 
							`oc_clinical_sale_total` cst
								ON cs.clinical_sale_id = cst.clinical_sale_id
						LEFT JOIN 
							`oc_clinical_sale_total` cst2
								ON cs.clinical_sale_id = cst2.clinical_sale_id
					WHERE 
						1
						AND cst.id = 2
						AND cst.code = 'sub_total'
						AND cst2.id = 1
						AND cst2.code = 'sub_total'
						AND cs.collect_consultation_price = '1'
						$date_statement
						$filter_store_id_statement
						$filter_payment_status_statement
						$filter_payment_method_statement
					GROUP BY date(o.date_added) 
		
			UNION ALL
		
			SELECT 
				0 AS herbal_remedies, 0 AS herbal_remedies2, 0 AS doctor, SUM(ROUND(cst.value, 2)) AS doctor_tax, 0 AS service_form, 0 AS service_form_tax, 0 AS pos, 0 AS expoint_subtotal, 0 AS expoint_tax, 0 AS subtotal, 0 AS shipping, 0 AS tax,0 AS rounding, 0 AS total, date(o.date_added) AS date_added
				FROM `oc_order` o
					LEFT JOIN 
						`oc_clinical_sale` cs
							ON o.order_id = cs.order_id
					INNER JOIN 
						`oc_clinical_sale_total` cst
							ON cs.clinical_sale_id = cst.clinical_sale_id
					WHERE 
						1
						AND cst.id = 2
						AND cst.code = 'tax'
						$date_statement
						$filter_store_id_statement
						$filter_payment_status_statement
						$filter_payment_method_statement
					GROUP BY date(o.date_added) 
		
			UNION ALL
		
			SELECT 
				0 AS herbal_remedies, 0 AS herbal_remedies2, 0 AS doctor, 0 AS doctor_tax, SUM(ROUND(st.value, 2)) AS service_form,  0 AS service_form_tax, 0 AS pos, 0 AS expoint_subtotal, 0 AS expoint_tax, 0 AS subtotal, 0 AS shipping, 0 AS tax, 0 AS rounding, 0 AS total, date(o.date_added) AS date_added
				FROM 
					`oc_order` o
					LEFT JOIN 
						`oc_service_form` sf
							ON o.order_id = sf.order_id
					INNER JOIN 
						`oc_service_total` st
							ON sf.service_form_id = st.service_form_id
					WHERE 
						1
						AND st.code = 'sub_total'
						$date_statement
						$filter_store_id_statement
						$filter_payment_status_statement
						$filter_payment_method_statement
					GROUP BY date(o.date_added) 
		
			UNION ALL
		
			SELECT 
				0 AS herbal_remedies, 0 AS herbal_remedies2, 0 AS doctor, 0 AS doctor_tax, 0 AS service_form, SUM(ROUND(st.value, 2)) AS service_form_tax, 0 AS pos, 0 AS expoint_subtotal, 0 AS expoint_tax, 0 AS subtotal, 0 AS shipping, 0 AS tax, 0 AS rounding, 0 AS total, date(o.date_added) AS date_added
				FROM `oc_order` o
					LEFT JOIN 
						`oc_service_form` sf
							ON o.order_id = sf.order_id
					INNER JOIN 
						`oc_service_total` st
							ON sf.service_form_id = st.service_form_id
					WHERE 
						1
						AND st.code = 'tax'
						$date_statement
						$filter_store_id_statement
						$filter_payment_status_statement
						$filter_payment_method_statement
					GROUP BY date(o.date_added) 
		
			UNION ALL
		
			SELECT 
				0 AS herbal_remedies, 0 AS herbal_remedies2, 0 AS doctor, 0 AS doctor_tax, 0 AS service_form, 0 AS service_form_tax, SUM(ROUND(op.total_net_amount,2)) AS pos, 0 AS expoint_subtotal, 0 AS expoint_tax, 0 AS subtotal, 0 AS shipping, 0 AS tax, 0 AS rounding, 0 AS total, date(o.date_added) AS date_added
				FROM 
					`oc_order` o 
					LEFT JOIN 
						`oc_order_product` op
							ON o.order_id = op.order_id
					   WHERE 
						1
						AND o.payment_method <>'points'
						$date_statement
						$filter_store_id_statement
						$filter_payment_status_statement
						$filter_payment_method_statement
					GROUP BY date(o.date_added)    
		
			UNION ALL
		
			SELECT 
				0 AS herbal_remedies, 0 AS herbal_remedies2, 0 AS doctor, 0 AS doctor_tax, 0 AS service_form, 0 AS service_form_tax, 0 AS pos, SUM(ROUND(ot.value,2)) AS expoint_subtotal, 0 AS expoint_tax, 0 AS subtotal, 0 AS shipping, 0 AS tax, 0 AS rounding, 0 AS total, date(o.date_added) AS date_added
				FROM 
					`oc_order` o
					LEFT JOIN 
						`oc_order_total` ot
							ON o.order_id = ot.order_id AND ot.code = 'sub_total'
					WHERE 
						1
						AND o.payment_method = 'points'
						$date_statement
						$filter_store_id_statement
						$filter_payment_status_statement
						$filter_payment_method_statement
					GROUP BY date(o.date_added)
		
			UNION ALL
		
			SELECT 
				0 AS herbal_remedies, 0 AS herbal_remedies2, 0 AS doctor, 0 AS doctor_tax, 0 AS service_form, 0 AS service_form_tax, 0 AS pos, 0 AS expoint_subtotal, SUM(ROUND(ot.value,2)) AS expoint_tax, 0 AS subtotal, 0 AS shipping, 0 AS tax, 0 AS rounding, 0 AS total, date(o.date_added) AS date_added 
				FROM 
					`oc_order` o
					LEFT JOIN 
						`oc_order_total` ot
							ON o.order_id = ot.order_id AND ot.code = 'tax'
					WHERE 
						1
						AND o.payment_method = 'points'
						$date_statement
						$filter_store_id_statement
						$filter_payment_status_statement
						$filter_payment_method_statement
					GROUP BY date(o.date_added)
		
			UNION ALL
		
			SELECT 
				0 AS herbal_remedies, 0 AS herbal_remedies2, 0 AS doctor, 0 AS doctor_tax, 0 AS service_form, 0 AS service_form_tax, 0 AS pos, 0 AS expoint_subtotal, 0 AS expoint_tax, SUM(ROUND(ot.value, 2)) AS subtotal, 0 AS shipping, 0 AS tax, 0 AS rounding, 0 AS total, date(o.date_added) AS date_added
				FROM `oc_order_total` ot
					INNER JOIN 
						`oc_order` o
							ON ot.order_id = o.order_id
					WHERE 
						1
						AND ot.code = 'sub_total'
						$date_statement
						$filter_store_id_statement
						$filter_payment_status_statement
						$filter_payment_method_statement
					GROUP BY date(o.date_added)
		
			UNION ALL
		
			SELECT 
				0 AS herbal_remedies, 0 AS herbal_remedies2, 0 AS doctor, 0 AS doctor_tax, 0 AS service_form, 0 AS service_form_tax, 0 AS pos, 0 AS expoint_subtotal, 0 AS expoint_tax, 0 AS subtotal, SUM(ROUND(ot.value, 2)) AS shipping,  0 AS tax, 0 AS rounding, 0 AS total, date(o.date_added) AS date_added 
				FROM 
					`oc_order_total` ot
						INNER JOIN 
							`oc_order` o
								ON ot.order_id = o.order_id
					WHERE 
						1
						AND ot.code = 'shipping'
						$date_statement
						$filter_store_id_statement
						$filter_payment_status_statement
						$filter_payment_method_statement
					GROUP BY date(o.date_added)
		
			UNION ALL
		
			SELECT 
				0 AS herbal_remedies, 0 AS herbal_remedies2, 0 AS doctor, 0 AS doctor_tax, 0 AS service_form, 0 AS service_form_tax, 0 AS pos, 0 AS expoint_subtotal, 0 AS expoint_tax, 0 AS subtotal, 0 AS shipping, SUM(ROUND(ot.value, 2)) AS tax, 0 AS rounding, 0 AS total, date(o.date_added) AS date_added
				FROM 
					`oc_order_total` ot
						INNER JOIN 
							`oc_order` o
								ON ot.order_id = o.order_id
					WHERE 
						1
						AND ot.code = 'tax'
						$date_statement
						$filter_store_id_statement
						$filter_payment_status_statement
						$filter_payment_method_statement
					GROUP BY date(o.date_added)
		
			UNION ALL
			
			SELECT 
				0 AS herbal_remedies, 0 AS herbal_remedies2, 0 AS doctor, 0 AS doctor_tax, 0 AS service_form, 0 AS service_form_tax, 0 AS pos, 0 AS expoint_subtotal, 0 AS expoint_tax, 0 AS subtotal, 0 AS shipping, 0 AS tax, SUM(ROUND(ot.value, 2)) AS rounding, 0 AS total, date(o.date_added) AS date_added
				FROM 
					`oc_order_total` ot
						INNER JOIN 
							`oc_order` o
								ON ot.order_id = o.order_id
					WHERE 
						1
						AND ot.code = 'rounding'
						$date_statement
						$filter_store_id_statement
						$filter_payment_status_statement
						$filter_payment_method_statement
					GROUP BY date(o.date_added)
		
			UNION ALL
			
			SELECT 
				0 AS herbal_remedies, 0 AS herbal_remedies2, 0 AS doctor, 0 AS doctor_tax, 0 AS service_form, 0 AS service_form_tax, 0 AS pos, 0 AS expoint_subtotal, 0 AS expoint_tax, 0 AS subtotal, 0 AS shipping, 0 AS tax, 0 AS rounding, SUM(ROUND(ot.value, 2)) AS total, date(o.date_added) AS date_added 
				FROM 
					`oc_order_total` ot
						INNER JOIN 
							`oc_order` o
								ON ot.order_id = o.order_id
					WHERE
						1
						AND ot.code = 'total'
						$date_statement
						$filter_store_id_statement
						$filter_payment_status_statement
						$filter_payment_method_statement
					GROUP BY date(o.date_added)
		) a
			WHERE 1
			GROUP BY a.date_added
			ORDER BY NULL";

		$sales_summary_query =  $this->db->query($sales_summary_sql);
		$all_sales = $sales_summary_query->rows;
	
		return $all_sales;
	}
	
	public function getSalesSummaryTotal($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");
		
		$start = date_create($date_start);
		$end = date_create($date_end);
		
		$interval = date_diff($start,$end);
		
		return strtotime($date_start) <= strtotime($date_end) ? $interval->days + 1 : 0;
	}
	
	public function getSalesSummaryTotalHermedies($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";
		
		$sql = "
		SELECT (SUM(ROUND(a.total,2)) + SUM(ROUND(a.total2,2))) AS total
			FROM (
				SELECT (SUM(ROUND(cst.value,2))) AS total, 0 AS total2
					FROM `oc_order` o
				LEFT JOIN 
					`oc_clinical_sale` cs
						ON o.order_id = cs.order_id
				LEFT JOIN 
					`oc_clinical_sale_total` cst
						ON cs.clinical_sale_id = cst.clinical_sale_id 
				WHERE 1
				AND cs.collect_consultation_price = '1' 
				AND cst.id = 1  
				AND cst.code = 'sub_total'
				AND DATE(o.date_added) >= '" . $this->db->escape($date_start) . "'
				AND DATE(o.date_added) <= '" . $this->db->escape($date_end) . "'
				$filter_store_id_statement
				$filter_payment_status_statement
				$filter_payment_method_statement

				UNION ALL

				SELECT 0 AS total, (SUM(ROUND(cst.value,2))) AS total2
					FROM `oc_order` o
				LEFT JOIN 
					`oc_clinical_sale` cs
						ON o.order_id = cs.order_id
				LEFT JOIN 
					`oc_clinical_sale_total` cst
						ON cs.clinical_sale_id = cst.clinical_sale_id 
				WHERE 1
				AND cs.collect_consultation_price = '0' 
				AND cst.id = 2  
				AND cst.code = 'sub_total'
				AND DATE(o.date_added) >= '" . $this->db->escape($date_start) . "'
				AND DATE(o.date_added) <= '" . $this->db->escape($date_end) . "'
				$filter_store_id_statement
				$filter_payment_status_statement
				$filter_payment_method_statement
			) a
			WHERE 
				1

		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getSalesSummaryTotalDoctor($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";
		
		$sql = "
		SELECT (SUM(ROUND(cst.value, 2)) - SUM(ROUND(cst2.value, 2))) as total
			FROM `oc_order` o
				LEFT JOIN 
					`oc_clinical_sale` cs
						ON o.order_id = cs.order_id
				LEFT JOIN 
					`oc_clinical_sale_total` cst
						ON cs.clinical_sale_id = cst.clinical_sale_id
				LEFT JOIN 
					`oc_clinical_sale_total` cst2
						ON cs.clinical_sale_id = cst2.clinical_sale_id
		WHERE 1
			AND cst.id = 2
			AND cst.code = 'sub_total'
			AND cst2.id = 1
			AND cst2.code = 'sub_total'
			AND cs.collect_consultation_price = '1'
			AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
			AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
			$filter_store_id_statement
			$filter_payment_status_statement
			$filter_payment_method_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	public function getSalesSummaryTotalServiceForm($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";
		
		$sql = "
		SELECT SUM(ROUND(st.value, 2)) as total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "service_form sf
		ON o.order_id = sf.order_id
		LEFT JOIN " . DB_PREFIX . "service_total st
		ON sf.service_form_id = st.service_form_id
		WHERE 1
		AND st.code = 'sub_total'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total'];
	}
	public function getSalesSummaryTotalExchangeSubtotal($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";
		
		$sql = "
		SELECT 
			SUM(ROUND(op.total_net_amount, 2)) AS total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_product op
		ON o.order_id = op.order_id
		WHERE 1
		AND o.payment_method = 'points'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	public function getSalesSummaryTotalExchangeTax($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";
		
		$sql = "
		SELECT 
			SUM(ROUND(op.total_tax, 2)) AS total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_product op
		ON o.order_id = op.order_id
		WHERE 1
		AND o.payment_method = 'points'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	public function getSalesSummaryTotalSubtotal($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";
		
		$sql = "
		SELECT SUM(ROUND(value, 2)) AS total
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'sub_total'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";
		$query = $this->db->query($sql);
		$total = $query->row['total'];
		return $total;
	}
	public function getSalesSummaryTotalTax($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";
		
		$sql = "
		SELECT SUM(ROUND(value, 2)) AS total_tax
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'tax'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";
		$query = $this->db->query($sql);
		$tax = $query->row['total_tax'];
		
		return $tax;
	}
	public function getSalesSummaryTotalRounding($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";
		
		$sql = "
		SELECT SUM(ROUND(ot.value, 2)) AS total_rounding
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'rounding'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_rounding'];
	}
	public function getSalesSummaryTotalShipping($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";
		
		$sql = "
		SELECT SUM(ROUND(value, 2)) AS total_shipping
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'shipping'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_shipping'];
	}
	public function getSalesSummaryTotalSales($data){
		$date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id = '" . (int)$data['filter_payment_status'] . "'" :
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" :
		"";
		
		$sql = "
		SELECT SUM(ROUND(value, 2)) AS total_sales
		FROM " . DB_PREFIX . "order_total ot
		INNER JOIN " . DB_PREFIX . "order o
		ON ot.order_id = o.order_id
		WHERE 1
		AND ot.code = 'total'
		AND date(o.date_added) >= '" . $this->db->escape($date_start) . "'
		AND date(o.date_added) <= '" . $this->db->escape($date_end) . "'
		$filter_store_id_statement
		$filter_payment_status_statement
		$filter_payment_method_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_sales'];
	}

	public function categorylist($data){

		$filter_category_id_statement = ($data['filter_category'] != '') ? 
		"AND cd.category_id in (" . $data['filter_category'] . ")" :
		"";

		$sql = "SELECT * FROM oc_category_description cd WHERE cd.language_id = '".$this->config->get('config_language_id')."' ";
		// echo"<pre>";
		// print_r($sql);
		// echo"</pre>";
		$query = $this->db->query($sql);
		return $query->rows;
	}
    public function getcategoryhodtotal($data){

		$language_id = $this->config->get('config_language_id');

        $date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_batch_date_from = (!empty($data['filter_date_start']))?
		" AND DATE(IFNULL(o.invoice_date,o.date_added)) >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";
		

		$filter_batch_date_to = (!empty($data['filter_date_end']))?
		" AND DATE(IFNULL(o.invoice_date,o.date_added)) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id  in (" . $data['filter_payment_status'] . ")" :
		"";
		
		$filter_category_id_statement = (($data['filter_category'] != '')) ? 
		"AND IFNULL(ptc.category_id,0) in (" . $data['filter_category'] . ")" :
		"";
		// $filter_category = (!empty($data['filter_category'])) ? 
		// "AND o.order_id = op_order.order_id" :
		// "";
        // $sql="SELECT COUNT(DISTINCT(op.order_id)) as total_sale ,sum(op.total_net_amount) as total FROM oc_order_product op
		// LEFT JOIN  oc_order o
		// ON op.order_id = o.order_id
		// LEFT JOIN oc_product_to_category ptc
		// ON op.product_id = ptc.product_id
        // LEFT JOIN oc_category_description cd
        // ON ptc.category_id = cd.category_id AND cd.language_id = '".$language_id."' 
		
		// WHERE 1 
		// $filter_category_id_statement
        // $filter_batch_date_from
        // $filter_batch_date_to
        // $filter_payment_status_statement
        
        
        // ";
		$sql="SELECT cd.category_id , cd.name as name ,IFNULL(sum(category.order_id),0) as total_sale, IFNULL(sum(category.total_amount),0) as total_amount
		FROM
			   oc_category_description cd
			   
			   LEFT JOIN (SELECT ptc.category_id as category_id, COUNT(DISTINCT(op.order_id))as order_id , sum(op.total_net_amount) as total_amount  FROM  oc_order_product op
			   LEFT JOIN  oc_order o
			   ON op.order_id = o.order_id
				LEFT JOIN oc_product_to_category ptc
				ON op.product_id = ptc.product_id
				WHERE 1 
				$filter_batch_date_from
				$filter_batch_date_to
				$filter_payment_status_statement 
				$filter_category_id_statement 
				GROUP BY category_id ) category
				ON cd.category_id = category.category_id	
				WHERE 1 AND cd.language_id = '".$language_id."'
				GROUP BY category_id
			   
	   UNION ALL 
			   
				SELECT 0 AS category_id,
				'NO CATEGORY' as name,
				IFNULL(COUNT(DISTINCT(op.order_id)),0) as total_sale ,
				IFNULL(sum(op.total_net_amount),0) as total_amount 
				FROM oc_order_product op
				LEFT JOIN  oc_order o
				ON op.order_id = o.order_id
				LEFT JOIN oc_product_to_category ptc
				ON op.product_id = ptc.product_id
		
				WHERE 1 AND ptc.category_id is null 
				$filter_batch_date_from
				$filter_batch_date_to
				$filter_payment_status_statement
				$filter_category_id_statement ";
		// echo"<pre>";
		// print_r($sql);
		// echo"</pre>";
        $query = $this->db->query($sql);
		// echo"<pre>";
		// print_r($query);
		// echo"</pre>";
		return $query->rows;
    }
	public function getnocategoryhodtotal($data){

		$language_id = $this->config->get('config_language_id');

        $date_start = (!empty($data['filter_date_start'])) ? $data['filter_date_start'] : date("Y-m-01");
		$date_end = (!empty($data['filter_date_end'])) ? $data['filter_date_end'] : date("Y-m-t");

		$filter_batch_date_from = (!empty($data['filter_date_start']))?
		" AND o.date_added >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";
		

		$filter_batch_date_to = (!empty($data['filter_date_end']))?
		" AND o.date_added <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id  in (" . $data['filter_payment_status'] . ")" :
		"";
		
		$filter_category_id_statement = (!empty($data['filter_category'])) ? 
		"AND IFNULL(ptc.category_id,0) in (" . $data['filter_category'] . ")" :
		"";
        $sql="SELECT COUNT(DISTINCT(op.order_id)) as total_sale ,sum(op.total_net_amount) as total FROM oc_order_product op
		LEFT JOIN  oc_order o
		ON op.order_id = o.order_id
		LEFT JOIN oc_product_to_category ptc
		ON op.product_id = ptc.product_id
        LEFT JOIN oc_category_description cd
        ON ptc.category_id = cd.category_id AND cd.language_id = '".$language_id."' 
		
		WHERE 1 
		AND IFNULL(ptc.category_id,0) in ('0')
        $filter_batch_date_from
        $filter_batch_date_to
        $filter_payment_status_statement
        $filter_category_id_statement
        
        ";
		// echo"<pre>";
		// print_r($sql);
		// echo"</pre>";
        $query = $this->db->query($sql);
		return $query->rows;
    }

    public function getcategoryhodTotalnumber($data) {

		$language_id = $this->config->get('config_language_id');

		$filter_batch_date_from = (!empty($data['filter_date_start']))?
		" AND o.date_added >= '" . $this->db->escape($data['filter_date_start']) . "'" :
		"";
		

		$filter_batch_date_to = (!empty($data['filter_date_end']))?
		" AND o.date_added <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id  in (" . $data['filter_payment_status'] . ")" :
		"";
		
		$filter_category_id_statement = (!empty($data['filter_category'])) ? 
		"AND cd.category_id in (" . $data['filter_category'] . ")" :
		"";
        $sql= "SELECT count(cd.category_id) +1 as category
		FROM
			   oc_category_description cd
			   
			   LEFT JOIN (SELECT ptc.category_id as category_id, COUNT(DISTINCT(op.order_id))as order_id , sum(op.total_net_amount) as total_amount  FROM  oc_order_product op
			   LEFT JOIN  oc_order o
			   ON op.order_id = o.order_id
				LEFT JOIN oc_product_to_category ptc
				ON op.product_id = ptc.product_id
				WHERE 1 
				
				GROUP BY category_id ) category
				ON cd.category_id = category.category_id	
				WHERE 1 AND cd.language_id = '".$language_id."'
			   
	  
		
		";
			
        $query = $this->db->query($sql);
		return $query->row['category'];
    }

	public function getCategories()
    {
        $query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "category_description WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND category_id ORDER BY category_id asc");

        return $query->rows;

    }


}
?>