<?php
class ModelReportProductStockIssue extends Model{
    public function getStockIssueProducts($data){
        $sql = "SELECT si.*, sii.*, CONCAT(u.firstname, ' ', u.lastname) AS staff_name, p.code, pden.name AS english_name, pdcn.name AS chinese_name
                FROM " . DB_PREFIX . "stock_issue_item sii
                LEFT JOIN " . DB_PREFIX . "stock_issue si
                ON si.stock_issue_id = sii.stock_issue_id
                LEFT JOIN " . DB_PREFIX . "product p
                ON p.product_id = sii.product_id
                LEFT JOIN " . DB_PREFIX . "product_description pden
                ON pden.product_id = sii.product_id
                AND pden.language_id = '1'
                LEFT JOIN " . DB_PREFIX . "product_description pdcn
                ON pdcn.product_id = sii.product_id
                AND pdcn.language_id = '2'
                LEFT JOIN " . DB_PREFIX . "user u
                ON u.user_id = si.add_by
                WHERE 1";

        if(!empty($data['filter_transaction_num_start'])){
            $sql .= " AND si.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_num_start']) . "'";
        }

        if(!empty($data['filter_transaction_num_end'])){
            $sql .= " AND si.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_num_end']) . "'";
        }

        if(!empty($data['filter_staff_name'])){
            $sql .= " AND CONCAT(u.firstname, ' ', u.lastname) LIKE '%" . $this->db->escape($data['filter_staff_name']) . "%'";
        }

        if(!empty($data['filter_date_from'])){
            $sql .= " AND DATE(si.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_from']))) . "'";
        }

        if(!empty($data['filter_date_to'])){
            $sql .= " AND DATE(si.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_to']))) . "'";
        }

        if(!empty($data['filter_product_code'])){
            $sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'";
        }

        if(!empty($data['filter_product_name'])){
            $sql .= " AND pden.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'";
        }

        if(!empty($data['filter_description'])){
            $sql .= " AND si.description LIKE '%" . $this->db->escape($data['filter_description']) . "%'";
        }

        if($data['filter_store_id'] != ''){
            $sql .= " AND si.store_id = '" . (int)$data['filter_store_id'] . "'";
        }

        $sort_data = array(
			'english_name',
			'chinese_name',
            'staff_name',
            'p.code',
			'si.description',
			'si.date_added',
			'si.invoice_prefix',
			'sii.quantity'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY si.invoice_prefix";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalStockIssueProducts($data){
        $sql = "SELECT COUNT(*) AS total
                FROM " . DB_PREFIX . "stock_issue_item sii
                LEFT JOIN " . DB_PREFIX . "stock_issue si
                ON si.stock_issue_id = sii.stock_issue_id
                LEFT JOIN " . DB_PREFIX . "product p
                ON p.product_id = sii.product_id
                LEFT JOIN " . DB_PREFIX . "product_description pden
                ON pden.product_id = sii.product_id
                AND pden.language_id = '1'
                LEFT JOIN " . DB_PREFIX . "product_description pdcn
                ON pdcn.product_id = sii.product_id
                AND pdcn.language_id = '2'
                LEFT JOIN " . DB_PREFIX . "user u
                ON u.user_id = si.add_by
                WHERE 1";

        if(!empty($data['filter_transaction_num_start'])){
            $sql .= " AND si.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_num_start']) . "'";
        }

        if(!empty($data['filter_transaction_num_end'])){
            $sql .= " AND si.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_num_end']) . "'";
        }

        if(!empty($data['filter_staff_name'])){
            $sql .= " AND CONCAT(u.firstname, ' ', u.lastname) LIKE '%" . $this->db->escape($data['filter_staff_name']) . "%'";
        }

        if(!empty($data['filter_date_from'])){
            $sql .= " AND DATE(si.date_added) >= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_from']))) . "'";
        }

        if(!empty($data['filter_date_to'])){
            $sql .= " AND DATE(si.date_added) <= '" . $this->db->escape(date('Y-m-d', strtotime($data['filter_date_to']))) . "'";
        }

        if(!empty($data['filter_product_code'])){
            $sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'";
        }

        if(!empty($data['filter_product_name'])){
            $sql .= " AND pden.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'";
        }

        if(!empty($data['filter_description'])){
            $sql .= " AND si.description LIKE '%" . $this->db->escape($data['filter_description']) . "%'";
        }

        if($data['filter_store_id'] != ''){
            $sql .= " AND si.store_id = '" . (int)$data['filter_store_id'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }
}
?>
