<?php
class ModelReportProductSerialNum extends Model {
    public function getSerialNums($data) {
        $sql = "SELECT p.production_id, p.invoice_prefix, pd.name AS product_name, p.serial_num, p.production_date, p.expiry_date, p.quantity, p.actual_quantity, p.status FROM " . DB_PREFIX . "production p LEFT JOIN " . DB_PREFIX . "product_description pd ON pd.product_id = p.product_id AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE 1";

        if (!empty($data['filter_production_date_from'])) {
            $sql .= " AND DATE(p.production_date) >= DATE('" . $this->db->escape($data['filter_production_date_from']) . "')";
        }

        if (!empty($data['filter_production_date_to'])) {
            $sql .= " AND DATE(p.production_date) <= DATE('" . $this->db->escape($data['filter_production_date_to']) . "')";
        }

        if (!empty($data['filter_expiry_date_from'])) {
            $sql .= " AND DATE(p.expiry_date) >= DATE('" . $this->db->escape($data['filter_expiry_date_from']) . "')";
        }

        if (!empty($data['filter_expiry_date_to'])) {
            $sql .= " AND DATE(p.expiry_date) <= DATE('" . $this->db->escape($data['filter_expiry_date_to']) . "')";
        }

        if (!empty($data['filter_invoice_prefix'])) {
            $sql .= " AND p.invoice_prefix LIKE '%" . $this->db->escape($data['filter_invoice_prefix']) . "%'";
        }

        if (!empty($data['filter_serial_num'])) {
            $sql .= " AND p.serial_num LIKE '%" . $this->db->escape($data['filter_serial_num']) . "%'";
        }

        if (!empty($data['filter_product_name'])) {
            $sql .= " AND pd.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'";
        }

        if (!empty($data['filter_status'])) {
            $sql .= " AND p.status = '" . (int)$data['filter_status'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_production_qc($production_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "production_qc WHERE production_id = '" . (int)$production_id . "' ORDER BY date_added DESC";
        
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_scanned_production($production_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "order_product_serial WHERE production_id = '" . (int)$production_id . "' ORDER BY date_added DESC";
        
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_order_scanned($production_id) {
        $sql = "SELECT ops.ops_id, op.order_product_id, op.order_id FROM " . DB_PREFIX . "order_product_serial ops LEFT JOIN " . DB_PREFIX . "order_product op ON op.order_product_id = ops.order_product_id WHERE ops.production_id = '" . (int)$production_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_order_product($order_product_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "order_product WHERE order_product_id = '" . (int)$order_product_id . "'";
        
        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_order($order_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "order WHERE order_id = '" . (int)$order_id . "'";
        
        $query = $this->db->query($sql);

        return $query->row;
    }
}
?>