<?php
class ModelReportProductMovement extends Model
{
    public function productStockExists($product_id)
    {
        $this->printTime(__FUNCTION__, 'Start');
        $language_id = $this->config->get('config_language_id');

        $sql = "
        SELECT
                COUNT(*) AS total
            FROM
                `oc_product_to_store` pts
                LEFT JOIN
                    `oc_product` p
                        ON pts.product_id = p.product_id
            WHERE
                1
                AND p.product_id <>''
                AND pts.product_id = '" . (int)$product_id . "'
            GROUP BY
                pts.product_id
            ";

        $query = $this->db->query($sql);
        $total = isset($query->row['total']) ? $query->row['total'] : 0;

        $this->printTime(__FUNCTION__, 'End');

        if ($product_id == 0) {
            return true;
        } else {
            return  $total > 0;
        }
    }

    public function getStockCalculation($product_id, $data)
    {
        $this->printTime(__FUNCTION__, 'Start');
        $open_date = !empty($data['filter_open_date']) ? $data['filter_open_date'] : '1970-01-01';

        $close_date = !empty($data['filter_close_date']) ? $data['filter_close_date'] : date('Y-m-d');


        $store_id = $data['filter_store_id'] != '' ? $data['filter_store_id'] : '';

        $store_id_statement = $data['filter_store_id'] != ''  ? "AND a.store_id in ( " . $store_id . ")" : '';

        $location_id_statement = $data['filter_location'] != ''  ? "AND a.location_id in ( " . $data['filter_location'] . ")" : '';

        $filter_date='';
        if(!empty($data['filter_batch_date_start'])){
            $date = explode(',',$data['filter_batch_date_start']);
            if(!empty($date)){
                $date_sql='';
                foreach($date as $dates){
                    $date_sql .=",'" . $dates . "'";
                }
                $batch_date = substr($date_sql,1);
            }
        }

        $batch_date_start_statement = $data['filter_batch_date_start'] != '' ? "AND a.batch_date in ( " . $batch_date . ")" : '';

        // $batch_date_end_statement = $data['filter_batch_date_end'] != '' ? "AND a.batch_date <= '" . $data['filter_batch_date_end'] . "'" : '';

        $product_name_statement = $data['filter_product_name'] != '' ? "AND CONCAT(en.name,' ',cn.name) LIKE '%" . $data['filter_product_name'] . "%'" : '';

        $product_code_statement = $data['filter_product_code'] != '' ? "AND p.code LIKE '%" . $data['filter_product_code'] . "%'" : '';


        $filter_doc_type = '';
        if (!empty($data['filter_doc_type'])) {
            $doc_types = explode(',',$data['filter_doc_type']);
            if (!empty($doc_types)) {
                $doc_type_sql = '';
                foreach ($doc_types as $doc) {
                    $doc_type_sql .=  ",'" . $doc . "'";
                }
                $doc_type_data = substr($doc_type_sql,1);
                //$filter_doc_type = " AND a.type IN (" . $this->db->escape($doc_type_sql) . ")";
            }
        }
        
        $filter_doc_type_data = $data['filter_doc_type'] != '' ? " AND a.type IN (" . $doc_type_data . ")" : '';

        $description_statement = $data['filter_description'] != '' ? "AND a.remark LIKE '%" . $this->db->escape($data['filter_description']) . "%'" : '';
        if ($product_id == 0) {
            $product_statement = '';
        } else {
            $product_statement = "AND a.product_id = '" . (int)$product_id . "'";
        }

        $start_date = $this->db->escape($open_date) .  " 00:00:00";
        $end_date  = $this->db->escape($close_date) .  " 23:59:59";

        $sql = "
		SELECT
			SUM(b.add) AS total_add,
            SUM(b.deduct) AS total_deduct
		FROM
		(
               
            SELECT
            a.date_added,
            a.type,
            a.product_id,
            pd.name AS product_name,
            p.code AS product_code,
            a.id,
            a.name,
            a.person_type,
            a.action,
            a.quantity,
            a.add,
            a.deduct,
            a.store_id,
            a.location_id,
            a.batch_date
        FROM
        (
            #stock return
            SELECT
                    sr.doc_date as date_added,
                    'Stock Return' AS type,
                    sr.product_id,
                    sr.doc_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    sr.action,
                    sr.qty AS quantity,
                    (CASE WHEN sr.action=1 THEN sr.qty ELSE NULL END) AS 'add',
                    (CASE WHEN sr.action=1 THEN NULL ELSE sr.qty END) AS deduct,
                    0 AS store_id,
                    sr.location_id,
                    (CASE WHEN sr.batch_date is NULL THEN '0000-00-00' ELSE sr.batch_date END) AS batch_date,
                    sr.description AS remark,
                    1 AS stock_type
                FROM
                    `oc_stock_return` sr
                        LEFT JOIN
                            `oc_user` u
                                ON sr.added_by = u.user_id
                WHERE
                    1
                    AND sr.doc_date >=  '" . $this->db->escape($start_date) . "'
                    AND sr.doc_date <= '" . $this->db->escape($end_date) . "'
                    AND sr.status   = 5

            UNION ALL
            #stock take
            SELECT
                    st.date_added as date_added,
                    'Stock Take' AS type,
                    stp.product_id,
                    st.doc_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    stp.qty AS quantity,
                    stp.qty AS 'add',
                    NULL AS deduct,
                    st.store_id,
                    stp.location_id,
                    (CASE WHEN stp.batch_date is NULL THEN '0000-00-00' ELSE stp.batch_date END) AS batch_date,
                    stp.remark,
                    1 AS stock_type
                FROM
                    `oc_stock_take_product` stp
                        LEFT JOIN
                            `oc_stock_take` st
                                ON stp.stock_take_id = st.stock_take_id
                        LEFT JOIN
                            `oc_user` u
                                ON stp.added_by = u.user_id
                WHERE
                    1
                    AND st.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND st.date_added <= '" . $this->db->escape($end_date) . "'
                    AND st.status   = 5

            UNION ALL
            #lot transfer out
            SELECT
                    lt.doc_date as date_added,
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    lt.doc_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    0 AS action,
                    ltp.qty AS quantity,
                    NULL AS 'add',
                    ltp.qty AS deduct,
                    lt.store_id,
                    ltp.source_location_id as location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date,
                    ltp.remark,
                    1 AS stock_type
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON ltp.added_by = u.user_id
                WHERE
                    1
                    AND lt.doc_date >=  '" . $this->db->escape($start_date) . "'
                    AND lt.doc_date <= '" . $this->db->escape($end_date) . "'
                    AND lt.status   = 5

            UNION ALL
            #lot transfer in
            SELECT
                    lt.doc_date as date_added,
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    lt.doc_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    ltp.qty AS quantity,
                    ltp.qty AS 'add',
                    NULL AS deduct,
                    lt.store_id,
                    ltp.target_location_id as location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date,
                    ltp.remark,
                    1 AS stock_type
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON ltp.added_by = u.user_id
                WHERE
                    1
                    AND lt.doc_date >=  '" . $this->db->escape($start_date) . "'
                    AND lt.doc_date <= '" . $this->db->escape($end_date) . "'
                    AND lt.status   = 5

            UNION ALL
            #stock received
            SELECT
                    srv.date_added,
                    'Stock Received' AS type,
                    srp.product_id,
                    srv.doc_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    srp.quantity AS quantity,
                    srp.quantity AS 'add',
                    NULL AS deduct,
                    srv.store_id,
                    srp.location_id,
                    (CASE WHEN srp.batch_date is NULL THEN '0000-00-00' ELSE srp.batch_date END) AS batch_date,
                    srp.reason AS remark,
                    1 AS stock_type
                FROM
                    `oc_stock_received_product` srp
                        LEFT JOIN
                            `oc_stock_received` srv
                                ON srp.stock_received_id = srv.stock_received_id
                        LEFT JOIN
                            `oc_user` u
                                ON srp.added_by = u.user_id
                WHERE
                    1
                    AND srv.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND srv.date_added <= '" . $this->db->escape($end_date) . "'
                    AND srv.status   = 5

            UNION ALL

            #stock adjustment
            SELECT
                    sai.date_added,
                    'Stock Adjustment' AS type,
                    sai.product_id,
                    sa.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    sai.action,
                    sai.qty AS quantity,
                    (CASE WHEN sai.action = 1 THEN sai.qty
                    ELSE NULL END) AS 'add',
                    (CASE WHEN sai.action = 1 THEN NULL
                    ELSE sai.qty END) AS deduct,
                    sa.store_id,
                    sai.location_id,
                    (CASE WHEN sai.batch_date is NULL THEN '0000-00-00' ELSE sai.batch_date END) AS batch_date,
                    sa.description as remark,
                    1 AS stock_type
                FROM
                    `oc_stock_adjustment_item` sai
                        LEFT JOIN
                            `oc_stock_adjustment` sa
                                ON sai.stock_adjustment_id = sa.stock_adjustment_id
                        LEFT JOIN
                            `oc_user` u
                                ON sa.add_by = u.user_id
                WHERE
                    1
                    AND sai.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND sai.date_added <= '" . $this->db->escape($end_date) . "'
                    AND sa.status   = 5

            UNION ALL

            #stock issue
            SELECT
                    sii.date_added,
                    'Stock Issue' AS type,
                    sii.product_id,
                    si.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    0 AS action,
                    sii.quantity,
                    NULL AS 'add',
                    sii.quantity AS deduct,
                    si.store_id,
                    sii.location_id,
                    (CASE WHEN sii.batch_date is NULL THEN '0000-00-00' ELSE sii.batch_date END) AS batch_date,
                    sii.remark,
                    1 AS stock_type
                FROM
                    `oc_stock_issue_item` sii
                        LEFT JOIN
                            `oc_stock_issue` si
                                ON sii.stock_issue_id = si.stock_issue_id
                        LEFT JOIN
                            `oc_user` u
                                ON si.add_by = u.user_id
                WHERE
                    1
                    AND sii.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND sii.date_added <= '" . $this->db->escape($end_date) . "'
                    AND si.status   = 5

            UNION ALL

            #received from store,出货
            SELECT
                    st.received_date as date_added,
                    'Stock Transfer' AS type,
                    std.product_id,
                    st.transfer_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    (CASE WHEN st.from_store in ($store_id) THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    (CASE WHEN st.from_store in ($store_id) THEN std.received_quantity ELSE NULL END) AS 'add',
                    (CASE WHEN st.to_store in ($store_id) THEN std.received_quantity ELSE NULL END) AS deduct,
                    st.to_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    st.remark,
                    2 AS stock_type
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON st.created_by = u.user_id
                WHERE
                    1
                    AND std.received_quantity > 0
                    AND st.received_date >=  '" . $this->db->escape($start_date) . "'
                    AND st.received_date <= '" . $this->db->escape($end_date) . "'
                    AND st.status >= 4

            UNION ALL

            #tranfer to store,进货
            SELECT
                    st.transfer_date as date_added,
                    'Stock Transfer' AS type,
                    std.product_id,
                    st.transfer_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    (CASE WHEN st.from_store in ($store_id) THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    (CASE WHEN st.from_store in ($store_id) THEN std.received_quantity ELSE NULL END) AS 'add',
                    (CASE WHEN st.to_store in ($store_id) THEN std.received_quantity ELSE NULL END) AS deduct,
                    st.from_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    st.remark,
                    2 AS stock_type
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON st.created_by = u.user_id
                WHERE
                    1
                    AND std.received_quantity > 0
                    AND st.transfer_date >=  '" . $this->db->escape($start_date) . "'
                    AND st.transfer_date <= '" . $this->db->escape($end_date) . "'
                    AND st.status >= 4

            UNION ALL

            #sold sale order
            SELECT
                    o.date_added,
                    'Order' AS type,
                    op.product_id,
                    o.invoice_prefix AS id,
                    CONCAT(o.firstname, ' ', o.lastname) AS name,
                    2 AS person_type,
                    0 as action,
                    ROUND(op.weight,2) AS quantity,
                    NULL as 'add',
                    ROUND(op.weight,2) AS deduct,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    o.comment as remark,
                    3 AS stock_type
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN
                            `oc_weight_class` wc
                                ON op.weight_class_id = wc.weight_class_id
                WHERE
                    1
                    AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 0

            UNION ALL
            
            #sold order wholesaler
            SELECT
                    o.date_added,
                    'Wholesale Order' AS type,
                    op.product_id,
                    o.invoice_prefix AS id,
                    CONCAT(o.firstname, ' ', o.lastname) AS name,
                    2 AS person_type,
                    0 as action,
                    ROUND(op.total_weight,2) AS quantity,
                    NULL as 'add',
                    ROUND(op.total_weight,2) AS deduct,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    o.comment as remark,
                    3 AS stock_type
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN
                            `oc_weight_class` wc
                                ON op.weight_class_id = wc.weight_class_id
                WHERE
                    1
                    AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 1

            UNION ALL

            #herbal remedies
            SELECT
                    o.date_added,
                    'Herbal Remedies' AS type,
                    csp.product_id,
                    CONCAT(o.invoice_prefix,'-',cs.invoice_prefix) AS id,
                    CONCAT(o.firstname, ' ', o.lastname) AS name,
                    2 AS person_type,
                    0 as action,
                    t_weight AS quantity,
                    NULL AS 'add',
                    t_weight AS deduct,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    cs.remark,
                    3 stock_type
                FROM
                    `oc_clinicalsale_product` csp
                        LEFT JOIN
                            `oc_clinical_sale` cs
                                ON csp.clinical_sale_id = cs.clinical_sale_id
                        LEFT JOIN
                            `oc_order` o
                                ON cs.order_id = o.order_id
                WHERE
                    1
                    AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''

            UNION ALL

            #purchase receive
            SELECT
                    pr.date_added,
                    'Purchase Received' AS type,
                    prp.product_id,
                    pr.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    prp.quantity,
                    prp.quantity AS 'add',
                    NULL AS deduct,
                    pr.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    pr.comment as remark,
                    4 AS stock_type
                FROM
                    `oc_purchase_receive_product` prp
                        LEFT JOIN
                            `oc_purchase_receive` pr
                                ON prp.purchase_receive_id = pr.purchase_receive_id
                        LEFT JOIN
                            `oc_user` u
                                ON pr.add_by = u.user_id
                WHERE
                    1
                    AND pr.order_status_id = '5'
                    AND pr.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND pr.date_added <= '" . $this->db->escape($end_date) . "'

            UNION ALL

            #purchase invoice
            SELECT
                    pi.date_added,
                    'Purchase Invoice' AS type,
                    pip.product_id,
                    pi.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    pip.quantity,
                    pip.quantity AS 'add',
                    NULL AS deduct,
                    pi.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    pi.comment as remark,
                    5 AS stock_type
                FROM
                    `oc_purchase_invoice_product` pip
                        LEFT JOIN
                            `oc_purchase_invoice` pi
                                ON pip.purchase_invoice_id = pi.purchase_invoice_id
                        LEFT JOIN
                            `oc_user` u
                                ON pi.add_by = u.user_id
                WHERE
                    1
                    AND pip.product_id != 0
                    AND pi.type IN (3, 5, 6)
                    AND pi.stock_affect = '1'
                    AND pi.order_status_id = '5'
                    AND pi.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND pi.date_added <= '" . $this->db->escape($end_date) . "'

            UNION ALL

            #production
            SELECT
                    p.date_added,
                    'Production' AS type,
                    ps.product_id,
                    p.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    2 AS person_type,
                    0 as action,
                    ps.quantity,
                    NULL AS 'add',
                    ps.quantity AS deduct,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    p.remark,
                    6 stock_type
                FROM
                    `oc_production` p
                        LEFT JOIN
                            `oc_production_stock` ps
                                ON ps.production_id = p.production_id
                        LEFT JOIN
                            `oc_user` u
                                ON p.add_by = u.user_id
                WHERE
                    1
                    AND ps.product_id != 0
                    AND p.status = '5'
                    AND p.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND p.date_added <= '" . $this->db->escape($end_date) . "'

            UNION ALL

            #production add stock
            SELECT
                    p.date_added,
                    'Production' AS type,
                    p.product_id,
                    p.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    (p.actual_quantity - a.total_reject_quantity) AS quantity,
                    (p.actual_quantity - a.total_reject_quantity) AS 'add',
                    NULL AS deduct,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    p.remark,
                    7 AS stock_type
                FROM
                    `oc_production` p
                    LEFT JOIN 
                        (SELECT pro.production_id, (CASE WHEN SUM(proqc.reject_quantity) IS NULL THEN 0 ELSE SUM(proqc.reject_quantity) END) AS total_reject_quantity 
                            FROM `" . DB_PREFIX . "production` pro 
                            LEFT JOIN `oc_production_qc` proqc 
                            ON proqc.production_id = pro.production_id 
                            GROUP BY pro.production_id)a 
                        ON a.production_id = p.production_id 
                        LEFT JOIN
                            `oc_user` u
                                ON p.add_by = u.user_id
                WHERE
                    1
                    AND p.product_id != 0
                    AND p.status = '5'
                    AND DATE(p.date_added) >=  DATE('" . $this->db->escape($start_date) . "')
                    AND DATE(p.date_added) <= DATE('" . $this->db->escape($end_date) . "') 
            ) a

        LEFT JOIN " . DB_PREFIX . "product p
        ON(a.product_id = p.product_id )

        LEFT JOIN " . DB_PREFIX . "product_description pd
        ON(a.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

        LEFT JOIN " . DB_PREFIX . "product_description cn
        ON (p.product_id = cn.product_id AND cn.language_id = '2')

        LEFT JOIN " . DB_PREFIX . "product_description en
        ON (p.product_id = en.product_id AND en.language_id = '1')

        WHERE 1
        $product_statement
        $store_id_statement
        $location_id_statement
        $batch_date_start_statement
        $product_name_statement
        $product_code_statement
        $filter_doc_type_data
        $description_statement
		) b
		";

        $query = $this->db->query($sql);
        $this->printTime(__FUNCTION__, 'End');
        return $query->row;
    }

    public function getProductStockInfo($product_id, $data)
    {
        $this->printTime(__FUNCTION__, 'Start');
        $open_date = !empty($data['filter_open_date']) ? $data['filter_open_date'] : '1970-01-01';

        $close_date = !empty($data['filter_close_date']) ? $data['filter_close_date'] : date('Y-m-d');


        $store_id = $data['filter_store_id'] != '' ? $data['filter_store_id'] : '';

        $store_id_statement = $data['filter_store_id'] != ''  ? "AND a.store_id in ( " . $store_id . ")" : '';

        $location_id_statement = $data['filter_location'] != ''  ? "AND a.location_id in ( " . $data['filter_location'] . ")" : '';

        $filter_batch_date_start= isset($data['filter_batch_date_start']) ? explode(',', $data['filter_batch_date_start']) : array();

        $filter_batch_date_start_statement = "";

        foreach ($filter_batch_date_start as $filter_batch_date_starts) {
            $filter_batch_date_start_statement .= empty($filter_batch_date_start_statement) ? "a.batch_date LIKE '%" . $filter_batch_date_starts . "%'" : " OR a.batch_date LIKE '%" . $filter_batch_date_starts . "%'";
        }

        $filter_batch_date_start_statement = !empty($filter_batch_date_start_statement) ? "AND ($filter_batch_date_start_statement)" : "";

        // $filter_date='';
        // if(!empty($data['filter_batch_date_start'])){
        //     $date = explode(',',$data['filter_batch_date_start']);
        //     if(!empty($date)){
        //         $date_sql='';
        //         foreach($date as $dates){
        //             $date_sql .=",'" . $dates . "'";
        //         }
        //         $batch_date = substr($date_sql,1);
        //     }
        // }

        // $batch_date_start_statement = $data['filter_batch_date_start'] != '' ? "AND a.batch_date in ( " . $batch_date . ")" : '';

        // $batch_date_end_statement = $data['filter_batch_date_end'] != '' ? "AND a.batch_date <= '" . $data['filter_batch_date_end'] . "'" : '';

        $product_name_statement = $data['filter_product_name'] != '' ? "AND CONCAT(en.name,' ',cn.name) LIKE '%" . $data['filter_product_name'] . "%'" : '';

        $product_code_statement = $data['filter_product_code'] != '' ? "AND p.code LIKE '%" . $data['filter_product_code'] . "%'" : '';


        $filter_doc_type = '';
        if (!empty($data['filter_doc_type'])) {
            $doc_types = explode(',',$data['filter_doc_type']);
            if (!empty($doc_types)) {
                $doc_type_sql = '';
                foreach ($doc_types as $doc) {
                    $doc_type_sql .=  ",'" . $doc . "'";
                }
                $doc_type_data = substr($doc_type_sql,1);
                //$filter_doc_type = " AND a.type IN (" . $this->db->escape($doc_type_sql) . ")";
            }
        }
        
        $filter_doc_type_data = $data['filter_doc_type'] != '' ? " AND a.type IN (" . $doc_type_data . ")" : '';

        $description_statement = $data['filter_description'] != '' ? "AND a.remark LIKE '%" . $this->db->escape($data['filter_description']) . "%'" : '';
        if ($product_id == 0) {
            $product_statement = '';
        } else {
            $product_statement = "AND a.product_id = '" . (int)$product_id . "'";
        }


        $limit_statement = "";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $start_date = $this->db->escape($open_date) .  " 00:00:00";
        $end_date  = $this->db->escape($close_date) .  " 23:59:59";

        $sqlSet = "SET @stock = " . (float)$this->getStock($start_date, $product_id, $data);
        $querySet = $this->db->query($sqlSet);

        $sql = "
        SELECT
                a.date_added,
                a.type,
                a.product_id,
                pd.name AS product_name,
                p.code AS product_code,
                a.id,
                a.name,
                a.person_type,
                a.action,
                a.quantity,
                a.add,
                a.deduct,
                a.store_id,
                a.location_id,
                a.batch_date,
                a.remark,
                a.stock_type,
                a.product_description,
		        (CASE WHEN action = 1 THEN @stock := @stock + a.quantity
		        ELSE @stock := @stock - a.quantity END) AS balance
		    FROM
		    (
			#stock return
			SELECT
				    sr.doc_date as date_added,
                    'Stock Return' AS type,
				    sr.product_id,
				    sr.doc_no AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    sr.action,
				    sr.qty AS quantity,
                    (CASE WHEN sr.action=1 THEN sr.qty ELSE NULL END) AS 'add',
                    (CASE WHEN sr.action=1 THEN NULL ELSE sr.qty END) AS deduct,
				    0 AS store_id,
				    sr.location_id,
                    (CASE WHEN sr.batch_date is NULL THEN '0000-00-00' ELSE sr.batch_date END) AS batch_date,
				    sr.description AS remark,
				    1 AS stock_type,
                    ''AS product_description
			    FROM
				    `oc_stock_return` sr
                        LEFT JOIN
                            `oc_user` u
                                ON sr.added_by = u.user_id
                WHERE
                    1
                    AND sr.doc_date >=  '" . $this->db->escape($start_date) . "'
                    AND sr.doc_date <= '" . $this->db->escape($end_date) . "'
                    AND sr.status   = 5

			UNION ALL

			#stock take
			SELECT
				    st.date_added as date_added,
                    'Stock Take' AS type,
				    stp.product_id,
				    st.doc_no AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    1 AS action,
				    stp.qty AS quantity,
                    stp.qty AS 'add',
                    NULL AS deduct,
				    st.store_id,
				    stp.location_id,
				    (CASE WHEN stp.batch_date is NULL THEN '0000-00-00' ELSE stp.batch_date END) AS batch_date,
				    st.description AS remark,
				    1 AS stock_type,
                    stp.remark AS product_description

			    FROM
				    `oc_stock_take_product` stp
                        LEFT JOIN
                            `oc_stock_take` st
                                ON stp.stock_take_id = st.stock_take_id
                        LEFT JOIN
                            `oc_user` u
                                ON stp.added_by = u.user_id
                WHERE
                    1
                    AND st.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND st.date_added <= '" . $this->db->escape($end_date) . "'
                    AND st.status   = 5

			UNION ALL
			#lot transfer out
			SELECT
				    lt.doc_date as date_added,
                    'Lot Transfer' AS type,
				    ltp.product_id,
				    lt.doc_no AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    0 AS action,
				    ltp.qty AS quantity,
                    NULL AS 'add',
                    ltp.qty AS deduct,
				    lt.store_id,
				    ltp.source_location_id as location_id,
				    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date,
				    lt.description AS remark,
				    1 AS stock_type,
                    ltp.remark AS product_description
			    FROM
				    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON ltp.added_by = u.user_id
                WHERE
                    1
                    AND lt.doc_date >=  '" . $this->db->escape($start_date) . "'
                    AND lt.doc_date <= '" . $this->db->escape($end_date) . "'
                    AND lt.status   = 5

			UNION ALL
			#lot transfer in
			SELECT
				    lt.doc_date as date_added,
                    'Lot Transfer' AS type,
				    ltp.product_id,
				    lt.doc_no AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    1 AS action,
				    ltp.qty AS quantity,
                    ltp.qty AS 'add',
                    NULL AS deduct,
				    lt.store_id,
				    ltp.target_location_id as location_id,
				    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date,
				    lt.description AS remark,
				    1 AS stock_type,
                    ltp.remark AS product_description
			    FROM
				    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON ltp.added_by = u.user_id
                WHERE
                    1
                    AND lt.doc_date >=  '" . $this->db->escape($start_date) . "'
                    AND lt.doc_date <= '" . $this->db->escape($end_date) . "'
                    AND lt.status   = 5

			UNION ALL
			#stock received
			SELECT
				    srv.date_added,
                    'Stock Received' AS type,
				    srp.product_id,
				    srv.doc_no AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    1 AS action,
				    srp.quantity AS quantity,
                    srp.quantity AS 'add',
                    NULL AS deduct,
				    srv.store_id,
				    srp.location_id,
				    (CASE WHEN srp.batch_date is NULL THEN '0000-00-00' ELSE srp.batch_date END) AS batch_date,
				    srv.description AS remark,
				    1 AS stock_type,
                    srp.description AS product_description
			    FROM
				    `oc_stock_received_product` srp
                        LEFT JOIN
                            `oc_stock_received` srv
                                ON srp.stock_received_id = srv.stock_received_id
                        LEFT JOIN
                            `oc_user` u
                                ON srp.added_by = u.user_id
                WHERE
                    1
                    AND srv.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND srv.date_added <= '" . $this->db->escape($end_date) . "'
                    AND srv.status   = 5

			UNION ALL
            #stock adjustment
			SELECT
				    sai.date_added,
                    'Stock Adjustment' AS type,
				    sai.product_id,
				    sa.invoice_prefix AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    sai.action,
				    sai.qty AS quantity,
                    (CASE WHEN sai.action = 1 THEN sai.qty
                    ELSE NULL END) AS 'add',
                    (CASE WHEN sai.action = 1 THEN NULL
                    ELSE sai.qty END) AS deduct,
				    sa.store_id,
                    sai.location_id,
                    (CASE WHEN sai.batch_date is NULL THEN '0000-00-00' ELSE sai.batch_date END) AS batch_date,
                    sa.description as remark,
				    1 AS stock_type,
                    sai.remark AS product_description
			    FROM
				    `oc_stock_adjustment_item` sai
                        LEFT JOIN
                            `oc_stock_adjustment` sa
                                ON sai.stock_adjustment_id = sa.stock_adjustment_id
                        LEFT JOIN
                            `oc_user` u
                                ON sa.add_by = u.user_id
                WHERE
                    1
                    AND sai.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND sai.date_added <= '" . $this->db->escape($end_date) . "'
                    AND sa.status   = 5

			UNION ALL

            #stock issue
            SELECT
				    sii.date_added,
                    'Stock Issue' AS type,
				    sii.product_id,
				    si.invoice_prefix AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
                    0 AS action,
				    sii.quantity,
                    NULL AS 'add',
                    sii.quantity AS deduct,
				    si.store_id,
                    sii.location_id,
                    (CASE WHEN sii.batch_date is NULL THEN '0000-00-00' ELSE sii.batch_date END) AS batch_date,
                    si.description AS remark,
				    1 AS stock_type,
                    sii.remark AS product_description
			    FROM
				    `oc_stock_issue_item` sii
                        LEFT JOIN
                            `oc_stock_issue` si
                                ON sii.stock_issue_id = si.stock_issue_id
                        LEFT JOIN
                            `oc_user` u
                                ON si.add_by = u.user_id
                WHERE
                    1
                    AND sii.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND sii.date_added <= '" . $this->db->escape($end_date) . "'
                    AND si.status   = 5

            UNION ALL

			#received from store,出货
			SELECT
				    st.received_date as date_added,
                    'Stock Transfer' AS type,
				    std.product_id,
				    st.transfer_no AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    (CASE WHEN st.from_store in ( " . $store_id . ") THEN 1 ELSE 0 END) AS action,
				    std.received_quantity AS quantity,
                    (CASE WHEN st.from_store in ( " . $store_id . ") THEN std.received_quantity ELSE NULL END) AS 'add',
                    (CASE WHEN st.to_store in ( " . $store_id . ") THEN std.received_quantity ELSE NULL END) AS deduct,
				    st.to_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    '' AS remark,
				    2 AS stock_type,
                    st.remark AS product_description
			    FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON st.created_by = u.user_id
                WHERE
                    1
                    AND std.received_quantity > 0
                    AND st.received_date >=  '" . $this->db->escape($start_date) . "'
                    AND st.received_date <= '" . $this->db->escape($end_date) . "'
                    AND st.status >= 4

			UNION ALL

			#tranfer to store,进货
			SELECT
				    st.transfer_date as date_added,
                    'Stock Transfer' AS type,
				    std.product_id,
				    st.transfer_no AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    (CASE WHEN st.from_store  in (" . $store_id . ") THEN 1 ELSE 0 END) AS action,
				    std.received_quantity AS quantity,
                    (CASE WHEN st.from_store  in (" . $store_id . ") THEN std.received_quantity ELSE NULL END) AS 'add',
                    (CASE WHEN st.to_store in (" . $store_id . ") THEN std.received_quantity ELSE NULL END) AS deduct,
				    st.from_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    '' AS remark,
				    2 AS stock_type,
                    st.remark AS product_description
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON st.created_by = u.user_id
                WHERE
                    1
                    AND std.received_quantity > 0
                    AND st.transfer_date >=  '" . $this->db->escape($start_date) . "'
                    AND st.transfer_date <= '" . $this->db->escape($end_date) . "'
                    AND st.status >= 4

			UNION ALL

			#sold sale order
			SELECT
				    o.date_added,
                    'Order' AS type,
				    op.product_id,
				    o.invoice_prefix AS id,
				    CONCAT(o.firstname, ' ', o.lastname) AS name,
				    2 AS person_type,
				    0 as action,
				    ROUND(op.weight,2) AS quantity,
                    NULL as 'add',
                    ROUND(op.weight,2) AS deduct,
				    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    o.comment as remark,
				    3 AS stock_type,
                    '' AS product_description
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
			                    ON op.order_id = o.order_id
                        LEFT JOIN
                            `oc_weight_class` wc
                                ON op.weight_class_id = wc.weight_class_id
                WHERE
                    1
                    AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 0

            UNION ALL
            
            #sold order wholesaler
			SELECT
				    o.date_added,
                    'Wholesale Order' AS type,
				    op.product_id,
				    o.invoice_prefix AS id,
				    CONCAT(o.firstname, ' ', o.lastname) AS name,
				    2 AS person_type,
				    0 as action,
				    ROUND(op.total_weight,2) AS quantity,
                    NULL as 'add',
                    ROUND(op.total_weight,2) AS deduct,
				    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    o.comment as remark,
				    3 AS stock_type,
                    '' AS product_description
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
			                    ON op.order_id = o.order_id
                        LEFT JOIN
                            `oc_weight_class` wc
                                ON op.weight_class_id = wc.weight_class_id
                WHERE
                    1
                    AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 1

            UNION ALL

            #herbal remedies
            SELECT
                    o.date_added,
                    'Herbal Remedies' AS type,
                    csp.product_id,
                    CONCAT(o.invoice_prefix,'-',cs.invoice_prefix) AS id,
                    CONCAT(o.firstname, ' ', o.lastname) AS name,
				    2 AS person_type,
                    0 as action,
                    t_weight AS quantity,
                    NULL AS 'add',
                    t_weight AS deduct,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    cs.remark,
                    3 stock_type,
                    '' AS product_description
                FROM
                    `oc_clinicalsale_product` csp
                        LEFT JOIN
                            `oc_clinical_sale` cs
                                ON csp.clinical_sale_id = cs.clinical_sale_id
                        LEFT JOIN
                            `oc_order` o
                                ON cs.order_id = o.order_id
                WHERE
                    1
                    AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''

            UNION ALL

			#purchase receive
			SELECT
				    pr.date_added,
                    'Purchase Received' AS type,
				    prp.product_id,
				    pr.invoice_prefix AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    1 AS action,
				    prp.quantity,
				    prp.quantity AS 'add',
				    NULL AS deduct,
				    pr.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    pr.comment as remark,
				    4 AS stock_type,
                    '' AS product_description
                FROM
                    `oc_purchase_receive_product` prp
                        LEFT JOIN
                            `oc_purchase_receive` pr
			                    ON prp.purchase_receive_id = pr.purchase_receive_id
                        LEFT JOIN
                            `oc_user` u
			                    ON pr.add_by = u.user_id
                WHERE
                    1
                    AND pr.order_status_id = '5'
                    AND pr.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND pr.date_added <= '" . $this->db->escape($end_date) . "'

			UNION ALL

			#purchase invoice
			SELECT
				    pi.date_added,
                    'Purchase Invoice' AS type,
				    pip.product_id,
				    pi.invoice_prefix AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    1 AS action,
				    pip.quantity,
				    pip.quantity AS 'add',
				    NULL AS deduct,
				    pi.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    pi.comment as remark,
				    5 AS stock_type,
                    '' AS product_description
                FROM
                    `oc_purchase_invoice_product` pip
                        LEFT JOIN
                            `oc_purchase_invoice` pi
			                    ON pip.purchase_invoice_id = pi.purchase_invoice_id
                        LEFT JOIN
                            `oc_user` u
			                    ON pi.add_by = u.user_id
                WHERE
                    1
			        AND pip.product_id != 0
			        AND pi.type IN (3, 5, 6)
			        AND pi.stock_affect = '1'
                    AND pi.order_status_id = '5'
                    AND pi.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND pi.date_added <= '" . $this->db->escape($end_date) . "'

            UNION ALL

            #production
            SELECT
                    p.date_added,
                    'Production' AS type,
                    ps.product_id,
                    p.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    2 AS person_type,
                    0 as action,
                    ps.quantity,
                    NULL AS 'add',
                    ps.quantity AS deduct,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    '' AS remark,
                    6 stock_type,
                    p.remark AS product_description
                FROM
                    `oc_production` p
                        LEFT JOIN
                            `oc_production_stock` ps
                                ON ps.production_id = p.production_id
                        LEFT JOIN
                            `oc_user` u
			                    ON p.add_by = u.user_id
                WHERE
                    1
                    AND ps.product_id != 0
                    AND p.status = '5'
                    AND p.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND p.date_added <= '" . $this->db->escape($end_date) . "'

            UNION ALL

            #production add stock
            SELECT
                    p.date_added,
                    'Production' AS type,
                    p.product_id,
                    p.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    (p.actual_quantity - a.total_reject_quantity) AS quantity,
                    (p.actual_quantity - a.total_reject_quantity) AS 'add',
                    NULL AS deduct,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    '' AS remark,
                    7 AS stock_type,
                    p.remark AS product_description
                FROM
                    `oc_production` p
                    LEFT JOIN 
                        (SELECT pro.production_id, (CASE WHEN SUM(proqc.reject_quantity) IS NULL THEN 0 ELSE SUM(proqc.reject_quantity) END) AS total_reject_quantity 
                            FROM `oc_production` pro 
                            LEFT JOIN `oc_production_qc` proqc 
                            ON proqc.production_id = pro.production_id 
                            GROUP BY pro.production_id)a 
                        ON a.production_id = p.production_id 
                        LEFT JOIN
                            `oc_user` u
                                ON p.add_by = u.user_id
                WHERE
                    1
                    AND p.product_id != 0
                    AND p.status = '5'
                    AND DATE(p.date_added) >=  DATE('" . $this->db->escape($start_date) . "')
                    AND DATE(p.date_added) <= DATE('" . $this->db->escape($end_date) . "') 
		) a

        LEFT JOIN " . DB_PREFIX . "product p
        ON(a.product_id = p.product_id )

        LEFT JOIN " . DB_PREFIX . "product_description pd
        ON(a.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

        LEFT JOIN " . DB_PREFIX . "product_description cn
        ON (p.product_id = cn.product_id AND cn.language_id = '2')

        LEFT JOIN " . DB_PREFIX . "product_description en
        ON (p.product_id = en.product_id AND en.language_id = '1')

        WHERE 1
        $product_statement
        $store_id_statement
        $location_id_statement
        $filter_batch_date_start_statement
        $product_name_statement
        $product_code_statement
        $filter_doc_type_data
        $description_statement
		ORDER BY date_added ASC
		$limit_statement
        ";
        // echo"<pre>";
        // print_r($sql);
        // echo"</pre>";
        $query = $this->db->query($sql);
        $this->printTime(__FUNCTION__, 'End');
        return $query->rows;
    }

    public function getStock($datetime, $product_id, $data)
    {
        $this->printTime(__FUNCTION__, 'Start');
        $store_id = $data['filter_store_id'] != ''  ? $data['filter_store_id'] : '';

        $store_id_statement = $data['filter_store_id'] != '' ? "AND column_store_id in( " . $store_id . ")" : '';

        $location_id_statement = $data['filter_location'] != '' ? "AND column_location_id in( " . $data['filter_location'] . ")" : '';

        $filter_batch_date_start= isset($data['filter_batch_date_start']) ? explode(',', $data['filter_batch_date_start']) : array();

        // $filter_batch_date_start = isset($data['filter_batch_date_start']) ? explode(',', $data['filter_batch_date_start']) : array();

        // $filter_date='';
        // if(!empty($data['filter_batch_date_start'])){
        //     $date = explode(',',$data['filter_batch_date_start']);
        //     if(!empty($date)){
        //         $date_sql='';
        //         foreach($date as $dates){
        //             $date_sql .=",'" . $dates . "'";
        //         }
        //         $batch_date = substr($date_sql,1);
        //     }
        // }

        $filter_batch_date_start_statement = "";

			foreach ($filter_batch_date_start as $filter_batch_date_starts) {
				$filter_batch_date_start_statement .= empty($filter_batch_date_start_statement) ? "a.batch_date LIKE '%" . $filter_batch_date_starts . "%'" : " OR a.batch_date LIKE '%" . $filter_batch_date_starts . "%'";
			}
	
			$filter_batch_date_start_statement = !empty($filter_batch_date_start_statement) ? "AND ($filter_batch_date_start_statement)" : "";

        // $filter_batch_date_start_statement = $data['filter_batch_date_start'] != '' ? "AND a.batch_date = ( " . $data['filter_batch_date_start'] . ")" : '';

        $batch_date_end_statement = $data['filter_batch_date_end'] != '' ? "AND batch_date <= '" . $data['filter_batch_date_end'] . "'" : '';

        $product_name_statement = $data['filter_product_name'] != '' ? "AND CONCAT(en.name,' ',cn.name) LIKE '%" . $data['filter_product_name'] . "%'" : '';

        $product_code_statement = $data['filter_product_code'] != '' ? "AND product.code LIKE '%" . $data['filter_product_code'] . "%'" : '';
        $filter_doc_type = '';
        if (!empty($data['filter_doc_type'])) {
            $doc_types = explode(',',$data['filter_doc_type']);
            if (!empty($doc_types)) {
                $doc_type_sql = '';
                foreach ($doc_types as $doc) {
                    $doc_type_sql .=  ",'" . $doc . "'";
                }
                $doc_type_data = substr($doc_type_sql,1);
                //$filter_doc_type = " AND a.type IN (" . $this->db->escape($doc_type_sql) . ")";
            }
        }
        
        $filter_doc_type_data = $data['filter_doc_type'] != '' ? " AND a.type IN (" . $doc_type_data . ")" : '';
        
        // $filter_doc_type = $data['filter_doc_type'] != '' ? "AND a.type LIKE '%" . $data['filter_doc_type'] . "%'" : '';


        if ($product_id == 0) {
            $product_statement = '';
        } else {
            $product_statement = "AND table_name.product_id = '" . (int)$product_id . "'";
        }

        $sql = "
        SELECT
            SUM((CASE WHEN a.action = 1 THEN a.quantity ELSE (a.quantity * -1) END)) AS stock
        FROM
        (
            #stock return
            SELECT
                    'Stock Return' AS type,
                    sr.product_id,
                    sr.action,
                    sr.qty AS quantity,
                    sr.store_id,
                    sr.location_id,
                    IFNULL(sr.batch_date,'0000-00-00') AS batch_date
                FROM
                    `oc_stock_return` sr
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sr.product_id = product.product_id )
                         LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sr.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (sr.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (sr.product_id = en.product_id AND en.language_id = '1')  
                WHERE
                    1
                    " . str_replace('table_name', 'sr', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'sr.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'sr.store_id', $store_id_statement) . "
                    AND sr.doc_date <  '" . $this->db->escape($datetime) . "'
                    AND sr.status   = 5

            UNION ALL

            #stock take

            SELECT
                    'Stock Take' AS type,
                    stp.product_id,
                    1 AS action,
                    stp.qty AS quantity,
                    st.store_id,
                    stp.location_id,
                    IFNULL(stp.batch_date,'0000-00-00') AS batch_date
                FROM
                    `oc_stock_take_product` stp
                        LEFT JOIN
                            `oc_stock_take` st
                                ON stp.stock_take_id = st.stock_take_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                                ON(stp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(stp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (stp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (stp.product_id = en.product_id AND en.language_id = '1')
                    
                WHERE
                    1
                    " . str_replace('table_name', 'stp', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'stp.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.store_id', $store_id_statement) . "
                    AND st.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND st.status   = 5

            UNION ALL

            #lot transfer out
            SELECT
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    0 AS action,
                    ltp.qty AS quantity,
                    lt.store_id,
                    ltp.source_location_id AS location_id,
                    IFNULL(ltp.batch_date,'0000-00-00') AS batch_date
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ltp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ltp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (ltp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (ltp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ltp', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'ltp.source_location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'lt.store_id', $store_id_statement) . "
                    AND lt.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND lt.status   = 5

            UNION ALL

            #lot transfer in
            SELECT
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    1 AS action,
                    ltp.qty AS quantity,
                    lt.store_id,
                    ltp.target_location_id AS location_id,
                    IFNULL(ltp.batch_date,'0000-00-00') AS batch_date
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ltp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ltp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (ltp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (ltp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ltp', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'ltp.target_location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'lt.store_id', $store_id_statement) . "
                    AND lt.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND lt.status   = 5

            UNION ALL

            #stock received
            SELECT
                    'Stock Received' AS type,
                    srp.product_id,
                    1 AS action,
                    srp.quantity AS quantity,
                    srv.store_id,
                    srp.location_id,
                    IFNULL(srp.batch_date,'0000-00-00') AS batch_date
                FROM
                    `oc_stock_received_product` srp
                        LEFT JOIN
                            `oc_stock_received` srv
                                ON srp.stock_received_id = srv.stock_received_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(srp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(srp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (srp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (srp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'srp', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'srp.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'srv.store_id', $store_id_statement) . "
                    AND srv.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND srv.status   = 5

            UNION ALL

            #stock adjustment
            SELECT
                    'Stock Adjustment' AS type,
                    sai.product_id,
                    sai.action,
                    sai.qty AS quantity,
                    sa.store_id,
                    sai.location_id,
                    IFNULL(sai.batch_date,'0000-00-00') AS batch_date
                FROM
                    `oc_stock_adjustment_item` sai
                        LEFT JOIN
                            `oc_stock_adjustment` sa
                                ON sai.stock_adjustment_id = sa.stock_adjustment_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sai.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sai.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (sai.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (sai.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'sai', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'sai.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'sa.store_id', $store_id_statement) . "
                    AND sai.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND sa.status   = 5

            UNION ALL

            #stock issue
            SELECT
                    'Stock Issue' AS type,
                    sii.product_id,
                    0 AS action,
                    sii.quantity,
                    si.store_id,
                    sii.location_id,
                    IFNULL(sii.batch_date,'0000-00-00') AS batch_date
                FROM
                    `oc_stock_issue_item` sii
                        LEFT JOIN
                            `oc_stock_issue` si
                                ON sii.stock_issue_id = si.stock_issue_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sii.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sii.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (sii.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (sii.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'sii', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'sii.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'si.store_id', $store_id_statement) . "
                    AND sii.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND si.status   = 5

            UNION ALL

            #received from store,出货
            SELECT
                    'Stock Transfer' AS type,
                    std.product_id,
                    (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    st.to_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(std.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(std.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (std.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (std.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'std', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.to_store', $store_id_statement) . "
                    AND std.received_quantity > 0
                    AND st.received_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status >= 4

            UNION ALL

            #tranfer to store,进货
            SELECT
                    'Stock Transfer' AS type,
                    std.product_id,
                    (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    st.from_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(std.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(std.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (std.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (std.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'std', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.from_store', $store_id_statement) . "
                    AND std.received_quantity > 0
                    AND st.transfer_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status >= 4

            UNION ALL

            #sold sale order
            SELECT
                    'Order' AS type,
                    op.product_id,
                    0 as action,
                    ROUND(op.weight,2) AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(op.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(op.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (op.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (op.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'op', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 0

            UNION ALL
            
            #sold order wholesaler
            SELECT
                    'Wholesale Order' AS type,
                    op.product_id,
                    0 as action,
                    ROUND(op.total_weight,2) AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(op.product_id = product.product_id )    
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(op.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (op.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (op.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'op', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 1

            UNION ALL

            #herbal remedies
            SELECT
                    'Herbal Remedies' AS type,
                    csp.product_id,
                    0 as action,
                    t_weight AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_clinicalsale_product` csp
                        LEFT JOIN
                            `oc_clinical_sale` cs
                                ON csp.clinical_sale_id = cs.clinical_sale_id
                        LEFT JOIN
                            `oc_order` o
                                ON cs.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(csp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(csp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (csp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (csp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'csp', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''

            UNION ALL

            #purchase receive
            SELECT
                    'Purchase Received' AS type,
                    prp.product_id,
                    1 AS action,
                    prp.quantity,
                    pr.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_purchase_receive_product` prp
                        LEFT JOIN
                            `oc_purchase_receive` pr
                                ON prp.purchase_receive_id = pr.purchase_receive_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(prp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(prp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (prp.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (prp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'prp', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'pr.store_id', $store_id_statement) . "
                    AND pr.order_status_id = '5'
                    AND pr.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #purchase invoice
            SELECT
                    'Purchase Invoice' AS type,
                    pip.product_id,
                    1 AS action,
                    pip.quantity,
                    pi.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_purchase_invoice_product` pip
                        LEFT JOIN
                            `oc_purchase_invoice` pi
                                ON pip.purchase_invoice_id = pi.purchase_invoice_id
                        LEFT JOIN " . DB_PREFIX . "product product
                            ON(pip.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(pip.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (pip.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (pip.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'pip', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'pi.store_id', $store_id_statement) . "
                    AND pip.product_id != 0
                    AND pi.type IN (3, 5, 6)
                    AND pi.stock_affect = '1'
                    AND pi.order_status_id = '5'
                    AND pi.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #production
            SELECT
                    'Production' AS type,
                    ps.product_id,
                    0 as action,
                    ps.quantity,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_production` p
                        LEFT JOIN
                            `oc_production_stock` ps
                                ON ps.production_id = p.production_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ps.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ps.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (ps.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (ps.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ps', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', '0', $store_id_statement) . "
                    AND ps.product_id != 0
                    AND p.status = '5'
                    AND p.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #production add stock
            SELECT
                    'Production' AS type,
                    p.product_id,
                    1 AS action,
                    (p.actual_quantity - a.total_reject_quantity) AS quantity,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_production` p
                    LEFT JOIN 
                        (SELECT pro.production_id, (CASE WHEN SUM(proqc.reject_quantity) IS NULL THEN 0 ELSE SUM(proqc.reject_quantity) END) AS total_reject_quantity 
                            FROM `oc_production` pro 
                            LEFT JOIN `oc_production_qc` proqc 
                            ON proqc.production_id = pro.production_id 
                            GROUP BY pro.production_id)a 
                        ON a.production_id = p.production_id 
                    LEFT JOIN " . DB_PREFIX . "product product 
                        ON(p.product_id = product.product_id )
                    LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(p.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                    
                    LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (p.product_id = cn.product_id AND cn.language_id = '2')
                    
                    LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (p.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'p', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', '0', $store_id_statement) . "
                    AND p.product_id != 0
                    AND p.status = '5'
                    AND p.date_added  <  '" . $this->db->escape($datetime) . "'
            ) a
        WHERE 1
        $filter_batch_date_start_statement
        $batch_date_end_statement
        $filter_doc_type_data
        
		";
        // echo"<pre>";
        // print_r($sql);
        // echo"</pre>";
        $query = $this->db->query($sql);
        $this->printTime(__FUNCTION__, 'End');
        return $query->row['stock'] ? $query->row['stock'] : 0;
    }

    

    public function getStockAll($datetime, $product_id, $data)
    {
        $this->printTime(__FUNCTION__, 'Start');
        $store_id = $data['filter_store_id'] != ''  ? $data['filter_store_id'] : '';

        $store_id_statement = $data['filter_store_id'] != '' ? "AND column_store_id in( " . $store_id . ")" : '';

        $location_id_statement = $data['filter_location'] != '' ? "AND column_location_id in( " . $data['filter_location'] . ")" : '';


        $product_name_statement = $data['filter_product_name'] != '' ? "AND CONCAT(en.name,' ',cn.name) LIKE '%" . $data['filter_product_name'] . "%'" : '';

        $product_code_statement = $data['filter_product_code'] != '' ? "AND product.code LIKE '%" . $data['filter_product_code'] . "%'" : '';
        
        // $filter_doc_type = $data['filter_doc_type'] != '' ? "AND a.type LIKE '%" . $data['filter_doc_type'] . "%'" : '';


        if ($product_id == 0) {
            $product_statement = '';
        } else {
            $product_statement = "AND table_name.product_id = '" . (int)$product_id . "'";
        }

        $sql = "
        SELECT
            SUM((CASE WHEN a.action = 1 THEN a.quantity ELSE (a.quantity * -1) END)) AS stock
        FROM
        (
            #stock return
            SELECT
                    'Stock Return' AS type,
                    sr.product_id,
                    sr.action,
                    sr.qty AS quantity,
                    sr.store_id,
                    sr.location_id,
                    (CASE WHEN sr.batch_date is NULL THEN '0000-00-00' ELSE sr.batch_date END) AS batch_date
                FROM
                    `oc_stock_return` sr
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sr.product_id = product.product_id )
                         LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sr.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (sr.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (sr.product_id = en.product_id AND en.language_id = '1')  
                WHERE
                    1
                    " . str_replace('table_name', 'sr', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'sr.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'sr.store_id', $store_id_statement) . "
                    AND sr.doc_date <  '" . $this->db->escape($datetime) . "'
                    AND sr.status   = 5

            UNION ALL

            #stock take

            SELECT
                    'Stock Take' AS type,
                    stp.product_id,
                    1 AS action,
                    stp.qty AS quantity,
                    st.store_id,
                    stp.location_id,
                    (CASE WHEN stp.batch_date is NULL THEN '0000-00-00' ELSE stp.batch_date END) AS batch_date
                FROM
                    `oc_stock_take_product` stp
                        LEFT JOIN
                            `oc_stock_take` st
                                ON stp.stock_take_id = st.stock_take_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                                ON(stp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(stp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (stp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (stp.product_id = en.product_id AND en.language_id = '1')
                    
                WHERE
                    1
                    " . str_replace('table_name', 'stp', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'stp.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.store_id', $store_id_statement) . "
                    AND st.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND st.status   = 5

            UNION ALL

            #lot transfer out
            SELECT
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    0 AS action,
                    ltp.qty AS quantity,
                    lt.store_id,
                    ltp.source_location_id AS location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ltp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ltp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (ltp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (ltp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ltp', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'ltp.source_location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'lt.store_id', $store_id_statement) . "
                    AND lt.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND lt.status   = 5

            UNION ALL

            #lot transfer in
            SELECT
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    1 AS action,
                    ltp.qty AS quantity,
                    lt.store_id,
                    ltp.target_location_id AS location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ltp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ltp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (ltp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (ltp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ltp', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'ltp.target_location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'lt.store_id', $store_id_statement) . "
                    AND lt.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND lt.status   = 5

            UNION ALL

            #stock received
            SELECT
                    'Stock Received' AS type,
                    srp.product_id,
                    1 AS action,
                    srp.quantity AS quantity,
                    srv.store_id,
                    srp.location_id,
                    (CASE WHEN srp.batch_date is NULL THEN '0000-00-00' ELSE srp.batch_date END) AS batch_date
                FROM
                    `oc_stock_received_product` srp
                        LEFT JOIN
                            `oc_stock_received` srv
                                ON srp.stock_received_id = srv.stock_received_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(srp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(srp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (srp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (srp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'srp', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'srp.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'srv.store_id', $store_id_statement) . "
                    AND srv.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND srv.status   = 5

            UNION ALL

            #stock adjustment
            SELECT
                    'Stock Adjustment' AS type,
                    sai.product_id,
                    sai.action,
                    sai.qty AS quantity,
                    sa.store_id,
                    sai.location_id,
                    (CASE WHEN sai.batch_date is NULL THEN '0000-00-00' ELSE sai.batch_date END) AS batch_date
                FROM
                    `oc_stock_adjustment_item` sai
                        LEFT JOIN
                            `oc_stock_adjustment` sa
                                ON sai.stock_adjustment_id = sa.stock_adjustment_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sai.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sai.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (sai.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (sai.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'sai', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'sai.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'sa.store_id', $store_id_statement) . "
                    AND sai.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND sa.status   = 5

            UNION ALL

            #stock issue
            SELECT
                    'Stock Issue' AS type,
                    sii.product_id,
                    0 AS action,
                    sii.quantity,
                    si.store_id,
                    sii.location_id,
                    (CASE WHEN sii.batch_date is NULL THEN '0000-00-00' ELSE sii.batch_date END) AS batch_date
                FROM
                    `oc_stock_issue_item` sii
                        LEFT JOIN
                            `oc_stock_issue` si
                                ON sii.stock_issue_id = si.stock_issue_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sii.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sii.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (sii.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (sii.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'sii', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', 'sii.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'si.store_id', $store_id_statement) . "
                    AND sii.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND si.status   = 5

            UNION ALL

            #received from store,出货
            SELECT
                    'Stock Transfer' AS type,
                    std.product_id,
                    (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    st.to_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(std.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(std.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (std.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (std.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'std', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.to_store', $store_id_statement) . "
                    AND std.received_quantity > 0
                    AND st.received_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status >= 4

            UNION ALL

            #tranfer to store,进货
            SELECT
                    'Stock Transfer' AS type,
                    std.product_id,
                    (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    st.from_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(std.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(std.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (std.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (std.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'std', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.from_store', $store_id_statement) . "
                    AND std.received_quantity > 0
                    AND st.transfer_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status >= 4

            UNION ALL

            #sold sale order
            SELECT
                    'Order' AS type,
                    op.product_id,
                    0 as action,
                    ROUND(op.weight,2) AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(op.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(op.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (op.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (op.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'op', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 0

            UNION ALL
            
            #sold order wholesaler
            SELECT
                    'Wholesale Order' AS type,
                    op.product_id,
                    0 as action,
                    ROUND(op.total_weight,2) AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(op.product_id = product.product_id )    
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(op.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (op.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (op.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'op', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 1

            UNION ALL

            #herbal remedies
            SELECT
                    'Herbal Remedies' AS type,
                    csp.product_id,
                    0 as action,
                    t_weight AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_clinicalsale_product` csp
                        LEFT JOIN
                            `oc_clinical_sale` cs
                                ON csp.clinical_sale_id = cs.clinical_sale_id
                        LEFT JOIN
                            `oc_order` o
                                ON cs.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(csp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(csp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (csp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (csp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'csp', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''

            UNION ALL

            #purchase receive
            SELECT
                    'Purchase Received' AS type,
                    prp.product_id,
                    1 AS action,
                    prp.quantity,
                    pr.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_purchase_receive_product` prp
                        LEFT JOIN
                            `oc_purchase_receive` pr
                                ON prp.purchase_receive_id = pr.purchase_receive_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(prp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(prp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (prp.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (prp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'prp', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'pr.store_id', $store_id_statement) . "
                    AND pr.order_status_id = '5'
                    AND pr.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #purchase invoice
            SELECT
                    'Purchase Invoice' AS type,
                    pip.product_id,
                    1 AS action,
                    pip.quantity,
                    pi.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_purchase_invoice_product` pip
                        LEFT JOIN
                            `oc_purchase_invoice` pi
                                ON pip.purchase_invoice_id = pi.purchase_invoice_id
                        LEFT JOIN " . DB_PREFIX . "product product
                            ON(pip.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(pip.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (pip.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (pip.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'pip', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'pi.store_id', $store_id_statement) . "
                    AND pip.product_id != 0
                    AND pi.type IN (3, 5, 6)
                    AND pi.stock_affect = '1'
                    AND pi.order_status_id = '5'
                    AND pi.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #production
            SELECT
                    'Production' AS type,
                    ps.product_id,
                    0 as action,
                    ps.quantity,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_production` p
                        LEFT JOIN
                            `oc_production_stock` ps
                                ON ps.production_id = p.production_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ps.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ps.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (ps.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (ps.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ps', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', '0', $store_id_statement) . "
                    AND ps.product_id != 0
                    AND p.status = '5'
                    AND p.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #production add stock
            SELECT
                    'Production' AS type,
                    p.product_id,
                    1 AS action,
                    (p.actual_quantity - a.total_reject_quantity) AS quantity,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_production` p
                    LEFT JOIN 
                        (SELECT pro.production_id, (CASE WHEN SUM(proqc.reject_quantity) IS NULL THEN 0 ELSE SUM(proqc.reject_quantity) END) AS total_reject_quantity 
                            FROM `oc_production` pro 
                            LEFT JOIN `oc_production_qc` proqc 
                            ON proqc.production_id = pro.production_id 
                            GROUP BY pro.production_id)a 
                        ON a.production_id = p.production_id 
                    LEFT JOIN " . DB_PREFIX . "product product 
                        ON(p.product_id = product.product_id )
                    LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(p.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                    
                    LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (p.product_id = cn.product_id AND cn.language_id = '2')
                    
                    LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (p.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'p', $product_statement) . " 
                    $product_code_statement
                    $product_name_statement
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', '0', $store_id_statement) . "
                    AND p.product_id != 0
                    AND p.status = '5'
                    AND p.date_added  <  '" . $this->db->escape($datetime) . "'
            ) a
        WHERE 1
   
        
		";

        $query = $this->db->query($sql);
        $this->printTime(__FUNCTION__, 'End');
        return $query->row['stock'] ? $query->row['stock'] : 0;
    }

    public function getStock_old($datetime, $product_id, $data)
    {
        $this->printTime(__FUNCTION__, 'Start');
        $store_id = $data['filter_store_id'] != '' && $data['filter_store_id'] != '*' ? $data['filter_store_id'] : '';

        $store_id_statement = $data['filter_store_id'] != '' && $data['filter_store_id'] != '*' ? "AND a.store_id = " . $store_id : '';

        $location_id_statement = $data['filter_location'] != '' && $data['filter_location'] != '*' ? "AND a.location_id = " . $data['filter_location'] : '';
        $batch_date_statement = $data['filter_batch_date'] != '' ? "AND a.batch_date = '" . $data['filter_batch_date'] . "'" : '';

        $product_name_statement = $data['filter_product_name'] != '' ? "AND pd.name LIKE '%" . $data['filter_product_name'] . "%'" : '';

        $product_code_statement = $data['filter_product_code'] != '' ? "AND p.code LIKE '%" . $data['filter_product_code'] . "%'" : '';
        // $product_description_statement = $data['filter_product_description'] != '' ? "AND p.code LIKE '%" . $data['filter_product_description'] . "%'" : '';

        if ($product_id == 0) {
            $product_statement = '';
        } else {
            $product_statement = "AND a.product_id = '" . (int)$product_id . "'";
        }

        $sql = "
		SELECT SUM((CASE WHEN b.action = 1 THEN b.quantity ELSE (b.quantity * -1) END)) AS stock
        FROM (
               
            SELECT
            a.action,
            a.quantity
        FROM
        (
            #stock return
            SELECT
                    'Stock Return' AS type,
                    sr.product_id,
                    sr.action,
                    sr.qty AS quantity,
                    0 AS store_id,
                    0 AS location_id,
                    '0000-00-00' AS batch_date
                FROM
                    `oc_stock_return` sr
                WHERE
                    1
                    AND sr.doc_date <  '" . $this->db->escape($datetime) . "'
                    AND sr.status   = 5

            UNION ALL
            #stock take
            SELECT
                    'Stock Take' AS type,
                    stp.product_id,
                    1 AS action,
                    stp.qty AS quantity,
                    st.store_id,
                    stp.location_id,
                    (CASE WHEN stp.batch_date is NULL THEN '0000-00-00' ELSE stp.batch_date END) AS batch_date
                FROM
                    `oc_stock_take_product` stp
                        LEFT JOIN
                            `oc_stock_take` st
                                ON stp.stock_take_id = st.stock_take_id
                WHERE
                    1
                    AND st.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND st.status   = 5

            UNION ALL
            #lot transfer out
            SELECT
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    0 AS action,
                    ltp.qty AS quantity,
                    lt.store_id,
                    ltp.source_location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                WHERE
                    1
                    AND lt.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND lt.status   = 5
            UNION ALL
            #lot transfer in
            SELECT
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    1 AS action,
                    ltp.qty AS quantity,
                    lt.store_id,
                    ltp.target_location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                WHERE
                    1
                    AND lt.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND lt.status   = 5

            UNION ALL
            #stock received
            SELECT
                    'Stock Received' AS type,
                    srp.product_id,
                    1 AS action,
                    srp.quantity AS quantity,
                    srv.store_id,
                    srp.location_id,
                    '0000-00-00' AS batch_date
                FROM
                    `oc_stock_received_product` srp
                        LEFT JOIN
                            `oc_stock_received` srv
                                ON srp.stock_received_id = srv.stock_received_id
                WHERE
                    1
                    AND srv.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND srv.status   = 5

            UNION ALL
            #stock adjustment
            SELECT
                    'Stock Adjustment' AS type,
                    sai.product_id,
                    sai.action,
                    sai.qty AS quantity,
                    sa.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_adjustment_item` sai
                        LEFT JOIN
                            `oc_stock_adjustment` sa
                                ON sai.stock_adjustment_id = sa.stock_adjustment_id
                WHERE
                    1
                    AND sai.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND sa.status   = 5

            UNION ALL

            #stock issue
            SELECT
                    'Stock Issue' AS type,
                    sii.product_id,
                    0 AS action,
                    sii.quantity,
                    si.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_issue_item` sii
                        LEFT JOIN
                            `oc_stock_issue` si
                                ON sii.stock_issue_id = si.stock_issue_id
                WHERE
                    1
                    AND sii.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND si.status   = 5

            UNION ALL

            #received from store,出货
            SELECT
                    'Stock Transfer' AS type,
                    std.product_id,
                    (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    st.to_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                WHERE
                    1
                    AND std.received_quantity > 0
                    AND st.received_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status >= 4

            UNION ALL

            #tranfer to store,进货
            SELECT
                    'Stock Transfer' AS type,
                    std.product_id,
                    (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    st.from_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                WHERE
                    1
                    AND std.received_quantity > 0
                    AND st.transfer_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status >= 4

            UNION ALL

            #sold sale order
            SELECT
                    'Order' AS type,
                    op.product_id,
                    0 as action,
                    ROUND(op.weight,2) AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                WHERE
                    1
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 0

            UNION ALL
            
            #sold order wholesaler
            SELECT
                    'Wholesale Order' AS type,
                    op.product_id,
                    0 as action,
                    ROUND(op.total_weight,2) AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                WHERE
                    1
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 1

            UNION ALL

            #herbal remedies
            SELECT
                    'Herbal Remedies' AS type,
                    csp.product_id,
                    0 as action,
                    t_weight AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_clinicalsale_product` csp
                        LEFT JOIN
                            `oc_clinical_sale` cs
                                ON csp.clinical_sale_id = cs.clinical_sale_id
                        LEFT JOIN
                            `oc_order` o
                                ON cs.order_id = o.order_id
                WHERE
                    1
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''

            UNION ALL

            #purchase receive
            SELECT
                    'Purchase Received' AS type,
                    prp.product_id,
                    1 AS action,
                    prp.quantity,
                    pr.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_purchase_receive_product` prp
                        LEFT JOIN
                            `oc_purchase_receive` pr
                                ON prp.purchase_receive_id = pr.purchase_receive_id
                WHERE
                    1
                    AND pr.order_status_id = '5'
                    AND pr.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #purchase invoice
            SELECT
                    'Purchase Invoice' AS type,
                    pip.product_id,
                    1 AS action,
                    pip.quantity,
                    pi.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_purchase_invoice_product` pip
                        LEFT JOIN
                            `oc_purchase_invoice` pi
                                ON pip.purchase_invoice_id = pi.purchase_invoice_id
                WHERE
                    1
                    AND pip.product_id != 0
                    AND pi.type IN (3, 5, 6)
                    AND pi.stock_affect = '1'
                    AND pi.order_status_id = '5'
                    AND pi.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #production
            SELECT
                    'Production' AS type,
                    ps.product_id,
                    0 as action,
                    ps.quantity,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_production` p
                        LEFT JOIN
                            `oc_production_stock` ps
                                ON ps.production_id = p.production_id
                WHERE
                    1
                    AND ps.product_id != 0
                    AND p.status = '5'
                    AND p.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #production add stock
            SELECT
                    'Production' AS type,
                    p.product_id,
                    1 AS action,
                    (p.actual_quantity - a.total_reject_quantity) AS quantity,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_production` p
                    LEFT JOIN 
                        (SELECT pro.production_id, (CASE WHEN SUM(proqc.reject_quantity) IS NULL THEN 0 ELSE SUM(proqc.reject_quantity) END) AS total_reject_quantity 
                            FROM `oc_production` pro 
                            LEFT JOIN `oc_production_qc` proqc 
                            ON proqc.production_id = pro.production_id 
                            GROUP BY pro.production_id)a 
                        ON a.production_id = p.production_id 
                WHERE
                    1
                    AND p.product_id != 0
                    AND p.status = '5'
                    AND p.date_added  <  '" . $this->db->escape($datetime) . "'
            ) a

        LEFT JOIN " . DB_PREFIX . "product p
        ON(a.product_id = p.product_id )

        LEFT JOIN " . DB_PREFIX . "product_description pd
        ON(a.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
        WHERE 1
        $product_statement
        $store_id_statement
        $location_id_statement
        $batch_date_statement
        $product_name_statement
        $product_code_statement
		) b
		";

        $query = $this->db->query($sql);
        $this->printTime(__FUNCTION__, 'End');
        return $query->row['stock'] ? $query->row['stock'] : 0;
    }

    public function getStock_backup($datetime, $product_id, $store_id = '', $equal = false)
    {
        $equal_statement = $equal ? "=" : "";

        $filter_store_id_statement = $store_id != '' && $store_id != '*' ?
            "AND a.store_id = '" . (int)$store_id . "'" :
            "";

        $sql = "
		SELECT SUM(a.quantity) AS stock
		    FROM
		    (
			    #stock return
			    SELECT
				        sr.qty AS quantity
			        FROM
                        `oc_stock_return` sr
                    WHERE
                        1
                        AND sr.product_id = '" . (int)$product_id . "'
                        AND sr.doc_date <  '" . $this->db->escape($datetime) . "'
                        #AND sr.store_id   = '" . (int)$store_id  .  "'
                        AND sr.status   = 5

			UNION ALL

			    #stock take
			    SELECT
				        stp.qty AS quantity
			        FROM
                        `oc_stock_take_product` stp
                            LEFT JOIN
                                `oc_stock_take` st
                                    ON stp.stock_take_id = st.stock_take_id
                    WHERE
                        1
                        AND stp.product_id = '" . (int)$product_id . "'
                        AND st.doc_date <  '" . $this->db->escape($datetime) . "'
                        AND st.store_id   = '" . (int)$store_id  .  "'
                        AND st.status   = 5
			UNION ALL

			    #stock received
			    SELECT
				        srp.quantity AS quantity
			        FROM
                        `oc_stock_received_product` srp
                            LEFT JOIN
                                `oc_stock_received` srv
                                    ON srp.stock_received_id = srv.stock_received_id
                    WHERE
                        1
                        AND srp.product_id = '" . (int)$product_id . "'
                        AND srv.date_added <  '" . $this->db->escape($datetime) . "'
                        AND srv.store_id   = '" . (int)$store_id  .  "'
                        AND srv.status   = 5

			UNION ALL

			    #stock adjustment
			    SELECT
				        (CASE WHEN sai.action = 1 THEN sai.qty ELSE (sai.qty * -1) END) AS quantity
			        FROM
                        `oc_stock_adjustment_item` sai
                            LEFT JOIN
                                `oc_stock_adjustment` sa
                                    ON sai.stock_adjustment_id = sa.stock_adjustment_id
                    WHERE
                        1
                        AND sai.product_id = '" . (int)$product_id . "'
                        AND sai.date_added <  '" . $this->db->escape($datetime) . "'
                        AND sa.store_id   = '" . (int)$store_id  .  "'
                        AND sa.status   = 5

			UNION ALL

                #stock issue
                SELECT
                        (sii.quantity * -1) AS quantity
                    FROM
                        `oc_stock_issue_item` sii
                            LEFT JOIN
                                `oc_stock_issue` si
                                    ON sii.stock_issue_id = si.stock_issue_id
                    WHERE
                        1
                        AND sii.product_id = '" . (int)$product_id . "'
                        AND sii.date_added <  '" . $this->db->escape($datetime) . "'
                        AND si.store_id   = '" . (int)$store_id  .  "'
                        AND si.status   = 5

            UNION ALL

                #received from store
                SELECT
                        (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN std.received_quantity ELSE (std.received_quantity * -1) END) AS quantity
                    FROM
                        `oc_stock_transfer_detail` std
                            LEFT JOIN
                                `oc_stock_transfer` st
                                    ON std.stock_transfer_id = st.stock_transfer_id
                    WHERE
                        1
                        AND std.received_quantity > 0
                        AND std.product_id = '" . (int)$product_id . "'
                        AND st.received_date <  '" . $this->db->escape($datetime) . "'
                        AND st.to_store   = '" . (int)$store_id  .  "'
                        AND st.status >= 4

			UNION ALL

                #tranfer to store store
                SELECT
                        (CASE WHEN st.to_store = '" . (int)$store_id . "' THEN (std.received_quantity * -1) ELSE std.received_quantity END) AS quantity
                    FROM
                        `oc_stock_transfer_detail` std
                            LEFT JOIN
                                `oc_stock_transfer` st
                                    ON std.stock_transfer_id = st.stock_transfer_id
                    WHERE
                        1
                        AND std.received_quantity > 0
                        AND std.product_id = '" . (int)$product_id . "'
                        AND st.transfer_date <  '" . $this->db->escape($datetime) . "'
                        AND st.from_store   = '" . (int)$store_id  .  "'
                        AND st.status >= 4

            UNION ALL

			#sold saler order
                SELECT
                        ROUND(op.weight * -1,2) AS quantity
                    FROM
                        `oc_order_product` op
                            LEFT JOIN
                                `oc_order` o
                                    ON op.order_id = o.order_id
                            LEFT JOIN
                                `oc_weight_class` wc
                                    ON op.weight_class_id = wc.weight_class_id
                    WHERE
                        1
                        AND op.product_id = '" . (int)$product_id . "'
                        AND o.date_added <  '" . $this->db->escape($datetime) . "'
                        AND o.store_id   = '" . (int)$store_id  .  "'
                        AND o.order_status_id = '5'
                        AND o.invoice_prefix <>''
                        AND o.invoice_wholesaler = 0

            UNION ALL
            
            #sold order wholesaler
                SELECT
                        ROUND(op.total_weight * -1,2) AS quantity
                    FROM
                        `oc_order_product` op
                            LEFT JOIN
                                `oc_order` o
                                    ON op.order_id = o.order_id
                            LEFT JOIN
                                `oc_weight_class` wc
                                    ON op.weight_class_id = wc.weight_class_id
                    WHERE
                        1
                        AND op.product_id = '" . (int)$product_id . "'
                        AND o.date_added <  '" . $this->db->escape($datetime) . "'
                        AND o.store_id   = '" . (int)$store_id  .  "'
                        AND o.order_status_id = '5'
                        AND o.invoice_prefix <>''
                        AND o.invoice_wholesaler = 1

            UNION ALL

            #herbal remedies
            SELECT
                    ROUND(t_weight * -1,2) AS quantity
                FROM
                    `oc_clinicalsale_product` csp
                        LEFT JOIN
                            `oc_clinical_sale` cs
                                ON csp.clinical_sale_id = cs.clinical_sale_id
                        LEFT JOIN
                            `oc_order` o
                                ON cs.order_id = o.order_id
                WHERE
                    1
                    AND csp.product_id = '" . (int)$product_id . "'
                    AND o.date_added <  '" . $this->db->escape($datetime) . "'
                    AND o.store_id   = '" . (int)$store_id  .  "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''

			UNION ALL

			#purchase receive
                SELECT
                        prp.quantity
                    FROM
                        `oc_purchase_receive_product` prp
                            LEFT JOIN
                                `oc_purchase_receive` pr
                                    ON prp.purchase_receive_id = pr.purchase_receive_id
                    WHERE
                        1
                        AND pr.order_status_id = '5'
                        AND prp.product_id = '" . (int)$product_id . "'
                        AND pr.date_added <  '" . $this->db->escape($datetime) . "'
                        AND pr.store_id   = '" . (int)$store_id  .  "'

			UNION ALL

			#purchase invoice
                SELECT
                        pip.quantity
                    FROM
                        `oc_purchase_invoice_product` pip
                            LEFT JOIN
                                `oc_purchase_invoice` pi
                                    ON pip.purchase_invoice_id = pi.purchase_invoice_id
                    WHERE
                        1
                        AND stock_affect = '1'
                        AND pip.product_id != '0'
                        AND pi.type IN (3, 5, 6)
                        AND pi.order_status_id = '5'
                        AND pip.product_id = '" . (int)$product_id . "'
                        AND pi.date_added <  '" . $this->db->escape($datetime) . "'
                        AND pi.store_id   = '" . (int)$store_id  .  "' 
            
            UNION ALL

            #production
            SELECT
                    ROUND(ps.quantity * -1,2) AS quantity
                FROM
                    `oc_production` p
                        LEFT JOIN
                            `oc_production_stock` ps
                                ON ps.production_id = p.production_id
                        LEFT JOIN
                            `oc_user` u
			                    ON p.add_by = u.user_id
                WHERE
                    1
                    AND ps.product_id != 0
                    AND p.status = '5'
                    AND ps.product_id = '" . (int)$product_id . "'
                    AND p.date_added <  '" . $this->db->escape($datetime) . "' 
            
            UNION ALL

            #production add stock
            SELECT
                    ROUND((p.actual_quantity - a.total_reject_quantity) * -1,2) AS quantity
                FROM
                    `oc_production` p
                    LEFT JOIN 
                        (SELECT pro.production_id, (CASE WHEN SUM(proqc.reject_quantity) IS NULL THEN 0 ELSE SUM(proqc.reject_quantity) END) AS total_reject_quantity 
                            FROM `oc_production` pro 
                            LEFT JOIN `oc_production_qc` proqc 
                            ON proqc.production_id = pro.production_id 
                            GROUP BY pro.production_id)a 
                        ON a.production_id = p.production_id 
                        LEFT JOIN
                            `oc_user` u
                                ON p.add_by = u.user_id
                WHERE
                    1
                    AND p.product_id != 0
                    AND p.status = '5'
                    AND p.product_id = '" . (int)$product_id . "'
                    AND p.date_added < '" . $this->db->escape($datetime) . "' 
		) a
		";

        $query = $this->db->query($sql);
        return $query->row['stock'] ? $query->row['stock'] : 0;
    }

    public function getProductStockInfoTotal($product_id, $data)
    {
        $this->printTime(__FUNCTION__, 'Start');
        $open_date = !empty($data['filter_open_date']) ? $data['filter_open_date'] : '1970-01-01';

        $close_date = !empty($data['filter_close_date']) ? $data['filter_close_date'] : date('Y-m-d');

        $store_id = $data['filter_store_id'] != '' ? $data['filter_store_id'] : '';

        $store_id_statement = $data['filter_store_id'] != ''  ? "AND a.store_id in ( " . $store_id . ")" : '';

        $location_id_statement = $data['filter_location'] != ''  ? "AND a.location_id in ( " . $data['filter_location'] . ")" : '';

        $filter_batch_date_start= isset($data['filter_batch_date_start']) ? explode(',', $data['filter_batch_date_start']) : array();

        $filter_batch_date_start_statement = "";

        foreach ($filter_batch_date_start as $filter_batch_date_starts) {
            $filter_batch_date_start_statement .= empty($filter_batch_date_start_statement) ? "a.batch_date LIKE '%" . $filter_batch_date_starts . "%'" : " OR a.batch_date LIKE '%" . $filter_batch_date_starts . "%'";
        }

        $filter_batch_date_start_statement = !empty($filter_batch_date_start_statement) ? "AND ($filter_batch_date_start_statement)" : "";


        // $filter_date='';
        // if(!empty($data['filter_batch_date_start'])){
        //     $date = explode(',',$data['filter_batch_date_start']);
        //     if(!empty($date)){
        //         $date_sql='';
        //         foreach($date as $dates){
        //             $date_sql .=",'" . $dates . "'";
        //         }
        //         $batch_date = substr($date_sql,1);
        //     }
        // }

        // $batch_date_start_statement = $data['filter_batch_date_start'] != '' ? "AND a.batch_date in ( " . $batch_date . ")" : '';

        // $batch_date_end_statement = $data['filter_batch_date_end'] != '' ? "AND a.batch_date <= '" . $data['filter_batch_date_end'] . "'" : '';

        $product_name_statement = $data['filter_product_name'] != '' ? "AND CONCAT(en.name,' ',cn.name) LIKE '%" . $data['filter_product_name'] . "%'" : '';

        $product_code_statement = $data['filter_product_code'] != '' ? "AND p.code LIKE '%" . $data['filter_product_code'] . "%'" : '';


        $filter_doc_type = '';
        if (!empty($data['filter_doc_type'])) {
            $doc_types = explode(',',$data['filter_doc_type']);
            if (!empty($doc_types)) {
                $doc_type_sql = '';
                foreach ($doc_types as $doc) {
                    $doc_type_sql .=  ",'" . $doc . "'";
                }
                $doc_type_data = substr($doc_type_sql,1);
                //$filter_doc_type = " AND a.type IN (" . $this->db->escape($doc_type_sql) . ")";
            }
        }
        
        $filter_doc_type_data = $data['filter_doc_type'] != '' ? " AND a.type IN (" . $doc_type_data . ")" : '';

        $description_statement = $data['filter_description'] != '' ? "AND a.remark LIKE '%" . $this->db->escape($data['filter_description']) . "%'" : '';
        if ($product_id == 0) {
            $product_statement = '';
        } else {
            $product_statement = "AND a.product_id = '" . (int)$product_id . "'";
        }

        // $store_id = $data['filter_store_id'] != '' ? $data['filter_store_id'] : '';

        // $store_id_statement = $data['filter_store_id'] != ''  ? "AND a.store_id in ( " . $store_id . ")" : '';

        // $location_id_statement = $data['filter_location'] != ''  ? "AND a.location_id in ( " . $data['filter_location'] . ")" : '';

        // $filter_date='';
        // if(!empty($data['filter_batch_date_start'])){
        //     $date = explode(',',$data['filter_batch_date_start']);
        //     if(!empty($date)){
        //         $date_sql='';
        //         foreach($date as $dates){
        //             $date_sql .=",'" . $dates . "'";
        //         }
        //         $batch_date = substr($date_sql,1);
        //     }
        // }

        // $batch_date_start_statement = $data['filter_batch_date_start'] != '' ? "AND a.batch_date in ( " . $batch_date . ")" : '';

        // // $batch_date_end_statement = $data['filter_batch_date_end'] != '' ? "AND a.batch_date <= '" . $data['filter_batch_date_end'] . "'" : '';

        // $product_name_statement = $data['filter_product_name'] != '' ? "AND CONCAT(en.name,' ',cn.name) LIKE '%" . $data['filter_product_name'] . "%'" : '';

        // $product_code_statement = $data['filter_product_code'] != '' ? "AND p.code LIKE '%" . $data['filter_product_code'] . "%'" : '';


        // $filter_doc_type = '';
        // if (!empty($data['filter_doc_type'])) {
        //     $doc_types = explode(',',$data['filter_doc_type']);
        //     if (!empty($doc_types)) {
        //         $doc_type_sql = '';
        //         foreach ($doc_types as $doc) {
        //             $doc_type_sql .=  ",'" . $doc . "'";
        //         }
        //         $doc_type_data = substr($doc_type_sql,1);
        //         //$filter_doc_type = " AND a.type IN (" . $this->db->escape($doc_type_sql) . ")";
        //     }
        // }
        
        // $filter_doc_type_data = $data['filter_doc_type'] != '' ? " AND a.type IN (" . $doc_type_data . ")" : '';

        // $description_statement = $data['filter_description'] != '' ? "AND a.remark LIKE '%" . $this->db->escape($data['filter_description']) . "%'" : '';
        // if ($product_id == 0) {
        //     $product_statement = '';
        // } else {
        //     $product_statement = "AND a.product_id = '" . (int)$product_id . "'";
        // }

        $start_date = $this->db->escape($open_date) .  " 00:00:00";
        $end_date   = $this->db->escape($close_date) .  " 23:59:59";

        $sql = "
            SELECT
                COUNT(*) AS total
            FROM
                (
                    SELECT
                        a.date_added,
                        a.type,
                        a.product_id,
                        pd.name AS product_name,
                        p.code AS product_code,
                        a.id,
                        a.name,
                        a.person_type,
                        a.action,
                        a.quantity,
                        a.add,
                        a.deduct,
                        a.store_id,
                        a.location_id,
                        a.batch_date,
                        a.remark,
                        a.stock_type,
                        a.product_description,
                        (CASE WHEN action = 1 THEN @stock := @stock + a.quantity
                        ELSE @stock := @stock - a.quantity END) AS balance
                    FROM
                    (
                    #stock return
                    SELECT
                            sr.doc_date as date_added,
                            'Stock Return' AS type,
                            sr.product_id,
                            sr.doc_no AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            1 AS person_type,
                            sr.action,
                            sr.qty AS quantity,
                            (CASE WHEN sr.action=1 THEN sr.qty ELSE NULL END) AS 'add',
                            (CASE WHEN sr.action=1 THEN NULL ELSE sr.qty END) AS deduct,
                            0 AS store_id,
                            sr.location_id,
                            (CASE WHEN sr.batch_date is NULL THEN '0000-00-00' ELSE sr.batch_date END) AS batch_date,
                            sr.description AS remark,
                            1 AS stock_type,
                            ''AS product_description
                        FROM
                            `oc_stock_return` sr
                                LEFT JOIN
                                    `oc_user` u
                                        ON sr.added_by = u.user_id
                        WHERE
                            1
                            AND sr.doc_date >=  '" . $this->db->escape($start_date) . "'
                            AND sr.doc_date <= '" . $this->db->escape($end_date) . "'
                            AND sr.status   = 5

                    UNION ALL

                    #stock take
                    SELECT
                            st.date_added as date_added,
                            'Stock Take' AS type,
                            stp.product_id,
                            st.doc_no AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            1 AS person_type,
                            1 AS action,
                            stp.qty AS quantity,
                            stp.qty AS 'add',
                            NULL AS deduct,
                            st.store_id,
                            stp.location_id,
                            (CASE WHEN stp.batch_date is NULL THEN '0000-00-00' ELSE stp.batch_date END) AS batch_date,
                            st.description AS remark,
                            1 AS stock_type,
                            stp.remark AS product_description

                        FROM
                            `oc_stock_take_product` stp
                                LEFT JOIN
                                    `oc_stock_take` st
                                        ON stp.stock_take_id = st.stock_take_id
                                LEFT JOIN
                                    `oc_user` u
                                        ON stp.added_by = u.user_id
                        WHERE
                            1
                            AND st.date_added >=  '" . $this->db->escape($start_date) . "'
                            AND st.date_added <= '" . $this->db->escape($end_date) . "'
                            AND st.status   = 5

                    UNION ALL
                    #lot transfer out
                    SELECT
                            lt.doc_date as date_added,
                            'Lot Transfer' AS type,
                            ltp.product_id,
                            lt.doc_no AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            1 AS person_type,
                            0 AS action,
                            ltp.qty AS quantity,
                            NULL AS 'add',
                            ltp.qty AS deduct,
                            lt.store_id,
                            ltp.source_location_id as location_id,
                            (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date,
                            lt.description AS remark,
                            1 AS stock_type,
                            ltp.remark AS product_description
                        FROM
                            `oc_lot_transfer_product` ltp
                                LEFT JOIN
                                    `oc_lot_transfer` lt
                                        ON ltp.lot_transfer_id = lt.lot_transfer_id
                                LEFT JOIN
                                    `oc_user` u
                                        ON ltp.added_by = u.user_id
                        WHERE
                            1
                            AND lt.doc_date >=  '" . $this->db->escape($start_date) . "'
                            AND lt.doc_date <= '" . $this->db->escape($end_date) . "'
                            AND lt.status   = 5

                    UNION ALL
                    #lot transfer in
                    SELECT
                            lt.doc_date as date_added,
                            'Lot Transfer' AS type,
                            ltp.product_id,
                            lt.doc_no AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            1 AS person_type,
                            1 AS action,
                            ltp.qty AS quantity,
                            ltp.qty AS 'add',
                            NULL AS deduct,
                            lt.store_id,
                            ltp.target_location_id as location_id,
                            (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date,
                            lt.description AS remark,
                            1 AS stock_type,
                            ltp.remark AS product_description
                        FROM
                            `oc_lot_transfer_product` ltp
                                LEFT JOIN
                                    `oc_lot_transfer` lt
                                        ON ltp.lot_transfer_id = lt.lot_transfer_id
                                LEFT JOIN
                                    `oc_user` u
                                        ON ltp.added_by = u.user_id
                        WHERE
                            1
                            AND lt.doc_date >=  '" . $this->db->escape($start_date) . "'
                            AND lt.doc_date <= '" . $this->db->escape($end_date) . "'
                            AND lt.status   = 5

                    UNION ALL
                    #stock received
                    SELECT
                            srv.date_added,
                            'Stock Received' AS type,
                            srp.product_id,
                            srv.doc_no AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            1 AS person_type,
                            1 AS action,
                            srp.quantity AS quantity,
                            srp.quantity AS 'add',
                            NULL AS deduct,
                            srv.store_id,
                            srp.location_id,
                            (CASE WHEN srp.batch_date is NULL THEN '0000-00-00' ELSE srp.batch_date END) AS batch_date,
                            srv.description AS remark,
                            1 AS stock_type,
                            srp.description AS product_description
                        FROM
                            `oc_stock_received_product` srp
                                LEFT JOIN
                                    `oc_stock_received` srv
                                        ON srp.stock_received_id = srv.stock_received_id
                                LEFT JOIN
                                    `oc_user` u
                                        ON srp.added_by = u.user_id
                        WHERE
                            1
                            AND srv.date_added >=  '" . $this->db->escape($start_date) . "'
                            AND srv.date_added <= '" . $this->db->escape($end_date) . "'
                            AND srv.status   = 5

                    UNION ALL
                    #stock adjustment
                    SELECT
                            sai.date_added,
                            'Stock Adjustment' AS type,
                            sai.product_id,
                            sa.invoice_prefix AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            1 AS person_type,
                            sai.action,
                            sai.qty AS quantity,
                            (CASE WHEN sai.action = 1 THEN sai.qty
                            ELSE NULL END) AS 'add',
                            (CASE WHEN sai.action = 1 THEN NULL
                            ELSE sai.qty END) AS deduct,
                            sa.store_id,
                            sai.location_id,
                            (CASE WHEN sai.batch_date is NULL THEN '0000-00-00' ELSE sai.batch_date END) AS batch_date,
                            sa.description as remark,
                            1 AS stock_type,
                            sai.remark AS product_description
                        FROM
                            `oc_stock_adjustment_item` sai
                                LEFT JOIN
                                    `oc_stock_adjustment` sa
                                        ON sai.stock_adjustment_id = sa.stock_adjustment_id
                                LEFT JOIN
                                    `oc_user` u
                                        ON sa.add_by = u.user_id
                        WHERE
                            1
                            AND sai.date_added >=  '" . $this->db->escape($start_date) . "'
                            AND sai.date_added <= '" . $this->db->escape($end_date) . "'
                            AND sa.status   = 5

                    UNION ALL

                    #stock issue
                    SELECT
                            sii.date_added,
                            'Stock Issue' AS type,
                            sii.product_id,
                            si.invoice_prefix AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            1 AS person_type,
                            0 AS action,
                            sii.quantity,
                            NULL AS 'add',
                            sii.quantity AS deduct,
                            si.store_id,
                            sii.location_id,
                            (CASE WHEN sii.batch_date is NULL THEN '0000-00-00' ELSE sii.batch_date END) AS batch_date,
                            si.description AS remark,
                            1 AS stock_type,
                            sii.remark AS product_description
                        FROM
                            `oc_stock_issue_item` sii
                                LEFT JOIN
                                    `oc_stock_issue` si
                                        ON sii.stock_issue_id = si.stock_issue_id
                                LEFT JOIN
                                    `oc_user` u
                                        ON si.add_by = u.user_id
                        WHERE
                            1
                            AND sii.date_added >=  '" . $this->db->escape($start_date) . "'
                            AND sii.date_added <= '" . $this->db->escape($end_date) . "'
                            AND si.status   = 5

                    UNION ALL

                    #received from store,出货
                    SELECT
                            st.received_date as date_added,
                            'Stock Transfer' AS type,
                            std.product_id,
                            st.transfer_no AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            1 AS person_type,
                            (CASE WHEN st.from_store in ( " . $store_id . ") THEN 1 ELSE 0 END) AS action,
                            std.received_quantity AS quantity,
                            (CASE WHEN st.from_store in ( " . $store_id . ") THEN std.received_quantity ELSE NULL END) AS 'add',
                            (CASE WHEN st.to_store in ( " . $store_id . ") THEN std.received_quantity ELSE NULL END) AS deduct,
                            st.to_store AS store_id,
                            0 as location_id,
                            '0000-00-00' as batch_date,
                            '' AS remark,
                            2 AS stock_type,
                            st.remark AS product_description
                        FROM
                            `oc_stock_transfer_detail` std
                                LEFT JOIN
                                    `oc_stock_transfer` st
                                        ON std.stock_transfer_id = st.stock_transfer_id
                                LEFT JOIN
                                    `oc_user` u
                                        ON st.created_by = u.user_id
                        WHERE
                            1
                            AND std.received_quantity > 0
                            AND st.received_date >=  '" . $this->db->escape($start_date) . "'
                            AND st.received_date <= '" . $this->db->escape($end_date) . "'
                            AND st.status >= 4

                    UNION ALL

                    #tranfer to store,进货
                    SELECT
                            st.transfer_date as date_added,
                            'Stock Transfer' AS type,
                            std.product_id,
                            st.transfer_no AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            1 AS person_type,
                            (CASE WHEN st.from_store  in (" . $store_id . ") THEN 1 ELSE 0 END) AS action,
                            std.received_quantity AS quantity,
                            (CASE WHEN st.from_store  in (" . $store_id . ") THEN std.received_quantity ELSE NULL END) AS 'add',
                            (CASE WHEN st.to_store in (" . $store_id . ") THEN std.received_quantity ELSE NULL END) AS deduct,
                            st.from_store AS store_id,
                            0 as location_id,
                            '0000-00-00' as batch_date,
                            '' AS remark,
                            2 AS stock_type,
                            st.remark AS product_description
                        FROM
                            `oc_stock_transfer_detail` std
                                LEFT JOIN
                                    `oc_stock_transfer` st
                                        ON std.stock_transfer_id = st.stock_transfer_id
                                LEFT JOIN
                                    `oc_user` u
                                        ON st.created_by = u.user_id
                        WHERE
                            1
                            AND std.received_quantity > 0
                            AND st.transfer_date >=  '" . $this->db->escape($start_date) . "'
                            AND st.transfer_date <= '" . $this->db->escape($end_date) . "'
                            AND st.status >= 4

                    UNION ALL

                    #sold sale order
                    SELECT
                            o.date_added,
                            'Order' AS type,
                            op.product_id,
                            o.invoice_prefix AS id,
                            CONCAT(o.firstname, ' ', o.lastname) AS name,
                            2 AS person_type,
                            0 as action,
                            ROUND(op.weight,2) AS quantity,
                            NULL as 'add',
                            ROUND(op.weight,2) AS deduct,
                            o.store_id,
                            0 as location_id,
                            '0000-00-00' as batch_date,
                            o.comment as remark,
                            3 AS stock_type,
                            '' AS product_description
                        FROM
                            `oc_order_product` op
                                LEFT JOIN
                                    `oc_order` o
                                        ON op.order_id = o.order_id
                                LEFT JOIN
                                    `oc_weight_class` wc
                                        ON op.weight_class_id = wc.weight_class_id
                        WHERE
                            1
                            AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'
                            AND o.order_status_id = '5'
                            AND o.invoice_prefix <>''
                            AND o.invoice_wholesaler = 0

                    UNION ALL
                    
                    #sold order wholesaler
                    SELECT
                            o.date_added,
                            'Wholesale Order' AS type,
                            op.product_id,
                            o.invoice_prefix AS id,
                            CONCAT(o.firstname, ' ', o.lastname) AS name,
                            2 AS person_type,
                            0 as action,
                            ROUND(op.total_weight,2) AS quantity,
                            NULL as 'add',
                            ROUND(op.total_weight,2) AS deduct,
                            o.store_id,
                            0 as location_id,
                            '0000-00-00' as batch_date,
                            o.comment as remark,
                            3 AS stock_type,
                            '' AS product_description
                        FROM
                            `oc_order_product` op
                                LEFT JOIN
                                    `oc_order` o
                                        ON op.order_id = o.order_id
                                LEFT JOIN
                                    `oc_weight_class` wc
                                        ON op.weight_class_id = wc.weight_class_id
                        WHERE
                            1
                            AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'
                            AND o.order_status_id = '5'
                            AND o.invoice_prefix <>''
                            AND o.invoice_wholesaler = 1

                    UNION ALL

                    #herbal remedies
                    SELECT
                            o.date_added,
                            'Herbal Remedies' AS type,
                            csp.product_id,
                            CONCAT(o.invoice_prefix,'-',cs.invoice_prefix) AS id,
                            CONCAT(o.firstname, ' ', o.lastname) AS name,
                            2 AS person_type,
                            0 as action,
                            t_weight AS quantity,
                            NULL AS 'add',
                            t_weight AS deduct,
                            o.store_id,
                            0 as location_id,
                            '0000-00-00' as batch_date,
                            cs.remark,
                            3 stock_type,
                            '' AS product_description
                        FROM
                            `oc_clinicalsale_product` csp
                                LEFT JOIN
                                    `oc_clinical_sale` cs
                                        ON csp.clinical_sale_id = cs.clinical_sale_id
                                LEFT JOIN
                                    `oc_order` o
                                        ON cs.order_id = o.order_id
                        WHERE
                            1
                            AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'
                            AND o.order_status_id = '5'
                            AND o.invoice_prefix <>''

                    UNION ALL

                    #purchase receive
                    SELECT
                            pr.date_added,
                            'Purchase Received' AS type,
                            prp.product_id,
                            pr.invoice_prefix AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            1 AS person_type,
                            1 AS action,
                            prp.quantity,
                            prp.quantity AS 'add',
                            NULL AS deduct,
                            pr.store_id,
                            0 as location_id,
                            '0000-00-00' as batch_date,
                            pr.comment as remark,
                            4 AS stock_type,
                            '' AS product_description
                        FROM
                            `oc_purchase_receive_product` prp
                                LEFT JOIN
                                    `oc_purchase_receive` pr
                                        ON prp.purchase_receive_id = pr.purchase_receive_id
                                LEFT JOIN
                                    `oc_user` u
                                        ON pr.add_by = u.user_id
                        WHERE
                            1
                            AND pr.order_status_id = '5'
                            AND pr.date_added >=  '" . $this->db->escape($start_date) . "'
                            AND pr.date_added <= '" . $this->db->escape($end_date) . "'

                    UNION ALL

                    #purchase invoice
                    SELECT
                            pi.date_added,
                            'Purchase Invoice' AS type,
                            pip.product_id,
                            pi.invoice_prefix AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            1 AS person_type,
                            1 AS action,
                            pip.quantity,
                            pip.quantity AS 'add',
                            NULL AS deduct,
                            pi.store_id,
                            0 as location_id,
                            '0000-00-00' as batch_date,
                            pi.comment as remark,
                            5 AS stock_type,
                            '' AS product_description
                        FROM
                            `oc_purchase_invoice_product` pip
                                LEFT JOIN
                                    `oc_purchase_invoice` pi
                                        ON pip.purchase_invoice_id = pi.purchase_invoice_id
                                LEFT JOIN
                                    `oc_user` u
                                        ON pi.add_by = u.user_id
                        WHERE
                            1
                            AND pip.product_id != 0
                            AND pi.type IN (3, 5, 6)
                            AND pi.stock_affect = '1'
                            AND pi.order_status_id = '5'
                            AND pi.date_added >=  '" . $this->db->escape($start_date) . "'
                            AND pi.date_added <= '" . $this->db->escape($end_date) . "'

                    UNION ALL

                    #production
                    SELECT
                            p.date_added,
                            'Production' AS type,
                            ps.product_id,
                            p.invoice_prefix AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            2 AS person_type,
                            0 as action,
                            ps.quantity,
                            NULL AS 'add',
                            ps.quantity AS deduct,
                            0 AS store_id,
                            0 as location_id,
                            '0000-00-00' as batch_date,
                            '' AS remark,
                            6 stock_type,
                            p.remark AS product_description
                        FROM
                            `oc_production` p
                                LEFT JOIN
                                    `oc_production_stock` ps
                                        ON ps.production_id = p.production_id
                                LEFT JOIN
                                    `oc_user` u
                                        ON p.add_by = u.user_id
                        WHERE
                            1
                            AND ps.product_id != 0
                            AND p.status = '5'
                            AND p.date_added >=  '" . $this->db->escape($start_date) . "'
                            AND p.date_added <= '" . $this->db->escape($end_date) . "'

                    UNION ALL

                    #production add stock
                    SELECT
                            p.date_added,
                            'Production' AS type,
                            p.product_id,
                            p.invoice_prefix AS id,
                            CONCAT(u.firstname, ' ', u.lastname) AS name,
                            1 AS person_type,
                            1 AS action,
                            (p.actual_quantity - a.total_reject_quantity) AS quantity,
                            (p.actual_quantity - a.total_reject_quantity) AS 'add',
                            NULL AS deduct,
                            0 AS store_id,
                            0 as location_id,
                            '0000-00-00' as batch_date,
                            '' AS remark,
                            7 AS stock_type,
                            p.remark AS product_description
                        FROM
                            `oc_production` p
                            LEFT JOIN 
                                (SELECT pro.production_id, (CASE WHEN SUM(proqc.reject_quantity) IS NULL THEN 0 ELSE SUM(proqc.reject_quantity) END) AS total_reject_quantity 
                                    FROM `oc_production` pro 
                                    LEFT JOIN `oc_production_qc` proqc 
                                    ON proqc.production_id = pro.production_id 
                                    GROUP BY pro.production_id)a 
                                ON a.production_id = p.production_id 
                                LEFT JOIN
                                    `oc_user` u
                                        ON p.add_by = u.user_id
                        WHERE
                            1
                            AND p.product_id != 0
                            AND p.status = '5'
                            AND DATE(p.date_added) >=  DATE('" . $this->db->escape($start_date) . "')
                            AND DATE(p.date_added) <= DATE('" . $this->db->escape($end_date) . "') 
                ) a

            LEFT JOIN " . DB_PREFIX . "product p
            ON(a.product_id = p.product_id )

            LEFT JOIN " . DB_PREFIX . "product_description pd
            ON(a.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

            LEFT JOIN " . DB_PREFIX . "product_description cn
            ON (p.product_id = cn.product_id AND cn.language_id = '2')

            LEFT JOIN " . DB_PREFIX . "product_description en
            ON (p.product_id = en.product_id AND en.language_id = '1')

            WHERE 1
            $product_statement
            $store_id_statement
            $location_id_statement
            $filter_batch_date_start_statement
            $product_name_statement
            $product_code_statement
            $filter_doc_type_data
            $description_statement
        ) b
		";
        // print_r($sql);
        $query = $this->db->query($sql);
        $this->printTime(__FUNCTION__, 'End');
        return $query->row['total'];
    }

    public function getOpenStock($datetime, $product_id, $data)
    {
        return $this->getStock($datetime, $product_id, $data);
    }

    public function getCloseStock($datetime, $product_id, $data)
    {
        return $this->getStock($datetime, $product_id, $data);
    }

    public function getOpenStockAll($datetime, $product_id, $data)
    {
        return $this->getStockAll($datetime, $product_id, $data);
    }

    public function getCloseStockAll($datetime, $product_id, $data)
    {
        return $this->getStockAll($datetime, $product_id, $data);
    }

    public function getProductStock($data)
    {
        $this->printTime(__FUNCTION__, 'Start');
        $language_id = $this->config->get('config_language_id');

        $filter_status_id_statement = $data['filter_status_id'] !== NULL ?
            "AND p.status = '" . (int)$data['filter_status_id'] . "'" :
            "";

        $filter_store_id_statement = $data['filter_store_id'] != '' ?
            "AND pts.store_id = '" . (int)$data['filter_store_id'] . "'" :
            "";

        $filter_quantity_from_statement = !empty($data['filter_quantity_from']) ?
            "AND pts.quantity >= '" . $this->db->escape($data['filter_quantity_from']) . "'" :
            "";

        $filter_quantity_to_statement = !empty($data['filter_quantity_to']) ?
            "AND pts.quantity <= '" . $this->db->escape($data['filter_quantity_to']) . "'" :
            "";

        $filter_price_from_statement = !empty($data['filter_price_from']) ?
            "AND p.price >= '" . $this->db->escape($data['filter_price_from']) . "'" :
            "";

        $filter_price_to_statement = !empty($data['filter_price_to']) ?
            "AND p.price <= '" . $this->db->escape($data['filter_price_to']) . "'" :
            "";

        $filter_points_from_statement = !empty($data['filter_points_from']) ?
            "AND p.points >= '" . $this->db->escape($data['filter_points_from']) . "'" :
            "";

        $filter_points_to_statement = !empty($data['filter_points_to']) ?
            "AND p.points <= '" . $this->db->escape($data['filter_points_to']) . "'" :
            "";

        $filter_product_name_statement = !empty($data['filter_product_name']) ?
            "AND (pd_cn.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%' OR pd_en.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%')" :
            "";

        $filter_product_code_statement = !empty($data['filter_product_code']) ?
            "AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'" :
            "";

        $filter_category_statement = !empty($data['filter_category']) ?
            "AND a.category_name LIKE '%" . $this->db->escape($data['filter_category']) . "%'" :
            "";

        $filter_show_all_statement = !empty($data['filter_show_all']) ?
            "" :
            "AND pts.onhand_quantity > 0";
        //  $filter_description_statement = !empty($data['filter_description']) ?
        //     "AND a.description LIKE '%" . $this->db->escape($data['filter_description']) . "%'" :
        //     "";

        $sql = "
            SELECT
                    p.product_id AS product_id,
                    p.code AS code,
                    pd_cn.name AS chinese_name,
                    pd_en.name AS english_name,
                    a.category_name AS category,
                    p.product_type AS type,
                    SUM(pts.onhand_quantity) AS quantity,
                    p.price AS price,
                    p.points AS points,
                    p.status AS status
                FROM
                    `oc_product` p
                        LEFT JOIN
                            `oc_product_to_store` pts
                                ON p.product_id = pts.product_id
                        LEFT JOIN
                            `oc_product_description` pd_cn
                                ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2
                        LEFT JOIN
                            `oc_product_description` pd_en
                                ON p.product_id = pd_en.product_id AND pd_en.language_id = 1
                        LEFT JOIN
                            (SELECT ptc.category_id, ptc.product_id, cd.name AS category_name 
                                FROM `oc_product_to_category` ptc
                                LEFT JOIN `oc_category_description` cd
                                        ON ptc.category_id = cd.category_id
                                        AND cd.language_id = '" . (int)$language_id . "' 
                                        GROUP BY ptc.product_id) a
                                ON a.product_id = p.product_id
                WHERE
                    1
                    $filter_store_id_statement
                    $filter_product_name_statement
                    $filter_product_code_statement
                    $filter_category_statement
                    $filter_show_all_statement
                    $filter_quantity_from_statement
                    $filter_quantity_to_statement
                    $filter_price_from_statement
                    $filter_price_to_statement
                    $filter_points_from_statement
                    $filter_points_to_statement
                    $filter_status_id_statement
                    
                    GROUP BY pts.product_id";

        $sort_data = array(
            'product_id',
            'code',
            'category',
            'chinese_name',
            'english_name',
            'quantity',
            'price',
            'type',
            'points'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY quantity";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        $query = $this->db->query($sql);
        $this->printTime(__FUNCTION__, 'End');
        return $query->rows;
    }

    public function getLocations()
    {
        $sql = "SELECT location_id, concat(warehouse,'>',zone,'>',lot) as name
        FROM " . DB_PREFIX . "wms_location";

        $query = $this->db->query($sql);
        return $query->rows;
    }


    public function getProductStockByTransaction($datetime, $product_id, $store_id, $location_id, $batch_date)
    {

        $store_id_statement = " AND column_store_id ='" . (int)$store_id . "'";

        $location_id_statement = " AND column_location_id='" . (int)$location_id . "'";

        $batch_date_statement = " AND batch_date = '" . $batch_date . "'";

        $product_statement = "AND table_name.product_id = '" . (int)$product_id . "'";

        $sql = "
        SELECT
            SUM((CASE WHEN a.action = 1 THEN a.quantity ELSE (a.quantity * -1) END)) AS stock
        FROM
        (
            #stock return
            SELECT
                    'Stock Return' AS type,
                    sr.product_id,
                    sr.action,
                    sr.qty AS quantity,
                    sr.store_id,
                    sr.location_id,
                    (CASE WHEN sr.batch_date is NULL THEN '0000-00-00' ELSE sr.batch_date END) AS batch_date
                FROM
                    `oc_stock_return` sr
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sr.product_id = product.product_id )
                         LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sr.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (sr.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (sr.product_id = en.product_id AND en.language_id = '1')
                    
                WHERE
                    1
                    " . str_replace('table_name', 'sr', $product_statement) . " 
                    " . str_replace('column_location_id', 'sr.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'sr.store_id', $store_id_statement) . "
                    AND sr.doc_date <  '" . $this->db->escape($datetime) . "'
                    AND sr.status   = 5

            UNION ALL

            #stock take

            SELECT
                    'Stock Take' AS type,
                    stp.product_id,
                    1 AS action,
                    stp.qty AS quantity,
                    st.store_id,
                    stp.location_id,
                    (CASE WHEN stp.batch_date is NULL THEN '0000-00-00' ELSE stp.batch_date END) AS batch_date
                FROM
                    `oc_stock_take_product` stp
                        LEFT JOIN
                            `oc_stock_take` st
                                ON stp.stock_take_id = st.stock_take_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                                ON(stp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(stp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (stp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (stp.product_id = en.product_id AND en.language_id = '1')
                    
                WHERE
                    1
                    " . str_replace('table_name', 'stp', $product_statement) . " 
                    " . str_replace('column_location_id', 'stp.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.store_id', $store_id_statement) . "
                    AND st.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status   = 5

            UNION ALL

            #lot transfer out
            SELECT
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    0 AS action,
                    ltp.qty AS quantity,
                    lt.store_id,
                    ltp.source_location_id AS location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ltp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ltp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (ltp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (ltp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ltp', $product_statement) . " 
                    " . str_replace('column_location_id', 'ltp.source_location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'lt.store_id', $store_id_statement) . "
                    AND lt.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND lt.status   = 5

            UNION ALL

            #lot transfer in
            SELECT
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    1 AS action,
                    ltp.qty AS quantity,
                    lt.store_id,
                    ltp.target_location_id AS location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ltp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ltp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (ltp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (ltp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ltp', $product_statement) . " 
                    " . str_replace('column_location_id', 'ltp.target_location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'lt.store_id', $store_id_statement) . "
                    AND lt.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND lt.status   = 5

            UNION ALL
            #stock received
            SELECT
                    'Stock Received' AS type,
                    srp.product_id,
                    1 AS action,
                    srp.quantity AS quantity,
                    srv.store_id,
                    srp.location_id,
                    (CASE WHEN srp.batch_date is NULL THEN '0000-00-00' ELSE srp.batch_date END) AS batch_date
                FROM
                    `oc_stock_received_product` srp
                        LEFT JOIN
                            `oc_stock_received` srv
                                ON srp.stock_received_id = srv.stock_received_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(srp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(srp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (srp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (srp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'srp', $product_statement) . " 
                    " . str_replace('column_location_id', 'srp.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'srv.store_id', $store_id_statement) . "
                    AND srv.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND srv.status   = 5

            UNION ALL
            #stock adjustment
            SELECT
                    'Stock Adjustment' AS type,
                    sai.product_id,
                    sai.action,
                    sai.qty AS quantity,
                    sa.store_id,
                    sai.location_id,
                    (CASE WHEN sai.batch_date is NULL THEN '0000-00-00' ELSE sai.batch_date END) AS batch_date
                FROM
                    `oc_stock_adjustment_item` sai
                        LEFT JOIN
                            `oc_stock_adjustment` sa
                                ON sai.stock_adjustment_id = sa.stock_adjustment_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sai.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sai.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (sai.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (sai.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'sai', $product_statement) . " 
                    " . str_replace('column_location_id', 'sai.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'sa.store_id', $store_id_statement) . "
                    AND sai.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND sa.status   = 5

            UNION ALL

            #stock issue
            SELECT
                    'Stock Issue' AS type,
                    sii.product_id,
                    0 AS action,
                    sii.quantity,
                    si.store_id,
                    sii.location_id,
                    (CASE WHEN sii.batch_date is NULL THEN '0000-00-00' ELSE sii.batch_date END) AS batch_date
                FROM
                    `oc_stock_issue_item` sii
                        LEFT JOIN
                            `oc_stock_issue` si
                                ON sii.stock_issue_id = si.stock_issue_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sii.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sii.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (sii.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (sii.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'sii', $product_statement) . " 
                    " . str_replace('column_location_id', 'sii.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'si.store_id', $store_id_statement) . "
                    AND sii.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND si.status   = 5

            UNION ALL

            #received from store,出货
            SELECT
                    'Stock Transfer' AS type,
                    std.product_id,
                    (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    st.to_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(std.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(std.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (std.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (std.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'std', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.to_store', $store_id_statement) . "
                    AND std.received_quantity > 0
                    AND st.received_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status >= 4

            UNION ALL

            #tranfer to store,进货
            SELECT
                    'Stock Transfer' AS type,
                    std.product_id,
                    (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    st.from_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(std.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(std.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (std.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (std.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'std', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.from_store', $store_id_statement) . "
                    AND std.received_quantity > 0
                    AND st.transfer_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status >= 4

            UNION ALL

            #sold sale order
            SELECT
                    'Order' AS type,
                    op.product_id,
                    0 as action,
                    ROUND(op.weight,2) AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(op.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(op.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (op.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (op.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'op', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 0

            UNION ALL
            
            #sold order wholesaler
            SELECT
                    'Wholesale Order' AS type,
                    op.product_id,
                    0 as action,
                    ROUND(op.total_weight,2) AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(op.product_id = product.product_id )    
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(op.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (op.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (op.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'op', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 1

            UNION ALL

            #herbal remedies
            SELECT
                    'Herbal Remedies' AS type,
                    csp.product_id,
                    0 as action,
                    t_weight AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_clinicalsale_product` csp
                        LEFT JOIN
                            `oc_clinical_sale` cs
                                ON csp.clinical_sale_id = cs.clinical_sale_id
                        LEFT JOIN
                            `oc_order` o
                                ON cs.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(csp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(csp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (csp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (csp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'csp', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''

            UNION ALL

            #purchase receive
            SELECT
                    'Purchase Received' AS type,
                    prp.product_id,
                    1 AS action,
                    prp.quantity,
                    pr.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_purchase_receive_product` prp
                        LEFT JOIN
                            `oc_purchase_receive` pr
                                ON prp.purchase_receive_id = pr.purchase_receive_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(prp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(prp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (prp.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (prp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'prp', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'pr.store_id', $store_id_statement) . "
                    AND pr.order_status_id = '5'
                    AND pr.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #purchase invoice
            SELECT
                    'Purchase Invoice' AS type,
                    pip.product_id,
                    1 AS action,
                    pip.quantity,
                    pi.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_purchase_invoice_product` pip
                        LEFT JOIN
                            `oc_purchase_invoice` pi
                                ON pip.purchase_invoice_id = pi.purchase_invoice_id
                        LEFT JOIN " . DB_PREFIX . "product product
                            ON(pip.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(pip.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (pip.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (pip.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'pip', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'pi.store_id', $store_id_statement) . "
                    AND pip.product_id != 0
                    AND pi.type IN (3, 5, 6)
                    AND pi.stock_affect = '1'
                    AND pi.order_status_id = '5'
                    AND pi.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #production
            SELECT
                    'Production' AS type,
                    ps.product_id,
                    0 as action,
                    ps.quantity,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_production` p
                        LEFT JOIN
                            `oc_production_stock` ps
                                ON ps.production_id = p.production_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ps.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ps.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (ps.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (ps.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ps', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', '0', $store_id_statement) . "
                    AND ps.product_id != 0
                    AND p.status = '5'
                    AND p.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #production add stock
            SELECT
                    'Production' AS type,
                    p.product_id,
                    1 AS action,
                    (p.actual_quantity - a.total_reject_quantity) AS quantity,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_production` p
                    LEFT JOIN 
                        (SELECT pro.production_id, (CASE WHEN SUM(proqc.reject_quantity) IS NULL THEN 0 ELSE SUM(proqc.reject_quantity) END) AS total_reject_quantity 
                            FROM `oc_production` pro 
                            LEFT JOIN `oc_production_qc` proqc 
                            ON proqc.production_id = pro.production_id 
                            GROUP BY pro.production_id)a 
                        ON a.production_id = p.production_id 
                    LEFT JOIN " . DB_PREFIX . "product product 
                        ON(p.product_id = product.product_id )
                    LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(p.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                    
                    LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (p.product_id = cn.product_id AND cn.language_id = '2')
                    
                    LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (p.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'p', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', '0', $store_id_statement) . "
                    AND p.product_id != 0
                    AND p.status = '5'
                    AND p.date_added  <  '" . $this->db->escape($datetime) . "'
            ) a
        WHERE 1
        $batch_date_statement
		";

        $query = $this->db->query($sql);
        return $query->row['stock'] ? $query->row['stock'] : 0;
    }


    protected function printTime($function, $pos)
    {
        //echo '<br><br><h3>'.$function.':'.$pos.'</h3><br>';

        $date = date('H:i:s:u');
        //        echo $date;
    }

   
    public function getlocation($product_id){
        $sql="
                SELECT DISTINCT
                    pts.location_id AS location_id,
                    wl.warehouse AS warehouse,
                    wl.zone AS zone,
                    wl.lot AS lot
                FROM
                " . DB_PREFIX . "product_to_store pts
                LEFT JOIN " . DB_PREFIX . "wms_location wl
                ON pts.location_id = wl.location_id
                WHERE product_id = '" . (int)$product_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->rows; 
    }

    public function getbatchdate($product_id){
            $sql="
                SELECT DISTINCT
                    pts.batch_date AS batch_date
                FROM
                " . DB_PREFIX . "product_to_store pts
                LEFT JOIN " . DB_PREFIX . "wms_location wl
                ON pts.location_id = wl.location_id
                WHERE product_id = '" . (int)$product_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->rows; 

    }

    public function getStockCalculationAll($product_id, $data)
    {
        $this->printTime(__FUNCTION__, 'Start');
        $open_date = !empty($data['filter_open_date']) ? $data['filter_open_date'] : '1970-01-01';

        $close_date = !empty($data['filter_close_date']) ? $data['filter_close_date'] : date('Y-m-d');


        $store_id = $data['filter_store_id'] != '' ? $data['filter_store_id'] : '';

        $store_id_statement = $data['filter_store_id'] != '' ? "AND a.store_id in (" . $store_id . ")" : '';

        $location_id_statement = $data['filter_location'] != '' ? "AND a.location_id in (" . $data['filter_location'] . ")" : '';

        $product_name_statement = $data['filter_product_name'] != '' ? "AND CONCAT(en.name,' ',cn.name) LIKE '%" . $data['filter_product_name'] . "%'" : '';

        $product_code_statement = $data['filter_product_code'] != '' ? "AND p.code LIKE '%" . $data['filter_product_code'] . "%'" : '';

        if ($product_id == 0) {
            $product_statement = '';
        } else {
            $product_statement = "AND a.product_id = '" . (int)$product_id . "'";
        }

        $start_date = $this->db->escape($open_date) .  " 00:00:00";
        $end_date  = $this->db->escape($close_date) .  " 23:59:59";

        $sql = "
		SELECT
			SUM(b.add) AS total_add,
            SUM(b.deduct) AS total_deduct
		FROM
		(
               
            SELECT
            a.date_added,
            a.type,
            a.product_id,
            pd.name AS product_name,
            p.code AS product_code,
            a.id,
            a.name,
            a.person_type,
            a.action,
            a.quantity,
            a.add,
            a.deduct,
            a.store_id,
            a.location_id,
            a.batch_date
        FROM
        (
            #stock return
            SELECT
                    sr.doc_date as date_added,
                    'Stock Return' AS type,
                    sr.product_id,
                    sr.doc_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    sr.action,
                    sr.qty AS quantity,
                    (CASE WHEN sr.action=1 THEN sr.qty ELSE NULL END) AS 'add',
                    (CASE WHEN sr.action=1 THEN NULL ELSE sr.qty END) AS deduct,
                    0 AS store_id,
                    sr.location_id,
                    (CASE WHEN sr.batch_date is NULL THEN '0000-00-00' ELSE sr.batch_date END) AS batch_date,
                    sr.description AS remark,
                    1 AS stock_type
                FROM
                    `oc_stock_return` sr
                        LEFT JOIN
                            `oc_user` u
                                ON sr.added_by = u.user_id
                WHERE
                    1
                    AND sr.doc_date >=  '" . $this->db->escape($start_date) . "'
                    AND sr.doc_date <= '" . $this->db->escape($end_date) . "'
                    AND sr.status   = 5

            UNION ALL
            #stock take
            SELECT
                    st.date_added as date_added,
                    'Stock Take' AS type,
                    stp.product_id,
                    st.doc_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    stp.qty AS quantity,
                    stp.qty AS 'add',
                    NULL AS deduct,
                    st.store_id,
                    stp.location_id,
                    (CASE WHEN stp.batch_date is NULL THEN '0000-00-00' ELSE stp.batch_date END) AS batch_date,
                    stp.remark,
                    1 AS stock_type
                FROM
                    `oc_stock_take_product` stp
                        LEFT JOIN
                            `oc_stock_take` st
                                ON stp.stock_take_id = st.stock_take_id
                        LEFT JOIN
                            `oc_user` u
                                ON stp.added_by = u.user_id
                WHERE
                    1
                    AND st.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND st.date_added <= '" . $this->db->escape($end_date) . "'
                    AND st.status   = 5

            UNION ALL
            #lot transfer out
            SELECT
                    lt.doc_date as date_added,
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    lt.doc_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    0 AS action,
                    ltp.qty AS quantity,
                    NULL AS 'add',
                    ltp.qty AS deduct,
                    lt.store_id,
                    ltp.source_location_id as location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date,
                    ltp.remark,
                    1 AS stock_type
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON ltp.added_by = u.user_id
                WHERE
                    1
                    AND lt.doc_date >=  '" . $this->db->escape($start_date) . "'
                    AND lt.doc_date <= '" . $this->db->escape($end_date) . "'
                    AND lt.status   = 5

            UNION ALL
            #lot transfer in
            SELECT
                    lt.doc_date as date_added,
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    lt.doc_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    ltp.qty AS quantity,
                    ltp.qty AS 'add',
                    NULL AS deduct,
                    lt.store_id,
                    ltp.target_location_id as location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date,
                    ltp.remark,
                    1 AS stock_type
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON ltp.added_by = u.user_id
                WHERE
                    1
                    AND lt.doc_date >=  '" . $this->db->escape($start_date) . "'
                    AND lt.doc_date <= '" . $this->db->escape($end_date) . "'
                    AND lt.status   = 5

            UNION ALL
            #stock received
            SELECT
                    srv.date_added,
                    'Stock Received' AS type,
                    srp.product_id,
                    srv.doc_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    srp.quantity AS quantity,
                    srp.quantity AS 'add',
                    NULL AS deduct,
                    srv.store_id,
                    srp.location_id,
                    (CASE WHEN srp.batch_date is NULL THEN '0000-00-00' ELSE srp.batch_date END) AS batch_date,
                    srp.reason AS remark,
                    1 AS stock_type
                FROM
                    `oc_stock_received_product` srp
                        LEFT JOIN
                            `oc_stock_received` srv
                                ON srp.stock_received_id = srv.stock_received_id
                        LEFT JOIN
                            `oc_user` u
                                ON srp.added_by = u.user_id
                WHERE
                    1
                    AND srv.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND srv.date_added <= '" . $this->db->escape($end_date) . "'
                    AND srv.status   = 5

            UNION ALL

            #stock adjustment
            SELECT
                    sai.date_added,
                    'Stock Adjustment' AS type,
                    sai.product_id,
                    sa.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    sai.action,
                    sai.qty AS quantity,
                    (CASE WHEN sai.action = 1 THEN sai.qty
                    ELSE NULL END) AS 'add',
                    (CASE WHEN sai.action = 1 THEN NULL
                    ELSE sai.qty END) AS deduct,
                    sa.store_id,
                    sai.location_id,
                    (CASE WHEN sai.batch_date is NULL THEN '0000-00-00' ELSE sai.batch_date END) AS batch_date,
                    sa.description as remark,
                    1 AS stock_type
                FROM
                    `oc_stock_adjustment_item` sai
                        LEFT JOIN
                            `oc_stock_adjustment` sa
                                ON sai.stock_adjustment_id = sa.stock_adjustment_id
                        LEFT JOIN
                            `oc_user` u
                                ON sa.add_by = u.user_id
                WHERE
                    1
                    AND sai.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND sai.date_added <= '" . $this->db->escape($end_date) . "'
                    AND sa.status   = 5

            UNION ALL

            #stock issue
            SELECT
                    sii.date_added,
                    'Stock Issue' AS type,
                    sii.product_id,
                    si.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    0 AS action,
                    sii.quantity,
                    NULL AS 'add',
                    sii.quantity AS deduct,
                    si.store_id,
                    sii.location_id,
                    (CASE WHEN sii.batch_date is NULL THEN '0000-00-00' ELSE sii.batch_date END) AS batch_date,
                    sii.remark,
                    1 AS stock_type
                FROM
                    `oc_stock_issue_item` sii
                        LEFT JOIN
                            `oc_stock_issue` si
                                ON sii.stock_issue_id = si.stock_issue_id
                        LEFT JOIN
                            `oc_user` u
                                ON si.add_by = u.user_id
                WHERE
                    1
                    AND sii.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND sii.date_added <= '" . $this->db->escape($end_date) . "'
                    AND si.status   = 5

            UNION ALL

            #received from store,出货
            SELECT
                    st.received_date as date_added,
                    'Stock Transfer' AS type,
                    std.product_id,
                    st.transfer_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    (CASE WHEN st.from_store in ($store_id) THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    (CASE WHEN st.from_store in ($store_id) THEN std.received_quantity ELSE NULL END) AS 'add',
                    (CASE WHEN st.to_store in ($store_id) THEN std.received_quantity ELSE NULL END) AS deduct,
                    st.to_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    st.remark,
                    2 AS stock_type
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON st.created_by = u.user_id
                WHERE
                    1
                    AND std.received_quantity > 0
                    AND st.received_date >=  '" . $this->db->escape($start_date) . "'
                    AND st.received_date <= '" . $this->db->escape($end_date) . "'
                    AND st.status >= 4

            UNION ALL

            #tranfer to store,进货
            SELECT
                    st.transfer_date as date_added,
                    'Stock Transfer' AS type,
                    std.product_id,
                    st.transfer_no AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    (CASE WHEN st.from_store in ($store_id) THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    (CASE WHEN st.from_store in ($store_id) THEN std.received_quantity ELSE NULL END) AS 'add',
                    (CASE WHEN st.to_store in ($store_id) THEN std.received_quantity ELSE NULL END) AS deduct,
                    st.from_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    st.remark,
                    2 AS stock_type
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON st.created_by = u.user_id
                WHERE
                    1
                    AND std.received_quantity > 0
                    AND st.transfer_date >=  '" . $this->db->escape($start_date) . "'
                    AND st.transfer_date <= '" . $this->db->escape($end_date) . "'
                    AND st.status >= 4

            UNION ALL

            #sold sale order
            SELECT
                    o.date_added,
                    'Order' AS type,
                    op.product_id,
                    o.invoice_prefix AS id,
                    CONCAT(o.firstname, ' ', o.lastname) AS name,
                    2 AS person_type,
                    0 as action,
                    ROUND(op.weight,2) AS quantity,
                    NULL as 'add',
                    ROUND(op.weight,2) AS deduct,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    o.comment as remark,
                    3 AS stock_type
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN
                            `oc_weight_class` wc
                                ON op.weight_class_id = wc.weight_class_id
                WHERE
                    1
                    AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 0

            UNION ALL
            
            #sold order wholesaler
            SELECT
                    o.date_added,
                    'Wholesale Order' AS type,
                    op.product_id,
                    o.invoice_prefix AS id,
                    CONCAT(o.firstname, ' ', o.lastname) AS name,
                    2 AS person_type,
                    0 as action,
                    ROUND(op.total_weight,2) AS quantity,
                    NULL as 'add',
                    ROUND(op.total_weight,2) AS deduct,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    o.comment as remark,
                    3 AS stock_type
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN
                            `oc_weight_class` wc
                                ON op.weight_class_id = wc.weight_class_id
                WHERE
                    1
                    AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 1

            UNION ALL

            #herbal remedies
            SELECT
                    o.date_added,
                    'Herbal Remedies' AS type,
                    csp.product_id,
                    CONCAT(o.invoice_prefix,'-',cs.invoice_prefix) AS id,
                    CONCAT(o.firstname, ' ', o.lastname) AS name,
                    2 AS person_type,
                    0 as action,
                    t_weight AS quantity,
                    NULL AS 'add',
                    t_weight AS deduct,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    cs.remark,
                    3 stock_type
                FROM
                    `oc_clinicalsale_product` csp
                        LEFT JOIN
                            `oc_clinical_sale` cs
                                ON csp.clinical_sale_id = cs.clinical_sale_id
                        LEFT JOIN
                            `oc_order` o
                                ON cs.order_id = o.order_id
                WHERE
                    1
                    AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''

            UNION ALL

            #purchase receive
            SELECT
                    pr.date_added,
                    'Purchase Received' AS type,
                    prp.product_id,
                    pr.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    prp.quantity,
                    prp.quantity AS 'add',
                    NULL AS deduct,
                    pr.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    pr.comment as remark,
                    4 AS stock_type
                FROM
                    `oc_purchase_receive_product` prp
                        LEFT JOIN
                            `oc_purchase_receive` pr
                                ON prp.purchase_receive_id = pr.purchase_receive_id
                        LEFT JOIN
                            `oc_user` u
                                ON pr.add_by = u.user_id
                WHERE
                    1
                    AND pr.order_status_id = '5'
                    AND pr.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND pr.date_added <= '" . $this->db->escape($end_date) . "'

            UNION ALL

            #purchase invoice
            SELECT
                    pi.date_added,
                    'Purchase Invoice' AS type,
                    pip.product_id,
                    pi.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    pip.quantity,
                    pip.quantity AS 'add',
                    NULL AS deduct,
                    pi.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    pi.comment as remark,
                    5 AS stock_type
                FROM
                    `oc_purchase_invoice_product` pip
                        LEFT JOIN
                            `oc_purchase_invoice` pi
                                ON pip.purchase_invoice_id = pi.purchase_invoice_id
                        LEFT JOIN
                            `oc_user` u
                                ON pi.add_by = u.user_id
                WHERE
                    1
                    AND pip.product_id != 0
                    AND pi.type IN (3, 5, 6)
                    AND pi.stock_affect = '1'
                    AND pi.order_status_id = '5'
                    AND pi.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND pi.date_added <= '" . $this->db->escape($end_date) . "'

            UNION ALL

            #production
            SELECT
                    p.date_added,
                    'Production' AS type,
                    ps.product_id,
                    p.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    2 AS person_type,
                    0 as action,
                    ps.quantity,
                    NULL AS 'add',
                    ps.quantity AS deduct,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    p.remark,
                    6 stock_type
                FROM
                    `oc_production` p
                        LEFT JOIN
                            `oc_production_stock` ps
                                ON ps.production_id = p.production_id
                        LEFT JOIN
                            `oc_user` u
                                ON p.add_by = u.user_id
                WHERE
                    1
                    AND ps.product_id != 0
                    AND p.status = '5'
                    AND p.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND p.date_added <= '" . $this->db->escape($end_date) . "'

            UNION ALL

            #production add stock
            SELECT
                    p.date_added,
                    'Production' AS type,
                    p.product_id,
                    p.invoice_prefix AS id,
                    CONCAT(u.firstname, ' ', u.lastname) AS name,
                    1 AS person_type,
                    1 AS action,
                    (p.actual_quantity - a.total_reject_quantity) AS quantity,
                    (p.actual_quantity - a.total_reject_quantity) AS 'add',
                    NULL AS deduct,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date,
                    p.remark,
                    7 AS stock_type
                FROM
                    `oc_production` p
                    LEFT JOIN 
                        (SELECT pro.production_id, (CASE WHEN SUM(proqc.reject_quantity) IS NULL THEN 0 ELSE SUM(proqc.reject_quantity) END) AS total_reject_quantity 
                            FROM `" . DB_PREFIX . "production` pro 
                            LEFT JOIN `oc_production_qc` proqc 
                            ON proqc.production_id = pro.production_id 
                            GROUP BY pro.production_id)a 
                        ON a.production_id = p.production_id 
                        LEFT JOIN
                            `oc_user` u
                                ON p.add_by = u.user_id
                WHERE
                    1
                    AND p.product_id != 0
                    AND p.status = '5'
                    AND DATE(p.date_added) >=  DATE('" . $this->db->escape($start_date) . "')
                    AND DATE(p.date_added) <= DATE('" . $this->db->escape($end_date) . "') 
            ) a

        LEFT JOIN " . DB_PREFIX . "product p
        ON(a.product_id = p.product_id )

        LEFT JOIN " . DB_PREFIX . "product_description pd
        ON(a.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

        LEFT JOIN " . DB_PREFIX . "product_description cn
        ON (p.product_id = cn.product_id AND cn.language_id = '2')

        LEFT JOIN " . DB_PREFIX . "product_description en
        ON (p.product_id = en.product_id AND en.language_id = '1')

        WHERE 1
        $product_statement
        $store_id_statement
        $location_id_statement
        $product_name_statement
        $product_code_statement
		) b
		";

        $query = $this->db->query($sql);
        $this->printTime(__FUNCTION__, 'End');
        return $query->row;
    }
    



}
