<?php
class ModelReportPos extends Model{
	//hold list
	public function getHoldList($data = array()){
		
		$language_id = $this->config->get('config_language_id');
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";

		$order 	= isset($data['order']) ? $data['order'] : "DESC";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_customer_type_statement = "";
		
		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND o.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND o.customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
			SELECT
					o.order_id,
					o.invoice_prefix,
					o.date_added,
					o.store_id,
					o.customer_id,
					(CASE WHEN o.customer_id = 0 THEN 1
					ELSE 2 END) AS customer_type,
					(CASE WHEN o.customer_id = 0 THEN 'Walk In Customer'
					ELSE CONCAT(o.firstname, ' ', o.lastname) END) AS customer_name,
					(CASE WHEN o.customer_id = 0 THEN 'Walk In Customer'
					ELSE
						(SELECT customer_card FROM oc_customer WHERE customer_id = o.customer_id)
					END) AS customer_card,
					o.payment_method,
					os.name AS status,
					o.order_status_id,
					o.points,
					COALESCE((SELECT SUM(ot.value) FROM oc_order_total ot WHERE ot.code = 'rounding' AND ot.order_id = o.order_id), 0) AS rounding,
					COALESCE((SELECT SUM(ot.value) FROM oc_order_total ot WHERE ot.code = 'tax' AND ot.order_id = o.order_id), 0) AS tax,
					COALESCE((SELECT SUM(ot.value) FROM oc_order_total ot WHERE ot.code = 'sub_total' AND ot.order_id = o.order_id), 0) AS subtotal,
					COALESCE((SELECT SUM(ot.value) FROM oc_order_total ot WHERE ot.code = 'total' AND ot.order_id = o.order_id), 0) AS total
			FROM 
				oc_order o
					LEFT JOIN 
						oc_order_status os
							ON o.order_status_id = os.order_status_id AND os.language_id = '1'
			WHERE 
				1
				AND o.order_status_id = 1
				$filter_date_start_statement
				$filter_date_end_statement
				$filter_transaction_start_statement
				$filter_transaction_end_statement
				$filter_store_id_statement
				$filter_customer_type_statement
				$filter_customer_card_statement
				$filter_customer_name_statement
				$filter_payment_method_statement
				GROUP BY o.order_id 
				ORDER BY o.$sort $order
				$limit_statement";
		
		$query = $this->db->query($sql);
		return $query->rows;
	}
	public function getHoldListTotal($data = array()){
		
		$language_id = $this->config->get('config_language_id');
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";

		$order 	= isset($data['order']) ? $data['order'] : "DESC";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_customer_type_statement = "";
		
		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND o.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND o.customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$sql = "
		SELECT
				COUNT(*) AS total
			FROM 
				oc_order o
					LEFT JOIN 
						oc_order_status os
							ON o.order_status_id = os.order_status_id AND os.language_id = '1'
			WHERE 
				1
				AND o.order_status_id = 1
				$filter_date_start_statement
				$filter_date_end_statement
				$filter_transaction_start_statement
				$filter_transaction_end_statement
				$filter_store_id_statement
				$filter_customer_type_statement
				$filter_customer_card_statement
				$filter_customer_name_statement
				$filter_payment_method_statement
				ORDER BY o.$sort $order
		";
		
		$query = $this->db->query($sql);
		return $query->row['total'];
	}
	public function getHoldListTotalSubtotal($data){
		$language_id = $this->config->get('config_language_id');
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_customer_type_statement = "";
		
		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND o.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND o.customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$sql = "
		SELECT 
				SUM(ROUND(ot.value,2)) AS total_subtotal
			FROM 
				`oc_order_total` ot
					LEFT JOIN `oc_order` o
						ON ot.order_id = o.order_id
			WHERE 
				1
				AND ot.code = 'sub_total'
				AND o.order_status_id = 1
				$filter_date_start_statement
				$filter_date_end_statement
				$filter_transaction_start_statement
				$filter_transaction_end_statement
				$filter_store_id_statement
				$filter_customer_type_statement
				$filter_customer_card_statement
				$filter_customer_name_statement
				$filter_payment_method_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_subtotal'];
	}

	public function getHoldListTotalTax($data){
		$language_id = $this->config->get('config_language_id');
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_customer_type_statement = "";
		
		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND o.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND o.customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$sql = "
		SELECT 
				SUM(ROUND(ot.value,2)) AS total_tax
			FROM 
				`oc_order_total` ot
					LEFT JOIN `oc_order` o
						ON ot.order_id = o.order_id
			WHERE 
				1
				AND ot.code = 'tax'
				AND o.order_status_id = 1
				$filter_date_start_statement
				$filter_date_end_statement
				$filter_transaction_start_statement
				$filter_transaction_end_statement
				$filter_store_id_statement
				$filter_customer_type_statement
				$filter_customer_card_statement
				$filter_customer_name_statement
				$filter_payment_method_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_tax'];
	}

	public function getHoldListTotalSales($data){
		$language_id = $this->config->get('config_language_id');
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_customer_type_statement = "";
		
		if(!empty($data['filter_customer_type'])){
			if($data['filter_customer_type'] == 1){
				$filter_customer_type_statement = "AND o.customer_id = 0";
			} else if ($data['filter_customer_type'] == 2){
				$filter_customer_type_statement = "AND o.customer_id != 0";
			}
		}
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_customer_card_statement = (!empty($data['filter_customer_card'])) ? 
		"AND o.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'" : 
		"";
		
		$filter_customer_name_statement = (!empty($data['filter_customer_name'])) ? 
		"AND o.customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" : 
		"";
		
		$filter_payment_method_statement = (!empty($data['filter_payment_method'])) ? 
		"AND o.payment_method = '" . $this->db->escape($data['filter_payment_method']) . "'" : 
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$sql = "
		SELECT 
				SUM(ROUND(ot.value,2)) AS total_sales
			FROM 
				`oc_order_total` ot
					LEFT JOIN `oc_order` o
						ON ot.order_id = o.order_id
			WHERE 
				1
				AND ot.code = 'total'
				AND o.order_status_id = 1
				$filter_date_start_statement
				$filter_date_end_statement
				$filter_transaction_start_statement
				$filter_transaction_end_statement
				$filter_store_id_statement
				$filter_customer_type_statement
				$filter_customer_card_statement
				$filter_customer_name_statement
				$filter_payment_method_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_sales'];
	}

	public function getHoldListInfo($order_id){
		$sql = "
		SELECT
			p.code AS code,
			op.name AS name,
			op.quantity AS quantity,
			op.price AS price,
			op.total_net_amount AS subtotal,
			op.total_tax AS tax,
			op.total
		FROM " . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "product p
		ON op.product_id = p.product_id
		WHERE order_id = '" . (int)$order_id . "'
		
		UNION ALL
		
		SELECT
			sf.invoice_prefix AS code,
			csd.name AS name,
			1 AS quantity,
			si.price AS price,
			si.net_amount AS subtotal,
			si.gst AS tax,
			si.total AS total
		FROM " . DB_PREFIX . "service_form sf
		LEFT JOIN " . DB_PREFIX . "service_item si
		ON sf.service_form_id = si.service_form_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON si.clinicalservice_id = csd.clinicalservice_id
		WHERE 1
		AND language_id = 1
		AND sf.order_id = '" . (int)$order_id . "'
		
		UNION ALL 
		
		SELECT
			invoice_prefix AS code,
			'Herbal Remedies' AS name,
			1 AS quantity,
			d_net_amount AS price,
			d_net_amount AS subtotal,
			d_gst AS tax,
			total_d_gst AS total
		FROM " . DB_PREFIX . "clinical_sale
		WHERE 1
		AND order_id = '" . (int)$order_id . "'";
		
		$query = $this->db->query($sql);
		return $query->rows;
	}
	public function getHoldListInfoTotalTax($order_id){
		$sql = "
		SELECT
			SUM(op.tax) AS total_tax
		FROM " . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "product p
		ON (op.product_id = p.product_id)
		WHERE order_id = " . (int)$order_id;
		
		$query = $this->db->query($sql);
		return $query->row['total_tax'];
	}
	public function getHoldListInfoTotalSubtotal($order_id){
		$sql = "
		SELECT
			SUM(op.price) AS subtotal
		FROM " . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "product p
		ON (op.product_id = p.product_id)
		WHERE order_id = " . (int)$order_id;
		
		$query = $this->db->query($sql);
		return $query->row['subtotal'];
	}
	public function getHoldListInfoTotalSales($order_id){
		$sql = "
		SELECT
			SUM(op.total) AS total_sales
		FROM " . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "product p
		ON (op.product_id = p.product_id)
		WHERE order_id = " . (int)$order_id;
		
		$query = $this->db->query($sql);
		return $query->row['total_sales'];
	}
	
	public function getShipping($data = array()){
		$language_id = $this->config->get('config_language_id');
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "date_added";

		$order 	= isset($data['order']) ? $data['order'] : "DESC";
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_shipping_name_statement = (!empty($data['filter_shipping_name'])) ? 
		"AND st.title LIKE '%" . $this->db->escape($data['filter_shipping_name']) . "%'" : 
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$limit_statement = "";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT 
			o.invoice_prefix,
			o.date_added,
			st.title,
			o.order_status_id,
			os.name AS order_status,
			st.cost,
			st.tax,
			st.total
		FROM " . DB_PREFIX . "shipping_transaction st
		INNER JOIN " . DB_PREFIX . "order o
		ON st.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "order_status os
		ON o.order_status_id = os.order_status_id
		WHERE 1
		AND os.language_id = '" . (int)$language_id . "'
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_payment_status_statement
		$filter_shipping_name_statement
		$filter_store_id_statement
		ORDER BY $sort $order
		$limit_statement
		";
		
		$query = $this->db->query($sql);
		return $query->rows;
	}
	public function getShippingTotal($data = array()){
		$language_id = $this->config->get('config_language_id');
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_shipping_name_statement = (!empty($data['filter_shipping_name'])) ? 
		"AND st.title LIKE '%" . $this->db->escape($data['filter_shipping_name']) . "%'" : 
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$sql = "
		SELECT COUNT(*) AS total FROM(
		SELECT 
			o.invoice_prefix,
			o.date_added,
			st.title,
			o.order_status_id,
			os.name AS order_status,
			st.cost,
			st.tax,
			st.total
		FROM " . DB_PREFIX . "shipping_transaction st
		INNER JOIN " . DB_PREFIX . "order o
		ON st.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "order_status os
		ON o.order_status_id = os.order_status_id
		WHERE 1
		AND os.language_id = '" . (int)$language_id . "'
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_payment_status_statement
		$filter_shipping_name_statement
		$filter_store_id_statement
		)a
		";
		
		$query = $this->db->query($sql);
		return $query->row['total'];
	}
	public function getShippingTotalCost($data = array()){
		$language_id = $this->config->get('config_language_id');
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_shipping_name_statement = (!empty($data['filter_shipping_name'])) ? 
		"AND st.title LIKE '%" . $this->db->escape($data['filter_shipping_name']) . "%'" : 
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$sql = "
		SELECT 
			SUM(st.cost) AS total_cost
		FROM " . DB_PREFIX . "shipping_transaction st
		INNER JOIN " . DB_PREFIX . "order o
		ON st.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "order_status os
		ON o.order_status_id = os.order_status_id
		WHERE 1
		AND os.language_id = '" . (int)$language_id . "'
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_payment_status_statement
		$filter_shipping_name_statement
		$filter_store_id_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_cost'];
	}
	public function getShippingTotalTax($data = array()){
		$language_id = $this->config->get('config_language_id');
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_shipping_name_statement = (!empty($data['filter_shipping_name'])) ? 
		"AND st.title LIKE '%" . $this->db->escape($data['filter_shipping_name']) . "%'" : 
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$sql = "
		SELECT 
			SUM(st.tax) AS total_tax
		FROM " . DB_PREFIX . "shipping_transaction st
		INNER JOIN " . DB_PREFIX . "order o
		ON st.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "order_status os
		ON o.order_status_id = os.order_status_id
		WHERE 1
		AND os.language_id = '" . (int)$language_id . "'
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_payment_status_statement
		$filter_shipping_name_statement
		$filter_store_id_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_tax'];
	}
	public function getShippingTotalShipping($data = array()){
		$language_id = $this->config->get('config_language_id');
		
		$filter_date_start_statement = (!empty($data['filter_date_start'])) ? 
		"AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'" : 
		"";
		
		$filter_date_end_statement = (!empty($data['filter_date_end'])) ? 
		"AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'" : 
		"";
		
		$filter_transaction_start_statement = (!empty($data['filter_transaction_start'])) ? 
		"AND o.invoice_prefix >= '" . $this->db->escape($data['filter_transaction_start']) . "'" : 
		"";
		
		$filter_transaction_end_statement = (!empty($data['filter_transaction_end'])) ? 
		"AND o.invoice_prefix <= '" . $this->db->escape($data['filter_transaction_end']) . "'" : 
		"";
		
		$filter_shipping_name_statement = (!empty($data['filter_shipping_name'])) ? 
		"AND st.title LIKE '%" . $this->db->escape($data['filter_shipping_name']) . "%'" : 
		"";
		
		$filter_payment_status_statement = (!empty($data['filter_payment_status'])) ?
		"AND o.order_status_id IN (" . $this->db->escape($data['filter_payment_status']) . ")" :
		"";
		
		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND o.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		
		$sql = "
		SELECT 
			SUM(st.total) AS total_shipping 
		FROM " . DB_PREFIX . "shipping_transaction st
		INNER JOIN " . DB_PREFIX . "order o
		ON st.order_id = o.order_id
		INNER JOIN " . DB_PREFIX . "order_status os
		ON o.order_status_id = os.order_status_id
		WHERE 1
		AND os.language_id = '" . (int)$language_id . "'
		$filter_transaction_start_statement
		$filter_transaction_end_statement
		$filter_date_start_statement
		$filter_date_end_statement
		$filter_payment_status_statement
		$filter_shipping_name_statement
		$filter_store_id_statement
		";
		
		$query = $this->db->query($sql);
		return $query->row['total_shipping'];
	}
}
?>