<?php
class ModelReportCustomer extends Model {
	public function getTotalCustomersByDay() {
		$customer_data = array();

		for ($i = 0; $i < 24; $i++) {
			$customer_data[$i] = array(
				'hour'  => $i,
				'total' => 0
			);
		}

		$query = $this->db->query("SELECT COUNT(*) AS total, HOUR(date_added) AS hour FROM `" . DB_PREFIX . "customer` WHERE DATE(date_added) = DATE(NOW()) GROUP BY HOUR(date_added) ORDER BY date_added ASC");

		foreach ($query->rows as $result) {
			$customer_data[$result['hour']] = array(
				'hour'  => $result['hour'],
				'total' => $result['total']
			);
		}

		return $customer_data;
	}

	public function getTotalCustomersByWeek() {
		$customer_data = array();

		$date_start = strtotime('-' . date('w') . ' days');

		for ($i = 0; $i < 7; $i++) {
			$date = date('Y-m-d', $date_start + ($i * 86400));

			$order_data[date('w', strtotime($date))] = array(
				'day'   => date('D', strtotime($date)),
				'total' => 0
			);
		}

		$query = $this->db->query("SELECT COUNT(*) AS total, date_added FROM `" . DB_PREFIX . "customer` WHERE DATE(date_added) >= DATE('" . $this->db->escape(date('Y-m-d', $date_start)) . "') GROUP BY DAYNAME(date_added)");

		foreach ($query->rows as $result) {
			$customer_data[date('w', strtotime($result['date_added']))] = array(
				'day'   => date('D', strtotime($result['date_added'])),
				'total' => $result['total']
			);
		}

		return $customer_data;
	}

	public function getTotalCustomersByMonth() {
		$customer_data = array();

		for ($i = 1; $i <= date('t'); $i++) {
			$date = date('Y') . '-' . date('m') . '-' . $i;

			$customer_data[date('j', strtotime($date))] = array(
				'day'   => date('d', strtotime($date)),
				'total' => 0
			);
		}

		$query = $this->db->query("SELECT COUNT(*) AS total, date_added FROM `" . DB_PREFIX . "customer` WHERE DATE(date_added) >= '" . $this->db->escape(date('Y') . '-' . date('m') . '-1') . "' GROUP BY DATE(date_added)");

		foreach ($query->rows as $result) {
			$customer_data[date('j', strtotime($result['date_added']))] = array(
				'day'   => date('d', strtotime($result['date_added'])),
				'total' => $result['total']
			);
		}

		return $customer_data;
	}

	public function getTotalCustomersByYear() {
		$customer_data = array();

		for ($i = 1; $i <= 12; $i++) {
			$customer_data[$i] = array(
				'month' => date('M', mktime(0, 0, 0, $i)),
				'total' => 0
			);
		}

		$query = $this->db->query("SELECT COUNT(*) AS total, date_added FROM `" . DB_PREFIX . "customer` WHERE YEAR(date_added) = YEAR(NOW()) GROUP BY MONTH(date_added)");

		foreach ($query->rows as $result) {
			$customer_data[date('n', strtotime($result['date_added']))] = array(
				'month' => date('M', strtotime($result['date_added'])),
				'total' => $result['total']
			);
		}

		return $customer_data;
	}

	public function getOrders($data = array()) {
		$filter_date_start_statement = !empty($data['filter_date_start']) ?
		"AND DATE(o.date_added) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')" :
		"";

		$filter_date_end_statement = !empty($data['filter_date_end']) ?
		"AND DATE(o.date_added) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')" :
		"";

		$filter_customer_card_statement = !empty($data['filter_customer_card']) ?
		"AND c.customer_card LIKE '%" .  $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_ic_statement = !empty($data['filter_customer_ic']) ?
		"AND c.customer_ic LIKE '%" .  $this->db->escape($data['filter_customer_ic']) . "%'" :
		"";

		$filter_customer_name_statement = !empty($data['filter_customer_name']) ?
		"AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_order_statis_id_statement = !empty($data['filter_order_status_id']) ?
		"AND o.order_status_id IN ('" . $this->db->escape($data['filter_order_status_id']) . "')" :
		"";

		$filter_gender_statement = isset($data['filter_gender']) ?
		"AND c.gender = '" .  $this->db->escape($data['filter_gender']) . "'" :
		"";

		$filter_store_id_statement = ($data['filter_store_id'] != '') ? "AND o.store_id = '" .  $this->db->escape($data['filter_store_id']) . "'" : '';

		$limit_statement = "";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
			c.customer_ic,
			o.customer_id,
			o.order_id,
			c.customer_card,
			CONCAT(o.firstname, ' ', o.lastname) AS customer_name,
			c.gender,
			COUNT(DISTINCT(o.order_id)) as total_order,
			SUM(CASE WHEN ot.code = 'sub_total' THEN ot.value ELSE 0 END) AS subtotal,
			SUM(CASE WHEN ot.code = 'tax' THEN ot.value ELSE 0 END) AS tax,
			SUM(CASE WHEN ot.code = 'rounding' THEN ot.value ELSE 0 END) AS rounding,
			SUM(CASE WHEN ot.code = 'shipping' THEN ot.value ELSE 0 END) AS shipping,
			SUM(CASE WHEN ot.code = 'total' THEN ot.value ELSE 0 END) AS total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_total ot
		ON ot.order_id = o.order_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id
		WHERE 1
		AND o.customer_id > 0
		$filter_customer_card_statement
		$filter_date_end_statement
		$filter_date_start_statement
		$filter_gender_statement
		$filter_order_statis_id_statement
		$filter_store_id_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		GROUP BY o.customer_id
		ORDER BY total_order DESC
		$limit_statement
		";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalOrders($data = array()) {
		$filter_date_start_statement = !empty($data['filter_date_start']) ?
		"AND DATE(o.date_added) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')" :
		"";

		$filter_date_end_statement = !empty($data['filter_date_end']) ?
		"AND DATE(o.date_added) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')" :
		"";

		$filter_customer_card_statement = !empty($data['filter_customer_card']) ?
		"AND c.customer_card LIKE '%" .  $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_ic_statement = !empty($data['filter_customer_ic']) ?
		"AND c.customer_ic LIKE '%" .  $this->db->escape($data['filter_customer_ic']) . "%'" :
		"";

		$filter_customer_name_statement = !empty($data['filter_customer_name']) ?
		"AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_order_statis_id_statement = !empty($data['filter_order_status_id']) ?
		"AND o.order_status_id IN ('" . $this->db->escape($data['filter_order_status_id']) . "')" :
		"";

		$filter_gender_statement = isset($data['filter_gender']) ?
		"AND c.gender = '" .  $this->db->escape($data['filter_gender']) . "'" :
		"";

		$filter_store_id_statement = ($data['filter_store_id'] != '') ? "AND o.store_id = '" .  $this->db->escape($data['filter_store_id']) . "'" : '';

		$limit_statement = "";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT COUNT(*) AS total FROM(
		SELECT
			c.customer_ic,
			o.customer_id,
			c.customer_card,
			CONCAT(o.firstname, ' ', o.lastname) AS customer_name,
			c.gender,
			COUNT(DISTINCT(o.order_id)) as total_order,
			SUM(CASE WHEN ot.code = 'sub_total' THEN ot.value ELSE 0 END) AS subtotal,
			SUM(CASE WHEN ot.code = 'tax' THEN ot.value ELSE 0 END) AS tax,
			SUM(CASE WHEN ot.code = 'rounding' THEN ot.value ELSE 0 END) AS rounding,
			SUM(CASE WHEN ot.code = 'shipping' THEN ot.value ELSE 0 END) AS shipping,
			SUM(CASE WHEN ot.code = 'total' THEN ot.value ELSE 0 END) AS total
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_total ot
		ON ot.order_id = o.order_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id
		WHERE 1
		AND o.customer_id > 0
		$filter_customer_card_statement
		$filter_date_end_statement
		$filter_date_start_statement
		$filter_gender_statement
		$filter_order_statis_id_statement
		$filter_store_id_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		GROUP BY o.customer_id
		)a
		";

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getOrderDetails($data) {
		$filter_date_start_statement = !empty($data['filter_date_start']) ?
		"AND DATE(o.date_added) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')" :
		"";

		$filter_date_end_statement = !empty($data['filter_date_end']) ?
		"AND DATE(o.date_added) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')" :
		"";

		$filter_customer_card_statement = !empty($data['filter_customer_card']) ?
		"AND c.customer_card LIKE '%" .  $this->db->escape($data['filter_customer_card']) . "%'" :
		"";

		$filter_customer_ic_statement = !empty($data['filter_customer_ic']) ?
		"AND c.customer_ic LIKE '%" .  $this->db->escape($data['filter_customer_ic']) . "%'" :
		"";

		$filter_customer_name_statement = !empty($data['filter_customer_name']) ?
		"AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" :
		"";

		$filter_order_statis_id_statement = !empty($data['filter_order_status_id']) ?
		"AND o.order_status_id IN ('" . $this->db->escape($data['filter_order_status_id']) . "')" :
		"";

		$filter_gender_statement = isset($data['filter_gender']) ?
		"AND c.gender = '" .  $this->db->escape($data['filter_gender']) . "'" :
		"";

		$filter_store_id_statement = ($data['filter_store_id'] != '') ? "AND o.store_id = '" .  $this->db->escape($data['filter_store_id']) . "'" : '';

		$limit_statement = "";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$sql = "
		SELECT
			c.customer_ic,
			o.order_id,
			o.invoice_prefix,
			o.date_added,
			c.customer_card,
			CONCAT(o.firstname, ' ', o.lastname) AS customer_name,
			op.name AS product_name, 
			op.quantity AS purchased_quantity, 
			op.total AS product_total_amount, 
			o.payment_zone, 
			os.name AS order_status    
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_product op
		ON op.order_id = o.order_id
		LEFT JOIN " . DB_PREFIX . "customer c
		ON o.customer_id = c.customer_id 
		LEFT JOIN " . DB_PREFIX . "order_status os 
		ON os.order_status_id = o.order_status_id 
		AND os.language_id = '" . (int)$this->config->get('config_language_id') . "' 
		WHERE 1
		AND o.customer_id > 0
		$filter_customer_card_statement
		$filter_date_end_statement
		$filter_date_start_statement
		$filter_gender_statement
		$filter_order_statis_id_statement
		$filter_store_id_statement
		$filter_customer_ic_statement
		$filter_customer_name_statement
		ORDER BY o.order_id DESC
		$limit_statement
		";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getRewardPoints($data = array()) {
		$sql = "SELECT cr.customer_id, CONCAT(c.firstname, ' ', c.lastname) AS customer, c.email, cgd.name AS customer_group, c.status, SUM(cr.points) AS points, COUNT(o.order_id) AS orders, SUM(o.total) AS total FROM " . DB_PREFIX . "customer_reward cr LEFT JOIN `" . DB_PREFIX . "customer` c ON (cr.customer_id = c.customer_id) LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (c.customer_group_id = cgd.customer_group_id) LEFT JOIN `" . DB_PREFIX . "order` o ON (cr.order_id = o.order_id) WHERE cgd.language_id = '" . (int)$this->config->get('config_language_id') . "'";

		if (!empty($data['filter_date_start'])) {
			$sql .= " AND DATE(cr.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$sql .= " AND DATE(cr.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		$sql .= " GROUP BY cr.customer_id ORDER BY points DESC";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalRewardPoints($data = array()) {
		$sql = "SELECT COUNT(DISTINCT customer_id) AS total FROM `" . DB_PREFIX . "customer_reward`";

		$implode = array();

		if (!empty($data['filter_date_start'])) {
			$implode[] = "DATE(date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$implode[] = "DATE(date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getCredit($data = array()) {
		$sql = "SELECT ct.customer_id, CONCAT(c.firstname, ' ', c.lastname) AS customer, c.email, cgd.name AS customer_group, c.status, SUM(ct.amount) AS total FROM `" . DB_PREFIX . "customer_transaction` ct LEFT JOIN `" . DB_PREFIX . "customer` c ON (ct.customer_id = c.customer_id) LEFT JOIN `" . DB_PREFIX . "customer_group_description` cgd ON (c.customer_group_id = cgd.customer_group_id) WHERE cgd.language_id = '" . (int)$this->config->get('config_language_id') . "'";

		if (!empty($data['filter_date_start'])) {
			$sql .= "DATE(ct.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$sql .= "DATE(ct.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		$sql .= " GROUP BY ct.customer_id ORDER BY total DESC";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalCredit($data = array()) {
		$sql = "SELECT COUNT(DISTINCT customer_id) AS total FROM `" . DB_PREFIX . "customer_transaction`";

		$implode = array();

		if (!empty($data['filter_date_start'])) {
			$implode[] = "DATE(date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$implode[] = "DATE(date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getCustomersOnline($data = array()) {
		$sql = "SELECT co.ip, co.customer_id, co.url, co.referer, co.date_added FROM " . DB_PREFIX . "customer_online co LEFT JOIN " . DB_PREFIX . "customer c ON (co.customer_id = c.customer_id)";

		$implode = array();

		if (!empty($data['filter_ip'])) {
			$implode[] = "co.ip LIKE '" . $this->db->escape($data['filter_ip']) . "'";
		}

		if (!empty($data['filter_customer'])) {
			$implode[] = "co.customer_id > 0 AND CONCAT(c.firstname, ' ', c.lastname) LIKE '" . $this->db->escape($data['filter_customer']) . "'";
		}

		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}

		$sql .= " ORDER BY co.date_added DESC";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalCustomersOnline($data = array()) {
		$sql = "SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "customer_online` co LEFT JOIN " . DB_PREFIX . "customer c ON (co.customer_id = c.customer_id)";

		$implode = array();

		if (!empty($data['filter_ip'])) {
			$implode[] = "co.ip LIKE '" . $this->db->escape($data['filter_ip']) . "'";
		}

		if (!empty($data['filter_customer'])) {
			$implode[] = "co.customer_id > 0 AND CONCAT(c.firstname, ' ', c.lastname) LIKE '" . $this->db->escape($data['filter_customer']) . "'";
		}

		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getCustomerActivities($data = array()) {
		$sql = "SELECT ca.activity_id, ca.customer_id, ca.key, ca.data, ca.ip, ca.date_added FROM " . DB_PREFIX . "customer_activity ca LEFT JOIN " . DB_PREFIX . "customer c ON (ca.customer_id = c.customer_id)";

		$implode = array();

		if (!empty($data['filter_customer'])) {
			$implode[] = "CONCAT(c.firstname, ' ', c.lastname) LIKE '" . $this->db->escape($data['filter_customer']) . "'";
		}

		if (!empty($data['filter_ip'])) {
			$implode[] = "ca.ip LIKE '" . $this->db->escape($data['filter_ip']) . "'";
		}

		if (!empty($data['filter_date_start'])) {
			$implode[] = "DATE(ca.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$implode[] = "DATE(ca.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}

		$sql .= " ORDER BY ca.date_added DESC";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalCustomerActivities($data = array()) {
		$sql = "SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "customer_activity` ca LEFT JOIN " . DB_PREFIX . "customer c ON (ca.customer_id = c.customer_id)";

		$implode = array();

		if (!empty($data['filter_customer'])) {
			$implode[] = "CONCAT(c.firstname, ' ', c.lastname) LIKE '" . $this->db->escape($data['filter_customer']) . "'";
		}

		if (!empty($data['filter_ip'])) {
			$implode[] = "ca.ip LIKE '" . $this->db->escape($data['filter_ip']) . "'";
		}

		if (!empty($data['filter_date_start'])) {
			$implode[] = "DATE(ca.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$implode[] = "DATE(ca.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function get_customer($customer_id){
		$sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'";

		$query = $this->db->query($sql);

		return $query->row;
	}

	public function getCustomerOrders($customer_id, $data) {
		$filter_date_start_statement = !empty($data['filter_date_start']) ?
		"AND DATE(o.date_added) >= DATE('" . $this->db->escape($data['filter_date_start']) . "')" :
		"";

		$filter_date_end_statement = !empty($data['filter_date_end']) ?
		"AND DATE(o.date_added) <= DATE('" . $this->db->escape($data['filter_date_end']) . "')" :
		"";

		$filter_order_statis_id_statement = !empty($data['filter_order_status_id']) ?
		"AND o.order_status_id IN ('" . $this->db->escape($data['filter_order_status_id']) . "')" :
		"";

		$filter_store_id_statement = ($data['filter_store_id'] != '') ? "AND o.store_id = '" .  $this->db->escape($data['filter_store_id']) . "'" : '';

		$sql = "
		SELECT
			o.order_id,
			o.date_added,
			o.invoice_prefix,
			o.order_status_id,
			os.name AS order_status
		FROM " . DB_PREFIX . "order o
		LEFT JOIN " . DB_PREFIX . "order_status os
		ON os.order_status_id = o.order_status_id
		AND os.language_id = '" . $this->config->get('config_language_id') . "'
		WHERE 1
		AND o.customer_id = '" . (int)$customer_id . "'
		$filter_date_end_statement
		$filter_date_start_statement
		$filter_order_statis_id_statement
		$filter_store_id_statement
		ORDER BY o.date_added DESC";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function get_order_total($code, $order_id){
		$sql = "SELECT * FROM " . DB_PREFIX . "order_total WHERE code = '" . $this->db->escape($code) . "' AND order_id = '" . (int)$order_id . "'";

		$query = $this->db->query($sql);

		return $query->row;
	}
}
?>