<?php

class ModelPrescriptionTreatment extends Model {

    public function getTreatments($data = array()) {
        return array();
    }

    public function getTreatmentList($data) {
        $sort = isset($data['sort']) ? $data['sort'] : "name";
        $order = isset($data['order']) ? $data['order'] : "ASC";

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_description = isset($data['filter_description']) ? $data['filter_description'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_description_statement = $filter_description ? "AND a.description LIKE '%" . $filter_description . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "treatment.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "treatment.pinyin LIKE '%" . $filter_pinyin . "%'" : "";
        $filter_status_statement = $filter_status ? "AND " . DB_PREFIX . "treatment.status ='" . $filter_status . "'" : "";

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "treatment ,
		(
			SELECT *
			FROM " . DB_PREFIX . "treatment_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "treatment.treatment_id = a.treatment_id
		AND " . DB_PREFIX . "treatment.parent_id = 0
		$filter_name_statement
		$filter_description_statement
		$filter_code_statement
	    $filter_status_statement
		$filter_pinyin_statement
		ORDER BY $sort $order
		LIMIT $start, $limit";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTreatmentItemList($treatment_id) {
        $treatmentItemList = array();

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "treatment
		WHERE parent_id = $treatment_id";

        $query = $this->db->query($sql);
        $treatmentItemRows = $query->rows;

        foreach ($treatmentItemRows as $row => $treatmentItem) {
            $data = array();
            $data["code"] = $treatmentItem["code"];
            $data["pinyin"] = $treatmentItem["pinyin"];
            $data["treatment_id"] = $treatmentItem["treatment_id"];

            $data["treatment_description"] = array();

            $sql = "
			SELECT *
			FROM " . DB_PREFIX . "treatment_name
			WHERE treatment_id = " . $treatmentItem["treatment_id"];
            $query = $this->db->query($sql);
            $names = $query->rows;

            foreach ($names as $row => $description) {
                $data["treatment_description"][$description["language_id"]] = array(
                    "name" => $description["name"],
                    "description" => $description["description"]
                );
            }

            $treatmentItemList[] = $data;
        }



        return $treatmentItemList;
    }

    public function getTreatmentItem($treatment_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "treatment  d LEFT JOIN " . DB_PREFIX . "treatment_name dn ON (d.treatment_id = dn.treatment_id) WHERE d.parent_id = '" . (int) $treatment_id . "' AND dn.language_id = '" . (int) $this->config->get('config_language_id') . "'");

        return $query->rows;
    }

    public function getTreatmentColumn($treatment_id, $column_name, $multirow = false, $language_id = NULL) {
        $language_id = $language_id ? $language_id : (int) $this->config->get('config_language_id');

        $sql = "
		SELECT b." . $column_name . "
		FROM(
			SELECT " . DB_PREFIX . "treatment.treatment_id, " . DB_PREFIX . "treatment.code, " . DB_PREFIX . "treatment.pinyin, a.name, a.description, " . DB_PREFIX . "treatment.sort_order, " . DB_PREFIX . "treatment.status
			FROM " . DB_PREFIX . "treatment ,
			(
				SELECT *
				FROM " . DB_PREFIX . "treatment_name
				WHERE language_id = $language_id
			)a
			WHERE " . DB_PREFIX . "treatment.treatment_id = a.treatment_id
			AND " . DB_PREFIX . "treatment.parent_id = 0
			AND " . DB_PREFIX . "treatment.treatment_id = " . $treatment_id . "
		)b";
        $query = $this->db->query($sql);

        return $multirow ? $query->rows[$column_name] : $query->row[$column_name];
    }

    public function addTreatment($data, $parent_id = 0) {

        //traking insert data
        // post data
        $descriptions = $data['treatment_description'];
        $code = $data['code'];

        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;

        $treatmentitems = isset($data['treatmentitem']) ? $data['treatmentitem'] : false;

        // insert treatment
        $sql = "INSERT INTO " . DB_PREFIX . "treatment(code, pinyin, parent_id, status, sort_order, createby, createdate)
				VALUES('$code', '$pinyin', '$parent_id', '$status', '$sort_order', '" . $this->session->data['user_id'] . "', NOW())";
        $query = $this->db->query($sql);

        // get last insert id
        $lastid = $this->db->getLastId();

        // insert treatment name
        foreach ($descriptions as $language_id => $value) {
            $name = $value['name'];
            $description = $value['description'];

            $sql = "INSERT INTO " . DB_PREFIX . "treatment_name(treatment_id, language_id, name, description)
					VALUES('$lastid', '$language_id', '$name', '$description')";

            $query = $this->db->query($sql);
        }

        // If have child, insert child
        if ($treatmentitems) {
            foreach ($treatmentitems as $treatmentitem) {
                $treatmentitem['status'] = $status;
                $this->addTreatment($treatmentitem, $lastid);
            }
        }

        return $lastid;
    }

    public function editTreatment($id, $data) {
        // post data
        $descriptions = $data['treatment_description'];
        $code = $data['code'];

        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;

        $treatmentitems = isset($data['treatmentitem']) ? $data['treatmentitem'] : false;

        //general update
        $sql = "
		UPDATE " . DB_PREFIX . "treatment SET
		code = '$code',
		pinyin = '$pinyin',
		status = '$status',
		sort_order = '$sort_order',
		modifyby = '" . $this->session->data['user_id'] . "',
		modifydate = NOW()
		WHERE treatment_id = '$id'
		";
        $query = $this->db->query($sql);

        //name update
        foreach ($descriptions as $language_id => $value) {
            $newname = $value['name'];
            $newdescription = $value['description'];
            $sql = "
			UPDATE " . DB_PREFIX . "treatment_name SET
			name = '$newname',
			description = '$newdescription'
			WHERE treatment_id = '$id'
			AND language_id = $language_id
			";
            $query = $this->db->query($sql);
        }

        // clear treatment item language description
        $sql = "SELECT treatment_id FROM " . DB_PREFIX . "treatment WHERE parent_id = '" . (int) $id . "'";
        $query = $this->db->query($sql);

        foreach ($query->rows as $treatment) {
            $sql = "
			DELETE FROM " . DB_PREFIX . "treatment_name
			WHERE treatment_id = '" . $treatment['treatment_id'] . "'
			";

            $this->db->query($sql);
        }

        // clear all treatment child item
        $sql = "DELETE FROM " . DB_PREFIX . "treatment WHERE parent_id = '" . (int) $id . "'";
        $query = $this->db->query($sql);

        if ($treatmentitems) {
            //insert new data
            foreach ($treatmentitems as $treatmentitempos => $treatmentitem) {
                $treatmentitem['status'] = $status;
                $this->addTreatment($treatmentitem, $id);
            }
        }
    }

    public function deleteTreatment($treatment_id) {
        //delete treatment multi language name
        $sql = "
		SELECT treatment_id
		FROM " . DB_PREFIX . "treatment
		WHERE treatment_id = $treatment_id
		OR parent_id = $treatment_id
		";
        $query = $this->db->query($sql);
        $rows = $query->rows;
        foreach ($rows as $row => $row_data) {
            $row_id = $row_data['treatment_id'];

            //delete treatment
            $sql = "
			DELETE FROM " . DB_PREFIX . "treatment_name
			WHERE treatment_id = $row_id";
            $query = $this->db->query($sql);
        }

        //delete treatment and treatment item
        $sql = "
		DELETE FROM " . DB_PREFIX . "treatment
		WHERE treatment_id = $treatment_id
		OR parent_id = $treatment_id";
        $query = $this->db->query($sql);

        $this->cache->delete('category');
    }

    public function totalTreatment($data) {

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;

        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "treatment.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "treatment.pinyin LIKE '%" . $filter_pinyin . "%'" : "";

        $sql = "
		SELECT COUNT(*) AS total
		FROM " . DB_PREFIX . "treatment ,
		(
			SELECT *
			FROM " . DB_PREFIX . "treatment_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "treatment.treatment_id = a.treatment_id
		AND " . DB_PREFIX . "treatment.parent_id = 0
		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

}

?>
