<?php

class ModelPrescriptionDoctorAdvice extends Model {

    public function getDoctorAdvices($data = array()) {
        return array();
    }

    public function getDoctorAdviceList($data) {
        $sort = isset($data['sort']) ? $data['sort'] : "name";
        $order = isset($data['order']) ? $data['order'] : "ASC";

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;

        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "doctoradvice.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "doctoradvice.pinyin LIKE '%" . $filter_pinyin . "%'" : "";
        $filter_status_statement = $filter_status ? "AND " . DB_PREFIX . "doctoradvice.status ='" . $filter_status . "'" : "";

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "doctoradvice ,
		(
			SELECT *
			FROM " . DB_PREFIX . "doctoradvice_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "doctoradvice.doctoradvice_id = a.doctoradvice_id
		AND " . DB_PREFIX . "doctoradvice.parent_id = 0

		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement
	    $filter_status_statement

		ORDER BY $sort $order
		LIMIT $start, $limit";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getDoctorAdviceItemList($doctoradvice_id) {
        $doctoradviceItemList = array();

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "doctoradvice
		WHERE parent_id = $doctoradvice_id";

        $query = $this->db->query($sql);
        $doctoradviceItemRows = $query->rows;

        foreach ($doctoradviceItemRows as $row => $doctoradviceItem) {
            $data = array();
            $data["code"] = $doctoradviceItem["code"];
            $data["pinyin"] = $doctoradviceItem["pinyin"];
            $data["doctoradvice_id"] = $doctoradviceItem["doctoradvice_id"];
            $data["doctoradvice_name"] = array();

            $sql = "

			SELECT *
			FROM " . DB_PREFIX . "doctoradvice_name
			WHERE doctoradvice_id = " . $doctoradviceItem["doctoradvice_id"];

            $query = $this->db->query($sql);

            $names = $query->rows;

            foreach ($names as $row => $name) {
                $data["doctoradvice_name"][$name["language_id"]]["name"] = $name["name"];
            }

            $doctoradviceItemList[] = $data;
        }

        return $doctoradviceItemList;
    }

    public function getDoctorAdviceItem($doctoradvice_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "doctoradvice  d LEFT JOIN " . DB_PREFIX . "doctoradvice_name dn ON (d.doctoradvice_id = dn.doctoradvice_id) WHERE d.parent_id = '" . (int) $doctoradvice_id . "' AND dn.language_id = '" . (int) $this->config->get('config_language_id') . "'");
        return $query->rows;
    }

    public function getDoctorAdviceColumn($doctoradvice_id, $column_name, $multirow = false, $language_id = NULL) {
        $language_id = $language_id ? $language_id : (int) $this->config->get('config_language_id');

        $sql = "
                   
		SELECT b." . $column_name . "
		FROM(
			SELECT " . DB_PREFIX . "doctoradvice.doctoradvice_id, " . DB_PREFIX . "doctoradvice.code, " . DB_PREFIX . "doctoradvice.pinyin, a.name, " . DB_PREFIX . "doctoradvice.sort_order, " . DB_PREFIX . "doctoradvice.status
			FROM " . DB_PREFIX . "doctoradvice ,
			(
				SELECT *
				FROM " . DB_PREFIX . "doctoradvice_name
				WHERE language_id = $language_id
			)a

			WHERE " . DB_PREFIX . "doctoradvice.doctoradvice_id = a.doctoradvice_id
			AND " . DB_PREFIX . "doctoradvice.parent_id = 0
			AND " . DB_PREFIX . "doctoradvice.doctoradvice_id = " . $doctoradvice_id . "
		)b";

        $query = $this->db->query($sql);
        return $multirow ? $query->rows[$column_name] : $query->row[$column_name];
    }

    public function addDoctorAdvice($data, $parent_id = 0) {
        // post data
        $names = $data['doctoradvice_name'];
        $code = $data['code'];
        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;

        $doctoradviceitems = isset($data['doctoradviceitem']) ? $data['doctoradviceitem'] : false;



        // insert doctoradvice
        $sql = "INSERT INTO " . DB_PREFIX . "doctoradvice(code, pinyin, parent_id, status, sort_order, createby, createdate)
				VALUES('$code', '$pinyin', '$parent_id', '$status', '$sort_order', '" . $this->session->data['user_id'] . "', NOW())";
        $query = $this->db->query($sql);

        // get last insert id
        $lastid = $this->db->getLastId();
        // insert doctoradvice name

        foreach ($names as $language_id => $value) {
            $name = $value['name'];
            $sql = "INSERT INTO " . DB_PREFIX . "doctoradvice_name(doctoradvice_id, language_id, name)
					VALUES('$lastid', '$language_id', '$name')";

            $query = $this->db->query($sql);
        }

        // If have child, insert child
        if ($doctoradviceitems) {
            foreach ($doctoradviceitems as $doctoradviceitem) {
                $doctoradviceitem['status'] = $status;
                $this->addDoctorAdvice($doctoradviceitem, $lastid);
            }
        }
        return $lastid;
    }

    public function editDoctorAdvice($id, $data) {
        // post data
        $names = $data['doctoradvice_name'];
        $code = $data['code'];
        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;

        $doctoradviceitems = isset($data['doctoradviceitem']) ? $data['doctoradviceitem'] : false;

        //general update

        $sql = "
		UPDATE " . DB_PREFIX . "doctoradvice SET
		code = '$code',
		pinyin = '$pinyin',
		status = '$status',
		sort_order = '$sort_order',
		modifyby = '" . $this->session->data['user_id'] . "',
		modifydate = NOW()
		WHERE doctoradvice_id = '$id'
		";

        $query = $this->db->query($sql);

        //name update
        foreach ($names as $language_id => $value) {
            $newname = $value['name'];
            $sql = "
			UPDATE " . DB_PREFIX . "doctoradvice_name SET
			name = '$newname'
			WHERE doctoradvice_id = '$id'
			AND language_id = $language_id
			";
            $query = $this->db->query($sql);
        }
        if ($doctoradviceitems) {
            $survive_id = array();
            $updated_data = array();
            $new_data = array();
            $removed_data = array();

            foreach ($doctoradviceitems as $doctoradviceitempos => $doctoradviceitem) {
                if (!empty($doctoradviceitem["doctoradvice_id"])) {
                    $doctoradviceitem['status'] = $status;
                    $survive_id[] = $doctoradviceitem["doctoradvice_id"]; //track for survice doctoradvice

                    $updated_data[] = array(//track for update doctoradvice
                        'doctoradvice_id' => $doctoradviceitem["doctoradvice_id"],
                        'data' => $doctoradviceitem
                    );
                } else {
                    $doctoradviceitem['status'] = $status;
                    $new_data[] = array(//track for new doctoradvice
                        'data' => $doctoradviceitem,
                        'parent_id' => $id
                    );
                }
            }

            // kill oudated doctoradvice item
            $survive_id_statement = !empty($survive_id) ?
                    "AND doctoradvice_id NOT IN('" . implode("','", $survive_id) . "')" :
                    NULL;
            $sql = "
			SELECT doctoradvice_id
			FROM " . DB_PREFIX . "doctoradvice
			WHERE parent_id = $id
			$survive_id_statement
			";

            $query = $this->db->query($sql);
            $outdatedDoctorAdvice = $query->rows;
            foreach ($outdatedDoctorAdvice as $odoctoradvice)
                $this->deleteDoctorAdvice($odoctoradvice['doctoradvice_id']);

            // update doctoradvice item
            foreach ($updated_data as $data)
                $this->editDoctorAdvice($data['doctoradvice_id'], $data['data']);

            // add new doctoradvice item
            foreach ($new_data as $data)
                $this->addDoctorAdvice($data['data'], $data['parent_id']);
        } else {
            // no child item, just kill all

            $sql = "
			SELECT COUNT(*) as total
			FROM " . DB_PREFIX . "doctoradvice
			WHERE parent_id = $id
			";
            $query = $this->db->query($sql);
            $total = $query->row['total'];

            if ($total > 0) {
                $sql = "DELETE FROM " . DB_PREFIX . "doctoradvice WHERE parent_id = $id";
                $query = $this->db->query($sql); //kill all child
            }
        }
    }

    public function deleteDoctorAdvice($doctoradvice_id) {
        //delete doctoradvice multi language name
        $sql = "
		SELECT doctoradvice_id
		FROM " . DB_PREFIX . "doctoradvice
		WHERE doctoradvice_id = $doctoradvice_id
		OR parent_id = $doctoradvice_id
		";
        $query = $this->db->query($sql);
        $rows = $query->rows;

        foreach ($rows as $row => $row_data) {
            $row_id = $row_data['doctoradvice_id'];

            //delete doctoradvice
            $sql = "
			DELETE FROM " . DB_PREFIX . "doctoradvice_name
			WHERE doctoradvice_id = $row_id";
            $query = $this->db->query($sql);
        }

        //delete doctoradvice and doctoradvice item
        $sql = "
		DELETE FROM " . DB_PREFIX . "doctoradvice
		WHERE doctoradvice_id = $doctoradvice_id
		OR parent_id = $doctoradvice_id";

        $query = $this->db->query($sql);

        $this->cache->delete('category');
    }

    public function totalDoctorAdvice($data) {

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "doctoradvice.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "doctoradvice.pinyin LIKE '%" . $filter_pinyin . "%'" : "";

        $sql = "

		SELECT COUNT(*) AS total
		FROM " . DB_PREFIX . "doctoradvice ,
		(
			SELECT *
			FROM " . DB_PREFIX . "doctoradvice_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a

		WHERE " . DB_PREFIX . "doctoradvice.doctoradvice_id = a.doctoradvice_id

		AND " . DB_PREFIX . "doctoradvice.parent_id = 0

		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement";
        $query = $this->db->query($sql);

        return $query->row['total'];
    }

}

?>