<?php

class ModelPrescriptionDiagnostic extends Model {

    public function getDiagnostics($data = array()) {
        return array();
    }

    public function getDiagnosticList($data) {
        $sort = isset($data['sort']) ? $data['sort'] : "name";
        $order = isset($data['order']) ? $data['order'] : "ASC";

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "diagnostic.code LIKE '%" . $filter_code . "%'" : "";
        $filter_status_statement = $filter_status ? "AND " . DB_PREFIX . "diagnostic.status ='" . $filter_status . "'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "diagnostic.pinyin LIKE '%" . $filter_pinyin . "%'" : "";

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "diagnostic ,
		(
			SELECT *
			FROM " . DB_PREFIX . "diagnostic_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "diagnostic.diagnostic_id = a.diagnostic_id
		AND " . DB_PREFIX . "diagnostic.parent_id = 0
		$filter_name_statement
		$filter_code_statement
	    $filter_status_statement
		$filter_pinyin_statement
		ORDER BY $sort $order
		LIMIT $start, $limit";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getDiagnosticItemList($diagnostic_id) {
        $diagnosticItemList = array();

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "diagnostic
		WHERE parent_id = $diagnostic_id";

        $query = $this->db->query($sql);
        $diagnosticItemRows = $query->rows;

        foreach ($diagnosticItemRows as $row => $diagnosticItem) {
            $data = array();
            $data["code"] = $diagnosticItem["code"];
            $data["pinyin"] = $diagnosticItem["pinyin"];
            $data["diagnostic_id"] = $diagnosticItem["diagnostic_id"];

            $data["diagnostic_name"] = array();
            $sql = "
			SELECT *
			FROM " . DB_PREFIX . "diagnostic_name
			WHERE diagnostic_id = " . $diagnosticItem["diagnostic_id"];
            $query = $this->db->query($sql);
            $names = $query->rows;

            foreach ($names as $row => $name) {
                $data["diagnostic_name"][$name["language_id"]]["name"] = $name["name"];
            }

            $diagnosticItemList[] = $data;
        }

        return $diagnosticItemList;
    }

    public function getDiagnosticItem($diagnostic_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "diagnostic  d LEFT JOIN " . DB_PREFIX . "diagnostic_name dn ON (d.diagnostic_id = dn.diagnostic_id) WHERE d.parent_id = '" . (int) $diagnostic_id . "' AND dn.language_id = '" . (int) $this->config->get('config_language_id') . "'");

        return $query->rows;
    }

    public function getDiagnosticColumn($diagnostic_id, $column_name, $multirow = false, $language_id = NULL) {
        $language_id = $language_id ? $language_id : (int) $this->config->get('config_language_id');

        $sql = "
		SELECT b." . $column_name . "
		FROM(
			SELECT " . DB_PREFIX . "diagnostic.diagnostic_id, " . DB_PREFIX . "diagnostic.code, " . DB_PREFIX . "diagnostic.pinyin, a.name, " . DB_PREFIX . "diagnostic.sort_order, " . DB_PREFIX . "diagnostic.status
			FROM " . DB_PREFIX . "diagnostic ,
			(
				SELECT *
				FROM " . DB_PREFIX . "diagnostic_name
				WHERE language_id = $language_id
			)a
			WHERE " . DB_PREFIX . "diagnostic.diagnostic_id = a.diagnostic_id
			AND " . DB_PREFIX . "diagnostic.parent_id = 0
			AND " . DB_PREFIX . "diagnostic.diagnostic_id = " . $diagnostic_id . "
		)b";
        $query = $this->db->query($sql);
        return $multirow ? $query->rows[$column_name] : $query->row[$column_name];
    }

    public function addDiagnostic($data, $parent_id = 0) {
        // post data
        $names = $data['diagnostic_name'];
        $code = $data['code'];

        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;

        $diagnosticitems = isset($data['diagnosticitem']) ? $data['diagnosticitem'] : false;

        // insert diagnostic
        $sql = "INSERT INTO " . DB_PREFIX . "diagnostic(code, pinyin, parent_id, status, sort_order, createby, createdate)
				VALUES('$code', '$pinyin', '$parent_id', '$status', '$sort_order', '" . $this->session->data['user_id'] . "', NOW())";
        $query = $this->db->query($sql);

        // get last insert id
        $lastid = $this->db->getLastId();

        // insert diagnostic name
        foreach ($names as $language_id => $value) {
            $name = $value['name'];

            $sql = "INSERT INTO " . DB_PREFIX . "diagnostic_name(diagnostic_id, language_id, name)
					VALUES('$lastid', '$language_id', '$name')";

            $query = $this->db->query($sql);
        }

        // If have child, insert child
        if ($diagnosticitems) {
            foreach ($diagnosticitems as $diagnosticitem) {
                $diagnosticitem['status'] = $status;
                $this->addDiagnostic($diagnosticitem, $lastid);
            }
        }

        return $lastid;
    }

    public function editDiagnostic($id, $data) {
        // post data
        $names = $data['diagnostic_name'];
        $code = $data['code'];

        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;

        $diagnosticitems = isset($data['diagnosticitem']) ? $data['diagnosticitem'] : false;

        //general update
        $sql = "
		UPDATE " . DB_PREFIX . "diagnostic SET
		code = '$code',
		pinyin = '$pinyin',
		status = '$status',
		sort_order = '$sort_order',
		modifyby = '" . $this->session->data['user_id'] . "',
		modifydate = NOW()
		WHERE diagnostic_id = '$id'
		";
        $query = $this->db->query($sql);

        //name update
        foreach ($names as $language_id => $value) {
            $newname = $value['name'];
            $sql = "
			UPDATE " . DB_PREFIX . "diagnostic_name SET
			name = '$newname'
			WHERE diagnostic_id = '$id'
			AND language_id = $language_id
			";
            $query = $this->db->query($sql);
        }

        if ($diagnosticitems) {
            $survive_id = array();

            $updated_data = array();
            $new_data = array();
            $removed_data = array();

            foreach ($diagnosticitems as $diagnosticitempos => $diagnosticitem) {
                if (!empty($diagnosticitem["diagnostic_id"])) {
                    $diagnosticitem['status'] = $status;
                    $survive_id[] = $diagnosticitem["diagnostic_id"]; //track for survice diagnostic

                    $updated_data[] = array(//track for update diagnostic
                        'diagnostic_id' => $diagnosticitem["diagnostic_id"],
                        'data' => $diagnosticitem
                    );
                } else {
                    $diagnosticitem['status'] = $status;
                    $new_data[] = array(//track for new diagnostic
                        'data' => $diagnosticitem,
                        'parent_id' => $id
                    );
                }
            }

            // kill oudated diagnostic item
            $survive_id_statement = !empty($survive_id) ?
                    "AND diagnostic_id NOT IN('" . implode("','", $survive_id) . "')" :
                    NULL;
            $sql = "
			SELECT diagnostic_id
			FROM " . DB_PREFIX . "diagnostic
			WHERE parent_id = $id
			$survive_id_statement
			";



            $query = $this->db->query($sql);
            $outdatedDiagnostic = $query->rows;
            foreach ($outdatedDiagnostic as $odiagnostic)
                $this->deleteDiagnostic($odiagnostic['diagnostic_id']);

            // update diagnostic item
            foreach ($updated_data as $data)
                $this->editDiagnostic($data['diagnostic_id'], $data['data']);

            // add new diagnostic item
            foreach ($new_data as $data)
                $this->addDiagnostic($data['data'], $data['parent_id']);
        } else {
            // no child item, just kill all

            $sql = "
			SELECT COUNT(*) as total
			FROM " . DB_PREFIX . "diagnostic
			WHERE parent_id = $id
			";
            $query = $this->db->query($sql);
            $total = $query->row['total'];

            if ($total > 0) {
                $sql = "DELETE FROM " . DB_PREFIX . "diagnostic WHERE parent_id = $id";
                $query = $this->db->query($sql); //kill all child
            }
        }
    }

    public function deleteDiagnostic($diagnostic_id) {

        //delete diagnostic multi language name
        $sql = "
		SELECT diagnostic_id
		FROM " . DB_PREFIX . "diagnostic
		WHERE diagnostic_id = $diagnostic_id
		OR parent_id = $diagnostic_id
		";
        $query = $this->db->query($sql);
        $rows = $query->rows;
        foreach ($rows as $row => $row_data) {
            $row_id = $row_data['diagnostic_id'];

            //delete diagnostic
            $sql = "
			DELETE FROM " . DB_PREFIX . "diagnostic_name
			WHERE diagnostic_id = $row_id";
            $query = $this->db->query($sql);
        }

        //delete diagnostic and diagnostic item
        $sql = "
		DELETE FROM " . DB_PREFIX . "diagnostic
		WHERE diagnostic_id = $diagnostic_id
		OR parent_id = $diagnostic_id";
        $query = $this->db->query($sql);

        $this->cache->delete('category');
    }

    public function totalDiagnostic($data) {

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;

        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "diagnostic.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "diagnostic.pinyin LIKE '%" . $filter_pinyin . "%'" : "";

        $sql = "
		SELECT COUNT(*) AS total
		FROM " . DB_PREFIX . "diagnostic ,
		(
			SELECT *
			FROM " . DB_PREFIX . "diagnostic_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "diagnostic.diagnostic_id = a.diagnostic_id
		AND " . DB_PREFIX . "diagnostic.parent_id = 0
		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement";

        $query = $this->db->query($sql);
        return $query->row['total'];
    }

}

?>
