<?php
class ModelPosSubTotal extends Model {
    public function getTotal($total) {
		$this->load->language('extension/total/sub_total');
		
		$sub_total = $this->cart->getSubTotal();
		
		if (isset($this->session->data['vouchers']) && $this->session->data['vouchers']) {
			foreach ($this->session->data['vouchers'] as $voucher) {
				$sub_total += $voucher['amount'];
			}
        }
        
		$tax_code = '';
        
        $total['totals'][] = array( 
		    'key'        => '',
			'code'       => 'sub_total',
			'title'      => 'Sub-Total',
			'text'       => $this->currency->format($sub_total, $this->config->get('config_currency')),
			'value'      => $sub_total,
			'tax_code'   => $tax_code,
			'sort_order' => $this->config->get('sub_total_sort_order')
		);
		
		$total['total'] += $sub_total;
	}
}
?>