<?php
class ModelPosShipping extends Model {
    public function getTotal($total) {
		if (isset($this->session->data['shipping_method'])) {
			
			$tax_code = '';
			
			if ($this->session->data['shipping_method']['tax_class_id']) {
				$tax_rates = $this->tax->getRates($this->session->data['shipping_method']['cost'], $this->session->data['shipping_method']['tax_class_id']);
	
				foreach ($tax_rates as $tax_rate) {
					if (!isset($total['taxes'][$tax_rate['tax_rate_id']])) {
						$taxes[$tax_rate['tax_rate_id']] = $tax_rate['amount'];
					} else {
						$taxes[$tax_rate['tax_rate_id']] += $tax_rate['amount'];
					}
				}
				
				$tax_code = $this->tax->getClassCode($this->session->data['shipping_method']['tax_class_id']);
			}
						
		    $total['totals'][] = array( 
			    'key'        => '',
				'code'       => 'shipping',
				'title'      => $this->session->data['shipping_method']['title'],
				'tax_code'   => $tax_code,
				'text'       => $this->currency->format($this->session->data['shipping_method']['cost'], $this->config->get('config_currency')),
				'value'      => $this->session->data['shipping_method']['cost'],
				'sort_order' => $this->config->get('total_shipping_sort_order')
			);

			$total['total'] += $this->session->data['shipping_method']['cost'];
		}			
	}
}
?>