<?php
class ModelModuleGeneratorPro extends Model {
     public function getQrList($data = array()){
        $sql = "SELECT * FROM " .DB_PREFIX. "generator_pro gp LEFT JOIN " .DB_PREFIX. "generator_pro_description gpd ON (gp.qr_id = gpd.qr_id)  WHERE gpd.language_id = '" . (int) $this->config->get('config_language_id') . "'";
        
        if (!empty($data['filter_title'])) {
            $sql .= " AND gpd.title LIKE '%" . $this->db->escape($data['filter_title']) . "%'";
		}
        
        if(!empty($data['filter_description'])){
            $sql .= " AND gpd.description LIKE '%" . $this->db->escape($data['filter_description']) . "%'";
        }
        
        $sql .= " GROUP BY gp.qr_id";
        
        $query = $this->db->query($sql);

        return $query->rows;
    }
    
    public function getTotalQr()
    {
            $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "generator_pro");

            return $query->row['total'];
    }
    
    public function getQrDescription($qr_id){
    $sql = "SELECT * FROM " .DB_PREFIX. "generator_pro WHERE 1 AND language_id = '" . (int) $this->config->get('config_language_id') . "'";
    
    $query = $this->db->query($sql);

    return $query->rows;
}
    
    public function addQr($data){
         $this->db->query("INSERT INTO " .DB_PREFIX. "generator_pro SET type = '" . $this->db->escape($data['type']) . "', value = '" . $this->db->escape($data['value']). "'");
             
         $qr_id =$this->db->getLastId();
         
         foreach ($data['qr_description'] as $language_id => $value) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "generator_pro_description SET qr_id = '" . (int) $qr_id . "', language_id = '" . (int) $language_id . "', title = '" . $this->db->escape($value['title']) . "', description = '" . $this->db->escape($value['description']) . "'");
        }
         $this->cache->delete('product');

        return $qr_id;
    }
    
    public function editQr($qr_id, $data){
        
        $this->db->query("UPDATE " .DB_PREFIX. "generator_pro SET type = '" . $this->db->escape($data['type']) . "', value = '" . $this->db->escape($data['value']). "' WHERE qr_id = '" . (int) $qr_id . "'");
        
        $this->db->query("DELETE FROM " . DB_PREFIX . "generator_pro_description WHERE qr_id = '" . (int) $qr_id . "'");
        
        foreach ($data['qr_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "generator_pro_description set qr_id = '" . (int) $qr_id . "',language_id = '" . (int) $language_id . "',title = '" . $this->db->escape($value['title']) . "',description = '" . $this->db->escape($value['description']) . "'");
		}
    }
    
     public function deleteQr($qr_id) {
        $this->db->query("DELETE FROM " . DB_PREFIX . "generator_pro WHERE qr_id = '" . (int) $qr_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "generator_pro_description WHERE qr_id = '" . (int) $qr_id . "'");
        
    }
    
    public function getQrDescriptions($qr_id)
	{
		$qr_description_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "generator_pro_description WHERE qr_id = '" . (int) $qr_id . "'");

		foreach ($query->rows as $result) {
			$qr_description_data[$result['language_id']] = array(
				'title'             => $result['title'],
				'description'      => $result['description']
			);
		}

		return $qr_description_data;
	}
        
        public function getQr($qr_id){
           return $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "generator_pro gp LEFT JOIN " . DB_PREFIX . "generator_pro_description gpd ON(gp.qr_id = gpd.qr_id) WHERE gp.qr_id = '" . (int) $qr_id . "' AND gpd.language_id = '" . (int) $this->config->get('config_language_id') . "'")->row;
        }
        
        public function getUrl($qr_id){
            return $this->db->query("SELECT * FROM " .DB_PREFIX. "generator_pro WHERE qr_id = '" . (int) $qr_id . "'")->row;
        }
}

?>