<?php

class ModelHerbalNgpPrescription extends Model {
    
    public function getDoctors() {
        $sql = "SELECT CONCAT(firstname, ' ', lastname) AS doctor_name, user_id FROM " . DB_PREFIX . "user WHERE position = '2'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalNGPPrescription($data = array()) {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_to_service WHERE 1 ";

        if (!empty($data['filter_customer'])) {
            $sql .= " AND customer LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
        }

        if (!empty($data['filter_gender'])) {
            $sql .= " AND gender LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
        }

        if (!empty($data['filter_doctor'])) {
            $sql .= " AND doctor LIKE '%" . $this->db->escape($data['filter_doctor']) . "%'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getNGPPrescriptions($data = array()) {
        $sql = "SELECT * 
        FROM " . DB_PREFIX . "product_to_service 
        LEFT JOIN " . DB_PREFIX . "order 
        ON ". DB_PREFIX . "product_to_service.order_id = "  . DB_PREFIX . "order.order_id 
        LEFT JOIN " . DB_PREFIX . "clinical_sale 
        ON " . DB_PREFIX . "clinical_sale.customer_id = " . DB_PREFIX . "order.customer_id
         WHERE 1 ";

        if (!empty($data['filter_customer'])) {
            $sql .= " AND customer LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
        } 

        if (!empty($data['filter_gender'])) {
            $sql .= " AND gender LIKE '%" . $this->db->escape($data['filter_gender']) . "%'";
        }

        if (!empty($data['filter_doctor'])) {
            $sql .= " AND doctor_id LIKE '%" . $this->db->escape($data['filter_doctor']) . "%'";
        }
        
        if (!empty($data['filter_status'])) {
            $sql .= " AND status IN (" . $this->db->escape($data['filter_status']) . ")";
        }
        
        if (!empty($data['filter_service_type'])) {
            $sql .= " AND service_type LIKE '" . $this->db->escape($data['filter_service_type']) . "'";
        }
        
        if (!empty($data['filter_date_from']) && !empty($data['filter_date_to'])) {
            $sql .= " AND DATE(sales_date) BETWEEN DATE('" . $this->db->escape($data['filter_date_from']) . "') AND DATE('" . $this->db->escape($data['filter_date_to']) . "')";
		}
		
		if (!empty($data['filter_payment_status'])) {
            $sql .= " AND order_action LIKE '" . $this->db->escape($data['filter_payment_status']) . "'";
        }
        
        
        $sort_data = array(
            'sales_date',
            'customer',
            'gender',
            'doctor',
            'prescription_id'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY prescription_id";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        // if (isset($data['start']) || isset($data['limit'])) {
        //     if ($data['start'] < 0) {
        //         $data['start'] = 0;
        //     }

        //     if ($data['limit'] < 1) {
        //         $data['limit'] = 20;
        //     }

            $sql .= " LIMIT  0 , 1";
        // }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function updateCompleteStatus($product_to_service_id) {
        $this->db->query("UPDATE " . DB_PREFIX . "product_to_service SET status = '5', completed_by = " . (int) $this->session->data['user_id'] . ", completed_date = NOW() WHERE product_to_service_id = '" . (int) $product_to_service_id . "'");

        return $this->db->getLastId();
    }

    public function getCompleteStatusName($complete_status_id) {
        $sql = "SELECT os.name AS complete_status_name FROM " . DB_PREFIX . "order_status os
                LEFT JOIN " . DB_PREFIX . "product_to_service pts
                ON pts.status = os.order_status_id
                WHERE os.order_status_id = '" . (int) $complete_status_id . "'
                 ";

        $query = $this->db->query($sql);
        
        return !empty($query->row['complete_status_name']) ? $query->row['complete_status_name'] : 'Complete';
    }

    public function getProductToServiceDetails($id) {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product_to_service` WHERE 1 AND product_to_service_id = '" . (int) $id . "'");
        return $query->row;
    }

    public function updateStatus($data) {
        $this->db->query("UPDATE `" . DB_PREFIX . "product_to_service` SET `ngp_machine` = '" . (int) $data['response'] . "', `status` = '" . (int) $data['status'] . "' WHERE 1 AND product_to_service_id = '" . (int) $data['id'] . "'");

        $this->db->query("INSERT INTO `" . DB_PREFIX . "product_to_service_history` SET `product_to_service_id` = '" . (int) $data['id'] . "', `status` = '" . (int) $data['status'] . "', added_by = '" . $this->session->data['user_id'] . "', `date_added` = NOW(), `comment` = '" . $this->db->escape($data['msg']) .  "'");
    }

    public function updateHerbalStatus($data) {
        $this->db->query("UPDATE `" . DB_PREFIX . "clinical_sale` SET `ngp_prescription_id` = '" . (int) $data['response'] . "' WHERE 1 AND clinical_sale_id = '" . (int) $data['herbal_id'] . "'");
    }

    public function getNGPData($product_to_service_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "product_to_service WHERE product_to_service_id = '" . (int) $product_to_service_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

}
