<?php

class ModelHerbalHerbal extends Model {

    public function getAllOrderByDate($invoice_prefix) {
        $query = $this->db->query("SELECT o.* FROM `" . DB_PREFIX . "order` o WHERE 1 AND DATE(o.date_added) BETWEEN DATE('2017-09-01') AND DATE('2017-10-17') AND o.invoice_prefix = '" . $invoice_prefix . "' ORDER BY o.order_id ASC");
        return $query->rows;
    }

    public function checkOrderExists($order_id) {
        $query = $this->db->query("SELECT cs.clinical_sale_id FROM `" . DB_PREFIX . "clinical_sale` cs WHERE 1 AND cs.order_id = '" . (int) $order_id . "' AND cs.collect_consultation_price = 1");
        return $query->rows;
    }
	public function getHerbalProducts($herbal_id)
	{
		$query = $this->db->query("SELECT CONCAT(pcm.code, ', ', (SUM(cp.quantity) * (CASE WHEN cs.herb_service_type = 'granule' THEN 5 ELSE 1 END))) AS product   FROM " . DB_PREFIX . "clinicalsale_product cp LEFT JOIN " . DB_PREFIX . "clinical_sale cs ON cp.clinical_sale_id = cs.clinical_sale_id LEFT JOIN " . DB_PREFIX . "product p ON (cp.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (cp.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "product_code_match pcm ON cp.product_id = pcm.product_id LEFT JOIN " . DB_PREFIX . "ngp_product np ON pcm.drug_id = np.drug_id  WHERE cp.clinical_sale_id = '" . (int)$herbal_id . "' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND pcm.code <>'' GROUP BY cp.product_id");
		return $query->rows;
	}

	public function getHerbalDailyTimes($herbal_id)
	{
		$query = $this->db->query("SELECT MAX(cp.times) AS times FROM " . DB_PREFIX . "clinicalsale_product cp WHERE 1 AND cp.clinical_sale_id = '" . (int)$herbal_id . "' GROUP BY cp.clinical_sale_id");
		return $query->row;
	}
	
		public function getHerbalDailyTake($herbal_id)
	{
		$query = $this->db->query("SELECT MAX(cp.day) AS taken FROM " . DB_PREFIX . "clinicalsale_product cp WHERE 1 AND cp.clinical_sale_id = '" . (int)$herbal_id . "' GROUP BY cp.clinical_sale_id");
		return $query->row;
	}
	
		public function getHerbalProducts2($herbal_id)
	{
		$query = $this->db->query("SELECT CONCAT(pd.name, '(', p.code, ') ', SUM(cp.quantity),wcd.unit) AS product   FROM " . DB_PREFIX . "clinicalsale_product cp LEFT JOIN " . DB_PREFIX . "product p ON (cp.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (cp.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "product_code_match pcm ON cp.product_id = pcm.product_id LEFT JOIN `" . DB_PREFIX . "weight_class_description` wcd ON cp.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int)$this->config->get('config_language_id') . "'  WHERE cp.clinical_sale_id = '" . (int)$herbal_id . "' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' GROUP BY cp.product_id");
		return $query->rows;
	}
	
    public function getErrorHerbal() {
        $query = $this->db->query("SELECT cs.clinical_sale_id, cs.sales_date, cs.collect_consultation_price, cs.clinicalsale_concultation, cs.invoice_prefix, cs.doctor_id FROM `" . DB_PREFIX . "clinical_sale` cs WHERE 1 AND cs.collect_consultation_price = 1 AND DATE(cs.sales_date) BETWEEN DATE('2017-09-01') AND DATE('2017-10-06') ORDER BY cs.clinical_sale_id ASC");
        return $query->rows;
    }

    public function getHerbalbyCustomerId($customer_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_sale WHERE 1 AND customer_id = '" . (int) $customer_id . "' ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function updatErrorOrderTotal($data) {
        // Get the total
        $order_total = 0;
        $this->db->query("DELETE FROM " . DB_PREFIX . "order_total WHERE order_id = '" . (int) $data['order_id'] . "'");
        if (isset($data['total_data'])) {
            foreach ($data['total_data'] as $total) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "order_total SET order_id = '" . (int) $data['order_id'] . "', code = '" . $this->db->escape($total['code']) . "', tax_key ='" . (int) $total['key'] . "', tax_code = '" . $this->db->escape($total['tax_code']) . "', title = '" . $this->db->escape($total['title']) . "', `value` = '" . (float) $total['value'] . "', sort_order = '" . (int) $total['sort_order'] . "'");
            }
            /* foreach ($data['total_data'] as $total) {
              $this->db->query("UPDATE " . DB_PREFIX . "order_total SET `value` = '" . (float) $total['value'] . "' WHERE order_id = '" . (int)$data['order_id'] ."' AND code = '" . $total['code']."'");
              } */
            $order_total += $total['value'];
        }
        // Update order total
        $this->db->query("UPDATE `" . DB_PREFIX . "order` SET total = '" . (float) $order_total . "' WHERE order_id = '" . (int) $data['order_id'] . "'");
    }

    public function getErrorHerbalTotal($clinical_sale_id) {
        $query = $this->db->query("SELECT cst.* FROM `" . DB_PREFIX . "clinical_sale_total` cst WHERE 1 AND clinical_sale_id = '" . (int) $clinical_sale_id . "'");
        return $query->rows;
    }

    public function updateErrorHerbal($data) {
        $this->db->query("UPDATE `" . DB_PREFIX . "clinical_sale` SET d_net_amount = '" . (float) $data['d_net_amount'] . "', d_gst = '" . (float) $data['d_gst'] . "', total_d_gst = '" . (float) $data['total_d_gst'] . "', total = '" . (float) $data['total'] . "' WHERE clinical_sale_id = '" . (int) $data['clinical_sale_id'] . "'");
    }

    public function updateErrorHerbalTotal($data) {
        if (!empty($data['order_totals'])) {
            foreach ($data['order_totals'] as $order_total) {
                $this->db->query("UPDATE `" . DB_PREFIX . "clinical_sale_total` SET value = '" . $order_total['value'] . "' WHERE clinical_sale_total_id = '" . (int) $order_total['clinical_sale_total_id'] . "' AND clinical_sale_id = '" . (int) $order_total['clinical_sale_id'] . "' AND code = '" . $order_total['code'] . "'");
            }
        }
    }

    public function getTotalHerbal($data = array()) {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "clinical_sale cs  LEFT JOIN " . DB_PREFIX . "customer c ON (cs.customer_id = c.customer_id)";

        $implode = array();

        if (!empty($data['filter_date_from'])) {
            $implode[] = "DATE(cs.sales_date) >= ('" . $this->db->escape($data['filter_date_from']) . "')";
        }

        if (!empty($data['filter_date_to'])) {
            $implode[] = "DATE(cs.sales_date) <= ('" . $this->db->escape($data['filter_date_to']) . "')";
        }

        if (!empty($data['filter_transaction_from']) && !empty($data['filter_transaction_to'])) {
            $implode[] = "cs.invoice_prefix BETWEEN '" . $this->db->escape($data['filter_transaction_from']) . "' AND '" . $this->db->escape($data['filter_transaction_to']) . "'";
        }


        if (isset($data['filter_customer_ic'])) {
            $implode[] = "c.customer_ic = '" . $data['filter_customer_ic'] . "'";
        }

        if (!empty($data['filter_customer_card'])) {
            $implode[] = "c.customer_card = '" . (int) $data['filter_customer_card'] . "'";
        }

        //history
        if (!empty($data['customer_id'])) {
            $implode[] = "cs.customer_id = '" . $this->db->escape($data['customer_id']) . "'";
        }

        if (!empty($data['herbal_id'])) {
            $implode[] = "cs.clinical_sale_id < '" . (int) $data['herbal_id'] . "'";
        }

        if (!empty($data['filter_diagnostic'])) {
            $implode[] = "cs.diagnostic LIKE '%" . $this->db->escape($data['filter_diagnostic']) . "%'";
        }

        if (!empty($data['filter_doctoradvice'])) {
            $implode[] = "cs.doctoradvice LIKE '%" . $this->db->escape($data['filter_doctoradvice']) . "%'";
        }

        if (!empty($data['filter_pulse'])) {
            $implode[] = "cs.pulse LIKE '%" . $this->db->escape($data['filter_pulse']) . "%'";
        }

        if (!empty($data['filter_disease'])) {
            $implode[] = "cs.disease LIKE '%" . $this->db->escape($data['filter_disease']) . "%'";
        }

        if (!empty($data['filter_treatment'])) {
            $implode[] = "cs.treatment LIKE '" . $this->db->escape($data['filter_treatment']) . "%'";
        }

        if (!empty($data['filter_acupuncture'])) {
            $implode[] = "cs.acupuncture LIKE '" . $this->db->escape($data['filter_acupuncture']) . "%'";
        }

        if (!empty($data['filter_symptoms'])) {
            $implode[] = "cs.symptom LIKE '" . $this->db->escape($data['filter_symptoms']) . "%'";
        }

        //end filter history


        if (!empty($data['filter_customer_firstname'])) {
            $implode[] = "c.firstname LIKE '" . $this->db->escape($data['filter_customer_firstname']) . "%'";
        }

        if (isset($data['filter_payment_status']) && !is_null($data['filter_payment_status'])) {
            $implode[] = "cs.order_action = '" . (int) $data['filter_payment_status'] . "'";
        }

        if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
            $implode[] = "cs.clinicalsale_action = '" . (int) $data['filter_status'] . "'";
        }

        if (isset($data['filter_doctor']) && !is_null($data['filter_doctor'])) {
            $implode[] = "cs.doctor_id = '" . (int) $data['filter_doctor'] . "'";
        }

        if ($implode) {
            $sql .= " WHERE " . implode(" AND ", $implode);
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getHerbals($data = array()) {

        $sql = "SELECT *,(SELECT os.name FROM " . DB_PREFIX . "order_status os WHERE os.order_status_id = cs.clinicalsale_action AND os.language_id = '" . (int) $this->config->get('config_language_id') . "') AS status,(SELECT os.name FROM " . DB_PREFIX . "order_status os WHERE os.order_status_id = cs.order_action AND os.language_id = '" . (int) $this->config->get('config_language_id') . "') AS order_status FROM " . DB_PREFIX . "clinical_sale cs  LEFT JOIN " . DB_PREFIX . "customer c ON (cs.customer_id = c.customer_id)";



        $implode = array();

        if (!empty($data['filter_date_from'])) {
            $implode[] = "DATE(cs.sales_date) >= ('" . $this->db->escape($data['filter_date_from']) . "')";
        }

        if (!empty($data['filter_date_to'])) {
            $implode[] = "DATE(cs.sales_date) <= ('" . $this->db->escape($data['filter_date_to']) . "')";
        }

        if (!empty($data['filter_transaction_from']) && !empty($data['filter_transaction_to'])) {
            $implode[] = "cs.invoice_prefix BETWEEN '" . $this->db->escape($data['filter_transaction_from']) . "' AND '" . $this->db->escape($data['filter_transaction_to']) . "'";
        }


        if (isset($data['filter_customer_ic'])) {
            $implode[] = "c.customer_ic = '" . $data['filter_customer_ic'] . "'";
        }

        if (!empty($data['filter_customer_card'])) {
            $implode[] = "c.customer_card = '" . $this->db->escape($data['filter_customer_card']) . "'";
        }


        //history

        if (!empty($data['customer_id'])) {
            $implode[] = "cs.customer_id = '" . $this->db->escape($data['customer_id']) . "'";
        }

        if (!empty($data['herbal_id'])) {
            $implode[] = "cs.clinical_sale_id < '" . (int) $data['herbal_id'] . "'";
        }

        if (!empty($data['filter_diagnostic'])) {
            $implode[] = "cs.diagnostic LIKE '%" . $this->db->escape($data['filter_diagnostic']) . "%'";
        }

        if (!empty($data['filter_doctoradvice'])) {
            $implode[] = "cs.doctoradvice LIKE '%" . $this->db->escape($data['filter_doctoradvice']) . "%'";
        }

        if (!empty($data['filter_pulse'])) {
            $implode[] = "cs.pulse LIKE '%" . $this->db->escape($data['filter_pulse']) . "%'";
        }

        if (!empty($data['filter_disease'])) {
            $implode[] = "cs.disease LIKE '%" . $this->db->escape($data['filter_disease']) . "%'";
        }

        if (!empty($data['filter_treatment'])) {
            $implode[] = "cs.treatment LIKE '" . $this->db->escape($data['filter_treatment']) . "%'";
        }

        if (!empty($data['filter_acupuncture'])) {
            $implode[] = "cs.acupuncture LIKE '" . $this->db->escape($data['filter_acupuncture']) . "%'";
        }

        if (!empty($data['filter_symptoms'])) {
            $implode[] = "cs.symptom LIKE '" . $this->db->escape($data['filter_symptoms']) . "%'";
        }

        //end filter history


        if (!empty($data['filter_customer_firstname'])) {
            $implode[] = "c.firstname LIKE '" . $this->db->escape($data['filter_customer_firstname']) . "%'";
        }

        if (isset($data['filter_payment_status']) && !is_null($data['filter_payment_status'])) {
            $implode[] = "cs.order_action = '" . (int) $data['filter_payment_status'] . "'";
        }

        if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
            $implode[] = "cs.clinicalsale_action = '" . (int) $data['filter_status'] . "'";
        }

        if (isset($data['filter_doctor']) && !is_null($data['filter_doctor'])) {
            $implode[] = "cs.doctor_id = '" . (int) $data['filter_doctor'] . "'";
        }


        if ($implode) {
            $sql .= " WHERE " . implode(" AND ", $implode);
        }

        $sort_data = array(
            'cs.sales_date',
            'cs.invoice_prefix',
            'c.firstname',
            'c.customer_ic',
            'c.customer_card',
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY cs.sales_date DESC, cs.invoice_prefix ";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function addHerbal($data) {

        $this->load->model('setting/setting');
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));

        $this->db->query("
			INSERT INTO " . DB_PREFIX . "clinical_sale SET
				customer_id = '" . (int) $data['customer_id'] . "',
				doctor_id = '" . (int) $data['doctor_id'] . "',
				invoice_prefix ='" . $this->db->escape($invoice_prefix) . "',
				sales_date = Now(),
				store_id = '" . (int) $this->session->data['store_id'] . "',
				clinicalsale_action = '" . (int) 1 . "',
				clinicalsale_concultation = '" . (float) $data['consultationprice'] . "',
				collect_consultation_price = '" . (int) $data['enable_consultation_price'] . "',
				order_action = '" . (int) 17 . "',
				add_by = '" . (int) $this->session->data['user_id'] . "',
				date_added = NOW(),
				modifi_by = '" . (int) $this->session->data['user_id'] . "',
				date_modified = NOW()
		");

        $clinical_sale_id = $this->db->getLastId();

        if ($clinical_sale_id != 0) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));
        }
        return $clinical_sale_id;
    }

    public function getHerbal($herbal_id) {

        $query = $this->db->query("SELECT (SELECT u.firstname FROM " . DB_PREFIX . "user u WHERE u.user_id = cs.doctor_id) AS doctor_firstname,(SELECT u.lastname FROM " . DB_PREFIX . "user u WHERE u.user_id = cs.doctor_id) AS doctor_lastname,c.*,cs.* FROM " . DB_PREFIX . "clinical_sale cs  LEFT JOIN " . DB_PREFIX . "customer c ON (cs.customer_id = c.customer_id) WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->row;
    }

    public function getImage($herbal_id) {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinical_sale_image  WHERE clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getHerbalPrescription($herbal_id) {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinecal_sales_prescription cp WHERE cp.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getHerbalService($herbal_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinecal_service_item cs WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getHerbalProduct($prescription_id) {
        $query = $this->db->query("SELECT cp.* FROM " . DB_PREFIX . "clinicalsale_product cp LEFT JOIN " . DB_PREFIX . "product p ON (cp.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (cp.product_id = pd.product_id) WHERE cp.prescription_id = '" . (int) $prescription_id . "' AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "'");
        return $query->rows;
    }

    public function getHerbalInfoProduct($prescription_id) {
        $query = $this->db->query("SELECT *,cp.quantity AS quantity,cp.price AS product_price, cp.weight, cp.weight_class_id FROM " . DB_PREFIX . "clinicalsale_product cp LEFT JOIN " . DB_PREFIX . "product p ON (cp.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (cp.product_id = pd.product_id) WHERE cp.prescription_id = '" . (int) $prescription_id . "' AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "'");
        return $query->rows;
    }

    public function getHerbalTotals($herbal_id) {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinical_sale_total cs WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getHerbalDateModified($herbal_id) {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinical_sale cs  LEFT JOIN " . DB_PREFIX . "customer c ON (cs.customer_id = c.customer_id) WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->row['date_modified'];
    }

    public function getCookType() {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "cook_type ct LEFT JOIN " . DB_PREFIX . "cook_type_description ctd ON (ct.cook_type_id = ctd.cook_type_id) WHERE ct.status = '" . (int) 1 . "' AND ctd.language_id = '" . (int) $this->config->get('config_language_id') . "'");

        return $query->rows;
    }

    public function editOrder($herbal_id, $data) {

        $this->load->model('localisation/currency');

        $currency_info = $this->model_localisation_currency->getCurrencyByCode($this->config->get('config_currency'));

        if ($currency_info) {
            $currency_id = $currency_info['currency_id'];
            $currency_code = $currency_info['code'];
            $currency_value = $currency_info['value'];
        } else {
            $currency_id = 0;
            $currency_code = $this->config->get('config_currency');
            $currency_value = 1.00000;
        }


        $this->db->query("update " . DB_PREFIX . "clinical_sale SET
	    shipping_address_id = '" . (int) $data['shipping_address_id'] . "',
		clinicalsale_action = '" . (int) $data['status'] . "',
		doctor_id = '" . (int) $data['doctor_id'] . "',
		diagnostic = '" . $this->db->escape($data['diagnostic']) . "',
		doctoradvice = '" . $this->db->escape($data['doctoradvice']) . "',
		pulse = '" . $this->db->escape($data['pulse']) . "',
		disease = '" . $this->db->escape($data['disease']) . "',
		treatment = '" . $this->db->escape($data['treatment']) . "',
		acupuncture = '" . $this->db->escape($data['acupuncture']) . "',
		symptom = '" . $this->db->escape($data['symptom']) . "',
	    modifi_by = '" . (int) $this->session->data['user_id'] . "',
	    date_modified = NOW()
		WHERE clinical_sale_id = '" . (int) $herbal_id . "'");


        $this->db->query("DELETE FROM " . DB_PREFIX . "clinecal_sales_prescription WHERE clinical_sale_id = '" . (int) $herbal_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinicalsale_product WHERE clinical_sale_id = '" . (int) $herbal_id . "'");

        $product_total = 0;
        $product_tax = 0;
        $product_sutotal = 0;
        $weight = 0;
        $times = 0;
        $total_times = 0;
        $per_time = 0;

        if (!empty($data['prescription'])) {


            foreach ($data['prescription'] as $key => $itmes) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinecal_sales_prescription SET
			  clinical_sale_id = '" . (int) $herbal_id . "',
			  prescription_id = '" . $this->db->escape($itmes['id']) . "',
			  name = '" . $this->db->escape($itmes['name']) . "',
			  modifi_by = '" . (int) $this->session->data['user_id'] . "',
			  date_modified = NOW()");

                $prescription_id = $this->db->getLastId();
                if (!empty($data['products'])) {
                    foreach ($data['products'][$key] as $product_id => $product) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "clinicalsale_product SET
					  clinical_sale_id = '" . (int) $herbal_id . "',
					  product_id = '" . (int) $product['product_id'] . "',
					  prescription_id = '" . (int) $prescription_id . "',
					  quantity = '" . (float) $product['quantity'] . "',
					  times = '" . (int) $product['times'] . "',
					  price = '" . (float) $product['price'] . "',
					  day = '" . (int) $product['day'] . "',
					  t_qty = '" . (float) $product['quantity'] * (int) $product['times'] . "',
					  weight = '" . (float) $product['product_weight'] . "',
					  weight_class_id = '" . (int) $product['weight_class_id'] . "',
					  t_weight = '" . (float) $product['weight'] . "',
					  cook = '" . $this->db->escape($product['cook']) . "',
					  taketype = '" . $this->db->escape($product['taketype']) . "',
					  t_gst = '" . (float) $product['tax'] . "',
					  discount = '" . (float) $product['discount'] . "',
					  t_net_price = '" . (float) $product['subtotal'] . "',
					  tax_class_id = '" . (int) $product['tax_class_id'] . "',
					  tax_code = '" . $this->db->escape($product['tax_code']) . "',
					  tax_format = '" . $this->db->escape($product['tax_format']) . "',
					  gst = '" . (float) $product['product_tax'] . "',
					  net_price = '" . (float) $product['product_subtotal'] . "',
					  rowtotal = '" . (float) $product['total'] . "',
					  modifi_by = '" . (int) $this->session->data['user_id'] . "',
					  date_modified = NOW()");

                        $product_total += $product['total'];
                        $product_sutotal += $product['subtotal'];
                        $product_tax += $product['tax'];
                        $times = $product['times'];
                    }
                }

                $total_times += $times;
                $per_time = $product['day'];
            }

            $this->db->query("update " . DB_PREFIX . "clinical_sale SET
	        clinicalsale_total = '" . (float) $product_total . "',
		    net_total = '" . (float) $product_sutotal . "',
	        gst = '" . (float) $product_tax . "'
	     	WHERE clinical_sale_id = '" . (int) $prescription_id . "'");
        } //end add product and prescription


        $this->db->query("DELETE FROM " . DB_PREFIX . "clinecal_service_item WHERE clinical_sale_id = '" . (int) $herbal_id . "'");
        if (!empty($data['service'])) {
            foreach ($data['service'] as $key => $service) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinecal_service_item SET
					  clinical_sale_id = '" . (int) $herbal_id . "',
					  clinicalservice_id = '" . (int) $service['service_id'] . "',
					  staffincharge ='" . (int) $service['staff_id'] . "',
					  servicename ='" . $this->db->escape($service['service_name']) . "',
					  serviceminutes ='" . $this->db->escape($service['service_minute']) . "',
					  price = '" . (float) $service['price'] . "',
					  tax_class_id = '" . (int) $service['tax_class_id'] . "',
					  tax_code = '" . $this->db->escape($service['tax_code']) . "',
					  tax_format = '" . $this->db->escape($service['tax_format']) . "',
					  t_gst = '" . (float) $service['tax'] . "',
					  t_net_price = '" . (int) $service['subtotal'] . "',
					  gst = '" . $service['nat_tax'] . "',
					  net_price = '" . (float) $service['net_price'] . "',
					  rowtotal = '" . (float) $service['total'] . "',
					  modifi_by = '" . (int) $this->session->data['user_id'] . "',
					  date_modified = NOW()");

                $clinecal_service_item_id = $this->db->getLastId();

                if (!empty($data['acupuncture_list'][$service['service_id']])) {
                    $this->db->query("UPDATE " . DB_PREFIX . "clinecal_service_item SET acupuncture_parts = '" . $this->db->escape(serialize($data['acupuncture_list'][$service['service_id']])) . "' WHERE clinecal_service_id = '" . (int) $clinecal_service_item_id . "'");
                } else {
                    $this->db->query("UPDATE " . DB_PREFIX . "clinecal_service_item SET acupuncture_parts = '" . $this->db->escape(serialize(array())) . "' WHERE clinecal_service_id = '" . (int) $clinecal_service_item_id . "'");
                }
            }
        }

        //add services
        if ($data['status'] == 5 && !empty($data['service'])) {

            $this->load->model('setting/setting');
            $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));

            $this->db->query("
			  INSERT INTO " . DB_PREFIX . "service_form SET
					invoice_prefix = '" . $this->db->escape($invoice_prefix) . "',
					customer_id = '" . (int) $data['customer_id'] . "',
					user_id = '" . (int) $service['staff_id'] . "',
					service_date = Now(),
					store_id = '" . (int) $this->session->data['store_id'] . "',
					serviceform_action = '" . (int) 1 . "',
					order_action = '" . (int) 17 . "',
					add_by = '" . (int) $this->session->data['user_id'] . "',
					date_added = NOW(),
					modifi_by = '" . (int) $this->session->data['user_id'] . "',
					date_modified = NOW()
			");

            $service_form_id = $this->db->getLastId();

            if ($service_form_id != 0) {
                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));
            }

            $service_subtotal = 0;
            $service_total = 0;
            $service_gst = 0;
            foreach ($data['service'] as $key => $service) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "service_item SET
			  service_form_id = '" . (int) $service_form_id . "',
			  clinicalservice_id = '" . (int) $service['service_id'] . "',
			  servicename ='" . $this->db->escape($service['service_name']) . "',
			  serviceminutes = '" . $this->db->escape($service['service_minute']) . "',
			  user_id = '" . (int) $this->session->data['user_id'] . "',
			  price = '" . (float) $service['price'] . "',
			  total = '" . (float) $service['total_whit_gst'] . "',
			  net_amount = '" . (float) $service['net_total'] . "',
			  tax_class_id = '" . (int) $service['tax_class_id'] . "',
			  tax_code = '" . $this->db->escape($service['tax_code']) . "',
			  tax_format = '" . $this->db->escape($service['tax_format']) . "',
			  gst = '" . $service['nat_tax'] . "',
			  modifi_by = '" . (int) $this->session->data['user_id'] . "',
			  date_modified = NOW()");

                $service_item_id = $this->db->getLastId();

                if (!empty($data['acupuncture_list'][$service['service_id']])) {
                    foreach ($data['acupuncture_list'][$service['service_id']] as $acupuncture) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "service_item_acupuncture_point
					  					SET service_Item_id = '" . (int) $service_item_id . "',
											acupuncture_id = '" . (int) $acupuncture['acupuncture_id'] . "',
											num_of_acupuncture = '" . (int) $acupuncture['num_of_acupuncture'] . "'");
                    }
                }

                $service_subtotal += $service['subtotal'];
                $service_total += $service['total'];
                $service_gst += $service['tax'];
            }

            $this->db->query("update " . DB_PREFIX . "service_form SET
	        total_price = '" . (float) $service_total . "',
		    net_amount = '" . (float) $service_subtotal . "',
	        t_gst = '" . (float) $service_gst . "'
	     	WHERE service_form_id = '" . (int) $service_form_id . "'");
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_sale_image WHERE clinical_sale_id = '" . (int) $herbal_id . "'");

        if (!empty($data['images'])) {
            foreach ($data['images'] as $key => $image) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale_image SET
			  clinical_sale_id = '" . (int) $herbal_id . "',
			  folder = '" . $this->db->escape($image['name']) . "',
			  customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
			  category_id = '" . (int) $image['category_id'] . "',
			  remark = '" . $this->db->escape($image['remark']) . "',
			  image ='" . $this->db->escape($image['path']) . "',
			  modifi_by = '" . (int) $this->session->data['user_id'] . "',
			  date_modified = NOW()");
            }
        }

        // Get the total
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_sale_total WHERE clinical_sale_id = '" . (int) $herbal_id . "' AND id ='1' ");
        $subtotal = 0;
        $tax = 0;
        $total = 0;

        if (isset($data['order_total'])) {
            foreach ($data['order_total'] as $order_total) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale_total SET clinical_sale_id = '" . (int) $herbal_id . "',id ='1',tax_code ='" . $this->db->escape($order_total['tax_code']) . "', code = '" . $this->db->escape($order_total['code']) . "', tax_key = '" . (int) $order_total['key'] . "', title = '" . $this->db->escape($order_total['title']) . "',  `value` = '" . (float) $order_total['value'] . "', sort_order = '" . (int) $order_total['sort_order'] . "'");

                if ($order_total['code'] == 'sub_total') {
                    $subtotal += $order_total['value'];
                }
                if ($order_total['code'] == 'tax') {
                    $tax += $order_total['value'];
                }
                if ($order_total['code'] == 'total') {
                    $total += $order_total['value'];
                }
            }
        }

        $this->db->query("update " . DB_PREFIX . "clinical_sale SET
	  clinicalsale_total = '" . (float) $total . "', net_total = '" . (float) $subtotal . "', gst ='" . (float) $tax . "' WHERE clinical_sale_id = '" . (int) $herbal_id . "'");

        $subtotal = 0;
        $tax = 0;
        $total = 0;

        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_sale_total WHERE clinical_sale_id = '" . (int) $herbal_id . "' AND id ='2' ");

        if (isset($data['total_doctor_data'])) {
            foreach ($data['total_doctor_data'] as $total_doctor_data) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale_total SET clinical_sale_id = '" . (int) $herbal_id . "',id ='2', tax_code ='" . $this->db->escape($total_doctor_data['tax_code']) . "', code = '" . $this->db->escape($total_doctor_data['code']) . "', tax_key = '" . (int) $total_doctor_data['key'] . "', title = '" . $this->db->escape($total_doctor_data['title']) . "',  `value` = '" . (float) $total_doctor_data['value'] . "', sort_order = '" . (int) $total_doctor_data['sort_order'] . "'");

                if ($total_doctor_data['code'] == 'sub_total') {
                    $subtotal += $total_doctor_data['value'];
                }
                if ($total_doctor_data['code'] == 'tax') {
                    $tax += $total_doctor_data['value'];
                }
                if ($total_doctor_data['code'] == 'total') {
                    $total += $total_doctor_data['value'];
                }
            }
        }

        $total_sales = $product_total + $data['doctor_total'];

        $total_weight = ($total_times * $per_time) * $this->config->get('config_herbal_weight');
        $weight_class_id = $this->config->get('config_herbal_weight_class_id');
        $this->db->query("update " . DB_PREFIX . "clinical_sale SET
	  total_d_gst = '" . (float) $data['doctor_total'] . "', collect_consultation_price = '" . (int) $data['enable_doctorprice'] . "', clinicalsale_concultation = '" . (float) $data['doctor_price'] . "', d_gst ='" . (float) $data['doctor_tax'] . "',d_net_amount ='" . (float) $data['doctor_subtotal'] . "', tax_format='" . $this->db->escape($data['doctor_format']) . "', tax_class_id ='" . (int) $data['tax_class_id'] . "',total ='" . (float) $total_sales . "',tax_code ='" . $this->db->escape($data['tax_code']) . "', currency_id = '" . (int) $currency_id . "', currency_code = '" . $this->db->escape($currency_code) . "',weight ='" . (float) $total_weight . "', weight_class_id ='" . (int) $weight_class_id . "', currency_value = '" . (float) $currency_value . "' WHERE clinical_sale_id = '" . (int) $herbal_id . "'");

        unset($this->session->data['prescription']);
        unset($this->session->data['product']);
        unset($this->session->data['service']);
        unset($this->session->data['image']);
        unset($this->session->data['shipping_addres_id']);
        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        return $herbal_id;
    }

    public function deleteHerbal($herbal_id) {

        //delete ServiceForm and ServiceForm item
        $sql = "
		UPDATE " . DB_PREFIX . "clinical_sale
		SET
			clinicalsale_action = 7,
			modifi_by 			= '" . $this->session->data['user_id'] . "',
			date_modified 			= NOW()
		WHERE clinical_sale_id = $herbal_id";
        $query = $this->db->query($sql);

        $this->cache->delete('herbal');
    }

    public function selectHerbal($data = array()) {

        $filter_invoice_prefix_statement = isset($data['invoice_prefix']) ? "AND cs.invoice_prefix = '" . $this->db->escape($data['invoice_prefix']) . "'" : "";
        $filter_clinical_sale_id_statement = isset($data['clinical_sale_id']) ? "AND cs.clinical_sale_id = '" . (int) $data['clinical_sale_id'] . "'" : "";

        $filter_clinicalsale_action_statement = isset($data['clinicalsale_action']) ? "AND cs.clinicalsale_action = '" . (int) $data['clinicalsale_action'] . "'" : "";

        $filter_customer_card_statement = isset($data['customer_card']) ? "AND c.customer_card = '" . $this->db->escape($data['customer_card']) . "'" : "";

        $filter_customer_ic_statement = isset($data['customer_ic']) ? "AND c.customer_ic = '" . $this->db->escape($data['customer_ic']) . "'" : "";



        $limit_statement = "";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $sql = "
		SELECT
			cs.*,
			c.customer_card,
			c.customer_ic,
			c.firstname,
			c.lastname,
			c.email,
			a.address_1,
			a.address_2,
			a.address_3,
			a.city,
			a.postcode,
			a.country_id,
			ctry.name AS country,
			a.zone_id,
			z.name AS state
		FROM " . DB_PREFIX . "clinical_sale	cs
		LEFT JOIN " . DB_PREFIX . "customer c
		ON cs.customer_id = c.customer_id
		LEFT JOIN " . DB_PREFIX . "address a
		ON c.address_id = a.address_id
		LEFT JOIN " . DB_PREFIX . "zone z
		ON a.zone_id = z.zone_id
		LEFT JOIN " . DB_PREFIX . "country ctry
		ON a.country_id = ctry.country_id
		WHERE 1
		$filter_invoice_prefix_statement
		$filter_clinical_sale_id_statement
		$filter_clinicalsale_action_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$limit_statement
		";

        /*
          echo "<pre>";
          print_r($sql);
          echo "</pre>";
         */

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function totalSelectHerbal($data = array()) {
        $filter_invoice_prefix_statement = isset($data['invoice_prefix']) ? "AND cs.invoice_prefix = '" . $this->db->escape($data['invoice_prefix']) . "'" : "";
        $filter_clinical_sale_id_statement = isset($data['clinical_sale_id']) ? "AND cs.clinical_sale_id = '" . (int) $data['clinical_sale_id'] . "'" : "";
        $filter_clinicalsale_action_statement = isset($data['clinicalsale_action']) ? "AND cs.clinicalsale_action = '" . (int) $data['clinicalsale_action'] . "'" : "";
        $filter_customer_card_statement = isset($data['customer_card']) ? "AND c.customer_card = '" . $this->db->escape($data['customer_card']) . "'" : "";

        $filter_customer_ic_statement = isset($data['customer_ic']) ? "AND c.customer_ic = '" . $this->db->escape($data['customer_ic']) . "'" : "";

        $sql = "
		SELECT
			COUNT(*) AS num
		FROM " . DB_PREFIX . "clinical_sale	cs
		LEFT JOIN " . DB_PREFIX . "customer c
		ON cs.customer_id = c.customer_id
		LEFT JOIN " . DB_PREFIX . "address a
		ON c.address_id = a.address_id
		LEFT JOIN " . DB_PREFIX . "zone z
		ON a.zone_id = z.zone_id
		LEFT JOIN " . DB_PREFIX . "country ctry
		ON a.country_id = ctry.country_id
		WHERE 1
		$filter_invoice_prefix_statement
		$filter_clinical_sale_id_statement
		$filter_clinicalsale_action_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		";

        $query = $this->db->query($sql);

        return $query->row['num'];
    }

    public function getHerbalImages($customer_id, $herbla_id = 0) {

        $query = $this->db->query("SELECT cs.clinical_sale_id,cs.sales_date,cs.customer_id,cs.invoice_prefix FROM " . DB_PREFIX . "clinical_sale cs WHERE cs.clinical_sale_id IN(SELECT ci.clinical_sale_id
               FROM " . DB_PREFIX . "clinical_sale_image ci) AND customer_id ='" . (int) $customer_id . "' AND cs.clinical_sale_id !='" . $herbla_id . "' ORDER BY cs.sales_date DESC");

        return $query->rows;
    }

    // added by lunguang 20160408 1815
    public function getHerbalRemediesBasicData($herbal_id) {
        $sql = "SELECT CONCAT(c.firstname, ' ', c.lastname) AS customer_name,
					   c.customer_ic,
					   cs.invoice_prefix,
					   cs.date_added,
					   CONCAT(u.firstname, ' ', u.lastname) AS doctor_name,
					   c.gender,
					   c.telephone,
					   cs.diagnostic,
					   cs.doctoradvice,
					   cs.pulse,
					   cs.disease,
					   cs.treatment,
					   cs.acupuncture,
					   cs.symptom,
					   csp.times,
					   csp.day,
					   csp.cook,
					   csp.taketype
				FROM " . DB_PREFIX . "clinical_sale cs
				LEFT JOIN " . DB_PREFIX . "customer c
				ON c.customer_id = cs.customer_id
				LEFT JOIN " . DB_PREFIX . "user u
				ON u.user_id = cs.doctor_id
				LEFT JOIN " . DB_PREFIX . "clinicalsale_product csp
				ON csp.clinical_sale_id = cs.clinical_sale_id
				WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    // added by lunguang 20160411 1716
    public function getHerbalRemediesImage($herbal_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_sale_image WHERE clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    // added by lunguang 20160412 1257
    public function getDoctors() {
        $sql = "SELECT CONCAT(firstname, ' ', lastname) AS doctor_name, user_id FROM " . DB_PREFIX . "user WHERE position = '2'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    //added by lunguang 20160801 1204
    public function getTotalCustomers($data = array()) {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE customer_group_id = '1' AND status = '1'";

        if (!empty($data['customer_name'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
        }

        if (!empty($data['customer_ic'])) {
            $sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['customer_ic']) . "%'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    //added by lunguang 20160801 1204
    public function getCustomers($data = array()) {
        $sql = "SELECT customer_id,
					   CONCAT(firstname, ' ', lastname) AS customer_name,
					   customer_ic,
					   customer_card
				FROM " . DB_PREFIX . "customer
				WHERE status = '1'";

        if (!empty($data['customer_name'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
        }

        if (!empty($data['customer_ic'])) {
            $sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['customer_ic']) . "%'";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }
            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCustomerByIC($data = array()) {
        $sql = "SELECT customer_id, CONCAT(firstname, ' ', lastname) AS customer_name, customer_card, customer_ic FROM " . DB_PREFIX . "customer WHERE status = '1'";

        if (isset($data['customer_ic'])) {
            $sql .= " AND customer_ic = '" . $this->db->escape($data['customer_ic']) . "'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function updateCustomer($herbal_id, $customer_id) {
        $sql = "UPDATE " . DB_PREFIX . "clinical_sale
				SET customer_id = '" . (int) $customer_id . "'
				WHERE clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);
    }

    public function getPatientPrescription($herbal_id) {
        $prescriptions = array();

        $sql = "SELECT *
				FROM " . DB_PREFIX . "clinecal_sales_prescription WHERE
				clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);

        $prescription_rows = $query->rows;
        if (!empty($prescription_rows)) {
            foreach ($prescription_rows as $prescription) {
                $sql_prescription_item = "SELECT cp.product_id,
												 pd.name AS product_name,
												 p.code,
												 cp.quantity,
												 cp.times,
												 cp.day
										  FROM " . DB_PREFIX . "clinicalsale_product cp
										  LEFT JOIN " . DB_PREFIX . "product p
										  ON p.product_id = cp.product_id
										  LEFT JOIN " . DB_PREFIX . "product_description pd
										  ON pd.product_id = cp.product_id
										  AND pd.language_id = " . $this->config->get('config_language_id') . "
										  WHERE prescription_id = '" . (int) $prescription['clinical_sale_prescription_id'] . "'";

                $prescription_item_query = $this->db->query($sql_prescription_item);

                $prescription_item_rows = $prescription_item_query->rows;

                if (!empty($prescription_item_rows)) {
                    foreach ($prescription_item_rows as $item) {
                        $prescription_items[$prescription['clinical_sale_prescription_id']][] = array(
                            'product_id' => $item['product_id'],
                            'product_name' => $item['product_name'],
                            'product_code' => $item['code'],
                            'quantity' => $item['quantity'],
                            'times' => $item['times'],
                            'day' => $item['day']
                        );
                    }
                } else {
                    $prescription_items[$prescription['clinical_sale_prescription_id']] = array();
                }

                $prescriptions[] = array(
                    'clinical_sale_prescription_id' => $prescription['clinical_sale_prescription_id'],
                    'prescription_name' => $prescription['name'],
                    'prescription_items' => $prescription_items[$prescription['clinical_sale_prescription_id']]
                );
            }
        } else {
            $prescription = array();
        }

        return $prescriptions;
    }

    public function getDoctorDevice($doctor_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "user_device WHERE user_id = '" . (int) $doctor_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getAcupunctureNameById($acupuncture_id) {
        $sql = "SELECT name
				FROM " . DB_PREFIX . "acupuncture_name
				WHERE language_id = '" . $this->config->get('config_language_id') . "'
				AND acupuncture_id = '" . (int) $acupuncture_id . "'";

        $query = $this->db->query($sql);

        return $query->row['name'];
    }

    public function getHerbalServiceAcupuncture($herbal_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinecal_service_item WHERE clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);
        $clinical_service_items = $query->rows;

        $herbal_service_acupuncture_arr = array();

        foreach ($clinical_service_items as $item) {
            $clinical_service_id = $item['clinicalservice_id'];
            $acupuncture_parts_arr = unserialize($item['acupuncture_parts']);

            $herbal_service_acupuncture_arr[$clinical_service_id] = $acupuncture_parts_arr;
        }

        return $herbal_service_acupuncture_arr;
    }

    public function getAutocompleteFormCustomers($data) {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE status = '1' AND approved = '1'";

        if (!empty($data['filter_firstname'])) {
            $sql .= " AND firstname LIKE '%" . $this->db->escape($data['filter_firstname']) . "%'";
        }

        if (!empty($data['filter_lastname'])) {
            $sql .= " AND lastname LIKE '%" . $this->db->escape($data['filter_lastname']) . "%'";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

}

?>
