<?php

class ModelFacilityFacility extends Model
{
    public function getFacilities($data = array())
    {
        $default_store_name = $this->config->get('config_name');

        $sql = "SELECT f.* ,
        (CASE WHEN f.store_id = 0 THEN '$default_store_name' ELSE s.name END) AS store_name
        FROM " . DB_PREFIX . "facility f
        LEFT JOIN " . DB_PREFIX . "store s ON(f.store_id = s.store_id) WHERE 1";

        if (!empty($data['filter_name'])) {
            $sql .= " AND f.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (isset($data['sort'])) {
            $sql .= " ORDER BY f." . $data['sort'];
        } else {
            $sql .= " ORDER BY f.name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTotalFacilities($data = array())
    {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "facility WHERE 1";

        if (!empty($data['filter_name'])) {
            $sql .= " AND name LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        $query = $this->db->query($sql);
        return $query->row['total'];
    }

    public function getFacility($id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "facility WHERE facility_id = '" . (int)$id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getFacilityAvailabilities($id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "facility_availability WHERE facility_id = '" . (int)$id . "' ORDER BY 
        CASE day
            WHEN 'Sunday' THEN 1
            WHEN 'Monday' THEN 2
            WHEN 'Tuesday' THEN 3
            WHEN 'Wednesday' THEN 4
            WHEN 'Thursday' THEN 5
            WHEN 'Friday' THEN 6
            WHEN 'Saturday' THEN 7
        END ASC,
        STR_TO_DATE(start_time, '%h:%i %p') ASC";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function addFacility($data)
    {
        if (empty($data['facility_availabilities'])) {
            $data['facility_available'] = '1';
        }

        $sql = "INSERT INTO " . DB_PREFIX . "facility
        SET store_id = '" . (int)$data['store_id'] . "',
        name = '" . $this->db->escape($data['facility_name']) . "',
        available = '" . (int)$data['facility_available'] . "',
        status = '" . (int)$data['facility_status'] . "',
        added_by = '" . (int)$this->user->getId() . "',
        date_added = NOW(),
        modified_by = '" . (int)$this->user->getId() . "',
        date_modified = NOW()
        ";
        $this->db->query($sql);
        $facility_id = $this->db->getLastId();

        if ($data['facility_available'] == 1) {
            $data['facility_availabilities'] = [];
        }

        if ($facility_id > 0 && !empty($data['facility_availabilities'])) {
            foreach ($data['facility_availabilities'] as $detail) {
                if(!empty($detail['check_day'])){
                    foreach($detail['times'] as $time){
                        $sql = "INSERT INTO " . DB_PREFIX . "facility_availability
                        SET facility_id = '" . (int)$facility_id . "',
                        day = '" . $this->db->escape($detail['clinical_day']) . "',
                        start_time = '" . $this->db->escape($time['start_time']) . "',
                        end_time = '" . $this->db->escape($time['end_time']) . "' 
                        ";
                    $this->db->query($sql);
                    }
                }
                
                
            }
        }

        return $facility_id;
    }

    public function editFacility($facility_id, $data)
    {
        if (empty($data['facility_availabilities'])) {
            $data['facility_available'] = '1';
        }

        $sql = "UPDATE " . DB_PREFIX . "facility 
        SET name = '" . $this->db->escape($data['facility_name']) . "',
        available = '" . (int)$data['facility_available'] . "',
        status = '" . (int)$data['facility_status'] . "',
        modified_by = '" . (int)$this->user->getId() . "',
        date_modified = NOW()
        WHERE facility_id = '" . (int)$facility_id . "'";
        $this->db->query($sql);

        if ($data['facility_available'] == 1) {
            $data['facility_availabilities'] = [];
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "facility_availability WHERE facility_id = '" . (int)$facility_id . "'");

        if (!empty($data['facility_availabilities']) && $data['facility_available'] == 0) {
            foreach ($data['facility_availabilities'] as $detail) {
                if(!empty($detail['check_day'])){
                    foreach($detail['times'] as $time){
                        $sql = "INSERT INTO " . DB_PREFIX . "facility_availability
                        SET facility_id = '" . (int)$facility_id . "',
                        day = '" . $this->db->escape($detail['clinical_day']) . "',
                        start_time = '" . $this->db->escape($time['start_time']) . "',
                        end_time = '" . $this->db->escape($time['end_time']) . "' 
                        ";
                    $this->db->query($sql);
                    }
                }
                
                
            }
        }
    }

    public function deleteFacility($facility_id)
    {
        $this->db->query("DELETE FROM " . DB_PREFIX . "facility WHERE facility_id = '" . (int)$facility_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "facility_availability WHERE facility_id = '" . (int)$facility_id . "'");
    }

    // public function getFacility($facility_id) {
    //     $query = $this->db->query("SELECT * FROM oc_facility   WHERE facility_id = '" . (int) $facility_id . "'");

    //     return $query->row;
    // }

    public function getFacilityAvailability($facility_id,$day) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "facility_availability WHERE facility_id = '" . (int) $facility_id . "' AND day = '" . $this->db->escape($day) . "' ");

        return $query->rows;
    }

    public function getAvailabilityService($availability_id){
        $query = $this->db->query("SELECT service_id FROM oc_availability_to_service WHERE availability_id = '" . $availability_id . "'");

        return $query->rows;
    }

    public function getFacilityhour($facility_id){
        $sql="SELECT * FROM oc_facility_availability WHERE facility_id = '".(int)$facility_id."'";

        $query = $this->db->query($sql);
        return $query->rows;
    }
}
