<?php

class ModelExtensionModuleShippingTemplate extends Model
{
	private $default_table = 'shipping_template';

	public function __construct($registry)
	{
		parent::__construct($registry);

		$this->default_table = DB_PREFIX . $this->default_table;
	}

	public function get_shipping_template($template_id = 0)
    {
        if (empty($template_id)) {return [];}

        return $this->db->query("SELECT * FROM `{$this->default_table}` WHERE shipping_template_id = " . (int)$template_id)->row;
    }

    public function get_shipping_list_name()
    {
        return $this->db->query("SELECT shipping_template_id, name FROM `{$this->default_table}`")->rows;
    }

	public function get_template_list()
    {
        return $this->db->query("SELECT * FROM `{$this->default_table}`")->rows;
    }

    public function get_total_template_list()
    {
        return $this->db->query("SELECT COUNT(*) AS total FROM `{$this->default_table}`")->row['total'];
    }

    public function get_tracking_shipment_carrier_info($carrier_id = 0)
    {
        if (empty($carrier_id)) {
            return [];
        }

        return $this->db->query("SELECT * FROM `" . DB_PREFIX . "carriers` WHERE carrier_id = " . (int)$carrier_id)->row;
    }

    public function update_shipping_template($template_id = 0, $data = [])
    {
        if (empty($template_id) || empty($data)) {
            return false;
        }

        $sql = "UPDATE `{$this->default_table}` 
                SET name = '" . $this->db->escape($data['input_name']) . "',
                    image = '" . $this->db->escape($data['input_image']) . "',
                    account_no = '" . $this->db->escape($data['input_account_no']) . "',
                    width = '" . $data['input_width'] . "',
                    height = '" . $data['input_height'] . "',
                    format = '" . $this->db->escape($data['input_format']) . "',
                    order_status_id = '" . (int)$data['input_order_status_id'] . "',
                    comment = '" . $this->db->escape($data['input_comment']) . "',        
                    tracking_url = '" . $this->db->escape($data['input_tracking_url']) . "', 
                    status = '" . (int)$data['input_status'] . "',
                    date_modified = NOW(),
                    modified_by = '" . (int)$this->session->data['user_id'] . "'
                WHERE shipping_template_id = " . (int)$template_id;

        $this->db->query($sql);
    }

    public function delete_shipping_template($template_id = null)
    {
        if (empty($template_id)) {return false;}

        $sql = "DELETE FROM `{$this->default_table}` WHERE shipping_template_id ";

        if (is_array($template_id)) {
            $sql .= "IN (" . implode(',', $template_id) . ")";
        } else {
            $sql .= "= " . (int)$template_id;
        }

        $this->db->query($sql);
    }

	public function post_new_shipping_template($data = [])
	{
		if (empty($data)) {return false;}

		$sql = "INSERT INTO `" . $this->default_table ."` VALUES (
					DEFAULT,
					'" . $this->db->escape($data['input_name']) . "',
					'" . $this->db->escape($data['input_image']) . "',
					'" . $this->db->escape($data['input_account_no']) . "',
					'" . $data['input_width'] . "',
					'" . $data['input_height'] . "',
					'" . $this->db->escape($data['input_format']) . "',
					'" . (int)$data['input_order_status_id'] . "',
					'" . $this->db->escape($data['input_comment']) . "',
					'" . $this->db->escape($data['input_tracking_url']) . "',
					'" . (int)$data['input_status'] . "',
					NOW(),
					'" . (int)$this->session->data['user_id'] . "',
					NOW(),
					'" . (int)$this->session->data['user_id'] . "'
				)";

		$this->db->query($sql);
	}

	public function drop_existing_table()
	{
		$this->db->query("DROP TABLE IF EXISTS `" . $this->default_table . "`");
	}

	public function get_table_exist()
	{
		$sql = "SELECT COUNT(*) AS total
				FROM information_schema.TABLES
				WHERE TABLE_SCHEMA = '" . DB_DATABASE . "'
				AND TABLE_NAME = '" . $this->default_table . "'";

		return $this->db->query($sql)->row;
	}

	public function post_new_table()
	{
		$sql = "CREATE TABLE `" . $this->default_table . "` (
					`shipping_template_id` int(11) NOT NULL AUTO_INCREMENT,
					`name` varchar(255) NOT NULL,
					`image` text NOT NULL,
					`account_no` varchar(255) NOT NULL,
					`width` decimal(10, 5) NOT NULL,
					`height` decimal(10, 5) NOT NULL,
					`format` text,
					`order_status_id` int(11) NOT NULL,
					`comment` text NOT NULL,
					`tracking_url` text NOT NULL,
					`status` int(11) NOT NULL,
					`date_added` datetime NOT NULL,
					`added_by` int(11) NOT NULL,
					`date_modified` datetime NOT NULL,
					`modified_by` int(11) NOT NULL,
					PRIMARY KEY (`shipping_template_id`)
				) ENGINE=MYISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";
		$this->db->query($sql);
	}

	public function check_column_exist()
    {
        $sql = "SELECT * 
                FROM information_schema.COLUMNS
                WHERE TABLE_SCHEMA = '". DB_DATABASE . "'
                AND TABLE_NAME = '" . DB_PREFIX . "order_history'
                AND COLUMN_NAME = 'shipping_template_id'";

        return $this->db->query($sql)->num_rows;
    }

    public function post_new_columns()
    {
        $this->db->query("ALTER TABLE `" . DB_PREFIX . "order_history` ADD COLUMN `shipping_template_id` int(11) NOT NULL after `comment`;");
        $this->db->query("ALTER TABLE `" . DB_PREFIX . "order_history` ADD COLUMN `tracking_number` varchar(255) charset utf8 collate utf8_general_ci default '' NOT NULL after `comment`");
        $this->db->query("ALTER TABLE `" . DB_PREFIX . "order_history` ADD COLUMN `shipment_info` text CHARACTER SET utf8 COLLATE utf8_general_ci default '' NOT NULL after `comment`");

        $this->db->query("ALTER TABLE `" . DB_PREFIX . "order` ADD COLUMN `shipping_template_id` int(11) NOT NULL after `comment`;");
        $this->db->query("ALTER TABLE `" . DB_PREFIX . "order` ADD COLUMN `tracking_number` varchar(255) charset utf8 collate utf8_general_ci default '' NOT NULL after `comment`");
        $this->db->query("ALTER TABLE `" . DB_PREFIX . "order` ADD COLUMN `shipment_info` text CHARACTER SET utf8 COLLATE utf8_general_ci default '' NOT NULL after `comment`");
    }

    // for banhuat only
    public function get_ckeditor_installed()
    {
        return $this->db->query("SELECT modification_id, name, code FROM `" . DB_PREFIX . "modification` WHERE code = 'ckeditortwoplus'")->row;
    }
}

?>