<?php

class ModelCustomerCustomer extends Model {
    //alia edit
    //     public function addHerbal($data)
    //     {
    //         $this->load->model('setting/setting');
    //         $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/waiting', 'store' => $this->session->data['store_id']));
    //         // $consultation_price = ($data['enable_doctorprice'] == '1') ? $data['doctor_price'] : '0';
    //         // $consultation_price =  $data['doctor_price'];


    //         $this->db->query("
    // 			INSERT INTO " . DB_PREFIX . "etcm_customer_to_queue SET
    //                 doc_no ='" . $this->db->escape($invoice_prefix) . "',
    //                 store_id = '" . (int) $this->session->data['store_id'] . "',
    //                 customer_id = '" . (int) $data['customer_id'] . "',
    //                 clinicale_sale_id = '" . (int) $data['clinicale_sale_id'] . "',
    //                 doctor_id = '" . (int) $data['doctor_id'] . "',
    // 				status = '" . (int) $data['status'] . "',
    //                 remark = '" . $this->db->escape($data['remark']) . "',
    // 				added_by = '" . (int) $this->session->data['user_id'] . "',
    // 				date_added = NOW(),
    // 				modified_by = '" . (int) $this->session->data['user_id'] . "',
    // 				date_modified = NOW()
    // 		");

    //         $clinical_sale_id = $this->db->getLastId();

    //         if ($clinical_sale_id != 0) {
    //             $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'herbal/waiting', 'store' => $this->session->data['store_id']));
    //         }
    //         return $clinical_sale_id;
    //     }

    public function addHerbal($data) {
        $this->load->model('setting/setting');
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));
        // $consultation_price = ($data['enable_doctorprice'] == '1') ? $data['doctor_price'] : '0';
        // $consultation_price =  $data['doctor_price'];


        $this->db->query("
			INSERT INTO " . DB_PREFIX . "clinical_sale SET
				customer_id = '" . (int) $data['customer_id'] . "',
				doctor_id = '" . (int) $data['doctor_id'] . "',
				invoice_prefix ='" . $this->db->escape($invoice_prefix) . "',
                saved = '1',
				sales_date = Now(),
				store_id = '" . (int) $this->session->data['store_id'] . "',
				clinicalsale_action = '" . (int) 1 . "',
                clinicalsale_concultation = '" . (float) $data['consultationprice'] . "',
				collect_consultation_price = '" . (int) $data['enable_consultation_price'] . "',
				order_action = '" . (int) 17 . "',
				add_by = '" . (int) $this->session->data['user_id'] . "',
				date_added = NOW(),
				modifi_by = '" . (int) $this->session->data['user_id'] . "',
				date_modified = NOW()
		");

        $clinical_sale_id = $this->db->getLastId();

        if ($clinical_sale_id != 0) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));
        }
        return $clinical_sale_id;
    }

    //woo modify
    public function getHerbalbyCustomerId($customer_id, $start = 0, $limit = 10) {
        if ($start < 0) {
            $start = 0;
        }
        if ($limit < 1) {
            $limit = 10;
        }

        $sql = "SELECT *,os.name AS name,os1.name AS name1 FROM " . DB_PREFIX . "clinical_sale cs 
        LEFT JOIN " . DB_PREFIX . "order_status os ON (cs.clinicalsale_action = os.order_status_id)
        LEFT JOIN " . DB_PREFIX . "order_status os1 ON (cs.order_action = os1.order_status_id) WHERE       
        os.language_id = '" . (int) $this->config->get('config_language_id') . "' AND os1.language_id = '" . (int) $this->config->get('config_language_id') . "'AND customer_id = '" . (int) $customer_id . "' ORDER BY date_added DESC LIMIT " . (int)$start . "," . (int)$limit;
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTotalMedicalHistory($customer_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "clinical_sale WHERE hide !=1 AND customer_id = '" . (int) $customer_id . "'");

        return $query->row['total'];
    }


    public function getAppointmentsbyCustomerId($customer_id, $start = 0, $limit = 10) {
        if ($start < 0) {
            $start = 0;
        }
        if ($limit < 1) {
            $limit = 10;
        }

        $sql = "SELECT * FROM " . DB_PREFIX . "appointment a 
        LEFT JOIN " . DB_PREFIX . "clinical_service_description csd on (a.clinicalservice_id = csd.clinicalservice_id)
        LEFT JOIN " . DB_PREFIX . "user u on (u.user_id = a.created_by)
        WHERE csd.language_id = '" . (int) $this->config->get('config_language_id') . "' AND customer_id = '" . (int) $customer_id . "' ORDER BY created_date DESC LIMIT " . (int)$start . "," . (int)$limit;
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTotalAppointment($customer_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "appointment WHERE clinicalservice_id !=0 AND customer_id = '" . (int) $customer_id . "'");

        return $query->row['total'];
    }

    public function getServiceItem($customer_id, $start = 0, $limit = 10) {
        if ($start < 0) {
            $start = 0;
        }
        if ($limit < 1) {
            $limit = 10;
        }

        $sql = "SELECT *,os1.name AS name1 ,serviceform_action, CONCAT(u.firstname, ' ', u.lastname) AS doctor_name FROM " . DB_PREFIX . "service_item si 
        LEFT JOIN " . DB_PREFIX . "service_form sf on (si.service_form_id = sf.service_form_id)
        LEFT JOIN " . DB_PREFIX . "order_status os ON (sf.serviceform_action = os.order_status_id) 
        LEFT JOIN " . DB_PREFIX . "order_status os1 ON (sf.order_action = os1.order_status_id) 
        LEFT JOIN " . DB_PREFIX . "user u on (u.user_id = si.user_id)
        WHERE os.language_id = '" . (int) $this->config->get('config_language_id') . "' AND os1.language_id = '" . (int) $this->config->get('config_language_id') . "' AND customer_id = '" . (int) $customer_id . "' ORDER BY si.date_modified DESC LIMIT " . (int)$start . "," . (int)$limit;
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTotalServiceItem($customer_id) {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "service_item si 
        LEFT JOIN " . DB_PREFIX . "service_form sf on (si.service_form_id = sf.service_form_id)
        LEFT JOIN " . DB_PREFIX . "order_status os ON (sf.serviceform_action = os.order_status_id) 
        LEFT JOIN " . DB_PREFIX . "order_status os1 ON (sf.order_action = os1.order_status_id) 
        LEFT JOIN " . DB_PREFIX . "user u on (u.user_id = si.user_id)
        WHERE os.language_id = '" . (int) $this->config->get('config_language_id') . "' AND os1.language_id = '" . (int) $this->config->get('config_language_id') . "' AND customer_id = '" . (int) $customer_id . "' ORDER BY si.date_modified DESC";
        $query = $this->db->query($sql);
        return $query->row['total'];
    }

    // public function getTotalServiceItem($service_form_id)
    // {
    //     $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "service_item WHERE service_form_id = '" . (int) $service_form_id . "'");

    //     return $query->row['total'];
    // }

    public function tickToTop($customer_id, $top) {
        $sql = "
			UPDATE `oc_customer`
			SET
				top = '" . (int) $top . "'
			WHERE 1 
				AND customer_id = '" . (int) $customer_id . "'";
        $query = $this->db->query($sql);
    }

    public function customerStatus($customer_id, $status) {
        $sql = "
			UPDATE `oc_customer`
			SET
				status = '" . (int) $status . "'
			WHERE 1 
				AND customer_id = '" . (int) $customer_id . "'";
        $query = $this->db->query($sql);
        return $this->db->countAffected();
    }

    public function updateCustomerStatus($customer_id) {
        $sql = "
			UPDATE `oc_customer`
			SET
				status = '0'
			WHERE 1 
				AND customer_id = '" . (int) $customer_id . "'";
        $query = $this->db->query($sql);
        return $this->db->countAffected();
    }

    public function updateOrderCustomerId($old_customer_id, $new_customer_id) {
        $sql = "
			UPDATE `oc_order`
			SET
				customer_id = '" . (int) $new_customer_id . "'
			WHERE customer_id = '" . (int) $old_customer_id . "'";
        $query = $this->db->query($sql);
        return $this->db->countAffected();
    }

    public function updateServiceCustomerId($old_customer_id, $new_customer_id) {
        $sql = "
			UPDATE `oc_service_form`
			SET
				customer_id = '" . (int) $new_customer_id . "'
			WHERE customer_id = '" . (int) $old_customer_id . "'";
        $query = $this->db->query($sql);
        return $this->db->countAffected();
    }

    public function updateClinicalCustomerId($old_customer_id, $new_customer_id) {
        $sql = "
			UPDATE `oc_clinical_sale`
			SET
				customer_id = '" . (int) $new_customer_id . "'
			WHERE customer_id = '" . (int) $old_customer_id . "'";
        $query = $this->db->query($sql);
        return $this->db->countAffected();
    }


    public function updateAppointmentCustomerId($old_customer_id, $new_customer_id) {
        $sql = "
			UPDATE `oc_appointment`
			SET customer_id = '" . (int) $new_customer_id . "'
			WHERE customer_id = '" . (int) $old_customer_id . "'";
        $query = $this->db->query($sql);
        return $this->db->countAffected();
    }


    public function updateAddressCustomerId($old_customer_id, $new_customer_id) {
        $sql = "
			UPDATE `oc_address`
			SET customer_id = '" . (int) $new_customer_id . "'
			WHERE customer_id = '" . (int) $old_customer_id . "'";
        $query = $this->db->query($sql);
        return $this->db->countAffected();
    }

    public function getServiceformbyCustomerId($customer_id, $start = 0, $limit = 10) {
        if ($start < 0) {
            $start = 0;
        }
        if ($limit < 1) {
            $limit = 10;
        }

        $sql = "SELECT  sf.service_form_id, 
						sf.invoice_prefix, 
					  	sf.service_date,
                        sf.serviceform_action,
					 	sf.order_action As name1,
                        sf.total_price,
                        sf.date_added,
                        sf.add_by,
                        sf.order_action,
						c.customer_ic,
						c.customer_card,
                        os.name AS name,
                        os1.name AS name1
					  
					  FROM " . DB_PREFIX . "service_form sf LEFT JOIN " . DB_PREFIX . "customer c ON sf.customer_id = c.customer_id
                      LEFT JOIN " . DB_PREFIX . "order_status os ON (sf.serviceform_action = os.order_status_id) 
                      LEFT JOIN " . DB_PREFIX . "order_status os1 ON (sf.order_action = os1.order_status_id) WHERE
                      os.language_id = '" . (int) $this->config->get('config_language_id') . "' AND os1.language_id = '" . (int) $this->config->get('config_language_id') . "' AND sf.customer_id = '" . (int) $customer_id . "' ORDER BY date_added DESC LIMIT " . (int)$start . "," . (int)$limit;

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTotalServiceForm($customer_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "service_form WHERE customer_id = '" . (int) $customer_id . "'");

        return $query->row['total'];
    }


    public function getSaleOrderbyCustomerId($customer_id, $start = 0, $limit = 10) {
        if ($start < 0) {
            $start = 0;
        }
        if ($limit < 1) {
            $limit = 10;
        }

        $sql = "SELECT o.order_id, CONCAT(o.firstname, ' ', o.lastname) AS customer, (SELECT os.name  FROM " . DB_PREFIX . "order_status os WHERE os.order_status_id = o.order_status_id AND os.language_id = '" . (int) $this->config->get('config_language_id') . "') AS status, o.total, o.currency_code, o.currency_value, o.date_added,o.invoice_prefix,o.order_status_id,o.invoice_date,o.store_name,o.payment_method,o.comment,o.add_by FROM `" . DB_PREFIX . "order` o LEFT JOIN " . DB_PREFIX . "customer c ON o.customer_id = c.customer_id WHERE 1  AND o.customer_id = '" . (int) $customer_id . "'ORDER BY date_added DESC LIMIT " . (int)$start . "," . (int)$limit;

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTotalCustomerSales($customer_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "order WHERE customer_id = '" . (int) $customer_id . "'");

        return $query->row['total'];
    }

    //mlax wong modify
    public function addCustomer($data) {
        do {
            $insert_customer = false;
            $unique_id = md5(rand() . $data['customer_ic'] . time());
            $customer_row = $this->check_unique_id($unique_id);

            $customer_card_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'customer/customer', 'store' => $this->session->data['store_id']));

            if (empty($data['customer_card'])) {
                $customer_card = $customer_card_no;
                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/customer', 'store' => $this->session->data['store_id']));
            } else {
                $customer_card = $data['customer_card'];
            }

            if (empty($customer_row)) {
                $insert_customer = true;
                $this->db->query("
					INSERT INTO " . DB_PREFIX . "customer SET
						unique_customer_id = '" . $this->db->escape($unique_id) . "',
						customer_group_id = '" . (int) $data['customer_group_id'] . "',
						firstname = '" . $this->db->escape($data['firstname']) . "',
						lastname = '" . $this->db->escape($data['lastname']) . "',
						gender = '" . $this->db->escape($data['gender']) . "',
						customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
						customer_card = '" . $this->db->escape($customer_card) . "',
						dob = '" . $this->db->escape($data['dob']) . "',
                        nationality = '" . $this->db->escape($data['nationality']) . "',
                        marital_status = '" . (int) $data['marital_status'] . "',
                        religion = '" . $this->db->escape($data['religion']) . "',
                        race = '" . $this->db->escape($data['race']) . "',
                        allergic = '" . $this->db->escape($data['allergic']) . "',
                        diagnostic_history = '" . $this->db->escape($data['diagnostic_history']) . "',
                        occupation = '" . $this->db->escape($data['occupation']) . "',
						email = '" . $this->db->escape($data['email']) . "',
						telephone = '" . $this->db->escape($data['telephone']) . "',
						telephone2 = '" . $this->db->escape($data['telephone2']) . "',
						home = '" . $this->db->escape($data['home']) . "',
						fax = '" . $this->db->escape($data['fax']) . "',
						custom_field = '" . $this->db->escape(isset($data['custom_field']) ? serialize($data['custom_field']) : '') . "',
						newsletter = '" . (int) $data['newsletter'] . "',
						salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "',
							password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "',
						status = '" . (int) $data['status'] . "',
						approved = '" . (int) $data['approved'] . "',
						safe = '" . (int) $data['safe'] . "',
                        add_by = '" . (int) $this->session->data['user_id'] . "',
						date_added = NOW(),
                        date_modified = NOW()
				");
            }
        } while ($insert_customer == false);

        $customer_id = $this->db->getLastId();

        if ($customer_id != 0) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'customer/customer', 'store' => $this->session->data['store_id']));
        }

        if (isset($data['address'])) {
            foreach ($data['address'] as $address) {
                $this->db->query("
				INSERT INTO " . DB_PREFIX . "address SET
				customer_id = '" . (int) $customer_id . "',
				firstname = '" . $this->db->escape($address['firstname']) . "',
				lastname = '" . $this->db->escape($address['lastname']) . "',
				company = '" . $this->db->escape($address['company']) . "',
				address_1 = '" . $this->db->escape($address['address_1']) . "',
				address_2 = '" . $this->db->escape($address['address_2']) . "',
				address_3 = '" . $this->db->escape($address['address_3']) . "',
				city = '" . $this->db->escape($address['city']) . "',
				postcode = '" . $this->db->escape($address['postcode']) . "',
				country_id = '" . (int) $address['country_id'] . "',
				zone_id = '" . (int) $address['zone_id'] . "',
				custom_field = '" . $this->db->escape(isset($address['custom_field']) ? serialize($address['custom_field']) : '') . "'");

                if (isset($address['default'])) {
                    $address_id = $this->db->getLastId();

                    $this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int) $address_id . "' WHERE customer_id = '" . (int) $customer_id . "'");
                }
            }
        }

        if ($data['affiliate']) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "customer_affiliate SET customer_id = '" . (int) $customer_id . "', company = '" . $this->db->escape($data['company']) . "', website = '" . $this->db->escape($data['website']) . "', tracking = '" . $this->db->escape($data['tracking']) . "', commission = '" . (float) $data['commission'] . "', tax = '" . $this->db->escape($data['tax']) . "', payment = '" . $this->db->escape($data['payment']) . "', cheque = '" . $this->db->escape($data['cheque']) . "', paypal = '" . $this->db->escape($data['paypal']) . "', bank_name = '" . $this->db->escape($data['bank_name']) . "', bank_branch_number = '" . $this->db->escape($data['bank_branch_number']) . "', bank_swift_code = '" . $this->db->escape($data['bank_swift_code']) . "', bank_account_name = '" . $this->db->escape($data['bank_account_name']) . "', bank_account_number = '" . $this->db->escape($data['bank_account_number']) . "', custom_field = '" . $this->db->escape(isset($data['custom_field']) ? json_encode($data['custom_field']) : json_encode(array())) . "', status = '" . (int) $data['affiliate'] . "', date_added = NOW()");
        }

        return $customer_id;
    }

    public function addCustomerByImport($data) {
        do {
            $insert_customer = false;
            $unique_id = md5(rand() . $data['customer_ic'] . time());
            $customer_row = $this->check_unique_id($unique_id);

            if (empty($customer_row)) {
                $insert_customer = true;
                $this->db->query("
					INSERT INTO " . DB_PREFIX . "customer SET
                        customer_id = '" . (int) $data['customer_id'] . "',
						unique_customer_id = '" . $this->db->escape($unique_id) . "',
						customer_group_id = '" . (int) $data['customer_group_id'] . "',
						firstname = '" . $this->db->escape($data['firstname']) . "',
						lastname = '" . $this->db->escape($data['lastname']) . "',
						gender = '" . $this->db->escape($data['gender']) . "',
						customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
						customer_card = '" . $this->db->escape(isset($data['customer_card']) ? $data['customer_card'] : '') . "',
						dob = '" . $this->db->escape($data['dob']) . "',
						email = '" . $this->db->escape($data['email']) . "',
						telephone = '" . $this->db->escape($data['telephone']) . "',
						telephone2 = '" . $this->db->escape($data['telephone2']) . "',
						home = '" . $this->db->escape($data['home']) . "',
						fax = '" . $this->db->escape($data['fax']) . "',
                        marital_status = '" . $this->db->escape($data['marital_status']) . "',
                        nationality = '" . $this->db->escape($data['nationality']) . "',
                        religion = '" . $this->db->escape($data['religion']) . "',
                        race = '" . $this->db->escape($data['race']) . "',
                        allergic = '" . $this->db->escape($data['allergic']) . "',
                        diagnostic_history = '" . $this->db->escape($data['diagnostic_history']) . "',
                        occupation = '" . $this->db->escape($data['occupation']) . "',
                        address_id = '" . $this->db->escape($data['address_id']) . "',
						custom_field = '" . $this->db->escape(isset($data['custom_field']) ? serialize($data['custom_field']) : '') . "',
						newsletter = '" . (int) $data['newsletter'] . "',
						salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "',
						password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "',
						status = '" . (int) $data['status'] . "',
						approved = '" . (int) $data['approved'] . "',
						safe = '" . (int) $data['safe'] . "',
                        add_by = '" . (int) $this->session->data['user_id'] . "', 
						date_added = NOW()
				");
            }
        } while ($insert_customer == false);

        $customer_id = $this->db->getLastId();

        if (isset($data['address'])) {
            foreach ($data['address'] as $address) {
                $this->db->query("
				INSERT INTO " . DB_PREFIX . "address SET
				customer_id = '" . (int) $customer_id . "',
				firstname = '" . $this->db->escape($address['firstname']) . "',
				lastname = '" . $this->db->escape($address['lastname']) . "',
				company = '" . $this->db->escape($address['company']) . "',
				address_1 = '" . $this->db->escape($address['address_1']) . "',
				address_2 = '" . $this->db->escape($address['address_2']) . "',
				address_3 = '" . $this->db->escape($address['address_3']) . "',
				city = '" . $this->db->escape($address['city']) . "',
				postcode = '" . $this->db->escape($address['postcode']) . "',
				country_id = '" . (int) $address['country_id'] . "',
				zone_id = '" . (int) $address['zone_id'] . "',
				custom_field = '" . $this->db->escape(isset($address['custom_field']) ? serialize($address['custom_field']) : '') . "'");

                if (isset($address['default'])) {
                    $address_id = $this->db->getLastId();

                    $this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int) $address_id . "' WHERE customer_id = '" . (int) $customer_id . "'");
                }
            }
        }
        return $customer_id;
    }


    public function updateImportedCustomer($data, $customer_id) {
        $this->db->query("UPDATE " . DB_PREFIX . "customer SET 
			customer_ic = '" . $this->db->escape($data['customer_ic']) . "', 
            firstname = '" . $this->db->escape($data['firstname']) . "', 
			lastname = '" . $this->db->escape($data['lastname']) . "', 
			telephone = '" . $this->db->escape($data['telephone']) . "',              
            email = '" . $this->db->escape($data['email']) . "',  
            customer_card = '" . $this->db->escape($data['customer_card']) . "',  
            telephone2 = '" . $this->db->escape($data['telephone2']) . "',
            home = '" . $this->db->escape($data['home']) . "',
            gender = '" . $this->db->escape($data['gender']) . "',
            dob = '" . $this->db->escape($data['dob']) . "',
            marital_status = '" . $this->db->escape($data['marital_status']) . "',
            nationality = '" . $this->db->escape($data['nationality']) . "',
            religion = '" . $this->db->escape($data['religion']) . "',
            race = '" . $this->db->escape($data['race']) . "',
            allergic = '" . $this->db->escape($data['allergic']) . "',
            diagnostic_history = '" . $this->db->escape($data['diagnostic_history']) . "',
            occupation = '" . $this->db->escape($data['occupation']) . "',
            address_id = '" . $this->db->escape($data['address_id']) . "',
            custom_field = '" . $this->db->escape(isset($data['custom_field']) ? serialize($data['custom_field']) : '') . "',
            modify_by = '" . (int) $this->session->data['user_id'] . "', 
			date_modified = NOW() 
            WHERE customer_id = '" . (int) $customer_id . "'");

        $this->db->query("DELETE FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int) $customer_id . "'");


        if (isset($data['address'])) {
            foreach ($data['address'] as $address) {
                if (!isset($address['custom_field'])) {
                    $address['custom_field'] = array();
                }

                $this->db->query("
                    INSERT INTO " . DB_PREFIX . "address SET
                        address_id = '" . (int) $address['address_id'] . "',
                        customer_id = '" . (int) $customer_id . "',
                        firstname = '" . $this->db->escape($address['firstname']) . "',
                        lastname = '" . $this->db->escape($address['lastname']) . "',
                        company = '" . $this->db->escape($address['company']) . "',
                        address_1 = '" . $this->db->escape($address['address_1']) . "',
                        address_2 = '" . $this->db->escape($address['address_2']) . "',
                        address_3 = '" . $this->db->escape($address['address_3']) . "',
                        city = '" . $this->db->escape($address['city']) . "',
                        postcode = '" . $this->db->escape($address['postcode']) . "',
                        country_id = '" . (int) $address['country_id'] . "',
                        zone_id = '" . (int) $address['zone_id'] . "',
                        custom_field = '" . $this->db->escape(isset($address['custom_field']) ? serialize($address['custom_field']) : '') . "'");

                if (isset($address['default'])) {
                    $address_id = $this->db->getLastId();

                    $this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int) $address_id . "' WHERE customer_id = '" . (int) $customer_id . "'");
                }
            }
        }
    }

    //mlax wong modify
    public function editCustomer($customer_id, $data) {
        if (!isset($data['custom_field'])) {
            $data['custom_field'] = array();
        }



        $customer_card_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'customer/customer', 'store' => $this->session->data['store_id']));

        $customer_card = $data['customer_card'];

        if ($customer_card == $customer_card_no) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'customer/customer', 'store' => $this->session->data['store_id']));
        }

        $this->db->query("
		UPDATE " . DB_PREFIX . "customer SET
			customer_group_id = '" . (int) $data['customer_group_id'] . "',
			firstname = '" . $this->db->escape($data['firstname']) . "',
			lastname = '" . $this->db->escape($data['lastname']) . "',
			gender = '" . $this->db->escape($data['gender']) . "',
			customer_card = '" . $this->db->escape($customer_card) . "',
			customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
			dob = '" . $this->db->escape($data['dob']) . "',
            nationality= '" . $this->db->escape($data['nationality']) . "',
            marital_status = '" . $this->db->escape($data['marital_status']) . "',
            religion = '" . $this->db->escape($data['religion']) . "',
            race ='" . $this->db->escape($data['race']) . "',
            allergic = '" . $this->db->escape($data['allergic']) . "',
            diagnostic_history = '" . $this->db->escape($data['diagnostic_history']) . "',
            occupation = '" . $this->db->escape($data['occupation']) . "',
			email = '" . $this->db->escape($data['email']) . "',
			telephone = '" . $this->db->escape($data['telephone']) . "',
			telephone2 = '" . $this->db->escape($data['telephone2']) . "',
			fax = '" . $this->db->escape($data['fax']) . "',
			home = '" . $this->db->escape($data['home']) . "',
			custom_field = '" . $this->db->escape(isset($data['custom_field']) ? serialize($data['custom_field']) : '') . "',
			newsletter = '" . (int) $data['newsletter'] . "',
			status = '" . (int) $data['status'] . "',
			approved = '" . (int) $data['approved'] . "',
			safe = '" . (int) $data['safe'] . "',
            modify_by = '" . (int) $this->session->data['user_id'] . "',
            date_modified = NOW()
		WHERE customer_id = '" . (int) $customer_id . "'");




        if ($data['password']) {
            $this->db->query("UPDATE " . DB_PREFIX . "customer SET salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "' WHERE customer_id = '" . (int) $customer_id . "'");
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int) $customer_id . "'");

        if (isset($data['address'])) {
            foreach ($data['address'] as $address) {
                if (!isset($address['custom_field'])) {
                    $address['custom_field'] = array();
                }

                $this->db->query("
				INSERT INTO " . DB_PREFIX . "address SET
					address_id = '" . (int) $address['address_id'] . "',
					customer_id = '" . (int) $customer_id . "',
					firstname = '" . $this->db->escape($address['firstname']) . "',
					lastname = '" . $this->db->escape($address['lastname']) . "',
					company = '" . $this->db->escape($address['company']) . "',
					address_1 = '" . $this->db->escape($address['address_1']) . "',
					address_2 = '" . $this->db->escape($address['address_2']) . "',
					address_3 = '" . $this->db->escape($address['address_3']) . "',
					city = '" . $this->db->escape($address['city']) . "',
					postcode = '" . $this->db->escape($address['postcode']) . "',
					country_id = '" . (int) $address['country_id'] . "',
					zone_id = '" . (int) $address['zone_id'] . "',
					custom_field = '" . $this->db->escape(isset($address['custom_field']) ? serialize($address['custom_field']) : '') . "'");

                if (isset($address['default'])) {
                    $address_id = $this->db->getLastId();

                    $this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int) $address_id . "' WHERE customer_id = '" . (int) $customer_id . "'");
                }
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "customer_affiliate WHERE customer_id = '" . (int) $customer_id . "'");

        if ($data['affiliate']) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "customer_affiliate SET customer_id = '" . (int) $customer_id . "', company = '" . $this->db->escape($data['company']) . "', website = '" . $this->db->escape($data['website']) . "', tracking = '" . $this->db->escape($data['tracking']) . "', commission = '" . (float) $data['commission'] . "', tax = '" . $this->db->escape($data['tax']) . "', payment = '" . $this->db->escape($data['payment']) . "', cheque = '" . $this->db->escape($data['cheque']) . "', paypal = '" . $this->db->escape($data['paypal']) . "', bank_name = '" . $this->db->escape($data['bank_name']) . "', bank_branch_number = '" . $this->db->escape($data['bank_branch_number']) . "', bank_swift_code = '" . $this->db->escape($data['bank_swift_code']) . "', bank_account_name = '" . $this->db->escape($data['bank_account_name']) . "', bank_account_number = '" . $this->db->escape($data['bank_account_number']) . "', status = '" . (int) $data['affiliate'] . "', date_added = NOW()");
        }

        // echo '<pre>';
        // print_r($this->db->query);
        // echo '</pre>';

    }

    public function editToken($customer_id, $token) {
        $this->db->query("UPDATE " . DB_PREFIX . "customer SET token = '" . $this->db->escape($token) . "' WHERE customer_id = '" . (int) $customer_id . "'");
    }

    public function deleteCustomer($customer_id) {
        $this->db->query("DELETE FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int) $customer_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "customer_reward WHERE customer_id = '" . (int) $customer_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "customer_affiliate WHERE customer_id = '" . (int) $customer_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "customer_transaction WHERE customer_id = '" . (int) $customer_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "customer_ip WHERE customer_id = '" . (int) $customer_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int) $customer_id . "'");
    }

    public function getCustomer($customer_id) {
        $query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int) $customer_id . "'");

        return $query->row;
    }

    public function getCustomerByEmail($email) {
        $query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer WHERE LCASE(email) = '" . $this->db->escape(utf8_strtolower($email)) . "'");

        return $query->row;
    }

    public function getCustomers($data = array()) {
        $sql = "SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name, cgd.name AS customer_group FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (c.customer_group_id = cgd.customer_group_id) WHERE cgd.language_id = '" . (int) $this->config->get('config_language_id') . "'";

        if (!empty($data['filter_affiliate'])) {
            $sql .= " LEFT JOIN " . DB_PREFIX . "customer_affiliate ca ON (c.customer_id = ca.customer_id)";
        }


        $implode = array();



        if (!empty($data['filter_name'])) {
            $implode[] = "CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (!empty($data['filter_customer_search'])) {
            $implode[] = "CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_search']) . "%'";
        }

        if (!empty($data['filter_email'])) {
            $implode[] = " c.email LIKE '" . $this->db->escape($data['filter_email']) . "%'";
        }

        if (!empty($data['filter_telephone'])) {
            $implode[] = "c.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if (!empty($data['exactly_ic'])) {
            $implode[] = "c.customer_ic = '" . $this->db->escape($data['exactly_ic']) . "'";
        } elseif (!empty($data['filter_ic'])) {
            $implode[] = "c.customer_ic LIKE '" . $this->db->escape($data['filter_ic']) . "%'";
        }

        if (!empty($data['filter_card'])) {
            $implode[] = "c.customer_card LIKE '" . $this->db->escape($data['filter_card']) . "%'";
        }


        if (isset($data['filter_newsletter']) && !is_null($data['filter_newsletter'])) {
            $implode[] = "c.newsletter = '" . (int) $data['filter_newsletter'] . "'";
        }

        if (!empty($data['filter_affiliate'])) {
            $implode[] = "ca.status = '" . (int) $data['filter_affiliate'] . "'";
        }

        // if (!empty($data['filter_add_by'])) {
        //     $implode[] = "c.add_by = '" . (int) $data['filter_add_by'] . "'";
        // }

        if (!empty($data['filter_age_from']) && !empty($data['filter_age_to'])) {
            $implode[] = "TIMESTAMPDIFF(YEAR, c.dob , curdate()) BETWEEN '" . (int) $data['filter_age_from'] . "' AND '" . (int) $data['filter_age_to'] . "'";
        } elseif (empty($data['filter_age_from']) && !empty($data['filter_age_to'])) {
            $implode[] = "TIMESTAMPDIFF(YEAR, c.dob , curdate()) <= '" . (int) $data['filter_age_to'] . "'";
        } elseif (!empty($data['filter_age_from']) && empty($data['filter_age_to'])) {
            $implode[] = "TIMESTAMPDIFF(YEAR, c.dob , curdate()) >= '" . (int) $data['filter_age_from'] . "'";
        }



        if (!empty($data['filter_customer_group'])) {
            $implode[] = "c.customer_group_id = '" . (int) $data['filter_customer_group'] . "'";
        }


        if (!empty($data['filter_store_id'])) {
            $implode[] = "c.store_id = '" . (int) $data['filter_store_id'] . "'";
        }



        // if ($data['filter_gender'] != '') {
        //     $implode[] = "c.gender in (" . (int) $data['filter_gender'] . "'";
        //     $sql .= "AND c.gender in (" . $data['filter_gender'] . ")";
        // }else{
        //     $sql.= "";
        // }


        // if ($data['filter_status'] != '') {
        //     $sql .= "AND c.status in (" . $data['filter_status'] . ")";
        // }else{
        //     $sql.= "";
        // }

        // if ($data['filter_approved'] != '') {
        //     $sql .= "AND c.approved in (" . $data['filter_approved'] . ")";
        // }else{
        //     $sql.= "";
        // }
        if (isset($data['filter_gender'])) {
            if ($data['filter_gender'] != '') {
                $sql .= " AND c.gender in (" . $data['filter_gender'] . ")";
            } else {
                $sql .= '';
            }
        }

        if (isset($data['filter_status'])) {
            if ($data['filter_status'] != '') {
                $sql .= " AND c.status in (" . $data['filter_status'] . ")";
            } else {
                $sql .= '';
            }
        }
        if (isset($data['filter_approved'])) {
            if ($data['filter_approved'] != '') {
                $sql .= " AND c.approved in (" . $data['filter_approved'] . ")";
            } else {
                $sql .= '';
            }
        }

        if (!empty($data['filter_add_by'])) {
            $sql .= " AND c.add_by in (" . $data['filter_add_by'] . ")";
        } else {
            $sql .= "";
        }




        if (!empty($data['filter_date_added_from'])) {
            $sql .= " AND DATE(c.date_added) >= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        }

        if (!empty($data['filter_date_added_to'])) {
            $sql .= " AND DATE(c.date_added) <= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        }

        // if (!empty($data['filter_date_added_from'])) {
        //     $implode[] = "DATE(c.date_added)>= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        // }

        // if (!empty($data['filter_date_added_to'])) {
        //     $implode[] = "DATE(c.date_added)<= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        // }


        if ($implode) {
            $sql .= " AND " . implode(" AND ", $implode);
        }

        $sort_data = array(
            'name',
            'age',
            'c.email',
            'c.customer_ic',
            'c.status',
            'c.gender',
            'c.approved',
            'c.customer_card',
            'c.date_added',
            'c.telephone',
            'c.store_id',
            'c.add_by',
            'c.modify_by'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= "ORDER BY c.top DESC, " . $data['sort'];
        } else {
            $sql .= "ORDER BY c.top DESC, c.date_added";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCustomersAutocomplete($data = array()) {
        $sql = "SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name, cgd.name AS customer_group FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (c.customer_group_id = cgd.customer_group_id) WHERE c.status='1' AND cgd.language_id = '" . (int) $this->config->get('config_language_id') . "'";

        if (!empty($data['filter_affiliate'])) {
            $sql .= " LEFT JOIN " . DB_PREFIX . "customer_affiliate ca ON (c.customer_id = ca.customer_id)";
        }


        $implode = array();



        if (!empty($data['filter_name'])) {
            $implode[] = "CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (!empty($data['filter_customer_search'])) {
            $implode[] = "CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_search']) . "%'";
        }

        if (!empty($data['filter_email'])) {
            $implode[] = " c.email LIKE '" . $this->db->escape($data['filter_email']) . "%'";
        }

        if (!empty($data['filter_telephone'])) {
            $implode[] = "c.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if (!empty($data['exactly_ic'])) {
            $implode[] = "c.customer_ic = '" . $this->db->escape($data['exactly_ic']) . "'";
        } elseif (!empty($data['filter_ic'])) {
            $implode[] = "c.customer_ic LIKE '" . $this->db->escape($data['filter_ic']) . "%'";
        }

        if (!empty($data['filter_card'])) {
            $implode[] = "c.customer_card LIKE '" . $this->db->escape($data['filter_card']) . "%'";
        }


        if (isset($data['filter_newsletter']) && !is_null($data['filter_newsletter'])) {
            $implode[] = "c.newsletter = '" . (int) $data['filter_newsletter'] . "'";
        }

        if (!empty($data['filter_affiliate'])) {
            $implode[] = "ca.status = '" . (int) $data['filter_affiliate'] . "'";
        }

        // if (!empty($data['filter_add_by'])) {
        //     $implode[] = "c.add_by = '" . (int) $data['filter_add_by'] . "'";
        // }

        if (!empty($data['filter_age_from']) && !empty($data['filter_age_to'])) {
            $implode[] = "TIMESTAMPDIFF(YEAR, c.dob , curdate()) BETWEEN '" . (int) $data['filter_age_from'] . "' AND '" . (int) $data['filter_age_to'] . "'";
        } elseif (empty($data['filter_age_from']) && !empty($data['filter_age_to'])) {
            $implode[] = "TIMESTAMPDIFF(YEAR, c.dob , curdate()) <= '" . (int) $data['filter_age_to'] . "'";
        } elseif (!empty($data['filter_age_from']) && empty($data['filter_age_to'])) {
            $implode[] = "TIMESTAMPDIFF(YEAR, c.dob , curdate()) >= '" . (int) $data['filter_age_from'] . "'";
        }



        if (!empty($data['filter_customer_group'])) {
            $implode[] = "c.customer_group_id = '" . (int) $data['filter_customer_group'] . "'";
        }


        if (!empty($data['filter_store_id'])) {
            $implode[] = "c.store_id = '" . (int) $data['filter_store_id'] . "'";
        }



        // if ($data['filter_gender'] != '') {
        //     $implode[] = "c.gender in (" . (int) $data['filter_gender'] . "'";
        //     $sql .= "AND c.gender in (" . $data['filter_gender'] . ")";
        // }else{
        //     $sql.= "";
        // }


        // if ($data['filter_status'] != '') {
        //     $sql .= "AND c.status in (" . $data['filter_status'] . ")";
        // }else{
        //     $sql.= "";
        // }

        // if ($data['filter_approved'] != '') {
        //     $sql .= "AND c.approved in (" . $data['filter_approved'] . ")";
        // }else{
        //     $sql.= "";
        // }
        if (isset($data['filter_gender'])) {
            if ($data['filter_gender'] != '') {
                $sql .= " AND c.gender in (" . $data['filter_gender'] . ")";
            } else {
                $sql .= '';
            }
        }

        if (isset($data['filter_status'])) {
            if ($data['filter_status'] != '') {
                $sql .= " AND c.status in (" . $data['filter_status'] . ")";
            } else {
                $sql .= '';
            }
        }
        if (isset($data['filter_approved'])) {
            if ($data['filter_approved'] != '') {
                $sql .= " AND c.approved in (" . $data['filter_approved'] . ")";
            } else {
                $sql .= '';
            }
        }

        if (!empty($data['filter_add_by'])) {
            $sql .= " AND c.add_by in (" . $data['filter_add_by'] . ")";
        } else {
            $sql .= "";
        }




        if (!empty($data['filter_date_added_from'])) {
            $sql .= " AND DATE(c.date_added) >= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        }

        if (!empty($data['filter_date_added_to'])) {
            $sql .= " AND DATE(c.date_added) <= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        }

        // if (!empty($data['filter_date_added_from'])) {
        //     $implode[] = "DATE(c.date_added)>= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        // }

        // if (!empty($data['filter_date_added_to'])) {
        //     $implode[] = "DATE(c.date_added)<= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        // }


        if ($implode) {
            $sql .= " AND " . implode(" AND ", $implode);
        }

        $sort_data = array(
            'name',
            'age',
            'c.email',
            'c.customer_ic',
            'c.status',
            'c.gender',
            'c.approved',
            'c.customer_card',
            'c.date_added',
            'c.telephone',
            'c.store_id',
            'c.add_by',
            'c.modify_by'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= "ORDER BY c.top DESC, " . $data['sort'];
        } else {
            $sql .= "ORDER BY c.top DESC, c.date_added";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalCustomers($data = array()) {
        $sql = "SELECT COUNT(*) AS total  FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (c.customer_group_id = cgd.customer_group_id) WHERE cgd.language_id = '" . (int) $this->config->get('config_language_id') . "'";

        if (!empty($data['filter_affiliate'])) {
            $sql .= " LEFT JOIN " . DB_PREFIX . "customer_affiliate ca ON (c.customer_id = ca.customer_id)";
        }


        $implode = array();


        if (!empty($data['filter_name'])) {
            $implode[] = "CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (!empty($data['filter_email'])) {
            $implode[] = " c.email LIKE '" . $this->db->escape($data['filter_email']) . "%'";
        }

        if (!empty($data['filter_telephone'])) {
            $implode[] = "c.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if (!empty($data['exactly_ic'])) {
            $implode[] = "c.customer_ic = '" . $this->db->escape($data['exactly_ic']) . "'";
        } elseif (!empty($data['filter_ic'])) {
            $implode[] = "c.customer_ic LIKE '" . $this->db->escape($data['filter_ic']) . "%'";
        }

        if (!empty($data['filter_card'])) {
            $implode[] = "c.customer_card LIKE '" . $this->db->escape($data['filter_card']) . "%'";
        }


        if (isset($data['filter_newsletter']) && !is_null($data['filter_newsletter'])) {
            $implode[] = "c.newsletter = '" . (int) $data['filter_newsletter'] . "'";
        }

        if (!empty($data['filter_affiliate'])) {
            $implode[] = "ca.status = '" . (int) $data['filter_affiliate'] . "'";
        }

        // if (!empty($data['filter_add_by'])) {
        //     $implode[] = "c.add_by = '" . (int) $data['filter_add_by'] . "'";
        // }

        if (!empty($data['filter_age_from']) && !empty($data['filter_age_to'])) {
            $implode[] = "TIMESTAMPDIFF(YEAR, c.dob , curdate()) BETWEEN '" . (int) $data['filter_age_from'] . "' AND '" . (int) $data['filter_age_to'] . "'";
        } elseif (empty($data['filter_age_from']) && !empty($data['filter_age_to'])) {
            $implode[] = "TIMESTAMPDIFF(YEAR, c.dob , curdate()) <= '" . (int) $data['filter_age_to'] . "'";
        } elseif (!empty($data['filter_age_from']) && empty($data['filter_age_to'])) {
            $implode[] = "TIMESTAMPDIFF(YEAR, c.dob , curdate()) >= '" . (int) $data['filter_age_from'] . "'";
        }



        if (!empty($data['filter_customer_group'])) {
            $implode[] = "c.customer_group_id = '" . (int) $data['filter_customer_group'] . "'";
        }


        if (!empty($data['filter_store_id'])) {
            $implode[] = "c.store_id = '" . (int) $data['filter_store_id'] . "'";
        }


        // if (isset($data['filter_gender'])) {
        //     $sql .= " AND c.gender in (" . $data['filter_gender'] . ")";
        // } else {
        //     $sql.= "";
        // }

        if (isset($data['filter_gender'])) {
            if ($data['filter_gender'] != '') {
                $sql .= " AND c.gender in (" . $data['filter_gender'] . ")";
            } else {
                $sql .= '';
            }
        }


        if (isset($data['filter_status'])) {
            if ($data['filter_status'] != '') {
                $sql .= " AND c.status in (" . $data['filter_status'] . ")";
            } else {
                $sql .= '';
            }
        }


        if (isset($data['filter_approved'])) {
            if ($data['filter_approved'] != '') {
                $sql .= " AND c.approved in (" . $data['filter_approved'] . ")";
            } else {
                $sql .= '';
            }
        }


        if (!empty($data['filter_add_by'])) {
            $sql .= " AND c.add_by in (" . $data['filter_add_by'] . ")";
        } else {
            $sql .= "";
        }


        if (!empty($data['filter_date_added_from'])) {
            $sql .= " AND DATE(c.date_added) >= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        }

        if (!empty($data['filter_date_added_to'])) {
            $sql .= " AND DATE(c.date_added) <= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        }



        // if (!empty($data['filter_date_added_from'])) {
        //     $implode[] = "DATE(c.date_added)>= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        // }

        // if (!empty($data['filter_date_added_to'])) {
        //     $implode[] = "DATE(c.date_added)<= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        // }


        if ($implode) {
            $sql .= " AND " . implode(" AND ", $implode);
        }


        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getDoctors() {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user u
        LEFT JOIN " . DB_PREFIX . "user_description ud on (u.user_id = ud.user_id)
    
        WHERE u.position = 2 and u.status ='1' AND u.hide_user = 0  ORDER BY doctor_sort_order ASC,firstname,lastname ASC");



        return $query->rows;
    }

    public function getAffiliate($customer_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_affiliate WHERE customer_id = '" . (int) $customer_id . "'");

        return $query->row;
    }

    public function getCustomerId() {
        $query = $this->db->query("SELECT customer_id FROM " . DB_PREFIX . "customer WHERE 1");

        return $query->row;
    }

    public function getStaffs() {
        $query = $this->db->query("SELECT DISTINCT(c.add_by), CONCAT(u.firstname,' ',u.lastname) AS staff_name FROM " . DB_PREFIX . "customer c
		LEFT JOIN " . DB_PREFIX . "user u on (c.add_by = u.user_id)
        WHERE c.add_by !='0'
		ORDER BY staff_name asc");

        return $query->rows;
    }

    public function getAffliateByTracking($tracking) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_affiliate WHERE tracking = '" . $this->db->escape($tracking) . "'");

        return $query->row;
    }

    // public function getCustomerById($customer_id)
    // {
    //     $sql = "SELECT customer_id FROM " . DB_PREFIX . "customer WHERE customer_id = '$customer_id'";
    //     $query = $this->db->query($sql);
    //     return $query->row['customer_id'];
    // }

    public function getAffiliates($data = array()) {
        $sql = "SELECT DISTINCT *, CONCAT(c.firstname, ' ', c.lastname) AS name FROM " . DB_PREFIX . "customer_affiliate ca LEFT JOIN " . DB_PREFIX . "customer c ON (ca.customer_id = c.customer_id)";

        $implode = array();

        if (!empty($data['filter_name'])) {
            $implode[] = "CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if ($implode) {
            $sql .= " WHERE " . implode(" AND ", $implode);
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql . "ORDER BY name");

        return $query->rows;
    }

    public function getTotalAffiliates($data = array()) {
        $sql = "SELECT DISTINCT COUNT(*) AS total FROM " . DB_PREFIX . "customer_affiliate ca LEFT JOIN " . DB_PREFIX . "customer c ON (ca.customer_id = c.customer_id)";

        $implode = array();

        if (!empty($data['filter_name'])) {
            $implode[] = "CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if ($implode) {
            $sql .= " WHERE " . implode(" AND ", $implode);
        }

        return $sql->row['total'];
    }

    //mlax wong added
    public function getCustomerIdByIc($ic) {
        $sql = "SELECT customer_id FROM " . DB_PREFIX . "customer WHERE customer_ic = '$ic'";
        $query = $this->db->query($sql);
        return $query->row['customer_id'];
    }

    public function approve($customer_id) {
        $customer_info = $this->getCustomer($customer_id);

        if ($customer_info) {
            $this->db->query("UPDATE " . DB_PREFIX . "customer SET approved = '1' WHERE customer_id = '" . (int) $customer_id . "'");

            $this->load->language('mail/customer');

            $this->load->model('setting/store');

            $store_info = $this->model_setting_store->getStore($customer_info['store_id']);

            if ($store_info) {
                $store_name = $store_info['name'];
                $store_url = $store_info['url'] . 'index.php?route=account/login';
            } else {
                $store_name = $this->config->get('config_name');
                $store_url = HTTP_CATALOG . 'index.php?route=account/login';
            }

            $message = sprintf($this->language->get('text_approve_welcome'), $store_name) . "\n\n";
            $message .= $this->language->get('text_approve_login') . "\n";
            $message .= $store_url . "\n\n";
            $message .= $this->language->get('text_approve_services') . "\n\n";
            $message .= $this->language->get('text_approve_thanks') . "\n";
            $message .= $store_name;

            $mail = new Mail($this->config->get('config_mail_engine'));
            $mail->parameter = $this->config->get('config_mail_parameter');
            $mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
            $mail->smtp_username = $this->config->get('config_mail_smtp_username');
            $mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
            $mail->smtp_port = $this->config->get('config_mail_smtp_port');
            $mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

            $mail->setTo($customer_info['email']);
            $mail->setFrom($this->config->get('config_email'));
            $mail->setSender($store_name);
            $mail->setSubject(sprintf($this->language->get('text_approve_subject'), $store_name));
            $mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
            $mail->send();
        }
    }

    //mlax wong modify
    public function getAddress($address_id) {
        $address_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "address WHERE address_id = '" . (int) $address_id . "'");

        if ($address_query->num_rows) {
            $country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int) $address_query->row['country_id'] . "'");

            if ($country_query->num_rows) {
                $country = $country_query->row['name'];
                $iso_code_2 = $country_query->row['iso_code_2'];
                $iso_code_3 = $country_query->row['iso_code_3'];
                $address_format = $country_query->row['address_format'];
            } else {
                $country = '';
                $iso_code_2 = '';
                $iso_code_3 = '';
                $address_format = '';
            }

            $zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int) $address_query->row['zone_id'] . "'");

            if ($zone_query->num_rows) {
                $zone = $zone_query->row['name'];
                $zone_code = $zone_query->row['code'];
            } else {
                $zone = '';
                $zone_code = '';
            }

            return array(
                'address_id' => $address_query->row['address_id'],
                'customer_id' => $address_query->row['customer_id'],
                'firstname' => $address_query->row['firstname'],
                'lastname' => $address_query->row['lastname'],
                'company' => $address_query->row['company'],
                'address_1' => $address_query->row['address_1'],
                'address_2' => $address_query->row['address_2'],
                'address_3' => $address_query->row['address_3'],
                'postcode' => $address_query->row['postcode'],
                'city' => $address_query->row['city'],
                'zone_id' => $address_query->row['zone_id'],
                'zone' => $zone,
                'zone_code' => $zone_code,
                'country_id' => $address_query->row['country_id'],
                'country' => $country,
                'iso_code_2' => $iso_code_2,
                'iso_code_3' => $iso_code_3,
                'address_format' => $address_format,
                'custom_field' => unserialize($address_query->row['custom_field'])
            );
        }
    }

    public function getAddresses($customer_id) {
        $address_data = array();

        $query = $this->db->query("SELECT address_id FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int) $customer_id . "'");

        foreach ($query->rows as $result) {
            $address_info = $this->getAddress($result['address_id']);

            if ($address_info) {
                $address_data[$result['address_id']] = $address_info;
            }
        }

        return $address_data;
    }



    public function getUserInfo($user_id) {
        $query = $this->db->query("SELECT CONCAT(firstname,' ',lastname) AS name FROM `oc_user` WHERE 1 AND user_id = '" . (int)$user_id . "'");
        return $query->row;
    }


    public function getTotalCustomersAwaitingApproval() {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE status = '0' OR approved = '0'");

        return $query->row['total'];
    }

    public function getTotalAddressesByCustomerId($customer_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int) $customer_id . "'");

        return $query->row['total'];
    }

    public function getTotalAddressesByCountryId($country_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "address WHERE country_id = '" . (int) $country_id . "'");

        return $query->row['total'];
    }

    public function getTotalAddressesByZoneId($zone_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "address WHERE zone_id = '" . (int) $zone_id . "'");

        return $query->row['total'];
    }

    public function getTotalCustomersByCustomerGroupId($customer_group_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE customer_group_id = '" . (int) $customer_group_id . "'");

        return $query->row['total'];
    }

    public function addHistory($customer_id, $comment) {
        $this->db->query("INSERT INTO " . DB_PREFIX . "customer_history SET customer_id = '" . (int) $customer_id . "', comment = '" . $this->db->escape(strip_tags($comment)) . "', date_added = NOW()");
    }

    public function getHistories($customer_id, $start = 0, $limit = 10) {
        if ($start < 0) {
            $start = 0;
        }

        if ($limit < 1) {
            $limit = 10;
        }

        $query = $this->db->query("SELECT comment, date_added FROM " . DB_PREFIX . "customer_history WHERE customer_id = '" . (int) $customer_id . "' ORDER BY date_added DESC LIMIT " . (int) $start . "," . (int) $limit);

        return $query->rows;
    }

    public function getTotalHistories($customer_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer_history WHERE customer_id = '" . (int) $customer_id . "'");

        return $query->row['total'];
    }

    public function addTransaction($customer_id, $description = '', $amount = '', $order_id = 0) {
        $customer_info = $this->getCustomer($customer_id);

        if ($customer_info) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "customer_transaction SET customer_id = '" . (int) $customer_id . "', order_id = '" . (int) $order_id . "', description = '" . $this->db->escape($description) . "', amount = '" . (float) $amount . "', date_added = NOW()");

            $this->load->language('mail/customer');

            $this->load->model('setting/store');

            $store_info = $this->model_setting_store->getStore($customer_info['store_id']);

            if ($store_info) {
                $store_name = $store_info['name'];
            } else {
                $store_name = $this->config->get('config_name');
            }

            $subject = sprintf($this->language->get('text_transaction_subject'), $this->config->get('config_name'));
            $message = sprintf($this->language->get('text_transaction_received'), $this->currency->format($amount, $this->config->get('config_currency'))) . "\n\n";
            $message .= sprintf($this->language->get('text_transaction_total'), $this->currency->format($this->getTransactionTotal($customer_id), $this->config->get('config_currency')));

            $mail = new Mail($this->config->get('config_mail_engine'));
            $mail->parameter = $this->config->get('config_mail_parameter');
            $mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
            $mail->smtp_username = $this->config->get('config_mail_smtp_username');
            $mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
            $mail->smtp_port = $this->config->get('config_mail_smtp_port');
            $mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

            $mail->setTo($customer_info['email']);
            $mail->setFrom($this->config->get('config_email'));
            $mail->setSender($store_name);
            $mail->setSubject($subject);
            $mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
            $mail->send();
        }
    }

    public function deleteTransaction($order_id) {
        $this->db->query("DELETE FROM " . DB_PREFIX . "customer_transaction WHERE order_id = '" . (int) $order_id . "'");
    }

    public function getTransactions($customer_id, $start = 0, $limit = 10) {
        if ($start < 0) {
            $start = 0;
        }

        if ($limit < 1) {
            $limit = 10;
        }

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_transaction WHERE customer_id = '" . (int) $customer_id . "' ORDER BY date_added DESC LIMIT " . (int) $start . "," . (int) $limit);

        return $query->rows;
    }

    public function getTotalTransactions($customer_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total  FROM " . DB_PREFIX . "customer_transaction WHERE customer_id = '" . (int) $customer_id . "'");

        return $query->row['total'];
    }

    public function getTransactionTotal($customer_id) {
        $query = $this->db->query("SELECT SUM(amount) AS total FROM " . DB_PREFIX . "customer_transaction WHERE customer_id = '" . (int) $customer_id . "'");

        return $query->row['total'];
    }

    public function getTotalTransactionsByOrderId($order_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer_transaction WHERE order_id = '" . (int) $order_id . "'");

        return $query->row['total'];
    }

    public function addReward($customer_id, $description = '', $points = '', $order_id = 0) {
        $customer_info = $this->getCustomer($customer_id);

        if ($customer_info) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "customer_reward SET customer_id = '" . (int) $customer_id . "', order_id = '" . (int) $order_id . "', points = '" . (int) $points . "', description = '" . $this->db->escape($description) . "', date_added = NOW()");

            $this->load->language('mail/customer');

            $this->load->model('setting/store');

            $store_info = $this->model_setting_store->getStore($customer_info['store_id']);

            if ($store_info) {
                $store_name = $store_info['name'];
            } else {
                $store_name = $this->config->get('config_name');
            }

            $message = sprintf($this->language->get('text_reward_received'), $points) . "\n\n";
            $message .= sprintf($this->language->get('text_reward_total'), $this->getRewardTotal($customer_id));

            $mail = new Mail($this->config->get('config_mail_engine'));
            $mail->parameter = $this->config->get('config_mail_parameter');
            $mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
            $mail->smtp_username = $this->config->get('config_mail_smtp_username');
            $mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
            $mail->smtp_port = $this->config->get('config_mail_smtp_port');
            $mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

            $mail->setTo($customer_info['email']);
            $mail->setFrom($this->config->get('config_email'));
            $mail->setSender($store_name);
            $mail->setSubject(sprintf($this->language->get('text_reward_subject'), $store_name));
            $mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
            $mail->send();
        }
    }

    public function deleteReward($order_id) {
        $this->db->query("DELETE FROM " . DB_PREFIX . "customer_reward WHERE order_id = '" . (int) $order_id . "' AND points > 0");
    }

    public function getRewards($customer_id, $start = 0, $limit = 10) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_reward WHERE customer_id = '" . (int) $customer_id . "' ORDER BY date_added DESC LIMIT " . (int) $start . "," . (int) $limit);

        return $query->rows;
    }

    public function getTotalRewards($customer_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer_reward WHERE customer_id = '" . (int) $customer_id . "'");

        return $query->row['total'];
    }

    public function getRewardTotal($customer_id) {
        $query = $this->db->query("SELECT SUM(points) AS total FROM " . DB_PREFIX . "customer_reward WHERE customer_id = '" . (int) $customer_id . "'");

        return $query->row['total'];
    }

    public function getTotalCustomerRewardsByOrderId($order_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer_reward WHERE order_id = '" . (int) $order_id . "'");

        return $query->row['total'];
    }

    public function getIps($customer_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_ip WHERE customer_id = '" . (int) $customer_id . "'");

        return $query->rows;
    }

    public function getTotalIps($customer_id) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer_ip WHERE customer_id = '" . (int) $customer_id . "'");

        return $query->row['total'];
    }

    public function getTotalCustomersByIp($ip) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer_ip WHERE ip = '" . $this->db->escape($ip) . "'");

        return $query->row['total'];
    }

    public function addBanIp($ip) {
        $this->db->query("INSERT INTO `" . DB_PREFIX . "customer_ban_ip` SET `ip` = '" . $this->db->escape($ip) . "'");
    }

    public function removeBanIp($ip) {
        $this->db->query("DELETE FROM `" . DB_PREFIX . "customer_ban_ip` WHERE `ip` = '" . $this->db->escape($ip) . "'");
    }

    public function getTotalBanIpsByIp($ip) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "customer_ban_ip` WHERE `ip` = '" . $this->db->escape($ip) . "'");

        return $query->row['total'];
    }

    public function getTotalLoginAttempts($email) {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "customer_login` WHERE `email` = '" . $this->db->escape($email) . "'");

        return $query->row;
    }

    public function deleteLoginAttempts($email) {
        $this->db->query("DELETE FROM `" . DB_PREFIX . "customer_login` WHERE `email` = '" . $this->db->escape($email) . "'");
    }

    //mlaxwong added
    public function customerExistsByPhone($telephone) {
        $sql = "SELECT 	* FROM " . DB_PREFIX . "customer WHERE telephone = '$telephone'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function newCustomerExistByPhone($customer_id) {
        $sql = "SELECT 	telephone FROM " . DB_PREFIX . "customer WHERE customer_id = '$customer_id'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function oldCustomerExistByIc($customer_id) {
        $sql = "SELECT 	telephone FROM " . DB_PREFIX . "customer WHERE customer_id = '$customer_id'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function newCustomerExistByIC($customer_id) {
        $sql = "SELECT 	customer_ic FROM " . DB_PREFIX . "customer WHERE customer_id = '$customer_id'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function oldCustomerExistByPhone($customer_id) {
        $sql = "SELECT 	customer_ic FROM " . DB_PREFIX . "customer WHERE customer_id = '$customer_id'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function customerExistsByIc($ic) {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_ic = '$ic'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    //mlaxwong added
    public function customerExistsByCard($card) {
        $sql = "SELECT 	* FROM " . DB_PREFIX . "customer WHERE customer_card = '$card'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    //mlaxwong added
    public function customerExistsByEmail($email) {
        $sql = "SELECT 	* FROM " . DB_PREFIX . "customer WHERE email = '$email'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    //get Customers tines
    public function selectCustomers($data = array()) {
        $sql = "SELECT * from " . DB_PREFIX . "customer c WHERE c.status = '1' AND c.approved = '1'";

        //print_r($sql);

        if (isset($data['customer_ic']) && !is_null($data['customer_ic'])) {
            $sql .= " AND c.customer_ic = '" . $this->db->escape($data['customer_ic']) . "'";
        }

        if (isset($data['customer_card']) && !is_null($data['customer_card'])) {
            $sql .= " AND c.customer_card = '" . $this->db->escape($data['customer_card']) . "'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }



    public function setPassword() {
        $sql = "SELECT * from " . DB_PREFIX . "customer c";
        $query = $this->db->query($sql);

        foreach ($query->rows as $customers) {
            $new_password = substr($customers['customer_ic'], -4);

            $this->db->query("UPDATE " . DB_PREFIX . "customer SET salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($new_password)))) . "' WHERE customer_id = '" . (int) $customers['customer_id'] . "'");
        }
    }

    public function check_unique_id($unique_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE unique_customer_id = '" . $this->db->escape($unique_id) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_customer_by_ic($customer_ic) {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_ic = '" . $this->db->escape($customer_ic) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_customer_by_id($customer_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . $this->db->escape($customer_id) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_appointment_customer_id($customer_id) {
        $sql = "SELECT customer_id FROM " . DB_PREFIX . "appointment WHERE customer_id = '" . $this->db->escape($customer_id) . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_zone_by_name($zone_name) {
        $sql = "SELECT * FROM " . DB_PREFIX . "zone WHERE name = '" . $this->db->escape($zone_name) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }
    public function getStores() {
        $store_data = $this->cache->get('store');

        if (!$store_data) {
            $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store ORDER BY url");

            $store_data = $query->rows;

            $this->cache->set('store', $store_data);
        }

        return $store_data;
    }

    public function getPaidHerbals($order_id) {
        $order_query = $this->db->query("SELECT *  FROM " . DB_PREFIX . "clinical_sale cs WHERE cs.order_id ='" . (int) $order_id . "' AND cs.order_action= '5'");

        return $order_query->rows;
    }

    public function getServices($order_id) {
        $order_query = $this->db->query("SELECT * ,si.net_amount As service_price   FROM " . DB_PREFIX . "service_item si  LEFT JOIN " . DB_PREFIX . "service_form sf ON (si.service_form_id = sf.service_form_id) WHERE sf.order_id ='" . (int) $order_id . "'");

        return $order_query->rows;
    }

    public function getOrderProducts($order_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "' AND price !=0");

        return $query->rows;
    }

    public function getUserStore($user_id) {
        $query = $this->db->query("SELECT store_id FROM `oc_user_to_store` WHERE user_id = '" . (int)$user_id . "'");
        return $query->rows;
    }
}
