<?php

class ModelCatalogStockAdjustment extends Model
{
	public function getStockAdjustmentList($data)
	{
		$sort 	= isset($data['sort']) ? $data['sort'] : "name";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";

		$filter_remark = isset($data['filter_remark']) ? explode(',', $data['filter_remark']) : array();


		$filter_location_id = $data['filter_location_id'] != '' ?
		"AND sai.location_id in (" . $data['filter_location_id'] . ")" : '';
		
		$filter_date_from = (!empty($data['filter_date_from']))?
		" AND DATE(sai.date_added) >= '" . $this->db->escape($data['filter_date_from']) . "'" :
		"";
		

		$filter_date_to = (!empty($data['filter_date_to']))?
		" AND DATE(sai.date_added) <= '" . $this->db->escape($data['filter_date_to']) . "'" : 
		"";
		

		$filter_batch_date_from = (!empty($data['filter_batch_date_from']))?
		" AND sai.batch_date >= '" . $this->db->escape($data['filter_batch_date_from']) . "'" :
		"";
		

		$filter_batch_date_to = (!empty($data['filter_batch_date_to']))?
		" AND sai.batch_date <= '" . $this->db->escape($data['filter_batch_date_to']) . "'" : 
		"";
		

		$filter_doc_no = (!empty($data['filter_doc_no']))?
		" AND sa.invoice_prefix LIKE '%" . $this->db->escape($data['filter_doc_no']) . "%'" :
		"";
		

		// $filter_remark = (!empty($data['filter_remark']))?
		// " AND sa.description LIKE '%" . $this->db->escape($data['filter_remark']) . "%'" : 
		// "";
		

		$filter_product_name = (!empty($data['filter_product_name']))?
		" AND p.model LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'" :
		"";
		

		$filter_product_code = (!empty($data['filter_product_code']))?
		" AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'":
		"";

		$filter_remark_statement = "";

        foreach ($filter_remark as $filter_remarks) {
            $filter_remark_statement .= empty($filter_remark_statement) ? "sa.description LIKE '%" . $filter_remarks . "%'" : " OR sa.description LIKE '%" . $filter_remarks . "%'";
        }

        $filter_remark_statement = !empty($filter_remark_statement) ? "AND ($filter_remark_statement)" : "";
		
		$filter_add_by = $data['filter_add_by'] != '' ?
		"AND sai.add_by in (" . $data['filter_add_by'] . ")" : '';

		$filter_status = $data['filter_status'] != '' ?
		"AND sa.status in (" . $data['filter_status'] . ")" : '';

		$filter_store_id = $data['filter_store_id'] != '' ?
		"AND sa.store_id in (" . $data['filter_store_id'] . ")" : '';

		$filter_category = $data['filter_category'] != '' ?
		"AND (CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) in (" . $data['filter_category'] . ")" : '';

		

		$start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;


		$sql = "
				SELECT 
					
					sai.stock_adjustment_item_id AS stock_adjustment_item_id,
					sai.product_id AS product_id,
					sai.batch_date AS batch_date,
					sai.stock_onhand AS onhand,
					sai.stock_balance AS balance,
					wcd.unit AS unit,
					sai.date_added  AS date_added,
					sai.date_modified AS date_modified,
					sai.location_id AS location_id,
					sai.qty AS qty,
					sai.location AS location,
					sai.add_by,
					sai.remark AS remark,
					sai.action AS action,
					p.model AS product_name,
					p.code AS product_code,
					CONCAT(u.firstname,'',u.lastname) AS add_by,
					CONCAT(u.firstname,'',u.lastname) AS modified_by,
					sa.invoice_prefix AS invoice_prefix,
					sa.status AS status,
					sa.date_added AS doc_date,
					sa.description AS description,
					sa.stock_adjustment_id AS stock_adjustment_id,
					sa.store_id AS store_id,
					(CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) as category_id,
					cd.name AS category,
					s.name AS store_name


				FROM " . DB_PREFIX . "stock_adjustment_item sai
				LEFT JOIN " . DB_PREFIX . "stock_adjustment sa
				ON sai.stock_adjustment_id = sa.stock_adjustment_id
				LEFT JOIN " . DB_PREFIX . "product p
				ON sai.product_id = p.product_id
				LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
				ON sai.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "'
				LEFT JOIN " . DB_PREFIX . "user u
				ON sai.add_by = u.user_id 
				LEFT JOIN " . DB_PREFIX . "product_to_category ptc
				ON sai.product_id = ptc.product_id
				LEFT JOIN " . DB_PREFIX . "category_description cd
				ON ptc.category_id = cd.category_id AND cd.language_id = '" . (int) $this->config->get('config_language_id') . "'
				LEFT JOIN " . DB_PREFIX . "store s
				ON sa.store_id = s.store_id	
				WHERE 1
				$filter_location_id
				$filter_date_from
				$filter_date_to
				$filter_batch_date_from
				$filter_batch_date_to
				$filter_doc_no
				$filter_remark_statement
				$filter_product_name
				$filter_product_code
				$filter_add_by
				$filter_status
				$filter_store_id
				$filter_category
				GROUP BY sai.stock_adjustment_item_id
				ORDER BY sa.stock_adjustment_id DESC , sai.stock_adjustment_item_id DESC
				LIMIT $start, $limit 

		";


		$query = $this->db->query($sql);

		return $query->rows;
	}



	public function getStockAdjustment($stock_adjustment_id)
	{
		$stock_adjustment_info = array();

		$store_id = $this->session->data['store_id'];

		$user_id = $this->session->data['user_id'];

		$language_id = $this->config->get('config_language_id');

		$sql = "

		SELECT
		    " . DB_PREFIX . "stock_adjustment.*,

			CONCAT(" . DB_PREFIX . "user.firstname, ' ', " . DB_PREFIX . "user.lastname) AS 'staff',

			" . DB_PREFIX . "stock_adjustment.store_id

		FROM

			" . DB_PREFIX . "stock_adjustment,

			" . DB_PREFIX . "user

		WHERE " . DB_PREFIX . "stock_adjustment.add_by = " . DB_PREFIX . "user.user_id

		AND " . DB_PREFIX . "stock_adjustment.stock_adjustment_id = $stock_adjustment_id";

		$query = $this->db->query($sql);



		$stock_adjustment_info = $query->row;

		if (!empty($stock_adjustment_info['store_id'])) {
			$store_id = $stock_adjustment_info['store_id'];
		}


		$sql = "

		SELECT

			p.product_id,

			pd.name AS name,

			pd_en.name AS product_name, 
                pd_cn.name AS product_name2,

			p.code AS code,

			pts.onhand_quantity,

			sai.*,

			wcd.*,

			GROUP_CONCAT(DISTINCT cd.name separator ', ') AS category,

			DATE_FORMAT(sai.date_modified, '%d-%m-%Y %H:%i %a') AS 'date_modified',

			CONCAT(u2.firstname , ' ', u2.lastname) AS 'modified_by',

			(CASE WHEN sa.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname

		FROM

		" . DB_PREFIX . "stock_adjustment_item sai LEFT JOIN 
		" . DB_PREFIX . "stock_adjustment sa ON (sa.stock_adjustment_id = sai.stock_adjustment_id) LEFT JOIN
		" . DB_PREFIX . "product p ON p.product_id = sai.product_id LEFT JOIN 
		" . DB_PREFIX . "product_description pd ON pd.product_id = p.product_id AND pd.language_id = '" . $this->config->get('config_language_id') . "'LEFT JOIN 
		" . DB_PREFIX . "weight_class_description wcd ON(wcd.weight_class_id = sai.weight_class_id AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN
		"  . DB_PREFIX . "product_to_category ptc ON(ptc.product_id = sai.product_id) LEFT JOIN 
		" . DB_PREFIX . "product_description pd_en ON(sai.product_id = pd_en.product_id AND pd_en.language_id='1') LEFT JOIN  
		" . DB_PREFIX . "product_description pd_cn ON(sai.product_id = pd_cn.product_id AND pd_cn.language_id='2') LEFT JOIN
		" . DB_PREFIX . "user u2 ON(sai.modify_by = u2.user_id) LEFT JOIN 
		"  . DB_PREFIX . "category_description cd ON(cd.category_id = ptc.category_id AND cd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN 
		" . DB_PREFIX . "setting sett ON(sett.key = 'config_name' AND sett.store_id = sa.store_id) LEFT JOIN 
		" . DB_PREFIX . "store s ON(s.store_id = sa.store_id) LEFT JOIN
		" . DB_PREFIX . "product_to_store pts ON(pts.product_id = sai.product_id AND pts.location_id = sai.location_id AND pts.store_id = $store_id) 


		WHERE sai.stock_adjustment_id = $stock_adjustment_id GROUP BY sai.stock_adjustment_item_id

		";


		$query = $this->db->query($sql);
		$stock_adjustment_items = $query->rows;
		foreach ($stock_adjustment_items as $product) {
			$stock_adjustment_info['stock_adjustment_item'][$product['stock_adjustment_item_id']] = array(

				'stock_adjustment_item_id' => $product['stock_adjustment_item_id'],
				'name' => $product['name'],
				'product_name2' => $product['product_name2'],
				'product_id' => $product['product_id'],
				'code' => $product['code'],
				'batch_date' => $product['batch_date'],
				'onhand_quantity' => $product['onhand_quantity'],
				'qty' => $product['qty'],
				'weight_class_id' => $product['weight_class_id'],
				'location_id' => $product['location_id'],
				'remark' => $product['remark'],
				'action' => $product['action'],
				'location' => $product['location'],
				'stock_balance' => $product['stock_balance'],
				'stock_onhand' => $product['stock_onhand'],
				'unit' => $product['unit'],
				'sname' => $product['sname'],
				'category' => $product['category'],
				'date_modified' => date('d/m/Y H:iA', strtotime($product['date_modified'])),
				'modified_by' => $product['modified_by']
			);
		}


		return $stock_adjustment_info;
	}

	public function getStockAdjustmentProducts($stock_adjustment_id)
	{
		$sql = "SELECT 
                sai.qty, 
                sa.invoice_prefix,
                sa.description,
                sai.product_id, 
                p.code, 
                pd_en.name AS product_name, 
                pd_cn.name AS product_name2,
                GROUP_CONCAT(cd.name separator ', ') AS category,
                sai.batch_date,
                sai.location,
				(CASE WHEN sa.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,
                wcd.unit,
                sai.stock_onhand,
				sai.stock_balance,
				sai.action,
                DATE_FORMAT(sai.date_modified, '%d-%m-%Y %H:%i %a') AS 'date_modified',
                CONCAT(u2.firstname , ' ', u2.lastname) AS 'modified_by'
                FROM 
                " . DB_PREFIX . "stock_adjustment_item sai LEFT JOIN 
                " . DB_PREFIX . "stock_adjustment sa ON (sa.stock_adjustment_id = sai.stock_adjustment_id) LEFT JOIN
                " . DB_PREFIX . "product p ON p.product_id = sai.product_id LEFT JOIN 
                " . DB_PREFIX . "product_description pd ON pd.product_id = p.product_id AND pd.language_id = '" . $this->config->get('config_language_id') . "'LEFT JOIN 
                " . DB_PREFIX . "weight_class_description wcd ON(wcd.weight_class_id = sai.weight_class_id AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN
                "  . DB_PREFIX . "product_to_category ptc ON(ptc.product_id = sai.product_id) LEFT JOIN 
                " . DB_PREFIX . "product_description pd_en ON(sai.product_id = pd_en.product_id AND pd_en.language_id='1') LEFT JOIN  
                " . DB_PREFIX . "product_description pd_cn ON(sai.product_id = pd_cn.product_id AND pd_cn.language_id='2') LEFT JOIN
                " . DB_PREFIX . "user u2 ON(sai.modify_by = u2.user_id) LEFT JOIN 
                "  . DB_PREFIX . "category_description cd ON(cd.category_id = ptc.category_id AND cd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN 
                " . DB_PREFIX . "setting sett ON(sett.key = 'config_name' AND sett.store_id = sa.store_id) LEFT JOIN 
                " . DB_PREFIX . "store s ON(s.store_id = sa.store_id)
                WHERE 
                sai.stock_adjustment_id = '" . (int)$stock_adjustment_id . "'";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function addStockAdjustment($data)

	{
		$this->load->model('catalog/product');

		$submit = isset($this->request->post['submit']) ? true : false;
		$draft = isset($this->request->post['draft']) ? true : false;
		$save_header = isset($this->request->post['add_product']) ? true : false;

		if ($submit) {
			$status = '5';
		}
		if ($draft || $save_header) {
			$status = '1';
		}

		$invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_adjustment', 'store' => $this->session->data['store_id']));

		//$status = $data['action'];

		$store_id = $this->session->data['store_id'];
		$user_id = $this->session->data['user_id'];

		$stock_adjustment_item = isset($data['stock_adjustment_item']) ? $data['stock_adjustment_item'] : array();

		$sql = "
			INSERT INTO " . DB_PREFIX . "stock_adjustment 
				SET
					invoice_prefix = '" . $invoice_prefix . "',
					store_id = '" . (int)$store_id . "',
					status = '" . (int)$status . "',
					description = '" . $this->db->escape($data['description'])  . "',
					add_by = " . (int)$user_id . ",
					date_added = '" . $this->db->escape($data['stock_adjustment_date'])  . "',
					modify_by = " . (int)$user_id . ",
					date_modified = NOW()

		";
// 		echo"<pre>";
// 		print_r($stock_adjustment_item);
// 		echo"</pre>";
		$query = $this->db->query($sql);
		$lastid =  $this->db->getLastId();

		if ($lastid != 0) {
			$this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_adjustment', 'store' => $this->session->data['store_id']));
			foreach ($stock_adjustment_item as $row_id => $item) {
				$product_id = $item['product_id'];
				$action = $item['action'];
				$qty = $item['qty'];
				$weight_class_id = $item['unit'];
				$remark = $item['remark'];
				$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : null;
				$location = $this->getLocationText($item['location_id']);
				$location_id = $item['location_id'];
				$stock_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);

				

				if($action == 1){
					$stock_balance = $stock_onhand + $qty ;
				}else{
					$stock_balance = $stock_onhand - $qty ;
				};
				$product_info = $this->model_catalog_product->getProduct($product_id);

				$product_wcid = $this->getweightClassProduct($product_id);

				$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;

				$total_product_weight = $qty * $product_weight;
				$weight_quantity = $this->weight->convert($total_product_weight, $weight_class_id, $product_wcid);

				if (!empty($batch_date)) {
					$batch_date = $batch_date;
					$batch = $batch_date;
				} else {
					$batch_date = 'NULL';
					$batch = '0000-00-00';
				}

				// $location = $item['location'];
				$item_sql = "
				INSERT INTO " . DB_PREFIX . "stock_adjustment_item 
					SET
						stock_adjustment_id = " . (int)$lastid . ",
						product_id = " . (int)$product_id . ",
						action = " . (int)$action . ",
						qty = " . (float)$qty . ",
						weight_class_id= " . (int)$item['weight_class_id'] . ",
						weight_quantity = '" . (float)$weight_quantity . "',
						remark = '" . $this->db->escape($remark) . "',
						batch_date = '" .  $this->db->escape($batch_date) . "',
						stock_onhand = '" . (float)$stock_onhand . "',
						stock_balance = '" . (float)$stock_balance . "',
						location_id = '" . (int)$item['location_id'] . "',
						location = '" . $this->db->escape($location) . "',
						add_by = " . (int)$user_id . ",
						date_added = '" . $this->db->escape($data['stock_adjustment_date'])  . "',
						modify_by = " . (int)$user_id . ",
						date_modified = NOW()

				";

				$item_query = $this->db->query($item_sql);
				//if($status == 5){
				if($action == 1){
					$calculation = "+" ;
				}else{
					$calculation = "-";
				};

				if ($submit) {
					$calculation_sql = "

				UPDATE " . DB_PREFIX . "product_to_store 
				SET
					onhand_quantity = onhand_quantity $calculation $qty
					WHERE product_id = $product_id
					AND store_id = $store_id
					AND location_id = $location_id
					AND batch_date = $batch_date
				";



					$calculate_query = $this->db->query($calculation_sql);

					//}
				}
			}
		}
		
		return $lastid;
	}


	public function editStockAdjustment($stock_adjustment_id, $data)
	{

		$this->load->model('catalog/product');

		$submit = isset($this->request->post['submit']) ? true : false;
		$draft = isset($this->request->post['draft']) ? true : false;


		if ($submit) {
			$status = '5';
		}
		if ($draft) {
			$status = '1';
		}



		$store_id = $this->session->data['store_id'];
		$user_id = $this->session->data['user_id'];


		$stock_adjustment_item = $data['stock_adjustment_item'];

		$sql = "
		UPDATE " . DB_PREFIX . "stock_adjustment SET

		status = '$status',
		description = '" . $this->db->escape($data['description'])  . "',
		
		modify_by = " . $user_id . ",
		date_modified = NOW()
		WHERE stock_adjustment_id = '" . (int)$stock_adjustment_id . "'
		";

		$query = $this->db->query($sql);

		$old_user_id = $this->db->query("SELECT add_by FROM " . DB_PREFIX . "stock_adjustment WHERE stock_adjustment_id = '" . (int)$stock_adjustment_id . "'")->row['add_by'];

		$sql_delete = "DELETE FROM " . DB_PREFIX . "stock_adjustment_item WHERE stock_adjustment_id='" . (int)$stock_adjustment_id . "'";
		$this->db->query($sql_delete);
		$this->load->model('catalog/product');

		$this->load->library('weight');

		$this->weight = new Weight($this->registry);



		foreach ($stock_adjustment_item as $row_id => $item) {
			$product_id = $item['product_id'];
			$action = $item['action'];
			$qty = $item['qty'];
			$weight_class_id = $item['weight_class_id'];
			$remark = $item['remark'];
			$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : null;
			$location = $this->getLocationText($item['location_id']);
			$location_id = $item['location_id'];
			$stock_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);

			if ($action == 1) {
				$stock_balance = $stock_onhand + $qty;
			} else {
				$stock_balance = $stock_onhand - $qty;
			}

			$product_info = $this->model_catalog_product->getProduct($product_id);

			$product_wcid = $this->getweightClassProduct($product_id);

			$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;

			$total_product_weight = $qty * $product_weight;
			$weight_quantity = $this->weight->convert($total_product_weight, $weight_class_id, $product_wcid);

			if (!empty($batch_date)) {
				$batch_date = "'" . $batch_date . "'";
				$batch = $batch_date;
			} else {
				$batch_date = 'NULL';
				$batch = "'0000-00-00'";
			}

			$item_sql = "

				INSERT INTO " . DB_PREFIX . "stock_adjustment_item SET

				stock_adjustment_id = " . $stock_adjustment_id . ",
				product_id = " . $product_id . ",
				action = " . $action . ",
				qty = " . $qty . ",
				weight_class_id= " . (int)$weight_class_id . ",
				weight_quantity = '" . (float)$weight_quantity . "',
				remark = '" . $this->db->escape($remark) . "',
				batch_date = " . $batch_date . ",
				stock_onhand = '" . (float)$stock_onhand . "',
				stock_balance = '" . (float)$stock_balance . "',
				location_id = '" . (int)$item['location_id'] . "',
				location = '" . $this->db->escape($location) . "',
				add_by = " . $old_user_id . ",
				date_added = '" . $this->db->escape($data['stock_adjustment_date'])  . "',
				modify_by = " . $user_id . ",
		        date_modified = NOW()

				";

			$item_query = $this->db->query($item_sql);
			$calculation = ($action == 1) ? "+" : "-";

			if ($submit) {
				$stock_adjustment_item_id =  $this->db->getLastId();
				$converted_qty = $this->weight->convert($qty, $weight_class_id, $this->getweightClassProduct($product_id));

				$calculation_sql = "

					UPDATE " . DB_PREFIX . "product_to_store SET
					onhand_quantity = onhand_quantity  $calculation $qty
					WHERE product_id = $product_id
					AND store_id = $store_id
					AND location_id = $location_id
					AND batch_date = $batch_date
					";



				$calculate_query = $this->db->query($calculation_sql);

				//update stock_balance in lot_transfer_product table
				$update_sql = "UPDATE " . DB_PREFIX . "stock_adjustment_item SET
				stock_balance = stock_onhand $calculation $converted_qty
				WHERE stock_adjustment_item_id = $stock_adjustment_item_id";
				$update_query = $this->db->query($update_sql);
			}
		}
	}


	public function getProductByName($product_name)
	{
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND pd.name = '" . $this->db->escape($product_name) . "' AND pd.name != ''");

		return $query->rows;
	}


	public function totalStockAdjustment($data)
	{

		$filter_remark = isset($data['filter_remark']) ? explode(',', $data['filter_remark']) : array();


		$filter_location_id = $data['filter_location_id'] != '' ?
		"AND sai.location_id in (" . $data['filter_location_id'] . ")" : '';
		
		$filter_date_from = (!empty($data['filter_date_from']))?
		" AND DATE(sai.date_added) >= '" . $this->db->escape($data['filter_date_from']) . "'" :
		"";
		

		$filter_date_to = (!empty($data['filter_date_to']))?
		" AND DATE(sai.date_added) <= '" . $this->db->escape($data['filter_date_to']) . "'" : 
		"";
		

		$filter_batch_date_from = (!empty($data['filter_batch_date_from']))?
		" AND sai.batch_date >= '" . $this->db->escape($data['filter_batch_date_from']) . "'" :
		"";
		

		$filter_batch_date_to = (!empty($data['filter_batch_date_to']))?
		" AND sai.batch_date <= '" . $this->db->escape($data['filter_batch_date_to']) . "'" : 
		"";
		

		$filter_doc_no = (!empty($data['filter_doc_no']))?
		" AND sa.invoice_prefix LIKE '%" . $this->db->escape($data['filter_doc_no']) . "%'" :
		"";
		

		// $filter_remark = (!empty($data['filter_remark']))?
		// " AND sa.description LIKE '%" . $this->db->escape($data['filter_remark']) . "%'" : 
		// "";
		

		$filter_product_name = (!empty($data['filter_product_name']))?
		" AND p.model LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'" :
		"";
		

		$filter_product_code = (!empty($data['filter_product_code']))?
		" AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'":
		"";

		$filter_remark_statement = "";

        foreach ($filter_remark as $filter_remarks) {
            $filter_remark_statement .= empty($filter_remark_statement) ? "sa.description LIKE '%" . $filter_remarks . "%'" : " OR sa.description LIKE '%" . $filter_remarks . "%'";
        }

        $filter_remark_statement = !empty($filter_remark_statement) ? "AND ($filter_remark_statement)" : "";
		
		$filter_add_by = $data['filter_add_by'] != '' ?
		"AND sai.add_by in (" . $data['filter_add_by'] . ")" : '';

		$filter_status = $data['filter_status'] != '' ?
		"AND sa.status in (" . $data['filter_status'] . ")" : '';

		$filter_store_id = $data['filter_store_id'] != '' ?
		"AND sa.store_id in (" . $data['filter_store_id'] . ")" : '';

		$filter_category = $data['filter_category'] != '' ?
		"AND (CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) in (" . $data['filter_category'] . ")" : '';

		$start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;


		$sql = "
				SELECT 
					COUNT(DISTINCT sai.stock_adjustment_item_id) AS total


				FROM " . DB_PREFIX . "stock_adjustment_item sai
				LEFT JOIN " . DB_PREFIX . "stock_adjustment sa
				ON sai.stock_adjustment_id = sa.stock_adjustment_id
				LEFT JOIN " . DB_PREFIX . "product p
				ON sai.product_id = p.product_id
				LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
				ON sai.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "'
				LEFT JOIN " . DB_PREFIX . "user u
				ON sai.add_by = u.user_id 
				LEFT JOIN " . DB_PREFIX . "product_to_category ptc
				ON sai.product_id = ptc.product_id
				LEFT JOIN " . DB_PREFIX . "category_description cd
				ON ptc.category_id = cd.category_id AND cd.language_id = '" . (int) $this->config->get('config_language_id') . "'
				LEFT JOIN " . DB_PREFIX . "store s
				ON sa.store_id = s.store_id	
				WHERE 1
				
				$filter_location_id
				$filter_date_from
				$filter_date_to
				$filter_batch_date_from
				$filter_batch_date_to
				$filter_doc_no
				$filter_remark_statement
				$filter_product_name
				$filter_product_code
				$filter_add_by
				$filter_status
				$filter_store_id
				$filter_category
				
		";


		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getStockAdjustmentItemAll()
	{
		$sql = "

			SELECT
			   
			    " . DB_PREFIX . "stock_adjustment.add_by as user_id,
				" . DB_PREFIX . "stock_adjustment.stock_adjustment_id,
				" . DB_PREFIX . "stock_adjustment.date_added,
				" . DB_PREFIX . "stock_adjustment.date_added AS date_added_2,
				DATE_FORMAT(" . DB_PREFIX . "stock_adjustment.date_modified, '%d-%m-%Y %H:%i %a') AS 'date_modified',
				" . DB_PREFIX . "stock_adjustment.invoice_prefix,
				pd_en.name as product_name,
                pd_cn.name as product_name2,
				" . DB_PREFIX . "product.code as product_code,
				" . DB_PREFIX . "stock_adjustment_item.product_id,
				" . DB_PREFIX . "stock_adjustment.description,
				" . DB_PREFIX . "stock_adjustment.store_id,
				(CASE WHEN " . DB_PREFIX . "stock_adjustment.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  " . DB_PREFIX . "store.name END) AS sname,
				" . DB_PREFIX . "order_status.name as status_name,
				" . DB_PREFIX . "stock_adjustment.status,
				" . DB_PREFIX . "stock_adjustment_item.qty,
				" . DB_PREFIX . "stock_adjustment_item.location,
				" . DB_PREFIX . "stock_adjustment_item.location_id,
				" . DB_PREFIX . "stock_adjustment_item.remark as remark,
				" . DB_PREFIX . "stock_adjustment_item.stock_onhand,
				" . DB_PREFIX . "stock_adjustment_item.stock_balance,
				" . DB_PREFIX . "stock_adjustment_item.batch_date,
				" . DB_PREFIX . "weight_class_description.unit AS uom,
				" . DB_PREFIX . "category_description.category_id,
				GROUP_CONCAT(DISTINCT " . DB_PREFIX . "category_description.name separator ', ') AS category,

				CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modify_by',

				os.name AS status_name

			FROM

				" . DB_PREFIX . "stock_adjustment_item

				LEFT JOIN " . DB_PREFIX . "stock_adjustment ON (" . DB_PREFIX . "stock_adjustment.stock_adjustment_id = " . DB_PREFIX . "stock_adjustment_item.stock_adjustment_id)

				LEFT JOIN " . DB_PREFIX . "store 
                ON(" . DB_PREFIX . "store.store_id = " . DB_PREFIX . "stock_adjustment.store_id)

				LEFT JOIN " . DB_PREFIX . "order_status
				ON(" . DB_PREFIX . "stock_adjustment.status = " . DB_PREFIX . "order_status.order_status_id AND " . DB_PREFIX . "order_status.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "product_description
				ON(" . DB_PREFIX . "stock_adjustment_item.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(" . DB_PREFIX . "stock_adjustment_item.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(" . DB_PREFIX . "stock_adjustment_item.product_id = pd_cn.product_id AND pd_cn.language_id='2')

				LEFT JOIN " . DB_PREFIX . "product
				ON(" . DB_PREFIX . "stock_adjustment_item.product_id = " . DB_PREFIX . "product.product_id )

				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_adjustment_item.add_by = " . DB_PREFIX . "user.user_id)

				LEFT JOIN " . DB_PREFIX . "weight_class_description
				ON(" . DB_PREFIX . "stock_adjustment_item.weight_class_id = " . DB_PREFIX . "weight_class_description.weight_class_id AND " . DB_PREFIX . "weight_class_description.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN "  . DB_PREFIX . "product_to_category
				ON(" . DB_PREFIX . "product_to_category.product_id = " . DB_PREFIX . "stock_adjustment_item.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description
				ON(" . DB_PREFIX . "category_description.category_id = " . DB_PREFIX . "product_to_category.category_id
				AND " . DB_PREFIX . "category_description.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

				LEFT JOIN " . DB_PREFIX . "setting sett
                ON(sett.key = 'config_name' AND sett.store_id = " . DB_PREFIX . "stock_adjustment.store_id)

				LEFT JOIN " . DB_PREFIX . "order_status os
				ON (os.order_status_id = " . DB_PREFIX . "stock_adjustment.status)

				GROUP BY " . DB_PREFIX . "stock_adjustment_item.stock_adjustment_item_id
            ";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getStockAdjustmentItemSearched($data)
	{

		$filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? explode(',', $data['filter_invoice_prefix']) : array();
		$filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;
		$filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
		$filter_date_from_str = trim($filter_date_from);
		$filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;
		$filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
		$filter_date_to_str = trim($filter_date_to);

		$filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();
		$filter_product_id = isset($data['filter_product_id']) ? $data['filter_product_id'] : false;
		$filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();
		$filter_batch_date = isset($data['filter_batch_date']) ? $data['filter_batch_date'] : false;
		$filter_batch_date_str = trim($filter_batch_date);
		$filter_batch_date = (!empty($filter_batch_date_str)) ? date("Y-m-d", strtotime($filter_batch_date)) . " 00:00:00" : false;

		$filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;
		$filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
		$filter_category = isset($data['filter_category']) ? $data['filter_category'] : false;
		$filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
		$filter_batch_date_from_str = trim($filter_batch_date_from);
		$filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) . " 00:00:00" : false;

		$filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
		$filter_batch_date_to_str = trim($filter_batch_date_to);
		$filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) . " 23:59:59" : false;

		$filter_product_id_statement = $filter_product_id ? "AND a.product_id LIKE '%" . $filter_product_id . "%'" : "";

		$filter_product_name_statement = "";

		foreach ($filter_product_name as $product_name) {
			$filter_product_name_statement .= empty($filter_product_name_statement) ? " a.en_cn_product_name LIKE '%" . $product_name . "%'" : " OR a.en_cn_product_name LIKE '%" . $product_name . "%'";
		}
		$filter_product_name_statement = !empty($filter_product_name_statement) ? " AND ($filter_product_name_statement)" : "";

		$filter_product_code_statement = "";

		foreach ($filter_product_code as $product_code) {
			$filter_product_code_statement .= empty($filter_product_code_statement) ? "a.product_code LIKE '%" . $product_code . "%'" : " OR a.product_code LIKE '%" . $product_code . "%'";
		}
		$filter_product_code_statement = !empty($filter_product_code_statement) ? " AND ($filter_product_code_statement)" : "";

		//prepare where clause statement
		$filter_invoice_prefix_statement = "";

		foreach ($filter_invoice_prefix as $invoice_prefix) {
			$filter_invoice_prefix_statement .= empty($filter_invoice_prefix_statement) ? "a.invoice_prefix LIKE '%" . $invoice_prefix . "%'" : " OR a.invoice_prefix LIKE '%" . $invoice_prefix . "%'";
		}

		$filter_invoice_prefix_statement = !empty($filter_invoice_prefix_statement) ? "AND ($filter_invoice_prefix_statement)" : "";

		$filter_date_from_statement = $filter_date_from ? "AND DATE(a.date_added) >= DATE('" . $filter_date_from . "')" : "";

		$filter_date_to_statement = $filter_date_to ? "AND DATE(a.date_added) <= DATE('" . $filter_date_to . "')" : "";

		$filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";
		$filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

		$filter_location_id_statement = !empty($data['filter_location_id']) ?

			"AND a.location_id in (" . implode(',', $data['filter_location_id']) . ")" :

			"";


		$filter_store_id_statement = !empty($data['filter_store_id']) ?

			"AND a.store_id in(" . implode(',', $data['filter_store_id']) . ")" :

			"";


		$filter_add_by_statement = !empty($data['filter_add_by']) ?

			"AND a.user_id in (" . implode(',', $data['filter_add_by']) . ")" :

			"";

		$filter_status_statement = !empty($data['filter_status']) ?

			"AND a.status in (" . implode(',', $data['filter_status']) . ")" :

			"";

		$filter_category_statement = !empty($data['filter_category']) ?

			"AND a.category_id in (" . implode(',', $data['filter_category']) . ")" :

			"";

		$sql = "

		SELECT *

		FROM(

			SELECT
			   
			    " . DB_PREFIX . "stock_adjustment.add_by as user_id,
				" . DB_PREFIX . "stock_adjustment.stock_adjustment_id,
				" . DB_PREFIX . "stock_adjustment.date_added,
				" . DB_PREFIX . "stock_adjustment.date_added AS date_added_2,
				DATE_FORMAT(" . DB_PREFIX . "stock_adjustment.date_modified, '%d-%m-%Y %H:%i %a') AS 'date_modified',
				" . DB_PREFIX . "stock_adjustment.invoice_prefix,
				pd_en.name as product_name,
                pd_cn.name as product_name2,
				" . DB_PREFIX . "product.code as product_code,
				" . DB_PREFIX . "stock_adjustment_item.product_id,
				" . DB_PREFIX . "stock_adjustment.description,
				" . DB_PREFIX . "stock_adjustment.store_id,
				(CASE WHEN " . DB_PREFIX . "stock_adjustment.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  " . DB_PREFIX . "store.name END) AS sname,
				" . DB_PREFIX . "order_status.name as status_name,
				" . DB_PREFIX . "stock_adjustment.status,
				" . DB_PREFIX . "stock_adjustment_item.qty,
				" . DB_PREFIX . "stock_adjustment_item.location,
				" . DB_PREFIX . "stock_adjustment_item.location_id,
				" . DB_PREFIX . "stock_adjustment_item.remark as remark,
				" . DB_PREFIX . "stock_adjustment_item.stock_onhand,
				" . DB_PREFIX . "stock_adjustment_item.stock_balance,
				" . DB_PREFIX . "stock_adjustment_item.batch_date,
				" . DB_PREFIX . "weight_class_description.unit AS uom,
				" . DB_PREFIX . "category_description.category_id,
				GROUP_CONCAT(DISTINCT " . DB_PREFIX . "category_description.name separator ', ') AS category,

				CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modify_by'

			FROM

				" . DB_PREFIX . "stock_adjustment_item

				LEFT JOIN " . DB_PREFIX . "stock_adjustment ON (" . DB_PREFIX . "stock_adjustment.stock_adjustment_id = " . DB_PREFIX . "stock_adjustment_item.stock_adjustment_id)

				LEFT JOIN " . DB_PREFIX . "store 
                ON(" . DB_PREFIX . "store.store_id = " . DB_PREFIX . "stock_adjustment.store_id)

				LEFT JOIN " . DB_PREFIX . "order_status
				ON(" . DB_PREFIX . "stock_adjustment.status = " . DB_PREFIX . "order_status.order_status_id AND " . DB_PREFIX . "order_status.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "product_description
				ON(" . DB_PREFIX . "stock_adjustment_item.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(" . DB_PREFIX . "stock_adjustment_item.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(" . DB_PREFIX . "stock_adjustment_item.product_id = pd_cn.product_id AND pd_cn.language_id='2')

				LEFT JOIN " . DB_PREFIX . "product
				ON(" . DB_PREFIX . "stock_adjustment_item.product_id = " . DB_PREFIX . "product.product_id )

				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_adjustment_item.add_by = " . DB_PREFIX . "user.user_id)

				LEFT JOIN " . DB_PREFIX . "weight_class_description
				ON(" . DB_PREFIX . "stock_adjustment_item.weight_class_id = " . DB_PREFIX . "weight_class_description.weight_class_id AND " . DB_PREFIX . "weight_class_description.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN "  . DB_PREFIX . "product_to_category
				ON(" . DB_PREFIX . "product_to_category.product_id = " . DB_PREFIX . "stock_adjustment_item.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description
				ON(" . DB_PREFIX . "category_description.category_id = " . DB_PREFIX . "product_to_category.category_id
				AND " . DB_PREFIX . "category_description.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

				LEFT JOIN " . DB_PREFIX . "setting sett
                ON(sett.key = 'config_name' AND sett.store_id = " . DB_PREFIX . "stock_adjustment.store_id)

				GROUP BY " . DB_PREFIX . "stock_adjustment_item.stock_adjustment_item_id
				)a

				WHERE 1
		
				$filter_invoice_prefix_statement
		
				$filter_add_by_statement
		
				$filter_status_statement
		
				$filter_category_statement
		
				$filter_date_from_statement
		
				$filter_date_to_statement
		
				$filter_store_id_statement
		
				$filter_location_id_statement
		
				$filter_product_id_statement
		
				$filter_product_name_statement
		
				$filter_product_code_statement
		
				$filter_batch_date_to_statement
		
				$filter_batch_date_from_statement";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getStockAdjustmentItemSelected($adjustment_id)
	{
		$sql = "

			SELECT
			   
			    " . DB_PREFIX . "stock_adjustment.add_by as user_id,
				" . DB_PREFIX . "stock_adjustment.stock_adjustment_id,
				" . DB_PREFIX . "stock_adjustment.date_added,
				" . DB_PREFIX . "stock_adjustment.date_added AS date_added_2,
				DATE_FORMAT(" . DB_PREFIX . "stock_adjustment.date_modified, '%d-%m-%Y %H:%i %a') AS 'date_modified',
				" . DB_PREFIX . "stock_adjustment.invoice_prefix,
				pd_en.name as product_name,
                pd_cn.name as product_name2,
				" . DB_PREFIX . "product.code as product_code,
				" . DB_PREFIX . "stock_adjustment_item.product_id,
				" . DB_PREFIX . "stock_adjustment.description,
				" . DB_PREFIX . "stock_adjustment.store_id,
				(CASE WHEN " . DB_PREFIX . "stock_adjustment.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  " . DB_PREFIX . "store.name END) AS sname,
				" . DB_PREFIX . "order_status.name as status_name,
				" . DB_PREFIX . "stock_adjustment.status,
				" . DB_PREFIX . "stock_adjustment_item.qty,
				" . DB_PREFIX . "stock_adjustment_item.location,
				" . DB_PREFIX . "stock_adjustment_item.location_id,
				" . DB_PREFIX . "stock_adjustment_item.remark as remark,
				" . DB_PREFIX . "stock_adjustment_item.stock_onhand,
				" . DB_PREFIX . "stock_adjustment_item.stock_balance,
				" . DB_PREFIX . "stock_adjustment_item.batch_date,
				" . DB_PREFIX . "weight_class_description.unit AS uom,
				" . DB_PREFIX . "category_description.category_id,
				GROUP_CONCAT(DISTINCT " . DB_PREFIX . "category_description.name separator ', ') AS category,

				CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modify_by',

				os.name AS status_name

			FROM

				" . DB_PREFIX . "stock_adjustment_item

				LEFT JOIN " . DB_PREFIX . "stock_adjustment ON (" . DB_PREFIX . "stock_adjustment.stock_adjustment_id = " . DB_PREFIX . "stock_adjustment_item.stock_adjustment_id)

				LEFT JOIN " . DB_PREFIX . "store 
                ON(" . DB_PREFIX . "store.store_id = " . DB_PREFIX . "stock_adjustment.store_id)

				LEFT JOIN " . DB_PREFIX . "order_status
				ON(" . DB_PREFIX . "stock_adjustment.status = " . DB_PREFIX . "order_status.order_status_id AND " . DB_PREFIX . "order_status.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "product_description
				ON(" . DB_PREFIX . "stock_adjustment_item.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(" . DB_PREFIX . "stock_adjustment_item.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(" . DB_PREFIX . "stock_adjustment_item.product_id = pd_cn.product_id AND pd_cn.language_id='2')

				LEFT JOIN " . DB_PREFIX . "product
				ON(" . DB_PREFIX . "stock_adjustment_item.product_id = " . DB_PREFIX . "product.product_id )

				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_adjustment_item.add_by = " . DB_PREFIX . "user.user_id)

				LEFT JOIN " . DB_PREFIX . "weight_class_description
				ON(" . DB_PREFIX . "stock_adjustment_item.weight_class_id = " . DB_PREFIX . "weight_class_description.weight_class_id AND " . DB_PREFIX . "weight_class_description.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN "  . DB_PREFIX . "product_to_category
				ON(" . DB_PREFIX . "product_to_category.product_id = " . DB_PREFIX . "stock_adjustment_item.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description
				ON(" . DB_PREFIX . "category_description.category_id = " . DB_PREFIX . "product_to_category.category_id
				AND " . DB_PREFIX . "category_description.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

				LEFT JOIN " . DB_PREFIX . "setting sett
                ON(sett.key = 'config_name' AND sett.store_id = " . DB_PREFIX . "stock_adjustment.store_id)

				LEFT JOIN " . DB_PREFIX . "order_status os
				ON (os.order_status_id = " . DB_PREFIX . "stock_adjustment.status)

				WHERE " . DB_PREFIX . "stock_adjustment_item.stock_adjustment_id = '" . (int)$adjustment_id . "'
            ";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	//add by alia
	public function getWeightClasses()
	{
		$sql = "SELECT wc.weight_class_id,wcd.unit FROM " . DB_PREFIX . "weight_class wc LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON wc.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE 1";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getLocations()
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location WHERE store_id = '" . (int)$this->session->data['store_id'] . "' ORDER BY warehouse,zone,lot");

		return $query->rows;
	}

	public function getLocationText($location_id)
	{
		$query = $this->db->query("SELECT CONCAT(warehouse,' > ',zone,' > ',lot) as loc_text FROM " . DB_PREFIX . "wms_location WHERE location_id = '" . (int)$location_id . "'");
		$loc_text = !empty($query->row['loc_text']) ? $query->row['loc_text'] : '';
		return $loc_text;
	}

	public function getAllLocations()
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location ORDER BY warehouse,zone,lot");

		return $query->rows;
	}

	public function getDefaultLocation($product_id)
	{
		$query = $this->db->query("SELECT location_id FROM " . DB_PREFIX . "product_to_location WHERE store_id = '" . (int)$this->session->data['store_id'] . "' AND product_id='" . (int)$product_id . "'");

		$location_id = isset($query->row['location_id']) ? $query->row['location_id'] : 0;
		return $location_id;
	}

	public function getProductStock($store_id, $product_id, $location_id, $batch_date)
	{
		if ($batch_date == 'NULL') {
			$batch_condition = " AND batch_date = '0000-00-00' ";
		} else {
			$batch_condition = " AND batch_date = '" . $this->db->escape($batch_date) . "'";
		}

		$sql = "SELECT 
					`onhand_quantity` 
				FROM `" . DB_PREFIX . "product_to_store` 
				WHERE `store_id` = '" . (int)$store_id . "' 
				AND `product_id` = '" . (int)$product_id . "' 
				AND `location_id` = '" . (int)$location_id . "'
				$batch_condition 
		";
		$query = $this->db->query($sql);

		if (!empty($query->row['onhand_quantity'])) {
			return $query->row['onhand_quantity'];
		} else {
			//$this->addProductStock($store_id, $product_id, $location_id, $batch_date);
			return 0;
		}
	}

	public function addProductStock($store_id, $product_id, $location_id, $batch_date)
	{
		if ($batch_date == 'NULL') {
			$batch_update = " batch_date = '0000-00-00', ";
		} else {
			$batch_update = " batch_date = '" . $this->db->escape($batch_date) . "', ";
		}
		$user_id = (int)$this->session->data['user_id'];
		$sql = "INSERT INTO " . DB_PREFIX . "product_to_store 
			SET
				store_id = " . (int)$store_id . ",
				product_id = " . (int)$product_id . ",
				location_id = " . (int)$location_id . ",
				$batch_update
				product_lastmodifiedby = " . (int)$user_id . ",
				product_lastmodifieddate = NOW()
		";
		$this->db->query($sql);
	}


	public function getLocationList($product_id)
	{
		$def_location = array();
		$sql = "SELECT DISTINCT(pts.location_id), CONCAT(wms.warehouse,'>',wms.zone,'>',wms.lot) AS location_text FROM " . DB_PREFIX . "product_to_store pts
		LEFT JOIN " . DB_PREFIX . "wms_location wms on (pts.location_id = wms.location_id)
		 WHERE pts.store_id = '" . (int)$this->session->data['store_id'] . "' 
		 AND pts.product_id='" . (int)$product_id . "'
		 ORDER BY location_text asc";

		$query = $this->db->query($sql);
		$location = $query->rows;
		if (!empty($location)) {
			foreach ($location as $loc) {
				if ($loc['location_id'] == 0) {
					$def_location[$loc['location_id']] = 'Default Location';
				} else {
					$def_location[$loc['location_id']] = $loc['location_text'];
				}
			}
		}

		return $def_location;
	}

	public function getBatchDateList($product_id, $location_id)
	{
		$batchDateList = array();
		$sql = "SELECT DISTINCT(batch_date) FROM " . DB_PREFIX . "product_to_store 
		WHERE product_id = '" . (int)$product_id . "' 
		AND store_id = '" . (int)$this->session->data['store_id'] . "'
		AND location_id = '" . (int)$location_id . "'
		ORDER BY FIELD('0000-00-00', batch_date) DESC, batch_date DESC";
		$query = $this->db->query($sql);
		$list = $query->rows;
		if (!empty($list)) {
			foreach ($list as $date) {
				$batchDateList[] = $date['batch_date'];
			}
		}
		return $batchDateList;
	}

	public function getStockOnhand($product_id, $location_id, $batch_date)
	{
		$sql = "SELECT onhand_quantity FROM " . DB_PREFIX . "product_to_store 
		WHERE product_id = '" . (int)$product_id . "' 
		AND store_id = '" . (int)$this->session->data['store_id'] . "'
		AND location_id = '" . (int)$location_id . "'
		AND batch_date='$batch_date'";
		$query = $this->db->query($sql);
		$qty = !empty($query->row['onhand_quantity']) ? $query->row['onhand_quantity'] : 0;
		return $qty;
	}
	public function getBatchDate()
	{
		$query = $this->db->query("SELECT batch_date FROM " . DB_PREFIX . "stock_adjustment_item WHERE 1");

		return $query->rows;
	}

	public function editStockInfo($stock_adjustment_id, $data)
	{
		$invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_adjustment', 'store' => $this->session->data['store_id']));
		if (!empty($data['invoice_prefix']) && $invoice_prefix == $data['invoice_prefix']) {
			$this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_adjustment', 'store' => $this->session->data['store_id']));
		}

		$store_id = (int)$this->session->data['store_id'];
		$user_id = (int)$this->session->data['user_id'];


		if (!empty($stock_adjustment_id)) {
			$sql = "
                UPDATE " . DB_PREFIX . "stock_adjustment
                    SET
                        description = '" . $this->db->escape($data['description'])  . "',
                        modify_by = " . $user_id . ",
                        date_modified = NOW()
                        WHERE stock_adjustment_id = '" . (int)$stock_adjustment_id . "'           
            ";
			$this->db->query($sql);
		}
	}
	public function addStockAdjustmentProduct($data)
	{
		$stock_adjustment_id = !empty($data['stock_adjustment_id']) ? $data['stock_adjustment_id'] : 0;
		$stock_adjustment_item_id = 0;
		if (!empty($stock_adjustment_id)) {
			$this->load->model('catalog/product');
			$this->load->library('weight');
			$this->weight = new Weight($this->registry);

			$product_id = !empty($data['product_id']) ? $data['product_id'] : 0;
			$store_id = (int)$this->session->data['store_id'];
			$user_id = (int)$this->session->data['user_id'];

			if (!empty($product_id)) {

				$qty = !empty($data['qty']) ? $data['qty'] : 1;
				$location_id = !empty($data['location']) ? $data['location'] : 0;
				if ($location_id) {
					$location = $this->getLocationText($data['location']);
				} else {
					$location = '';
				}

				$remark = $data['remark'];
				$weight_class_id = $data['weight_class_id'];
				$action = $data['action'];

				$batch_date = !empty($data['batch_date']) ? $data['batch_date'] : NULL;
				$product_info = $this->model_catalog_product->getProduct($product_id);
				$product_wcid = $this->getweightClassProduct($product_id);
				$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;

				$total_product_weight = $qty * $product_weight;
				$weight_quantity = $this->weight->convert($total_product_weight, $weight_class_id, $product_wcid);

				if (!empty($batch_date)) {
					$batch_date = $batch_date;
					$batch = $batch_date;
				} else {
					$batch_date = NULL;
					$batch = '0000-00-00';
				}

				$stock_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);
				$item_sql = "
				INSERT INTO " . DB_PREFIX . "stock_adjustment_item SET

				stock_adjustment_id = " . (int)$stock_adjustment_id . ",
				product_id = " . (int)$product_id . ",
				action = " . (int)$action . ",
				qty = " . (float)$qty . ",
				weight_class_id = " . (int)$weight_class_id . ",
				remark = '" . $this->db->escape($remark) . "',
				batch_date = " . $this->db->escape($batch) . ",
				weight_quantity = '" . (float)$weight_quantity . "',
				stock_onhand = '" . (float)$stock_onhand . "',
				location_id = '" . (int)$location_id . "',
				location = '" . $this->db->escape($location) . "',
				add_by = " . (int)$user_id . ",
				date_added = NOW()

				";

				$this->db->query($item_sql);
				$stock_adjustment_item_id =  $this->db->getLastId();
			}
		}
		return array(
			'id' => $stock_adjustment_item_id,
			'stock_onhand' => $stock_onhand
		);
	}

	public function editStockAdjustmentProduct($data)
	{
		$stock_adjustment_item_id = !empty($data['stock_adjustment_item_id']) ? $data['stock_adjustment_item_id'] : 0;

		if (!empty($stock_adjustment_item_id)) {
			$this->load->model('catalog/product');
			$this->load->library('weight');
			$this->weight = new Weight($this->registry);

			$product_id = !empty($data['product_id']) ? $data['product_id'] : 0;
			$store_id = (int)$this->session->data['store_id'];
			$user_id = (int)$this->session->data['user_id'];

			if (!empty($product_id)) {
				$qty = !empty($data['qty']) ? $data['qty'] : 1;
				$location_id = !empty($data['location']) ? $data['location'] : 0;
				if ($location_id) {
					$location = $this->getLocationText($data['location']);
				} else {
					$location = '';
				}

				$remark = $data['remark'];
				$weight_class_id = $data['weight_class_id'];
				$action = $data['action'];
				$batch_date = !empty($data['batch_date']) ? $data['batch_date'] : NULL;

				$product_info = $this->model_catalog_product->getProduct($product_id);
				$product_wcid = $this->getweightClassProduct($product_id);
				$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;

				$total_product_weight = $qty * $product_weight;
				$weight_quantity = $this->weight->convert($total_product_weight, $weight_class_id, $product_wcid);

				if (!empty($batch_date)) {
					$batch_date = $batch_date;
					$batch = $batch_date;
				} else {
					$batch_date = NULL;
					$batch = '0000-00-00';
				}

				$stock_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);

				$item_sql = "UPDATE " . DB_PREFIX . "stock_adjustment_item 
					SET product_id = " . (int)$product_id . ",
						qty = " . (float)$qty . ",
						weight_class_id = " . (int)$weight_class_id . ",
						batch_date = " . $this->db->escape($batch) . ",
						weight_quantity = '" . (float)$weight_quantity . "',
						stock_onhand = '" . (float)$stock_onhand . "',
						location_id = '" . (int)$location_id . "',
						location = '" . $this->db->escape($location) . "',
						remark = '" . $this->db->escape($remark) . "',
						modify_by = " . (int)$user_id . ",
						action = '" . (int)$action . "',
						date_modified = NOW()
						WHERE
						stock_adjustment_item_id = '" . (int)$stock_adjustment_item_id . "'
				";

				$this->db->query($item_sql);
				$stock_adjustment_item_id =  $this->db->getLastId();
			}
		}
		return array(
			'id' => $stock_adjustment_item_id,
			'stock_onhand' => $stock_onhand
		);
	}

	public function deleteStockAdjustmentProduct($stock_adjustment_item_id)
	{
		$sql_delete = "DELETE FROM " . DB_PREFIX . "stock_adjustment_item WHERE stock_adjustment_item_id='" . (int)$stock_adjustment_item_id . "'";
		$this->db->query($sql_delete);
	}

	public function getweightClassProduct($product_id)
	{
		$sql = "SELECT weight_class_id FROM " . DB_PREFIX . "product WHERE product_id='" . (int)$product_id . "'";
		$query = $this->db->query($sql);

		$weight_class_id = isset($query->row['weight_class_id']) ? $query->row['weight_class_id'] : 2;
		return $weight_class_id;
	}

	public function getAllStockAdjustmentBatchDates()

	{

		$query = $this->db->query("SELECT DISTINCT(batch_date) FROM " . DB_PREFIX . "stock_adjustment_item WHERE 1 ");



		return $query->rows;
	}

	//put here
	public function getStaffs()
	{
		$query = $this->db->query("SELECT DISTINCT(st.added_by), CONCAT(u.firstname,' ',u.lastname) AS staff_name FROM " . DB_PREFIX . "stock_take st
		LEFT JOIN " . DB_PREFIX . "user u on (st.added_by = u.user_id)
		ORDER BY staff_name asc");

		return $query->rows;
	}

	public function getStatus()
	{
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "order_status WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND order_status_id IN (SELECT DISTINCT (status) from " . DB_PREFIX . "stock_adjustment) ORDER BY order_status_id asc");

		return $query->rows;
	}

	public function getCategories()
	{
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "category_description WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND category_id ORDER BY category_id asc");

		return $query->rows;
	}


	public function getlocationfulllist($stock_adjustment_id){
		$sql = "
	
		SELECT sai.location_id FROM " . DB_PREFIX . "stock_adjustment_item sai WHERE sai.stock_adjustment_id = $stock_adjustment_id
	";

	$query = $this->db->query($sql);

		return $query->rows;
	}

	
	
}
